      SUBROUTINE HAZEL (CURSOR, LCURSOR)
C
C     CURSOR CONTROL CHARACTERS FOR A HAZELTINE 1500 TERMINAL.
C
      INTEGER*4 CURSOR(10,22), LCURSOR(22), CDATA(22), LCDATA(22),
     1 BUFFER4
C
      LOGICAL CURRADDR
C
      DATA CDATA/
     1 Z'1B120000',Z'1B0C0000',Z'1B0B0000',Z'08000000',Z'10000000',
     2 Z'1B110000',Z'1B050000',Z'1B1C0000',Z'1B1D0000',Z'1B0F0000',
     3 Z'1B180000',Z'1B170000',Z'1B190000',Z'1B1F0000',Z'1B130000',
     4 Z'1B1A0000',Z'1B150000',Z'1B060000',Z'07000000',Z'09000000',
     5 Z'0D000000',Z'0A000000'/
      DATA LCDATA/2,2,2,1,1, 2,2,2,2,2, 2,2,2,2,2, 2,2,2,1,1, 1,1/
C
C     COMMAND      LEAD IN   KEY                ASCII   DECIMAL
C     -------      -------   ---                -----   -------
C
C     HOME           YES     CONTROL-R           DC2       18
C     UP             YES     SHIFT-LINE FEED     FF        12
C     DOWN           YES     CONTROL-K           VT        11
C     LEFT           NO      BACK SPACE          BS        8
C     RIGHT          NO      SHIFT-BACK SPACE    DLE       16
C     ADDRESS        YES     CONTROL-Q           DC1       17
C     READ ADDRESS   YES     CONTROL-E           ENQ       5
C     CLEAR SCREEN   YES     CONTROL-SHIFT-L     FS        28
C     CLEAR FOREGR   YES     CONTROL-SHIFT-M     GS        29
C     CLEAR TO EOL   YES     CONTROL-O           SI        15
C     CLEAR TO EOS   YES     CONTROL-X           CAN       24
C     CLEAR BACKSP   YES     CONTROL-W           ETB       23
C     BCKGRND FLWS   YES     CONTROL-Y           EM        25
C     FREGRND FLWS   YES     CONTROL-SHIFT-O     US        31
C     DELETE LINE    YES     CONTROL-S           DC3       19
C     INSERT LINE    YES     CONTROL-Z           SUB       26
C     KEYB LOCK      YES     CONTROL-U           NAK       21
C     KEYB UNLOCK    YES     CONTROL-F           ACK       6
C     BELL           NO      CONTROL-G           BEL       7
C     TAB            NO      TAB (CONTROL-I)     HT        9
C     CARRIAGE RET   NO      CR                  CR        14
C     LINE FEED      NO      LF                  LF        10
C
      DO 10 I=1,22
      CURSOR(1,I) = CDATA(I)
      LCURSOR(I) = LCDATA(I)
      DO 10 J=2,10
   10 CURSOR(J,I) = 0
      RETURN
C
C     ENTRY HAZCONV
C
C     PERFORM BUFFER CONVERSION FOR HAZELTINE TERMINAL.
C     CURSOR ADDRESSING STRINGS MUST BE OUTPUT IN ONE STATEMENT
C     TO AVOID PROBLEMS WITH INTERVENING NULL CHARACTERS IN
C     TELNET/RLOGIN SESSIONS.
C
C     CURSOR   - INPUT BUFFER (1 INTEGER*4 WORD).
C     ICOUNT   - NUMBER OF CHARACTERS DEFINED IN BUFFER.
C                HAZCONV ONLY INSPECTS (OR MODIFIES) 2 CHARACTER
C                COMMANDS.
C     CURRADDR - LOGICAL FLAG WHICH KEEPS TRACK OF WHETHER THE LAST
C                CURSOR COMMAND WAS CURSOR ADDRESSING - THIS VARIABLE
C                MUST BE SET FALSE BY THE CALLING PROGRAM BEFORE THE
C                FIRST CALL TO HAZCONV. THE CALLING PROGRAM MAY CHANGE
C                THIS VARIABLE TO INDICATE THAT THE LAST COMMAND
C                WAS NOT CURSOR ADDRESSING (SET TO .FALSE.), OR VICE
C                VERSA (SET .TRUE. TO INDICATE LAST COMMAND WAS
C                CURSOR ADDRESSING). THIS ROUTINE WILL ALSO SET/RESET
C                THE FLAG APPROPRIATELY.
C
C     CURSOR ADDRESSING IS HANDLED BY SETTING THE TRANSFER COUNT FOR
C     THE OUTPUT OF THE 'ESC' '...' PART OF THE ADDRESS COMMAND STRING
C     TO 0, AND PREFIXING THE 'ESC' '...' ONTO THE ACTUAL CURSOR
C     ADDRESSES WHEN THEY ARE WRITTEN OUT - THIS AVOIDS EXTRANEOUS
C     'NUL' CHARACTERS BEING SENT IN THE MIDDLE OF THE ADDRESS STRING.
C
      ENTRY HAZCONV (CURSOR, ICOUNT, CURRADDR)
C
      IF (ICOUNT .NE. 2) GO TO 100
      BUFFER4 = CURSOR(1,1)
      IF (CURRADDR) GO TO 300
      IF (BUFFER4 .EQ. CDATA(6)) THEN
         CURRADDR = .TRUE.
         ICOUNT = 0
         RETURN
      END IF
  100 CURRADDR = .FALSE.
      RETURN
C
C     HANDLE SCREEN ADDRESSING BY EXPANDING THE BUFFER.
C
C     BYTE    INPUT BUFFER CONTAINS        OUTPUT BUFFER CONTAINS
C       1           X COORD                       ESCAPE
C       2           Y COORD                     <WHATEVER>
C       3           -------                       X COORD
C       4           -------                       Y COORD
C
  300 CURRADDR = .FALSE.
      ICOUNT = 4
      IX = IGETBUFFER1 (1, BUFFER4)
      IY = IGETBUFFER1 (2, BUFFER4)
      BUFFER4 = CDATA(6)
      CALL ISETBUFFER1(3, IX, BUFFER4)
      CALL ISETBUFFER1(4, IY, BUFFER4)
      CURSOR(1,1) = BUFFER4
      RETURN
      END
