/* weapon.h 15.1 06/08/90 10:08:10 */


/* Original code by Daryl Poe.
 *
 * Copyright (c) 1989 Daryl Poe
 *
 * Ported to X11 by Jim Andreas.
 * Tractors, treaties, and other features by Norm Gee.
 * Damage window and shield bitmaps by Tom LaStrange.
 *
 * The above comments apply to this version as well, and this
 * notice must also appear in any copies or follow-ons.
 */

/* Weapon numbers */
#define WPN_PHOTON			0
#define WPN_MISSILE			1
#define WPN_PLASMA			2
#define WPN_CHAFF			3
#define WPN_MINE			4
#define WPN_PHASER			5
#define WPN_DISRUPTER		6
#define WPN_TACHYON			7
#define WPN_FUSION			8
#define WPN_PLANET			9
#define WPN_DESTRUCT		10
#define WPN_PROB_VORTEX		11
#define WPN_PROB_VORTEX_NS	12
#define WPN_SPHERE_BACKLASH	13

#define ST_CLOAK			0
#define ST_IMP_SENS			1
#define ST_ECM				2
#define ST_HYPERSPACE		3
#define ST_SPHERE			4
#define ST_AFC				5
#define ST_DAMAGE_ABS		6


/* Special technology masks */
#define STMASK_CLOAK		(1<<ST_CLOAK)
#define STMASK_IMP_SENS		(1<<ST_IMP_SENS)
#define STMASK_ECM			(1<<ST_ECM)
#define STMASK_HYPERSPACE	(1<<ST_HYPERSPACE)
#define STMASK_SPHERE		(1<<ST_SPHERE)
#define STMASK_AFC			(1<<ST_AFC)
#define STMASK_DAMAGE_ABS	(1<<ST_DAMAGE_ABS)

/* === If you change these, you may invalidate the shiparchives === */
#define WPN_PHOTON_MIN_SPEED		10
#define WPN_PHOTON_DEF_SPEED		12
#define WPN_PHOTON_MAX_SPEED		16
#define WPN_PHOTON_MIN_DAMAGE		24
#define WPN_PHOTON_DEF_DAMAGE		30
#define WPN_PHOTON_MAX_DAMAGE		42
#define WPN_PHOTON_MIN_DURATION		2
#define WPN_PHOTON_DEF_DURATION		3
#define WPN_PHOTON_MAX_DURATION		5
#define WPN_PHOTON_MIN_RELOAD		2
#define WPN_PHOTON_DEF_RELOAD		3
#define WPN_PHOTON_MAX_RELOAD		4

#define WPN_MISSILE_MIN_SPEED		6
#define WPN_MISSILE_DEF_SPEED		7
#define WPN_MISSILE_MAX_SPEED		10
#define WPN_MISSILE_MIN_DAMAGE		12
#define WPN_MISSILE_DEF_DAMAGE		15
#define WPN_MISSILE_MAX_DAMAGE		24
#define WPN_MISSILE_MIN_DURATION	5
#define WPN_MISSILE_DEF_DURATION	7
#define WPN_MISSILE_MAX_DURATION	9
#define WPN_MISSILE_MIN_RELOAD		3
#define WPN_MISSILE_DEF_RELOAD		4
#define WPN_MISSILE_MAX_RELOAD		5

#define WPN_PLASMA_MIN_SPEED		6
#define WPN_PLASMA_DEF_SPEED		7
#define WPN_PLASMA_MAX_SPEED		10
#define WPN_PLASMA_MIN_DAMAGE		80
#define WPN_PLASMA_DEF_DAMAGE		90
#define WPN_PLASMA_MAX_DAMAGE		120
#define WPN_PLASMA_DURATION			10
#define WPN_PLASMA_ATTEN			3/4
#define WPN_PLASMA_MIN_RELOAD		6
#define WPN_PLASMA_DEF_RELOAD		7
#define WPN_PLASMA_MAX_RELOAD		8

#define WPN_CHAFF_MIN_DAMAGE		13
#define WPN_CHAFF_DEF_DAMAGE		15
#define WPN_CHAFF_MAX_DAMAGE		19
#define WPN_CHAFF_MIN_DURATION		5
#define WPN_CHAFF_DEF_DURATION		7
#define WPN_CHAFF_MAX_DURATION		13
#define WPN_CHAFF_MIN_RELOAD		5
#define WPN_CHAFF_DEF_RELOAD		7
#define WPN_CHAFF_MAX_RELOAD		8
#define WPN_CHAFF_ARM				0

#define WPN_MINE_MIN_DAMAGE			20
#define WPN_MINE_DEF_DAMAGE			25
#define WPN_MINE_MAX_DAMAGE			35
#define WPN_MINE_MIN_DURATION		6
#define WPN_MINE_DEF_DURATION		8
#define WPN_MINE_MAX_DURATION		16
#define WPN_MINE_MIN_RELOAD			6
#define WPN_MINE_DEF_RELOAD			8
#define WPN_MINE_MAX_RELOAD			9
#define WPN_MINE_ARM				(10/TORPFUSE)
#define WPN_MINE_RANGE				(GWIDTH/20)

#define WPN_PHASER_MIN_RANGE		4500
#define WPN_PHASER_DEF_RANGE		6000
#define WPN_PHASER_MAX_RANGE		7500
#define WPN_PHASER_MIN_DAMAGE		20
#define WPN_PHASER_DEF_DAMAGE		25
#define WPN_PHASER_MAX_DAMAGE		30
#define WPN_PHASER_MIN_ACCURACY		2
#define WPN_PHASER_DEF_ACCURACY		3
#define WPN_PHASER_MAX_ACCURACY		5
#define WPN_PHASER_MIN_RELOAD		2
#define WPN_PHASER_DEF_RELOAD		4
#define WPN_PHASER_MAX_RELOAD		5
#define WPN_PHASER_ATTEN			1

#define WPN_DISRUPTER_MIN_RANGE		6000
#define WPN_DISRUPTER_DEF_RANGE		7500
#define WPN_DISRUPTER_MAX_RANGE		10500
#define WPN_DISRUPTER_MIN_DAMAGE	10
#define WPN_DISRUPTER_DEF_DAMAGE	13
#define WPN_DISRUPTER_MAX_DAMAGE	16
#define WPN_DISRUPTER_MIN_ACCURACY	4
#define WPN_DISRUPTER_DEF_ACCURACY	5
#define WPN_DISRUPTER_MAX_ACCURACY	7
#define WPN_DISRUPTER_MIN_RELOAD	2
#define WPN_DISRUPTER_DEF_RELOAD	4
#define WPN_DISRUPTER_MAX_RELOAD	5
#define WPN_DISRUPTER_ATTEN			4/3

#define WPN_TACHYON_MIN_RANGE		2000
#define WPN_TACHYON_DEF_RANGE		3000
#define WPN_TACHYON_MAX_RANGE		5000
#define WPN_TACHYON_MIN_DAMAGE		4
#define WPN_TACHYON_DEF_DAMAGE		5
#define WPN_TACHYON_MAX_DAMAGE		8
#define WPN_TACHYON_MIN_ACCURACY	1
#define WPN_TACHYON_DEF_ACCURACY	2
#define WPN_TACHYON_MAX_ACCURACY	4
#define WPN_TACHYON_MIN_RELOAD		4
#define WPN_TACHYON_DEF_RELOAD		6
#define WPN_TACHYON_MAX_RELOAD		10

#define WPN_FUSION_MIN_RANGE		3000
#define WPN_FUSION_DEF_RANGE		4000
#define WPN_FUSION_MAX_RANGE		6000
#define WPN_FUSION_MIN_DAMAGE		15
#define WPN_FUSION_DEF_DAMAGE		20
#define WPN_FUSION_MAX_DAMAGE		25
#define WPN_FUSION_MIN_ACCURACY		4
#define WPN_FUSION_DEF_ACCURACY		6
#define WPN_FUSION_MAX_ACCURACY		10
#define WPN_FUSION_MIN_RELOAD		2
#define WPN_FUSION_DEF_RELOAD		4
#define WPN_FUSION_MAX_RELOAD		5
#define WPN_FUSION_ATTEN			1

/* fuel costs */
#define STFUEL_CLOAK		20
#define STFUEL_ECM			10
#define STFUEL_HYPERSPACE	1000
#define STFUEL_SPHERE		30

/* misc. */
#define BACKLASH_SPEED		14
/* =============================================================== */

/* tractor stuff */
#define TRACTOR_RANGE		7500
#define TRACTOR_FUEL		8
#define TRACTOR_ACCURACY	20
#define TRACTOR             1
#define REPULSOR            2
#define WINCH               3
#define PUSHER              4
