/* warwin.c 15.1 06/08/90 10:08:08 */

/*

	Copyright (c) 1986 	Chris Guthrie

Permission to use, copy, modify, and distribute this
software and its documentation for any purpose and without
fee is hereby granted, provided that the above copyright
notice appear in all copies and that both that copyright
notice and this permission notice appear in supporting
documentation.  No representations are made about the
suitability of this software for any purpose.  It is
provided "as is" without express or implied warranty.

*/

/* Major overhaul by Daryl Poe.
 *
 * Copyright (c) 1989 Daryl Poe
 *
 * Ported to X11 by Jim Andreas.
 * Tractors, treaties, and other features by Norm Gee.
 * Damage window and shield bitmaps by Tom LaStrange.
 *
 * The above comments apply to this version as well, and this
 * notice must also appear in any copies or follow-ons.
 */

/************************************************************
 *  warwin.c
 ************************************************************/

#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <stdio.h>
#include "defs.h"
#include "weapon.h"
#include "system.h"
#include "ship.h"
#include "stats.h"
#include "player.h"
#include "torp.h"
#include "status.h"
#include "planet.h"
#include "phaser.h"
#include "message.h"
#include "shmem.h"
#include "data.h"
#include "xdata.h"

static int newhostile;
static int treaties;
static int allies;

/* Set up the war window and map it */
static char *feds = "FED - ";
static char *roms = "ROM - ";
static char *klis = "KLI - ";
static char *oris = "ORI - ";
static char *gos = "  Re-program";
static char *exs = "  Exit - no change";
static char *peaces = "Treaty";
static char *hostiles = "Hostile";
static char *allys= "Alliance";
static char *treatystr = "Treaties";
static char *desired = "Desired Status";

static void fillwin(win, string, treaty, ally, teammask)
Window win;
char *string;
int treaty, ally;
int teammask;
{
	XTextItem t;
	XGCValues values;

	char buf[80];


	if (teammask & ally) {
		/* Alliance */
		sprintf(buf, "  %s%s", string, allys);

		values.foreground =  gColor;
		XChangeGC( dpy, gc, GCForeground, &values );
		XClearWindow(dpy,win);

		t.chars = buf;
		t.nchars = strlen(buf);
		t.delta = 0;
		t.font  = dfont;
		XDrawText( dpy, win, gc,  0,
		    dfontinfo->ascent / 2 + dfontinfo->ascent, &t, 1 ); 
	}
	else if (teammask & treaty) {
		/* Treaty */
		sprintf(buf, "  %s%s", string, peaces);
		values.foreground =  yColor;
		XChangeGC( dpy, gc, GCForeground, &values );
		XClearWindow(dpy,win);

		t.chars = buf;
		t.nchars = strlen(buf);
		t.delta = 0;
		t.font  = dfont;
		XDrawText( dpy, win, gc, 0,
		    dfontinfo->ascent / 2 + dfontinfo->ascent, &t, 1 );  
	}
	else   {
		/* Treaty */
		sprintf(buf, "  %s%s", string, hostiles);

		values.foreground =  rColor;
		XChangeGC( dpy, gc, GCForeground, &values );
		XClearWindow(dpy,win);

		t.chars = buf;
		t.nchars = strlen(buf);
		t.delta = 0;
		t.font  = dfont;
		XDrawText( dpy, win, gc,  0,
		    dfontinfo->ascent / 2 + dfontinfo->ascent, &t, 1 );  
	}
}

void warwindow()
{
	XMapWindow( dpy, war);
	newhostile = me->p_hostile_mask;
	treaties = me->p_treaty_mask;
	allies   = me->p_ally_mask;
	warrefresh();
}


void warrefresh()
{
#define WARWIDTH (dfontinfo->max_bounds.rbearing * 20)
	XTextItem t;

	team = sharedMemory->team;
	t.chars = treatystr;
	t.nchars = strlen(treatystr);
	t.delta = 0;
	t.font = dfont;
	XDrawText(dpy,war,gc,0, dfontinfo->ascent / 2 + 20, &t, 1 );

	t.chars = desired;
	t.nchars = strlen(desired);
	t.delta = 0;
	t.font = dfont;
	XDrawText(dpy,war,gc,WARWIDTH, dfontinfo->ascent / 2 + 20, &t, 1 );

	t.chars = gos;
	t.nchars = strlen(gos);
	t.delta = 0;
	t.font  = dfont;
	XDrawText( dpy, wargo, gc, 0, dfontinfo->ascent / 2 + 8, &t,  1 ); 

	t.chars = exs;
	t.nchars = strlen(exs);
	XDrawText( dpy, warno,  gc,  0,
	    dfontinfo->ascent / 2 + dfontinfo->ascent, &t,  1 ); 

	fillwin(warf1, feds, team[me->p_team_no].t_treaty, 
		team[me->p_team_no].t_ally, FED_MASK);
	fillwin(warr1, roms, team[me->p_team_no].t_treaty, 
		team[me->p_team_no].t_ally, ROM_MASK);
	fillwin(wark1, klis, team[me->p_team_no].t_treaty, 
		team[me->p_team_no].t_ally, KLI_MASK);
	fillwin(waro1, oris, team[me->p_team_no].t_treaty, 
		team[me->p_team_no].t_ally, ORI_MASK);

	fillwin(warf, feds, treaties, allies, FED_MASK);
	fillwin(warr, roms, treaties, allies, ROM_MASK);
	fillwin(wark, klis, treaties, allies, KLI_MASK);
	fillwin(waro, oris, treaties, allies, ORI_MASK);

}


waraction(data)
XButtonEvent *data;
{
	int changes;
	int reprogram = 0;

	if ((data->window != warno) && (watch)) {
		warning("can't modify war settings from watch");
		return;
	}
	if (data->window == warf) {
		if (me->p_team_no == FEDERATION) {
			warning("You cannot go to war with your own race.");
			XBell(dpy,100);
		}
		else {
			if( allies & FED_MASK ) {
			  treaties &= ~FED_MASK;
			  allies   &= ~FED_MASK;
			}
			else if ( treaties & FED_MASK ) 
			   allies |= FED_MASK;
			else {
			   treaties |= FED_MASK;
			   allies &= ~FED_MASK;
			}
		}
	}
	if (data->window == warr) {
		if (me->p_team_no == ROMULAN ) {
			warning("You cannot go to war with your own race.");
			XBell(dpy,100);
		}
		else {
			if( allies & ROM_MASK ) {
			  treaties &= ~ROM_MASK;
			  allies   &= ~ROM_MASK;
			}
			else if ( treaties & ROM_MASK ) 
			   allies |= ROM_MASK;
			else {
			   treaties |= ROM_MASK;
			   allies &= ~ROM_MASK;
			}
		}
	}
	if (data->window == wark) {
		if (me->p_team_no == KLINGON) {
			warning("You cannot go to war with your own race.");
			XBell(dpy,100);
		}
		else {
			if( allies & KLI_MASK ) {
			  treaties &= ~KLI_MASK;
			  allies   &= ~KLI_MASK;
			}
			else if ( treaties & KLI_MASK ) 
			   allies |= KLI_MASK;
			else {
			   treaties |= KLI_MASK;
			   allies &= ~KLI_MASK;
			}
		}
	}
	if (data->window == waro) {
		if (me->p_team_no == ORION) {
			warning("You cannot go to war with your own race.");
			XBell(dpy,100);
		}
		else {
			if( allies & ORI_MASK ) {
			  treaties &= ~ORI_MASK;
			  allies   &= ~ORI_MASK;
			}
			else if ( treaties & ORI_MASK ) 
			   allies |= ORI_MASK;
			else {
			   treaties |= ORI_MASK;
			   allies &= ~ORI_MASK;
			}
		}
	}
	warrefresh();

	if (data->window == wargo) {
		changes = (me->p_treaty_mask ^ treaties) | (me->p_ally_mask ^ allies);
		if (changes & FED_MASK) {
			reprogram |=
				send_war_warning("Federation", treaties,allies, FED_MASK);
		}
		if (changes & ROM_MASK) {
			reprogram |= 
				send_war_warning("Romulans", treaties,allies, ROM_MASK);
		}
		if (changes & KLI_MASK) {
			reprogram |= 
				send_war_warning("Klingons", treaties,allies, KLI_MASK);
		}
		if (changes & ORI_MASK) {
			reprogram |= 
				send_war_warning("Orions", treaties,allies, ORI_MASK);
		}

		me->p_treaty_mask = treaties;
		me->p_ally_mask = allies;
		if (reprogram) {
			delay = me->p_updates + /*  100 */ 50;
			me->p_flags |= PFWAR;	/* stop copilots, mostly */
			warning("Pausing to re-program battle computers.");
		}
		check_treaty_status(me->p_team_no);
		update_treaties();
		XUnmapWindow( dpy, war);
		return;
	}

	if (data->window == warno) {
		XUnmapWindow( dpy, war);
		return;
	}
}

