/* warning.c 15.1 06/08/90 10:08:05 */

/*

	Copyright (c) 1986 	Chris Guthrie

Permission to use, copy, modify, and distribute this
software and its documentation for any purpose and without
fee is hereby granted, provided that the above copyright
notice appear in all copies and that both that copyright
notice and this permission notice appear in supporting
documentation.  No representations are made about the
suitability of this software for any purpose.  It is
provided "as is" without express or implied warranty.

*/

/* Major overhaul by Daryl Poe.
 *
 * Copyright (c) 1989 Daryl Poe
 *
 * Ported to X11 by Jim Andreas.
 * Tractors, treaties, and other features by Norm Gee.
 * Damage window and shield bitmaps by Tom LaStrange.
 *
 * The above comments apply to this version as well, and this
 * notice must also appear in any copies or follow-ons.
 */


#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <stdio.h>
#include "defs.h"
#include "weapon.h"
#include "system.h"
#include "ship.h"
#include "stats.h"
#include "player.h"
#include "torp.h"
#include "status.h"
#include "planet.h"
#include "phaser.h"
#include "message.h"
#include "shmem.h"
#include "data.h"
#include "xdata.h"

/*
** The warning in text will be printed in the warning window.
** The message will last WARNTIME/10 seconds unless another message
** comes through and overwrites it.
*/
void warning(text)
char *text;
{
	XTextItem t;
	XGCValues values;

	values.foreground =  backColor;
	values.function   =  GXcopy;
	XChangeGC( dpy, gc, GCForeground | GCFunction, &values );

	warntimer = udcounter + WARNTIME;  /* set the line to be cleared */
	if (warncount > 0)

		XFillRectangle( dpy, warnw,  gc, 5, 5,
			dfontinfo->max_bounds.rbearing * warncount,
		    dfontinfo->descent + dfontinfo->ascent );
	values.foreground =  textColor;
	XChangeGC( dpy, gc, GCForeground, &values );
	warncount = strlen(text);
	t.chars = text;
	t.nchars = warncount;
	t.delta = 0;
	t.font  = dfont;
	XDrawText( dpy, warnw, gc,   5, 5 + dfontinfo->ascent, &t, 1 );  
	XFlush( dpy );
}
