/* war.c 15.1 06/08/90 10:08:01 */

/*

	Copyright (c) 1986 	Chris Guthrie

Permission to use, copy, modify, and distribute this
software and its documentation for any purpose and without
fee is hereby granted, provided that the above copyright
notice appear in all copies and that both that copyright
notice and this permission notice appear in supporting
documentation.  No representations are made about the
suitability of this software for any purpose.  It is
provided "as is" without express or implied warranty.

*/

/* Major overhaul by Daryl Poe.
 *
 * Copyright (c) 1989 Daryl Poe
 *
 * Ported to X11 by Jim Andreas.
 * Tractors, treaties, and other features by Norm Gee.
 * Damage window and shield bitmaps by Tom LaStrange.
 *
 * The above comments apply to this version as well, and this
 * notice must also appear in any copies or follow-ons.
 */

#include <stdio.h>
#include "defs.h"
#include "weapon.h"
#include "system.h"
#include "ship.h"
#include "stats.h"
#include "player.h"
#include "torp.h"
#include "status.h"
#include "planet.h"
#include "phaser.h"
#include "message.h"
#include "shmem.h"
#include "data.h"

#define SET_WAR       0
#define SET_TREATY    1
#define SET_ALLIANCE  2


/* return value:  reprogram */
int send_war_warning(string, treaties,allies, team_mask)
char *string;
int treaties,allies;
int team_mask;
{
	char buf[BUFSIZ];
	char addrbuf[10];
	int returnval=0;

	if (allies & team_mask ) {
		sprintf(buf, "%s (%s) would like to make an alliance with the %s",
		    me->p_name,
			me->p_mapchars,
		    string);
	}
	else if(treaties & team_mask ) {
		sprintf(buf, "%s (%s) would like to make a treaty with the %s",
		    me->p_name,
			me->p_mapchars,
		    string);
	}
	else  {
		sprintf(buf, "%s (%s) would like to declare war on the %s",
		    me->p_name,
			me->p_mapchars,
		    string);
		returnval = 1;
	}

	sprintf(addrbuf, " %s->%-3s",
		me->p_mapchars,
	    teamshort[log_two[team_mask]]);
	pmessage(buf, team_mask, MTEAM, addrbuf);
	return(returnval);
}


static void treaty_inform(team1,team2,mystatus,team_mask)
char *team1,*team2;
int mystatus,team_mask;
{
	char buf[BUFSIZ];
	char addrbuf[10];

	if (mystatus == SET_ALLIANCE) {  /* the teams want to be nice */
		sprintf(buf,"The %s and %s Empires have an ALLIANCE ",
			team1,team2);
	}
	else if ( mystatus == SET_TREATY) {
		sprintf(buf,"The %s and %s Empires have a TREATY",team1,team2);
	}
	else {
		sprintf(buf,"The %s and %s Empires are at WAR",team1,team2);
	}

	sprintf(addrbuf, " %s->%-3s",
		me->p_mapchars,
	    teamshort[log_two[team_mask]]);
	pmessage(buf, team_mask, MTEAM, addrbuf);
}

static char team_names[5][20] = {
	"Independent",
	"Federation",
	"Romulan",
	"Klingon",
	"Orion"
};


void check_treaty_status(team_no)
int team_no;
{
	int race,usmask,racemask;
	int us_ally, us_treaty, us_mean, us_robot_mean;
	int them_ally, them_treaty, them_mean, them_robot_mean;
	PLAYER *p;
#ifdef DEBUG
	int us_robot_nice,them_robot_nice; /* only needed for debugging */
#endif

	usmask = 1 << team_no;

	for (race=FEDERATION, racemask = FED_MASK;
			race<=ORION;
			++race, racemask <<= 1) {

		if (race == team_no ) continue;

		us_treaty =   
			them_treaty = 
			us_ally = 
			them_ally =
			us_mean = 
			them_mean =
			us_robot_mean = 
			them_robot_mean = 
#ifdef DEBUG
			us_robot_nice =
			them_robot_nice =
#endif
			0;

		/* We need to check for both treaties *and* alliances here.  Note 
		   that if the ally bit is set, the treaty bit will be set as well. */

		for (p=players; p<players+MAXPLAYER; p++) {
			if (p->p_status != PALIVE) continue;
			if (p->p_team_no == team_no) {
				/* on my team */
				if (p->p_flags & PFROBOT) {
					if (!(p->p_treaty_mask & racemask)) ++us_robot_mean;
#ifdef DEBUG
					else ++us_robot_nice;
#endif
				}
				else {
					if (!(p->p_treaty_mask & racemask)) {
						/*  player wants to be mean to this team */
						++us_mean;
			  		}
			  		else {
						/* treaty ok by this player */
						++us_treaty;
						if (p->p_ally_mask & racemask) ++us_ally;
			  		}
				}
			}
		  	else if (p->p_team_no == race) {
				/* on their team */
				if (p->p_flags & PFROBOT) {
					if ((p->p_treaty_mask & usmask) == 0)
						++them_robot_mean;
#ifdef DEBUG
					else ++them_robot_nice;
#endif
				}
			  	else {
					if ((p->p_treaty_mask & usmask) == 0) {
						/* they want to be mean to us! */
						++them_mean;
			  		}
			  		else {
						++them_treaty;  
						if (p->p_ally_mask & usmask) ++them_ally;
					}
			  	}
			}
		}

		logmsg4("war: team %d: us_ally %d, us_treaty %d, ",
			team_no,us_ally,us_treaty);
		logmsg4("us_mean %d, us_robot_mean %d, us_robot_nice %d\n",
			us_mean,us_robot_mean,us_robot_nice);
		logmsg4("war: race %d: them_ally %d, them_treaty %d, ",
			race,them_ally,them_treaty);
		logmsg4("them_mean %d, them_robot_mean %d, them_robot_nice %d\n",
			them_mean,them_robot_mean,them_robot_nice);

		if ((us_ally == 0)
				&& (us_treaty == 0)
				&& (us_mean == 0)) {
			if ((them_ally == 0)
					&& (them_treaty == 0)
					&& (them_mean == 0)) {
				/* no one home on either team */
				continue;
			}
			if (us_robot_mean > 0) {
				/* let the robots decide */
				/* us_ally = us_treaty = 0; */
				us_mean = 1;
				logmsg1("  mean us robots\n");
			}
			else {
				/* nobody home or all friendly robots */
				us_ally = us_treaty = 1;
				/* us_mean = 0; */
				logmsg1("  nice us robots\n");
			}
		}

		if ((them_ally == 0)
				&& (them_treaty == 0)
				&& (them_mean == 0)) {
			if (them_robot_mean > 0) {
				/* let the robots decide */
				/* them_ally = them_treaty = 0; */
				them_mean = 1;
				logmsg1("  mean them robots\n");
			}
			else {
				/* nobody home or all friendly robots */
				them_ally = them_treaty = 1;
				/* them_mean = 0; */
				logmsg1("  nice them robots\n");
			}
		}

		/* Takes a unanimous vote on each side to form an alliance */
		if ((us_ally == us_treaty+us_mean)
				&& (them_ally == them_treaty+them_mean)) {
			if (!(team[team_no].t_ally & racemask)) {
				/*** FORM AN ALLIANCE ***/
				logmsg3("  forming alliance between %d and %d\n",
					team_no,race);
				team[team_no].t_ally |= racemask;
				team[race   ].t_ally |= usmask;
				treaty_inform(team_names[team_no],team_names[race],
					SET_ALLIANCE,usmask|racemask);
			}
		}
		else if ((us_treaty > us_mean)
				&& (them_treaty > them_mean)) {
		  	if (!(team[team_no].t_treaty & racemask)) {
				/*** FORM A TREATY ***/
				logmsg3("  forming treaty between %d and %d\n",
					team_no,race);
				team[team_no].t_treaty |= racemask;
				team[race   ].t_treaty |= usmask;
				treaty_inform(team_names[team_no],team_names[race],
					SET_TREATY,usmask|racemask);
			}
		}
		else if ((team[team_no].t_ally & racemask)
				&& ((us_ally*2 < (us_treaty + us_mean))
					|| (them_ally*2 < (them_treaty + them_mean)))) {
			/*** BREAK AN ALLIANCE ***/
			logmsg3("  breaking alliance between %d and %d\n",
				team_no,race);
			team[team_no].t_ally &= ~racemask;
			team[race   ].t_ally &= ~usmask;
			if ((us_treaty > us_mean)
					&& (them_treaty > them_mean)) {
				/*** DOWNGRADE TO TREATY ***/
				logmsg1("   downgrade to treaty.\n");
				team[team_no].t_treaty |= racemask;
				team[race   ].t_treaty |= usmask;
				treaty_inform(team_names[team_no],team_names[race],
					SET_TREATY,usmask|racemask);
			}
			else {
				/*** WAR BREAKS OUT ***/
				logmsg1("   downgrade to war.\n");
				team[team_no].t_treaty &= ~racemask;
				team[race   ].t_treaty &= ~usmask;
				treaty_inform(team_names[team_no],team_names[race],
					SET_WAR,usmask|racemask);
			}
		}
		else if (!(team[team_no].t_ally & racemask)
				&& (team[team_no].t_treaty & racemask)
				&& ((us_treaty < us_mean)
					|| (them_treaty < them_mean))) {
			logmsg3("  breaking treaty between %d and %d\n",
				team_no,race);
			/*** BREAK A TREATY ***/
			team[team_no].t_treaty &= ~racemask;
			team[race   ].t_treaty &= ~usmask;
			treaty_inform(team_names[team_no],team_names[race],
				SET_WAR,usmask|racemask);
		}
	}
}


void update_treaties()
{

	PLAYER *p;

	for (p=players; p<players + MAXPLAYER; p++) {
		if ((p->p_status == PALIVE)
				|| (p->p_status == PIMMUNE)) {
			p->p_hostile_mask =
				ALL_MASK & ~( (team[p->p_team_no].t_treaty) | 
							  (team[p->p_team_no].t_ally ) );
		}
	}
}
