/* util.c 15.1 06/08/90 10:07:54 */

/*

	Copyright (c) 1986 	Chris Guthrie

Permission to use, copy, modify, and distribute this
software and its documentation for any purpose and without
fee is hereby granted, provided that the above copyright
notice appear in all copies and that both that copyright
notice and this permission notice appear in supporting
documentation.  No representations are made about the
suitability of this software for any purpose.  It is
provided "as is" without express or implied warranty.

*/

/* Major overhaul by Daryl Poe.
 *
 * Copyright (c) 1989 Daryl Poe
 *
 * Ported to X11 by Jim Andreas.
 * Tractors, treaties, and other features by Norm Gee.
 * Damage window and shield bitmaps by Tom LaStrange.
 *
 * The above comments apply to this version as well, and this
 * notice must also appear in any copies or follow-ons.
 */

#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <stdio.h>
#include "defs.h"
#include "weapon.h"
#include "system.h"
#include "ship.h"
#include "stats.h"
#include "player.h"
#include "torp.h"
#include "status.h"
#include "planet.h"
#include "phaser.h"
#include "message.h"
#include "shmem.h"
#include "data.h"
#include "xdata.h"

void getxy(ww,x,y,gx,gy)
Window ww;
int x,y;
int *gx,*gy;
{
	if ((ww == galaxy_win) || ((ww == mapw) && watch)) {
		*gx = x * GWIDTH / WINSIDE;
		*gy = y * GWIDTH / WINSIDE;
	}
	else if (ww == mapw) {
		*gx = me->map_offsetx + x * MAPWIDTH / WINSIDE;
		*gy = me->map_offsety + y * MAPWIDTH / WINSIDE;
	}
	else {
		*gx = me->p_x + ((x - WINSIDE/2) * SCALE);
		*gy = me->p_y + ((y - WINSIDE/2) * SCALE);
	}
}

/*
** Find the object nearest mouse.  Returns a pointer to an
** obtype structure.  This is used for info and locking on.
**
** Because we are never interested in it, this function will
** never return your own ship as the target.
**
** Finally, this only works on the two main windows
*/

void gettarget(ww, x, y, targtype, target)
Window ww;
int x, y;
int targtype;
OBTYPE *target;
{
	int	i, g_x, g_y, dist, closedist;

	getxy(ww,x,y,&g_x,&g_y);

	if (targtype & TARG_PLANET) {
		target->o_num  =
			closest_planet_dist(g_x,g_y,&closedist,targtype,0);
		target->o_type = PLANETTYPE;
	}
	else closedist = (GWIDTH*2);

	if (targtype & TARG_PLAYER) {
		i = closest_player_dist(g_x,g_y,&dist,targtype,0);
		if (dist < closedist) {
			target->o_type = PLAYERTYPE;
			target->o_num = i;
			closedist = dist;
		}
	}

	if (closedist >= (GWIDTH*2)) {
		/* Didn't get one.  bad news */
		/* Return myself.  Oh well... */
		target->o_type = PLAYERTYPE;
		target->o_num = me->p_no;
	}
}


/*
** Tell us if a window is currently visible on the screen
*/
int ismapped(win)
Window win;
{
	XWindowAttributes attr;

	XGetWindowAttributes( dpy, win, &attr );
	return( attr.map_state == IsViewable );
}


