/* torp.c 15.1 06/08/90 10:07:49 */

/*

	Copyright (c) 1986 	Chris Guthrie

Permission to use, copy, modify, and distribute this
software and its documentation for any purpose and without
fee is hereby granted, provided that the above copyright
notice appear in all copies and that both that copyright
notice and this permission notice appear in supporting
documentation.  No representations are made about the
suitability of this software for any purpose.  It is
provided "as is" without express or implied warranty.

*/

/* Major overhaul by Daryl Poe.
 *
 * Copyright (c) 1989 Daryl Poe
 *
 * Ported to X11 by Jim Andreas.
 * Tractors, treaties, and other features by Norm Gee.
 * Damage window and shield bitmaps by Tom LaStrange.
 *
 * The above comments apply to this version as well, and this
 * notice must also appear in any copies or follow-ons.
 */

#include <stdio.h>
#include "defs.h"
#include "daemon.h"
#include "weapon.h"
#include "ship.h"
#include "stats.h"
#include "player.h"
#include "torp.h"
#include "status.h"
#include "planet.h"
#include "phaser.h"
#include "message.h"
#include "shmem.h"
#include "data.h"
#include "system.h"

/* Launch torp */

int fire_torp(course,aimx,aimy)
COURSE course;
int aimx,aimy;
{
	int i;
	TORP *k;

	logmsg4("torp fired. crs %d, aim %d,%d\n",course,aimx,aimy);

	if (me->p_torps_unloaded == myship->s_torps) {
		warning("Torpedoes still reloading");
		return(0);
	}

	if (me->p_fuel < myship->s_torpcost) {
		warning("Not enough fuel for torp");
		return(0);
	}

	if (me->p_flags & PFREPAIR) {
		warning("Cannot fire while repairing");
		return(0);
	}

	if (me->p_flags & PFCLOAK) {
		warning("Cannot fire while cloaked");
		return(0);
	}

	if (me->p_flags & PFSPHERE) {
		warning("Cannot fire while in sphere");
		return(0);
	}

	if ((planets[me->p_closest_planet].pl_flags & PLMASK_AST_FIELD)
			&& (me->p_closest_planet_dist < AST_FIELD_RADIUS)) {
		warning("Cannot fire from inside asteroid field");
		return(0);
	}

	me->p_ntorp++;
	me->p_fuel -= myship->s_torpcost;
	++me->p_torps_unloaded;
	/* if not already reloading, begin to do so */
	if (me->p_subreload == 0)
		me->p_subreload = myship->s_torpreload;


	for (i = me->p_no * MAXTORP, k = &torps[i];	/* Find a free torp */
	i < me->p_no * MAXTORP + MAXTORP; i++, k++) {
		if (k->t_status == TFREE)
			break;
	}

	/* Setup data in new torp */
	switch (myship->s_torpclass) {
		case WPN_PHOTON:
			k->t_status = TMOVE;
			k->t_dir    = course;
			k->t_speed  = myship->s_torpspeed;
			k->t_arm    = 0;
			k->t_x      = me->p_x;
			k->t_y      = me->p_y;
			k->t_fuse   = INTRAND(30) + myship->s_torpduration;
			break;
		case WPN_MISSILE:
			if (me->p_flags & PFWLOCK) k->t_status = TTRACK;
			else k->t_status = TMOVE;
			k->t_dir    = course;
			k->t_speed  = myship->s_torpspeed;
			k->t_arm    = 0;
			k->t_x      = me->p_x;
			k->t_y      = me->p_y;
			k->t_fuse   = INTRAND(30) + myship->s_torpduration;
			break;
		case WPN_PLASMA:
			if (me->p_flags & PFWLOCK) k->t_status = TTRACK;
			else k->t_status = TMOVE;
			k->t_dir    = course;
			k->t_speed  = myship->s_torpspeed;
			k->t_arm    = 0;
			k->t_x      = me->p_x;
			k->t_y      = me->p_y;
			k->t_fuse   = myship->s_torpduration;
			break;
		case WPN_CHAFF:
			k->t_status = TSTRAIGHT;
			k->t_dir    = me->p_dir;
			k->t_speed  = me->p_speed;
			k->t_arm    = WPN_CHAFF_ARM;
			k->t_x      = me->p_x + Cos[me->p_dir] * (EXPDIST*2);
			k->t_y      = me->p_y + Sin[me->p_dir] * (EXPDIST*2);
			k->t_fuse   = INTRAND(30) + myship->s_torpduration
				+ k->t_arm;
			break;
		case WPN_MINE:
			k->t_status = TSTRAIGHT;
			k->t_dir    = course;
			k->t_speed  = 0;
			k->t_arm    = WPN_MINE_ARM;
			k->t_fuse   = INTRAND(30) + myship->s_torpduration
				+ k->t_arm;
			{
				int dist;

				if ((dist = Ihypot(me->p_x-aimx, me->p_y-aimy))
						> WPN_MINE_RANGE) {
					COURSE tcrs;
	
					tcrs = Atan2(aimy - me->p_y, me->p_x - aimx);
					k->t_x = me->p_x + Cos[tcrs] * WPN_MINE_RANGE;
					k->t_y = me->p_y + Sin[tcrs] * WPN_MINE_RANGE;
					logmsg4(" adjusted mine aim: %d,%d; olddist %d\n",k->t_x,k->t_y,dist);
				}
				else {
					k->t_x = aimx;
					k->t_y = aimy;
				}
			}
			break;
		default:
			logmsg2( "torp: Error--cannot deal with torpclass %d.\n",
				myship->s_torpclass);
			return(0);
			break;
	}

	k->t_dx        = Cos[k->t_dir] * k->t_speed * WARP1;
	k->t_dy        = Sin[k->t_dir] * k->t_speed * WARP1;
	k->t_no        = i;
	k->t_owner_no  = me->p_no;
	if (myship->s_torpclass == WPN_PLASMA ) {
		/* adjust torp damage if injured */
	  	int j,total,current;
	  	float percent;

	  	total = current = 0;
	  	for (j=0; j<myship->s_numsys; j++) {
			if (myship->s_system[j].item == TORP_NUM ) {
				/* got us a torp */
		  		total += myship->s_system[j].undamaged_size;
		  		current += myship->s_system[j].current_size;
			}
	  	}
	  	percent = (float)(current +1 ) / (float)(total +1);
	  	k->t_damage = myship->s_torpdamage * percent;
	}
	else
	k->t_damage    = myship->s_torpdamage;
	k->t_war_mask  = me->p_hostile_mask ;
	k->t_team_mask = me->p_team_mask;
	k->t_decay     = myship->s_torpdecay;
	k->t_target    = me->p_wpnlock;
	k->t_class     = myship->s_torpclass;
	k->t_closest_planet = me->p_closest_planet;
	k->t_closest_planet_dist = me->p_closest_planet_dist;
	logmsg5(" fired %s dir %d at %d,%d\n",myship->s_torpname,k->t_dir,k->t_x,k->t_y);
	return(1);
}
