/* stats.c 15.1 06/08/90 10:07:37 */

/*

	Copyright (c) 1986 	Chris Guthrie

Permission to use, copy, modify, and distribute this
software and its documentation for any purpose and without
fee is hereby granted, provided that the above copyright
notice appear in all copies and that both that copyright
notice and this permission notice appear in supporting
documentation.  No representations are made about the
suitability of this software for any purpose.  It is
provided "as is" without express or implied warranty.

*/

/* Major overhaul by Daryl Poe.
 *
 * Copyright (c) 1989 Daryl Poe
 *
 * Ported to X11 by Jim Andreas.
 * Tractors, treaties, and other features by Norm Gee.
 * Damage window and shield bitmaps by Tom LaStrange.
 *
 * The above comments apply to this version as well, and this
 * notice must also appear in any copies or follow-ons.
 */

#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/X10.h>	/* for hashing functions */
#include <stdio.h>
#include "defs.h"
#include "weapon.h"
#include "system.h"
#include "ship.h"
#include "stats.h"
#include "player.h"
#include "torp.h"
#include "status.h"
#include "planet.h"
#include "phaser.h"
#include "message.h"
#include "shmem.h"
#include "data.h"
#include "xdata.h"

#define	MIN(a,b)	(((a) < (b)) ? (a) : (b))
#define	MAX(a,b)	(((a) > (b)) ? (a) : (b))

#define	BX_OFF() \
	((textWidth + 1) * dfontinfo->max_bounds.rbearing + S_IBORDER)
#define	BY_OFF(line) \
	((line) * (dfontinfo->ascent + dfontinfo->descent + S_IBORDER) \
	+ S_IBORDER)
#define	TX_OFF(len) \
	((textWidth - len) * dfontinfo->max_bounds.rbearing + S_IBORDER)
#define	TY_OFF(line) \
	BY_OFF(line)

#define STAT_WIDTH		160
#define STAT_HEIGHT		BY_OFF(NUM_SLIDERS)
#define STAT_BORDER		2
#define S_IBORDER		5
#define STAT_X			422
#define STAT_Y			13

#define SL_WID			\
	(STAT_WIDTH - 2 * S_IBORDER - (textWidth + 1) \
	* dfontinfo->max_bounds.rbearing)
#define SL_HEI			(dfontinfo->ascent + dfontinfo->descent )

#define NUM_ELS(a)		(sizeof (a) / sizeof (*(a)))
#define NUM_SLIDERS		NUM_ELS(sliders)

typedef struct slider {
	char	*label;
	int	min, max;
	int	low_red, high_red;
	int	label_length;
	int	diff,last_value;
} SLIDER;

static SLIDER	sliders[] = {
	{ "Front Shield",	0,	100,	20,		100,	0,0,0 },
	{ "Right Shield",	0,	100,	20,		100,	0,0,0 },
	{ "Left  Shield",	0,	100,	20,		100,	0,0,0 },
	{ "Rear  Shield",	0,	100,	20,		100,	0,0,0 },
	{ "Fuel",			0,	10000,	1000,	10000,	0,0,0 },
	{ "Warp",			0,	9,		0,		9,		0,0,0 },
	{ "Torps Loaded",	0,	12,		0,		12,		0,0,0 },
	{ "Beams Loaded",   0,   4,     0,       4,     0,0,0 },
	{ "Engine Temp",	0,	1200,	0,		1000,	0,0,0 }
};

#define SL_FRSHIELD	0
#define SL_RISHIELD	1
#define SL_LESHIELD	2
#define SL_RESHIELD	3
#define SL_FUEL    	4
#define SL_WARP    	5
#define SL_TORP    	6
#define SL_BEAM     7
#define SL_ETEMP   	8

static int		textWidth = 0;
static int		statX = STAT_X, statY = STAT_Y;
static GC sgc;

void box(w, whichgc, filled, x, y, wid, hei, pixel)
Window	w;
GC whichgc;
int filled,x,y,wid,hei;
unsigned long pixel;
{
	XPoint vertex[5];

	XSetForeground(dpy, whichgc, pixel);
	if (filled)
	{
		int	minX, minY;

		minX = MIN(x, x + wid);
		wid = ABS(wid);
		minY = MIN(y, y + hei);
		hei = ABS(hei);
		XFillRectangle(dpy, w, whichgc, minX, minY, wid + 1, hei + 1);
		return;
	}

	vertex[0].x = x;
	vertex[0].y = y;

	vertex[1].x = x + wid;
	vertex[1].y = y;

	vertex[2].x = x + wid;
	vertex[2].y = y + hei;

	vertex[3].x = x;
	vertex[3].y = y + hei;

	vertex[4].x = x;
	vertex[4].y = y;

	XDrawLines(dpy, w, whichgc, vertex, 5, CoordModeOrigin);
	XSetForeground(dpy, whichgc, textColor);
}


void initStats(prog)
char	*prog;
{
	int	i;

	if ((me->p_status == PALIVE)
			|| (me->p_status == POUTFIT)
			|| (me->p_status == PIMMUNE)) {
		/* Individualize for the particular ship */
		/* FRONT SHIELD */
		sliders[SL_FRSHIELD].max      = myship->s_shield[FRONT_SHIELD];
		sliders[SL_FRSHIELD].low_red  = sliders[SL_FRSHIELD].max / 5;
		sliders[SL_FRSHIELD].high_red = sliders[SL_FRSHIELD].max + 1;
	
		/* RIGHT SHIELD */
		sliders[SL_RISHIELD].max      = myship->s_shield[RIGHT_SHIELD];
		sliders[SL_RISHIELD].low_red  = sliders[SL_RISHIELD].max / 5;
		sliders[SL_RISHIELD].high_red = sliders[SL_RISHIELD].max + 1;
	
		/* LEFT SHIELD */
		sliders[SL_LESHIELD].max      = myship->s_shield[LEFT_SHIELD];
		sliders[SL_LESHIELD].low_red  = sliders[SL_LESHIELD].max / 5;
		sliders[SL_LESHIELD].high_red = sliders[SL_LESHIELD].max + 1;
	
		/* REAR SHIELD */
		sliders[SL_RESHIELD].max      = myship->s_shield[REAR_SHIELD];
		sliders[SL_RESHIELD].low_red  = sliders[SL_RESHIELD].max / 5;
		sliders[SL_RESHIELD].high_red = sliders[SL_RESHIELD].max + 1;
	
		/* FUEL */
		sliders[SL_FUEL].max      = myship->s_maxfuel;
		sliders[SL_FUEL].low_red  = sliders[SL_FUEL].max / 5;
		sliders[SL_FUEL].high_red = sliders[SL_FUEL].max + 1;
	
		/* WARP */
		sliders[SL_WARP].max      = myship->s_maxspeed;
		sliders[SL_WARP].low_red  = -1;
		sliders[SL_WARP].high_red = 8;
	
		/* TORPS LOADED */
		sliders[SL_TORP].max      = myship->s_torps;
		sliders[SL_TORP].low_red  = sliders[SL_TORP].max - 1;
		sliders[SL_TORP].high_red = sliders[SL_TORP].max + 1;

		/* BEAMS LOADED */
		sliders[SL_BEAM].max      = myship->s_beams;
		sliders[SL_BEAM].low_red  = sliders[SL_BEAM].max - 1;
		sliders[SL_BEAM].high_red = sliders[SL_BEAM].max + 1;
	}

	for (i = 0; i < NUM_SLIDERS; i++) {
		sliders[i].label_length = strlen(sliders[i].label);
		textWidth = MAX(textWidth, sliders[i].label_length);
		sliders[i].diff = sliders[i].max - sliders[i].min;
	}
}


Window openStats(p)
PLAYER	*p;
{
	char	*str;
	Window		w;
	extern Cursor	crosshair;
	char 		*calloc();
	XSizeHints          sizehints;
	XGCValues           xgcv;
	static char *Dummy[] = { "Dummy", "" };
	int	dummy;

	if ((str = XGetDefault(dpy, progname, "stats.geometry")) != NULL)
		XParseGeometry(str, &statX, &statY, &dummy, &dummy);

	sizehints.flags = USPosition | USSize;
	sizehints.width = STAT_WIDTH;
	sizehints.height = STAT_HEIGHT;
	sizehints.x = statX;
	sizehints.y = statY;

	w = XCreateSimpleWindow(dpy,
	    RootWindow(dpy,DefaultScreen(dpy)),
	    statX,
	    statY,
	    STAT_WIDTH,
	    STAT_HEIGHT,
	    2, gColor, backColor );
	XSetStandardProperties(dpy, w,"stats","stats",
	    None, Dummy, 1, &sizehints);
	set_class(w, "DTrek", "stats");

	xgcv.foreground = backColor;
	xgcv.background = backColor;
	xgcv.line_width = 1;
	sgc = XCreateGC(dpy, w,
	    GCForeground|GCBackground|GCLineWidth,
	    &xgcv);

	XSelectInput(dpy, w, ExposureMask );
	XMapWindow(dpy, w);
	return (w);
}

void redrawStats(w)
Window	w;
{
	int	i;
	XTextItem t;

	XClearWindow(dpy, w);
	for (i = 0; i < NUM_SLIDERS; i++) {
		t.chars = sliders[i].label;
		t.nchars = sliders[i].label_length;
		t.delta = 0;
		t.font  = dfont;
		XDrawText(dpy, w, gc, TX_OFF(sliders[i].label_length), TY_OFF(i)+8, 
		    &t, 1);
		box(w, sgc, 0, BX_OFF() - 1, BY_OFF(i) - 1, SL_WID+2, SL_HEI+2,
		    borderColor);
		sliders[i].last_value = 0;
	}
}

void closeStats(w)
Window	w;
{
	XDestroyWindow(dpy, w);
}

void updateStats(w)
Window		w;
{
	int	i, value, diff, old_x, new_x, wid;
	SLIDER	*s;
	unsigned long color;

	if (me->p_stats_dirty) {
		initStats("");
		redrawStats(w);
		me->p_stats_dirty = FALSE;
	}

	for (i = 0; i < NUM_SLIDERS; i++) {
		switch (i) {
			case SL_FRSHIELD:
				value = me->p_shield[FRONT_SHIELD];
				break;
			case SL_RISHIELD:
				value = me->p_shield[RIGHT_SHIELD];
				break;
			case SL_LESHIELD:
				value = me->p_shield[LEFT_SHIELD];
				break;
			case SL_RESHIELD:
				value = me->p_shield[REAR_SHIELD];
				break;
			case SL_FUEL:
				value = me->p_fuel;
				break;
			case SL_WARP:
				value = me->p_speed;
				break;
			case SL_TORP:
				value = myship->s_torps - me->p_torps_unloaded;
				break;
			case SL_BEAM:
				value = myship->s_beams - me->p_beams_unloaded;
				break;
			case SL_ETEMP:
				value = me->p_etemp;
				break;
		}
		s = &sliders[i];
		if (value < s->min) value = s->min;
		else if (value > s->max) value = s->max;

		if (value == s->last_value) continue;

		diff = value - s->last_value;
		if (diff < 0) color = backColor;
		else {
			if (value < s->low_red) color = warningColor;
			else if (value > s->high_red) {
				color = warningColor;
				if (s->last_value <= s->high_red) s->last_value = 0;
			}
			else {
				color = myColor;
				if (s->last_value < s->low_red) s->last_value = 0;
			}
		}
		if (s->diff == 0) {
			old_x = 0;
			new_x = 0;
		}
		else {
			old_x = s->last_value * SL_WID / s->diff;
			new_x = value * SL_WID / s->diff;
		}
		wid = new_x - old_x;
		box(w, sgc, 1, BX_OFF() + old_x, BY_OFF(i), wid,
		    SL_HEI, color);
		if (diff < 0) {
			if (s->last_value >= s->low_red && value < s->low_red)
				box(w, sgc, 1, BX_OFF(), BY_OFF(i), new_x, SL_HEI,
				    warningColor);
			else if (s->last_value > s->high_red && 
			    value <= s->high_red)
				box(w, sgc, 1, BX_OFF(), BY_OFF(i), new_x, SL_HEI,
				    myColor);
		}
		s->last_value = value;
	}
}

