/* startdmn.c 15.1 06/08/90 10:07:33 */

/*

	Copyright (c) 1986 	Chris Guthrie

Permission to use, copy, modify, and distribute this
software and its documentation for any purpose and without
fee is hereby granted, provided that the above copyright
notice appear in all copies and that both that copyright
notice and this permission notice appear in supporting
documentation.  No representations are made about the
suitability of this software for any purpose.  It is
provided "as is" without express or implied warranty.

*/

/* Major overhaul by Daryl Poe.
 *
 * Copyright (c) 1989 Daryl Poe
 *
 * Ported to X11 by Jim Andreas.
 * Tractors, treaties, and other features by Norm Gee.
 * Damage window and shield bitmaps by Tom LaStrange.
 *
 * The above comments apply to this version as well, and this
 * notice must also appear in any copies or follow-ons.
 */


#include <stdio.h>
#include "defs.h"
#include "weapon.h"
#include "system.h"
#include "ship.h"
#include "stats.h"
#include "player.h"
#include "torp.h"
#include "status.h"
#include "planet.h"
#include "phaser.h"
#include "message.h"
#include "shmem.h"
#include "data.h"
#include "daemon.h"

/* path using "me" will never be called by the daemon */
extern PLAYER *me;

#define MAXBASES		2
#define MAXMONITORS		2


void startdaemon()
{

	if (fork() == 0) {
		detach();
		setresuid(geteuid(),-1,-1);
		execl(Daemon, "dtrek_daemon", 0);
		perror(Daemon);
		fprintf(stderr, "Couldn't start daemon!!!\n");
		_exit(1);
	}
}


/**** MAKE SURE YOU'VE FORKED BEFORE CALLING THIS ****/
void start_robot(team_no,kills,who_attacked,orbit_planet,
	practice,shipname)
int team_no;
float kills;
int who_attacked,orbit_planet,practice;
char *shipname;
{
    char argv[20][80];
	int argc=0;
	register PLAYER *j;

	logmsg3("daemon: sending in robot for team %d, kills %f ",
		team_no,kills);
	logmsg3(" attacker %d, orbit %d\n",who_attacked,orbit_planet);
	logmsg3(" practice? %d, shipname: %s\n",practice,shipname);

	seedrandom();

	if (practice) {
		/* check for other players in game */
		for (j = players; j < players+MAXPLAYER;  j++) {
			if (j->p_status != PALIVE) continue;
			if (j == me) continue;
			if (j->p_ship.s_maxspeed == 0) continue;
			return;
		}
		/* It's okay */
		/* ask for small  ship */
		sprintf(argv[argc++],"-H%d",STD_HULL_SIZE-1);
		strcpy(argv[argc++],"-p");
		strcpy(argv[argc++],"-f");
		strcpy(argv[argc++],"-h");
	}
	else if (SAMESTR(shipname,"Starbase")
			|| SAMESTR(shipname,"Defense_base")) {
		sprintf(argv[argc++],"-S%d",10+INTRAND(60));
		strcpy(argv[argc++],"-f");
	}
	else if (SAMESTR(shipname,"Monitor")) {
		sprintf(argv[argc++],"-S%d",10+INTRAND(60));
		strcpy(argv[argc++],"-f");
		strcpy(argv[argc++],"-m");
		strcpy(argv[argc++],"-H125");
	}

	if (shipname != NULL) sprintf(argv[argc++],"-n%s",shipname);

	switch (team_no) {
        case FEDERATION:
            strcpy(argv[argc++],"-Tf");
            break;
        case ROMULAN:
            strcpy(argv[argc++],"-Tr");
            break;
        case KLINGON:
            strcpy(argv[argc++],"-Tk");
            break;
        case ORION:
            strcpy(argv[argc++],"-To");
            break;
        case INDEPENDENT:
            strcpy(argv[argc++],"-Ti");
			/* these must orbit */
			if (orbit_planet < 0) exit(1);
            break;
        case JUGGERNAUT:
            strcpy(argv[argc++],"-Tj");
            break;
		case PLANETKILLER:
            strcpy(argv[argc++],"-Tj");
            strcpy(argv[argc++],"-K");
            strcpy(argv[argc++],"-H500");
			break;
	}

	if (kills > 9.0) kills = 9.0;
	sprintf(argv[argc++], "-l%d", (int) kills);

	if (orbit_planet > -1)
    	sprintf(argv[argc++],"-P%d",orbit_planet);

	if (who_attacked > -1)
		sprintf(argv[argc++],"-e%d",who_attacked);

	switch (argc) {
		case 10:
			execl(Robot,"dtrek_robot",
				argv[0],argv[1],argv[2],argv[3],argv[4],
				argv[5],argv[6],argv[7],argv[8],argv[9],0);
			break;
		case 9:
			execl(Robot,"dtrek_robot",
				argv[0],argv[1],argv[2],argv[3],argv[4],
				argv[5],argv[6],argv[7],argv[8],0);
			break;
		case 8:
			execl(Robot,"dtrek_robot",
				argv[0],argv[1],argv[2],argv[3],argv[4],
				argv[5],argv[6],argv[7],0);
			break;
		case 7:
			execl(Robot,"dtrek_robot",
				argv[0],argv[1],argv[2],argv[3],argv[4],
				argv[5],argv[6],0);
			break;
		case 6:
			execl(Robot,"dtrek_robot",
				argv[0],argv[1],argv[2],argv[3],argv[4],
				argv[5],0);
			break;
		case 5:
			execl(Robot,"dtrek_robot",
				argv[0],argv[1],argv[2],argv[3],argv[4],0);
			break;
		case 4:
			execl(Robot,"dtrek_robot",
				argv[0],argv[1],argv[2],argv[3],0);
			break;
		case 3:
			execl(Robot,"dtrek_robot",argv[0],argv[1],argv[2],0);
			break;
		case 2:
			execl(Robot,"dtrek_robot",argv[0],argv[1],0);
			break;
		case 1:
			execl(Robot,"dtrek_robot",argv[0],0);
			break;
		case 0:
			execl(Robot,"dtrek_robot",0);
			break;
	}
	/* If we get here, we are hosed anyway */
	exit(0);
}


/**** MAKE SURE YOU'VE FORKED BEFORE CALLING THIS ****/
void start_starbases()
{
	PLAYER *player;
	int start_sb[NUMTEAM];

	/* give them time to die if they've recently been killed */
	sleep(30);

	if ((planets[FED_HOME].pl_owner_no == FEDERATION) 
			&& !team[FEDERATION].t_starbase_died)
		start_sb[FEDERATION] = TRUE;
	else start_sb[FEDERATION] = FALSE;

	if ((planets[ROM_HOME].pl_owner_no == ROMULAN) 
			&& !team[ROMULAN].t_starbase_died)
		start_sb[ROMULAN] = TRUE;
	else start_sb[ROMULAN] = FALSE;

	if ((planets[KLI_HOME].pl_owner_no == KLINGON) 
			&& !team[KLINGON].t_starbase_died)
		start_sb[KLINGON] = TRUE;
	else start_sb[KLINGON] = FALSE;

	if ((planets[ORI_HOME].pl_owner_no == ORION) 
			&& !team[ORION].t_starbase_died)
		start_sb[ORION] = TRUE;
	else start_sb[ORION] = FALSE;

	if ((planets[IND_HOME].pl_owner_no == INDEPENDENT) 
			&& !team[INDEPENDENT].t_starbase_died)
		start_sb[INDEPENDENT] = TRUE;
	else start_sb[INDEPENDENT] = FALSE;

	for (player=players; player < players+MAXPLAYER; ++player) {
		if ((player->p_status == PALIVE)
				&& (player->p_flags & PFROBOT)
				&& SAMESTR(player->p_ship.s_shipname,"Starbase")) {
			/* already got one */
			start_sb[player->p_team_no] = FALSE;
		}
	}

	if (start_sb[FEDERATION]) {
		if (fork() == 0) {
			detach();
			setresuid(geteuid(),-1,-1);
			start_robot(FEDERATION,5.0,-1,FED_HOME,
				FALSE,"Starbase");
			_exit(1);
		}
	}
	if (start_sb[ROMULAN]) {
		if (fork() == 0) {
			detach();
			setresuid(geteuid(),-1,-1);
			start_robot(ROMULAN,   5.0,-1,ROM_HOME,
				FALSE,"Starbase");
			_exit(1);
		}
	}
	if (start_sb[KLINGON]) {
		if (fork() == 0) {
			detach();
			setresuid(geteuid(),-1,-1);
			start_robot(KLINGON,   5.0,-1,KLI_HOME,
				FALSE,"Starbase");
			_exit(1);
		}
	}
	if (start_sb[ORION]) {
		if (fork() == 0) {
			detach();
			setresuid(geteuid(),-1,-1);
			start_robot(ORION,     5.0,-1,ORI_HOME,
				FALSE,"Starbase");
			_exit(1);
		}
	}
	if (start_sb[INDEPENDENT]) {
		if (fork() == 0) {
			detach();
			setresuid(geteuid(),-1,-1);
			start_robot(INDEPENDENT,5.0,-1,IND_HOME,
				FALSE,"Starbase");
			_exit(1);
		}
	}
	exit(0);
}


void kill_starbases()
{
	PLAYER *player;
	unsigned short uid,euid;

	uid  = getuid();
	euid = geteuid();

	setresuid(euid,euid,uid);
	for (player=players; player < players+MAXPLAYER; ++player) {
		if ((player->p_status == PALIVE)
				&& (player->p_flags & PFROBOT)
				&& SAMESTR(player->p_ship.s_shipname,"Starbase")) {
			kill(player->p_pid,15);
			player->p_explode = 10/PLAYERFUSE - 1;
			player->p_status = PEXPLODE;
		}
	}
	setresuid(uid,euid,uid);
}

/**** MAKE SURE YOU'VE FORKED BEFORE CALLING THIS ****/
void start_defense_bases()
{
	PLAYER *player;
	PLANET *planet,*home;
	int basecount[NUMTEAM],race,dist,closest,mindist;
	static long lasttime = 0;
	long thistime;

	/* make sure I haven't done this too recently */
	thistime = time((long *) 0);
	if ((thistime - lasttime) < (60*2)) {
		return;
	}
	lasttime = thistime;

	/* count the number of bases active on each team */
	for (race=0; race<NUMTEAM; ++race) basecount[race] = 0;

	for (player=players; player<players+MAXPLAYER; ++player) {
		if ((player->p_status == PALIVE)
				&& (player->p_flags & PFROBOT)
				&& (player->p_ship.s_maxspeed == 0)) {
			++basecount[player->p_team_no];
		}
	}
	logmsg2("basecount[FED] = %d\n",basecount[FEDERATION]);
	logmsg2("basecount[ROM] = %d\n",basecount[ROMULAN]);
	logmsg2("basecount[KLI] = %d\n",basecount[KLINGON]);
	logmsg2("basecount[ORI] = %d\n",basecount[ORION]);

	/* now add one to each team if they don't have MAXBASES already */
	for (race=FEDERATION; race<=ORION; ++race) {
		if (basecount[race] < MAXBASES) {
			/* is my home planet mine? */
			home = &planets[race*10-10];
			if (home->pl_owner_no == race) {
				closest = home->pl_no;
			}
			else {
				/* find the nearest planet to my home owned by me */
				mindist = (GWIDTH*2);
				closest = -1;
				for (planet = planets; planet < planets+MAXPLANETS;
						++planet) {
					if (planet->pl_owner_no == race) {
						dist = Ihypot(planet->pl_x - home->pl_x,
							planet->pl_y - home->pl_y);
						if (dist < mindist) {
							closest = planet->pl_no;
							mindist = dist;
						}
					}
				}
				if (closest == -1) {
					/* no planets, orbit old home */
					closest = home->pl_no;
				}
			}

			logmsg2("\nStarting Defense_base for team %d\n",race); 
			if (fork() == 0) {
				detach();
				setresuid(geteuid(),-1,-1);
				start_robot(race,0.0,-1,closest,
					FALSE,"Defense_base");
				_exit(1);
			}
		}
	}
}


/**** MAKE SURE YOU'VE FORKED BEFORE CALLING THIS ****/
void start_monitors()
{
	PLAYER *player;
	PLANET *planet,*home;
	int monitorcount[NUMTEAM],race,dist,closest,mindist;
	static long lasttime = 0;
	long thistime;

	/* make sure I haven't done this too recently */
	thistime = time((long *) 0);
	if ((thistime - lasttime) < (60*2)) {
		return;
	}
	lasttime = thistime;

	/* count the number of monitors active on each team */
	for (race=0; race<NUMTEAM; ++race) monitorcount[race] = 0;

	for (player=players; player<players+MAXPLAYER; ++player) {
		if ((player->p_status == PALIVE)
				&& (player->p_flags & PFROBOT)
				&& (player->p_flags & PFMONITOR)
				&& (player->p_ship.s_maxspeed == 0)) {
			++monitorcount[player->p_team_no];
		}
	}
	logmsg2("monitorcount[FED] = %d\n",monitorcount[FEDERATION]);
	logmsg2("monitorcount[ROM] = %d\n",monitorcount[ROMULAN]);
	logmsg2("monitorcount[KLI] = %d\n",monitorcount[KLINGON]);
	logmsg2("monitorcount[ORI] = %d\n",monitorcount[ORION]);

	/* now add one to each team if they don't have MAXMONITORS */
	for (race=FEDERATION; race<=ORION; ++race) {
		if (monitorcount[race] < MAXMONITORS) {
			/* is my home planet mine? */
			home = &planets[race*10-10];
			if (home->pl_owner_no == race) {
				closest = home->pl_no;
			}
			else {
				/* find the nearest planet to my home owned by me */
				mindist = (GWIDTH*2);
				closest = -1;
				for (planet = planets; planet < planets+MAXPLANETS;
						++planet) {
					if (planet->pl_owner_no == race) {
						dist = Ihypot(planet->pl_x - home->pl_x,
							planet->pl_y - home->pl_y);
						if (dist < mindist) {
							closest = planet->pl_no;
							mindist = dist;
						}
					}
				}
				if (closest == -1) {
					/* no planets, orbit old home */
					closest = home->pl_no;
				}
			}

			logmsg2("\nStarting Monitor for team %d\n",race); 
			if (fork() == 0) {
				detach();
				setresuid(geteuid(),-1,-1);
				start_robot(race,0.0,-1,closest,
					FALSE,"Monitor");
				_exit(1);
			}
		}
	}
}


/**** MAKE SURE YOU'VE FORKED BEFORE CALLING THIS ****/
void start_planetkiller()
{
	PLAYER *player;
	PLANET *planet,*home;
	int race,dist,closest,mindist;
	static long lasttime = 0;
	long thistime;

	/* make sure I haven't done this too recently */
	thistime = time((long *) 0);
	if ((thistime - lasttime) < (60*2)) {
		return;
	}
	lasttime = thistime;

	for (player=players; player<players+MAXPLAYER; ++player) {
		if ((player->p_status == PALIVE)
				&& (player->p_flags & PFROBOT)
				&& (player->p_flags & PFPLKILLER)) {
			/* only one at a time, please */
			return;
		}
	}

	logmsg1("\nStarting Planetkiller\n");
	if (fork() == 0) {
		detach();
		setresuid(geteuid(),-1,-1);
		start_robot(PLANETKILLER,10.0,-1,-1,FALSE,NULL);
		_exit(1);
	}
}


void kill_defense_bases()
{
	PLAYER *player;
	unsigned short uid,euid;

	uid  = getuid();
	euid = geteuid();

	setresuid(euid,euid,uid);
	for (player=players; player < players+MAXPLAYER; ++player) {
		if ((player->p_status == PALIVE)
				&& (player->p_flags & PFROBOT)
				&& (strncmp(player->p_ship.s_shipname,
					"Defense_base",8) == 0)) {
			kill(player->p_pid,15);
			player->p_explode = 10/PLAYERFUSE - 1;
			player->p_status = PEXPLODE;
		}
	}
	setresuid(uid,euid,uid);
}


void kill_monitors()
{
	PLAYER *player;
	unsigned short uid,euid;

	uid  = getuid();
	euid = geteuid();

	setresuid(euid,euid,uid);
	for (player=players; player < players+MAXPLAYER; ++player) {
		if ((player->p_status == PALIVE)
				&& (player->p_flags & PFROBOT)
				&& (player->p_flags & PFMONITOR)) {
			kill(player->p_pid,15);
			player->p_explode = 10/PLAYERFUSE - 1;
			player->p_status = PEXPLODE;
		}
	}
	setresuid(uid,euid,uid);
}


void kill_planetkiller()
{
	PLAYER *player;
	unsigned short uid,euid;

	uid  = getuid();
	euid = geteuid();

	setresuid(euid,euid,uid);
	for (player=players; player < players+MAXPLAYER; ++player) {
		if ((player->p_status == PALIVE)
				&& (player->p_flags & PFROBOT)
				&& (player->p_flags & PFPLKILLER)) {
			kill(player->p_pid,15);
			player->p_explode = 10/PLAYERFUSE - 1;
			player->p_status = PEXPLODE;
		}
	}
	setresuid(uid,euid,uid);
}

