/* sphere.c 15.1 06/08/90 10:07:30 */

/*

	Copyright (c) 1986 	Chris Guthrie

Permission to use, copy, modify, and distribute this
software and its documentation for any purpose and without
fee is hereby granted, provided that the above copyright
notice appear in all copies and that both that copyright
notice and this permission notice appear in supporting
documentation.  No representations are made about the
suitability of this software for any purpose.  It is
provided "as is" without express or implied warranty.

*/

/* Major overhaul by Daryl Poe.
 *
 * Copyright (c) 1989 Daryl Poe
 *
 * Ported to X11 by Jim Andreas.
 * Tractors, treaties, and other features by Norm Gee.
 * Damage window and shield bitmaps by Tom LaStrange.
 *
 * The above comments apply to this version as well, and this
 * notice must also appear in any copies or follow-ons.
 */

#include <stdio.h>
#include "defs.h"
#include "daemon.h"
#include "weapon.h"
#include "ship.h"
#include "stats.h"
#include "player.h"
#include "torp.h"
#include "status.h"
#include "planet.h"
#include "phaser.h"
#include "message.h"
#include "shmem.h"
#include "data.h"
#include "system.h"



int sphere_backlash(firer,target,damage)
PLAYER *firer,*target;
int damage;
{
	int i;
	TORP *k;

	logmsg3("backlash fired from %d to %d. \n",
		firer->p_no,target->p_no);

	if ((planets[firer->p_closest_planet].pl_flags & PLMASK_AST_FIELD)
			&& (firer->p_closest_planet_dist < AST_FIELD_RADIUS)) {
		warning("Cannot fire from inside asteroid field");
		return(0);
	}

	/* Find a free torp */
	for (i = firer->p_no * MAXTORP, k = &torps[i];
			i < firer->p_no * MAXTORP + MAXTORP;
			i++, k++) {
		if (k->t_status == TFREE) break;
	}
	if (i >= firer->p_no * MAXTORP + MAXTORP) return;

	firer->p_ntorp++;

	/* Setup data in new torp */
	k->t_no        = i;
	k->t_status    = TTRACK;
	k->t_owner_no  = firer->p_no;
	k->t_x         = firer->p_x;
	k->t_y         = firer->p_y;
	k->t_dir       = Atan2(firer->p_y - target->p_y,
						target->p_x - firer->p_x);
	k->t_dx        = Cos[k->t_dir] * (BACKLASH_SPEED * WARP1);
	k->t_dy        = Sin[k->t_dir] * (BACKLASH_SPEED * WARP1);
	k->t_damage    = damage;
	k->t_speed     = BACKLASH_SPEED;
	k->t_fuse      = 60;
	k->t_arm       = (10/TORPFUSE);
	k->t_war_mask  = ALL_MASK;
	k->t_team_mask = firer->p_team_mask;
	k->t_decay     = 0;
	k->t_target    = target->p_no;
	k->t_class     = WPN_SPHERE_BACKLASH;
	k->t_closest_planet = firer->p_closest_planet;
	k->t_closest_planet_dist = firer->p_closest_planet_dist;
	return(1);
}
