/* smessage.c 15.1 06/08/90 10:07:27 */

/*

	Copyright (c) 1986 	Chris Guthrie

Permission to use, copy, modify, and distribute this
software and its documentation for any purpose and without
fee is hereby granted, provided that the above copyright
notice appear in all copies and that both that copyright
notice and this permission notice appear in supporting
documentation.  No representations are made about the
suitability of this software for any purpose.  It is
provided "as is" without express or implied warranty.

*/

/* Major overhaul by Daryl Poe.
 *
 * Copyright (c) 1989 Daryl Poe
 *
 * Ported to X11 by Jim Andreas.
 * Tractors, treaties, and other features by Norm Gee.
 * Damage window and shield bitmaps by Tom LaStrange.
 *
 * The above comments apply to this version as well, and this
 * notice must also appear in any copies or follow-ons.
 */


#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <stdio.h>
#include <ctype.h>
#include "defs.h"
#include "weapon.h"
#include "system.h"
#include "ship.h"
#include "stats.h"
#include "player.h"
#include "torp.h"
#include "status.h"
#include "planet.h"
#include "phaser.h"
#include "message.h"
#include "shmem.h"
#include "data.h"
#include "xdata.h"

#define STRSTART (MSG_ADDRLEN+1)

static int lcount;
static char buf[MSG_STRLEN+1];
static char addr;
static char addrmesg[MSG_ADDRLEN+1];

static int getaddr(who)
char who;
{
	int pno;

	if (iscntrl(who)) {
		return(-1);
	}

	addr = who;
	sprintf(addrmesg, " %s->", me->p_mapchars);
	switch (who) {
	case 'E':
         (void) sprintf(&addrmesg[5],"ENM");
         break;
	case 'T': 
		 (void) sprintf(&addrmesg[5],"TR ");
		 break;
	case 'A':
		(void) sprintf(&addrmesg[5], "ALL");
		break;
	case 'F':
		(void) sprintf(&addrmesg[5], "FED");
		break;
	case 'R':
		(void) sprintf(&addrmesg[5], "ROM");
		break;
	case 'K':
		(void) sprintf(&addrmesg[5], "KLI");
		break;
	case 'O':
		(void) sprintf(&addrmesg[5], "ORI");
		break;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':
		pno = (int) (who - '0');
		if (players[pno].p_status == PALIVE) {
			sprintf(&addrmesg[5], "%s ",players[pno].p_mapchars);
		}
		else if (players[pno].p_status == PIMMUNE) {
			sprintf(&addrmesg[5], "%s ",players[pno].p_mapchars);
			warning("Player in eXit mode -- message sent anyway");
		}
		else {
			warning("Player is not in game");
			return(-1);
		}
		break;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':
		pno = (int) (who - 'a') + 10;
		if (players[pno].p_status == PALIVE) {
			sprintf(&addrmesg[5], "%s ",players[pno].p_mapchars);
		}
		else if (players[pno].p_status == PIMMUNE) {
			sprintf(&addrmesg[5], "%s ",players[pno].p_mapchars);
			warning("Player in eXit mode -- message sent anyway");
		}
		else {
			warning("Player is not in game");
			return(-1);
		}
		break;
	default:
		warning("Not legal recipient");
		return(-1);
	}
	return(0);
}


void smessage(ichar)
char ichar;
{
	register int i;
	XTextItem t;
	int tmask;

	if (watch) {
		warning("cannot send messages from watch");
		return;
	}
	if (messpend == 0) {
		messpend = 1;
		if (mdisplayed) {
			XClearWindow(dpy, smessagew);
			mdisplayed = 0;
		}
		/* Put the proper recipient in the window */
		if (getaddr(ichar) < 0) {
			/* print error message */
			messpend = 0;
			return;
		}
		XSetForeground(dpy,gc,textColor);
		t.chars = addrmesg;
		t.nchars = MSG_ADDRLEN;
		t.delta = 0;
		t.font  = dfont;
		XDrawText( dpy, smessagew, gc,    
			5 + dfontinfo->max_bounds.rbearing * lcount, 
		    5 + dfontinfo->ascent,
		    &t, 1 );  
		lcount = STRSTART;
		return;
	}
	switch (ichar) {
	case '\b':
	case '\177':
		if (--lcount < STRSTART) {
			lcount = STRSTART;
			break;
		}
		XClearArea(dpy, smessagew,
			5 + dfontinfo->max_bounds.rbearing * lcount, 5,
			dfontinfo->max_bounds.rbearing
				- dfontinfo->min_bounds.lbearing,
			dfontinfo->descent + dfontinfo->ascent, False);
		break;

	case '\027':
		i = 0;
		/* back up over blanks */
		while (--lcount >= STRSTART && isspace(buf[lcount - STRSTART]))
			i++;
		lcount++;
		/* back up over non-blanks */
		while (--lcount >= STRSTART && !isspace(buf[lcount - STRSTART]))
			i++;
		lcount++;

		if (i > 0) {
			XSetForeground(dpy,gc,backColor);
			XFillRectangle( dpy, smessagew, gc,      
				5 + dfontinfo->max_bounds.rbearing * lcount, 5,
			    dfontinfo->max_bounds.rbearing * i,
			    dfontinfo->descent + dfontinfo->ascent );
		}
		break;
	case '\025':
	case '\030':
		if (lcount > STRSTART) {
			XSetForeground(dpy,gc,backColor);
			XFillRectangle( dpy, smessagew, gc,      
				5 + dfontinfo->max_bounds.rbearing * STRSTART, 5,
			    dfontinfo->max_bounds.rbearing * (lcount - STRSTART),
			    dfontinfo->descent + dfontinfo->ascent );
		}
		lcount = STRSTART;
		break;
	case '\033':
		XSetForeground(dpy,gc,backColor);
		XFillRectangle( dpy, smessagew, gc,       
			5, 5,    
			dfontinfo->max_bounds.rbearing * lcount,
		    dfontinfo->descent + dfontinfo->ascent );
		mdisplayed = 0;
		messpend = 0;
		break;
	case '\r':
		buf[lcount - STRSTART] = 0;
		messpend = 0;
		switch (addr) {
		case 'E':
             tmask = 1;
             while ( tmask <= ORI_MASK )  {
               if ( !(tmask & ~(me->p_hostile_mask)) ) {
                 pmessage(buf, tmask, MTEAM, addrmesg);
               }
               tmask <<= 1;
             }
             break;
		case 'T':
			 tmask = 1;
			 while ( tmask <= ORI_MASK ) {
			   if ( tmask & ~(me->p_hostile_mask) ) {
				 pmessage(buf, tmask, MTEAM, addrmesg);
			   }
			   tmask <<= 1;
			 }
			 break;
		case 'A':
			pmessage(buf, 0, MALL, addrmesg);
			break;
		case 'F':
			pmessage(buf, FED_MASK, MTEAM, addrmesg);
			break;
		case 'R':
			pmessage(buf, ROM_MASK, MTEAM, addrmesg);
			break;
		case 'K':
			pmessage(buf, KLI_MASK, MTEAM, addrmesg);
			break;
		case 'O':
			pmessage(buf, ORI_MASK, MTEAM, addrmesg);
			break;
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9':
			pmessage(buf, addr - '0', MINDIV, addrmesg);
			break;
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z':
			pmessage(buf, addr - 'a' + 10, MINDIV, addrmesg);
			break;
		default:
			warning("Not legal recipient");
		}
		XSetForeground(dpy,gc,backColor);
		XFillRectangle( dpy, smessagew, gc,       
			5, 5,
			dfontinfo->max_bounds.rbearing * lcount,
		    dfontinfo->descent + dfontinfo->ascent );
		mdisplayed = 0;
		lcount = 0;
		break;
	default:
		if (lcount == MSG_DATALEN) {
			XBell( dpy, 100 );
			break;
		}
		if (iscntrl(ichar)) break;

		XSetForeground(dpy,gc,textColor);
		t.chars = &ichar;
		t.nchars = 1;
		t.delta = 0;
		t.font  = dfont;
		XDrawText( dpy, smessagew, gc,   
			5 + dfontinfo->max_bounds.rbearing * lcount, 
		    5 + dfontinfo->ascent,
		    &t, 1 );   
		buf[(lcount++) - STRSTART] = ichar;
		break;
	}
}


