/* sintab.c 15.1 06/08/90 10:07:23 */

/*

	Copyright (c) 1986 	Chris Guthrie

Permission to use, copy, modify, and distribute this
software and its documentation for any purpose and without
fee is hereby granted, provided that the above copyright
notice appear in all copies and that both that copyright
notice and this permission notice appear in supporting
documentation.  No representations are made about the
suitability of this software for any purpose.  It is
provided "as is" without express or implied warranty.

*/

/* Major overhaul by Daryl Poe.
 *
 * Copyright (c) 1989 Daryl Poe
 *
 * Ported to X11 by Jim Andreas.
 * Tractors, treaties, and other features by Norm Gee.
 * Damage window and shield bitmaps by Tom LaStrange.
 *
 * The above comments apply to this version as well, and this
 * notice must also appear in any copies or follow-ons.
 */

#include <stdio.h>
#include <math.h>
#include "defs.h"

double Sin[] = {
	-1.0000,
	-0.9997,
	-0.9988,
	-0.9973,
	-0.9952,
	-0.9925,
	-0.9892,
	-0.9853,
	-0.9808,
	-0.9757,
	-0.9701,
	-0.9638,
	-0.9570,
	-0.9496,
	-0.9416,
	-0.9330,
	-0.9239,
	-0.9143,
	-0.9040,
	-0.8933,
	-0.8820,
	-0.8701,
	-0.8578,
	-0.8449,
	-0.8315,
	-0.8176,
	-0.8033,
	-0.7884,
	-0.7731,
	-0.7573,
	-0.7410,
	-0.7243,
	-0.7072,
	-0.6896,
	-0.6716,
	-0.6533,
	-0.6345,
	-0.6153,
	-0.5958,
	-0.5759,
	-0.5557,
	-0.5351,
	-0.5142,
	-0.4930,
	-0.4715,
	-0.4497,
	-0.4277,
	-0.4054,
	-0.3828,
	-0.3600,
	-0.3370,
	-0.3138,
	-0.2904,
	-0.2668,
	-0.2431,
	-0.2192,
	-0.1952,
	-0.1711,
	-0.1469,
	-0.1225,
	-0.0982,
	-0.0737,
	-0.0492,
	-0.0247,
	-0.0001,
	0.0244,
	0.0489,
	0.0734,
	0.0979,
	0.1223,
	0.1466,
	0.1708,
	0.1949,
	0.2190,
	0.2428,
	0.2666,
	0.2901,
	0.3135,
	0.3367,
	0.3598,
	0.3825,
	0.4051,
	0.4274,
	0.4495,
	0.4713,
	0.4928,
	0.5140,
	0.5349,
	0.5554,
	0.5757,
	0.5956,
	0.6151,
	0.6343,
	0.6531,
	0.6714,
	0.6894,
	0.7070,
	0.7241,
	0.7408,
	0.7571,
	0.7729,
	0.7882,
	0.8031,
	0.8175,
	0.8314,
	0.8448,
	0.8576,
	0.8700,
	0.8818,
	0.8931,
	0.9039,
	0.9141,
	0.9238,
	0.9329,
	0.9415,
	0.9495,
	0.9569,
	0.9637,
	0.9700,
	0.9757,
	0.9808,
	0.9852,
	0.9891,
	0.9925,
	0.9952,
	0.9973,
	0.9988,
	0.9997,
	1.0000,
	0.9997,
	0.9988,
	0.9973,
	0.9952,
	0.9925,
	0.9892,
	0.9853,
	0.9808,
	0.9757,
	0.9700,
	0.9638,
	0.9569,
	0.9495,
	0.9415,
	0.9330,
	0.9239,
	0.9142,
	0.9040,
	0.8932,
	0.8819,
	0.8701,
	0.8577,
	0.8449,
	0.8315,
	0.8176,
	0.8032,
	0.7884,
	0.7730,
	0.7572,
	0.7410,
	0.7243,
	0.7071,
	0.6896,
	0.6716,
	0.6532,
	0.6344,
	0.6153,
	0.5957,
	0.5758,
	0.5556,
	0.5350,
	0.5141,
	0.4929,
	0.4714,
	0.4496,
	0.4276,
	0.4053,
	0.3827,
	0.3599,
	0.3369,
	0.3137,
	0.2903,
	0.2667,
	0.2430,
	0.2191,
	0.1951,
	0.1710,
	0.1468,
	0.1225,
	0.0981,
	0.0736,
	0.0491,
	0.0246,
	0.0000,
	-0.0245,
	-0.0490,
	-0.0735,
	-0.0980,
	-0.1224,
	-0.1467,
	-0.1709,
	-0.1950,
	-0.2190,
	-0.2429,
	-0.2667,
	-0.2902,
	-0.3136,
	-0.3368,
	-0.3598,
	-0.3826,
	-0.4052,
	-0.4275,
	-0.4496,
	-0.4713,
	-0.4928,
	-0.5140,
	-0.5349,
	-0.5555,
	-0.5758,
	-0.5956,
	-0.6152,
	-0.6343,
	-0.6531,
	-0.6715,
	-0.6895,
	-0.7071,
	-0.7242,
	-0.7409,
	-0.7572,
	-0.7730,
	-0.7883,
	-0.8032,
	-0.8175,
	-0.8314,
	-0.8448,
	-0.8577,
	-0.8700,
	-0.8819,
	-0.8932,
	-0.9040,
	-0.9142,
	-0.9238,
	-0.9330,
	-0.9415,
	-0.9495,
	-0.9569,
	-0.9638,
	-0.9700,
	-0.9757,
	-0.9808,
	-0.9853,
	-0.9892,
	-0.9925,
	-0.9952,
	-0.9973,
	-0.9988,
	-0.9997
};

double Cos[] = {
	0.0000,
	0.0245,
	0.0491,
	0.0736,
	0.0980,
	0.1224,
	0.1467,
	0.1710,
	0.1951,
	0.2191,
	0.2430,
	0.2667,
	0.2903,
	0.3137,
	0.3369,
	0.3599,
	0.3827,
	0.4052,
	0.4275,
	0.4496,
	0.4714,
	0.4929,
	0.5141,
	0.5350,
	0.5556,
	0.5758,
	0.5957,
	0.6152,
	0.6344,
	0.6532,
	0.6715,
	0.6895,
	0.7071,
	0.7242,
	0.7409,
	0.7572,
	0.7730,
	0.7883,
	0.8032,
	0.8176,
	0.8315,
	0.8448,
	0.8577,
	0.8701,
	0.8819,
	0.8932,
	0.9040,
	0.9142,
	0.9239,
	0.9330,
	0.9415,
	0.9495,
	0.9569,
	0.9638,
	0.9700,
	0.9757,
	0.9808,
	0.9853,
	0.9892,
	0.9925,
	0.9952,
	0.9973,
	0.9988,
	0.9997,
	1.0000,
	0.9997,
	0.9988,
	0.9973,
	0.9952,
	0.9925,
	0.9892,
	0.9853,
	0.9808,
	0.9757,
	0.9700,
	0.9638,
	0.9570,
	0.9495,
	0.9416,
	0.9330,
	0.9239,
	0.9142,
	0.9040,
	0.8933,
	0.8819,
	0.8701,
	0.8578,
	0.8449,
	0.8315,
	0.8176,
	0.8032,
	0.7884,
	0.7731,
	0.7573,
	0.7410,
	0.7243,
	0.7072,
	0.6896,
	0.6716,
	0.6532,
	0.6344,
	0.6153,
	0.5958,
	0.5759,
	0.5556,
	0.5351,
	0.5142,
	0.4930,
	0.4715,
	0.4497,
	0.4276,
	0.4053,
	0.3828,
	0.3600,
	0.3370,
	0.3138,
	0.2904,
	0.2668,
	0.2431,
	0.2192,
	0.1952,
	0.1710,
	0.1468,
	0.1225,
	0.0981,
	0.0737,
	0.0492,
	0.0246,
	0.0001,
	-0.0244,
	-0.0490,
	-0.0735,
	-0.0979,
	-0.1223,
	-0.1466,
	-0.1709,
	-0.1950,
	-0.2190,
	-0.2429,
	-0.2666,
	-0.2902,
	-0.3136,
	-0.3368,
	-0.3598,
	-0.3826,
	-0.4051,
	-0.4275,
	-0.4495,
	-0.4713,
	-0.4928,
	-0.5140,
	-0.5349,
	-0.5555,
	-0.5757,
	-0.5956,
	-0.6151,
	-0.6343,
	-0.6531,
	-0.6715,
	-0.6895,
	-0.7070,
	-0.7242,
	-0.7409,
	-0.7571,
	-0.7729,
	-0.7883,
	-0.8031,
	-0.8175,
	-0.8314,
	-0.8448,
	-0.8577,
	-0.8700,
	-0.8819,
	-0.8932,
	-0.9039,
	-0.9142,
	-0.9238,
	-0.9329,
	-0.9415,
	-0.9495,
	-0.9569,
	-0.9637,
	-0.9700,
	-0.9757,
	-0.9808,
	-0.9853,
	-0.9892,
	-0.9925,
	-0.9952,
	-0.9973,
	-0.9988,
	-0.9997,
	-1.0000,
	-0.9997,
	-0.9988,
	-0.9973,
	-0.9952,
	-0.9925,
	-0.9892,
	-0.9853,
	-0.9808,
	-0.9757,
	-0.9701,
	-0.9638,
	-0.9570,
	-0.9496,
	-0.9416,
	-0.9330,
	-0.9239,
	-0.9143,
	-0.9041,
	-0.8933,
	-0.8820,
	-0.8702,
	-0.8578,
	-0.8449,
	-0.8316,
	-0.8177,
	-0.8033,
	-0.7884,
	-0.7731,
	-0.7573,
	-0.7411,
	-0.7244,
	-0.7072,
	-0.6897,
	-0.6717,
	-0.6533,
	-0.6345,
	-0.6154,
	-0.5958,
	-0.5759,
	-0.5557,
	-0.5351,
	-0.5142,
	-0.4930,
	-0.4715,
	-0.4498,
	-0.4277,
	-0.4054,
	-0.3828,
	-0.3601,
	-0.3371,
	-0.3138,
	-0.2905,
	-0.2669,
	-0.2432,
	-0.2193,
	-0.1953,
	-0.1711,
	-0.1469,
	-0.1226,
	-0.0982,
	-0.0737,
	-0.0493,
	-0.0247
};

static int at2tab1[256] = {
	64, 64, 64, 64, 63, 63, 63, 63, 63, 63, 62, 62, 62, 62, 62, 62, 
	61, 61, 61, 61, 61, 61, 61, 60, 60, 60, 60, 60, 60, 59, 59, 59, 
	59, 59, 59, 58, 58, 58, 58, 58, 58, 58, 57, 57, 57, 57, 57, 57, 
	56, 56, 56, 56, 56, 56, 56, 55, 55, 55, 55, 55, 55, 54, 54, 54, 
	54, 54, 54, 54, 53, 53, 53, 53, 53, 53, 53, 52, 52, 52, 52, 52, 
	52, 52, 51, 51, 51, 51, 51, 51, 51, 50, 50, 50, 50, 50, 50, 50, 
	49, 49, 49, 49, 49, 49, 49, 48, 48, 48, 48, 48, 48, 48, 47, 47, 
	47, 47, 47, 47, 47, 47, 46, 46, 46, 46, 46, 46, 46, 45, 45, 45, 
	45, 45, 45, 45, 45, 44, 44, 44, 44, 44, 44, 44, 44, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 42, 42, 42, 42, 42, 42, 42, 42, 41, 41, 
	41, 41, 41, 41, 41, 41, 41, 40, 40, 40, 40, 40, 40, 40, 40, 40, 
	39, 39, 39, 39, 39, 39, 39, 39, 39, 39, 38, 38, 38, 38, 38, 38, 
	38, 38, 38, 37, 37, 37, 37, 37, 37, 37, 37, 37, 37, 36, 36, 36, 
	36, 36, 36, 36, 36, 36, 36, 36, 35, 35, 35, 35, 35, 35, 35, 35, 
	35, 35, 35, 34, 34, 34, 34, 34, 34, 34, 34, 34, 34, 34, 33, 33, 
	33, 33, 33, 33, 33, 33, 33, 33, 33, 33, 32, 32, 32, 32, 32, 32
};

static int at2tab2[256] = {
	 0,  0,  0,  0,  1,  1,  1,  1,  1,  1,  2,  2,  2,  2,  2,  2, 
	 3,  3,  3,  3,  3,  3,  3,  4,  4,  4,  4,  4,  4,  5,  5,  5, 
	 5,  5,  5,  6,  6,  6,  6,  6,  6,  6,  7,  7,  7,  7,  7,  7, 
	 8,  8,  8,  8,  8,  8,  8,  9,  9,  9,  9,  9,  9, 10, 10, 10, 
	10, 10, 10, 10, 11, 11, 11, 11, 11, 11, 11, 12, 12, 12, 12, 12, 
	12, 12, 13, 13, 13, 13, 13, 13, 13, 14, 14, 14, 14, 14, 14, 14, 
	15, 15, 15, 15, 15, 15, 15, 16, 16, 16, 16, 16, 16, 16, 17, 17, 
	17, 17, 17, 17, 17, 17, 18, 18, 18, 18, 18, 18, 18, 19, 19, 19, 
	19, 19, 19, 19, 19, 20, 20, 20, 20, 20, 20, 20, 20, 21, 21, 21, 
	21, 21, 21, 21, 21, 21, 22, 22, 22, 22, 22, 22, 22, 22, 23, 23, 
	23, 23, 23, 23, 23, 23, 23, 24, 24, 24, 24, 24, 24, 24, 24, 24, 
	25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 26, 26, 26, 26, 26, 26, 
	26, 26, 26, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 28, 28, 28, 
	28, 28, 28, 28, 28, 28, 28, 28, 29, 29, 29, 29, 29, 29, 29, 29, 
	29, 29, 29, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 31, 31, 
	31, 31, 31, 31, 31, 31, 31, 31, 31, 31, 32, 32, 32, 32, 32, 32
};

COURSE Atan2(y, x)
int y, x;
{
	int add,retsign,t;

	if ( x == 0 )
		if (y >= 0) return((COURSE) 0);
		else return((COURSE) 128);

	if ( y == 0 )
		if (x >= 0) return((COURSE) 64);
		else return((COURSE) 192);

	if (x < 0) {
		x = -x;
		retsign = -1;
		add = 128;
	}
	else {
		add = 0;
		retsign = 1;
	}

	if (y < 0) {
		y = -y;
		retsign = -retsign;
	}

	if ( x == y ) t = 32;
	else if ( x > y ) t = at2tab1[(y << 8)/x];
	else t = at2tab2[(x << 8)/y];

	if (retsign == 1) return((COURSE) (add+t));
	else return((COURSE) (128+add-t));
}

unsigned int two_to[] = {
	0x0001, 0x0002, 0x0004, 0x0008,
	0x0010, 0x0020, 0x0040, 0x0080,
	0x0100, 0x0200, 0x0400, 0x0800,
	0x1000, 0x2000, 0x4000, 0x8000
};

short log_two[] = {
	0, 0, 1, 1, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3,
	4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4,
	5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
	5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
	6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6,
	6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6,
	6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6,
	7
};


int Isqrt(n)
int n;
{
    register unsigned int a,b,c,j,i;

	if (n <= 0) return(0);
	if (n < 4)  return(1);

	a = n; j = 0;
	while (a >>= 1) ++j;
	j >>= 1;
	a = 1 << j;
	if (!(b = n - (1<<(j<<1)))) return(a);
	--j;

	for (i=1<<j; i>0; i >>= 1,--j) 
		/* if i*i < b */
		if ((c = 1<<(j<<1)) < b) {
			/* if i*i + 2*i*current_guess < b */
			if ((c += a*(2<<j)) < b) {
				a |= i;
				b = n - a*a;
			}
			else if (c == b) return(a|i);
		}

	return(a);
}

int Ihypot(x,y)
int x,y;
{
	register unsigned int max,mask,shift;

	x = ABS(x);
	y = ABS(y);

	if (x>y) max = x;
	else max = y;
	
	if (!(max & 0x7fff8000)) return(Isqrt(x*x + y*y));
	/* else */
	mask = 0x40000000; shift = 16;
	while (!(max & mask)) {
		--shift;
		mask >>= 1;
	}

	x >>= shift;
	y >>= shift;
	return(Isqrt(x*x + y*y) << shift);
}


float min_quadratic_solution(a,b,c)
float a,b,c;
{
	float d;

	if (a == 0.0) {
		/* solve a linear equation */
		if (b != 0.0) c = - c / b;
		else c = -1.0;
	}
	else {
		if ((a *= 2.0) > 0.0) {
			a = -a;
			b = -b;
			c = -c;
		}
		if ((c = b * b - 2.0 * a * c) > 0.0) {
			c = sqrt(c);
			if ((d = c-b) < 0.0) c = d / a;
			else c = (-b - c) / a;
		}
	}

	return(c);
}

