/* shmem.h 15.1 06/08/90 10:07:21 */

/*

	Copyright (c) 1986 	Chris Guthrie

Permission to use, copy, modify, and distribute this
software and its documentation for any purpose and without
fee is hereby granted, provided that the above copyright
notice appear in all copies and that both that copyright
notice and this permission notice appear in supporting
documentation.  No representations are made about the
suitability of this software for any purpose.  It is
provided "as is" without express or implied warranty.

*/

/* Major overhaul by Daryl Poe.
 *
 * Copyright (c) 1989 Daryl Poe
 *
 * Ported to X11 by Jim Andreas.
 * Tractors, treaties, and other features by Norm Gee.
 * Damage window and shield bitmaps by Tom LaStrange.
 *
 * The above comments apply to this version as well, and this
 * notice must also appear in any copies or follow-ons.
 */

/******************************************************
 * NEED THE FOLLOWING INCLUDE FILES PRECEDING THIS ONE 
 *	 "ship.h"
 *	 "stats.h"
 *	 "player.h"
 *	 "torp.h"
 *	 "status.h"
 *	 "planet.h"
 *	 "phaser.h"
 *	 "message.h"
 *	 "general.h"
 *******************************************************/

/* This is a structure used for objects returned by mouse pointing */

#define PLANETTYPE 0x1
#define PLAYERTYPE 0x2

typedef struct {
    int o_type;
    int o_num;
} OBTYPE;

typedef struct {
	int  w_status;
	char w_login[16];
	char w_monitor[16];
	int  w_pid;
} WATCHER;

typedef struct {
    PLAYER	players[MAXPLAYER];
    TORP	torps[(MAXPLAYER+1) * MAXTORP];
    STATUS	status[1];
	TEAM	team[5];
    PLANET	planets[MAXPLANETS];
    PHASER	phasers[MAXPLAYER * MAXBEAM];
    MCTL	mctl[1];
    MESSAGE	messages[MAXMESSAGE];
	int     mode;	/* bitmask of modes */
	int     mode_fixed_on;
	int		mode_fixed_off; 
	WATCHER watchers[MAXWATCHERS];
	long    game_end_time;  /* time (2) game should be ended */
	char    gamename[256];
	char    nextgame[512];
} MEMORY;

