/* ship.h 15.1 06/08/90 10:07:07 */

/*

	Copyright (c) 1986 	Chris Guthrie

Permission to use, copy, modify, and distribute this
software and its documentation for any purpose and without
fee is hereby granted, provided that the above copyright
notice appear in all copies and that both that copyright
notice and this permission notice appear in supporting
documentation.  No representations are made about the
suitability of this software for any purpose.  It is
provided "as is" without express or implied warranty.

*/

/* Major overhaul by Daryl Poe.
 *
 * Copyright (c) 1989 Daryl Poe
 *
 * Ported to X11 by Jim Andreas.
 * Tractors, treaties, and other features by Norm Gee.
 * Damage window and shield bitmaps by Tom LaStrange.
 *
 * The above comments apply to this version as well, and this
 * notice must also appear in any copies or follow-ons.
 */

#define MAX_SYS_UNIT	50
#define SHIPNAMELEN		40
#define STD_HULL_SIZE	150

typedef struct {
	int item,				/* HULL, DILITHIUM, etc. */
		subitem,			/* torp tube #, for instance */
		current_size,		/* in ktons (hull units) */
		undamaged_size,
		fractional_size,	/* in 1/256's, decrementing from 256 */
		repair_rate,		/* in 1/256's to repair each kton */
		planet_repair_rate;	/* in 1/256's to repair each kton */
} SYSTEM_UNIT;

typedef struct {
	int s_hull;				/* hull size in ktons */
	char s_shipname[SHIPNAMELEN*4];  /* the ship's given name */

	int s_torps;			/* number of torpedo tubes */
    int s_torpspeed;		/* torpedo warp speed */
    int s_torpdamage;		/* damage of full torp */
	int s_torpduration;		/* in 1/10s, +0-3 s random */
	int s_torpreload;     	/* 1/10s to reload a torpedo */
	int s_torpdecay;		/* loss of warhead strength per turn*256 */
    int s_torpcost;			/* decrement to fuel per torp */
	int s_torpclass;		/* PHOTON, MISSILE, etc. */
	char s_torpname[20];	/* "missile", "photon torp", etc. */

	int s_beams;			/* # of beams */
	int s_beamrange;		/* max range of beams */
    int s_beamdamage;		/* 0-range hit with beam */
    int s_beamaccuracy;		/* radius of target beam must pass thru */
	int s_beamreload;     	/* reload time, in 1/10s */
    int s_beamcost;			/* decrement to fuel per beam */
	int s_beamatten;		/* damage -1 per beamatten in range */
	int s_beamclass;		/* PHASER, BLASTER, etc. */
	char s_beamname[20];	/* "phaser", "blaster", etc. */

	int s_sptechmask;		/* special tech items aboard */

	int s_tractor;			/* number of tractor beams */

	int s_engines;			/* # engines */
    int s_maxspeed;			/* maximum warp */
    int s_warpcost;			/* fuel cost per warp per turn */
    int s_turns;			/* t*180/128000 degree turn at warp 1 */
    int s_accint;			/* acceleration (1/1000's of warp) */
    int s_decint;			/* deceleration (1/1000's of warp) */

    int s_recharge;			/* fuel recharge rate halved */
    int s_repair;			/* 1/256's per turn, double if repairing */
    int s_cargo;			/* army/cargo capacity */
	int s_shield[4];   		/* in damage points */
	int s_armor;			/* # ktons devoted to armor */
	int s_hull_str;       	/* in damage points */
    int s_maxfuel;			/* fuel capacity */

	short s_damaged;		/* any system damaged? */
	short s_repairable;		/* any self-repairable system damaged? */
	int s_numsys;			/* # entries in s_system */
	int s_systemsize;		/* sum of # of tons in s_system */
	SYSTEM_UNIT s_system[MAX_SYS_UNIT];
							/* a list of ship's components to damage */
} SHIP;

