/* scores.c 15.1 06/08/90 10:06:59 */

/*

	Copyright (c) 1986 	Chris Guthrie

Permission to use, copy, modify, and distribute this
software and its documentation for any purpose and without
fee is hereby granted, provided that the above copyright
notice appear in all copies and that both that copyright
notice and this permission notice appear in supporting
documentation.  No representations are made about the
suitability of this software for any purpose.  It is
provided "as is" without express or implied warranty.

*/

/* Original code by Daryl Poe.
 *
 * Copyright (c) 1989 Daryl Poe
 *
 * Ported to X11 by Jim Andreas.
 * Tractors, treaties, and other features by Norm Gee.
 * Damage window and shield bitmaps by Tom LaStrange.
 *
 * The above comments apply to this version as well, and this
 * notice must also appear in any copies or follow-ons.
 */

#include <stdio.h>
#include <fcntl.h>
#include <ndir.h>
#include <pwd.h>
#include <time.h>
#include <sys/param.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/file.h>
#include "defs.h"
#include "weapon.h"
#include "system.h"
#include "ship.h"
#include "stats.h"
#include "player.h"
#include "torp.h"
#include "status.h"
#include "planet.h"
#include "phaser.h"
#include "message.h"
#include "shmem.h"
#include "data.h"

extern DIR *opendir();
extern struct direct *readdir();

typedef struct {
	char  name[9];
	int   rtime;
	int   cputime;
	float kills;
	float maxkills;
	int   losses;
	int   entries;
	int   planets;
	float kill_ratio;
	int   games;
	float score;
} MYSTATS;

static char *_version = "@(#) 15.1 06/08/90 scores display program for dtrek";

static int compar(a,b)
MYSTATS *a,*b;
{
	if (a->score < b->score) return(1);
	else if (a->score > b->score) return(-1);
	else if (a->kill_ratio < b->kill_ratio) return(1);
	else if (a->kill_ratio > b->kill_ratio) return(-1);
	else if (a->maxkills < b->maxkills) return(1);
	else if (a->maxkills > b->maxkills) return(-1);
	else return(0);
}


main(argc,argv)
int argc;
char *argv[];
{
	int count,entries,opt,fildes,i;
	struct passwd *buf;
	MYSTATS *msptr,*allstats;
	STATS old;
	DIR *dirp;
	struct direct *dirent;
	char path[MAXPATHLEN];

	construct_filenames();

	while ((opt = getopt(argc,argv,"d:")) != EOF) {
		switch (opt) {
			case ((int) 'd'):
				strcpy(Scoredir,optarg);
				break;
			case ((int) '?'):
				printf("usage: %s [-d scoredir]\n",argv[0]);
				break;
		}
	}

	if ((dirp = opendir(Scoredir)) == NULL) {
		fprintf(stderr,"Cannot open scoredir %s\n",Scoredir);
		exit(1);
	}

	entries = 0;
	dirent = readdir(dirp);
	while (dirent != NULL) {
		if (!SAMESTR(dirent->d_name,".")
				&& !SAMESTR(dirent->d_name,".."))
			++entries;
		dirent = readdir(dirp);
	}

	if (entries == 0) {
		closedir(dirp);
		exit(1);
	}

	if ((allstats = (MYSTATS *) malloc(entries*sizeof(MYSTATS))) 
			== NULL) {
		fprintf(stderr,"could not malloc enough space.  Aborting.\n");
		exit(1);
	}
	msptr = allstats;

	rewinddir(dirp);
	count = 0;
	dirent = readdir(dirp);
	while (dirent != NULL) {
		if (!SAMESTR(dirent->d_name,".")
				&& !SAMESTR(dirent->d_name,"..")) {
			sprintf(path,"%s/%s",Scoredir,dirent->d_name);
			if (((fildes = open(path,O_RDONLY)) != -1)
					&& (read(fildes,(char *) &old,sizeof(STATS))
						== sizeof(STATS))
					&& ((old.st_uid & 0xffff0000)
						== SCORES_MAGIC_NUMBER)) {
				close(fildes);
	
				if ((buf = getpwuid(old.st_uid & 0xffff)) != NULL) {
		
					++count;
					strncpy(msptr->name,buf->pw_name,8);
						msptr->name[8] = '\0';
					msptr->rtime    = old.st_time/60;
					msptr->cputime  = old.st_cpu/60;
					msptr->kills    = old.st_kills;
					msptr->maxkills = old.st_maxkills;
					msptr->losses   = old.st_losses;
					msptr->entries  = old.st_entries;
					msptr->games    = old.st_conqs;
					msptr->planets  = old.st_planets;
					msptr->kill_ratio = old.st_kills
						/ (old.st_losses+0.01);
					msptr->score = 
						(old.st_kills+old.st_planets-old.st_losses) * 100.0
					 	/ (old.st_kills+old.st_planets+old.st_losses+1.0)
					 	+ old.st_maxkills + 100.0;
					msptr->score /= 2.0;
					++msptr;		
					if (count == entries) break;
				}
			}
		}
		dirent = readdir(dirp);
	}
	closedir(dirp);

	if (count == 0) {
		free(allstats);
		exit(0);
	}

	qsort((char *) allstats,(unsigned) count,sizeof(*allstats),compar);

	printf("## --Name-- Rtime CPUtime --Kills- MaxKill Loss Plnts  KillRatio Games Score\n");
	printf("----------------------------------------------------------------------------\n");
	for (msptr=allstats,i=1; i<=count; ++msptr,++i) {
		printf("%2d %-8s %3d:%02d %3d:%02d %8.2f %6.2f %5d %5d %10.3f %3d %7.2f\n",
			i,
			msptr->name,
			msptr->rtime / 60,
			msptr->rtime % 60,
			msptr->cputime / 60,
			msptr->cputime % 60,
			msptr->kills,
			msptr->maxkills,
			msptr->losses,
			msptr->planets,
			msptr->kill_ratio,
			msptr->games,
			msptr->score);
	}

	free(allstats);
}
