/* robot.c 15.1 06/08/90 10:06:55 */

/*

	Copyright (c) 1986 	Chris Guthrie

Permission to use, copy, modify, and distribute this
software and its documentation for any purpose and without
fee is hereby granted, provided that the above copyright
notice appear in all copies and that both that copyright
notice and this permission notice appear in supporting
documentation.  No representations are made about the
suitability of this software for any purpose.  It is
provided "as is" without express or implied warranty.

*/

/* Major overhaul by Daryl Poe.
 *
 * Copyright (c) 1989 Daryl Poe
 *
 * Ported to X11 by Jim Andreas.
 * Tractors, treaties, and other features by Norm Gee.
 * Damage window and shield bitmaps by Tom LaStrange.
 *
 * The above comments apply to this version as well, and this
 * notice must also appear in any copies or follow-ons.
 */

#include <stdio.h>
#include <sys/types.h>
#include <time.h>
#include <signal.h>
#include <setjmp.h>
#include <pwd.h>
#include "defs.h"
#include "weapon.h"
#include "system.h"
#include "ship.h"
#include "stats.h"
#include "player.h"
#include "torp.h"
#include "status.h"
#include "planet.h"
#include "phaser.h"
#include "message.h"
#include "shmem.h"
#include "data.h"

struct itimerval udt;
int redrawall;
int lastm;

/* lots of neat flags */
int swar_mask;
int level;
int fleet;
int sticky;
int berserk;
int practice;
PLAYER *last_target;
int attack_speed;
int offense;
int beam_impatience;
int torp_impatience;
int orbiter;
int starbase;
int tractor_str; /* strength I'm being tractored */
int friendly_tractor; /* is a teammate towing me? */
int patrol_planet;
int want_buddy;

static int orbit_planet;
static int enemy_no,is_monitor,is_planetkiller;
static char *_version = "@(#) 15.1 06/08/90 robot ship controller for dtrek";

#define NOTEAM 		(-1)
#define CREATOR		"poe"
#ifndef XTREK_OWNER
#define XTREK_OWNER	"daemon"
#endif

/* make sure some bozo hasn't started the process */
static void checkuser()
{
	struct passwd *pw;

	/* root? */
	if (getuid() == 0) return;

	/* Was this spawned by dtrek or the daemon? */
	pw = getpwuid(getuid());
	if (pw != NULL)
		if (strcmp(pw->pw_name,XTREK_OWNER) == 0) return;

	/* Was it started by "the creator"? :-)  */ 
	if (pw != NULL)
		if (strcmp(pw->pw_name,CREATOR) == 0) return;

	fprintf(stderr,"You are not authorized to start robots.\n");
	exit(1);
}

void read_dtrek_mode_file()
{
	/* a stub */
}


static int suicide()
{
	logflush();
	/* Yep, it's dead.  Abort */
	me->p_status = PFREE;
	me->p_ntorp = 0;
	exit(0);
}


static int daemondead()
{
	int curupdate;

	logmsg1("received signal indicating daemon died.  Checking\n");
	/* Have received SIGUSR1, usually indicating the daemon
	 * has died.  Make sure.
	 */
	curupdate = me->p_updates;
	sleep(2);
	if (curupdate == me->p_updates) {
		logmsg1("daemon is dead.  Aborting.\n");
		suicide();    /* This will exit */
	}

	/* If here, the signal must be erroneous.
	 * Continue running.
	 */
}		


static PLANET *return_myhome(myhome)
PLANET *myhome;
{
	int tmp;

	if (orbiter) return(&planets[orbit_planet]);

	if ((enemy_no == -1)
			|| (players[enemy_no].p_status != PALIVE)) {
		if (myhome == NULL) {
			patrol_planet = INTRAND(MAXPLANETS);
			return(&planets[patrol_planet]);
		}
		else {
			patrol_planet = myhome->pl_no;
			return(myhome);
		}
	}
	else {
		patrol_planet = closest_planet_dist(
			players[enemy_no].p_x, players[enemy_no].p_y,
			&tmp, TARG_PLANET|TARG_MEOWNER, 0);
		if (patrol_planet == -1) patrol_planet = INTRAND(MAXPLANETS);
		return(&planets[patrol_planet]);
	}
}


main(argc, argv)
int argc;
char **argv;
{
	register int i;
	int thisteam=NOTEAM,real_team;
	int teammask;
	int player_no;
	int hull_size = -1;
	char *whichship = "RANDOM";

	checkuser();

	construct_filenames();

	OPEN_LOGFILE(Rlogfilename);

	enemy_no = orbit_planet -1;
	orbiter = want_buddy = is_monitor = is_planetkiller = FALSE;
	patrol_planet = 0;

	seedrandom();
	offense = 100 - (INTRAND(10)*INTRAND(10));
	torp_impatience = beam_impatience =  20 + INTRAND(80);

	logmsg1("\n\nROBOT STARTING\n\n");
	mysignal(SIGUSR1, daemondead);

	for( ; argc>1 && argv[1][0]=='-'; argc--,argv++) {
		logmsg2("argv: %s\n",argv[1]);
		switch(argv[1][1]) {
		case 'f':
			fleet++;
			break;
		case 's':
			sticky++;
			break;
		case 'S':
			sleep((unsigned long) atoi(&argv[1][2]));
			break;
		case 'h':
			swar_mask++;
			break;
		case 'p':
			offense = 80;
			practice++;
			break;
		case 'b':
			offense = 100;
			berserk++;
			break;
		case 'B':
			want_buddy = TRUE;
			break;
		case 'n':
			/* a particular ship */
			whichship = &argv[1][2];
			break;
		case 'm':
			/* a monitor */
			is_monitor = TRUE;
			break;
		case 'K':
			/* a monitor */
			is_planetkiller = TRUE;
			break;
		case 'e':
			/* who caused me to appear */
			if (argv[1][2] != '\0') {
				enemy_no = atoi(&argv[1][2]);
			}
			break;
		case 'l':
			if (argv[1][2] != NULL)
				level = atoi(&argv[1][2]);
			else
				level = 0;
			break;
		case 'P':  /* starting location */
			orbit_planet = atoi(&argv[1][2]);
			break;
		case 'H':	/* hull size */
			hull_size = atoi(&argv[1][2]);
			break;
		case 'T':
			switch (argv[1][2]) {
			case 'f':
				thisteam = FEDERATION;
				teammask = FED_MASK;
				break;
			case 'r':
				thisteam = ROMULAN;
				teammask = ROM_MASK;
				break;
			case 'k':
				thisteam = KLINGON;
				teammask = KLI_MASK;
				break;
			case 'o':
				thisteam = ORION;
				teammask = ORI_MASK;
				break;
			case 'i':
				thisteam = INDEPENDENT;
				teammask = IND_MASK;
				fleet++;
				torp_impatience += 30;
				beam_impatience += 30;
				break;
			case 'j':
				thisteam = JUGGERNAUT;
				teammask = IND_MASK;
				fleet++;
				break;
			default:
				fprintf(stderr, "Unknown team type.  Usage -Tx where x is [frko]\n");
				exit(1);
			}
			break;
		default:
			fprintf(stderr, "Unknown option '%c'\n", argv[1][1]);
			exit(1);
		}


	}
	if (thisteam == NOTEAM) {
		thisteam = INTRAND(4)+1;
		teammask = two_to[thisteam];
		logmsg2("Random team chosen: %d\n",thisteam);
	}

	/* don't let all this stuff take *too* long */
	mysignal(SIGALRM,suicide);
	alarm(10*60);  /* ten minutes */

	openmem(FALSE);

	if (enemy_no == -1) last_target = NULL;
	else {
		last_target = players + enemy_no;
		if (last_target->p_status != PALIVE) {
			last_target = NULL;
		}
	}
	player_no = findslot();
	me = &players[player_no];
	myship = &me->p_ship;
	mystats = &me->p_stats;
	lastm = mctl->mc_current;

	/* At this point we have memory set up.  If we aren't a fleet,
	 * we don't want to replace any other robots on this team, so
	 * we'll check the other players and get out if there are any 
	 * on our team.  Don't count stationary bases.
     */
	if (!fleet) {
		for (i = 0; i < MAXPLAYER; i++) {
			if ((players[i].p_status == PALIVE)
					&& (players[i].p_team_mask == teammask)
					&& (players[i].p_ship.s_maxspeed > 0)) {
				logmsg2("%d: Galaxy already defended\n",me->p_no);
				players[player_no].p_status = PFREE;
				exit(1);
			}
		}
	}
	if (hull_size <= 0) {
		if (strcmp(whichship,"RANDOM") == 0) {
			if ((thisteam == INDEPENDENT) || (thisteam == JUGGERNAUT)) {
				if (level == 0) {
					hull_size = 125 + 25*INTRAND(6);
				}
				else {
					hull_size = 250;
				}
			}
			else hull_size = compute_hull_size(thisteam);
		}
		else hull_size = 999;   /* no practical limit */
	}		

	if (is_monitor) {
		real_team = thisteam;
		thisteam  = MONITOR;
		whichship = "RANDOM";
	}
	else if (is_planetkiller) {
		real_team = INDEPENDENT;
		thisteam  = PLANETKILLER;
		want_buddy = FALSE;
		whichship = "RANDOM";
	}
	else if (thisteam == JUGGERNAUT) {
		real_team = INDEPENDENT;
	}
	else {
		real_team = thisteam;
	}

	/**** ENTER ****/
	enter(thisteam,real_team,"Nowhere",hull_size,
		player_no,TRUE,whichship,return_myhome);

	if (myship->s_maxspeed == 0) {
		orbiter = TRUE;
		if (strncmp(whichship,"Starbase",8) == 0) starbase = TRUE;
		else starbase = FALSE;
	}
	else {
		if (INTRAND(100) < 50) want_buddy = TRUE;
	}

	switch (thisteam) {
		case INDEPENDENT: 
			attack_speed = 2;
			break;
		case FEDERATION: /* FED */
			attack_speed = 7;
			break;
		case ROMULAN: /* ROM */
			attack_speed = 5;
			break;
		case KLINGON: /* KLI */
			attack_speed = 4;
			break;
		case ORION: /* ORI */
			attack_speed = 9;
			break;
		case JUGGERNAUT: /* JUGGER */
			thisteam = INDEPENDENT;
			if (myship->s_maxspeed > 6) {
				attack_speed = myship->s_maxspeed - 2;
			}
			else {
				attack_speed = myship->s_maxspeed;
			}
			offense += 10;
			break;
		case MONITOR:
			thisteam = INDEPENDENT;
			strcpy(myship->s_shipname,"Monitor");
			attack_speed = 1;
			break;
		case PLANETKILLER: 
			thisteam = INDEPENDENT;
			want_buddy = FALSE;
			strcpy(myship->s_shipname,"Planetkiller");
			attack_speed = 4;
			offense = 50;
			torp_impatience = 10;
			beam_impatience = 100;
			break;
	}

	if (myship->s_torps > 0) {
		switch (myship->s_torpclass) {
			case WPN_PLASMA:
				torp_impatience -= 30;
				break;
			case WPN_MISSILE:
				torp_impatience += 40;
				break;
			case WPN_CHAFF:
				attack_speed = myship->s_maxspeed;
				break;
		}
	}

	if (myship->s_beams > 0) {
		switch (myship->s_beamclass) {
			case WPN_PHASER:
			case WPN_FUSION:
				beam_impatience -= 40;
				break;
			/* case WPN_DISRUPTER: */
			case WPN_TACHYON:
				beam_impatience += 100;
				break;
		}
	}

	if (orbiter) {
		offense = 100;
		torp_impatience = 100;
		beam_impatience = 100;
		/* don't log orbiters */
		fclose(logfile);
		logfile = fopen("/dev/null","w");
	}
	else {
		if (offense > 100) offense = 100;
		else if (offense < 10) offense = 10;
		if (torp_impatience > 100) torp_impatience = 100;
		else if (torp_impatience < 50) torp_impatience = 50;
		if (beam_impatience > 100) beam_impatience = 100;
		else if (beam_impatience < 50) beam_impatience = 50;
	}

	logmsg3("%d: Starting robot %d, ",me->p_no,me->p_no);
	logmsg5(" offense %d, torp_impatience %d, beam_impatience %d, team %d.\n",offense,torp_impatience,beam_impatience,thisteam);
	logmsg4(" torps: %d, torpspeed %d, torpdur %d\n",myship->s_torps,myship->s_torpspeed,myship->s_torpduration);
	logmsg3(" beams: %d, beamrange: %d\n",myship->s_beams,myship->s_beamrange);

	if (orbiter) {
		/* orbit a planet */
		me->p_x = planets[orbit_planet].pl_x;
		me->p_y = planets[orbit_planet].pl_y;
		me->p_flags |= PFORBIT;
		me->p_planet = orbit_planet;
	}

	mysignal(SIGALRM, rmove);
	me->p_flags |= PFROBOT;			/* Mark as a robot */
	if (is_monitor) me->p_flags |= PFMONITOR;
	else if (is_planetkiller) {
		me->p_flags |= PFPLKILLER;
		me->p_hostile_mask = ALL_MASK;
	}
	if (practice) {
		me->p_hostile_mask = ALL_MASK;
		me->p_flags |= PFPRACTR;		/* Mark as a practice robot */
		strncpy(me->p_name, "Hoser", strlen("Hoser"));
		me->p_name[strlen("Hoser")] = NULL;
	}
	else {
		strcpy(me->p_name, myship->s_shipname);
	}
	strcpy(me->p_login, "Robot");

	if (last_target == NULL) {
		last_target = me;
		me->p_treaty_mask = ALL_MASK;
		me->p_ally_mask   = ALL_MASK;
		logmsg3("generic treaty mask: %x, ally mask %x\n",
			me->p_treaty_mask,me->p_ally_mask);
	}
	else {
		me->p_treaty_mask = ALL_MASK & ~(last_target->p_team_mask);
		me->p_ally_mask   = ALL_MASK & ~(last_target->p_team_mask);
		logmsg4("enemy-modified treaty mask: %x, ally mask %x, hismask %x\n",
			me->p_treaty_mask,me->p_ally_mask,last_target->p_team_mask);
	}
	fflush(logfile);

	{
		char buf[256],addrbuf[80];

		sprintf(buf, "%s (%s) entering game in about 5 seconds",
		    	me->p_name, me->p_mapchars);
		sprintf(addrbuf, " %s->ALL",me->p_mapchars);
		pmessage(buf, 0, MALL, addrbuf);
		sleep(5);
	}

	if (practice) {
		udt.it_interval.tv_sec = 1;		/* Robots get to move 1/sec */
		udt.it_interval.tv_usec = 000000;
	}
	else {
		udt.it_interval.tv_sec = 0;		/* Robots get to move 2/sec */
		udt.it_interval.tv_usec = 500000;
	}
	udt.it_value.tv_sec = 1;
	udt.it_value.tv_usec = 0;
	if (setitimer(ITIMER_REAL, &udt, (struct itimerval *) NULL) < 0) {
		perror("setitimer");
		me->p_status = PFREE;		/* Put robot in game */
		exit(1);
	}
	/* allows robots to be forked by the daemon -- Evil ultrix bullshit */
	sigsetmask(0);

	me->p_status = PALIVE;		/* Put robot in game */
	while (1) {
		pause();
	}
}

void warning(mess)
int mess;
{
	logmsg3("%d: Warning received: %s\n",me->p_no,mess);
}
