/* repair.c 15.1 06/08/90 10:06:41 */

/* Original code by Daryl Poe.
 *
 * Copyright (c) 1989 Daryl Poe
 *
 * Ported to X11 by Jim Andreas.
 * Tractors, treaties, and other features by Norm Gee.
 * Damage window and shield bitmaps by Tom LaStrange.
 *
 * Permission to use, copy, modify, and distribute this
 * software and its documentation for any purpose and without
 * fee is hereby granted, provided that the above copyright
 * notice appear in all copies and that both that copyright
 * notice and this permission notice appear in supporting
 * documentation.  No representations are made about the
 * suitability of this software for any purpose.  It is
 * provided "as is" without express or implied warranty.
 */

#include <stdio.h>
#include "defs.h"
#include "weapon.h"
#include "system.h"
#include "ship.h"
#include "stats.h"
#include "player.h"
#include "torp.h"
#include "status.h"
#include "planet.h"
#include "phaser.h"
#include "message.h"
#include "shmem.h"
#include "data.h"

void repair_player(player)
PLAYER *player;
{
	SYSTEM_UNIT *sysunitptr;
	short sysdamaged,at_repair_base;
	int incr,rpr,repair_shift,tmp;
	SHIP *ship;

	if (player->p_status != PALIVE) return;
	ship = &player->p_ship;

	logmsg4("repair: player %d; damaged? %d; repairable? %d",player->p_no,ship->s_damaged,ship->s_repairable);
	logmsg2("  systemsize: %d\n",ship->s_systemsize);

	if ((player->p_flags & PFREPAIR) && (player->p_speed==0)) {
		repair_shift = 1;
		at_repair_base = FALSE;
		if (player->p_flags & PFORBIT)
			if (planets[player->p_planet].pl_flags & PLMASK_REPAIR)
				if (!(planets[player->p_planet].pl_owner_mask &
						(player->p_hostile_mask))) {
					at_repair_base = TRUE;	
				}
	}
	else {
		repair_shift = 0;
		at_repair_base = FALSE;
	}

	logmsg4("repair:  value %d, shift %d, at base? %d\n",ship->s_repair << repair_shift,repair_shift,at_repair_base);

	if ((at_repair_base && ship->s_damaged)
			|| ship->s_repairable) {
		ship->s_damaged = ship->s_repairable = FALSE;
		for (sysunitptr = ship->s_system;
				sysunitptr<ship->s_system+ship->s_numsys; ++sysunitptr) {
			if (sysunitptr->current_size != sysunitptr->undamaged_size) {
				/* system is damaged */
				rpr = sysunitptr->repair_rate << repair_shift;
				if (at_repair_base)
					 rpr += sysunitptr->planet_repair_rate;
				logmsg3("repair: item %d, frac. rpr: %d\n",sysunitptr->item,rpr);
				/* if no repair, continue */
				if (rpr == 0) {
					ship->s_damaged = TRUE;
					if (sysunitptr->repair_rate)
						ship->s_repairable = TRUE;
					continue;
				}
	
				sysunitptr->fractional_size += rpr;
				if (incr = sysunitptr->fractional_size >> 8)
					sysunitptr->fractional_size &= 0x0ff;

				if ((tmp = sysunitptr->undamaged_size
						- sysunitptr->current_size) <= incr) {
					incr = tmp;
					sysunitptr->fractional_size = 0;
					sysdamaged = FALSE;
				}
				else {
					sysdamaged = TRUE;
				}

				logmsg4("repair: item %d undamaged size %d currently %d\n",sysunitptr->item,sysunitptr->undamaged_size,sysunitptr->current_size);
				logmsg3("repair: item %d by %d\n",sysunitptr->item,incr);
				if ((sysunitptr->item != ARMOR)
						&& (sysunitptr->item != HULL))
					ship->s_systemsize += incr;
				sysunitptr->current_size += incr;
	
				if (incr) switch (sysunitptr->item) {
					case ARMOR:
						logmsg1("repair: armor.  s_armor\n");
						ship->s_armor += incr;
						break;
					case HULL:
						logmsg1("repair: hull.  nothing special\n");
						break;
					case ENGINE:
						/* improve acceleration, etc.
						 *	(if there ever was any)
						 */
						logmsg1("repair: engine.  p_engine_health\n");
						if (sysunitptr->undamaged_size)
							player->p_engine_health =
								sysunitptr->current_size * 
								256 / sysunitptr->undamaged_size;
						break;
					case FUEL:
						logmsg1("repair: fuel.  s_maxfuel\n");
						ship->s_maxfuel += 500 * incr;
						break;
					case BEAM_NUM:
						logmsg1("repair: beam\n");
						if (!sysdamaged) {
							logmsg1("repair: fixed beam\n");
							++ship->s_beams;
						}
						break;
					case CLOAK:
						logmsg1("repair: cloak\n");
						if (!sysdamaged) {
							logmsg1("repair: fixed cloak\n");
							ship->s_sptechmask |= 
								STMASK_CLOAK;
						}		
						break;
					case IMP_SENS:
						logmsg1("repair: sens\n");
						if (!sysdamaged) {
							logmsg1("repair: fixed sens\n");
							ship->s_sptechmask |= 
								STMASK_IMP_SENS;
						}		
						break;
					case ECM:
						logmsg1("repair: ecm\n");
						if (!sysdamaged) {
							logmsg1("repair: fixed ecm\n");
							ship->s_sptechmask |= 
								STMASK_ECM;
						}		
						break;
					case HYPERSPACE:
						logmsg1("repair: hyperspace\n");
						if (!sysdamaged) {
							logmsg1("repair: fixed hyperspace\n");
							ship->s_sptechmask |= 
								STMASK_HYPERSPACE;
						}		
						break;
					case SPHERE:
						logmsg1("repair: sphere\n");
						if (!sysdamaged) {
							logmsg1("repair: fixed sphere\n");
							ship->s_sptechmask |= 
								STMASK_SPHERE;
						}		
						break;
					case AFC:
						logmsg1("repair: afc\n");
						if (!sysdamaged) {
							logmsg1("repair: fixed afc\n");
							ship->s_sptechmask |= 
								STMASK_AFC;
						}		
						break;
					case DAMAGE_ABS:
						logmsg1("repair: damage_abs\n");
						if (!sysdamaged) {
							logmsg1("repair: fixed damage_abs\n");
							ship->s_sptechmask |= 
								STMASK_DAMAGE_ABS;
						}		
						break;
					case TORP_NUM:
						logmsg1("repair: torp\n");
						if ( ship->s_torpclass != WPN_PLASMA )
						if (!sysdamaged) {
							logmsg1("repair: fixed torp\n");
							++ship->s_torps;
						}		
						break;
					case TRACTOR_BEAM:
						logmsg1("repair: tractor\n");
						if (!sysdamaged) {
							logmsg1("repair: fixed tractor\n");
							++ship->s_tractor;
						}		
						break;
					case DILITHIUM:
						logmsg1("repair: dilithium.  s_recharge.\n");
						ship->s_recharge += incr;
						break;
					case CARGO:
						logmsg1("repair: cargo.  s_cargo.\n");
						ship->s_cargo += incr;
						break;
					default:
						logmsg2("ERROR: repair not complete for system %d\n",sysunitptr->item);
						break;
				}
	
				if (sysdamaged) {
					ship->s_damaged = TRUE;
					if (sysunitptr->repair_rate)
						 ship->s_repairable = TRUE;
				}
			}
		}
	}

	rpr = ship->s_repair << (repair_shift+1);
	if (at_repair_base) rpr <<= 1;

	player->p_subshield += rpr;
	if (player->p_subshield & 0x0ff00) {
		rpr = player->p_subshield >> 8;
		logmsg2("repair:  repairing shields by %d\n",rpr);
		player->p_subshield &= 0x0ff;
		for (tmp=0; tmp<4; ++tmp) {
			if (player->p_shield[tmp] < ship->s_shield[tmp])
				if ((player->p_shield[tmp] += rpr) > ship->s_shield[tmp])
					player->p_shield[tmp] = ship->s_shield[tmp];
		}
	}
	logmsg2("repair done: systemsize is %d\n",ship->s_systemsize);
}

