/* redraw.c 15.1 06/08/90 10:06:32 */
/*

		Copyright (c) 1986		Chris Guthrie

Permission to use, copy, modify, and distribute this
software and its documentation for any purpose and without
fee is hereby granted, provided that the above copyright
notice appear in all copies and that both that copyright
notice and this permission notice appear in supporting
documentation.	No representations are made about the
suitability of this software for any purpose.  It is
provided "as is" without express or implied warranty.

*/

/* Major overhaul by Daryl Poe.
 *
 * Copyright (c) 1989 Daryl Poe
 *
 * Ported to X11 by Jim Andreas.
 * Tractors, treaties, and other features by Norm Gee.
 * Damage window and shield bitmaps by Tom LaStrange.
 *
 * The above comments apply to this version as well, and this
 * notice must also appear in any copies or follow-ons.
 */

#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <stdio.h>
#include "defs.h"
#include "weapon.h"
#include "system.h"
#include "ship.h"
#include "stats.h"
#include "player.h"
#include "torp.h"
#include "status.h"
#include "planet.h"
#include "phaser.h"
#include "message.h"
#include "shmem.h"
#include "bitmaps.h"
#include "data.h"
#include "xdata.h"
#include "daemon.h"

#define TACHYON_WIDTH 		3
#define MINEREDRAW			6
#define PULSAR_BLANKING 	8
#define NUM_ASTEROID_IMAGES	8


/* For map window */
static XRectangle mclearzone[MAXPLAYER + MAXPLANETS];
static XRectangle *mczp;
#define MCLEAR(X, Y, W, H) \
{ \
	mczp->x = (X); \
	mczp->y = (Y); \
	mczp->width = (W); \
	mczp++->height = (H); \
	mclearcount++; \
}
static int mclearcount=0;

static char *shipnos = "0123456789abcdefghijklmnopqrstuvwxyz";
static short nplayers;

XImage	image;
XImage  ship_image = {
    ship_width, ship_height, 0, XYBitmap, (char *)0,
    LSBFirst, 16, LSBFirst, 0, 1, 2, 1,
    0, 0, 0, (char *)0, 0, 0, 0, 0, 0, 0};
XImage  immune_image = {
    ship_width, ship_height, 0, XYBitmap, (char *)immune_bits,
    LSBFirst, 16, LSBFirst, 0, 1, 2, 1,
    0, 0, 0, (char *)0, 0, 0, 0, 0, 0, 0};
XImage  sphere_image = {
    ship_width, ship_height, 0, XYBitmap, (char *)sphere_bits,
    LSBFirst, 16, LSBFirst, 0, 1, 2, 1,
    0, 0, 0, (char *)0, 0, 0, 0, 0, 0, 0};
XImage  ex_image = {
    ex_width, ex_height, 0, XYBitmap, (char *)0,
    MSBFirst, 16, LSBFirst, 0, 1, 8, 1,
    0, 0, 0, (char *)0, 0, 0, 0, 0, 0, 0};

XImage  pvortex_image = {
    pvortex_width, pvortex_height, 0, XYBitmap, (char *)0,
    LSBFirst, 16, LSBFirst, 0, 1, 2, 1,
    0, 0, 0, (char *)0, 0, 0, 0, 0, 0, 0};

XImage planet_image[5] = {
	{
    planet_width, planet_height, 0, XYBitmap, (char *)bplanet_bits,
    LSBFirst, 16, LSBFirst, 0, 1, 4, 1,
    0, 0, 0, (char *)0, 0, 0, 0, 0, 0, 0
	}, {
    planet_width, planet_height, 0, XYBitmap, (char *)bfplanet_bits,
    LSBFirst, 16, LSBFirst, 0, 1, 4, 1,
    0, 0, 0, (char *)0, 0, 0, 0, 0, 0, 0
	}, {
    planet_width, planet_height, 0, XYBitmap, (char *)brplanet_bits,
    LSBFirst, 16, LSBFirst, 0, 1, 4, 1,
    0, 0, 0, (char *)0, 0, 0, 0, 0, 0, 0
	}, {
    planet_width, planet_height, 0, XYBitmap, (char *)bkplanet_bits,
    LSBFirst, 16, LSBFirst, 0, 1, 4, 1,
    0, 0, 0, (char *)0, 0, 0, 0, 0, 0, 0
	}, {
    planet_width, planet_height, 0, XYBitmap, (char *)boplanet_bits,
    LSBFirst, 16, LSBFirst, 0, 1, 4, 1,
    0, 0, 0, (char *)0, 0, 0, 0, 0, 0, 0
	} 
};
XImage  bplanet_image = {
    planet_width, planet_height, 0, XYBitmap, (char *)bbplanet_bits,
    LSBFirst, 16, LSBFirst, 0, 1, 4, 1,
    0, 0, 0, (char *)0, 0, 0, 0, 0, 0, 0};
XImage  pulsar_image = {
    planet_width, planet_height, 0, XYBitmap, (char *)0,
    LSBFirst, 16, LSBFirst, 0, 1, 4, 1,
    0, 0, 0, (char *)0, 0, 0, 0, 0, 0, 0};
XImage  blackhole_image = {
    blackhole_width, blackhole_height, 0, XYBitmap, (char *)0,
    LSBFirst, 16, LSBFirst, 0, 1, 2, 1,
    0, 0, 0, (char *)0, 0, 0, 0, 0, 0, 0};

XImage mplanet_image[5] = {
	{
    mplanet_width, mplanet_height, 0, XYBitmap, (char *)mbplanet_bits,
    LSBFirst, 16, LSBFirst, 0, 1, 2, 1,
    0, 0, 0, (char *)0, 0, 0, 0, 0, 0, 0
	}, {
    mplanet_width, mplanet_height, 0, XYBitmap, (char *)mbfplanet_bits,
    LSBFirst, 16, LSBFirst, 0, 1, 2, 1,
    0, 0, 0, (char *)0, 0, 0, 0, 0, 0, 0
	}, {
    mplanet_width, mplanet_height, 0, XYBitmap, (char *)mbrplanet_bits,
    LSBFirst, 16, LSBFirst, 0, 1, 2, 1,
    0, 0, 0, (char *)0, 0, 0, 0, 0, 0, 0
	}, {
    mplanet_width, mplanet_height, 0, XYBitmap, (char *)mbkplanet_bits,
    LSBFirst, 16, LSBFirst, 0, 1, 2, 1,
    0, 0, 0, (char *)0, 0, 0, 0, 0, 0, 0
	}, {
    mplanet_width, mplanet_height, 0, XYBitmap, (char *)mboplanet_bits,
    LSBFirst, 16, LSBFirst, 0, 1, 2, 1,
    0, 0, 0, (char *)0, 0, 0, 0, 0, 0, 0
	}
};
XImage  mbplanet_image = {
    mplanet_width, mplanet_height, 0, XYBitmap, (char *)mbbplanet_bits,
    LSBFirst, 16, LSBFirst, 0, 1, 2, 1,
    0, 0, 0, (char *)0, 0, 0, 0, 0, 0, 0};
XImage  mpulsar_image = {
    mplanet_width, mplanet_height, 0, XYBitmap, (char *)mbpulsar_bits,
    LSBFirst, 16, LSBFirst, 0, 1, 2, 1,
    0, 0, 0, (char *)0, 0, 0, 0, 0, 0, 0};
XImage  mblackhole_image = {
    mplanet_width, mplanet_height, 0, XYBitmap, (char *)mbblackhole_bits,
    LSBFirst, 16, LSBFirst, 0, 1, 2, 1,
    0, 0, 0, (char *)0, 0, 0, 0, 0, 0, 0};
XImage  mnebula_image = {
    mbnebula_width, mbnebula_height, 0, XYBitmap, (char *)mbnebula_bits,
    LSBFirst, 16, LSBFirst, 0, 1, 6, 1,
    0, 0, 0, (char *)0, 0, 0, 0, 0, 0, 0};
XImage  mast_field_image = {
    mast_field_width, mast_field_height, 0, XYBitmap, (char *)mast_field_bits,
    LSBFirst, 16, LSBFirst, 0, 1, 4, 1,
    0, 0, 0, (char *)0, 0, 0, 0, 0, 0, 0};

XImage  cloud_image = {
    cloud_width, cloud_height, 0, XYBitmap, (char *)cloud_bits,
    MSBFirst, 16, LSBFirst, 0, 1, 2, 1,
    0, 0, 0, (char *)0, 0, 0, 0, 0, 0, 0};
XImage  photon_image = {
    photon_width, photon_height, 0, XYBitmap, (char *)photon_bits,
    MSBFirst, 16, LSBFirst, 0, 1, 2, 1,
    0, 0, 0, (char *)0, 0, 0, 0, 0, 0, 0};
XImage  plasma_image = {
    plasma_width, plasma_height, 0, XYBitmap, (char *)0,
    LSBFirst, 16, LSBFirst, 0, 1, 2, 1,
    0, 0, 0, (char *)0, 0, 0, 0, 0, 0, 0};
XImage  backlash_image = {
    bklsh_width, bklsh_height, 0, XYBitmap, (char *)0,
    LSBFirst, 16, LSBFirst, 0, 1, 1, 1,
    0, 0, 0, (char *)0, 0, 0, 0, 0, 0, 0};
XImage  missile_image = {
    missile_width, missile_height, 0, XYBitmap, (char *)0,
    LSBFirst, 16, LSBFirst, 0, 1, 1, 1,
    0, 0, 0, (char *)0, 0, 0, 0, 0, 0, 0};
XImage  chaff_image = {
    chaff_width, chaff_height, 0, XYBitmap, (char *)0,
    LSBFirst, 16, LSBFirst, 0, 1, 3, 1,
    0, 0, 0, (char *)0, 0, 0, 0, 0, 0, 0};
XImage  mine_image = {
    mine_width, mine_height, 0, XYBitmap, (char *) mine_bits,
    LSBFirst, 16, LSBFirst, 0, 1, 2, 1,
    0, 0, 0, (char *)0, 0, 0, 0, 0, 0, 0};

XImage  wlock_image = {
    lock_width, lock_height, 0, XYBitmap, (char *) wlock_bits,
    LSBFirst, 16, LSBFirst, 0, 1, 4, 1,
    0, 0, 0, (char *)0, 0, 0, 0, 0, 0, 0};
XImage  nlock_image = {
    lock_width, lock_height, 0, XYBitmap, (char *) nlock_bits,
    LSBFirst, 16, LSBFirst, 0, 1, 4, 1,
    0, 0, 0, (char *)0, 0, 0, 0, 0, 0, 0};

/* fast foreground/background switching macros */
#define FOREGROUND(fg) 						\
{ 											\
	register unsigned long _color;			\
 											\
	_color = fg;	 						\
	if (_color != lastFG) { 				\
		XSetForeground(dpy, gc, _color); 	\
		lastFG = _color; 					\
	} 										\
}

#define BACKGROUND(bg) 						\
{ 											\
	register unsigned long _color;			\
 											\
	_color = bg;	 						\
	if (_color != lastBG) { 				\
		XSetBackground(dpy, gc, _color); 	\
		lastBG = _color; 					\
	} 										\
}

#define XFUNCTION(function) 				\
{ 											\
	if (function != lastFunction) { 		\
		XSetFunction(dpy, gc, function);	\
		lastFunction = function;			\
	} 										\
}

#define LINESTYLEWIDTH(style,width)							\
{															\
	XGCValues xgcv;											\
															\
	xgcv.line_style = style;								\
	xgcv.line_width = width;								\
	if ((xgcv.line_width != lastLineWidth)					\
			|| (xgcv.line_style != lastLineStyle)) {		\
		XChangeGC(dpy,gc,(GCLineWidth|GCLineStyle),&xgcv);	\
		lastLineStyle = xgcv.line_style;					\
		lastLineWidth = xgcv.line_width;					\
	}														\
}


static void draw_ast_field(xc,yc)
int xc,yc;
{
	static XImage ast_image[NUM_ASTEROID_IMAGES] = {
		{ ast_width, ast_height, 0, XYBitmap,
			(char *) ast0_bits,
	    	LSBFirst, 16, LSBFirst, 0, 1, 1, 1,
	    	0, 0, 0, (char *)0, 0, 0, 0, 0, 0, 0 },
		{ ast_width, ast_height, 0, XYBitmap,
			(char *) ast1_bits,
	    	LSBFirst, 16, LSBFirst, 0, 1, 1, 1,
	    	0, 0, 0, (char *)0, 0, 0, 0, 0, 0, 0},
		{ ast_width, ast_height, 0, XYBitmap, 
			(char *) ast2_bits,
	    	LSBFirst, 16, LSBFirst, 0, 1, 1, 1,
	    	0, 0, 0, (char *)0, 0, 0, 0, 0, 0, 0},
		{ ast_width, ast_height, 0, XYBitmap, 
			(char *) ast3_bits,
	    	LSBFirst, 16, LSBFirst, 0, 1, 1, 1,
	    	0, 0, 0, (char *)0, 0, 0, 0, 0, 0, 0},
		{ ast_width, ast_height, 0, XYBitmap, 
			(char *) ast4_bits,
	    	LSBFirst, 16, LSBFirst, 0, 1, 1, 1,
	    	0, 0, 0, (char *)0, 0, 0, 0, 0, 0, 0},
		{ ast_width, ast_height, 0, XYBitmap, 
			(char *) ast5_bits,
	    	LSBFirst, 16, LSBFirst, 0, 1, 1, 1,
	    	0, 0, 0, (char *)0, 0, 0, 0, 0, 0, 0},
		{ ast_width, ast_height, 0, XYBitmap, 
			(char *) ast6_bits,
	    	LSBFirst, 16, LSBFirst, 0, 1, 1, 1,
	    	0, 0, 0, (char *)0, 0, 0, 0, 0, 0, 0},
		{ ast_width, ast_height, 0, XYBitmap, 
			(char *) ast7_bits,
	    	LSBFirst, 16, LSBFirst, 0, 1, 1, 1,
	    	0, 0, 0, (char *)0, 0, 0, 0, 0, 0, 0},
	};
	static ast_x[NUM_ASTEROID_IMAGES] = {
		0,	(AST_FIELD_RADIUS/SCALE), -(AST_FIELD_RADIUS/SCALE), 0,
		0,	(AST_FIELD_RADIUS/SCALE), -(AST_FIELD_RADIUS/SCALE), 0,
	};
	static ast_y[NUM_ASTEROID_IMAGES] = {
		0,	(AST_FIELD_RADIUS/SCALE), -(AST_FIELD_RADIUS/SCALE), 0,
		(AST_FIELD_RADIUS/SCALE), -(AST_FIELD_RADIUS/SCALE), 0,  0,
	};
	static ast_dx[NUM_ASTEROID_IMAGES] = {
		-4, -4, -2, -2, 2, 2, 4, 4
	};
	static ast_dy[NUM_ASTEROID_IMAGES] = {
		-4, -2, 2, 4, -4, -2, 2, 4
	};
	register int i;
	register XImage *im;

	for (i=0,im=ast_image; i<NUM_ASTEROID_IMAGES; ++i,++im) {
		if ((ast_x[i] += ast_dx[i]) < (-(AST_FIELD_RADIUS/SCALE))) {
			ast_dx[i] = INTRAND(6)+2;
		}
		else if (ast_x[i] > (AST_FIELD_RADIUS/SCALE)) {
			ast_dx[i] = -(INTRAND(6)+2);
		}
		
		if ((ast_y[i] += ast_dy[i]) < (-(AST_FIELD_RADIUS/SCALE))) {
			ast_dy[i] = INTRAND(6)+2;
		}
		else if (ast_y[i] > (AST_FIELD_RADIUS/SCALE)) {
			ast_dy[i] = -(INTRAND(6)+2);
		}
		
		XPutImage(dpy, mainw, gc, im, 0, 0,
			xc+ast_x[i], yc+ast_y[i], ast_width, ast_height);
	}
}


static void local()
{
	register int h, i;
	register PLAYER *j;
	register TORP *k;
	register PLANET *planet;
	register PHASER *php;
	int dx, dy;
	int x1,y1,x2,y2;
	int delx,dely;
	int view,innebview,ownerguess,scaledview;
	XTextItem t;
	int in_pulsar,nebdist;
	int lastFG, lastBG, lastLineStyle, lastLineWidth, lastFunction;
	unsigned int pmask;

	lastLineWidth = lastLineStyle = lastFG = lastBG = lastFunction =
		-1;

	logmsg1("redraw: local\n");
	logmsg1("redraw: local: redrawing planets\n");
	t.delta = 0;
	if (me->p_obscured == OBSCURED_PULSAR) in_pulsar = TRUE;
	else in_pulsar = FALSE;
	innebview = (SCALE*WINSIDE/2*NEBULA_VISIBILITY);
	if (me->p_obscured == OBSCURED_NEBULA) {
		view = innebview;
	}
	else {
		view = (SCALE*WINSIDE/2);
	}
	nebdist = view + NEBULA_RADIUS;
	scaledview = view/SCALE;

	LINESTYLEWIDTH(LineSolid,0)

	/* draw planets */
	for (planet = planets; planet < planets+MAXPLANETS; ++planet) {
		if (planet->pl_flags & PLMASK_NEBULA) {
			dx = planet->pl_x - me->p_x;
			if (ABS(dx) > nebdist) continue;
			dy = planet->pl_y - me->p_y;
			if (ABS(dy) > nebdist) continue;
			dx /= SCALE; 
			dy /= SCALE;
			if ((x1 = dx - (NEBULA_RADIUS/SCALE)) < -scaledview)
				x1 = -scaledview;
			if ((x2 = dx + (NEBULA_RADIUS/SCALE)) >  scaledview)
				x2 =  scaledview;
			if ((y1 = dy - (NEBULA_RADIUS/SCALE)) < -scaledview)
				y1 = -scaledview;
			if ((y2 = dy + (NEBULA_RADIUS/SCALE)) >  scaledview)
				y2 =  scaledview;

			FOREGROUND(warningColor)
			XDrawRectangle(dpy,mainw,gc,
				x1+(WINSIDE/2), y1+(WINSIDE/2),
				x2-x1+1, y2-y1+1);
		}
		else {
			dx = planet->pl_x - me->p_x;
			if (ABS(dx) > view) continue;
			dy = planet->pl_y - me->p_y;
			if (ABS(dy) > view) continue;
			dx = dx / SCALE + (WINSIDE/2);
			dy = dy / SCALE + (WINSIDE/2);
	
			if (planet->pl_flags & PLMASK_PULSAR) {
				pulsar_image.data =
					(char *) &bpulsar_bits[(me->p_updates>>3)&0x3][0];
				FOREGROUND( cloakColor)
				XPutImage(dpy, mainw, gc, &pulsar_image, 0, 0,
					dx - (planet_width/2), dy - (planet_height/2),
					planet_width, planet_height);
			}
			else if (planet->pl_flags & PLMASK_BLACKHOLE) {
				blackhole_image.data =
					(char *) &blackhole_bits[(-(me->p_updates>>2))&0x7][0];
				FOREGROUND( cloakColor)
				XPutImage(dpy, mainw, gc, &blackhole_image, 0, 0,
					dx - (blackhole_width/2), dy - (blackhole_height/2),
					blackhole_width, blackhole_height);
			}
			else if (planet->pl_flags & PLMASK_BARREN) {
				FOREGROUND( cloakColor)
				XPutImage(dpy, mainw, gc, &bplanet_image, 0, 0,
					dx - (planet_width/2), dy - (planet_height/2),
					planet_width, planet_height);
				if (planet->pl_flags & PLMASK_AST_FIELD) {
					draw_ast_field(dx,dy);
				}
			}
			else {
				/* non-special planets */
				FOREGROUND( planetColor(planet))
				if ((me->p_team_no == planet->pl_owner_no)
						|| (me->p_team_no == INDEPENDENT)) /* watch */
					ownerguess = planet->pl_owner_no;
				else ownerguess = planet->pl_info[me->p_team_no].pi_owner_no;
				XPutImage(dpy, mainw, gc, &planet_image[ownerguess], 0, 0,
					dx - (planet_width/2), dy - (planet_height/2),
					planet_width, planet_height);
				if (planet->pl_flags & PLMASK_AST_FIELD) {
					draw_ast_field(dx,dy);
				}
			}
			t.chars  = planet->pl_name;
			t.nchars = planet->pl_namelen;
			t.font	 = planetFont(planet);
			XDrawText(dpy, mainw, gc,
				dx - (planet_width/2), dy + ((planet_height/2) + 7),
				&t, 1);
		}
		if ((me->p_planet == planet->pl_no)
				&& (me->p_flags & PFPLLOCK)) {
			XFUNCTION(GXxor)
			FOREGROUND(myColor)
           	XPutImage(dpy, mainw, gc, &nlock_image, 0, 0,
				dx - (lock_width/2), dy - (lock_height/2),
				lock_width, lock_height);
			XFUNCTION(GXcopy)
		}
	}

	/* Draw ships */
	t.nchars = 1;
	t.delta = 0;
	logmsg1("redraw: local: redrawing ships\n");
	for (j = players, pmask=1;
			j < players + MAXPLAYER;
			j++, pmask <<= 1) {
		int tx, ty;

		if (!(me->p_visible_ships & pmask)) continue;
		if ((j->p_status != PALIVE) 
				&& (j->p_status != PIMMUNE)
				&& (j->p_status != PEXPLODE)) {
			continue;
		}

		if ((in_pulsar || (j->p_obscured == OBSCURED_PULSAR))
				&& (j != me)
				&& INTRAND(PULSAR_BLANKING)) {
			continue;
		}

		if (j == me) {
			dx = dy = (WINSIDE/2);
		}
		else if ((myship->s_sptechmask & STMASK_IMP_SENS)
				|| (me->p_loanflags & PFLIMP_SENS)) {
			dx = j->p_x - me->p_x;
			if (ABS(dx) > view) continue;
			dy = j->p_y - me->p_y;
			if (ABS(dy) > view) continue;
			dx = dx/SCALE + (WINSIDE/2);
			dy = dy/SCALE + (WINSIDE/2);
		}
		else {
			dx = j->p_app_x - me->p_x;
			if (ABS(dx) > view) continue;
			dy = j->p_app_y - me->p_y;
			if (ABS(dy) > view) continue;
			dx = dx/SCALE + (WINSIDE/2);
			dy = dy/SCALE + (WINSIDE/2);
		}

		if ((j->p_flags & PFCLOAK)
				|| (j->p_loanflags & PFLCLOAK)) {
			if (j == me) {
				FOREGROUND(cloakColor)
			}
			else {
				if (((myship->s_sptechmask & STMASK_IMP_SENS)
							|| (me->p_loanflags & PFLIMP_SENS))
						&& (INTRAND(5))) continue;
				else if (INTRAND(30)) continue;
				FOREGROUND(playerColor(j))
			}
		}
		else {
			FOREGROUND(playerColor(j))
		}

		if ((j->p_status == PALIVE)
				|| (j->p_status == PIMMUNE)) {
			int dir;

			/* draw the ship */
			dir = rosette(j->p_dir);
			if (j->p_ship.s_maxspeed == 0) {
				/* orbiter */
				ship_image.data = (char *)
					&ind_bits[j->p_bitmap_num][dir][0];
			}
			else if (j->p_team_no == FEDERATION) {
				ship_image.data = (char *)
					&fed_bits[j->p_bitmap_num][dir][0];
			}
			else if (j->p_team_no == ROMULAN) {
				ship_image.data = (char *)
					&rom_bits[j->p_bitmap_num][dir][0];
			}
			else if (j->p_team_no == KLINGON) {
				ship_image.data = (char *)
					&kli_bits[j->p_bitmap_num][dir][0];
			}
			else if (j->p_team_no == ORION) {
				ship_image.data = (char *)
					&ori_bits[j->p_bitmap_num][dir][0];
			}
			else if (j->p_flags & PFPLKILLER) {
				ship_image.data = (char *) &pkil_bits[dir][0];
			}
			else {
				ship_image.data = (char *)
					&jgr_bits[j->p_bitmap_num][dir][0];
			}
            XPutImage(dpy, mainw, gc, &ship_image, 0, 0,
				dx - (ship_width/2), dy - (ship_height/2),
				ship_width, ship_height);

			t.chars = shipnos + j->p_no;
			t.font	= shipFont(j);
			XDrawText(dpy, mainw, gc,
				dx + (ship_width/2), dy - (ship_height/2),
				&t, 1);

			if ((me->p_wpnlock == j->p_no)
					&& (me->p_flags & PFWLOCK)) {
				XFUNCTION(GXxor)
				FOREGROUND(myColor)
            	XPutImage(dpy, mainw, gc, &wlock_image, 0, 0,
					dx - (lock_width/2), dy - (lock_height/2),
					lock_width, lock_height);
			}
			if ((me->p_playerl == j->p_no)
					&& (me->p_flags & PFPLOCK)) {
				XFUNCTION(GXxor)
				FOREGROUND(myColor)
            	XPutImage(dpy, mainw, gc, &nlock_image, 0, 0,
					dx - (lock_width/2), dy - (lock_height/2),
					lock_width, lock_height);
			}


			/* always draw shields */
			if (j->p_flags & PFSHIELD) {
				int shift, save, index;
				int findex, rindex, lindex, bindex;
				int bits[4];

				XFUNCTION(GXxor)

				findex = shieldIndex(j,FRONT_SHIELD);
				rindex = shieldIndex(j,RIGHT_SHIELD);
				lindex = shieldIndex(j,LEFT_SHIELD);
				bindex = shieldIndex(j,REAR_SHIELD);

				bits[1] = bits[2] = bits[3] = 0;
				bits[findex] |= 0x01;
				bits[rindex] |= 0x02;
				bits[bindex] |= 0x04;
				bits[lindex] |= 0x08;

				index = dir & 0x03;
				shift = (dir & 0xc) >> 2;

				if (bits[1]) {
					for (i = 0; i < shift; i++) {
						save    = ((bits[1] & 8) != 0);
						bits[1] = ((bits[1] << 1) | save) & 0x0f;
					}
	
					FOREGROUND( shieldColor[1])
					XPutImage(dpy, mainw, gc, shield[index][bits[1]], 0, 0,
						dx - (shield_width/2), dy - (shield_height/2),
						shield_width, shield_height);
				}

				if (bits[2]) {
					for (i = 0; i < shift; i++) {
						save = ((bits[2] & 8) != 0);
						bits[2] = ((bits[2] << 1) | save) & 0x0f;
					}
	
					FOREGROUND( shieldColor[2])
					XPutImage(dpy, mainw, gc, shield[index][bits[2]], 0, 0,
						dx - (shield_width/2), dy - (shield_height/2),
						shield_width, shield_height);
				}

				if (bits[3]) {
					for (i = 0; i < shift; i++) {
						save = ((bits[3] & 8) != 0);
						bits[3] = ((bits[3] << 1) | save) & 0x0f;
					}
	
					FOREGROUND( shieldColor[3])
					XPutImage(dpy, mainw, gc, shield[index][bits[3]], 0, 0,
						dx - (shield_width/2), dy - (shield_height/2),
						shield_width, shield_height);
				}
			}

			if (j->p_flags & PFSPHERE) {
				XFUNCTION(GXxor)
				FOREGROUND(cloakColor)
            	XPutImage(dpy, mainw, gc, &sphere_image, 0, 0,
					dx - (ship_width/2), dy - (ship_height/2),
					ship_width, ship_height);
			}

			if (j->p_status == PIMMUNE) {
				/* draw grey circle */
				XFUNCTION(GXxor)
				FOREGROUND(cloakColor)
            	XPutImage(dpy, mainw, gc, &immune_image, 0, 0,
					dx - (ship_width/2), dy - (ship_height/2),
					ship_width, ship_height);
			}
		}
		else if (j->p_status == PEXPLODE) {
			XFUNCTION(GXxor)
            ex_image.data = (char *)&ex_bits[ (10 - j->p_explode)/2 ][0];
            XPutImage(dpy, mainw, gc, &ex_image, 0, 0,
                      dx - (ex_width/2), dy - (ex_height/2),
                      ex_width, ex_height);
		}

		XFUNCTION(GXcopy)

		/* now draw his tractor beam if it exists */

		if (j->p_tractors_on) { /* gotta draw the tractor */
			if ((myship->s_sptechmask & STMASK_IMP_SENS)
					|| (me->p_loanflags & PFLIMP_SENS)) {
		  		tx = (players[j->p_who_tractor].p_x - me->p_x) /
		       		SCALE + WINSIDE / 2;
		  		ty = (players[j->p_who_tractor].p_y - me->p_y) /
			   		SCALE + WINSIDE / 2;
			}
			else {
		  		tx = (players[j->p_who_tractor].p_app_x - me->p_x) /
		       		SCALE + WINSIDE / 2;
		  		ty = (players[j->p_who_tractor].p_app_y - me->p_y) /
			   		SCALE + WINSIDE / 2;
			}
		   
		   if ( ABS(tx - dx) < ABS(ty - dy ) ) {
			 delx = 4; dely = 0;
		   }
		   else {
			 delx = 0; dely = 4; 
		   }
		   LINESTYLEWIDTH(LineOnOffDash,0)
		   FOREGROUND(playerColor(j))
           XDrawLine(dpy, mainw, gc, dx+delx, dy-dely, tx+delx, ty-dely);
           XDrawLine(dpy, mainw, gc, dx-delx, dy+dely, tx-delx, ty+dely);
		}

		/* Now draw his phasers (if they exist) */
		for (php = &phasers[j->p_no*MAXBEAM];
				php < &phasers[j->p_no*MAXBEAM + MAXBEAM];
				++php) {
			FOREGROUND(phaserColor(php))
			if (php->ph_status == PHFREE) continue;
			if (php->ph_status == PHMISS) {
				/* Here I will have to compute end coordinate */
				tx = j->p_app_x + j->p_ship.s_beamrange * Cos[php->ph_dir];
				ty = j->p_app_y + j->p_ship.s_beamrange * Sin[php->ph_dir];
				tx = (tx - me->p_x) / SCALE + (WINSIDE/2);
				ty = (ty - me->p_y) / SCALE + (WINSIDE/2);
			}
			else if (php->ph_status == PHHITLOCATION) {
				/* shoot to ph_x, ph_y */
				tx = (php->ph_x - me->p_x) / SCALE + (WINSIDE/2);
				ty = (php->ph_y - me->p_y) / SCALE + (WINSIDE/2);
			}
			else if (php->ph_status == PHHITPLAYER) {
			    /* Start point is dx, dy */
				tx = (players[php->ph_target].p_x - me->p_x) / SCALE
					+ (WINSIDE/2);
				ty = (players[php->ph_target].p_y - me->p_y) / SCALE
					+ (WINSIDE/2);
			}
			else {
				/* php->ph_status == PHHITTORP */
			    /* Start point is dx, dy */
				tx = (torps[php->ph_target].t_x - me->p_x) / SCALE
					+ (WINSIDE/2);
				ty = (torps[php->ph_target].t_y - me->p_y) / SCALE
					+ (WINSIDE/2);
			}
			if (php->ph_class == WPN_PHASER) {
				LINESTYLEWIDTH(LineSolid,0)
            	XDrawLine(dpy, mainw, gc, dx, dy, tx, ty);
			}
			else if (php->ph_class == WPN_DISRUPTER) {
				LINESTYLEWIDTH(LineOnOffDash,0)
            	XDrawLine(dpy, mainw, gc, dx, dy, tx, ty);
			}
			else if (php->ph_class == WPN_TACHYON) {
				LINESTYLEWIDTH(LineSolid,TACHYON_WIDTH)
            	XDrawLine(dpy, mainw, gc, dx, dy, tx, ty);
			}
			else if (php->ph_class == WPN_FUSION) {
				unsigned long mybackground;
				
				LINESTYLEWIDTH(LineDoubleDash,0)
				mybackground = gc->values.background;
				BACKGROUND(myColor)
            	XDrawLine(dpy, mainw, gc, dx, dy, tx, ty);
				BACKGROUND(mybackground)
			}
		}
	}

	/* Draw torps */
	logmsg1("redraw: local: torps\n");
	for (j = players, i = 0; i < MAXPLAYER; ++i, ++j) {
		if (!j->p_ntorp) continue;
		k = &torps[MAXTORP*i];
		FOREGROUND( torpColor(k))
		/* do it by weapon type for speed */
		if (j->p_ship.s_torpclass == WPN_PHOTON) {
			for (h = 0; h < MAXTORP; h++, k++) {
				if (!k->t_status) continue;
				if (in_pulsar && INTRAND(PULSAR_BLANKING)) continue;
				dx = k->t_x - me->p_x;
				if (ABS(dx) > view) continue;
				dy = k->t_y - me->p_y;
				if (ABS(dy) > view) continue;
				dx = dx / SCALE + WINSIDE / 2;
				dy = dy / SCALE + WINSIDE / 2;
				if (k->t_status == TEXPLODE) {
	                XPutImage(dpy, mainw, gc, &cloud_image, 0, 0,
						dx - (cloud_width/2), dy - (cloud_height/2),
						cloud_width, cloud_height);
				}
				else {
	                XPutImage(dpy, mainw, gc, &photon_image, 0, 0,
	                   	dx-(photon_width/2), dy-(photon_height/2),
	                   	photon_width, photon_height);
				}
			}
		}
		else if (j->p_ship.s_torpclass == WPN_MISSILE) {
			for (h = 0; h < MAXTORP; h++, k++) {
				if (!k->t_status) continue;
				if (in_pulsar && INTRAND(PULSAR_BLANKING)) continue;
				dx = k->t_x - me->p_x;
				if (ABS(dx) > view) continue;
				dy = k->t_y - me->p_y;
				if (ABS(dy) > view) continue;
				dx = dx / SCALE + WINSIDE / 2;
				dy = dy / SCALE + WINSIDE / 2;
				if (k->t_status == TEXPLODE) {
	                XPutImage(dpy, mainw, gc, &cloud_image, 0, 0,
						dx - (cloud_width/2), dy - (cloud_height/2),
						cloud_width, cloud_height);
				}
				else {
					missile_image.data =
						(char *) &missile_bits[rosette(k->t_dir)][0];
	                XPutImage(dpy, mainw, gc, &missile_image, 0, 0,
	                   	dx-(missile_width/2), dy-(missile_height/2),
	                   	missile_width, missile_height);
				}
			}
		}
		else if (j->p_ship.s_torpclass == WPN_PLASMA) {
			for (h = 0; h < MAXTORP; h++, k++) {
				if (!k->t_status) continue;
				if (in_pulsar && INTRAND(PULSAR_BLANKING)) continue;
				dx = k->t_x - me->p_x;
				if (ABS(dx) > view) continue;
				dy = k->t_y - me->p_y;
				if (ABS(dy) > view) continue;
				dx = dx / SCALE + WINSIDE / 2;
				dy = dy / SCALE + WINSIDE / 2;
				if (k->t_status == TEXPLODE) {
	                XPutImage(dpy, mainw, gc, &cloud_image, 0, 0,
						dx - (cloud_width/2), dy - (cloud_height/2),
						cloud_width, cloud_height);
				}
				else {
					plasma_image.data =
						(char *) &plasma_bits[(k->t_fuse>>2)&0x3][0];
	               	XPutImage(dpy, mainw, gc, &plasma_image, 0, 0,
	                   	dx-(plasma_width/2), dy-(plasma_height/2),
	                   	plasma_width, plasma_height);
				}
			}
		}
		else if (j->p_ship.s_torpclass == WPN_CHAFF) {
			for (h = 0; h < MAXTORP; h++, k++) {
				if (!k->t_status) continue;
				if (in_pulsar && INTRAND(PULSAR_BLANKING)) continue;
				dx = k->t_x - me->p_x;
				if (ABS(dx) > view) continue;
				dy = k->t_y - me->p_y;
				if (ABS(dy) > view) continue;
				dx = dx / SCALE + WINSIDE / 2;
				dy = dy / SCALE + WINSIDE / 2;
				if (k->t_status == TEXPLODE) {
	                XPutImage(dpy, mainw, gc, &cloud_image, 0, 0,
						dx - (cloud_width/2), dy - (cloud_height/2),
						cloud_width, cloud_height);
				}
				else {
					chaff_image.data =
						(char *) &chaff_bits[(k->t_fuse>>2)&0x3][0];
	                XPutImage(dpy, mainw, gc, &chaff_image, 0, 0,
	                   	dx-(chaff_width/2), dy-(chaff_height/2),
	                   	chaff_width, chaff_height);
				}
			}
		}
		else if (j->p_ship.s_torpclass == WPN_MINE) {
			for (h = 0; h < MAXTORP; h++, k++) {
				if (!k->t_status) continue;
				if (in_pulsar && INTRAND(PULSAR_BLANKING)) continue;
				dx = k->t_x - me->p_x;
				if (ABS(dx) > view) continue;
				dy = k->t_y - me->p_y;
				if (ABS(dy) > view) continue;
				dx = dx / SCALE + WINSIDE / 2;
				dy = dy / SCALE + WINSIDE / 2;
				if (k->t_status == TEXPLODE) {
	                XPutImage(dpy, mainw, gc, &cloud_image, 0, 0,
						dx - (cloud_width/2), dy - (cloud_height/2),
						cloud_width, cloud_height);
				}
				else {
					int drawit;
					
					drawit = FALSE;
					if ((myship->s_sptechmask & STMASK_IMP_SENS)
							|| (me->p_loanflags & PFLIMP_SENS)) {
						if (INTRAND(MINEREDRAW/2) == 0) drawit = TRUE;
					}
					else if (INTRAND(MINEREDRAW) == 0) drawit = TRUE;
					if (drawit) {
	                	XPutImage(dpy, mainw, gc, &mine_image, 0, 0,
	                   		dx-(mine_width/2), dy-(mine_height/2),
	                   		mine_width, mine_height);
					}
				}
			}
		}
		else if (j->p_ship.s_torpclass == WPN_SPHERE_BACKLASH) {
			for (h = 0; h < MAXTORP; h++, k++) {
				if (!k->t_status) continue;
				if (in_pulsar && INTRAND(PULSAR_BLANKING)) continue;
				dx = k->t_x - me->p_x;
				if (ABS(dx) > view) continue;
				dy = k->t_y - me->p_y;
				if (ABS(dy) > view) continue;
				dx = dx / SCALE + WINSIDE / 2;
				dy = dy / SCALE + WINSIDE / 2;
				if (k->t_status == TEXPLODE) {
	                XPutImage(dpy, mainw, gc, &cloud_image, 0, 0,
						dx - (cloud_width/2), dy - (cloud_height/2),
						cloud_width, cloud_height);
				}
				else {
					backlash_image.data =
						(char *) &bklsh_bits[(k->t_fuse>>1)&0x7][0];
	               	XPutImage(dpy, mainw, gc, &backlash_image, 0, 0,
	                   	dx-(bklsh_width/2), dy-(bklsh_height/2),
	                   	bklsh_width, bklsh_height);
				}
			}
		}
	}

	/* Draw vortices */
	for (k = torps + (MAXPLAYER*MAXTORP);
			k < torps + (MAXPLAYER*MAXTORP + MAXPVORTICES);
			++k) {
		if (k->t_status == TFREE) continue;
		if (in_pulsar && INTRAND(PULSAR_BLANKING)) continue;
		dx = k->t_x - me->p_x;
		if (ABS(dx) > view) continue;
		dy = k->t_y - me->p_y;
		if (ABS(dy) > view) continue;
		dx = dx / SCALE + WINSIDE / 2;
		dy = dy / SCALE + WINSIDE / 2;
		FOREGROUND(myColor);
		if (k->t_status == TEXPLODE) {
			XPutImage(dpy, mainw, gc, &cloud_image, 0, 0,
				dx - (cloud_width/2), dy - (cloud_height/2),
				cloud_width, cloud_height);
		}
		else {
			pvortex_image.data = 
				(char *) &pvortex_bits[(me->p_updates/5) & 0x3][0];
			XPutImage(dpy, mainw, gc, &pvortex_image, 0, 0,
				dx - (pvortex_width/2), dy - (pvortex_height/2),
				pvortex_width, pvortex_height);
		}
	}
		
	logmsg1("redraw: local: edges\n");
	/* Draw Edges */
	LINESTYLEWIDTH(LineSolid,0)
	if (me->p_x < (WINSIDE / 2) * SCALE)
	{
		int		sy, ey;

		dx = (WINSIDE / 2) - (me->p_x) / SCALE;
		sy = (WINSIDE / 2) + (0 - me->p_y) / SCALE;
		ey = (WINSIDE / 2) + (GWIDTH - me->p_y) / SCALE;
		if (sy < 0) sy = 0;
		if (ey > WINSIDE - 1) ey = WINSIDE - 1;

        FOREGROUND( warningColor)
        XDrawLine(dpy, mainw, gc, dx, sy, dx, ey);
	}
	if ((GWIDTH - me->p_x) < (WINSIDE / 2) * SCALE)
	{
		int		sy, ey;

		dx = (WINSIDE / 2) + (GWIDTH - me->p_x) / SCALE;
		sy = (WINSIDE / 2) + (0 - me->p_y) / SCALE;
		ey = (WINSIDE / 2) + (GWIDTH - me->p_y) / SCALE;
		if (sy < 0) sy = 0;
		if (ey > WINSIDE - 1) ey = WINSIDE - 1;

        FOREGROUND( warningColor)
        XDrawLine(dpy, mainw, gc, dx, sy, dx, ey);
	}
	if (me->p_y < (WINSIDE / 2) * SCALE)
	{
		int		sx, ex;

		dy = (WINSIDE / 2) - (me->p_y) / SCALE;
		sx = (WINSIDE / 2) + (0 - me->p_x) / SCALE;
		ex = (WINSIDE / 2) + (GWIDTH - me->p_x) / SCALE;
		if (sx < 0) sx = 0;
		if (ex > WINSIDE - 1) ex = WINSIDE - 1;

        FOREGROUND( warningColor)
        XDrawLine(dpy, mainw, gc, sx, dy, ex, dy);
	}
	if ((GWIDTH - me->p_y) < (WINSIDE / 2) * SCALE)
	{
		int		sx, ex;

		dy = (WINSIDE / 2) + (GWIDTH - me->p_y) / SCALE;
		sx = (WINSIDE / 2) + (0 - me->p_x) / SCALE;
		ex = (WINSIDE / 2) + (GWIDTH - me->p_x) / SCALE;
		if (sx < 0) sx = 0;
		if (ex > WINSIDE - 1) ex = WINSIDE - 1;

        FOREGROUND( warningColor)
        XDrawLine(dpy, mainw, gc, sx, dy, ex, dy);
	}

	/* Change border color to signify alert status */
	if (oldalert != (me->p_flags & (PFGREEN|PFYELLOW|PFRED)))
	{
		XSetWindowAttributes attr;

		logmsg1("redraw: local: changing border color\n");
		oldalert = (me->p_flags & (PFGREEN|PFYELLOW|PFRED));
		switch (oldalert)
		{
		case PFGREEN:
			attr.border_pixel = gColor;
			break;
		case PFYELLOW:
			attr.border_pixel = yColor;
			break;
		case PFRED:
			attr.border_pixel = rColor;
			break;
		}
		XChangeWindowAttributes( dpy, baseWin, CWBorderPixel, &attr );
	}

	XFlush(dpy);
}


/***********************************************************************
 *                          map
 * 
 * win      = window to draw it to
 * full_map = draw full galaxy?
 * snapshot = draw everything? (alternative is incremental update)
 *
 **********************************************************************/
void map(win,full_map,snapshot,myplanets_only)
Window win;
int full_map,snapshot,myplanets_only;
{
	register PLAYER *j;
	register PLANET *planet;
	int dx, dy, cloak_chance,ownerguess,mynovtent;
	int x1,y1,x2,y2;
	XTextItem t;
	int offx,offy,winwidth,draw_all_planets,pno;
	int lastFG;
	unsigned int pmask;

	lastFG = -1;

	/* don't draw strategic map if covered by galaxy map */
	if ((win != galaxy_win) && ismapped(galaxy_win)) return;

	if (snapshot) {
		XClearWindow(dpy,win);
		draw_all_planets = TRUE;
	}
	else {
		if (draw_all_planets = redrawall) {
			XClearWindow(dpy,win);
		}
	}

	if (full_map) {
		/* full-galaxy map for "G" window or watch mode */
		winwidth = GWIDTH;
		x1 = 0;
		y1 = 0;
		x2 = GWIDTH;
		y2 = GWIDTH;
		if (!draw_all_planets) {
    		/* clear all the rectangles that were drawn to */
    		FOREGROUND( backColor)
    		if (mclearcount)
        		XFillRectangles(dpy, mapw, gc, mclearzone, mclearcount);
		}
    	mczp = mclearzone;
    	mclearcount = 0;
	}
	else {
		/* standard strategic map */
		winwidth = MAPWIDTH;

		if (me->p_x < (GWIDTH/3)) {
			mynovtent = 0;
			offx = 0;
		}
		else if (me->p_x < (GWIDTH*2/3)) {
			mynovtent = 1;
			offx = (GWIDTH/4);
		}
		else {
			mynovtent = 2;
			offx = (GWIDTH/2);
		}
	
		if (me->p_y < (GWIDTH/3)) {
			offy = 0;
		}
		else if (me->p_y < (GWIDTH*2/3)) {
			mynovtent += 3;
			offy = (GWIDTH/4);
		}
		else {
			mynovtent += 6;
			offy = (GWIDTH/2);
		}
	
		if (mynovtent != me->novtent) {
			/* hysteresis */
			switch (me->novtent) {
				case 0:
					if ((me->p_x < (GWIDTH/3 + ORBDIST*2))
							&& (me->p_y < (GWIDTH/3 + ORBDIST*2))) {
						mynovtent = me->novtent;
					}
					break;
				case 1:
					if ((me->p_x < (GWIDTH*2/3 + ORBDIST*2))
							&& (me->p_x > (GWIDTH/3 - ORBDIST*2))
							&& (me->p_y < (GWIDTH/3 + ORBDIST*2))) {
						mynovtent = me->novtent;
					}
					break;
				case 2:
					if ((me->p_x > (GWIDTH*2/3 - ORBDIST*2))
							&& (me->p_y < (GWIDTH/3 + ORBDIST*2))) {
						mynovtent = me->novtent;
					}
					break;
				case 3:
					if ((me->p_x < (GWIDTH/3 + ORBDIST*2))
							&& (me->p_y > (GWIDTH/3 - ORBDIST*2))
							&& (me->p_y < (GWIDTH*2/3 + ORBDIST*2))) {
						mynovtent = me->novtent;
					}
					break;
				case 4:
					if ((me->p_x > (GWIDTH/3 - ORBDIST*2))
							&& (me->p_x < (GWIDTH*2/3 + ORBDIST*2))
							&& (me->p_y > (GWIDTH/3 - ORBDIST*2))
							&& (me->p_y < (GWIDTH*2/3 + ORBDIST*2))) {
						mynovtent = me->novtent;
					}
					break;
				case 5:
					if ((me->p_x > (GWIDTH*2/3 - ORBDIST*2))
							&& (me->p_y > (GWIDTH/3 - ORBDIST*2))
							&& (me->p_y < (GWIDTH*2/3 + ORBDIST*2))) {
						mynovtent = me->novtent;
					}
					break;
				case 6:
					if ((me->p_x < (GWIDTH/3 + ORBDIST*2))
							&& (me->p_y > (GWIDTH*2/3 - ORBDIST*2))) {
						mynovtent = me->novtent;
					}
					break;
				case 7:
					if ((me->p_x < (GWIDTH*2/3 + ORBDIST*2))
							&& (me->p_x > (GWIDTH/3 - ORBDIST*2))
							&& (me->p_y > (GWIDTH*2/3 - ORBDIST*2))) {
						mynovtent = me->novtent;
					}
					break;
				case 8:
					if ((me->p_x > (GWIDTH*2/3 - ORBDIST*2))
							&& (me->p_y > (GWIDTH*2/3 - ORBDIST*2))) {
						mynovtent = me->novtent;
					}
					break;
			}
		}
	
		if (mynovtent != me->novtent) {
			/* draw strategic map in new position */
			XClearWindow(dpy,mapw);
			me->novtent = mynovtent;
			me->map_offsetx = offx;
			me->map_offsety = offy;
			draw_all_planets = TRUE;
	    	mczp = mclearzone;
	    	mclearcount = 0;
		}
		else if (!snapshot) {
			/* draw to same strategic window */
	    	/* clear all the rectangles that were drawn to */
	    	FOREGROUND( backColor)
	    	if (mclearcount)
	        	XFillRectangles(dpy, mapw, gc, mclearzone, mclearcount);
	    	mczp = mclearzone;
	    	mclearcount = 0;
		}

		x1 = me->map_offsetx;
		y1 = me->map_offsety;
		x2 = me->map_offsetx + MAPWIDTH;
		y2 = me->map_offsety + MAPWIDTH;
	}

	logmsg1("redraw: map: planets\n");
	/* Draw Planets */
	t.nchars = 3;
	t.delta = 0;
	for (planet = planets; planet < planets+MAXPLANETS; ++planet) {
		if (!(planet->pl_flags & PLMASK_REDRAW)
				&& (!draw_all_planets)) {
			continue;
		}
		if (myplanets_only && (planet->pl_owner_no != me->p_team_no)) {
			continue;
		}

		if (planet->pl_x < x1) continue;
		if (planet->pl_x > x2) continue;
		if (planet->pl_y < y1) continue;
		if (planet->pl_y > y2) continue;

		dx = (planet->pl_x - x1) * WINSIDE / winwidth;
		dy = (planet->pl_y - y1) * WINSIDE / winwidth;

		if (planet->pl_flags & PLMASK_PULSAR) {
			FOREGROUND( cloakColor)
			XPutImage(dpy, win, gc, &mpulsar_image, 0, 0,
				dx - (mplanet_width/2), dy - (mplanet_height/2),
				mplanet_width, mplanet_height);
		}
		else if (planet->pl_flags & PLMASK_BARREN) {
			FOREGROUND( cloakColor)
			if (planet->pl_flags & PLMASK_AST_FIELD) {
				XPutImage(dpy, win, gc, &mast_field_image, 0, 0,
					dx - (mast_field_width/2), dy - (mast_field_height/2),
					mast_field_width, mast_field_height);
			}
			XPutImage(dpy, win, gc, &mbplanet_image, 0, 0,
				dx - (mplanet_width/2), dy - (mplanet_height/2),
				mplanet_width, mplanet_height);
			if ((planet->pl_flags & PLMASK_WANDERER)
					&& (!snapshot)) {
				MCLEAR(dx - (mplanet_width/2),
               		dy - (mplanet_height/2),
               		mplanet_width+10,
					mplanet_height+20);
			}
		}
		else if (planet->pl_flags & PLMASK_BLACKHOLE) {
			FOREGROUND( cloakColor)
			XPutImage(dpy, win, gc, &mblackhole_image, 0, 0,
				dx - (mplanet_width/2), dy - (mplanet_height/2),
				mplanet_width, mplanet_height);
		}
		else if (planet->pl_flags & PLMASK_NEBULA) {
			FOREGROUND( warningColor)
			XPutImage(dpy, win, gc, &mnebula_image, 0, 0,
				dx - (mbnebula_width/2), dy - (mbnebula_height/2),
				mbnebula_width, mbnebula_height);
		}
		else {
        	FOREGROUND( planetColor(planet))
			/* non-special planets */
			if ((me->p_team_no == planet->pl_owner_no)
					|| (me->p_team_no == INDEPENDENT)) /* watch */
				ownerguess = planet->pl_owner_no;
			else ownerguess = planet->pl_info[me->p_team_no].pi_owner_no;
			if (planet->pl_flags & PLMASK_AST_FIELD) {
				XPutImage(dpy, win, gc, &mast_field_image, 0, 0,
					dx - (mast_field_width/2), dy - (mast_field_height/2),
					mast_field_width, mast_field_height);
			}
			XPutImage(dpy, win, gc, &mplanet_image[ownerguess], 0, 0,
				dx - (mplanet_width/2), dy - (mplanet_height/2),
				mplanet_width, mplanet_height);
			if ((planet->pl_flags & PLMASK_WANDERER)
					&& (!snapshot)) {
				MCLEAR(dx - (mplanet_width/2),
               		dy - (mplanet_height/2),
               		mplanet_width+10,
					mplanet_height+20);
			}
		}

		t.chars = planet->pl_name;
		t.font	= planetFont(planet);
		XDrawText(dpy, win, gc,
			dx - (mplanet_width/2), dy + (mplanet_height/2)+7, 
			&t, 1);
	}
	if (!snapshot) redrawall = FALSE;

	logmsg1("redraw: map: ships\n");
	if ((myship->s_sptechmask & STMASK_IMP_SENS)
			|| (me->p_loanflags & PFLIMP_SENS)) {
		cloak_chance = 10;
	}
	else {
		cloak_chance = 40;
	}

	logmsg3("%d: visible_ships:  0x%x\n",me->p_no,me->p_visible_ships);
	nplayers = 0;
	if (!myplanets_only
			&& (watch
				|| ((me->p_obscured != OBSCURED_PULSAR)
						|| (INTRAND(PULSAR_BLANKING) == 0)))) {
		/* Draw ships */
	    t.nchars = 2;
	    t.delta = 0;
		for (j = players, pmask=1, pno = 0;
				pno < MAXPLAYER;
				++j, pmask <<= 1, ++pno ) {
			if (j->p_status == PALIVE) nplayers++;
			if (!(me->p_visible_ships & pmask)) {
				/* can't see him */
				/* break locks */
				if ((me->p_wpnlock == pno)
						&& (me->p_flags & PFWLOCK)) {
					me->p_flags &= ~PFWLOCK;
					logmsg3("%d: visibility wlock break with %d\n",
						me->p_no,pno);
				}
				if ((me->p_playerl == pno)
						&& (me->p_flags & PFPLOCK)) {
					me->p_flags &= ~PFPLOCK;
					logmsg3("%d: visibility nlock break with %d\n",
						me->p_no,pno);
				}
				continue;
			}

			if (j != me) {
				if (j->p_x < x1) continue;
				if (j->p_x > x2) continue;
				if (j->p_y < y1) continue;
				if (j->p_y > y2) continue;
				if (!watch
						&& (j->p_obscured == OBSCURED_PULSAR)
						&& INTRAND(PULSAR_BLANKING)) {
					continue;
				}
			}

			/* check for enemy cloaker */
			if ((j->p_flags & PFCLOAK)
					|| (j->p_loanflags & PFLCLOAK)) {
				if (j == me) {
					FOREGROUND(myColor)
				}
				else {
					if (INTRAND(cloak_chance)) continue;
					FOREGROUND(cloakColor)
				}
				t.chars = "??";
				t.font  = dfont;
			}
			else {
				FOREGROUND(playerColor(j))
				t.chars = j->p_mapchars;
				t.font  = shipFont(j);
			}
	
			/* Draw it (or ??) */
			if ((j == me)
					|| (myship->s_sptechmask & STMASK_IMP_SENS)
					|| (me->p_loanflags & PFLIMP_SENS)) {
				dx = (j->p_x - x1) * WINSIDE / winwidth;
				dy = (j->p_y - y1) * WINSIDE / winwidth;
			}
			else {
				dx = (j->p_app_x - x1) * WINSIDE / winwidth;
				dy = (j->p_app_y - y1) * WINSIDE / winwidth;
			}
	
	        XDrawText(dpy, win, gc,
					dx - dfontinfo->max_bounds.rbearing,
					dy - (dfontinfo->ascent/2)+7,
					&t, 1);

			if (!snapshot) {
				MCLEAR(dx - dfontinfo->max_bounds.rbearing,
                	dy - dfontinfo->ascent/2 - dfontinfo->ascent+7,
                	dfontinfo->max_bounds.rbearing * 2,
                	dfontinfo->ascent + dfontinfo->descent);
			}
		}
	}
	XFlush(dpy);
}

#define BLANK_STATUS_LINE \
	"                                                                "
static char *last_status_line = BLANK_STATUS_LINE;

static void stline()
{
		static char *buf2= "  ";
		static char *buf = BLANK_STATUS_LINE;
		register int i;
		static XTextItem t1 = {
			NULL, 63, 0, 0
		};
		static XTextItem t2 = {
			NULL, 1, 0, 0
		};

		/* Instead of one sprintf, all this done by hand for optimization */
		logmsg1("redraw: status line\n");

		/* FLAGS */
		buf[0] = (me->p_flags & PFSHIELD ? 'S': ' ');
		if (me->p_flags & PFGREEN) buf[1] = 'G';
		else if (me->p_flags & PFYELLOW) buf[1] = 'Y';
		else if (me->p_flags & PFRED) buf[1] = 'R';
		buf[2] = (me->p_flags & (PFPLLOCK | PFPLOCK) ? 'L': ' ');
		buf[3] = (me->p_flags & PFREPAIR ? 'R': ' ');
		buf[4] = (me->p_flags & PFBOMB ? 'B': ' ');
		buf[5] = (me->p_flags & PFORBIT ? 'O': ' ');
		buf[6] = (me->p_flags & PFWLOCK ? 'W': ' ');
		buf[7] = (me->p_flags & PFENG ? 'E': ' ');
		buf[8] = (me->p_flags & PFBEAMUP ? 'u': ' ');
		buf[9] = (me->p_flags & PFBEAMDOWN ? 'd': ' ');
		buf[10] = (me->p_flags & PFCOPILOT ? 'P' : ' ');
		if (me->p_flags & PFCLOAK) buf[11] = 'c';
		else if (me->p_loanflags & PFLCLOAK) buf[11] = 'c';
		else if (me->p_flags & PFECM) buf[11] = 'e';
		else if (me->p_loanflags & PFLECM) buf[11] = 'e';
		else if (me->p_flags & PFHYPERSPACE) buf[11] = 'h';
		else if (me->p_flags & PFSPHERE) buf[11] = 'b';
		else buf[11] = ' ';

		/* SPEED */
		if (me->p_speed < 10) buf[14] = ' ';
		else buf[14] = '0' + (me->p_speed / 10);
		buf[15] = '0' + (me->p_speed % 10);		
		
		/* DAMAGE */
		if (myship->s_system[1].undamaged_size > 0)
			i = 100 - 100 * myship->s_system[1].current_size /
					myship->s_system[1].undamaged_size;
		else i = 100;				
		if (i < 100) {
				buf[18] = ' ';
				if (i < 10) buf[19] = ' ';
				else buf[19] = '0' + (i / 10);
		}
		else {
				buf[18] = '0' + (i / 100);
				buf[19] = '0' + ((i % 100) / 10);
		}
		buf[20] = '0' + (i % 10);
 
		/* FRONT SHIELD */
		if (me->p_shield[FRONT_SHIELD] < 100) {
				buf[22] = ' ';
				if (me->p_shield[FRONT_SHIELD] < 10) buf[23] = ' ';
				else buf[23] = '0' + (me->p_shield[FRONT_SHIELD] / 10);
		}
		else {
				buf[22] = '0' + (me->p_shield[FRONT_SHIELD] / 100);
				buf[23] = '0' + ((me->p_shield[FRONT_SHIELD] % 100) / 10);
		}
		buf[24] = '0' + (me->p_shield[FRONT_SHIELD] % 10);

		/* TORPS FLYING */
		if (me->p_ntorp < 10) buf[27] = ' ';
		else buf[27] = '0' + ((me->p_ntorp % 100) / 10);
		buf[28] = '0' + (me->p_ntorp % 10);

		/* KILLS */
		if (me->p_kills < 10.0) buf[33] = ' ';
		else buf[33] = '0' + ((int) (me->p_kills / 10));
		buf[34] = '0' + (((int) me->p_kills) % 10);
		buf[35] = '.';
		buf[36] = '0' + (((int) (me->p_kills * 10)) % 10);
		buf[37] = '0' + (((int) (me->p_kills * 100)) % 10);

		/* ARMIES */
		if (me->p_armies < 10) buf[40] = ' ';
		else buf[40] = '0' + ((me->p_armies % 100) / 10);
		buf[41] = '0' + (me->p_armies % 10);

		/* FUEL */
		if (me->p_fuel < 10000) {
				buf[46] = ' ';
				if (me->p_fuel < 1000) {
						buf[47] = ' ';
						if (me->p_fuel < 100) {
								buf[48] = ' ';
								if (me->p_fuel < 10) buf[49] = ' ';
								else buf[49] = '0' + (me->p_fuel / 10);
						}
						else {
								buf[48] = '0' + (me->p_fuel / 100);
								buf[49] = '0' + ((me->p_fuel % 100)	 / 10);
						}
				}
				else {
						buf[47] = '0' + (me->p_fuel / 1000);
						buf[48] = '0' + ((me->p_fuel % 1000)  / 100);
						buf[49] = '0' + ((me->p_fuel % 100)	  / 10);
				}
		}
		else {
				buf[46] = '0' + ((me->p_fuel % 100000) / 10000);
				buf[47] = '0' + ((me->p_fuel % 10000)  / 1000);
				buf[48] = '0' + ((me->p_fuel % 1000)   / 100);
				buf[49] = '0' + ((me->p_fuel % 100)	   / 10);
		}
		buf[50] = '0' + (me->p_fuel % 10);

		/* TUBES LOADED */
		i = myship->s_torps - me->p_torps_unloaded;
		if (i < 10) buf[55] = ' ';
		else buf[55] = '0' + ((i % 100) / 10);
		buf[56] = '0' + (i % 10);

		/* ENGINE TEMPERATURE */
		i = me->p_etemp / 10;
		if (i < 100) {
				buf[60] = ' ';
				if (i < 10) buf[61] = ' ';
				else buf[61] = '0' + (i / 10);
		}
		else {
				buf[60] = '0' + ((i % 1000) / 100);
				buf[61] = '0' + ((i % 100)	/ 10);
		}
		buf[62] = '0' + (i % 10);

		buf[63] = '\0';

        if (me->p_tractors_on){
			buf2[0] = 'T';
		}
		else {
			buf2[0] = ' ';
		}
		buf2[1] = '\0';

		/* Draw status line */
		if (strcmp(buf,last_status_line)) {
			XSetForeground(dpy, gc, backColor);
			XFillRectangle( dpy, tstatw, gc,  30, 20,
					dfontinfo->max_bounds.rbearing * 67,
					dfontinfo->ascent + dfontinfo->descent ); 
	
			XSetForeground(dpy, gc, textColor);
			t1.chars = buf;
			t1.font	= dfont;
			XDrawText( dpy, tstatw, gc,	 50, 20 + dfontinfo->ascent, &t1, 1);
	
			t2.chars = buf2;
			t2.font = dfont;
	    	XDrawText( dpy, tstatw, gc,  40, 20 + dfontinfo->ascent, &t2, 1);
			strcpy(last_status_line,buf);
		}
}

/* These are routines that need to be done on interrupts but
   don't belong in the redraw routine and particularly don't
   belong in the daemon. */

static void auto_features()
{
		char buf[80];

		logmsg1("redraw: auto_features\n");

		if (copilot && (!(me->p_flags & PFCOPILOT))) {
				printf("Owning player has kicked you out\n");
				exit(0);
		}
		if ((!copilot) && (!watch)	&& (me->p_flags & PFSELFDEST)) {
			if ((me->p_updates >= selfdest) ||
				((!(me->p_flags & PFENTER))
				&& (me->p_flags & PFGREEN) && (myship->s_damaged == FALSE) 
				&& (me->p_shield[FRONT_SHIELD] == myship->s_shield[FRONT_SHIELD])
				&& (me->p_shield[RIGHT_SHIELD] == myship->s_shield[RIGHT_SHIELD])
				&& (me->p_shield[REAR_SHIELD]  == myship->s_shield[REAR_SHIELD])
				&& (me->p_shield[LEFT_SHIELD]  == myship->s_shield[LEFT_SHIELD]))) {
					me->p_flags &= ~PFSELFDEST;
					me->p_explode = 10;
					me->p_whydead = KQUIT;
					me->p_status = PEXPLODE;
			}
			else {
				sprintf(buf, "Self Destruct in %d seconds",
					(selfdest - me->p_updates) / 10);
				warning(buf);
			}
		}
		else if ((!copilot)
				&& (!watch)
				&& ((me->p_flags & (PFEXIT|PFORBIT))
						== (PFEXIT|PFORBIT))) {
			if (me->p_updates >= me->p_exittime) {
				me->p_flags &= ~(PFCLOAK|PFBEAMUP
					|PFBEAMDOWN|PFSELFDEST|PFPLOCK|PFPLLOCK
					|PFWLOCK|PFECM|PFHYPERSPACE|PFSPHERE
					|PFEXIT|PFENTER|PFSTART);
				/* don't let him stay out longer than 30 minutes */
				me->p_exittime = me->p_updates + (30*60*10);
				me->p_status = PIMMUNE;
				warning("Hit any key to begin 10 second countdown to reenter game");
			}
			else {
				sprintf(buf, "Temporary game exit in %d seconds",
					(me->p_exittime - me->p_updates) / 10);
				warning(buf);
			}
		}
		else if ((!copilot) && (!watch)	&& (me->p_flags & PFENTER)) {
			if (me->p_updates >= me->p_exittime) {
				me->p_flags &= ~(PFCLOAK|PFBEAMUP
					|PFBEAMDOWN|PFSELFDEST|PFPLOCK|PFPLLOCK
					|PFWLOCK|PFECM|PFHYPERSPACE|PFSPHERE
					|PFEXIT|PFENTER|PFSTART);
				me->p_status = PALIVE;
				warning("Re-entering game now!!");
				check_mode_status();
			}
			else {
				sprintf(buf, "Entering game in %d seconds",
					(me->p_exittime - me->p_updates) / 10);
				warning(buf);
			}
		}
		else if ((me->p_status == PIMMUNE)
				&& (me->p_updates >= me->p_exittime)) {
			me->p_status = PALIVE;
			selfdest = me->p_updates + 600;
			me->p_flags |= (PFSELFDEST|PFENTER|PFSTART);
			check_mode_status();
		}
		else if ((me->p_status == PIMMUNE)
				&& (me->p_updates >= (me->p_exittime-600))) {
			sprintf(buf, "Auto-return to game in %d seconds",
				(me->p_exittime - me->p_updates) / 10);
			warning(buf);
		}

		/* give certain information about bombing or beaming */
		if (me->p_flags & PFBOMB) {
				if (planets[me->p_planet].pl_armies < 5) {
						sprintf(buf, "Cannot bomb %s while armies are less than 5",
							planets[me->p_planet].pl_name);
						warning(buf);
						if (! (copilot || watch))
								me->p_flags &= ~PFBOMB;
				}
				else {
						sprintf(buf, "Bombing %s.  %d armies left",
							planets[me->p_planet].pl_name,
							planets[me->p_planet].pl_armies);
						warning(buf);
				}
		}

		if (me->p_flags & PFBEAMUP) {
				if (planets[me->p_planet].pl_armies < 5) {
						sprintf(buf, "%s: Too few armies to beam up",
							planets[me->p_planet].pl_name);
						warning(buf);
						if (! (copilot || watch))
								me->p_flags &= ~PFBEAMUP;
				}
				else if ((me->p_armies == (int) (me->p_kills * 2)) ||
					(me->p_armies == myship->s_cargo)) {
						sprintf(buf, "No more room on board for armies");
						warning(buf);
						if (! (copilot || watch))
								me->p_flags &= ~PFBEAMUP;
				}
				else {
						sprintf(buf, "Beaming up.  (%d/%d)", me->p_armies,
							((me->p_kills * 2) > myship->s_cargo) ?
							myship->s_cargo : (int) (me->p_kills * 2));
						warning(buf);
				}
		}
		if (me->p_flags & PFBEAMDOWN) {
				if (me->p_armies == 0) {
						sprintf(buf, "No more armies to beam down to %s.",
							planets[me->p_planet].pl_name);
						warning(buf);
						if (! (copilot || watch))
								me->p_flags &= ~PFBEAMDOWN;
				}
				else {
						sprintf(buf, "Beaming down.	 (%d/%d) %s has %d armies left",
							me->p_armies,
							((me->p_kills * 2) > myship->s_cargo) ?
							myship->s_cargo : (int) (me->p_kills * 2),
							planets[me->p_planet].pl_name,
							planets[me->p_planet].pl_armies);
						warning(buf);
				}
		}
		if (me->p_flags & PFREPAIR) {
				if ((myship->s_damaged == FALSE)
								&& (me->p_shield[FRONT_SHIELD] == myship->s_shield[FRONT_SHIELD])
								&& (me->p_shield[RIGHT_SHIELD] == myship->s_shield[RIGHT_SHIELD])
								&& (me->p_shield[REAR_SHIELD]  == myship->s_shield[REAR_SHIELD])
								&& (me->p_shield[LEFT_SHIELD]  == myship->s_shield[LEFT_SHIELD]))
						if (! (copilot || watch))
								me->p_flags &= ~PFREPAIR;
		}
}


void redrawTstats()
{
		static char *buf =
			"Flags        warp dam shd torps  kills armies  fuel loaded etemp";
		static XTextItem t = {
			NULL, 64, 0, 0
		};

		logmsg1("redraw: redrawTstats\n");
		XSetForeground(dpy, gc, textColor);
		t.chars = buf; 
		t.font  = dfont; 
		XDrawText( dpy, tstatw, gc, 50, 10, &t, 1 );

		strcpy(last_status_line,"");
}


void redraw()
{
	XSetForeground(dpy, gc, backColor);
	XSetBackground(dpy, gc, backColor);

	logmsg1("redraw: redraw\n");

	/* erase warning line if necessary */
	if ((warntimer <= udcounter) && (warncount > 0))
	{
		XFillRectangle(dpy, warnw, gc, 5, 5,
			dfontinfo->max_bounds.rbearing * warncount,
			dfontinfo->ascent + dfontinfo->descent);

		warncount = 0;
	}

	if ((mapmode) && (udcounter % ((nplayers == 0) ? 1 : nplayers) == 0)) {
		if (watch) {
			/* draw full galaxy */
			map(mapw,TRUE,FALSE,FALSE);
		}
		else {
			/* draw normal strategic window */
			map(mapw,FALSE,FALSE,FALSE);
		}
	}

	/* Display a new message every MESSTIME/10 seconds */
	if (udcounter % MESSTIME == 0)
		dmessage();

	XClearWindow(dpy, mainw);
	local();		/* redraw local window */

	stline();

	if (showStats)
		updateStats(statwin);

	updateDamage();
}


void intrupt()
{
	if (((me->p_status == PDEAD) || (me->p_status == POUTFIT))
		&& (me->p_ntorp <= 0)) {
			if (copilot)
					exit(0);
			else if (!watch)
					death();
	}

	if (! (copilot || watch))
			udcounter++;
	auto_features();
	redraw();
}

