/* rdplanets.c 15.1 06/08/90 10:06:30 */

/*

	Copyright (c) 1986 	Chris Guthrie

Permission to use, copy, modify, and distribute this
software and its documentation for any purpose and without
fee is hereby granted, provided that the above copyright
notice appear in all copies and that both that copyright
notice and this permission notice appear in supporting
documentation.  No representations are made about the
suitability of this software for any purpose.  It is
provided "as is" without express or implied warranty.

*/

/* Major overhaul by Daryl Poe.
 *
 * Copyright (c) 1989 Daryl Poe
 *
 * Ported to X11 by Jim Andreas.
 * Tractors, treaties, and other features by Norm Gee.
 * Damage window and shield bitmaps by Tom LaStrange.
 *
 * The above comments apply to this version as well, and this
 * notice must also appear in any copies or follow-ons.
 */

#include <stdio.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/ipc.h>
#include <sys/shm.h>
#include <sys/sem.h>
#include <time.h>
#include <fcntl.h>
#include <sys/file.h>
#include <sys/ioctl.h>
#include <signal.h>
#include <sys/signal.h>
#include <setjmp.h>

#include "defs.h"
#include "weapon.h"
#include "system.h"
#include "ship.h"
#include "stats.h"
#include "player.h"
#include "torp.h"
#include "status.h"
#include "planet.h"
#include "phaser.h"
#include "message.h"
#include "shmem.h"
#include "data.h"

static void print_flags(flags)
int flags;
{
	if (flags & IND_MASK) printf("I");
	if (flags & FED_MASK) printf("F");
	if (flags & ROM_MASK) printf("R");
	if (flags & KLI_MASK) printf("K");
	if (flags & ORI_MASK) printf("O");
	printf("-");
	if (flags & PLMASK_REPAIR) 		printf("R");
	else printf(" ");
	if (flags & PLMASK_FUEL) 		printf("F");
	else printf(" ");
	if (flags & PLMASK_REDRAW) 		printf("D");
	else printf(" ");
	if (flags & PLMASK_HOME) 		printf("H");
	else printf(" ");
	if (flags & PLMASK_COUP) 		printf("C");
	else printf(" ");
	if (flags & PLMASK_BLACKHOLE)	printf("H");
	else printf(" ");
	if (flags & PLMASK_PULSAR)		printf("P");
	else printf(" ");
	if (flags & PLMASK_BARREN)		printf("B");
	else printf(" ");
	if (flags & PLMASK_WANDERER)	printf("W");
	else printf(" ");
	if (flags & PLMASK_NEBULA)		printf("N");
	else printf(" ");
	if (flags & PLMASK_TMPBARREN)	printf("T");
	else printf(" ");
}

main(argc,argv)
int argc;
char *argv[];
{
	int i;
	MEMORY sharedMemory;
	PLANET *planet;

	construct_filenames();

	OPEN_LOGFILE(Dlogfilename);

	players  = sharedMemory.players;
	torps    = sharedMemory.torps;
	status   = sharedMemory.status;
	planets  = sharedMemory.planets;
	phasers  = sharedMemory.phasers;
	mctl     = sharedMemory.mctl;
	messages = sharedMemory.messages;
	team	 = sharedMemory.team;

	read_planet_file();

	for (planet=planets; planet<planets+MAXPLANETS; ++planet) {
		printf("%-2d ",planet->pl_no);
		print_flags(planet->pl_flags);
		printf("%1d 0x%1x %-6d %-6d %-3d %-3d %-8.8s %-2d %-3d %-3d %-3d\n",
			planet->pl_owner_no,
			planet->pl_owner_mask,
			planet->pl_x,
			planet->pl_y,
			planet->pl_dx,
			planet->pl_dy,
			planet->pl_name,
			planet->pl_namelen,
			planet->pl_armies,
			planet->pl_deadtime,
			planet->pl_couptime);
		for (i=1; i<5; ++i) {
			printf("\t");
			print_flags(planet->pl_info[i].pi_flags);
			printf("%-1d %-3d %s\n",
				planet->pl_info[i].pi_owner_no,
				planet->pl_info[i].pi_armies,
				nl_cxtime(&(planet->pl_info[i].pi_timestamp),
					"%m/%d %H:%M"));
		}

		printf("\n");
	}

}
