/* pstats.c 15.1 06/08/90 10:06:26 */

/*

	Copyright (c) 1986 	Chris Guthrie

Permission to use, copy, modify, and distribute this
software and its documentation for any purpose and without
fee is hereby granted, provided that the above copyright
notice appear in all copies and that both that copyright
notice and this permission notice appear in supporting
documentation.  No representations are made about the
suitability of this software for any purpose.  It is
provided "as is" without express or implied warranty.

*/

/* Major overhaul by Daryl Poe.
 *
 * Copyright (c) 1989 Daryl Poe
 *
 * Ported to X11 by Jim Andreas.
 * Tractors, treaties, and other features by Norm Gee.
 * Damage window and shield bitmaps by Tom LaStrange.
 *
 * The above comments apply to this version as well, and this
 * notice must also appear in any copies or follow-ons.
 */


#include <X11/X.h>
#include <X11/Xlib.h>
#include <stdio.h>
#include <time.h>
#include <fcntl.h>
#include <ndir.h>
#include <signal.h>
#include <sys/types.h>
#include <sys/param.h>
#include <sys/resource.h>
#include <sys/file.h>
#include <sys/errno.h>
#include "defs.h"
#include "weapon.h"
#include "system.h"
#include "ship.h"
#include "stats.h"
#include "player.h"
#include "torp.h"
#include "status.h"
#include "planet.h"
#include "phaser.h"
#include "message.h"
#include "shmem.h"
#include "data.h"
#include "xdata.h"

extern DIR *opendir();
/* extern void closedir(); */

#define RW_ACCESS		6
#define EXECUTE_ACCESS 	1
#define ACCESS_ERROR   -1

void savestats()
{
	DIR *dirp;
	int myuid,result,errcount,fildes;
	STATS old;
	struct rusage buf;
	long now;
	static int cpu_so_far=0;
	char filename[MAXPATHLEN],str[MAXPATHLEN+256];
	unsigned short euid,uid;

	if (me->p_flags & PFROBOT) return;

	time(&now);
	getrusage(0, &buf);
	uid = getuid();
	myuid = (int) uid;
	euid = geteuid();
	setresuid(euid,euid,uid);

	/* make sure the Scoredir exists */
	if ((dirp = opendir(Scoredir)) == NULL) {
		/* It's not there */
		if (access(Scoredir,0) != ACCESS_ERROR) {
			/* there's something else there */
			fprintf(stderr,"Cannot create scores directory %s",
				Scoredir);
			setresuid(uid,euid,uid);
			return;
		}
		else {
			/* make it */
			if (mkdir(Scoredir,0755) == -1) {
				sprintf(str,"cannot mkdir %s:",Scoredir);
				perror(str);
				setresuid(uid,euid,uid);
				return;
			}
			chown(Scoredir,geteuid(),getegid());
			chmod(Scoredir,0755);
		}
	}
	else {
		closedir(dirp);
	}

	sprintf(filename,"%s/%s",Scoredir,me->p_login);

	if ((result = access(filename,RW_ACCESS)) != ACCESS_ERROR) {
		errcount = 0;
		while (((fildes = open(filename,O_RDWR,0644)) == -1)
				&& (errno == EINTR)
				&& (errcount < 10)) {
			++errcount;
		}
		if (fildes == -1) {
			result = -1;
		}
		else {
			errcount = 0;
			while ((result = read(fildes,(char *) &old,sizeof(STATS)))
					&& (errno == EINTR)
					&& (errcount < 10)) {
				++errcount;
			}
			if (result != sizeof(STATS)) {
				sprintf(str,"Cannot read scorefile %s:",filename);
				perror(str);
				result = -1;
			}
			else if (((old.st_uid & 0xffff0000) != SCORES_MAGIC_NUMBER)
					|| ((old.st_uid & 0x0000ffff) != myuid)) {
				result = -1;
			}
			else {
				/* I've saved this guy before */
				old.st_time    += (now - start_time);
				old.st_cpu     += (buf.ru_utime.tv_sec - cpu_so_far);
				old.st_kills   += me->p_stats.st_kills;
				old.st_losses  += me->p_stats.st_losses;
				if (oldmax > old.st_maxkills) old.st_maxkills = oldmax;
				old.st_entries += me->p_stats.st_entries;
				old.st_conqs   += me->p_stats.st_conqs;
				old.st_planets += me->p_stats.st_planets;
				result = 1;
			}
		}
	}

	if (result != 1) {
		errcount = 0;
		while (((fildes = open(filename,O_WRONLY|O_CREAT,0644)) == -1)
				&& (errno == EINTR)
				&& (errcount < 10)) {
			++errcount;
		}
		if (fildes == -1) {
			sprintf(str,"Cannot open scorefile %s",filename);
			perror(str);
			setresuid(uid,euid,uid);
			return;
		}
		else {
			/* new player */
			old.st_uid      = (myuid & 0x0000ffff)
				| SCORES_MAGIC_NUMBER;
			old.st_time     = now - start_time;
			old.st_cpu      = buf.ru_utime.tv_sec;
			old.st_kills    = me->p_stats.st_kills;
			old.st_losses   = me->p_stats.st_losses;
			old.st_maxkills = oldmax;
			old.st_entries  = me->p_stats.st_entries;
			old.st_conqs    = me->p_stats.st_conqs;
			old.st_planets  = me->p_stats.st_planets;
		}
	}

	lseek(fildes,0,0);
	errcount = 0;
	while ((result = write(fildes,(char *) &old,sizeof(STATS)))
			&& (errno == EINTR)
			&& (errcount < 10)) {
		++errcount;
	}
	if (result != sizeof(STATS)) {
		sprintf(str,"Cannot write to scorefile %s:",filename);
		perror(str);
		close(fildes);
		setresuid(uid,euid,uid);
		return;
	}
	close(fildes);
	chown(filename,geteuid(),getegid());
	chmod(filename,0644);
	setresuid(uid,euid,uid);

	/* Now zero out my stats again, since I've already added the
	 * most recent stuff.
	 */
	start_time = now;
	cpu_so_far = buf.ru_utime.tv_sec;
	me->p_stats.st_kills    = 0.0;
	me->p_stats.st_losses   = 0;
	me->p_stats.st_maxkills = 0.0;
	me->p_stats.st_entries  = 0;
	me->p_stats.st_conqs    = 0;
	me->p_stats.st_planets  = 0;
}

#define BUFSIZE	1024

void printscores(win)
Window win;
{
	register int i,readchars;
	register char *eptr;
	char buf[BUFSIZE+1],*cptr;
	int pipefd[2],fontheight,pipemask,count;
	struct timeval mydelay;
	XTextItem xtext;
	int (*old_alarm_handler)();

	buf[BUFSIZE] = '\0';
	xtext.delta = 0;
	xtext.font = dfont;

	if (access(Scores,EXECUTE_ACCESS) == ACCESS_ERROR) {
		/* cannot execute Scores */
		return;
	}

	logmsg1("printscores: forking scores process\n");
	old_alarm_handler = mysignal(SIGALRM,SIG_IGN);
	XSetForeground(dpy, gc, textColor);
	XSetBackground(dpy, gc, backColor);
	XClearWindow( dpy, win);

	pipe(pipefd);
	if (fork() == 0) {
		pipedetach(pipefd[1]);
		execl(Scores,Scores,0);
		/* should never get here anyway */
		exit(0);
	}
	else {
		/* parent only */
		fontheight = dfontinfo->ascent + dfontinfo->descent;
		pipemask = 1<<pipefd[0];
		mydelay.tv_sec  = 1;
		mydelay.tv_usec = 0;
		cptr = buf;
		count = i = 0;
		/* wait for it to finish */
		wait((int *)0);
		/* is stdin ready? */
		while (select(pipefd[0]+1,&pipemask,0,0,&mydelay) > 0) {
			if ((readchars = read(pipefd[0],cptr,BUFSIZE-i))
					<= 0) {
				break;
			}
			readchars += i;
			xtext.chars = buf;
			eptr = cptr;
			do {
				while ((*eptr != '\012') && (i < readchars)) {
					++eptr;
					++i;
				}
				if (i < readchars) {
					/* print the string */
					*eptr = '\0';
					xtext.nchars = strlen(xtext.chars);
					XDrawText(dpy,win,gc,10,
						(count++) * fontheight + dfontinfo->ascent,
						&xtext,1);
					xtext.chars = ++eptr;
					++i;
				}
			} while (i < readchars);
			i = (int) (eptr - xtext.chars);
			strncpy(buf,xtext.chars,i);
			cptr = buf + i;
		}
		close(pipefd[0]);
		close(pipefd[1]);
	}
	XFlush(dpy);
	mysignal(SIGALRM,old_alarm_handler);
}


/* returns -1 on error */
static int num_score_entries()
{
	int entries;
	DIR *dirp;
	struct direct *dirent;

	if ((dirp = opendir(Scoredir)) == NULL) {
		perror("opendir failure");
		fprintf(stderr,"opendir failed on scoredir %s",Scoredir);
		return(-1);
	}

	entries = 0;
	dirent = readdir(dirp);
	while (dirent != NULL) {
		if (!SAMESTR(dirent->d_name,".")
				&& !SAMESTR(dirent->d_name,".."))
			++entries;
		dirent = readdir(dirp);
	}
	closedir(dirp);

	return(entries);
}


void create_scorewindow()
{
	int ne;

	ne = num_score_entries();

	scorewin = XCreateSimpleWindow(dpy,mapw,
		10,10,
		80*dfontinfo->max_bounds.rbearing,
		(ne+2)*(dfontinfo->ascent+dfontinfo->descent),
		2,borderColor,backColor);
	XSelectInput(dpy,scorewin,KeyPressMask|ExposureMask);
	XMapWindow(dpy,scorewin);

	/* Let the Expose event print the scores */
}
