/* playerlist.c 15.1 06/08/90 10:06:20 */
/*

	Copyright (c) 1986 	Chris Guthrie

Permission to use, copy, modify, and distribute this
software and its documentation for any purpose and without
fee is hereby granted, provided that the above copyright
notice appear in all copies and that both that copyright
notice and this permission notice appear in supporting
documentation.  No representations are made about the
suitability of this software for any purpose.  It is
provided "as is" without express or implied warranty.

*/

/* Major overhaul by Daryl Poe.
 *
 * Copyright (c) 1989 Daryl Poe
 *
 * Ported to X11 by Jim Andreas.
 * Tractors, treaties, and other features by Norm Gee.
 * Damage window and shield bitmaps by Tom LaStrange.
 *
 * The above comments apply to this version as well, and this
 * notice must also appear in any copies or follow-ons.
 */

#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <stdio.h>
#include "defs.h"
#include "weapon.h"
#include "system.h"
#include "ship.h"
#include "stats.h"
#include "player.h"
#include "torp.h"
#include "status.h"
#include "planet.h"
#include "phaser.h"
#include "message.h"
#include "shmem.h"
#include "data.h"
#include "xdata.h"

static char numltr[] = {
	'0',
	'1',
	'2',
	'3',
	'4',
	'5',
	'6',
	'7',
	'8',
	'9',
	'a',
	'b',
	'c',
	'd',
	'e',
	'f',
	'g',
	'h',
	'i',
	'j',
	'k',
	'l',
	'm',
	'o',
	'p',
	'q',
	's',
	't',
	'u',
	'v',
	'w',
	'x',
	'y',
	'z',
};


void playerlist()
{
	register int k = 0;
	char buf[BUFSIZ];
	register PLAYER *j;
	XTextItem t;

	sprintf(buf," # Team Name             Login    Display      kton Class        kills");

	XSetForeground(dpy,gc,textColor);

	t.chars = buf;
	t.nchars = strlen(buf);
	t.delta = 0;
	t.font  = dfont;
	XDrawText( dpy, playerw, gc,   0,	
		dfontinfo->ascent + dfontinfo->descent, &t, 1 );  

	k = 2;
	for (j = players; j < players+MAXPLAYER; j++) {
		if ((j->p_status != PALIVE) && (j->p_status != PIMMUNE))
			continue;
		/* else list the player */
		sprintf(buf, " %1c  %1c   %-16.16s %-8s %-12.12s %4d %-12.12s %5.2f",
		    numltr[j->p_no],
		    teamlet[j->p_team_no],
		    j->p_name,
		    j->p_login,
		    j->p_monitor,
			j->p_ship.s_hull,
			j->p_ship.s_shipname,
		    j->p_kills);

		if (j->p_status == PIMMUNE) {
			XSetForeground(dpy,gc,cloakColor);
		}
		else {
			XSetForeground(dpy,gc,playerColor(j));
		}
		t.chars = buf;
		t.nchars = strlen(buf);
		t.font  = shipFont(j);
		XDrawText( dpy, playerw, gc,   0,	
			(dfontinfo->ascent + dfontinfo->descent) * k++, &t, 1 );  
	}
	XFlush( dpy );
}
