/* player.h 15.1 06/08/90 10:06:17 */

/*

	Copyright (c) 1986 	Chris Guthrie

Permission to use, copy, modify, and distribute this
software and its documentation for any purpose and without
fee is hereby granted, provided that the above copyright
notice appear in all copies and that both that copyright
notice and this permission notice appear in supporting
documentation.  No representations are made about the
suitability of this software for any purpose.  It is
provided "as is" without express or implied warranty.

*/

/* Major overhaul by Daryl Poe.
 *
 * Copyright (c) 1989 Daryl Poe
 *
 * Ported to X11 by Jim Andreas.
 * Tractors, treaties, and other features by Norm Gee.
 * Damage window and shield bitmaps by Tom LaStrange.
 *
 * The above comments apply to this version as well, and this
 * notice must also appear in any copies or follow-ons.
 */


/* must include ship.h, stats.h before this file */

/* values for p_status */
#define PFREE 		0
#define POUTFIT 	1
#define PALIVE 		2
#define PEXPLODE 	3
#define PDEAD 		4
#define PIMMUNE		5 	/* eXited game temporarily */

/* masks for p_flags */
#define PFSHIELD	0x00000001
#define PFREPAIR	0x00000002
#define PFBOMB		0x00000004
#define PFORBIT		0x00000008
#define PFCLOAK		0x00000010
 
#define PFENG		0x00000040
#define PFROBOT		0x00000080
#define PFBEAMUP	0x00000100
#define PFBEAMDOWN	0x00000200
#define PFSELFDEST	0x00000400
#define PFGREEN		0x00000800
#define PFYELLOW	0x00001000
#define PFRED		0x00002000
#define PFPLOCK		0x00004000	/* Locked on a player */
#define PFPLLOCK	0x00008000	/* Locked on a planet */
#define PFWLOCK		0x00010000	/* weapons locked on */
#define PFCOPILOT	0x00020000	/* Allow copilots */
#define PFWAR		0x00040000	/* computer reprogramming for war */
#define PFPRACTR	0x00080000	/* practice type robot (no kills) */
#define PFECM       0x00100000	/* ECM on */
#define PFHYPERSPACE 0x00200000	/* Hyperspace engines warming up */
#define PFSPHERE	0x00400000	/* Black sphere up */
#define PFEXIT		0x00800000  /* Need to leave the game briefly */
#define PFENTER		0x01000000  /* Readying to re-enter game */
#define PFSTART		0x02000000	/* just entered game */
#define PFMONITOR	0x04000000	/* is a monitor */
#define PFPLKILLER	0x08000000	/* is a planetkiller */

/* masks for p_loanflags */
#define PFLECM		0x00000001
#define PFLSPHERE	0x00000002
#define PFLIMP_SENS	0x00000004
#define PFLCLOAK	0x00000008

/* values for p_whydead */
#define KQUIT		1		/* Player quit */
#define KTORP		2		/* killed by torp */
#define KPHASER		3		/* killed by phaser */
#define KPLANET		4		/* killed by planet */
#define KSHIP		5		/* killed by other ship */
#define KDAEMON		6		/* killed by dying daemon */
#define KWINNER		7		/* killed by a winner */
#define KGHOST		8		/* killed because a ghost */
#define KOVER		9		/* killed because game called */
#define KVORTEX		10		/* killed by Probability Vortex */

/* values for p_obscured */
#define OBSCURED_NONE	0
#define OBSCURED_PULSAR	1
#define OBSCURED_NEBULA	2

typedef struct Player{
    int p_no;				/* Player number */
    int p_updates;			/* Number of updates ship has survived */
    int p_status;			/* Player status */
    unsigned int p_flags;	/* Player flags */
    unsigned int p_loanflags;	/* Player flags loaned by other ships */
    unsigned int p_loanoutflags;	/* Stuff I'm loaning to others */
    char p_name[16];		/* Player name */
    char p_login[16];		/* login name */
    char p_monitor[16];		/* Monitor being played on */
    char p_mapchars[3];		/* I3, Rg, etc. */
    SHIP p_ship;			/* Personal ship statistics */
    int p_x,p_y;			/* current position */
	int p_ecm_dx,p_ecm_dy;	/* apparent offset to p_x, p_y due to ECM */
	int p_app_x,p_app_y;	/* apparent position due to  ECM */
    COURSE p_dir;			/* Real direction */
    COURSE p_desdir;		/* desired direction */
    int p_subdir;			/* fraction direction change */
    short p_speed;			/* Real speed */
    short p_desspeed;		/* Desired speed */
    int p_subspeed;			/* Fractional speed */
    short p_shield[4];		/* Current shield powers */
    int p_subshield;		/* Fractional shield recharge */
    short p_ntorp;			/* Number of torps flying */

	short p_tractor_type;	/* what kind of tractor beam? */
	int p_tractors_on;		/* how many tractors on? */
	int p_who_tractor;		/* player # of who the tractor beam is locked on */

	short p_team_no;		/* my team # */
    short p_team_mask;		/* mask for my team */
    char p_hostile_mask;	/* Who my torps will hurt */
	char p_treaty_mask;		/* Mask for desired war/peace status */
	char p_ally_mask;       /* Mask for desired ally  status */
    float p_kills;			/* Enemies killed */
    short p_planet;			/* Planet orbiting or locked onto */
    short p_playerl;		/* Player locked onto */
    short p_armies;			/* # armies loaded */
    int   p_fuel;			/* fuel loaded */
    short p_explode;		/* Keeps track of final explosion */
    short p_etemp;			/* engine temperature */
	short p_ecool;			/* cooling rate */
	short p_engine_health;	/* 1/256's, reduced by engine damage */
	short p_torps_unloaded;	/* # tubes not loaded */
	short p_beams_unloaded; /* phaser banks not loaded */
	short p_beams_reload;   /* time to next phaser reload */
	short p_subreload;		/* time to next torpedo reload */
    short p_whydead;		/* Tells you why you died */
    short p_whodead;		/* Tells you who killed you */
    STATS p_stats;			/* player statistics */
    int p_ghostbuster;		/* mechanism to insure daemon's running */
	short p_closest_planet;	/* closest planet to me */
	int p_closest_planet_dist;	/* closest planet dist to me */
	int p_hyp_x,p_hyp_y;	/* hyperspace destination */
	short p_wpnlock;		/* who my weapons are locked on to */
	int p_pid;				/* pid of 'robot' or 'xtrek' process */
	short p_bitmap_num;		/* which bitmap index to use */
	int p_mode;				/* bitmask of optional mode votes */
	short p_obscured;		/* what's causing obscured vision? */
	short novtent; /* which of nine map window positions I'm in */
	int map_offsetx,map_offsety; /* offset from 0,0 to mapwindow UL */
	int p_exittime;			/* timer to eXit/enter */
	int p_sensor_range;		/* my sensor range */
	unsigned int p_visible_ships; /* bitmask. which ships are visible */
	short p_stats_dirty;	/* redo stats window at next opportunity */
	short p_damage_dirty;	/* redo damage window at next opportunity */
	short p_buddy;			/* my robotic buddy */
	int p_yrange;			/* range at which I'll cause yellow alert */
} PLAYER;


typedef struct {
	char	t_treaty;  /* field for global team treaty mask */
	char    t_ally;   /*  field for global team ally   mask */ 
	char    t_starbase_died; /* has this team's starbase been killed? */
} TEAM;
