/* planetlist.c 15.1 06/08/90 10:06:11 */

/*

	Copyright (c) 1986 	Chris Guthrie

Permission to use, copy, modify, and distribute this
software and its documentation for any purpose and without
fee is hereby granted, provided that the above copyright
notice appear in all copies and that both that copyright
notice and this permission notice appear in supporting
documentation.  No representations are made about the
suitability of this software for any purpose.  It is
provided "as is" without express or implied warranty.

*/

/* Major overhaul by Daryl Poe.
 *
 * Copyright (c) 1989 Daryl Poe
 *
 * Ported to X11 by Jim Andreas.
 * Tractors, treaties, and other features by Norm Gee.
 * Damage window and shield bitmaps by Tom LaStrange.
 *
 * The above comments apply to this version as well, and this
 * notice must also appear in any copies or follow-ons.
 */


#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <stdio.h>
#include <time.h>
#include "defs.h"
#include "weapon.h"
#include "system.h"
#include "ship.h"
#include "stats.h"
#include "player.h"
#include "torp.h"
#include "status.h"
#include "planet.h"
#include "phaser.h"
#include "message.h"
#include "shmem.h"
#include "data.h"
#include "xdata.h"

/*
** Open a window which contains all the planets and their last known
** statistics. 
*/


void planetlist()
{
	static char *header_line = 
		"## Planet Name       Own Armies RPR FUEL   Info Date";
	register int i;
	char buf[256];
	register PLANET *planet;
	PLANET_INFO *pi;
	XTextItem t;
	int xhalf,xoffset,y;


	t.chars  = header_line;
	t.nchars = strlen(header_line);
	t.delta  = 0;
	t.font   = dfont;
	XDrawText( dpy, planetw, gc,     0, dfontinfo->ascent,  &t,  1 );
	xhalf = (t.nchars + 4) * dfontinfo->max_bounds.rbearing;
	XDrawText( dpy, planetw, gc, xhalf, dfontinfo->ascent,  &t,  1 );

	t.chars = buf;
	xoffset = 0;
	for (i = 0, planet = planets, y = 2;
			i < MAXPLANETS;
			++planet, ++i, ++y) {
		if (i == (MAXPLANETS/2)) {
			xoffset = xhalf;
			y = 2;
		}

		if (planet->pl_flags & PLMASK_BLACKHOLE) {
			sprintf(buf, "%2d %-17s ---      0          black hole",
		   	 	planet->pl_no,
		   	 	planet->pl_name);
			XSetForeground(dpy,gc,cloakColor);
		}
		else if (planet->pl_flags & PLMASK_PULSAR) {
			sprintf(buf, "%2d %-17s ---      0          pulsar",
		   	 	planet->pl_no,
		   	 	planet->pl_name);
			XSetForeground(dpy,gc,cloakColor);
		}
		else if (planet->pl_flags & PLMASK_NEBULA) {
			sprintf(buf, "%2d %-17s ---      0          nebula",
		   	 	planet->pl_no,
		   	 	planet->pl_name);
			XSetForeground(dpy,gc,cloakColor);
		}
		else if (planet->pl_flags & PLMASK_BARREN) {
			sprintf(buf, "%2d %-17s ---      0          barren",
		   	 	planet->pl_no,
		   	 	planet->pl_name);
			XSetForeground(dpy,gc,cloakColor);
		}
		else {
			if ((planet->pl_owner_no == me->p_team_no)
					|| (me->p_team_no == INDEPENDENT)) { /* for watch */
				/* It's mine.  Show current info */
				sprintf(buf,"%2d %-17s %3s %6d %3s %4s %11s",
		    		planet->pl_no,
		    		planet->pl_name,
		    		teamshort[planet->pl_owner_no],
		    		planet->pl_armies,
		    		(planet->pl_flags & PLMASK_REPAIR ? "RPR"  : "   "),
		    		(planet->pl_flags & PLMASK_FUEL   ? "FUEL" : "    "),
					"- current -");
			}
			else {
				/* Not mine -- show last known info */
				pi = &(planet->pl_info[me->p_team_no]);
				sprintf(buf,"%2d %-17s %3s %6d %3s %4s %11s",
		    		planet->pl_no,
		    		planet->pl_name,
		    		teamshort[pi->pi_owner_no],
		    		pi->pi_armies,
		    		(pi->pi_flags & PLMASK_REPAIR ? "RPR"  : "   "),
		    		(pi->pi_flags & PLMASK_FUEL   ? "FUEL" : "    "),
					nl_cxtime(&(pi->pi_timestamp),"%m/%d %H:%M"));
			}

			XSetForeground(dpy,gc,planetColor(planet));
		}

		t.nchars = strlen(buf);
		XDrawText( dpy, planetw, gc,
			xoffset, (dfontinfo->ascent+dfontinfo->descent) * y, &t, 1);
	}

	XFlush( dpy );
}
