/* planet.h 15.1 06/08/90 10:06:08 */

/*

	Copyright (c) 1986 	Chris Guthrie

Permission to use, copy, modify, and distribute this
software and its documentation for any purpose and without
fee is hereby granted, provided that the above copyright
notice appear in all copies and that both that copyright
notice and this permission notice appear in supporting
documentation.  No representations are made about the
suitability of this software for any purpose.  It is
provided "as is" without express or implied warranty.

*/

/* Major overhaul by Daryl Poe.
 *
 * Copyright (c) 1989 Daryl Poe
 *
 * Ported to X11 by Jim Andreas.
 * Tractors, treaties, and other features by Norm Gee.
 * Damage window and shield bitmaps by Tom LaStrange.
 *
 * The above comments apply to this version as well, and this
 * notice must also appear in any copies or follow-ons.
 */

/* An important note concerning planets:  The game assumes that
    the planets are in a 'known' order.  Ten planets per team,
    the first being the home planet.
*/

/* the 5 lower bits represent the original owning team mask */
#define PLMASK_REPAIR 		0x00000020
#define PLMASK_FUEL 		0x00000040
#define PLMASK_REDRAW		0x00000080	/* Player close for redraw */
#define PLMASK_HOME 		0x00000100	/* home planet for a given team */
#define PLMASK_COUP 		0x00000200	/* Coup has occured */
#define PLMASK_BLACKHOLE	0x00000400	/* planet is blackhole */
#define PLMASK_PULSAR		0x00000800	/* planet is pulsar */
#define PLMASK_BARREN		0x00001000	/* planet is barren */
#define PLMASK_WANDERER		0x00002000	/* planet moves */
#define PLMASK_NEBULA		0x00004000	/* planet is nebula */
#define PLMASK_TMPBARREN	0x00008000  /* temporarily barren */
#define PLMASK_AST_FIELD	0x00010000	/* asteroid field */

/* home planets */
#define FED_HOME	0
#define ROM_HOME	10
#define KLI_HOME	20
#define ORI_HOME	30
#define IND_HOME	40

/* misc. properties */
#define NEBULA_RADIUS		(GWIDTH/24)	/* area affected by a nebula */
#define AST_FIELD_RADIUS	(192*SCALE/2)	/* ... by asteroid field */
#define INTERPLANETARY_DIST	(GWIDTH/12) /* min dist between planets */
#define BLACKHOLE_STR		7			/* warp strength of blackhole */

typedef struct {
	int pi_flags;		/* last known state info */
	int pi_owner_no;	/* last known owner */
	int pi_armies;		/* last known army count */
	long pi_timestamp;		/* last time this info updated */
} PLANET_INFO;

typedef struct {
    short pl_no;			/* planet number */
    int pl_flags;		/* planet state information */
    int pl_owner_no;	/* owner team # */
    int pl_owner_mask;	/* owner team mask */
    int pl_x;			/* location */
    int pl_y;
    char pl_name[40];	/* its name */
    int pl_namelen;		/* Cuts back on strlen's */
    int pl_armies;		/* # armies on planet */
    int pl_deadtime;	/* Time before planet will support life */
    int pl_couptime;	/* Time before coup may take place */
	PLANET_INFO pl_info[NUMTEAM];	/* Last known info on planet */
	int pl_dx,pl_dy;	/* for wandering planets */
} PLANET;

/* from input.c */
extern PLANET *select_entry_planet();
