/* phaser.c 15.1 06/08/90 10:06:02 */

/*

	Copyright (c) 1986 	Chris Guthrie

Permission to use, copy, modify, and distribute this
software and its documentation for any purpose and without
fee is hereby granted, provided that the above copyright
notice appear in all copies and that both that copyright
notice and this permission notice appear in supporting
documentation.  No representations are made about the
suitability of this software for any purpose.  It is
provided "as is" without express or implied warranty.

*/

/* Major overhaul by Daryl Poe.
 *
 * Copyright (c) 1989 Daryl Poe
 *
 * Ported to X11 by Jim Andreas.
 * Tractors, treaties, and other features by Norm Gee.
 * Damage window and shield bitmaps by Tom LaStrange.
 *
 * The above comments apply to this version as well, and this
 * notice must also appear in any copies or follow-ons.
 */

#include <stdio.h>
#include "defs.h"
#include "ship.h"
#include "stats.h"
#include "player.h"
#include "torp.h"
#include "status.h"
#include "planet.h"
#include "phaser.h"
#include "message.h"
#include "shmem.h"
#include "weapon.h"
#include "data.h"
#include "daemon.h"

#define TORP_RADIUS	(12*SCALE)

int fire_beam(aim,aimx,aimy,wanted_beams)
COURSE aim;
int aimx,aimy,wanted_beams;
{
	PLAYER *player;
	TORP *tptr;
	PHASER *beamptr;
	COURSE dir;
	int i,torpnum,delta,pdelta,range,trange,beamrange,dx,dy;
	int im_planetkiller;
	char str[80];
	int loaded_beams,fired_beams;
	static char *torpname[] = {
		"photon",
		"missile",
		"plasma",
		"chaff",
		"mine",
		"",
		"",
		"",
		"",
		"",
		"",
		"vortex",
		"vortex",
		"unknown torp",
	};

	if ( myship->s_beams == 0 ) {
		sprintf(str,"No %s beams able to fire",myship->s_beamname);
		warning(str);
		return(FALSE);
	}

	if (me->p_flags & PFREPAIR) {
		warning("Cannot fire while repairing");
		return(FALSE);
	}

	if (me->p_flags & PFCLOAK) {
		warning("Cannot fire while cloaked");
		return(FALSE);
	}

	if (me->p_flags & PFSPHERE) {
		warning("Cannot fire while in sphere");
		return(FALSE);
	}

	if (me->p_fuel < myship->s_beamcost) {
		sprintf(str,"Not enough fuel to fire %ss.",myship->s_beamname);
		warning(str);
		return(FALSE);
	}

	if ((loaded_beams = 
			(int) myship->s_beams - (int) me->p_beams_unloaded) <= 0) {
		sprintf(str,"Still recharging %s beams",myship->s_beamname);
		warning(str);
		return(FALSE);
	}

	if (wanted_beams <= 0) wanted_beams = loaded_beams;

	/* find an empty beam slot */
	for (i = 0,beamptr = &phasers[me->p_no*MAXBEAM];
			i < MAXBEAM;
			++i, ++beamptr) {
		if (beamptr->ph_status == PHFREE) break;
	}
	if (i == MAXBEAM) {
		sprintf(str,"Still recharging %s beams",myship->s_beamname);
		warning(str);
		return(FALSE);
	}

	/* look for a close-by enemy ship */
	beamptr->ph_status = PHMISS;
	fired_beams        = 1;
	beamrange = pdelta = myship->s_beamrange + EXPDIST;
	im_planetkiller = me->p_flags & PFPLKILLER;
	for (player = players; player < players+MAXPLAYER; ++player) {
		if ((player->p_status != PALIVE) || (player == me)) continue;
		if ((sharedMemory->mode & SMART_WEAP_MASK)
				&& !(me->p_hostile_mask & player->p_team_mask)
				&& !im_planetkiller
				&& !(player->p_flags & PFPLKILLER))
			continue;
		if ((delta = Ihypot(player->p_x - aimx,
				player->p_y - aimy) > pdelta))
			continue;
		if ((trange = Ihypot((dx = player->p_x - me->p_x),
				(dy = player->p_y - me->p_y))) > beamrange)
			continue;

		dir = Atan2(-dy,dx);

		logmsg5("phaser xt %d xme %d yt %d yme %d",
			player->p_x,me->p_x,player->p_y,me->p_y);
		logmsg2("  dir: %d",(int) dir);
		logmsg3("aim: %d, angdist %d\n",
			(int)aim,(int)angdist(dir,aim));
		/* difficult to shoot into an asteroid field */
		if ((planets[player->p_closest_planet].pl_flags & PLMASK_AST_FIELD)
				&& (player->p_closest_planet_dist < AST_FIELD_RADIUS)
				&& (INTRAND(3))) {
			/* miss */
		}
		else if ((angdist(dir, aim) < myship->s_beamaccuracy) 
				|| (is_vector_close_to_point(
					me->p_x,me->p_y,aim,myship->s_beamrange,
					player->p_x,player->p_y,EXPDIST))) {
			pdelta             = delta;
			range              = trange;
			fired_beams        = loaded_beams;
			beamptr->ph_status = PHHITPLAYER;
			beamptr->ph_target = player->p_no;
		}
	}

	if ((pdelta > EXPDIST)
			&& (sharedMemory->mode & DEFENSIVE_BEAM_MASK)) {
		/* search for a nearer torp */
		tptr = torps;
		torpnum = 0;
		for (player = players; player < players+MAXPLAYER; ++player) {
			if ((player->p_status != PALIVE) ) {
				tptr    += MAXTORP;
				torpnum += MAXTORP;
				continue;
			}
			if ((sharedMemory->mode & SMART_WEAP_MASK)
					&& (player == me)) {
				tptr    += MAXTORP;
				torpnum += MAXTORP;
				continue;
			}
			for (i=0; i<MAXTORP; ++i,++tptr,++torpnum) {
				if ((tptr->t_status == TFREE)
						|| (tptr->t_status == TEXPLODE))
					continue;
				if ((sharedMemory->mode & SMART_WEAP_MASK)
						&& (!(tptr->t_war_mask & me->p_team_mask)))
					continue;

				if ((delta = Ihypot(tptr->t_x - aimx,
						tptr->t_y - aimy) > pdelta))
					continue;
				if ((trange = Ihypot((dx = tptr->t_x - me->p_x),
						(dy = tptr->t_y - me->p_y))) > beamrange)
					continue;
		
				dir = Atan2(-dy,dx);

				logmsg5("phaser xt torp %d xme %d yt %d yme %d",
					tptr->t_x,me->p_x,tptr->t_y,me->p_y);
				logmsg2("  dir: %d",(int) dir);
				logmsg3("aim: %d, angdist %d\n",
					(int)aim,(int)angdist(dir,aim));

				if ((angdist(dir, aim) < myship->s_beamaccuracy) 
						|| (is_vector_close_to_point(
							me->p_x,me->p_y,aim,myship->s_beamrange,
							tptr->t_x,tptr->t_y,TORP_RADIUS))) {
					pdelta             = delta;
					range              = trange;
					fired_beams        = 1;
					beamptr->ph_status = PHHITTORP;
					beamptr->ph_target = torpnum;
				}
			}
		}
	}

	/* check vortices */
	if ((pdelta > EXPDIST)
			&& (sharedMemory->mode & PROB_VORTEX_MASK)) {
		/* search for a nearer vortex */
		for (tptr=torps + MAXPLAYER*MAXTORP, torpnum=MAXPLAYER*MAXTORP;
				torpnum < MAXPLAYER*MAXTORP + MAXPVORTICES;
				++tptr,++torpnum) {
			if ((tptr->t_status == TFREE)
					|| (tptr->t_status == TEXPLODE))
				continue;

			if ((delta = Ihypot(tptr->t_x - aimx,
					tptr->t_y - aimy) > pdelta))
				continue;
			if ((trange = Ihypot((dx = tptr->t_x - me->p_x),
					(dy = tptr->t_y - me->p_y))) > beamrange)
				continue;
	
			dir = Atan2(-dy,dx);

			logmsg5("phaser vortex xt %d xme %d yt %d yme %d",
				tptr->t_x,me->p_x,tptr->t_y,me->p_y);
			logmsg2("  dir: %d",(int) dir);
			logmsg3("aim: %d, angdist %d\n",
					(int)aim,(int)angdist(dir,aim));

			if ((angdist(dir, aim) < myship->s_beamaccuracy) 
					|| (is_vector_close_to_point(
						me->p_x,me->p_y,aim,myship->s_beamrange,
						tptr->t_x,tptr->t_y,TORP_RADIUS))) {
				pdelta             = delta;
				range              = trange;
				fired_beams        = 1;
				beamptr->ph_status = PHHITTORP;
				beamptr->ph_target = torpnum;
			}
		}
	}

	/* difficult to shoot from an asteroid field */
	if ((planets[me->p_closest_planet].pl_flags & PLMASK_AST_FIELD)
			&& (me->p_closest_planet_dist < AST_FIELD_RADIUS)
			&& (INTRAND(3))) {
		beamptr->ph_status = PHMISS;
		fired_beams        = 1;
	}

	if (fired_beams > wanted_beams) fired_beams = wanted_beams;

	if (me->p_fuel < myship->s_beamcost*fired_beams) {
		if ((fired_beams = me->p_fuel/myship->s_beamcost) == 0) {
			sprintf(str,"Not enough fuel to fire %ss.",
				myship->s_beamname);
			warning(str);
			return(FALSE);
		}
		else {
			if (fired_beams > loaded_beams) fired_beams = loaded_beams;
			sprintf(str,"Not enough fuel to fire all %ss.",
				myship->s_beamname);
			warning(str);
		}
	}

	me->p_beams_unloaded += fired_beams;  /* unload the fired banks */
	if (me->p_beams_reload == 0)
	   me->p_beams_reload = myship->s_beamreload;

	me->p_fuel -= myship->s_beamcost * fired_beams;

	if (beamptr->ph_status == PHMISS) {
		sprintf(str,"%s missed!!!",myship->s_beamname);
		warning(str);
	}
	else if (beamptr->ph_status == PHHITPLAYER) {
		player = &players[beamptr->ph_target];

		beamptr->ph_x = player->p_x; beamptr->ph_y = player->p_y;
		beamptr->ph_damage = myship->s_beamdamage;
		if (myship->s_beamatten > 0)
			beamptr->ph_damage -= range / myship->s_beamatten;
		beamptr->ph_damage *= fired_beams;
		if (beamptr->ph_damage <= 0) beamptr->ph_damage = 1;
		sprintf(str, "Hit %s with %s for %d points",
			player->p_name, myship->s_beamname, beamptr->ph_damage);
		warning(str);
	}
	else {
		/* PHHITTORP */
		tptr = &torps[beamptr->ph_target];
		beamptr->ph_x = tptr->t_x; beamptr->ph_y = tptr->t_y;
		if (tptr->t_class == WPN_PHOTON) {
			beamptr->ph_damage = myship->s_beamdamage * 2;
		}
		else if (tptr->t_class == WPN_PLASMA) {
			beamptr->ph_damage = myship->s_beamdamage / 2;
		}
		else if (tptr->t_class == WPN_CHAFF) {
			beamptr->ph_damage = 0;
		}
		else {
			beamptr->ph_damage = myship->s_beamdamage;
		}
		if (myship->s_beamclass == WPN_TACHYON) {
			beamptr->ph_damage *= 4;
		}
		if (myship->s_beamatten > 0)
			beamptr->ph_damage -= range / myship->s_beamatten;
		if (beamptr->ph_damage <= 0) beamptr->ph_damage = 1;
		if (tptr->t_class != WPN_PROB_VORTEX) {
			if (beamptr->ph_damage > tptr->t_damage) {
				sprintf(str, "Destroyed %s with %s",
					torpname[tptr->t_class],myship->s_beamname);
				warning(str);
			}
			else {
				sprintf(str, "Reduced %s by %d points",
					torpname[tptr->t_class],beamptr->ph_damage);
				warning(str);
			}
		}
	}

	beamptr->ph_owner_no = me->p_no;
	beamptr->ph_dir      = aim;
	beamptr->ph_fuse     = myship->s_beamreload;
	beamptr->ph_class    = myship->s_beamclass;

	return(TRUE);
}


int fire_tractors(aim,tractor_type,num_tractors)
COURSE aim;
int tractor_type,num_tractors;
{
	PLAYER *j, *target;
	COURSE dir,accuracy;
	int range,trange;
	char str[80];

	if (myship->s_tractor == 0) {
		sprintf(str,"No tractor beams able to fire");
		warning(str);
		return(FALSE);
	}

	if (me->p_fuel < TRACTOR_FUEL * num_tractors) {
		sprintf(str,"Not enough fuel to fire tractors.");
		warning(str);
		return(FALSE);
	}

	if (me->p_flags & PFREPAIR) {
		warning("Cannot fire while repairing");
		return(FALSE);
	}

	if (me->p_flags & PFCLOAK) {
		warning("Cannot fire while cloaked");
		return(FALSE);
	}

	if (num_tractors > myship->s_tractor)
		num_tractors = myship->s_tractor;

	/* fuel will be taken out by the daemon */

	target = NULL;
	trange = TRACTOR_RANGE + EXPDIST;
	for (j = players; j < players+MAXPLAYER; j++) {
		if ((j->p_status != PALIVE) || (j == me))
			continue;
		if ((range = Ihypot(j->p_x-me->p_x, j->p_y-me->p_y)) > trange)
			continue;

		dir = Atan2(me->p_y - j->p_y, j->p_x - me->p_x);
		logmsg5("tractor xt %d xme %d yt %d yme %d",
			j->p_x,me->p_x,j->p_y,me->p_y);
		logmsg2("  dir: %d",(int) dir);
		accuracy = TRACTOR_ACCURACY;
		if ((range < DETDIST) && (accuracy < 64)) accuracy = 64;

		logmsg4("  accuracy: %d, aim: %d, angdist %d\n",
			(int)accuracy,(int)aim,(int)angdist(dir,aim));
		if (angdist(dir, aim) < accuracy) {
				target = j;
				trange = range;
		}
	}

	if (target == NULL) {
		sprintf(str,"Tractors missed!!!");
		warning(str);
	}
	else {
		me->p_tractors_on  = num_tractors;
		me->p_tractor_type = tractor_type;
		me->p_who_tractor  = target->p_no;
		if (num_tractors > 1) {
			sprintf(str, "Hit %s with Tractor Beam",target->p_name);
		}
		else {
			sprintf(str, "Hit %s with %d Tractor Beams",target->p_name,
				num_tractors);
		}
		warning(str);
	}

	return(TRUE);
}
