/* orbit.c 15.1 06/08/90 10:05:59 */

/*

	Copyright (c) 1986 	Chris Guthrie

Permission to use, copy, modify, and distribute this
software and its documentation for any purpose and without
fee is hereby granted, provided that the above copyright
notice appear in all copies and that both that copyright
notice and this permission notice appear in supporting
documentation.  No representations are made about the
suitability of this software for any purpose.  It is
provided "as is" without express or implied warranty.

*/

/* Major overhaul by Daryl Poe.
 *
 * Copyright (c) 1989 Daryl Poe
 *
 * Ported to X11 by Jim Andreas.
 * Tractors, treaties, and other features by Norm Gee.
 * Damage window and shield bitmaps by Tom LaStrange.
 *
 * The above comments apply to this version as well, and this
 * notice must also appear in any copies or follow-ons.
 */


#include <stdio.h>
#include "defs.h"
#include "weapon.h"
#include "system.h"
#include "ship.h"
#include "stats.h"
#include "player.h"
#include "torp.h"
#include "status.h"
#include "planet.h"
#include "phaser.h"
#include "message.h"
#include "shmem.h"
#include "data.h"


/* orbit a planet */

void orbit(player)
PLAYER *player;
{
	register int i;
	register PLANET *l;
	COURSE dir;
	int dx, dy;

	if (player->p_speed > ORBSPEED) {
		warning("Speed must be less than two to orbit");
		return;
	}
	for (i = 0, l = &planets[i]; i < MAXPLANETS; i++, l++) {
		dx = ABS(l->pl_x - player->p_x);
		dy = ABS(l->pl_y - player->p_y);
		if (dx > ENTORBDIST || dy > ENTORBDIST)		/*XXX*/
			continue;
		if (dx * dx + dy * dy > ENTORBDIST * ENTORBDIST)
			continue;
		if (l->pl_flags & (PLMASK_BLACKHOLE|PLMASK_NEBULA)) {
			/* cannot orbit these */
			break;
		}

		if (player->p_flags & PFEXIT) {
			begin_exit_countdown(player);
		}

		dir = Atan2(l->pl_y - player->p_y, player->p_x - l->pl_x);
		player->p_dir        = dir + 64;
		player->p_flags     |= PFORBIT;
		player->p_x          = l->pl_x + ORBDIST * Cos[dir];
		player->p_y          = l->pl_y + ORBDIST * Sin[dir];
		player->p_speed      = player->p_desspeed = 0;
		player->p_planet     = l->pl_no;

		return;
	}
	warning("Not close enough to any planet to orbit");
}


/* Can exit because I'm orbiting a good planet */
void begin_exit_countdown(player)
PLAYER *player;
{
	char buf[256],addrbuf[80];

	player->p_exittime = player->p_updates + 300;
	player->p_flags |= PFEXIT;
	warning("Exit countdown beginning");
	/**** send message to all players ****/
	sprintf(buf, "%s (%s) temporarily exiting game in 30 seconds",
   		player->p_name, player->p_mapchars);
	sprintf(addrbuf, " %s->ALL", player->p_mapchars);
	pmessage(buf, 0, MALL, addrbuf);
}
