/* newwin.c 15.1 06/08/90 10:05:53 */
/*

	Copyright (c) 1986 	Chris Guthrie

Permission to use, copy, modify, and distribute this
software and its documentation for any purpose and without
fee is hereby granted, provided that the above copyright
notice appear in all copies and that both that copyright
notice and this permission notice appear in supporting
documentation.  No representations are made about the
suitability of this software for any purpose.  It is
provided "as is" without express or implied warranty.

*/

/* Major overhaul by Daryl Poe.
 *
 * Copyright (c) 1989 Daryl Poe
 *
 * Ported to X11 by Jim Andreas.
 * Tractors, treaties, and other features by Norm Gee.
 * Damage window and shield bitmaps by Tom LaStrange.
 *
 * The above comments apply to this version as well, and this
 * notice must also appear in any copies or follow-ons.
 */

#include <X11/X.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <math.h>
#include <stdio.h>
#include <sys/types.h>
#include <time.h>
#include "defs.h"
#include "weapon.h"
#include "system.h"
#include "ship.h"
#include "stats.h"
#include "player.h"
#include "torp.h"
#include "status.h"
#include "planet.h"
#include "phaser.h"
#include "message.h"
#include "shmem.h"
#include "data.h"
#include "xdata.h"

#define SIZEOF(a)	(sizeof (a) / sizeof (*(a)))

#define BOXSIDE		(WINSIDE / 5)
#define BORDER		4
#define TILESIDE	16
#define MESSAGESIZE	20
#define STATSIZE	(MESSAGESIZE * 2 + BORDER)
#define YOFF		100

#define bkgndtile_width 16
#define bkgndtile_height 16
static short bkgndtile_bits[] = {
   0x0101, 0x0202, 0x0404, 0x0808,
   0x1010, 0x2020, 0x4040, 0x8080,
   0x0101, 0x0202, 0x0404, 0x0808,
   0x1010, 0x2020, 0x4040, 0x8080
};
static Pixmap bkgndTile;

/* 
 * #define tnebula_width 16
 * #define tnebula_height 16
 * static char tnebula_bits[] = {
 * 	0xea,0x5a,0x3f,0xad,0xb1,0xb8,0x19,0x05,0x4c,0xdb,0xd9,0x4a,
 * 	0x3b,0xd6,0xd1,0x25,0x65,0xfb,0x9a,0x90,0x61,0xbf,0x3f,0x82,
 * 	0x4d,0x3b,0x93,0xa9,0x4e,0xf5,0xd5,0xa2
 * };
 * static Pixmap nebTile;
 */

extern char keymap[128];  /* what each key maps to */

static XFontStruct	*bigFont;
static int tcount[6] = {
	-1, -1, -1, -1, -1, -1
};

set_class(window, class, name)
Window window;
char *class, *name;
{
	XClassHint xch;     /* Class hint for window manager */

	xch.res_class = class;
	xch.res_name = name;

	XSetClassHint(dpy, window, &xch);
}

static int numShips(owner)
{
	int		i, num = 0;
	PLAYER *p;

	for (i = 0, p = players; i < MAXPLAYER; i++, p++)
		if ((p->p_status != PFREE)
				&& (p->p_status != PEXPLODE)
				&& (p->p_status != PDEAD)
				&& (p->p_team_no == owner)
				&& (!(p->p_flags & PFROBOT))) {
			num++;
	}
	return (num);
}

static char	*AUTHOR[] = {
	"---  Improved XTREK for X11  ---",
	"Original game by Chris Guthrie and Ed James; Port to X11 by Jim Andreas",
	"Extensive modifications by Daryl Poe, Norm Gee, and Tom LaStrange",
	"Playtesting by a Cast of Thousands"
};

static void showMotd()
{
	char buf[BUFSIZ];
	FILE *motd, *fopen();
	int	i, length, top, center;

	XSetForeground(dpy, gc, textColor);
	XSetBackground(dpy, gc, backColor);
	XSetFont(dpy, gc, dfont);

	/* Author Gratification */
	XClearWindow( dpy, mainw);
	for (i = 0; i < SIZEOF(AUTHOR); i++)
	{
		length = strlen(AUTHOR[i]);
		center = WINSIDE / 2 - (length * dfontinfo->max_bounds.rbearing) / 2;
		XDrawImageString(dpy, mainw, gc, center,
		    (i * (dfontinfo->ascent + dfontinfo->descent) + dfontinfo->ascent),
			AUTHOR[i], length);
	}
	top = SIZEOF(AUTHOR) + 1;

	/* the following will print a motd */
	if ((motd = fopen(Motd, "r")) != NULL)
	{
		for (i = top; fgets(buf, sizeof (buf), motd) != NULL; i++)
		{
			length = strlen(buf);
			buf[length-1] = NULL;
			if (length > 80)
				length = 80;

			XDrawImageString(dpy, mainw, gc, 20,
				(i * (dfontinfo->ascent + dfontinfo->descent) +
					dfontinfo->ascent),
				buf, length);

		}
		(void) fclose(motd);
	}
}

static void getFonts(prog)
char	*prog;
{
	char	*font;

	if ((font = XGetDefault(dpy, prog, "font")) == NULL)
		font = "6x10";
	if ((dfontinfo = XLoadQueryFont( dpy, font)) == NULL) {
		perror(font);
		exit(1);
	}

	if ((font = XGetDefault( dpy, prog, "boldfont")) == NULL)
		font = "6x10";
	if ((bfontinfo = XLoadQueryFont( dpy, font)) == NULL)
		bfontinfo = dfontinfo;

	if ((font = XGetDefault( dpy, prog, "italicFont")) == NULL)
		font = "6x10";
	if ((ifontinfo = XLoadQueryFont( dpy, font)) == NULL)
		ifontinfo = dfontinfo;

	if ((font = XGetDefault( dpy, prog, "bigFont")) == NULL)
		font = "fg-40";
	if ((bigFont = XLoadQueryFont( dpy, font)) == NULL)
		bigFont = dfontinfo;

	dfont = dfontinfo->fid;
	bfont = bfontinfo->fid;
	ifont = ifontinfo->fid;
}


static void getResources(prog)
char	*prog;
{
	getColorDefs(prog);
	getFonts(prog);
	/* initStats(prog); */

	showShields = TRUE;
	showStats = booleanDefault(prog, "showstats");
	init_keymap(prog);
}


static void redrawEntry(teamno, p, w, fg)
int teamno;
char *p;
Window w;
unsigned long fg;
{
    char buf[BUFSIZ];
	int ns;

	if ((ns = numShips(teamno)) != tcount[teamno]) {
    	XClearWindow(dpy, w);
    	XSetForeground(dpy, gc, fg);
    	XSetFont(dpy, gc, dfont);
    	XDrawString(dpy, w, gc, 8, 15, p, strlen(p));
	
    	XSetFont(dpy, gc, bigFont->fid);
    	sprintf(buf, "%d ", ns);
    	XDrawString(dpy, w, gc, 20, 60, buf, strlen(buf));
		tcount[teamno] = ns;
	}
}

static void redrawQuit(qwin)
Window qwin;
{
	XTextItem t;
	XGCValues values;

	values.foreground = textColor;
	values.background = backColor;
	;
	XChangeGC( dpy, 
	    gc,
	    GCForeground | GCBackground,
	    &values );

	t.chars = "Quit dtrek";
	t.nchars = strlen(t.chars);
	t.delta = 0;
	t.font  = dfont;

	XClearWindow( dpy, qwin);
	XDrawText(dpy,qwin,gc,8,15,&t,1); 
}

typedef struct {
	char initialkeys[20];
	char description[40];
} HELPSTUFF;

static HELPSTUFF help_message[] = {
	{ "A", "Alias one key to another" },
	{ "p", "Fire all beam weapons"	},
	{ ";", "Fire one beam weapon"	},
	{ "t", "Launch torpedo"	},
	{ "0123456789", "Set speed"	},
	{ "[", "-1 to speed"	},
	{ "]", "+1 to speed"	},
	{ "j", "Set course"	},
	{ "+", "Put up screens"	},
	{ "-", "Put down screens"	},
	{ "s", "Toggle screens"	},
	{ "i", "Get info on player/planet"	},
	{ "b", "Bomb planet"	},
	{ "z", "Beam up armies"	},
	{ "x", "Beam down armies"	},
	{ "R", "Enter repair mode"	},
	{ "o", "orbit planet"	},
	{ "Q", "Quit"	},
	{ "X", "eXit temporarily"	},
	{ "?", "Review messages"	},
	{ "C", "Coup a planet"	},
	{ "l", "nav. Lock on to player/planet"	},
	{ "k", "weapon lock on to a player"	},
	{ "K", "negate weapon lock"	},
	{ "@", "(Dis)Allow copilots"	},
	{ "L", "(Un)Map player list window"	},
	{ "P", "(Un)Map planet list window"	},
	{ "S", "(Un)Map status window"	},
	{ "h", "(Un)Map help window"	},
	{ "w", "(Un)Map war window"	},
	{ "m", "(Un)Map game mode window"	},
	{ "g", "(Un)Map galaxy chart window"	},
	{ "V", "(Un)Map scores window"	},
	{ "$", "Send in IND practice robot"	},
	{ "%", "Send in FED practice robot"	},
	{ "^", "Send in ROM practice robot"	},
	{ "&", "Send in KLI practice robot"	},
	{ "*", "Send in ORI practice robot"	},
	{ "c", "toggle Cloak mode"	},
	{ "H", "toggle Hyperspace engines"	},
	{ "T", "toggle Tractor Beams"	},
	{ "Y", "toggle Repulsor Beams"	},
	{ "W", "toggle Winch Beams"	},
	{ "U", "toggle Unwich Beams"	},
	{ "O", "fire one more Tractor Beam"	},
	{ "y", "fire one more Repulsor Beam"	},
	{ "I", "fire one more Winch Beam"	},
	{ "u", "fire one more Unwich Beam"	},
	{ "E", "toggle ECM"	}
};

#define MAXHELP_LTRS 40

void fillhelp()
{
	int i, j, row, column;
	XTextItem t;
	XGCValues values;
	char *cptr,*nkptr,nowkeys[128],str[80];
	HELPSTUFF *hs;
	int nummsg;

	values.foreground = textColor;
	XChangeGC( dpy, gc, GCForeground, &values );
	t.delta = 0;
	t.font  = dfont;

	nummsg = sizeof(help_message)/sizeof(HELPSTUFF);
	i = 0; hs = help_message;

	for (column = 0; column < 4; column++) {
		for (row = 1; row < 14; row++) {
			if (i >= nummsg) break;
			else {
				cptr  = hs->initialkeys;
				nkptr = nowkeys;
				while (*cptr != '\0') {
					/* find all keys mapped to *cptr */
					for (j=((int) ' '); j<128; ++j) {
						if (keymap[j] == *cptr) {
							*nkptr++ = (char) j;
						}
					}
					++cptr;
				}
				*nkptr = '\0';

				sprintf(str,"%5s %s",nowkeys,hs->description);
				
				t.chars  = str;
				t.nchars = strlen(str);
				XDrawText( dpy, helpWin, gc,
					dfontinfo->max_bounds.rbearing
						* (MAXHELP_LTRS * column + 1),
				    (dfontinfo->ascent + dfontinfo->descent) * row
						+ dfontinfo->ascent,
				    &t, 1 );
				++i; ++hs;
			}
		}
		if (i >= nummsg) break;
	}
}

void drawIcon()
{
#ifdef NotUsed
	XBitmapBitsPut(iconWin, 0, 0, icon_width, icon_height, icon_bits, 
	    WhitePixel, BlackPixel, 0, GXcopy, AllPlanes);
#endif
}

static Window	clockwin;

#define CLOCK_WID	(BOXSIDE * 9 / 10)
#define CLOCK_HEI	(BOXSIDE * 2 / 3)
#define CLOCK_BDR	0
#define CLOCK_X		(BOXSIDE / 2 - CLOCK_WID / 2)
#define CLOCK_Y		(BOXSIDE / 2 - CLOCK_HEI / 2)

static void makeClock(window)
Window	window;
{
	clockwin = XCreateSimpleWindow(dpy, window, CLOCK_X, CLOCK_Y,
		CLOCK_WID, CLOCK_HEI, CLOCK_BDR, borderColor,backColor);
	XMapWindow(dpy, clockwin);
}

static void destroyClock()
{
	XDestroyWindow( dpy, clockwin);
}

#include "clock.bitmap"

static void showTimeLeft(tm, max)
{
	char	buf[BUFSIZ];
	int	cx, cy, ex, ey, tx, ty;
	XTextItem t;
	XGCValues values;
	XImage  image;

	XClearWindow( dpy, clockwin);

	values.foreground = textColor;
	XChangeGC( dpy, gc, GCForeground, &values );

	cx = CLOCK_WID / 2;
	cy = (CLOCK_HEI - dfontinfo->ascent) / 2;
	ex = cx - clock_width / 2;
	ey = cy - clock_height / 2;

	memset( &image, 0, sizeof( image ));
	image.width = 48;
	image.height = 48;
	image.format = XYBitmap;
	image.data = (char *)clock_bits;
	image.byte_order = MSBFirst;
	image.bitmap_unit = 16; /* ?*/
	image.bitmap_bit_order = LSBFirst;
	image.bitmap_pad = 0;
	image.depth = 1;
	image.bytes_per_line = 6;
	image.bits_per_pixel = 1;

	XPutImage( dpy, clockwin,	gc,        
		&image, 0, 0, ex, ey, clock_width, clock_height );

	ex = cx - clock_width * sin(2 * M_PI * tm / max) / 2;
	ey = cy - clock_height * cos(2 * M_PI * tm / max) / 2;
	XDrawLine( dpy, clockwin, gc, cx, cy, ex, ey );

	sprintf(buf, "%d", max - tm);
	tx = cx - dfontinfo->max_bounds.rbearing * strlen(buf) / 2;
	ty = cy - dfontinfo->ascent / 2;
	t.chars = buf;
	t.nchars = strlen(buf);
	t.delta = 0;
	t.font  = dfont;
	XDrawText( dpy, clockwin, gc, tx,ty, &t, 1 );

	t.chars =  "Auto Quit";
	t.nchars = strlen(t.chars);
	tx = cx - dfontinfo->max_bounds.rbearing * strlen(t.chars) / 2;
	ty = CLOCK_HEI - dfontinfo->ascent;
	XDrawText( dpy, clockwin, gc, tx,ty, &t, 1 );
}

static XImage *getfile(name)
char *name;
{
    int x_hot, y_hot, width, height;
    int ret;
	Pixmap pix;
	XImage *image;

    ret = XReadBitmapFile(dpy, DefaultRootWindow(dpy), name,
	&width, &height, &pix, &x_hot, &y_hot);

    if (ret != BitmapSuccess)
	{
		switch (ret)
		{
		case BitmapOpenFailed:
			fprintf(stderr, "getfile: couldn't open \"%s\"\n", name);
			break;
		case BitmapFileInvalid:
			fprintf(stderr, "getfile: bitmap file \"%s\" invalid\n", name);
			break;
		case BitmapNoMemory:
			fprintf(stderr, "getfile: no memory for \"%s\"\n", name);
			break;
		}
		exit(1);
	}
    image = XGetImage(dpy, pix, 0, 0, width, height, 1, XYPixmap);
    image->format = XYBitmap;
	return (image);
}


static void savebitmaps()
{
	int i, j;
	char filename[200];

	bkgndTile = XCreatePixmapFromBitmapData(dpy,
		RootWindow(dpy, DefaultScreen(dpy)), bkgndtile_bits,
		bkgndtile_height, bkgndtile_width, textColor, backColor,
		DefaultDepth(dpy, DefaultScreen(dpy)));

	for (i = 0; i < VIEWS/4; i++) {
		for (j = 1; j < VIEWS; j++) {
			sprintf(filename, "%s/shield%d.%d.%d", Bitmaps, shield_width, i, j);
			shield[i][j] = getfile(filename);
		}
	}
}


/*
 * this is separate from newwin.  It should; be called *after*
 * openmem.  If not, expose events will be eaten by the forked
 * process (daemon).
 */
void mapAll()
{
	initinput();
	XMapWindow(dpy, mapw);
	XMapWindow(dpy, tstatw);
	XMapWindow(dpy, warnw);
	XMapWindow(dpy, messagew);
	XMapWindow(dpy, smessagew);
	XMapWindow(dpy, mainw);
	XMapWindow(dpy, baseWin);
	XMapWindow(dpy, frameWin);
}


void newwin(hostmon, pname, argc, argv)
char *hostmon, *pname;
int argc;
char ** argv;
{

	Visual visual;
	XGCValues xgcv;
	XSetWindowAttributes xswa;
	XSizeHints sizehints;
	int fheight, msize, i;
	Cursor XtrekCursor;
	int dummy;
	char *str;

	if ((dpy = XOpenDisplay(hostmon)) == NULL) {
		perror(hostmon);
		exit(1);
	}

	getResources(pname);

	fheight = dfontinfo->ascent + dfontinfo->descent;
	msize = MESSAGES * (fheight + 2);

	sizehints.flags = USPosition | USSize;
	sizehints.x = 0;
	sizehints.y = YOFF;
	sizehints.width = WINSIDE * 2 + 3 * BORDER,
	sizehints.height = WINSIDE + 3 * BORDER + msize;

    if ((str = XGetDefault(dpy, pname, "geometry")) != NULL)
		XParseGeometry(str, &sizehints.x, &sizehints.y, &dummy, &dummy);

	/*******************************************************************
	 ** create the window and set its standard properties
	 *******************************************************************/

	xswa.event_mask = ExposureMask;
	visual.visualid = CopyFromParent;

    /* this frame window allows use of a reparenting window manager */
    frameWin = XCreateSimpleWindow(dpy,
		RootWindow(dpy,DefaultScreen(dpy)),
		sizehints.x, sizehints.y, sizehints.width, sizehints.height,
		0, gColor, backColor);
	baseWin = XCreateSimpleWindow(dpy, frameWin, 0, 0,
		WINSIDE*2 + 1*BORDER, WINSIDE + BORDER + msize,
	    BORDER, gColor, backColor );
	XSetStandardProperties(dpy, frameWin,"dtrek","dtrek",
	    None, argv, argc, &sizehints);
	set_class(frameWin, "DTrek", "dtrek");
	xgcv.foreground = backColor;
	xgcv.background = borderColor;
	xgcv.line_width = 0;
	gc = XCreateGC(dpy, baseWin,
	    GCForeground|GCBackground|GCLineWidth,
	    &xgcv);


	shieldColor[0] = backColor;
	shieldColor[1] = rColor;
	shieldColor[2] = yColor;
	shieldColor[3] = gColor;
	shieldColor[4] = gColor;

	savebitmaps(); 
	/* XSetTile(dpy,gc,nebTile); */

	mainw = XCreateSimpleWindow(dpy, baseWin,
		-BORDER, -BORDER, WINSIDE, WINSIDE, BORDER, borderColor,backColor);

	mapw = XCreateSimpleWindow(dpy, baseWin,
	    WINSIDE, -BORDER, WINSIDE, WINSIDE, BORDER, borderColor,backColor);

	galaxy_win = XCreateSimpleWindow(dpy, baseWin,
	    WINSIDE, -BORDER, WINSIDE, WINSIDE, BORDER, borderColor,backColor);

	tstatw = XCreateSimpleWindow(dpy, baseWin,
	    -BORDER, WINSIDE, WINSIDE, STATSIZE, BORDER, borderColor,backColor);

	warnw = XCreateSimpleWindow(dpy, baseWin,
	    -BORDER, WINSIDE + BORDER + STATSIZE, WINSIDE, MESSAGESIZE,
		BORDER, borderColor,backColor);

	smessagew = XCreateSimpleWindow(dpy, baseWin,
	    -BORDER, WINSIDE + 2*BORDER + STATSIZE + MESSAGESIZE,
		WINSIDE, /*MESSAGESIZE*/ 200, BORDER,
	    borderColor,backColor);

	messagew = XCreateSimpleWindow(dpy, baseWin,
	    WINSIDE, WINSIDE, WINSIDE, msize, BORDER,
	    borderColor,backColor);

	planetw = XCreateSimpleWindow(dpy, baseWin,
	    10, 10, 112 * dfontinfo->max_bounds.rbearing,
		((MAXPLANETS/2) + 3) * (dfontinfo->ascent + dfontinfo->descent ),
	    BORDER, borderColor,backColor);

	playerw = XCreateSimpleWindow(dpy, baseWin,
	    10, 10, 72 * dfontinfo->max_bounds.rbearing,
		(MAXPLAYER + 3) * (dfontinfo->ascent + dfontinfo->descent ),
	    BORDER, borderColor,backColor);

	helpWin = XCreateSimpleWindow(dpy, RootWindow(dpy,DefaultScreen(dpy)),
	    0,
		YOFF + WINSIDE + 2 * BORDER + 2 * MESSAGESIZE,
	    WINSIDE * 2 + 1 * BORDER,
		15 * (dfontinfo->ascent + dfontinfo->descent),
	    BORDER, borderColor,backColor);

	sizehints.flags = USPosition | USSize;
	sizehints.width = WINSIDE * 2 + 1 * BORDER;
	sizehints.height = 15 * (dfontinfo->ascent + dfontinfo->descent);
	sizehints.x = 0;
	sizehints.y = YOFF + WINSIDE + 2 * BORDER + 2 * MESSAGESIZE;
	XSetStandardProperties(dpy, helpWin,"helpwin","helpwin",
	    None, argv, argc, &sizehints);
	set_class(helpWin, "DTrek", "helpwin");
	XtrekCursor = XCreateFontCursor( dpy, 33 );
	if ( XtrekCursor > LastExtensionError )
	{
		XDefineCursor( dpy, baseWin, XtrekCursor );
	}



	/* These windows will be used for setting one's warlike stats */

#define WARHEIGHT ((dfontinfo->ascent + dfontinfo->descent) * 2)
#define WARWIDTH (dfontinfo->max_bounds.rbearing * 20)
#define WARBORDER 2
#define WAROFFSET WARHEIGHT*2

	war = XCreateSimpleWindow(dpy, baseWin, WINSIDE+10, -BORDER+10,
		WARWIDTH*2, WARHEIGHT * 8, BORDER, borderColor,backColor);

	warf1 = XCreateSimpleWindow(dpy, war, 0, 0 * WARHEIGHT + WAROFFSET ,
		WARWIDTH, WARHEIGHT, WARBORDER, borderColor,backColor);

	warr1 = XCreateSimpleWindow(dpy, war, 0, 1 * WARHEIGHT + WAROFFSET,
		WARWIDTH, WARHEIGHT, WARBORDER, borderColor,backColor);

	wark1 = XCreateSimpleWindow(dpy, war, 0, 2 * WARHEIGHT + WAROFFSET,
		WARWIDTH, WARHEIGHT, WARBORDER, borderColor,backColor);

	waro1 = XCreateSimpleWindow(dpy, war, 0, 3 * WARHEIGHT + WAROFFSET,
		WARWIDTH, WARHEIGHT, WARBORDER, borderColor,backColor);

	wargo1 = XCreateSimpleWindow(dpy, war, 0, 4 * WARHEIGHT + WAROFFSET,
		WARWIDTH, WARHEIGHT, WARBORDER, borderColor,backColor);

	warno1 = XCreateSimpleWindow(dpy, war, 0, 5 * WARHEIGHT + WAROFFSET,
		WARWIDTH, WARHEIGHT, WARBORDER, borderColor,backColor);

	warf = XCreateSimpleWindow(dpy, war, WARWIDTH, 0 * WARHEIGHT + WAROFFSET,
		WARWIDTH, WARHEIGHT, WARBORDER, borderColor,backColor);

	warr = XCreateSimpleWindow(dpy, war, WARWIDTH, 1 * WARHEIGHT + WAROFFSET,
		WARWIDTH, WARHEIGHT, WARBORDER, borderColor,backColor);

	wark = XCreateSimpleWindow(dpy, war, WARWIDTH, 2 * WARHEIGHT + WAROFFSET,
		WARWIDTH, WARHEIGHT, WARBORDER, borderColor,backColor);

	waro = XCreateSimpleWindow(dpy, war, WARWIDTH, 3 * WARHEIGHT + WAROFFSET,
		WARWIDTH, WARHEIGHT, WARBORDER, borderColor,backColor);

	wargo = XCreateSimpleWindow(dpy, war, WARWIDTH, 4 * WARHEIGHT + WAROFFSET,
		WARWIDTH, WARHEIGHT, WARBORDER, borderColor,backColor);

	warno = XCreateSimpleWindow(dpy, war, WARWIDTH, 5 * WARHEIGHT + WAROFFSET,
		WARWIDTH, WARHEIGHT, WARBORDER, borderColor,backColor);

	XMapSubwindows(dpy, war);


#define MODEOPTIONS 10
#define MODEHEIGHT ((dfontinfo->ascent + dfontinfo->descent) * 2)
#define MODEWIDTH (dfontinfo->max_bounds.rbearing * 50)
#define MODEBORDER 2
#define MODEOFFSET MODEHEIGHT*2

	/* These windows will be used for setting optional game modes */

	modew = XCreateSimpleWindow(dpy, baseWin,
		WINSIDE+10, -BORDER+10,
		MODEWIDTH, MODEHEIGHT * (2+MODEOPTIONS),
		BORDER, borderColor,backColor);

	i = 0;
	mode_starbase_mode_win = XCreateSimpleWindow(dpy, modew,
		0, i++ * MODEHEIGHT + MODEOFFSET ,
		MODEWIDTH, MODEHEIGHT, MODEBORDER, borderColor,backColor);
	mode_defense_base_win = XCreateSimpleWindow(dpy, modew,
		0, i++ * MODEHEIGHT + MODEOFFSET ,
		MODEWIDTH, MODEHEIGHT, MODEBORDER, borderColor,backColor);
	mode_monitor_win = XCreateSimpleWindow(dpy, modew,
		0, i++ * MODEHEIGHT + MODEOFFSET ,
		MODEWIDTH, MODEHEIGHT, MODEBORDER, borderColor,backColor);
	mode_planetkiller_win = XCreateSimpleWindow(dpy, modew,
		0, i++ * MODEHEIGHT + MODEOFFSET ,
		MODEWIDTH, MODEHEIGHT, MODEBORDER, borderColor,backColor);
	mode_robot_swarm_win = XCreateSimpleWindow(dpy, modew,
		0, i++ * MODEHEIGHT + MODEOFFSET ,
		MODEWIDTH, MODEHEIGHT, MODEBORDER, borderColor,backColor);
	mode_invasion_win = XCreateSimpleWindow(dpy, modew,
		0, i++ * MODEHEIGHT + MODEOFFSET ,
		MODEWIDTH, MODEHEIGHT, MODEBORDER, borderColor,backColor);
	mode_defensive_beam_win = XCreateSimpleWindow(dpy, modew,
		0, i++ * MODEHEIGHT + MODEOFFSET ,
		MODEWIDTH, MODEHEIGHT, MODEBORDER, borderColor,backColor);
	mode_wormhole_win = XCreateSimpleWindow(dpy, modew,
		0, i++ * MODEHEIGHT + MODEOFFSET ,
		MODEWIDTH, MODEHEIGHT, MODEBORDER, borderColor,backColor);
	mode_smart_weap_win = XCreateSimpleWindow(dpy, modew,
		0, i++ * MODEHEIGHT + MODEOFFSET ,
		MODEWIDTH, MODEHEIGHT, MODEBORDER, borderColor,backColor);
	mode_prob_vortex_win = XCreateSimpleWindow(dpy, modew,
		0, i++ * MODEHEIGHT + MODEOFFSET ,
		MODEWIDTH, MODEHEIGHT, MODEBORDER, borderColor,backColor);
	XMapSubwindows(dpy, modew);

}


/* This routine throws up an entry window for the player. */
/* It returns the chosen team number */
int which_team()
{
	int teamno;
	long	startTime;
	unsigned long ffg, rfg, kfg, ofg;
	Window fwin, rwin, kwin, owin, qwin;
	XEvent event;
    unsigned long valuemask;            /* mask for create windows */
	XSetWindowAttributes attributes;    /* attributes for create windows */

	logmsg3("which_team: mask is %x, mustexit? %d\n",me->p_team_mask,mustexit);
	valuemask = CWEventMask | CWBackPixmap | CWBorderPixel;
	attributes.event_mask = ExposureMask;
	attributes.background_pixmap = bkgndTile;
	attributes.border_pixel = borderColor;

	tcount[FEDERATION] = tcount[ROMULAN] = tcount[KLINGON] = 
		tcount[ORION] = -2;

	/* The following allows quick choosing of teams */
	if ((me->p_team_mask & FED_MASK) && !mustexit)
	{
		ffg = gColor;
		fwin = XCreateSimpleWindow(dpy, mainw, 0*BOXSIDE, 400,
			BOXSIDE, BOXSIDE, 1, borderColor,backColor);
		XSelectInput(dpy, fwin,
			KeyPressMask|ButtonPressMask|ButtonReleaseMask| ExposureMask);
		XMapWindow(dpy, fwin);
	}
	else
	{
		ffg = rColor;
		if (mono)
            fwin = XCreateWindow(dpy, mainw, 0* BOXSIDE, 400, BOXSIDE, BOXSIDE,
				 1, DefaultDepth(dpy, DefaultScreen(dpy)),
				 CopyFromParent, DefaultVisual(dpy, DefaultScreen(dpy)),
				 valuemask, &attributes);
        else
            fwin = XCreateSimpleWindow(dpy, mainw, 0* BOXSIDE, 400,  
			   BOXSIDE, BOXSIDE, 1, borderColor,backColor);

		XSelectInput(dpy, fwin, ExposureMask);
		XMapWindow(dpy, fwin);
	}

	if ((me->p_team_mask & ROM_MASK) && !mustexit)
	{
		rfg = gColor;
		rwin = XCreateSimpleWindow(dpy, mainw, 1*BOXSIDE, 400,
			BOXSIDE, BOXSIDE, 1, borderColor,backColor);
		XSelectInput(dpy, rwin,
			KeyPressMask|ButtonPressMask|ButtonReleaseMask| ExposureMask);
		XMapWindow(dpy, rwin);
	}
	else
	{
		rfg = rColor;
		if (mono)
            rwin = XCreateWindow(dpy, mainw, 1* BOXSIDE, 400, BOXSIDE, BOXSIDE,
				 1, DefaultDepth(dpy, DefaultScreen(dpy)),
				 CopyFromParent, DefaultVisual(dpy, DefaultScreen(dpy)),
				 valuemask, &attributes);
        else
            rwin = XCreateSimpleWindow(dpy, mainw, 1* BOXSIDE, 400,  
			   BOXSIDE, BOXSIDE, 1, borderColor,backColor);

		XSelectInput(dpy, rwin, ExposureMask);
		XMapWindow(dpy, rwin);
	}

	if ((me->p_team_mask & KLI_MASK) && !mustexit)
	{
		kfg = gColor;
		kwin = XCreateSimpleWindow(dpy, mainw, 2*BOXSIDE, 400,
			BOXSIDE, BOXSIDE, 1, borderColor,backColor);
		XSelectInput(dpy, kwin,
			KeyPressMask|ButtonPressMask|ButtonReleaseMask| ExposureMask);
		XMapWindow(dpy, kwin);
	}
	else
	{
		kfg = rColor;
		if (mono)
            kwin = XCreateWindow(dpy, mainw, 2* BOXSIDE, 400, BOXSIDE, BOXSIDE,
				 1, DefaultDepth(dpy, DefaultScreen(dpy)),
				 CopyFromParent, DefaultVisual(dpy, DefaultScreen(dpy)),
				 valuemask, &attributes);
        else
            kwin = XCreateSimpleWindow(dpy, mainw, 2* BOXSIDE, 400,  
			   BOXSIDE, BOXSIDE, 1, borderColor,backColor);

		XSelectInput(dpy, kwin, ExposureMask);
		XMapWindow(dpy, kwin);
	}

	if ((me->p_team_mask & ORI_MASK) && !mustexit)
	{
		ofg = gColor;
		owin = XCreateSimpleWindow(dpy, mainw, 3*BOXSIDE, 400,
			BOXSIDE, BOXSIDE, 1, borderColor,backColor);
		XSelectInput(dpy, owin,
			KeyPressMask|ButtonPressMask|ButtonReleaseMask| ExposureMask);
		XMapWindow(dpy, owin);
	}
	else
	{
		ofg = rColor;
		if (mono)
            owin = XCreateWindow(dpy, mainw, 3* BOXSIDE, 400, BOXSIDE, BOXSIDE,
				 1, DefaultDepth(dpy, DefaultScreen(dpy)),
				 CopyFromParent, DefaultVisual(dpy, DefaultScreen(dpy)),
				 valuemask, &attributes);
        else
            owin = XCreateSimpleWindow(dpy, mainw, 3* BOXSIDE, 400,  
			   BOXSIDE, BOXSIDE, 1, borderColor,backColor);

		XSelectInput(dpy, owin, ExposureMask);
		XMapWindow(dpy, owin);
	}

	qwin = XCreateSimpleWindow(dpy, mainw,
	    4 * BOXSIDE, 400, BOXSIDE, BOXSIDE,
		1, borderColor,backColor);
	XSelectInput(dpy, qwin, KeyPressMask|ButtonPressMask|ExposureMask);
	XMapWindow(dpy, qwin);
	if ((me->p_team_mask != ALL_MASK) || mustexit) printscores(mapw);

	teamno = -1;
	startTime = time(0);
	makeClock(qwin);
	do {
		me->p_ghostbuster = 0;
		while (!XPending(dpy)) {
			int		mask, elapsed;
			struct timeval	tv;

			me->p_ghostbuster = 0;
			tv.tv_sec = 1;
			tv.tv_usec = 0;
			mask = 1 << ConnectionNumber(dpy);
			select(ConnectionNumber(dpy) + 1, &mask, 0, 0, &tv);
			elapsed = time(0) - startTime;
			if (elapsed > AUTOQUIT) {
				printf("Auto-Quit.\n");
				teamno = NUMTEAM;
				break;
			}
			showTimeLeft(elapsed, AUTOQUIT);
			redrawEntry(FEDERATION, "Federation", fwin, ffg);
			redrawEntry(ROMULAN, "Romulan", rwin, rfg);
			redrawEntry(KLINGON, "Klingon", kwin, kfg);
			redrawEntry(ORION, "Orion", owin, ofg);
		}
		if (teamno == NUMTEAM) break;

		XNextEvent( dpy, &event);
		switch ((int) event.type) {
		case KeyPress:
		case ButtonPress:
			if (event.xany.window == fwin)
				teamno = FEDERATION;
			else if (event.xany.window == rwin)
				teamno = ROMULAN;
			else if (event.xany.window == kwin)
				teamno = KLINGON;
			else if (event.xany.window == owin)
				teamno = ORION;
			else if (event.xany.window == qwin)
				teamno = NUMTEAM;
			break;
		case Expose:
			if (event.xany.window == fwin) {
				tcount[FEDERATION] = -2;
				redrawEntry(FEDERATION, "Federation", fwin, ffg);
			}
			else if (event.xany.window == rwin) {
				tcount[ROMULAN] = -2;
				redrawEntry(ROMULAN, "Romulan", rwin, rfg);
			}
			else if (event.xany.window == kwin) {
				tcount[KLINGON] = -2;
				redrawEntry(KLINGON, "Klingon", kwin, kfg);
			}
			else if (event.xany.window == owin) {
				tcount[ORION] = -2;
				redrawEntry(ORION, "Orion", owin, ofg);
			}
			else if (event.xany.window == qwin)
				redrawQuit(qwin);
			else if (event.xany.window == tstatw)
				redrawTstats();
			else if (event.xany.window == iconWin)
				drawIcon();
			else if (event.xany.window == mainw)
				showMotd();
			else if (event.xany.window == mapw)
				printscores(mapw);
			else if (event.xany.window == helpWin)
				fillhelp();
			break;
		}
	} while (teamno == -1);
	destroyClock();

	tcount[FEDERATION] = tcount[ROMULAN] = tcount[KLINGON]
		= tcount[ORION] = -1;

	if (teamno == NUMTEAM) teamno = -1;

	XClearWindow( dpy, mapw);
	XDestroyWindow( dpy, fwin);
	XDestroyWindow( dpy, rwin);
	XDestroyWindow( dpy, kwin);
	XDestroyWindow( dpy, owin);
	XDestroyWindow( dpy, qwin);
	return(teamno);
}


void xdetach() {
	XAddToSaveSet(dpy,frameWin);
	XDestroyWindow(dpy,frameWin);
}
