/* mode.c 15.1 06/08/90 10:05:49 */

/* Original code by Daryl Poe.
 *
 * Copyright (c) 1989 Daryl Poe
 *
 * Ported to X11 by Jim Andreas.
 * Tractors, treaties, and other features by Norm Gee.
 * Damage window and shield bitmaps by Tom LaStrange.
 *
 * Permission to use, copy, modify, and distribute this
 * software and its documentation for any purpose and without
 * fee is hereby granted, provided that the above copyright
 * notice appear in all copies and that both that copyright
 * notice and this permission notice appear in supporting
 * documentation.  No representations are made about the
 * suitability of this software for any purpose.  It is
 * provided "as is" without express or implied warranty.
 */

#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <stdio.h>
#include "defs.h"
#include "weapon.h"
#include "system.h"
#include "ship.h"
#include "stats.h"
#include "player.h"
#include "torp.h"
#include "status.h"
#include "planet.h"
#include "phaser.h"
#include "message.h"
#include "shmem.h"
#include "data.h"
#include "xdata.h"

/* total characters should agree with value in newwin.c */
#define COL1WIDTH (dfontinfo->max_bounds.rbearing * 30)
#define COL2WIDTH (dfontinfo->max_bounds.rbearing * 10)
#define COL3WIDTH (dfontinfo->max_bounds.rbearing * 10)

static void display_option(win,label,mask)
Window win;
char *label;
unsigned int mask;
{
	XTextItem t;
	char str[256];
	int local,global,fixed;

	local  = me->p_mode         & mask; 
	global = sharedMemory->mode & mask;
	fixed  = (sharedMemory->mode_fixed_on|sharedMemory->mode_fixed_off)
		& mask;

	XClearWindow(dpy,win);

	t.chars  = label;
	t.nchars = strlen(label);
	t.delta  = 0;
	t.font   = dfont;
	XDrawText(dpy,win,gc,0,
		dfontinfo->ascent/2 + dfontinfo->ascent, &t, 1 );

	if (fixed) strcpy(str,"STATIC");
	else if (local) strcpy(str,"FOR");
	else strcpy(str,"AGAINST");
	t.chars  = str;
	t.nchars = strlen(str);
	XDrawText(dpy,win,gc,COL1WIDTH,
		dfontinfo->ascent/2 + dfontinfo->ascent, &t, 1 );

	if (global) strcpy(str,"ON");
	else strcpy(str,"OFF");
	t.chars  = str;
	t.nchars = strlen(str);
	XDrawText(dpy,win,gc,COL1WIDTH+COL2WIDTH,
		dfontinfo->ascent/2 + dfontinfo->ascent, &t, 1 );
}


static void moderefresh()
{
	XTextItem t;

	XSetForeground(dpy, gc, textColor);

	t.delta  = 0;
	t.font   = dfont;

	t.chars  = "OPTION";
	t.nchars = strlen(t.chars);
	XDrawText(dpy,modew,gc,0,
		dfontinfo->ascent/2 + 20, &t, 1 );

	t.chars  = "DESIRED";
	t.nchars = strlen(t.chars);
	XDrawText(dpy,modew,gc,COL1WIDTH,
		dfontinfo->ascent/2 + 20, &t, 1 );

	t.chars  = "STATUS";
	t.nchars = strlen(t.chars);
	XDrawText(dpy,modew,gc,COL1WIDTH + COL2WIDTH,
		dfontinfo->ascent/2 + 20, &t, 1 );

	display_option(mode_starbase_mode_win,
		"Starbase Mode",
		STARBASE_MODE_MASK);

	display_option(mode_defense_base_win,
		"Defense Base Mode",
		DEFENSE_BASE_MASK);

	display_option(mode_monitor_win,
		"Monitor Mode",
		MONITOR_MASK);

	display_option(mode_planetkiller_win,
		"Planetkiller Mode",
		PLANETKILLER_MASK);

	display_option(mode_robot_swarm_win,
		"Robot Swarm Mode",
		ROBOT_SWARM_MASK);

	display_option(mode_invasion_win,
		"Robot Invasion Mode",
		ROBOT_INVASION_MASK);

	display_option(mode_defensive_beam_win,
		"Defensive Beams Mode",
		DEFENSIVE_BEAM_MASK);

	display_option(mode_wormhole_win,
		"Wormhole Mode",
		WORMHOLE_MASK);

	display_option(mode_smart_weap_win,
		"Smart Weapons Mode",
		SMART_WEAP_MASK);

	display_option(mode_prob_vortex_win,
		"Probability Vortex Mode",
		PROB_VORTEX_MASK);
}


void modewindow()
{
	XMapWindow( dpy, modew);
	moderefresh();
}



void modeaction(data)
XButtonEvent *data;
{
	char buf[BUFSIZ];
	char addrbuf[10];
	unsigned int fixed_mask;
	typedef struct {
		Window 			*winaddr;
		unsigned int 	mask;
		char			*str;
	} MODESTUFF;
	static MODESTUFF modestuff[] = {
		{ &mode_invasion_win,		ROBOT_INVASION_MASK,
			"Robot Invasion" },
		{ &mode_defense_base_win,	DEFENSE_BASE_MASK,
			"Defense Base" },
		{ &mode_monitor_win,		MONITOR_MASK,
			"Monitor" },
		{ &mode_planetkiller_win,	PLANETKILLER_MASK,
			"Planetkiller" },
		{ &mode_starbase_mode_win,	STARBASE_MODE_MASK,
			"Starbase" },
		{ &mode_robot_swarm_win,	ROBOT_SWARM_MASK,
			"Robot Swarm" },
		{ &mode_defensive_beam_win,	DEFENSIVE_BEAM_MASK,
			"Defensive Beam" },
		{ &mode_wormhole_win,		WORMHOLE_MASK,
			"Wormhole" },
		{ &mode_smart_weap_win,		SMART_WEAP_MASK,
			"Smart Weapons" },
		{ &mode_prob_vortex_win,	PROB_VORTEX_MASK,
			"Probability Vortex" },
	};
	MODESTUFF *ms;
				
	fixed_mask = sharedMemory->mode_fixed_on
				| sharedMemory->mode_fixed_off;

	if (watch) {
		warning("can't modify mode settings from watch");
		return;
	}

	for (ms=modestuff;
			ms < modestuff+(sizeof(modestuff)/sizeof(MODESTUFF));
			++ms) {
		if (data->window == *(ms->winaddr)) {
			if (fixed_mask & ms->mask) {
				sprintf(buf,"%s mode static.",ms->str);
				warning(buf);
			}
			else if (me->p_mode & ms->mask) {
				/* vote to turn off */
				sprintf(buf,
					"%s (%s) would like to end %s mode",
		    		me->p_name, me->p_mapchars, ms->str);
				sprintf(addrbuf, " %s->ALL", me->p_mapchars);
				pmessage(buf, 0, MALL, addrbuf);
				me->p_mode &= ~(ms->mask);
			}
			else {
				/* vote to turn on */
				sprintf(buf,
					"%s (%s) would like to begin %s mode",
		    		me->p_name, me->p_mapchars, ms->str);
				sprintf(addrbuf, " %s->ALL", me->p_mapchars);
				pmessage(buf, 0, MALL, addrbuf);
				me->p_mode |= ms->mask;
			}
			break;
		}
	}

	if (me->p_mode & ROBOT_SWARM_MASK)
		me->p_mode |= ROBOT_INVASION_MASK;
	else if (!(me->p_mode & ROBOT_INVASION_MASK)) 
		me->p_mode &= ~ROBOT_SWARM_MASK;

	me->p_mode &= ~(sharedMemory->mode_fixed_off);
	me->p_mode |=  sharedMemory->mode_fixed_on;

	check_mode_status();
	moderefresh();
}


void check_mode_status()
{
	PLAYER *p;
	int invasion_for=0, invasion_against=0, invasion_mode;
	int sb_for=0, sb_against=0, sb_mode;
	int db_for=0, db_against=0, db_mode;
	int monitor_for=0, monitor_against=0, monitor_mode;
	int planetkiller_for=0, planetkiller_against=0, planetkiller_mode;
	int swarm_for=0, swarm_against=0;
	int beam_for=0, beam_against=0, beam_mode;
	int wormhole_for=0, wormhole_against=0, wormhole_mode;
	int smart_weap_for=0, smart_weap_against=0, smart_weap_mode;
	int prob_vortex_for=0, prob_vortex_against=0, prob_vortex_mode;

	for (p=players; p<players+MAXPLAYER; ++p) {
		if (p->p_status != PALIVE) continue;
		if (p->p_flags & PFROBOT)  continue;

		if (p->p_mode & ROBOT_INVASION_MASK) ++invasion_for;
		else ++invasion_against;

		if (p->p_mode & DEFENSE_BASE_MASK) ++db_for;
		else ++db_against;

		if (p->p_mode & MONITOR_MASK) ++monitor_for;
		else ++monitor_against;

		if (p->p_mode & PLANETKILLER_MASK) ++planetkiller_for;
		else ++planetkiller_against;

		if (p->p_mode & STARBASE_MODE_MASK) ++sb_for;
		else ++sb_against;

		if (p->p_mode & DEFENSIVE_BEAM_MASK) ++beam_for;
		else ++beam_against;

		if (p->p_mode & ROBOT_SWARM_MASK) ++swarm_for;
		else ++swarm_against;

		if (p->p_mode & WORMHOLE_MASK) ++wormhole_for;
		else ++wormhole_against;

		if (p->p_mode & SMART_WEAP_MASK) ++smart_weap_for;
		else ++smart_weap_against;

		if (p->p_mode & PROB_VORTEX_MASK) ++prob_vortex_for;
		else ++prob_vortex_against;
	}

	if (invasion_for+invasion_against == 0) {
		/* no one in game -- leave them as they are */
		return;
	}

	/************************* INVASION MODE ********************/
	/* must be 2/3 majority for invasion mode */
	if (invasion_for >= invasion_against*2) invasion_mode = TRUE;
	else invasion_mode = FALSE;

	if (invasion_mode && !(sharedMemory->mode & ROBOT_INVASION_MASK)) {
		sharedMemory->mode |= ROBOT_INVASION_MASK;
		/* warn everyone it's going on */
		pmessage("Robot invasion from Large Magellanic Cloud beginning.",
			0,MALL,
			"Aliens->ALL");
	}
	else if (!invasion_mode &&
			(sharedMemory->mode & ROBOT_INVASION_MASK)) {
		sharedMemory->mode &= ~ROBOT_INVASION_MASK;
		/* tell everybody it's over */
		pmessage("Robots from Large Magellanic Cloud give up invasion.",
			0,MALL,
			"Aliens->ALL");
	}

	/************************* PLANETKILLER MODE ********************/
	/* must be unanimous for planetkiller mode */
	if ((planetkiller_against == 0)
			&& !(sharedMemory->mode & PLANETKILLER_MASK)) {
		sharedMemory->mode |= PLANETKILLER_MASK;
		/* warn everyone it's going on */
		pmessage("Planetkiller mode active",
			0,MALL,
			"Game->ALL");
		if (fork() == 0) {
			detach();
			xdetach();
			setresuid(geteuid(),-1,-1);
			start_planetkiller();
			_exit(1);
		}
	}
	else if ((planetkiller_against > 0)
			&& (sharedMemory->mode & PLANETKILLER_MASK)) {
		sharedMemory->mode &= ~PLANETKILLER_MASK;
		/* tell everybody it's over */
		pmessage("Planetkiller mode inactive.",
			0,MALL,
			"Game->ALL");
		kill_planetkiller();
	}

	/************************* SWARM MODE ********************/
	/* must be unanimous for swarm mode */
	if ((swarm_against == 0)
			&& !(sharedMemory->mode & ROBOT_SWARM_MASK)) {
		sharedMemory->mode |= ROBOT_SWARM_MASK;
		/* warn everyone it's going on */
		pmessage("Large-scale robot invasion from Large Magellanic Cloud beginning.",
			0,MALL,
			"Aliens->ALL");
	}
	else if ((swarm_against > 0)
			&& (sharedMemory->mode & ROBOT_SWARM_MASK)) {
		sharedMemory->mode &= ~ROBOT_SWARM_MASK;
		/* tell everybody it's over */
		pmessage("Robots from Large Magellanic Cloud give up large-scale invasion.",
			0,MALL,
			"Aliens->ALL");
	}

	/************************* DEFENSE BASES **************************/
	/* must be simple majority */
	if (db_for > db_against) db_mode = TRUE;
	else db_mode = FALSE;

	if (db_mode && !(sharedMemory->mode & DEFENSE_BASE_MASK)) {
		sharedMemory->mode |= DEFENSE_BASE_MASK;
		/* warn everyone it's going on */
		pmessage("Defense Base mode active",
			0,MALL,
			"Game->ALL");
		if (fork() == 0) {
			detach();
			xdetach();
			setresuid(geteuid(),-1,-1);
			start_defense_bases();
			_exit(1);
		}
	}
	else if (!db_mode &&
			(sharedMemory->mode & DEFENSE_BASE_MASK)) {
		sharedMemory->mode &= ~DEFENSE_BASE_MASK;
		/* tell everybody it's over */
		pmessage("Defense Base mode disabled.",
			0,MALL,
			"Game->ALL");
		kill_defense_bases();
	}

	/************************* MONITORS **************************/
	/* must be simple majority */
	if (monitor_for > monitor_against) monitor_mode = TRUE;
	else monitor_mode = FALSE;

	if (monitor_mode && !(sharedMemory->mode & MONITOR_MASK)) {
		sharedMemory->mode |= MONITOR_MASK;
		/* warn everyone it's going on */
		pmessage("Monitor mode active",
			0,MALL,
			"Game->ALL");
		if (fork() == 0) {
			detach();
			xdetach();
			setresuid(geteuid(),-1,-1);
			start_monitors();
			_exit(1);
		}
	}
	else if (!monitor_mode &&
			(sharedMemory->mode & MONITOR_MASK)) {
		sharedMemory->mode &= ~MONITOR_MASK;
		/* tell everybody it's over */
		pmessage("Monitor mode disabled.",
			0,MALL,
			"Game->ALL");
		kill_monitors();
	}

	/*************************** STARBASES ****************************/
	/* must be unanimous to turn them off or on */
	if ((sb_for == 0)
			&& (sb_against > 0)
			&& (sharedMemory->mode & STARBASE_MODE_MASK)) sb_mode = FALSE;
	else sb_mode = TRUE;

	if ((sb_against == 0)
			&& !(sharedMemory->mode & STARBASE_MODE_MASK)) {
		/* turn them on */
		sharedMemory->mode |= STARBASE_MODE_MASK;
		pmessage("Starbase mode active",
			0,MALL,
			"Game->ALL");
		if (fork() == 0) {
			detach();
			xdetach();
			setresuid(geteuid(),-1,-1);
			start_starbases();
			_exit(1);
		}
	}
	else if ((sb_for == 0)
			&& (sharedMemory->mode & STARBASE_MODE_MASK)) {
		/* turn them off */
		sharedMemory->mode &= ~STARBASE_MODE_MASK;
		pmessage("Starbase mode disabled.",
			0,MALL,
			"Game->ALL");
		kill_starbases();
	}

	/****************** DEFENSIVE BEAM FIRE ***************************/
	/* must be simple majority */
	if (beam_for > beam_against) beam_mode = TRUE;
	else beam_mode = FALSE;

	if (beam_mode && !(sharedMemory->mode & DEFENSIVE_BEAM_MASK)) {
		sharedMemory->mode |= DEFENSIVE_BEAM_MASK;
		/* warn everyone it's going on */
		pmessage("Defensive Beam mode active",
			0,MALL,
			"Game->ALL");
	}
	else if (!beam_mode &&
			(sharedMemory->mode & DEFENSIVE_BEAM_MASK)) {
		sharedMemory->mode &= ~DEFENSIVE_BEAM_MASK;
		/* tell everybody it's over */
		pmessage("Defensive Beam mode disabled.",
			0,MALL,
			"Game->ALL");
	}

	/************************* WORMHOLE MODE ********************/
	/* must be 2/3 majority for wormhole mode */
	if (wormhole_for >= wormhole_against*2) wormhole_mode = TRUE;
	else wormhole_mode = FALSE;

	if (wormhole_mode
			&& !(sharedMemory->mode & WORMHOLE_MASK)) {
		sharedMemory->mode |= WORMHOLE_MASK;
		/* warn everyone it's going on */
		pmessage("Wormhole Mode enabled.",
			0,MALL,
			"Aliens->ALL");
	}
	else if (!wormhole_mode
			&& (sharedMemory->mode & WORMHOLE_MASK)) {
		sharedMemory->mode &= ~WORMHOLE_MASK;
		/* tell everybody it's over */
		pmessage("Wormhole mode disabled.",
			0,MALL,
			"Aliens->ALL");
	}

	/************************* SMART_WEAP MODE ********************/
	/* must be unanimous to turn off smart_weap mode */

	smart_weap_mode = TRUE;
	if ((smart_weap_for == 0) && (smart_weap_against > 0)
	/*	&& (sharedMemory->mode & SMART_WEAP_MASK) */ ) smart_weap_mode = FALSE;
	else smart_weap_mode = TRUE;

	if (smart_weap_mode
			&& !(sharedMemory->mode & SMART_WEAP_MASK)) {
		sharedMemory->mode |= SMART_WEAP_MASK;
		/* warn everyone it's going on */
		pmessage("Smart Weapons Mode enabled.",
			0,MALL,
			"Game->ALL");
	}
	else if (!smart_weap_mode
			&& (sharedMemory->mode & SMART_WEAP_MASK)) {
		sharedMemory->mode &= ~SMART_WEAP_MASK;
		/* tell everybody it's over */
		pmessage("Smart Weapons mode disabled.",
			0,MALL,
			"Game->ALL");
	}

	/****************** PROBABILITY VORTEX MODE *********************/
	/* must be simple majority */
	if (prob_vortex_for > prob_vortex_against) prob_vortex_mode = TRUE;
	else prob_vortex_mode = FALSE;

	if (prob_vortex_mode && !(sharedMemory->mode & PROB_VORTEX_MASK)) {
		sharedMemory->mode |= PROB_VORTEX_MASK;
		/* warn everyone it's going on */
		pmessage("Probability Vortex Mode active",
			0,MALL,
			"Game->ALL");
	}
	else if (!prob_vortex_mode &&
			(sharedMemory->mode & PROB_VORTEX_MASK)) {
		sharedMemory->mode &= ~PROB_VORTEX_MASK;
		/* tell everybody it's over */
		pmessage("Probability Vortex Mode disabled.",
			0,MALL,
			"Game->ALL");
	}
}


typedef struct {
	char   			*optionname;
	unsigned int  	optionmask;
} MODEOPTION;

/* read Xdefaults for mode */
void init_mode(prog)
char *prog;
{
	static MODEOPTION modeoption[] = {
		{ "StarbaseMode",			STARBASE_MODE_MASK		},
		{ "DefenseBaseMode",		DEFENSE_BASE_MASK		},
		{ "MonitorMode",			MONITOR_MASK			},
		{ "PlanetkillerMode",		PLANETKILLER_MASK		},
		{ "RobotSwarmMode",			ROBOT_SWARM_MASK		},
		{ "SwarmMode",				ROBOT_SWARM_MASK		},
		{ "RobotInvasionMode",		ROBOT_INVASION_MASK		},
		{ "InvasionMode",			ROBOT_INVASION_MASK		},
		{ "DefensiveBeamsMode",		DEFENSIVE_BEAM_MASK		},
		{ "WormholeMode",			WORMHOLE_MASK			},
		{ "SmartWeaponsMode",		SMART_WEAP_MASK			},
		{ "ProbabilityVortexMode",	PROB_VORTEX_MASK		},
		{ "VortexMode",				PROB_VORTEX_MASK		},
	};
	MODEOPTION *mo;
	char *cptr;

	for (mo=modeoption;
			mo<modeoption+sizeof(modeoption)/sizeof(MODEOPTION);
			++mo) {
		logmsg2("searching for %s\n",mo->optionname);
		if ((cptr = XGetDefault(dpy,prog,mo->optionname)) != NULL) {
			logmsg2("found %s: turning ",mo->optionname);
			if (is_substr("ON",cptr)
					|| is_substr("On",cptr)
					|| is_substr("on",cptr)
					|| is_substr("TRUE",cptr)
					|| is_substr("True",cptr)
					|| is_substr("true",cptr)) {
				logmsg1("on\n");
				me->p_mode |= mo->optionmask;
			}
			else if (is_substr("OFF",cptr)
					|| is_substr("Off",cptr)
					|| is_substr("off",cptr)
					|| is_substr("FALSE",cptr)
					|| is_substr("False",cptr)
					|| is_substr("false",cptr)) {
				logmsg1("off\n");
				me->p_mode &= ~mo->optionmask;
			}
		}
	}

	check_mode_status();
}



/* global game mode */
void read_dtrek_mode_file()
{
	FILE *mdfile;
	char *cptr,nullchar=(char) NULL;
	extern char *strchr();
	char str[256],option[256];
	MODEOPTION *mo;
	static MODEOPTION modeoption[] = {
		{ "STARBASEMODE",			STARBASE_MODE_MASK		},
		{ "STARBASE",				STARBASE_MODE_MASK		},
		{ "DEFENSEBASEMODE",		DEFENSE_BASE_MASK		},
		{ "DEFENSEBASE",			DEFENSE_BASE_MASK		},
		{ "MONITORMODE",			MONITOR_MASK			},
		{ "MONITOR",				MONITOR_MASK			},
		{ "PLANETKILLERMODE",		PLANETKILLER_MASK		},
		{ "PLANETKILLER",			PLANETKILLER_MASK		},
		{ "ROBOTSWARMMODE",			ROBOT_SWARM_MASK		},
		{ "ROBOTSWARM",				ROBOT_SWARM_MASK		},
		{ "SWARMMODE",				ROBOT_SWARM_MASK		},
		{ "SWARM",					ROBOT_SWARM_MASK		},
		{ "ROBOTINVASIONMODE",		ROBOT_INVASION_MASK		},
		{ "ROBOTINVASION",			ROBOT_INVASION_MASK		},
		{ "INVASIONMODE",			ROBOT_INVASION_MASK		},
		{ "INVASION",				ROBOT_INVASION_MASK		},
		{ "DEFENSIVEBEAMSMODE",		DEFENSIVE_BEAM_MASK		},
		{ "DEFENSIVEBEAMS",			DEFENSIVE_BEAM_MASK		},
		{ "WORMHOLEMODE",			WORMHOLE_MASK			},
		{ "WORMHOLE",				WORMHOLE_MASK			},
		{ "SMARTWEAPONSMODE",		SMART_WEAP_MASK			},
		{ "SMARTWEAPONS",			SMART_WEAP_MASK			},
		{ "PROBABILITYVORTEXMODE",	PROB_VORTEX_MASK		},
		{ "PROBABILITYVORTEX",		PROB_VORTEX_MASK		},
		{ "VORTEXMODE",				PROB_VORTEX_MASK		},
		{ "VORTEX",					PROB_VORTEX_MASK		},
	};


	if ((mdfile = fopen(Modefile,"r")) == NULL) {
		sharedMemory->mode_fixed_on  = 0;
		sharedMemory->mode_fixed_off = 0;
		return;
	}

	while (myfgets(str,sizeof(str),mdfile) != EOF) {
		normalize_string(str,option);
		/* terminate at ':' */
		if ((cptr = strchr(option,':')) != NULL) *cptr++ = '\0';
		else cptr = &nullchar;

		for (mo=modeoption;
				mo<modeoption+sizeof(modeoption)/sizeof(MODEOPTION);
				++mo) {
			if (SAMESTR(option,mo->optionname)) {
				if (is_substr("ON",cptr)
						|| is_substr("TRUE",cptr)) {
					sharedMemory->mode_fixed_on  |= mo->optionmask;
				}
				else if (is_substr("OFF",cptr)
						|| is_substr("FALSE",cptr)) {
					sharedMemory->mode_fixed_off |= mo->optionmask;
				}
				break;
			}
		}
	}

	fclose(mdfile);
}
