/* main.c 15.1 06/08/90 10:05:43 */
/*

	Copyright (c) 1986 	Chris Guthrie

Permission to use, copy, modify, and distribute this
software and its documentation for any purpose and without
fee is hereby granted, provided that the above copyright
notice appear in all copies and that both that copyright
notice and this permission notice appear in supporting
documentation.  No representations are made about the
suitability of this software for any purpose.  It is
provided "as is" without express or implied warranty.

*/

/* Major overhaul by Daryl Poe.
 *
 * Copyright (c) 1989 Daryl Poe
 *
 * Ported to X11 by Jim Andreas.
 * Tractors, treaties, and other features by Norm Gee.
 * Damage window and shield bitmaps by Tom LaStrange.
 *
 * The above comments apply to this version as well, and this
 * notice must also appear in any copies or follow-ons.
 */

#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <stdio.h>
#include <string.h>
#include <sys/types.h>
#include <time.h>
#include <signal.h>
#include <setjmp.h>
#include <pwd.h>
#include "defs.h"
#include "weapon.h"
#include "system.h"
#include "ship.h"
#include "stats.h"
#include "player.h"
#include "torp.h"
#include "status.h"
#include "planet.h"
#include "phaser.h"
#include "message.h"
#include "shmem.h"
#include "data.h"
#include "xdata.h"

#define MAXTEAMSIZE 4

static char *_version = "@(#)15.1  06/08/90 dtrek program for X11";
jmp_buf env;


static int daemondead()
{
	/* received signal SIGUSR1, meaning the daemon has died */
	sleep(10);
	me->p_status = PDEAD;
	if (me->p_whydead != KOVER) me->p_whydead = KDAEMON;
	me->p_ntorp = 0;
}

/* This routine returns a team mask that includes bits for all
 * teams with less than MAXTEAMSIZE human players.
 */
static int limit_team_selection()
{
	int team_count[NUMTEAM];
	int i,j,mask;
	PLAYER *player;

	for (i=0; i<NUMTEAM; ++i) team_count[i] = 0;

	for (player=players; player<players+MAXPLAYER; ++player) {
		if (player->p_status == PFREE) continue;
		if (player->p_status != POUTFIT)
			if (player->p_flags & (PFROBOT|PFPRACTR)) continue;
		j = player->p_team_no;
		if ((j > 0) && (j < NUMTEAM)) ++team_count[j];
	}

	j = 1;
	mask = 0;
	for (j=(1<<FEDERATION), i=FEDERATION; i <= ORION; ++i, j<<=1)
		if (team_count[i] < MAXTEAMSIZE) mask |= j;

	return(mask);
}


/************************************************************
 *  printUsage
 ************************************************************/
static void printUsage(prog)
char *prog;
{
	printf("Usage: %s [-u] [-[cw] copilot-number] [-d display-name]\n",
	    prog);
}


/************************************************************
 *  reaper
 * 
 *   This routine lays zombies to rest by issuing a wait
 * in response to SIGCLD signals.  Note that this could 
 * be done more clearly (at least on HPUX systems) by
 * setting the SIGCLD signal to SIG_IGN...  - ja
 ************************************************************/
static int reaper()
{
	wait((int *) 0);
}


/************************************************************
 *  main
 ************************************************************/
main(argc, argv)
int argc;
char **argv;
{
	int teamno,pno;
	char *host = NULL;
	int usage = 0;
	int err = 0;
	char *ptr, *rindex(),*pseudonym;
	char buf[80];
	struct passwd *pwent, *getpwuid();

	construct_filenames();

	OPEN_LOGFILE(Logfilename);

	progname = *argv++;
	argc--;
	if ((ptr = rindex(progname, '/')) != NULL)
		progname = ptr + 1;
	while (*argv) {
		if (**argv == '-')
			++(*argv);
		else
			break;

		argc--;
		ptr = *argv++;
		while (*ptr) {
			switch (*ptr) {
			case 'u': 
				usage++; 
				break;
			case 'c':
				if (*argv == 0) {
					fprintf(stderr, "Missing required player number\n");
					err++;
					break;
				}
				pno = atoi(*argv);
				argc--;
				argv++;
				if (pno < 0 || pno >= MAXPLAYER) {
					fprintf(stderr, "Bad Player Number: %d\n", pno);
					err++;
				} else
					copilot++;
				break;
			case 'w':
				if (*argv == 0) {
					fprintf(stderr, "Missing required player number\n");
					err++;
					break;
				}
				pno = atoi(*argv);
				argc--;
				argv++;
				if (pno < 0 || pno >= MAXPLAYER) {
					fprintf(stderr, "Bad Player Number: %d\n", pno);
					err++;
				} else
					watch++;
				break;
			case 'd':
				host = *argv;
				argc--;
				argv++;
				break;
			case 'D':
				debug=1;
				break;
			default:
				fprintf(stderr, "%s: unknown option '%c'\n", progname, *ptr);
				err++;
				break;
			}
			ptr++;
		}
	}
	if (usage || err) {
		printUsage(progname);
		exit(err);
	}
	if (watch && copilot) {
		printf("%s: Cannot simultaneously use both watch and copilot.",
		    progname);
		exit(err);
	}
	/* compatability */
	if (argc > 0)
		host = argv[0];
	seedrandom();
	/* this creates the necessary x windows for the game */
	newwin(host, progname, argc, argv);
	/* Version 12 change -- call newwin before openmem to solve 
	 * "XIO: Not enough space" problems
     */
	/* this finds the shared memory information */
	openmem(TRUE);
	XSync(dpy, 0 );
	/* map the windows */
	mapAll();
	XSync(dpy, 0 );

	if (watch) {
		PLAYER *player;
		WATCHER *watcher;
		char mylogin[16],mymonitor[16],mon[16],*cptr;
		extern char *strchr();

#ifndef ALLOW_WATCHPLAY

		/* make sure I'm not already playing */
		mylogin[0] = '\0';
		if ((pwent = getpwuid(getuid())) != NULL) {
			strncpy(mylogin,pwent->pw_name,16);
			for (player=players; player<players+MAXPLAYER; ++player) {
				if (player->p_status == PFREE) continue;
				if (kill(player->p_pid,0) == -1) continue;
				if (strncmp(pwent->pw_name,player->p_login,16) == 0) {
					printf("Already playing game.  Exiting.\n");
					exit(err);
				}
			}
		}

		strncpy(mymonitor,DisplayString(dpy),16);
		if ((cptr = strchr(mymonitor,':')) != NULL) *cptr = '\0';

		for (player=players; player<players+MAXPLAYER; ++player) {
			if (player->p_status == PFREE) continue;
			if (kill(player->p_pid,0) == -1) continue;
			strncpy(mon,player->p_monitor,16);
			if ((cptr = strchr(mon,':')) != NULL) *cptr = '\0';
			if (strcmp(mon,mymonitor) == 0) {
				printf("Already one game on your display.  Exiting.\n");
				exit(err);
			}
		}

		/* find a watcher slot */
		sem_lock();
		for (watcher=watchers; watcher<watchers+MAXWATCHERS; ++watcher) {
			if ((watcher->w_status == PFREE)
					|| (kill(watcher->w_pid,0) == -1)) {
				watcher->w_status = PALIVE;
				strcpy(watcher->w_login,mylogin);
				strcpy(watcher->w_monitor,mymonitor);
				watcher->w_pid = (int) getpid();
				break;
			}
		}
		sem_unlock();
		if (watcher == watchers+MAXWATCHERS) {
			printf("No room in watcher array.  Exiting.\n");
			exit(err);
		}
#endif

	}
	else {
		/* make sure I'm not already watching */
		WATCHER *watcher;
		char mymonitor[16],*cptr;
		extern char *strchr();

#ifndef ALLOW_WATCHPLAY
		if ((pwent = getpwuid(getuid())) != NULL) {
			for (watcher=watchers; watcher<watchers+MAXWATCHERS; ++watcher) {
				if (watcher->w_status == PFREE) continue;
				if (kill(watcher->w_pid,0) == -1) continue;
				if (strncmp(pwent->pw_name,watcher->w_login,16) == 0) {
					printf("Already watching game.  Exiting.\n");
					exit(err);
				}
			}
		}

		strncpy(mymonitor,DisplayString(dpy),16);
		if ((cptr = strchr(mymonitor,':')) != NULL) *cptr = '\0';
		for (watcher=watchers; watcher<watchers+MAXWATCHERS; ++watcher) {
			if (watcher->w_status == PFREE) continue;
			if (kill(watcher->w_pid,0) == -1) continue;
			if (strcmp(watcher->w_monitor,mymonitor) == 0) {
				printf("Already one game on your display.  Exiting.\n");
				exit(err);
			}
		}
#endif
	}

	if ((!copilot) && (!watch)) {
		pno = findslot();
		logmsg2("found empty slot: %d\n",pno);
	}
	XSync(dpy, 0 );
	if (pno < 0) {
		/* print some appropriate message */
		exit(1);
	}
	me = &players[pno];
	myship = &me->p_ship;
	mystats = &me->p_stats;
	lastm = mctl->mc_current;
	mysignal(SIGINT, SIG_IGN);
	mysignal(SIGQUIT, SIG_IGN);
	mysignal(SIGCLD, reaper);
	mysignal(SIGUSR1, daemondead);
	pseudonym = XGetDefault( dpy, "dtrek", "name");
	if (pseudonym != NULL)
		strncpy(me->p_name, pseudonym, sizeof (me->p_name));
	else {
		me->p_name[0] = '\0';
	}
	time(&start_time);		/* For stat gathering */
	me->p_mode = sharedMemory->mode;
	init_mode(progname);

	if ((!copilot) && (!watch)) {
		me->p_team_no = -1;
		me->p_team_mask = limit_team_selection();
		setjmp(env);		/* Reentry point of game */
		if (me->p_team_no != -1) {
			/* I've died and come back to life */
			savestats();
		}
		/* give the player the motd and find out which team he wants */
		teamno = which_team();
		logmsg2("got team: #%d\n",teamno);
		XSync(dpy, 0 );
		if (teamno == -1) {
			players[pno].p_status = PFREE;
			unmap_special_windows();
			XFreeGC(dpy,gc);
			XUnmapWindow(dpy,frameWin);
			XDestroyWindow(dpy,frameWin);
			XCloseDisplay(dpy);
			exit(0);
		}
		redrawall = 1;
		enter(teamno,teamno,DisplayString(dpy),
			compute_hull_size(teamno),pno,FALSE,NULL,
			select_entry_planet);
		logmsg1("returned to main\n");
		initStats(progname);
		XClearWindow( dpy, mainw);

		openDamage(progname);
		if (showStats)			/* Default showstats are on. */
			statwin = openStats(me);

		me->p_ghostbuster = 0;

 		me->p_exittime = me->p_updates + (5*60*10);
 		me->p_flags |= PFSTART;
 		me->p_status = PIMMUNE;

 		warning("Hit any key to begin 5 second countdown to enter game");
	}
	else if (copilot) {
		if (me->p_status != PALIVE)
			exit(1);
		if (!(me->p_flags & PFCOPILOT)) {
			printf("%s is not allowing copilots\n", me->p_name);
			exit(1);
		}
		openDamage(progname);
		if (showStats)			/* Default showstats are on. */
			statwin = openStats(me);

		if ((pwent = getpwuid(getuid())) == NULL)
			sprintf(buf, "Unknown person joining as a copilot");
		else
			sprintf(buf, "%-8s joining as a copilot", pwent->pw_name);

		pmessage(buf, pno, MINDIV, "Game->YOU");
	}
	else {
		/* watch */
		initStats(progname);
		openDamage(progname);
	}
	/* Get input until the player quits or dies */
	input();
}

