/* keymap.c 15.1 G% 10:05:40 */

/* Original code by Daryl Poe.
 *
 * Copyright (c) 1989 Daryl Poe
 *
 * Ported to X11 by Jim Andreas.
 * Tractors, treaties, and other features by Norm Gee.
 * Damage window and shield bitmaps by Tom LaStrange.
 *
 * Permission to use, copy, modify, and distribute this
 * software and its documentation for any purpose and without
 * fee is hereby granted, provided that the above copyright
 * notice appear in all copies and that both that copyright
 * notice and this permission notice appear in supporting
 * documentation.  No representations are made about the
 * suitability of this software for any purpose.  It is
 * provided "as is" without express or implied warranty.
 */

#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/keysym.h>
#include <X11/keysymdef.h>
#include <stdio.h>
#include "defs.h"
#include "xdata.h"

char keymap[128];	/* from newwin.c */
extern FILE *logfile;

#define KEYBUFFER_LENGTH 10
#define MAXMOD 3

static void alias_it(basekey,shift,ctrl,meta,aliaskey)
KeySym basekey;
int shift,ctrl,meta;
char aliaskey;
{
	KeySym mods[MAXMOD];
	int nummod;

	nummod = 0;
	if (shift) {
		mods[nummod++] = XStringToKeysym("Shift_L");
	}

	if (ctrl) {
		mods[nummod++] = XStringToKeysym("Control_L");
	}

	if (meta) {
		mods[nummod++] = XStringToKeysym("Meta_L");
	}

	logmsg3("Rebinding %c to %c",(char)basekey,aliaskey);
	if (shift) logmsg1(" shift");
	if (ctrl) logmsg1(" ctrl");
	if (meta) logmsg1(" meta");
	logmsg1("\n");

	XRebindKeysym(dpy,basekey,mods,nummod,&aliaskey,1);

	if (((int) basekey >= 0x20)
			&& ((int) basekey < 128)
			&& !ctrl
			&& !meta) {
		keymap[(int) basekey] = aliaskey;
	}
}


void keyalias()
{
	char junk;
	KeySym whichkey,aliaskey,modkeysym;
	KeyCode modkeycode;
	char str[80],cwhichkey,caliaskey;
	XEvent event;
	int i,shift,ctrl,meta;
	unsigned char keys_down[32];
	typedef struct {
		int XK_keycode;
		char name[15];
	} MODKEY;
	static MODKEY modkey[] = {
		{ XK_Shift_L,	"Shift_L" },
		{ XK_Shift_R,	"Shift_R" },
		{ XK_Control_L,	"Control_L" },
		{ XK_Control_R,	"Control_R" },
		{ XK_Meta_L,	"Meta_L" },
		{ XK_Meta_R,	"Meta_R" },
	};
	long modkeybyte;
	unsigned char modkeybit;

	warning("ALIAS KEY -- REMAP WHICH KEY?");
	do {
		XNextEvent(dpy,&event);
		XLookupString(&event,&junk,1,&whichkey,NULL);
	} while (IsModifierKey(whichkey));

	/* find which modifier keys are down */
	XQueryKeymap(dpy,keys_down);
	shift = ctrl = meta = FALSE;
	for (i=0; i<6; ++i) {
		modkeysym  = XStringToKeysym(modkey[i].name);
		modkeycode = XKeysymToKeycode(dpy,modkeysym);
		modkeybyte = modkeycode >> 3;
		modkeybit  = (unsigned char) (1 << (modkeycode - modkeybyte*8));

		if (keys_down[modkeybyte] & modkeybit) {
			switch (modkey[i].XK_keycode) {
				case XK_Shift_L:
				case XK_Shift_R:
					shift = TRUE;
					break;
				case XK_Control_L:
				case XK_Control_R:
					ctrl = TRUE;
					break;
				case XK_Meta_L:
				case XK_Meta_R:
					meta = TRUE;
					break;
			}
		}
	}

	if (whichkey == (KeySym) 'A') {
		warning("Cannot alias \'A\'");
	}
	else {
		cwhichkey = (char) (whichkey & 0x7F);
		sprintf(str,"ALIAS KEY -- REMAP \'%c\' TO WHICH KEY?",
			cwhichkey);
		warning(str);
		do {
			XNextEvent(dpy,&event);
			XLookupString(&event,&junk,1,&aliaskey,NULL);
		} while (IsModifierKey(aliaskey));

		if (((int) aliaskey < 0x20)
				|| ((int) aliaskey >= 128)) {
			warning("Cannot alias to that.");
		}
		else {
			caliaskey = (char) aliaskey;
			sprintf(str,
				"ALIAS KEY -- REMAPPING \'%c\' TO \'%c\'",
				cwhichkey, caliaskey);
			warning(str);
			alias_it(whichkey,shift,ctrl,meta,caliaskey);
		}
	}
}


void init_keymap(prog)
char *prog;
{
	char ltr,option[20],value[20],*cptr,**sptr;
	int shift,i,j;
	static char *otherkeys[] = {
		/* function keys */
		"F1",
		"F2",
		"F3",
		"F4",
		"F5",
		"F6",
		"F7",
		"F8",

		/* silly keys */
		"Left",
		"Down",
		"Right",
		"Select",
		"Up",
		"Next",
		"Home",
		"Prior",
		"InsertChar",
		"DeleteChar",
		"InsertLine",
		"DeleteLine",
		"ClearLine",
		"Clear",

		/* misc */
		"Backspace",
		"Tab",
		"Return",
		"Pause",
		"Escape",

		/* numeric keyboard keys */
		"KP_0",
		"KP_1",
		"KP_2",
		"KP_3",
		"KP_4",
		"KP_5",
		"KP_6",
		"KP_7",
		"KP_8",
		"KP_9",
		"KP_Multiply",
		"KP_Divide",
		"KP_Add",
		"KP_Subtract",
		"KP_Enter",
		"KP_Seperator",
		"KP_Tab",
		"KP_Decimal",
		"KP_F1",
		"KP_F2",
		"KP_F3",
		"KP_F4",
		NULL
	};

	/* initialize keymap array */
	for (i = 0; i < 128; ++i) {
		keymap[i] = (char) i;
	}
	
	logmsg2("checking xdefaults for %s aliases\n",prog);
	for (j = 0x20, ltr=' '; j < 128; ++ltr, ++j) {
		if (ltr == 'A') continue;
		if (index("ABCDEFGHIJKLMNOPQRSTUVWXYZ~!@#$%^&*()_+|{}:\"?><",
				ltr) == NULL) {
			shift = FALSE;
		}
		else {
			shift = TRUE;
		}

		/* check for aliasK */
		sprintf(option,"alias%c",ltr);
		logmsg3("searching for %s; shift? %d\n",option,shift);
		if ((cptr = XGetDefault(dpy,prog,option)) != NULL) {
			logmsg2("found %s\n",option);
			strncpy(value,cptr,19);
			cptr = value;
			value[19] = '\0';
			/* skip blanks (unless that's all there is) */
			while ((*cptr != '\0') && (*cptr == ' ')) ++cptr;
			if (*cptr == '\0') *cptr = ' ';
			alias_it((KeySym) ltr,shift,FALSE,FALSE,*cptr);
		}

		/* check for aliasCTRL-K */
		sprintf(option,"aliasCTRL-%c",ltr);
		if ((cptr = XGetDefault(dpy,prog,option)) != NULL) {
			logmsg2("found %s\n",option);
			strncpy(value,cptr,19);
			cptr = value;
			value[19] = '\0';
			/* skip blanks (unless that's all there is) */
			while ((*cptr != '\0') && (*cptr == ' ')) ++cptr;
			if (*cptr == '\0') *cptr = ' ';
			alias_it((KeySym) ltr,FALSE,TRUE,FALSE,*cptr);
		}

		/* check for aliasMETA-K */
		sprintf(option,"aliasMETA-%c",ltr);
		if ((cptr = XGetDefault(dpy,prog,option)) != NULL) {
			logmsg2("found %s\n",option);
			strncpy(value,cptr,19);
			cptr = value;
			value[19] = '\0';
			/* skip blanks (unless that's all there is) */
			while ((*cptr != '\0') && (*cptr == ' ')) ++cptr;
			if (*cptr == '\0') *cptr = ' ';
			alias_it((KeySym) ltr,FALSE,FALSE,TRUE,*cptr);
		}

		/* check for aliasCTRLMETA-K */
		sprintf(option,"aliasCTRLMETA-%c",ltr);
		if ((cptr = XGetDefault(dpy,prog,option)) != NULL) {
			logmsg2("found %s\n",option);
			strncpy(value,cptr,19);
			cptr = value;
			value[19] = '\0';
			/* skip blanks (unless that's all there is) */
			while ((*cptr != '\0') && (*cptr == ' ')) ++cptr;
			if (*cptr == '\0') *cptr = ' ';
			alias_it((KeySym) ltr,FALSE,TRUE,TRUE,*cptr);
		}
	}

	/* finally check a few other keys */
	sptr = otherkeys;
	while (*sptr != NULL) {
		sprintf(option,"alias%s",*sptr);
		logmsg2("searching for %s\n",option);
		if ((cptr = XGetDefault(dpy,prog,option)) != NULL) {
			logmsg2("found %s\n",option);
			strncpy(value,cptr,19);
			cptr = value;
			value[19] = '\0';
			/* skip blanks (unless that's all there is) */
			while ((*cptr != '\0') && (*cptr == ' ')) ++cptr;
			if (*cptr == '\0') *cptr = ' ';
			alias_it(XStringToKeysym(*sptr),FALSE,FALSE,FALSE,*cptr);
		}
		++sptr;
	}
}

