/* interface.c 15.1 06/08/90 10:05:38 */

/*

	Copyright (c) 1986 	Chris Guthrie

Permission to use, copy, modify, and distribute this
software and its documentation for any purpose and without
fee is hereby granted, provided that the above copyright
notice appear in all copies and that both that copyright
notice and this permission notice appear in supporting
documentation.  No representations are made about the
suitability of this software for any purpose.  It is
provided "as is" without express or implied warranty.

*/

/* Major overhaul by Daryl Poe.
 *
 * Copyright (c) 1989 Daryl Poe
 *
 * Ported to X11 by Jim Andreas.
 * Tractors, treaties, and other features by Norm Gee.
 * Damage window and shield bitmaps by Tom LaStrange.
 *
 * The above comments apply to this version as well, and this
 * notice must also appear in any copies or follow-ons.
 */

/* This file will include all the interfaces between the input routines
 * and the daemon.  They should be useful for writing robots and the
 * like
 */


#include <stdio.h>
#include "defs.h"
#include "weapon.h"
#include "system.h"
#include "ship.h"
#include "stats.h"
#include "player.h"
#include "torp.h"
#include "status.h"
#include "planet.h"
#include "phaser.h"
#include "message.h"
#include "shmem.h"
#include "data.h"


void set_speed(speed)
int speed;
{
	if (me->p_flags & PFHYPERSPACE) me->p_desspeed = 0;
	else me->p_desspeed = speed;
	me->p_flags &=
		~(PFREPAIR | PFBOMB | PFORBIT | PFBEAMUP | PFBEAMDOWN);
}

void set_course(dir)
COURSE dir;
{
	me->p_desdir = dir;
	me->p_flags &= ~(PFBOMB | PFORBIT | PFBEAMUP | PFBEAMDOWN);
}

void shield_up()
{
	me->p_flags |= PFSHIELD;
	me->p_flags &= ~(PFBOMB | PFREPAIR | PFBEAMUP | PFBEAMDOWN);
}

void shield_down()
{
	me->p_flags &= ~PFSHIELD;
}

void shield_tog()
{
	me->p_flags ^= PFSHIELD;
	me->p_flags &= ~(PFBOMB | PFREPAIR | PFBEAMUP | PFBEAMDOWN);
}

int bomb_planet()
{
	if (!(me->p_flags & PFORBIT)) {
		warning("Must be orbiting to bomb");
		return(FALSE);
	}
	me->p_flags |= PFBOMB;
	me->p_flags &= ~(PFSHIELD | PFREPAIR | PFBEAMUP | PFBEAMDOWN);
	return(TRUE);
}

int beam_up()
{
	if (!(me->p_flags & PFORBIT)) {
		warning("Must be orbiting to beam up.");
		return(FALSE);
	}
	if (me->p_team_mask != planets[me->p_planet].pl_owner_mask) {
		warning("Those aren't our men.");
		return(FALSE);
	}
	me->p_flags |= PFBEAMUP;
	me->p_flags &= ~(PFSHIELD | PFREPAIR | PFBOMB | PFBEAMDOWN);
	return(TRUE);
}

int beam_down()
{
	if (!(me->p_flags & PFORBIT)) {
		warning("Must be orbiting to beam down.");
		return(FALSE);
	}
	if (planets[me->p_planet].pl_flags & (PLMASK_BLACKHOLE |
			PLMASK_PULSAR | PLMASK_NEBULA)) {
		warning("Cannot beam down to stellar object");
		return(FALSE);
	}
	if (planets[me->p_planet].pl_flags & PLMASK_BARREN) {
		warning("Cannot beam down to barren planet");
		return(FALSE);
	}
	me->p_flags |= PFBEAMDOWN;
	me->p_flags &= ~(PFSHIELD | PFREPAIR | PFBOMB | PFBEAMUP);
	return(TRUE);
}

void repair()
{
	me->p_desspeed = 0;
	me->p_flags |= PFREPAIR;
	me->p_flags &= ~(PFSHIELD | PFBOMB | PFBEAMUP | PFBEAMDOWN);
}

void repeat_message()
{
	if (++lastm == MAXMESSAGE) lastm = 0;
}

void toggle_cloak()
{
	if ((me->p_flags & PFCLOAK)
			|| (myship->s_sptechmask & STMASK_CLOAK))
		me->p_flags ^= PFCLOAK;
}

