/* input.c 15.1 06/08/90 10:05:33 */

/*

	Copyright (c) 1986 	Chris Guthrie

Permission to use, copy, modify, and distribute this
software and its documentation for any purpose and without
fee is hereby granted, provided that the above copyright
notice appear in all copies and that both that copyright
notice and this permission notice appear in supporting
documentation.  No representations are made about the
suitability of this software for any purpose.  It is
provided "as is" without express or implied warranty.

*/

/* Major overhaul by Daryl Poe.
 *
 * Copyright (c) 1989 Daryl Poe
 *
 * Ported to X11 by Jim Andreas.
 * Tractors, treaties, and other features by Norm Gee.
 * Damage window and shield bitmaps by Tom LaStrange.
 *
 * The above comments apply to this version as well, and this
 * notice must also appear in any copies or follow-ons.
 */

#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/keysym.h>
#include <X11/keysymdef.h>
#include <stdio.h>
#include <sys/types.h>
#include <time.h>
#include <signal.h>
#include <errno.h>
#include "defs.h"
#include "weapon.h"
#include "system.h"
#include "ship.h"
#include "stats.h"
#include "player.h"
#include "torp.h"
#include "status.h"
#include "planet.h"
#include "phaser.h"
#include "message.h"
#include "shmem.h"
#include "data.h"
#include "xdata.h"

#define FIRE_ALL_BEAMS -1

typedef struct {
	Window *window;
	char   keys[10];
} WINKEYS;

/* which keys are legal in each window.  ""=none */
/* all keys legal for mainw, mapw, galaxy_win */
static WINKEYS winkeys[] = {
	{ &infow,		" i" },
	{ &war,			" w" },
	{ &warf,		" w" },
	{ &warr,		" w" },
	{ &wark,		" w" },
	{ &waro,		" w" },
	{ &wargo,		" w" },
	{ &warno,		" w" },
	{ &warf1,		" w" },
	{ &warr1,		" w" },
	{ &wark1,		" w" },
	{ &waro1,		" w" },
	{ &wargo1,		" w" },
	{ &warno1,		" w" },
	{ &helpWin,		" h" },
	{ &planetw,		" P" },
	{ &playerw,		" L" },
	{ &scorewin,	" V" },
	{ &modew,		" m" },
	{ &mode_invasion_win,		" m" },
	{ &mode_defense_base_win,	" m" },
	{ &mode_monitor_win,		" m" },
	{ &mode_planetkiller_win,	" m" },
	{ &mode_starbase_mode_win,	" m" },
	{ &mode_robot_swarm_win,	" m" },
	{ &mode_defensive_beam_win,	" m" },
	{ &mode_wormhole_win,		" m" },
	{ &mode_smart_weap_win,		" m" },
	{ &mode_prob_vortex_win,	" m" },
	{ &iconWin,		"" },
	{ &tstatw,		"" },
	{ &statwin,		"" },
	{ &baseWin,		"" },
	{ &messagew,	"" },
	{ &damwin,		"" },
	{ &frameWin,	"" },
	{ &smessagew,	"" },
	{ &warnw,		"" },
};

static int	doTheRedrawDude, skipUpdates = 1, scorewin_exists = FALSE;
#define KEYBUFFER_LENGTH 1

void unmap_special_windows()
{
	if (ismapped(playerw))
		XUnmapWindow( dpy, playerw);
	if (ismapped(planetw))
		XUnmapWindow( dpy, planetw);
	if (infomapped)
		destroyInfo();
	if (ismapped(helpWin))
		XUnmapWindow( dpy, helpWin);
	if (ismapped(war))
		XUnmapWindow( dpy, war);
	if (ismapped(modew))
		XUnmapWindow( dpy, modew);
	if (ismapped(galaxy_win))
		XUnmapWindow( dpy, galaxy_win);
	if (scorewin_exists) {
		XUnmapWindow(dpy,scorewin);
		XDestroyWindow(dpy,scorewin);
		scorewin_exists = FALSE;
	}
}


static COURSE getcourse(ww, x, y)
Window ww;
int x, y;
{
	if ((ww == galaxy_win) || ((ww == mapw) && watch)) {
		int	me_x, me_y;

		me_x = me->p_x * WINSIDE / GWIDTH;
		me_y = me->p_y * WINSIDE / GWIDTH;
		return(Atan2(me_y - y, x - me_x));
	}
	else if (ww == mapw) {
		int	me_x, me_y;

		me_x = (me->p_x - me->map_offsetx) * WINSIDE / MAPWIDTH;
		me_y = (me->p_y - me->map_offsety) * WINSIDE / MAPWIDTH;
		return(Atan2(me_y - y, x - me_x));
	}
	else {
		return(Atan2(WINSIDE/2 - y, x - WINSIDE/2));
	}
}


PLANET *select_entry_planet(myhome)
PLANET *myhome;
{
	XEvent event;
	XButtonEvent *tmpButton = (XButtonEvent *) &event;
	OBTYPE target;
	XTextItem xtext;

	/* let the user choose which planet he wants to enter at */

	if (!ismapped(galaxy_win)) {
		XMapWindow(dpy,galaxy_win);
	}

	xtext.chars  = "Select starting planet -->";
	xtext.nchars = strlen(xtext.chars);
	xtext.delta  = 0;
	xtext.font   = dfont;
	XClearWindow(dpy,mainw);
	XDrawText(dpy,mainw,gc,50,(WINSIDE/2),&xtext,1);

	XSelectInput(dpy,galaxy_win,
		ButtonPressMask|KeyPressMask|ExposureMask);
	do {
		XNextEvent(dpy,&event);
		if ((event.type == Expose)
				&& (event.xany.window == galaxy_win)) {
			map(galaxy_win,TRUE,TRUE,TRUE);
		}
		else if ((event.type != ButtonPress)
				|| (event.xany.window != galaxy_win)) {
			event.type = Expose;
		}
	} while (event.type == Expose);

	gettarget(galaxy_win,tmpButton->x,tmpButton->y,
		TARG_PLANET|TARG_MEOWNER,&target);

	XUnmapWindow(dpy,galaxy_win);
	return(&planets[target.o_num]);
}


void initinput()
{
	XSelectInput( dpy, mainw, 
	    KeyPressMask|ButtonPressMask|ButtonReleaseMask|ExposureMask);
	XSelectInput( dpy, mapw, 
	    KeyPressMask|ButtonPressMask|ButtonReleaseMask|ExposureMask);
	XSelectInput(dpy,galaxy_win,
	    KeyPressMask|ButtonPressMask|ButtonReleaseMask|ExposureMask);
	XSelectInput( dpy, smessagew, KeyPressMask|ExposureMask);
	XSelectInput( dpy, messagew, ExposureMask);
	XSelectInput( dpy, tstatw, ExposureMask);

	XSelectInput( dpy, war, KeyPressMask|ExposureMask);
	XSelectInput( dpy, warf,
	    KeyPressMask|ButtonPressMask|ButtonReleaseMask|ExposureMask);
	XSelectInput( dpy, warr,
	    KeyPressMask|ButtonPressMask|ButtonReleaseMask|ExposureMask);
	XSelectInput( dpy, wark,
	    KeyPressMask|ButtonPressMask|ButtonReleaseMask|ExposureMask);
	XSelectInput( dpy, waro,
	    KeyPressMask|ButtonPressMask|ButtonReleaseMask|ExposureMask);
	XSelectInput( dpy, wargo,
	    KeyPressMask|ButtonPressMask|ButtonReleaseMask|ExposureMask);
	XSelectInput( dpy, warno,
	    KeyPressMask|ButtonPressMask|ButtonReleaseMask|ExposureMask);
	XSelectInput( dpy, warf1, KeyPressMask|ExposureMask);
	XSelectInput( dpy, warr1, KeyPressMask|ExposureMask);
	XSelectInput( dpy, wark1, KeyPressMask|ExposureMask);
	XSelectInput( dpy, waro1, KeyPressMask|ExposureMask);
	XSelectInput( dpy, wargo1, KeyPressMask|ExposureMask);
	XSelectInput( dpy, warno1, KeyPressMask|ExposureMask);

	XSelectInput( dpy, modew,
	    KeyPressMask|ExposureMask);
	XSelectInput( dpy, mode_invasion_win,
	    KeyPressMask|ButtonPressMask|ButtonReleaseMask|ExposureMask);
	XSelectInput( dpy, mode_defense_base_win,
	    KeyPressMask|ButtonPressMask|ButtonReleaseMask|ExposureMask);
	XSelectInput( dpy, mode_monitor_win,
	    KeyPressMask|ButtonPressMask|ButtonReleaseMask|ExposureMask);
	XSelectInput( dpy, mode_planetkiller_win,
	    KeyPressMask|ButtonPressMask|ButtonReleaseMask|ExposureMask);
	XSelectInput( dpy, mode_defensive_beam_win,
	    KeyPressMask|ButtonPressMask|ButtonReleaseMask|ExposureMask);
	XSelectInput( dpy, mode_robot_swarm_win,
	    KeyPressMask|ButtonPressMask|ButtonReleaseMask|ExposureMask);
	XSelectInput( dpy, mode_starbase_mode_win,
	    KeyPressMask|ButtonPressMask|ButtonReleaseMask|ExposureMask);
	XSelectInput( dpy, mode_wormhole_win,
	    KeyPressMask|ButtonPressMask|ButtonReleaseMask|ExposureMask);
	XSelectInput( dpy, mode_smart_weap_win,
	    KeyPressMask|ButtonPressMask|ButtonReleaseMask|ExposureMask);
	XSelectInput( dpy, mode_prob_vortex_win,
	    KeyPressMask|ButtonPressMask|ButtonReleaseMask|ExposureMask);

	XSelectInput( dpy, helpWin, KeyPressMask|ExposureMask);
	XSelectInput( dpy, planetw, KeyPressMask|ExposureMask);
	XSelectInput( dpy, playerw, KeyPressMask|ExposureMask);
}


static void setRedrawFlag()
{
	/* let the daemon know I'm real */
	if (!watch) me->p_ghostbuster = 0;

	if (skipUpdates) doTheRedrawDude = 1;
	else doTheRedrawDude++;
}


static void setwatch(pno)
int pno;
{
	me = &players[pno];
	myship = &me->p_ship;
	mystats = &me->p_stats;
	lastm = mctl->mc_current;
	redrawall = 1;
	closeDamage();
	openDamage(progname);
	if (showStats) {
		closeStats(statwin);
		initStats(progname);
		statwin = openStats(me);
	}
}


static void keyaction(key, data)
char key;
XKeyEvent *data;
{
	char buf[256];
	COURSE course;
	OBTYPE target;
	PLAYER *p;
	PLANET *pl;
	int gx,gy;

	logmsg2("input: got key '%c'\n",key);

	if (watch && !index("LPSMiQ?hw ", key)) {
		char	buf2[BUFSIZ];

		sprintf(buf2, "'%c' command is not permitted in watch mode.", key);
		warning(buf2);
		return;
	}

	/* insure legal key for the window */
	if ((data->window != mainw)
			&& (data->window != mapw)
			&& (data->window != galaxy_win)) {
		WINKEYS *wk;

		wk = winkeys;
		while (wk < winkeys + (sizeof(winkeys)/sizeof(WINKEYS))) {
			if (data->window == *(wk->window)) {
				if (rindex(wk->keys,key)) break;
				else {
					XBell( dpy, 100 );
					return;
				}
			}
			++wk;
		}
	}

	switch(key) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':
		set_speed(key - '0');
		break;
	case '[':
		set_speed(me->p_desspeed - 1);
		break;
	case ']':
		set_speed(me->p_desspeed + 1);
		break;
	case 'j': /* j = set course */
		course = getcourse(data->window, data->x, data->y);
		set_course(course);
		me->p_flags &= ~(PFPLOCK | PFPLLOCK);
		break;
	case 'p': /* p = fire beams */
		getxy(data->window,data->x,data->y,&gx,&gy);
		course = getcourse(data->window, data->x, data->y);
		fire_beam(course,gx,gy,FIRE_ALL_BEAMS);
		break;
	case ';': /* ; = fire one beam */
		getxy(data->window,data->x,data->y,&gx,&gy);
		course = getcourse(data->window, data->x, data->y);
		fire_beam(course,gx,gy,1);
		break;
	case 'T': /* fire tractor beams */
		if (me->p_tractors_on) {
			me->p_tractors_on = 0;
		}
		else {
			course = getcourse(data->window, data->x, data->y);
			fire_tractors(course,TRACTOR,myship->s_tractor);
		}
		break;
	case 'O': /* fire one tractor */
		if (me->p_tractors_on && (me->p_tractor_type != TRACTOR)) {
			/* turn them off */
			me->p_tractors_on = 0;
		}

		if (!(me->p_tractors_on)) {
			course = getcourse(data->window, data->x, data->y);
			fire_tractors(course,TRACTOR,1);
		}
		else if (me->p_tractors_on < myship->s_tractor) {
			course = Atan2(me->p_y - players[me->p_who_tractor].p_y,
				players[me->p_who_tractor].p_x - me->p_x);
			fire_tractors(course,TRACTOR,me->p_tractors_on+1);
		}
		/* else no change */
		break;
	case 'Y': /* fire repulsor beams */
		if (me->p_tractors_on) {
			me->p_tractors_on = 0;
		}
		else {
			course = getcourse(data->window, data->x, data->y);
			fire_tractors(course,REPULSOR,myship->s_tractor);
		}
		break;
	case 'y': /* fire one repulsor */
		if (me->p_tractors_on && (me->p_tractor_type != REPULSOR)) {
			/* turn them off */
			me->p_tractors_on = 0;
		}

		if (!(me->p_tractors_on)) {
			course = getcourse(data->window, data->x, data->y);
			fire_tractors(course,REPULSOR,1);
		}
		else if (me->p_tractors_on < myship->s_tractor) {
			course = Atan2(me->p_y - players[me->p_who_tractor].p_y,
				players[me->p_who_tractor].p_x - me->p_x);
			fire_tractors(course,REPULSOR,me->p_tractors_on+1);
		}
		/* else no change */
		break;
	case 'W': /* fire winch beams */
		if (me->p_tractors_on) {
			me->p_tractors_on = 0;
		}
		else {
			course = getcourse(data->window, data->x, data->y);
			fire_tractors(course,WINCH,myship->s_tractor);
		}
		break;
	case 'I': /* fire one winch */
		if (me->p_tractors_on && (me->p_tractor_type != WINCH)) {
			/* turn them off */
			me->p_tractors_on = 0;
		}

		if (!(me->p_tractors_on)) {
			course = getcourse(data->window, data->x, data->y);
			fire_tractors(course,WINCH,1);
		}
		else if (me->p_tractors_on < myship->s_tractor) {
			course = Atan2(me->p_y - players[me->p_who_tractor].p_y,
				players[me->p_who_tractor].p_x - me->p_x);
			fire_tractors(course,WINCH,me->p_tractors_on+1);
		}
		/* else no change */
		break;
	case 'U': /* fire pusher beams */
		if (me->p_tractors_on) {
			me->p_tractors_on = 0;
		}
		else {
			course = getcourse(data->window, data->x, data->y);
			fire_tractors(course,PUSHER,myship->s_tractor);
		}
		break;
	case 'u': /* fire one pusher */
		if (me->p_tractors_on && (me->p_tractor_type != PUSHER)) {
			/* turn them off */
			me->p_tractors_on = 0;
		}

		if (!(me->p_tractors_on)) {
			course = getcourse(data->window, data->x, data->y);
			fire_tractors(course,PUSHER,1);
		}
		else if (me->p_tractors_on < myship->s_tractor) {
			course = Atan2(me->p_y - players[me->p_who_tractor].p_y,
				players[me->p_who_tractor].p_x - me->p_x);
			fire_tractors(course,PUSHER,me->p_tractors_on+1);
		}
		/* else no change */
		break;
	case 't': /* t = launch torps */
		if (myship->s_torpclass == WPN_MINE)
			getxy(data->window,data->x,data->y,&gx,&gy);
		else course = getcourse(data->window, data->x, data->y);
		fire_torp(course,gx,gy);
		break;
	case '+': /* + = Put shields up */
		shield_up();
		break;
	case '-': /* - = Put shields down */
		shield_down();
		break;
	case 's': /* toggle shields */
		shield_tog();
		break;
	case 'b': /* b = bomb planet */
		bomb_planet();
		break;
	case 'z': /* z = beam up */
		beam_up();
		break;
	case 'x': /* x = beam down */
		beam_down();
		break;
	case 'R': /* R = Go into repair mode */
		me->p_flags &= ~(PFPLOCK | PFPLLOCK);
		repair();
		break;
	case 'o': /* o = orbit nearest planet */
		me->p_flags &= ~(PFPLOCK | PFPLLOCK);
		orbit(me);
		break;
	case 'Q':
		if (copilot || watch)
			exit(1);
		me->p_flags |= PFSELFDEST;
		selfdest = me->p_updates + 100;
		warning("Self destruct initiated");
		break;
	case 'X':
		if (copilot || watch) exit(1);
		if (!(me->p_flags & PFORBIT)
				|| (me->p_hostile_mask
					& planets[me->p_planet].pl_owner_mask)) {
			gettarget(data->window, data->x, data->y,
				TARG_PLANET|TARG_FRIENDLY,&target);
			me->p_flags &= ~(PFPLOCK|PFORBIT|PFBEAMUP|PFBEAMDOWN|PFBOMB);
			me->p_flags |= (PFPLLOCK|PFEXIT);
			me->p_planet = target.o_num;
			if (me->p_desspeed < 4) set_speed(4);
			sprintf(buf, "Navigational lock on %s.  Will eXit on arrival.",
			    planets[target.o_num].pl_name);
			warning(buf);
		}
		else {
			begin_exit_countdown(me);
		}
		break;
	case '?': /* ? = Redisplay all messages */
		repeat_message();
		break;
	case 'c': /* c = cloak */
		toggle_cloak();
		break;
	case 'C': /* C = coups */
		coup();
		break;
	case 'l': /* l = navigational lock */
		/* since a robot would never use this function (it's user
	       Interface dependent,) all the work is done here instead
	       of in interface.c */
		gettarget(data->window, data->x, data->y,
		    TARG_PLAYER|TARG_PLANET|TARG_VISIBLE,&target);
		if (target.o_type == PLAYERTYPE) {
			me->p_flags |= PFPLOCK;
			me->p_flags &= ~(PFPLLOCK|PFORBIT|PFBEAMUP|PFBEAMDOWN|PFBOMB);
			me->p_playerl = target.o_num;
			p = &players[target.o_num];
			sprintf(buf, "Navigational lock on %s (%s)",
			    p->p_name,
				p->p_mapchars);
			warning(buf);
		}
		else { 	/* It's a planet */
			me->p_flags |= PFPLLOCK;
			me->p_flags &= ~(PFPLOCK|PFORBIT|PFBEAMUP|PFBEAMDOWN|PFBOMB);
			me->p_planet = target.o_num;
			pl = &planets[target.o_num];
			sprintf(buf, "Navigational lock on %s",
			    pl->pl_name);
			warning(buf);
		}
		break;
	case 'k': /* k = weapon lock */
		if ( sharedMemory->mode & SMART_WEAP_MASK)
		gettarget(data->window, data->x, data->y,
			TARG_PLAYER|TARG_UNFRIENDLY|TARG_VISIBLE,&target);
		else
		gettarget(data->window, data->x, data->y,
			TARG_PLAYER|TARG_VISIBLE,&target);

		if (target.o_num != me->p_no) {
			/* there's a target, make sure it's different than last */
			if (!(me->p_flags & PFWLOCK)
					|| (me->p_wpnlock != target.o_num)) {
				/* good, there's someone else to lock on to */
				me->p_flags |= PFWLOCK;
				me->p_wpnlock = target.o_num;
				p = &players[target.o_num];
				sprintf(buf, "Weapons lock on %s (%s)",
				    p->p_name, p->p_mapchars);
				warning(buf);
	
				sprintf(buf, "%s (%s) has locked his weapons on you", 
					me->p_name, me->p_mapchars);
				pmessage(buf, p->p_no, MINDIV, "Game->YOU");
			}
		}
		break;
	case 'K': /* K = weapon unlock */
		me->p_flags &= ~PFWLOCK;
		break;
	case '@': /* @ = toggle copilot permissions */
		me->p_flags ^= PFCOPILOT;
		break;

	case '$':
		if (fork() == 0) {
			detach();
			xdetach();
			setresuid(geteuid(),-1,-1);
			start_robot(JUGGERNAUT,0.0,me->p_no,-1,TRUE,NULL);
			_exit(1);
		}
		break;
	case '%':
		if (fork() == 0) {
			detach();
			xdetach();
			setresuid(geteuid(),-1,-1);
			start_robot(FEDERATION,0.0,me->p_no,-1,TRUE,NULL);
			_exit(1);
		}
		break;
	case '^':
		if (fork() == 0) {
			detach();
			xdetach();
			setresuid(geteuid(),-1,-1);
			start_robot(ROMULAN,0.0,me->p_no,-1,TRUE,NULL);
			_exit(1);
		}
		break;
	case '&':
		if (fork() == 0) {
			detach();
			xdetach();
			setresuid(geteuid(),-1,-1);
			start_robot(KLINGON,0.0,me->p_no,-1,TRUE,NULL);
			_exit(1);
		}
		break;
	case '*':
		if (fork() == 0) {
			detach();
			xdetach();
			setresuid(geteuid(),-1,-1);
			start_robot(ORION,0.0,me->p_no,-1,TRUE,NULL);
			_exit(1);
		}
		break;

		/* Start of display functions */
	case ' ': /* ' ' = clear special windows */
		unmap_special_windows();
		break;
	case 'L': /* L = Player list */
		if (ismapped(playerw)) {
			XUnmapWindow( dpy, playerw);
		} else {
			XMapWindow( dpy, playerw);
		}
		break;
	case 'P': /* P = Planet list */
		if (ismapped(planetw)) {
			XUnmapWindow( dpy, planetw);
		} else {
			XMapWindow( dpy, planetw);
		}
		break;
	case 'S': /* S = toggle stat mode */
		if (showStats) {
			showStats = !showStats;
			closeStats(statwin);
		} else {
			statwin = openStats(me);
			showStats = !showStats;
		}
		break;
	case 'N': /* N = Toggle Name mode */
		namemode = !namemode;
		break;
	case 'i': /* i = get information */
		if (!infomapped)
			inform(data->window, data->x, data->y);
		else
			destroyInfo();
		break;
	case 'h': /* h = Map help window */
		if (ismapped(helpWin)) {
			XUnmapWindow( dpy, helpWin);
		} else {
			XMapWindow( dpy, helpWin);
		}
		break;
	case 'w': /* w = map war stuff */
		if (copilot) {
			warning("Copilots cannot alter war settings");
			break;
		}
		if (ismapped(war))
			XUnmapWindow( dpy, war);
		else
			warwindow();
		break;
	case 'm': /* m = map optional mode stuff */
		if (copilot) {
			warning("Copilots cannot alter mode settings");
			break;
		}
		if (ismapped(modew))
			XUnmapWindow( dpy, modew);
		else
			modewindow();
		break;
	case 'V': /* m = (un)map scores window */
		if (scorewin_exists) {
			XUnmapWindow(dpy,scorewin);
			XDestroyWindow(dpy,scorewin);
			scorewin_exists = FALSE;
		}
		else {
			create_scorewindow();
			scorewin_exists = TRUE;
		}
		break;
	case 'g': /* g = galaxy map */
		if (ismapped(galaxy_win)) {
			if (infomapped) destroyInfo();
			XUnmapWindow( dpy, galaxy_win);
		}
		else {
			XMapWindow( dpy, galaxy_win);
			/* let exposure event redraw it */
		}
		break;
	case 'H': /* H = hyperspace */
		if (myship->s_sptechmask & STMASK_HYPERSPACE) {
			if (!(me->p_flags & PFHYPERSPACE)) {
				if ((me->p_etemp > 100+INTRAND(300)) || (me->p_flags & PFENG)) {
					warning("Engines too hot for hyperspace.");
					break;
				}
				me->p_flags    |= PFHYPERSPACE;
				me->p_desspeed  = 0;
				if (data->window == galaxy_win) {
					me->p_hyp_x = data->x * GWIDTH / WINSIDE;
					me->p_hyp_y = data->y * GWIDTH / WINSIDE;
				}
				else if (data->window == mapw) {
					me->p_hyp_x = me->map_offsetx
						+ data->x * MAPWIDTH / WINSIDE;
					me->p_hyp_y = me->map_offsety
						+ data->y * MAPWIDTH / WINSIDE;
				}
				else {
					me->p_hyp_x = me->p_x +
						((data->x - WINSIDE/2) * SCALE);
					me->p_hyp_y = me->p_y +
						((data->y - WINSIDE/2) * SCALE);
				}
				me->p_hyp_x += INTRAND(GWIDTH/20) - (GWIDTH/40);
				if (me->p_hyp_x > (GWIDTH-10))
					me->p_hyp_x = (GWIDTH-10);
				else if (me->p_hyp_x < 10)
					me->p_hyp_x = 10;
				me->p_hyp_y += INTRAND(GWIDTH/20) - (GWIDTH/40);
				if (me->p_hyp_y > (GWIDTH-10))
					me->p_hyp_y = (GWIDTH-10);
				else if (me->p_hyp_y < 10)
					me->p_hyp_y = 10;
			}
			else me->p_flags &= ~PFHYPERSPACE;
		}
		else me->p_flags &= ~PFHYPERSPACE;
		break;
	case 'E': /* E = toggle ECM */
		if (myship->s_sptechmask & STMASK_ECM) {
			me->p_flags ^= PFECM;
		}
		else me->p_flags &= ~PFECM;
		break;
	case 'A': /* A = alias key */
		keyalias();
		break;
	default:
		XBell( dpy, 100 );
		break;
	}
}


static void buttonaction(data)
XButtonEvent *data;
{
	COURSE course;
	OBTYPE target;
	int gx,gy;

	logmsg1("input: got mouse button press\n");

	if (watch) {	/* Special case */
		gettarget(data->window, data->x, data->y,
		    TARG_PLAYER|TARG_CLOAK, &target);
		if (target.o_num != me->p_no) setwatch(target.o_num);
		return;
	}

	if ((data->button & 0xf) == Button3) {
		course = getcourse(data->window, data->x, data->y);
		me->p_desdir = course;
		me->p_flags &=
			~(PFBOMB|PFORBIT|PFBEAMUP|PFBEAMDOWN|PFPLOCK|PFPLLOCK);
	}
	else if ((data->button & 0xf) == Button1) {
		if (myship->s_torpclass == WPN_MINE)
			getxy(data->window,data->x,data->y,&gx,&gy);
		else course = getcourse(data->window, data->x, data->y);
		fire_torp(course,gx,gy);
	}
	else if ((data->button & 0xf) == Button2) {
		getxy(data->window,data->x,data->y,&gx,&gy);
		course = getcourse(data->window, data->x, data->y);
		fire_beam(course,gx,gy,FIRE_ALL_BEAMS);
	}
}


static int inputIgnored(keysym_ptr)
KeySym *keysym_ptr;
{
	char buf[256],addrbuf[80];
	int entertime;

	if (watch) return(0);
	if ((me->p_status == PIMMUNE) && (!(me->p_flags & PFENTER))) {
		if ((keysym_ptr != NULL)
				&& IsModifierKey(*keysym_ptr)) {
			return(1);
		}
		if (me->p_flags & PFSTART) {
			me->p_exittime = me->p_updates + 40 + INTRAND(20);
			entertime = 5;
		}
		else {
			me->p_exittime = me->p_updates + 80 + INTRAND(40);
			entertime = 10;
		}
		me->p_flags |= (PFENTER|PFSHIELD);
		me->p_flags &= ~(PFCLOAK|PFBEAMUP|PFBEAMDOWN
			|PFSELFDEST|PFPLOCK|PFPLLOCK|PFWLOCK|PFECM|PFHYPERSPACE
			|PFSPHERE|PFEXIT);
		/**** send message to all players ****/
		sprintf(buf, "%s (%s) entering game in about %d seconds",
		    	me->p_name, me->p_mapchars, entertime);
		sprintf(addrbuf, " %s->ALL",me->p_mapchars);
		pmessage(buf, 0, MALL, addrbuf);
	}
	if (me->p_status != PALIVE) return (1);
	if (me->p_flags & PFWAR) {
		warning("Battle computers being re-programmed");
		return (1);
	}
	return (0);
}


void input()
{
	XEvent data;
	XKeyEvent    *tmpKey;
	XButtonEvent *tmpButton;
	KeySym keysym;
	char *c,str[KEYBUFFER_LENGTH];
	int nchar;
	int fd;
	struct itimerval udt;


	mysignal(SIGALRM, setRedrawFlag);
	udt.it_interval.tv_sec = 0;
	udt.it_interval.tv_usec = 200000;
	udt.it_value.tv_sec = 0;
	udt.it_value.tv_usec = 200000;
	setitimer(ITIMER_REAL, &udt, (struct itimerval *) NULL);

	tmpKey    = (XKeyEvent *)    &data;
	tmpButton = (XButtonEvent *) &data;

	while (1) {
		while (doTheRedrawDude-- > 0) {
			intrupt();
		}
		while (!XPending( dpy )) {
			fd = 1 << ConnectionNumber( dpy );
			select(32, &fd, 0, 0, (struct timeval *) NULL);
			while (doTheRedrawDude-- > 0)
				intrupt();
		}
		XNextEvent( dpy, &data);
		if ((!(copilot || watch)) && (me->p_updates > delay)) {
			me->p_flags &= ~(PFWAR);
		}
		switch ((int) data.type) {
		case KeyPress:
			nchar = XLookupString( &data, str, KEYBUFFER_LENGTH,
				&keysym, NULL );
			if (inputIgnored(&keysym)) continue;
			if ((me->p_flags & PFSELFDEST) && (!watch)) {
				me->p_flags &= ~(PFSELFDEST|PFENTER);
				warning("Self Destruct has been canceled");
			}
			else if ((me->p_flags & PFEXIT) && (!watch)) {
				me->p_flags &= ~PFEXIT;
				warning("Temporary game exit canceled");
			}
			if (data.xany.window == smessagew) {
				smessage(keysym);
			}
			else {
				c = str;
				++nchar;
				while (--nchar > 0) {
					if (*c != NoSymbol) {
						keyaction(*c, tmpKey);
					}
					++c;
				}
			}
			break;
		case ButtonPress:
			if (inputIgnored(NULL)) continue;
			if ((me->p_flags & PFSELFDEST) && (!watch)) {
				me->p_flags &= ~(PFSELFDEST|PFENTER);
				warning("Self Destruct has been canceled");
			}
			else if ((me->p_flags & PFEXIT) && (!watch)) {
				me->p_flags &= ~PFEXIT;
				warning("Temporary game exit canceled");
			}
			if (data.xany.window == warf)
				waraction(tmpButton);
			else if (data.xany.window == warr)
				waraction(tmpButton);
			else if (data.xany.window == wark)
				waraction(tmpButton);
			else if (data.xany.window == waro)
				waraction(tmpButton);
			else if (data.xany.window == wargo)
				waraction(tmpButton);
			else if (data.xany.window == warno)
				waraction(tmpButton);
			else if ((data.xany.window == mode_invasion_win)
					|| (data.xany.window == mode_defense_base_win)
					|| (data.xany.window == mode_monitor_win)
					|| (data.xany.window == mode_planetkiller_win)
					|| (data.xany.window == mode_robot_swarm_win)
					|| (data.xany.window == mode_defensive_beam_win)
					|| (data.xany.window == mode_starbase_mode_win)
					|| (data.xany.window == mode_wormhole_win)
					|| (data.xany.window == mode_smart_weap_win)
					|| (data.xany.window == mode_prob_vortex_win))
				modeaction(tmpButton);
			else
				buttonaction(tmpButton);
			break;
		case Expose:
			if (data.xany.window == statwin && showStats)
				redrawStats(statwin);
			else if (data.xany.window == damwin)
			    redrawDamage();
			else if (data.xany.window == messagew)
			    redraw_messagew();
			else if (data.xany.window == tstatw)
				redrawTstats();
			else if (data.xany.window == mapw)
				redrawall = 1;
			else if (data.xany.window == galaxy_win)
				map(galaxy_win,TRUE,TRUE,FALSE);
			else if (data.xany.window == iconWin)
				drawIcon();
			else if (data.xany.window == helpWin)
			{
				fillhelp();
			}
			else if (data.xany.window == playerw)
				playerlist();
			else if (data.xany.window == planetw)
				planetlist();
			else if (data.xany.window == scorewin)
				printscores(scorewin);
			break;
		default:
			break;
		}
	}
}

