/* inform.c 15.1 06/08/90 10:05:29 */

/*

	Copyright (c) 1986 	Chris Guthrie

Permission to use, copy, modify, and distribute this
software and its documentation for any purpose and without
fee is hereby granted, provided that the above copyright
notice appear in all copies and that both that copyright
notice and this permission notice appear in supporting
documentation.  No representations are made about the
suitability of this software for any purpose.  It is
provided "as is" without express or implied warranty.

*/

/* Major overhaul by Daryl Poe.
 *
 * Copyright (c) 1989 Daryl Poe
 *
 * Ported to X11 by Jim Andreas.
 * Tractors, treaties, and other features by Norm Gee.
 * Damage window and shield bitmaps by Tom LaStrange.
 *
 * The above comments apply to this version as well, and this
 * notice must also appear in any copies or follow-ons.
 */

#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <time.h>
#include <stdio.h>
#include "defs.h"
#include "weapon.h"
#include "system.h"
#include "ship.h"
#include "stats.h"
#include "player.h"
#include "torp.h"
#include "status.h"
#include "planet.h"
#include "phaser.h"
#include "message.h"
#include "shmem.h"
#include "data.h"
#include "xdata.h"

#define PLAYERINFOCHARS	23
#define PLAYERINFOLINES	10
#define PLANETINFOCHARS	20
#define PLANETINFOLINES	4


/* Display information about the nearest objext to mouse */

/*
** When the player asks for info, this routine finds the object
** nearest the mouse, either player or planet, and pop up a window
** with the desired information in it.
** 
** We intentionally provide less information than is actually
** available.  Keeps the fog of war up.
**
** There is a different sized window for each type player/planet
** and we take care to keep it from extending beyond the main
** window boundaries.
*/

void inform(ww, x, y)
Window ww;
int x, y;
{
	char buf[BUFSIZ];
	int line = 0,fontheight;
	register PLAYER *j;
	register PLANET *k;
	PLANET_INFO *pi;
	int mx, my;
	double dist;
	Window subw;
	OBTYPE target;
	static XWindowAttributes  wi;
	Window CurrentRoot;
	int rootX, rootY;
	unsigned int mask;
	XTextItem t;
	XGCValues values;
	int ismine,flags;

	infomapped = 1;
	gettarget(ww, x, y,
		(TARG_PLAYER|TARG_PLANET|TARG_VISIBLE|TARG_IMMUNE_OK), &target);

	if (wi.width == 0)
		XGetWindowAttributes( dpy, ww, &wi);

	XQueryPointer( dpy, ww, &CurrentRoot, &subw, 
		&rootX, &rootY, &mx, &my, &mask );

	fontheight = dfontinfo->ascent + dfontinfo->descent;

	if (target.o_type == PLAYERTYPE) {
		/****** PLAYER ******/
		/* Too close to the edge? */
		if (mx+PLAYERINFOCHARS*dfontinfo->max_bounds.rbearing+2 > wi.width)
			mx = wi.width-PLAYERINFOCHARS*dfontinfo->max_bounds.rbearing - 2;
		if (my+PLAYERINFOLINES*fontheight+2 > wi.height)
			my = wi.height - PLAYERINFOLINES * fontheight - 2;

		infow = XCreateSimpleWindow( dpy, ww,
		    mx,	my, PLAYERINFOCHARS * dfontinfo->max_bounds.rbearing,
		    PLAYERINFOLINES * fontheight, 2, borderColor, backColor);
		XSelectInput( dpy, infow,   KeyPressMask|ExposureMask);

		XMapWindow( dpy, infow );
		j = &players[target.o_num];
		dist = Ihypot(me->p_x - j->p_app_x, me->p_y - j->p_app_y);

		/* ID */
		sprintf(buf, "%s (%s):", j->p_name, j->p_mapchars);
		values.foreground =  playerColor(j);
		XChangeGC( dpy, gc, GCForeground, &values );
		t.chars = buf;
		t.nchars = strlen(buf);
		t.delta = 0;
		t.font  = shipFont(j);
		XDrawText( dpy, infow, gc,
		 	dfontinfo->max_bounds.rbearing,
			fontheight * line++ + dfontinfo->ascent,
			&t, 1 );  

		/* LOGIN */
		sprintf(buf, "Login   %-s", j->p_login);
		t.nchars = strlen(buf);
		XDrawText( dpy, infow, gc, 
			dfontinfo->max_bounds.rbearing,
		    fontheight * line++ + dfontinfo->ascent,
		    &t, 1 ); 

		/* SHIP CLASS */
		sprintf(buf,"Class   %s",j->p_ship.s_shipname);
		t.nchars = strlen(buf);
		XDrawText( dpy, infow, gc, 
			dfontinfo->max_bounds.rbearing,
		    fontheight * line++ + dfontinfo->ascent,
		    &t, 1 ); 

		/* SHIP SIZE */
		sprintf(buf,"Ktons   %d",j->p_ship.s_hull);
		t.nchars = strlen(buf);
		XDrawText( dpy, infow, gc, 
			dfontinfo->max_bounds.rbearing,
		    fontheight * line++ + dfontinfo->ascent,
		    &t, 1 ); 

		/* DISPLAY */		
		sprintf(buf, "Display %-s", j->p_monitor);
		t.nchars = strlen(buf);
		t.font  = dfont;
		XDrawText( dpy, infow, gc,
			dfontinfo->max_bounds.rbearing,
		    fontheight * line++ + dfontinfo->ascent,
		    &t, 1 );

		/* SPEED */		
		sprintf(buf, "Speed   %-d", j->p_speed);
		t.nchars = strlen(buf);
		XDrawText( dpy, infow, gc, 
			dfontinfo->max_bounds.rbearing,
		    fontheight * line++ + dfontinfo->ascent,
		    &t, 1 );  

		/* DAMAGE */
 		sprintf(buf, "Damage  %-d",
			100 - 100 * j->p_ship.s_system[1].current_size /
			j->p_ship.s_system[1].undamaged_size);
  		values.foreground =  playerColor(j);
  		XChangeGC( dpy, gc, GCForeground, &values );
  		t.chars = buf;
  		t.nchars = strlen(buf);
  		t.delta = 0;
  		t.font  = shipFont(j);
  		XDrawText( dpy, infow, gc,
			dfontinfo->max_bounds.rbearing,
  		    fontheight * line++ + dfontinfo->ascent,
			&t, 1 );
 

		/* KILLS */
		sprintf(buf, "kills   %-4.2f", j->p_kills);
		t.nchars = strlen(buf);
		XDrawText( dpy, infow, gc,  
			dfontinfo->max_bounds.rbearing,
		    fontheight * line++ + dfontinfo->ascent,
		    &t, 1 );  

		/* DISTANCE */
		sprintf(buf, "dist    %-d", (int) dist);
		t.nchars = strlen(buf);
		XDrawText( dpy, infow, gc,  
			dfontinfo->max_bounds.rbearing,
		    fontheight * line++ + dfontinfo->ascent,
		    &t, 1 );  

		/* WAR/HOSTILE/PEACEFUL */
		if (j->p_hostile_mask & me->p_team_mask) {
			t.chars = "HOSTILE";
			t.nchars = 7;
			XDrawText( dpy, infow, gc,    
				dfontinfo->max_bounds.rbearing,
	    		fontheight * line++ + dfontinfo->ascent,
	    		&t, 1 );  
		}
		else {
			t.chars = "PEACEFUL";
			t.nchars = 8;
			XDrawText( dpy, infow, gc,   
				dfontinfo->max_bounds.rbearing,
	    		fontheight * line++ + dfontinfo->ascent,
	    		&t, 1 );  
		}
	}
	else {
		/****** PLANET ******/
		/* Too close to the edge? */
		if (mx + PLANETINFOCHARS * dfontinfo->max_bounds.rbearing + 2 > wi.width)
			mx = wi.width - PLANETINFOCHARS * dfontinfo->max_bounds.rbearing - 2;
		if (my + PLANETINFOLINES * fontheight + 2 > wi.height)
			my = wi.height - PLANETINFOLINES * fontheight - 2;

		infow = XCreateSimpleWindow( dpy, ww, mx, my,
			PLANETINFOCHARS * dfontinfo->max_bounds.rbearing,
		    PLANETINFOLINES * fontheight,
		    2, borderColor, backColor);
		XSelectInput( dpy, infow,   KeyPressMask|ExposureMask);

		XMapWindow( dpy, infow);
		k = &planets[target.o_num];
		dist = Ihypot(me->p_x - k->pl_x, me->p_y - k->pl_y);
		pi = &(k->pl_info[me->p_team_no]);
		ismine = (k->pl_owner_no == me->p_team_no)
				|| (me->p_team_no == INDEPENDENT); /* for watch mode */

		/* LAST KNOWN OWNER */
		if (ismine) {
			sprintf(buf, "%s (%c)",
				k->pl_name, teamlet[k->pl_owner_no]);
		}
		else {
			sprintf(buf, "%s (%c)",
				k->pl_name, teamlet[pi->pi_owner_no]);
		}
		values.foreground = planetColor(k);
		XChangeGC( dpy, gc, GCForeground, &values );
		t.chars  = buf;
		t.nchars = strlen(buf);
		t.delta  = 0;
		t.font   = ismine ? bfont : dfont;
		XDrawText( dpy, infow, gc,   
			dfontinfo->max_bounds.rbearing,
		    fontheight * line++ + dfontinfo->ascent,
		    &t, 1 ); 

		t.font  = dfont;
		if (k->pl_flags & PLMASK_BLACKHOLE) {
			sprintf(buf,"Black Hole");
			t.nchars = strlen(buf);
			XDrawText( dpy, infow, gc, 
				dfontinfo->max_bounds.rbearing,
				fontheight * line++ + dfontinfo->ascent,
			    &t, 1 );  
		}
		else if (k->pl_flags & PLMASK_PULSAR) {
			sprintf(buf,"Pulsar");
			t.nchars = strlen(buf);
			XDrawText( dpy, infow, gc, 
				dfontinfo->max_bounds.rbearing,
				fontheight * line++ + dfontinfo->ascent,
			    &t, 1 );  
		}
		else if (k->pl_flags & PLMASK_BARREN) {
			sprintf(buf,"Barren Planet");
			t.nchars = strlen(buf);
			XDrawText( dpy, infow, gc, 
				dfontinfo->max_bounds.rbearing,
				fontheight * line++ + dfontinfo->ascent,
			    &t, 1 );  
		}
		else if (k->pl_flags & PLMASK_NEBULA) {
			sprintf(buf,"Nebula");
			t.nchars = strlen(buf);
			XDrawText( dpy, infow, gc, 
				dfontinfo->max_bounds.rbearing,
				fontheight * line++ + dfontinfo->ascent,
			    &t, 1 );  
		}
		else {
			/* ARMIES */
			if (ismine) sprintf(buf, "Armies %d", k->pl_armies);
			else sprintf(buf, "Armies %d", pi->pi_armies);
			t.nchars = strlen(buf);
			XDrawText( dpy, infow, gc, 
				dfontinfo->max_bounds.rbearing,
				fontheight * line++ + dfontinfo->ascent,
			    &t, 1 );  
	
			/* REPAIR, FUEL, ETC. */
			if (ismine) flags = k->pl_flags;
			else flags = pi->pi_flags;
			sprintf(buf, "%s %s",
			    (flags & PLMASK_REPAIR ? "REPAIR" : "      "),
			    (flags & PLMASK_FUEL   ? "FUEL"   : "    "));
			t.nchars = strlen(buf);
			XDrawText( dpy, infow, gc,  
				dfontinfo->max_bounds.rbearing,
			    fontheight * line++ + dfontinfo->ascent,
			    &t, 1 );  
	
	
			/* LAST TIME INFO UPDATED */
			if (!ismine) {
				strcpy(buf,nl_cxtime(&(pi->pi_timestamp),"%m/%d %H:%M"));
				t.nchars = strlen(buf);
				XDrawText( dpy, infow, gc,  
					dfontinfo->max_bounds.rbearing,
			    	fontheight * line++ + dfontinfo->ascent,
			    	&t, 1 );  
			}
		}
	}

	XFlush( dpy );
}


void destroyInfo()
{
	XDestroyWindow( dpy, infow);
	infomapped = 0;
}
