/* getship.c 15.1 06/08/90 10:05:26 */

/* Original code by Daryl Poe.
 *
 * Copyright (c) 1989 Daryl Poe
 *
 * Ported to X11 by Jim Andreas.
 * Tractors, treaties, and other features by Norm Gee.
 * Damage window and shield bitmaps by Tom LaStrange.
 *
 * Permission to use, copy, modify, and distribute this
 * software and its documentation for any purpose and without
 * fee is hereby granted, provided that the above copyright
 * notice appear in all copies and that both that copyright
 * notice and this permission notice appear in supporting
 * documentation.  No representations are made about the
 * suitability of this software for any purpose.  It is
 * provided "as is" without express or implied warranty.
 */

#include <X11/X.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <stdio.h>
#include <signal.h>
#include <time.h>
#include <sys/time.h>
#include "defs.h"
#include "weapon.h"
#include "system.h"
#include "ship.h"
#include "stats.h"
#include "player.h"
#include "torp.h"
#include "status.h"
#include "planet.h"
#include "phaser.h"
#include "message.h"
#include "shmem.h"
#include "data.h"
#include "xdata.h"

static unsigned short mychild_pid;

static int toolong()
{
	/* shipmenu took too long */
	fprintf(stderr,"Timed out waiting for %s\n",Shipmenu);
	/* kill the child process */
	kill(mychild_pid,SIGTERM);
	me->p_status = PFREE;
	exit(1);
}


void getship(ship,hull_size,team_no,playername,shipname)
SHIP *ship;
int hull_size,team_no;
char *playername,*shipname;
{
	int pipefd[2];
	char arg1[80],arg2[80],arg3[80],arg4[80],arg5[80];
	SHIP thisship;

	logmsg1("getship: forking shipmenu process\n");
	sprintf(arg1,"-h %d",hull_size);
	sprintf(arg2,"-t %d",team_no);
	sprintf(arg3,"-p %s",playername);
	strcpy(arg5,arg1);
	if (strcmp(playername,"robot") == 0) {
		if ((strcmp(shipname,"") == 0)
				|| strcmp(shipname,"RANDOM") == 0) {
			sprintf(arg4,"-r");
			if ((team_no >= FEDERATION) && (team_no <= ORION)) {
				/* get biggest ship available */
				sprintf(arg5,"-m");
			}
		}
		else sprintf(arg4,"-s %s",shipname);
	}
	else sprintf(arg4,"-D%s",DisplayString(dpy));

	pipe(pipefd);
	if ((mychild_pid = fork()) == 0) {
		pipedetach(pipefd[1]);
		execl(Shipmenu,"dtrek_shipmenu",arg1,arg2,arg3,arg4,arg5,"-g",0);
		/* should never get here anyway */
		perror(Shipmenu);
		exit(0);
	}
	else {
		/* parent only */
		struct itimerval itime,oitime;
		int (*oldsig)();

		/* wait for it to finish */
		/* but don't wait more than ten minutes */
		/* turn off itimer */
		itime.it_value.tv_sec = 0;
		itime.it_value.tv_usec = 0;
		setitimer(ITIMER_REAL,&itime,&oitime);
		/* set new alarm signal handler */
		oldsig = mysignal(SIGALRM,toolong);
		alarm(600);
		wait((int *) 0);

		/* read the ship output by the SHIPMENU program */
		if (read(pipefd[0],&thisship,sizeof(SHIP))
				< sizeof(SHIP)) {
			fprintf(stderr,"Could not read ship.  Aborting.\n");
			exit(1);
		}
		logmsg1("getship: got ship\n");
		close(pipefd[0]);
		close(pipefd[1]);

		/* Check to make sure my slot hasn't been grabbed by
		 * someone else.
		 */
		if (me->p_status != POUTFIT) toolong();

		/* copy the ship over */
		memcpy((char *) ship,(char *) &thisship,sizeof(SHIP));
		compute_fields(ship);

		/* restore old timer stuff */
		mysignal(SIGALRM,oldsig);
		setitimer(ITIMER_REAL,&oitime,&itime);
	}
}

