/* enter.c 15.1 06/08/90 10:05:12 */

/*

	Copyright (c) 1986 	Chris Guthrie

Permission to use, copy, modify, and distribute this
software and its documentation for any purpose and without
fee is hereby granted, provided that the above copyright
notice appear in all copies and that both that copyright
notice and this permission notice appear in supporting
documentation.  No representations are made about the
suitability of this software for any purpose.  It is
provided "as is" without express or implied warranty.

*/

/* Major overhaul by Daryl Poe.
 *
 * Copyright (c) 1989 Daryl Poe
 *
 * Ported to X11 by Jim Andreas.
 * Tractors, treaties, and other features by Norm Gee.
 * Damage window and shield bitmaps by Tom LaStrange.
 *
 * The above comments apply to this version as well, and this
 * notice must also appear in any copies or follow-ons.
 */

#include <stdio.h>
#include <sys/types.h>
#include <sys/ipc.h>
#include <sys/shm.h>
#include <sys/sem.h>
#include <errno.h>
#include <pwd.h>
#include <string.h>
#include <ctype.h>
#include "defs.h"
#include "weapon.h"
#include "system.h"
#include "ship.h"
#include "stats.h"
#include "player.h"
#include "torp.h"
#include "status.h"
#include "planet.h"
#include "phaser.h"
#include "message.h"
#include "shmem.h"
#include "data.h"

#define YRANGE ((GWIDTH)/10)

void enter(tno, real_tno, disp, hull_size, pno,robot,shipname,
	select_entry_planet_routine)
int tno,real_tno;
char *disp;
int hull_size,pno;
int robot;
char *shipname;
PLANET *(*select_entry_planet_routine)();
{
	struct passwd *pwent, *getpwuid();
	char buf[80];
	PLANET *planet,*myhome,*myplanet;

	me->p_team_no   = real_tno;
	me->p_team_mask = 1 << real_tno;

	me->p_no      = pno;
	me->p_updates = 0;
	me->p_flags   = (PFSHIELD|PFGREEN);
	if (robot) {
		strncpy(me->p_login,"Robot",sizeof(me->p_login));
		strncpy(me->p_name,"Robot",sizeof(me->p_name));
	}
	else {
		if ((pwent = getpwuid(getuid())) == NULL)
			strncpy(me->p_login, "Bozo", sizeof (me->p_login));
		else strncpy(me->p_login, pwent->pw_name, sizeof (me->p_login));
		if (strlen(me->p_name) == 0)
		  strncpy(me->p_name, me->p_login, sizeof (me->p_name)); 
	}		
	strncpy(me->p_monitor, disp, sizeof (me->p_monitor));

	if (me->p_no <= 15) {
		sprintf(buf, "%c%x", teamlet[me->p_team_no], me->p_no);
		strncpy(me->p_mapchars, buf, 2);
		me->p_mapchars[2] = '\0';
	}
	else {
		me->p_mapchars[0] = teamlet[me->p_team_no];
		me->p_mapchars[1] = 'g' + (char) (me->p_no - 16);
		me->p_mapchars[2] = '\0';
	}

	me->p_dir            = 0;
	me->p_desdir         = 0;
	me->p_subspeed       = 0;

	me->p_subshield      = 0;
	me->p_ntorp          = 0;


	me->p_hostile_mask = team[me->p_team_no].t_treaty;
	me->p_treaty_mask  = team[me->p_team_no].t_treaty;
	me->p_ally_mask  = team[me->p_team_no].t_ally;

	me->p_hostile_mask   = ALL_MASK & ~( team[me->p_team_no].t_treaty |
					     team[me->p_team_no].t_ally);  

	me->p_kills          = 0.0;
	me->p_planet         = 0;
	me->p_playerl        = 0;
	me->p_armies         = 0;

	me->p_explode        = 0;
	me->p_etemp          = 0;
	me->p_engine_health  = 256;
	me->p_torps_unloaded = 0;
	me->p_beams_unloaded = 0;
	me->p_beams_reload   = 0;
	me->p_subreload      = 0;
	me->p_whydead        = 0;
	me->p_whodead        = 0;

	me->p_ghostbuster    = 0;
	me->p_wpnlock        = 0;
	me->p_pid            = getpid();

	if (robot) getship(myship,hull_size,tno,"robot",shipname);
	else getship(myship,hull_size,tno,me->p_login,NULL);

	if (myship->s_maxspeed > 10) {
		me->p_ecool = 8;
	}
	else if (myship->s_maxspeed > 8) {
		me->p_ecool = 7;
	}
	else if (myship->s_maxspeed == 8) {
		me->p_ecool = 6;
	}
	else if (myship->s_maxspeed == 7) {
		me->p_ecool = 5;
	}
	else {
		me->p_ecool = 4;
	}

	if (robot) {
		/* send robots in with a running start */
		if (myship->s_maxspeed >= 4) {
			me->p_speed =
				me->p_desspeed =
				4;
		}
		else {
			me->p_speed =
				me->p_desspeed =
				myship->s_maxspeed;
		}
	}
	else {
		me->p_speed =
			me->p_desspeed =
			0;
	}

	/* find home planet */
	myhome = myplanet = NULL;
	if (real_tno >= FEDERATION && real_tno <= ORION) {
		for (planet=planets; planet<planets+MAXPLANETS; ++planet) {
			if ((planet->pl_flags & PLMASK_HOME)
					&& (planet->pl_flags & me->p_team_mask)) {
				myhome = planet;
				if (planet->pl_owner_no == real_tno) {
					myplanet = planet;
					break;
				}
			}
			else if ((planet->pl_owner_no == real_tno)
					&& (!(planet->pl_flags &
						(PLMASK_BLACKHOLE
						 	| PLMASK_BARREN
						 	| PLMASK_PULSAR
						 	| PLMASK_NEBULA)))) {
				myplanet = planet;
			}
		}

		if ((myplanet == NULL) && (myhome != NULL)) {
			/* must enter near former home planet */
			myplanet = myhome;
		}
		else {
			/* choose which planet to enter near */
			myplanet = (*select_entry_planet_routine)(myplanet);
		}
	}

	if (myplanet == NULL) {
		/* enter along one of the galaxy boundries */
		switch (INTRAND(4)) {
			case 0:  /* top edge */
				me->p_x = GWIDTH/100 + INTRAND(GWIDTH*98/100);
				me->p_y = GWIDTH/100;
				break;
			case 1:  /* right edge */
				me->p_x = GWIDTH*99/100;
				me->p_y = GWIDTH/100 + INTRAND(GWIDTH*98/100);
				break;
			case 2: /* bottom edge */
				me->p_x = GWIDTH/100 + INTRAND(GWIDTH*98/100);
				me->p_y = GWIDTH*99/100;
				break;
			case 3:  /* left edge */
				me->p_x = GWIDTH/100;
				me->p_y = GWIDTH/100 + INTRAND(GWIDTH*98/100);
		}
		me->p_closest_planet =
			closest_planet_dist(me->p_x,me->p_y,
				&me->p_closest_planet_dist,0,0);
	}
	else {
		int dx,dy;

		dx = INTRAND((INTERPLANETARY_DIST/2)) - (INTERPLANETARY_DIST/4);
		dy = INTRAND((INTERPLANETARY_DIST/2)) - (INTERPLANETARY_DIST/4);

		me->p_x = myplanet->pl_x + dx;
		me->p_y = myplanet->pl_y + dy;
		me->p_closest_planet = myplanet->pl_no;
		me->p_closest_planet_dist = Ihypot(dx,dy);
	}

	if (me->p_x < (GWIDTH/3)) {
		me->novtent = 0;
		me->map_offsetx = 0;
	}
	else if (me->p_x < (GWIDTH*2/3)) {
		me->novtent = 1;
		me->map_offsetx = (GWIDTH/4);
	}
	else {
		me->novtent = 2;
		me->map_offsetx = (GWIDTH/2);
	}

	if (me->p_y < (GWIDTH/3)) {
		me->map_offsety = 0;
	}
	else if (me->p_y < (GWIDTH*2/3)) {
		me->novtent += 3;
		me->map_offsety = (GWIDTH/4);
	}
	else {
		me->novtent += 6;
		me->map_offsety = (GWIDTH/2);
	}

	me->p_ecm_dx  = 0;
	me->p_ecm_dy  = 0;
	me->p_app_x   = me->p_x;
	me->p_app_y   = me->p_y;

	me->p_shield[0] = myship->s_shield[0];
	me->p_shield[1] = myship->s_shield[1];
	me->p_shield[2] = myship->s_shield[2];
	me->p_shield[3] = myship->s_shield[3];
	me->p_fuel      = myship->s_maxfuel;

	if (myship->s_maxspeed == 0) {
		/* Ind or orbiting starbase/ship */
		if      (myship->s_hull < 150) me->p_bitmap_num = 0;
		else if (myship->s_hull < 225) me->p_bitmap_num = 1;
		else                           me->p_bitmap_num = 2;
	}
	else switch (tno) {
		case FEDERATION:
		case ROMULAN:
		case KLINGON:
		case ORION:
			if      (myship->s_hull < 150) me->p_bitmap_num = 0;
			else if (myship->s_hull < 165) me->p_bitmap_num = 1;
			else if (myship->s_hull < 180) me->p_bitmap_num = 2;
			else                           me->p_bitmap_num = 3;
			break;
		case JUGGERNAUT:
		case INDEPENDENT:
			if      (myship->s_hull < 130) me->p_bitmap_num = 0;
			else if (myship->s_hull < 175) me->p_bitmap_num = 1;
			else if (myship->s_hull < 200) me->p_bitmap_num = 2;
			else if (myship->s_hull < 225) me->p_bitmap_num = 3;
			else if (myship->s_hull < 250) me->p_bitmap_num = 4;
			else                           me->p_bitmap_num = 5;
			break;
	}
	me->p_stats_dirty  = FALSE;
	me->p_damage_dirty = FALSE;
	me->p_buddy        = -1;

	switch (tno) {
		case FEDERATION:
		case ORION:
			me->p_yrange = WPN_PHOTON_MAX_SPEED * WARP1
				* WPN_PHOTON_MAX_DURATION/2 * (1000000/UPDATE);
			break;
		case KLINGON:
			me->p_yrange = WPN_MISSILE_MAX_SPEED * WARP1
				* WPN_MISSILE_MAX_DURATION * (1000000/UPDATE);
			break;
		case ROMULAN:
			me->p_yrange = WPN_PLASMA_MAX_SPEED * WARP1
				* WPN_PLASMA_DURATION * (1000000/UPDATE);
			break;
		default:
			me->p_yrange = YRANGE;
			break;
	}
	if (me->p_yrange < YRANGE) me->p_yrange = YRANGE;

	if (!robot) ++mystats->st_entries;
	delay = 0;
}


void openmem(startdaemon_if_necessary)
int startdaemon_if_necessary;
{
	key_t shmemKey = PKEY;
	int	shmid,started_daemon;
	long stoptime;
	char gamename[256];
	char nextgame[512];

	started_daemon = FALSE;
	errno = 0;
	shmid = shmget(shmemKey, 0, 0);
	stoptime = -1;
	if (shmid < 0) {
		if ((errno != ENOENT) || !startdaemon_if_necessary) {
			perror("shmget");
			exit(1);
		}
		game_control(&stoptime,gamename,nextgame);
		startdaemon();
		sleep(4);
		shmid = shmget(shmemKey, 0, 0);
		if (shmid < 0) {
			fprintf(stderr, "Daemon not running\n");
			exit (1);
		}
		started_daemon = TRUE;
	}
	sharedMemory = (MEMORY *) shmat(shmid, 0, 0);
	if (sharedMemory == (MEMORY *) -1) {
		perror("shared memory");
		exit (1);
	}
	if (stoptime >= 0) {
		/* must have called game_control() */
		sharedMemory->game_end_time = stoptime;
		strcpy(sharedMemory->gamename,gamename);
		strcpy(sharedMemory->nextgame,nextgame);
	}

	players  = sharedMemory->players;
	torps    = sharedMemory->torps;
	status   = sharedMemory->status;
	planets  = sharedMemory->planets;
	phasers  = sharedMemory->phasers;
	mctl     = sharedMemory->mctl;
	messages = sharedMemory->messages;
	team 	 = sharedMemory->team;
	watchers = sharedMemory->watchers;

	if ((semid = semget(shmemKey,1,0666)) == -1) {
		/* semaphore not already there */
		if ((semid = semget(shmemKey,1,IPC_CREAT|0666)) == -1) {
			fprintf(stderr,"Cannot create semaphore.\n");
			exit(1);
		}
		/* clear it */
		if (semctl(semid,0,SETVAL,1) == -1) {
			fprintf(stderr,"Cannot clear new semaphore.\n");
			exit(1);
		}
	}
			
	if (started_daemon) {
		/* default mode */
		sharedMemory->mode = 
			STARBASE_MODE_MASK|DEFENSIVE_BEAM_MASK|SMART_WEAP_MASK;
		read_dtrek_mode_file();
		sharedMemory->mode &= ~sharedMemory->mode_fixed_off;
		sharedMemory->mode |=  sharedMemory->mode_fixed_on;
		team[INDEPENDENT].t_starbase_died = 
			team[FEDERATION].t_starbase_died = 
			team[ROMULAN].t_starbase_died = 
			team[KLINGON].t_starbase_died = 
			team[ORION].t_starbase_died = 
			FALSE;

		if (fork() == 0) {
			detach();
			setresuid(geteuid(),-1,-1);
			start_starbases();
			_exit(1);
		}
	}
}


int findslot()
{
	register int i;
	STATS *s;

	sem_lock();
	for (i = 0; i < MAXPLAYER; i++) {
		if (players[i].p_status == PFREE) {	/* We have a free slot */
			players[i].p_status = POUTFIT;
			break;
		}
	}
	if (i == MAXPLAYER) {
		sem_unlock();
		fprintf(stderr, "No more room in game\n");
		exit (0);
	}
	sem_unlock();

	/* clear stats */
	s = &players[i].p_stats;
	s->st_uid      = (int) getuid();
	s->st_time     = 0;
	s->st_cpu      = 0;
	s->st_kills    = 0.0;
	s->st_losses   = 0;
	s->st_maxkills = 0.0;
	s->st_entries  = 0;
	s->st_conqs    = 0;
	s->st_planets  = 0;

	return(i);
}


/* Return the hull size appropriate for the number of planets
 * owned by this team.
 */
int compute_hull_size(team_no)
int team_no;
{
	int count,shipsize;
	PLANET *planet;

	count = 0;
	for (planet = planets; planet < planets+MAXPLANETS; ++planet)
		if (planet->pl_owner_no == team_no) ++count;
	if (count > 13) shipsize = 105 + ((count+2)/4) * 15;
	else if (count < 6) shipsize = 135;
	else shipsize = 150;

	logmsg2("found %d planets matching team.\n",count);
	return(shipsize);
}		
