/* dmessage.c 15.1 06/08/90 10:05:01 */

/*

	Copyright (c) 1986 	Chris Guthrie

Permission to use, copy, modify, and distribute this
software and its documentation for any purpose and without
fee is hereby granted, provided that the above copyright
notice appear in all copies and that both that copyright
notice and this permission notice appear in supporting
documentation.  No representations are made about the
suitability of this software for any purpose.  It is
provided "as is" without express or implied warranty.

*/

/* Major overhaul by Daryl Poe.
 *
 * Copyright (c) 1989 Daryl Poe
 *
 * Ported to X11 by Jim Andreas.
 * Tractors, treaties, and other features by Norm Gee.
 * Damage window and shield bitmaps by Tom LaStrange.
 *
 * The above comments apply to this version as well, and this
 * notice must also appear in any copies or follow-ons.
 */

#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <stdio.h>
#include "defs.h"
#include "weapon.h"
#include "system.h"
#include "ship.h"
#include "stats.h"
#include "player.h"
#include "torp.h"
#include "status.h"
#include "planet.h"
#include "phaser.h"
#include "message.h"
#include "shmem.h"
#include "data.h"
#include "xdata.h"


void redraw_messagew()
{
	MESSAGE *cur;
	char buf[MSG_DATALEN+11];
	XTextItem t;
	XGCValues values;
	int fheight, bline, line, mno;

	XClearWindow(dpy,messagew);

	buf[MSG_DATALEN+10] = '\0';
	fheight = dfontinfo->ascent + dfontinfo->descent;
	line = (MESSAGES-1);
	bline = line * (fheight + 2);
	mno = mctl->mc_current;

	t.chars = buf;
	t.delta = 0;
	t.font  = dfont;

	do {
		cur = &messages[mno];
		if (cur->m_msgflags & MVALID) {
			if ((cur->m_msgflags & MALL)
			    	|| ((cur->m_msgflags & MTEAM)
							&& (cur->m_recpt & me->p_team_mask))
					|| ((cur->m_msgflags & MINDIV)
						&& (cur->m_recpt == me->p_no))) {
				strncpy(buf,cur->m_data,MSG_DATALEN);
				lastcount = strlen(buf);
				if (lastcount > MSG_DATALEN)
					lastcount = MSG_DATALEN;

				if (cur->m_msgflags & MALL) {
					XSetForeground(dpy, gc, textColor);
				}
				else if (cur->m_msgflags & MTEAM) {
					XSetForeground(dpy, gc, yColor);
				}
				else {
					XSetForeground(dpy, gc, rColor);
				}

				t.nchars = lastcount;
				XDrawText(dpy, messagew, gc,
					5, bline + dfontinfo->ascent + 1, 
					&t, 1 );
				
				--line;
				bline -= (fheight+2);
			}
		}
		--mno;
	} while ((line >= 0) && (mno >= 0));

	XFlush( dpy );
}


void dmessage()
{
	MESSAGE *cur;
	char buf[MSG_DATALEN+11];
	XTextItem t;
	XGCValues values;
	int fheight, bline;

	buf[MSG_DATALEN+10] = '\0';

	if (mctl->mc_current == lastm)
		return;

	fheight = dfontinfo->ascent + dfontinfo->descent;
	bline = (MESSAGES-1) * (fheight + 2);

	do
	{
		if (++lastm >= MAXMESSAGE)
			lastm = 0;
		cur = &messages[lastm];
		if (cur->m_msgflags & MVALID) {
			if ((cur->m_msgflags & MALL) ||
			    ((cur->m_msgflags & MTEAM) && (cur->m_recpt & me->p_team_mask)) ||
			    ((cur->m_msgflags & MINDIV) && (cur->m_recpt == me->p_no)))
			{
				XCopyArea(dpy, messagew, messagew, gc,
					0, fheight+2,
					WINSIDE, bline,
					0, 0);

				XClearArea(dpy, messagew, 0, bline,
					WINSIDE, fheight + 2, False);

				logmsg2("received msg: %s@\n",cur->m_data);
				strncpy(buf,cur->m_data,MSG_DATALEN);
				lastcount = strlen(buf);
				if (lastcount > MSG_DATALEN)
					lastcount = MSG_DATALEN;

				if (cur->m_msgflags & MALL) {
					XSetForeground(dpy, gc, textColor);
				}
				else if (cur->m_msgflags & MTEAM) {
					XSetForeground(dpy, gc, yColor);
				}
				else {
					XSetForeground(dpy, gc, rColor);
				}

				t.chars = buf;
				t.nchars = lastcount;
				t.delta = 0;
				t.font  = dfont;
				XDrawText(dpy, messagew, gc,
					5, bline + dfontinfo->ascent + 1, 
					&t, 1 );

				XBell( dpy, 100 );
				XFlush( dpy );
				return;
			}
		}
	} while (lastm != mctl->mc_current);
}
