/* defs.h 15.1 06/08/90 10:04:57 */

/*

	Copyright (c) 1986 	Chris Guthrie

Permission to use, copy, modify, and distribute this
software and its documentation for any purpose and without
fee is hereby granted, provided that the above copyright
notice appear in all copies and that both that copyright
notice and this permission notice appear in supporting
documentation.  No representations are made about the
suitability of this software for any purpose.  It is
provided "as is" without express or implied warranty.

*/

/* Major overhaul by Daryl Poe.
 *
 * Copyright (c) 1989 Daryl Poe
 *
 * Ported to X11 by Jim Andreas.
 * Tractors, treaties, and other features by Norm Gee.
 * Damage window and shield bitmaps by Tom LaStrange.
 *
 * The above comments apply to this version as well, and this
 * notice must also appear in any copies or follow-ons.
 */

#define PKEY 		259 	/* Xtrek v10 is 257 */

/* These are configuration definitions */

#define GWIDTH 		200000	/* galaxy is 200000 spaces on a side */
#define WARP1 		25		/* spaces per update at warp one */
#define SCALE 		40		/* Window will be one pixel for 20 spaces */
#define EXPDIST 	400		/* At this range a torp will explode */
#define DETDIST 	800		/* Torp does some damage to this range */
#define ENTORBDIST	900		/* range a player can orbit a planet */
#define ORBDIST 	800		/* A player will orbit at this radius */
#define ORBSPEED 	2		/* fastest a person can go into orbit */
#define PFIREDIST 	1500	/* range planet will shoot at a player */
#define UPDATE 		100000	/* Update time is 100000 micro-seconds */
#define AUTOQUIT 	60		/* auto logout in 60 secs */
#define WINSIDE 	500		/* size of main windows */
#define MAPWIDTH	(GWIDTH/2)	/* strategic window width */
#define NEBULA_VISIBILITY 	1/3	/* visibility range inside a nebula */

/* this could be better */
#define INTRAND(k)	 (((k)<=0) ? 1 : ((int) (lrand48() % (k))))
#define SAMESTR(str1,str2) (strcmp(str1,str2) == 0)

#define FALSE	0
#define TRUE	1

#define MAXWATCHERS	16
#define MAXPLAYER 	32
#define MAXPLANETS 	80
#define MAXTORP 	24
#define MAXBEAM		4
#define MAXSPEED	12
#define MAXMESSAGE 	50
#define EXPDIST 	400		/* At this range a torp will explode */
#define MAX_INT		0x07fffffff
#define VIEWS		16		/* views of the ship */
#define MESSAGES	8		/* number of messages to view */

#define INDEPENDENT	0
#define FEDERATION	1
#define ROMULAN		2
#define KLINGON		3
#define ORION		4
#define MAXTEAM		ORION
#define NUMTEAM		(ORION+1)
#define JUGGERNAUT	5
#define MONITOR		6
#define PLANETKILLER 7

#define IND_MASK	0x01
#define FED_MASK	0x02
#define ROM_MASK	0x04
#define KLI_MASK	0x08
#define ORI_MASK	0x10
#define ALL_MASK	(IND_MASK|FED_MASK|ROM_MASK|KLI_MASK|ORI_MASK)

/* shield indices */
#define FRONT_SHIELD	0
#define RIGHT_SHIELD	1
#define REAR_SHIELD		2
#define LEFT_SHIELD		3

/* mode masks for p_mode and mode field in shmem */
#define ROBOT_INVASION_MASK	0x00000001
#define DEFENSE_BASE_MASK	0x00000002
#define STARBASE_MODE_MASK	0x00000004
#define DEFENSIVE_BEAM_MASK	0x00000008
#define ROBOT_SWARM_MASK	0x00000010
#define WORMHOLE_MASK		0x00000020
#define SMART_WEAP_MASK		0x00000040
#define PROB_VORTEX_MASK	0x00000080
#define MONITOR_MASK		0x00000100
#define PLANETKILLER_MASK	0x00000200

typedef unsigned char COURSE;

#define rosette(x)	((((x) + 256/VIEWS/2) / (256/VIEWS)) % VIEWS)

#define shield_width 20
#define shield_height 20

/*
** These are random configuration variables
*/
#define VICTORY 40	/* Number of planets needed to conquer the galaxy */
#define WARNTIME 50	/* Number of updates to have a warning on the screen */
#define MESSTIME 5	/* Number of updates to have a message on the screen */

/* Flags for gettarget, searches */
#define TARG_PLAYER			0x0001
#define TARG_PLANET			0x0002
#define TARG_CLOAK			0x0004	/* Include cloaked ships */
#define TARG_FRIENDLY		0x0008	/* friendlies only please */
#define TARG_UNFRIENDLY		0x0010	/* unfriendlies only please */
#define TARG_TRYDATA_FIRST	0x0020	/* check planet/player given first*/
#define TARG_VISIBLE		0x0040	/* target visible to player */
#define TARG_IMMUNE_OK      0x0080  /* immune players too */
#define TARG_MEOWNER		0x0100	/* planet owned by my team */
#define TARG_PLFLAGS_AND	0x0200	/* planet->pl_flags & data TRUE */
#define TARG_NOTASTEROID	0x0400	/* no asteroids in search */

#define SCORES_MAGIC_NUMBER	(7661<<16)

/* Convenient macros */

#define ABS(a) \
	(((a) < 0) ? -(a) : (a))

#define angdist(a,b) \
	((COURSE) ((COURSE)(a)) - ((COURSE)(b)))

#define myTorp(t) \
	(me->p_no == (t)->t_owner_no)

#define friendlyTorp(t) \
	((!(me->p_team_mask & (t)->t_war_mask)) || (myTorp(t)))

#define myPhaser(p) \
	(me->p_no == (p)->ph_owner_no)

#define myPlayer(p) \
	(me == (p))

#define myPlanet(p) \
	(me->p_team_no == (p)->pl_owner_no)

#define friendlyPlayer(p) \
	((!(me->p_team_mask & ( (p)->p_hostile_mask))) \
	&& \
    (!((p)->p_team_mask & ( me->p_hostile_mask))))

#define torpColor(t) \
	(myTorp(t) ? \
	myColor : shipCol[players[(t)->t_owner_no].p_team_no])

#define phaserColor(p) \
	(myPhaser(p) ? \
	myColor : shipCol[players[(p)->ph_owner_no].p_team_no])

#define playerColor(p) \
	(myPlayer(p) ? myColor : shipCol[(p)->p_team_no])

#define planetColor(p) \
	shipCol[(p)->pl_info[me->p_team_no].pi_owner_no]

#define planetFont(p) \
	(myPlanet(p) ? bfont : dfont)

#define shipFont(p)	\
	(myPlayer(p) ? bfont : friendlyPlayer(p) ? ifont : dfont)

#define shieldIndex(p,s) \
	(((p)->p_shield[s] == 0) ? \
		0 : \
		(((p)->p_shield[s] > (p)->p_ship.s_shield[s]*2/3) ? \
			3 : \
			3 * (p)->p_shield[s] / (p)->p_ship.s_shield[s] + 1))

/*  LOGGING MESSAGE MACROS */
#ifdef DEBUG
#define logmsg1(arg1)  fprintf(logfile,arg1); 
#define logmsg2(arg1,arg2)  fprintf(logfile,arg1,arg2); 
#define logmsg3(arg1,arg2,arg3)  fprintf(logfile,arg1,arg2,arg3); 
#define logmsg4(arg1,arg2,arg3,arg4)  \
	fprintf(logfile,arg1,arg2,arg3,arg4); 
#define logmsg5(arg1,arg2,arg3,arg4,arg5) \
	fprintf(logfile,arg1,arg2,arg3,arg4,arg5);
#define OPEN_LOGFILE(filename) \
	{ \
		int _i; \
 				\
		logfile = fopen(filename,"a"); \
		fprintf(logfile,"\nBEGINNING LOGGING FOR PID %d\n",getpid()); \
		fprintf(logfile,"argv[0]: %s, argc: %d\n",argv[0],argc); \
		for (_i=1;_i<argc;++_i) \
			fprintf(logfile,"argv[%d]: %s\n",_i,argv[_i]); \
		fprintf(logfile,"\n\n"); \
		fflush(logfile); \
	}
#define logflush()	fflush(logfile)
#else
#define logmsg1(arg1)
#define logmsg2(arg1,arg2)
#define logmsg3(arg1,arg2,arg3)
#define logmsg4(arg1,arg2,arg3,arg4)
#define logmsg5(arg1,arg2,arg3,arg4,arg5)
#define OPEN_LOGFILE(filename) \
	logfile = fopen("/dev/null","w");
#define logflush()
#endif

/* also check xdata.h for more externs */

/* from colors.c */
extern void getColorDefs();
extern int booleanDefault();

/* from coup.c */
extern void coup();

/* from daemon.c */
extern void killmess();

/* from damage.c */
extern void do_damage();

/* from damw.c */
extern void openDamage(),closeDamage(),redrawDamage(),updateDamage();

/* from death.c */
extern void death();

/* from dmessage.c */
extern void dmessage();
extern void redraw_messagew();

/* from enter.c */
extern void enter(),openmem();
extern int findslot(),compute_hull_size();

/* from gcontrol.c */
extern void game_control();

/* from general.c */
extern void seedrandom();
extern void getrusage();
extern int (*mysignal())();
extern void detach(),pipedetach();
extern void construct_filenames();
extern void sem_lock(),sem_unlock();
extern int ar_table_of_contents_size(),ar_check_entry();
extern int ar_read_entry(),ar_write_entry();
extern void compute_fields();
extern void normalize_string();
extern int is_substr();
extern int myfgets();

/* from getship.c */
extern void getship();

/* from inform.c */
extern void inform(),destroyInfo();

/* from input.c */
extern void initinput(),input(),unmap_special_windows();

/* from interface.c */
extern void set_speed(),set_course(),shield_up(),shield_down();
extern void shield_tog(),repair(),repeat_message();
extern void toggle_cloak();
extern int bomb_planet(),beam_up(),beam_down();

/* from keymap.c */
extern void init_keymap(),keyalias();

/* from mode.c */
extern void modewindow(),modeaction(),check_mode_status();

/* from newwin.c */
extern void newwin(),mapAll(),fillhelp(),drawIcon(),xdetach();
extern int which_team();

/* from orbit.c */
extern void orbit(),begin_exit_countdown();

/* from phaser.c */
extern int fire_beam(),fire_tractor();

/* from planetlist.c */
extern void planetlist();

/* from planets.c */
extern void read_planet_file();

/* from playerlist.c */
extern void playerlist();

/* from pmessage.c */
extern void pmessage();

/* from pstats.c */
extern void savestats(),printscores(),create_scorewindow();

/* from redraw.c */
extern void intrupt(),redraw(),map(),redrawTstats();

/* from repair.c */
extern void repair_player();

/* from rmove.c */
extern void rmove();

/* from search.c */
extern int closest_planet_dist(),closest_player_dist();
extern int is_vector_close_to_point(),is_planet_in_way(),shield_hit();

/* from sintab.c */
extern double Sin[], Cos[];
extern COURSE Atan2();
extern unsigned int two_to[];
extern short log_two[];
extern int Isqrt(),Ihypot();
extern float min_quadratic_solution();

/* from smessage.c */
extern void smessage();

 /* from startdmn.c */
extern void start_robot();
extern void startdaemon();
extern void start_starbases(),kill_starbases();
extern void start_defense_bases(),kill_defense_bases();

/* from stats.c */
extern void initStats(),redrawStats(),closeStats(),updateStats();
extern void box();

/* from torp.c */
extern int fire_torp();

/* from util.c */
extern void getxy(),gettarget();
extern int ismapped();

/* from war.c */
extern int send_war_warning();
extern void check_treaty_status(),update_treaties();

/* from warning.c */
extern void warning();

/* from warwin.c */
extern void warwindow(),warrefresh();

/* from the outside world */
extern char *getenv();
extern char *malloc();
#ifdef HPUX7
extern void *memcpy();
extern void *memset();
#else
extern char *memcpy();
extern char *memset();
#endif
extern char *nl_cxtime();
extern char *optarg;
/* extern char *shmat(); */
extern char *strcat();
extern char *strcpy();
extern char *strncpy();
extern int errno;
extern int getopt();
extern int optind;
extern long lrand48();
extern long lseek();
extern long sigsetmask();
extern long time();
extern unsigned long alarm();
extern unsigned long sleep();
extern unsigned short getegid();
extern unsigned short geteuid();
extern unsigned short getgid();
extern unsigned short getuid();
extern void exit(),_exit();
extern void free();
extern void perror();
extern void qsort();
extern void seekdir();
extern void srand();
extern void srand48();

