/* death.c 15.1 06/08/90 10:04:54 */

/*

	Copyright (c) 1986 	Chris Guthrie

Permission to use, copy, modify, and distribute this
software and its documentation for any purpose and without
fee is hereby granted, provided that the above copyright
notice appear in all copies and that both that copyright
notice and this permission notice appear in supporting
documentation.  No representations are made about the
suitability of this software for any purpose.  It is
provided "as is" without express or implied warranty.

*/

/* Major overhaul by Daryl Poe.
 *
 * Copyright (c) 1989 Daryl Poe
 *
 * Ported to X11 by Jim Andreas.
 * Tractors, treaties, and other features by Norm Gee.
 * Damage window and shield bitmaps by Tom LaStrange.
 *
 * The above comments apply to this version as well, and this
 * notice must also appear in any copies or follow-ons.
 */

#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <stdio.h>
#include <signal.h>
#include <sys/types.h>
#include <time.h>
#include <setjmp.h>
#include "defs.h"
#include "weapon.h"
#include "system.h"
#include "ship.h"
#include "stats.h"
#include "player.h"
#include "torp.h"
#include "status.h"
#include "planet.h"
#include "phaser.h"
#include "message.h"
#include "shmem.h"
#include "data.h"
#include "xdata.h"

extern jmp_buf env;

static struct itimerval udt;

void death()
{
	char buf[80];
	XSetWindowAttributes attr;
	SYSTEM_UNIT *killerhull;

	XSetForeground(dpy, gc, textColor);
	XSetBackground(dpy, gc, backColor);
	XSetFont(dpy, gc, dfont);

	mysignal(SIGALRM, SIG_IGN);
	udt.it_interval.tv_sec = 0;
	udt.it_interval.tv_usec = 0;
	udt.it_value.tv_sec = 0;
	udt.it_value.tv_usec = 0;
	setitimer(ITIMER_REAL, &udt, (struct itimerval *) NULL);
	mysignal(SIGALRM, SIG_DFL);

	me->p_status = POUTFIT;		/* Stop the ghost buster */

	XClearWindow( dpy, mainw);

	attr.border_pixel = gColor;
	XChangeWindowAttributes( dpy, mainw, CWBorderPixel, &attr );

	closeDamage();
	if (showStats)
		closeStats(statwin);
	if (infomapped)
		destroyInfo();
	if (ismapped(playerw))
		XUnmapWindow( dpy, playerw);
	if (ismapped(planetw))
		XUnmapWindow( dpy, planetw);
	if (ismapped(war))
		XUnmapWindow( dpy, war);

	logmsg4("death: why? %d, who? %d, mymask: %x\n",
		me->p_whydead,me->p_whodead,me->p_team_mask);

	switch (me->p_whydead) {
	case KQUIT:
		sprintf(buf, "You have self-destructed");
		mustexit = 1;
		break;
	case KTORP:
		killerhull = &players[me->p_whodead].p_ship.s_system[1];
		if (killerhull->undamaged_size) {
			sprintf(buf, "%s %s (%s) who was %d%% damaged",
				"You were killed by a torp from",
			    players[me->p_whodead].p_name,
			    players[me->p_whodead].p_mapchars,
	  		    100 - 100 * killerhull->current_size /
				killerhull->undamaged_size);
		}
		else {
			sprintf(buf, "%s %s (%s)",
				"You were killed by a torp from",
			    players[me->p_whodead].p_name,
			    players[me->p_whodead].p_mapchars);
		}
		break;
	case KPHASER:
		killerhull = &players[me->p_whodead].p_ship.s_system[1];
		if (killerhull->undamaged_size) {
			sprintf(buf, "%s %s (%s) who was %d%% damaged",
				"You were killed by a phaser shot from",
			    players[me->p_whodead].p_name,
			    players[me->p_whodead].p_mapchars,
	  		    100 - 100 * killerhull->current_size /
				killerhull->undamaged_size);
		}
		else {
			sprintf(buf, "%s %s (%s)",
				"You were killed by a phaser shot from",
			    players[me->p_whodead].p_name,
			    players[me->p_whodead].p_mapchars);
		}
		break;
	case KPLANET:
		if (planets[me->p_whodead].pl_flags & PLMASK_BLACKHOLE) {
			sprintf(buf, "You were sucked into a black hole");
		}
		else if (planets[me->p_whodead].pl_flags & PLMASK_AST_FIELD) {
			sprintf(buf, "You rammed an asteroid");
		}
		else if (planets[me->p_whodead].pl_flags & PLMASK_PULSAR) {
			sprintf(buf, "You were killed by pulsar radiation");
		}
		else {
			sprintf(buf, "You were killed by planetary fire from %s (%c)",
		    	planets[me->p_whodead].pl_name,
		    	teamlet[planets[me->p_whodead].pl_owner_no]);
		}
		break;
	case KSHIP:
		sprintf(buf, "%s %s (%s)",
			"You were killed by an exploding ship formerly owned by",
		    players[me->p_whodead].p_name,
		  	players[me->p_whodead].p_mapchars);
		break;
	case KDAEMON:
		sprintf(buf, "You were killed by a dying daemon");
		mustexit = 1;
		break;
	case KOVER:
		sprintf(buf, "%s over. %s",
			sharedMemory->gamename,sharedMemory->nextgame);
		mustexit = 1;
		break;
	case KWINNER:
		sprintf(buf, "Galaxy has been conquered by %s (%s)",
		    players[me->p_whodead].p_name,
			players[me->p_whodead].p_mapchars);
		mustexit = 1;
		break;
	case KGHOST:
		sprintf(buf, "You were killed by a confused daemon");
		mustexit = 1;
		break;
	case KVORTEX:
		sprintf(buf, "You were killed by an exploding Probability Vortex");
		break;
	default:
		sprintf(buf, "You were killed by something unknown to this game?");
		mustexit = 1;
		break;
	}
	check_treaty_status(me->p_team_no);
	update_treaties();
	check_mode_status();
	XDrawImageString(dpy, mainw, gc, 40, 250, buf, strlen(buf));
	logmsg2("death: message=%s\n",buf);
	if (oldmax < me->p_kills) oldmax = me->p_kills;
	mystats->st_kills += me->p_kills;
	me->p_tractors_on = 0;
	/* the exit routine in 'entryWindow' handles reentry now */
	XSync( dpy, 1);
	longjmp(env, 0);
}
