/* damw.c 15.1 06/08/90 10:04:45 */

/* Original code by Tom LaStrange.
 *
 * Copyright (c) 1989 Daryl Poe
 *
 * Tractors, treaties, and other features by Norm Gee.
 * Damage window and shield bitmaps by Tom LaStrange.
 *
 * Permission to use, copy, modify, and distribute this
 * software and its documentation for any purpose and without
 * fee is hereby granted, provided that the above copyright
 * notice appear in all copies and that both that copyright
 * notice and this permission notice appear in supporting
 * documentation.  No representations are made about the
 * suitability of this software for any purpose.  It is
 * provided "as is" without express or implied warranty.
 */

#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <stdio.h>
#include "defs.h"
#include "weapon.h"
#include "system.h"
#include "ship.h"
#include "stats.h"
#include "player.h"
#include "torp.h"
#include "status.h"
#include "planet.h"
#include "phaser.h"
#include "message.h"
#include "shmem.h"
#include "data.h"
#include "xdata.h"

#define LABELLEN 22
#define S_IBORDER 5
#define BOX_WIDTH 100

#define CH_WIDTH (dfontinfo->max_bounds.rbearing - \
		  dfontinfo->min_bounds.lbearing)
#define CH_HEIGHT (dfontinfo->max_bounds.ascent + \
		   dfontinfo->max_bounds.descent)

#define LABWIDTH (LABELLEN * CH_WIDTH)
#define ITEMS_PER_COLUMN ((myship->s_numsys + damColumns - 1) / damColumns)

#define DAM_WIDTH (damColumns * (LABWIDTH + BOX_WIDTH + (3 * S_IBORDER)))
#define DAM_HEIGHT (((CH_HEIGHT + S_IBORDER) * ITEMS_PER_COLUMN) + S_IBORDER)

#define DAM_X 10
#define DAM_Y 720
#define DAM_COLUMNS 2

#define	BX_OFF(line) \
    ((line / ITEMS_PER_COLUMN) * (LABWIDTH + BOX_WIDTH + (2*S_IBORDER)) + \
     ((LABELLEN + 1) * CH_WIDTH + S_IBORDER))
#define	BY_OFF(line) \
	((line % ITEMS_PER_COLUMN) * (CH_HEIGHT + S_IBORDER) + S_IBORDER)
#define	TX_OFF(line, len) \
    ((line / ITEMS_PER_COLUMN) * (LABWIDTH + (2*S_IBORDER) + BOX_WIDTH) + \
     ((LABELLEN - len) * CH_WIDTH + S_IBORDER))
#define	TY_OFF(line) (BY_OFF(line) + dfontinfo->max_bounds.ascent)


typedef struct {
    char label[LABELLEN];   /* label */
    int len;                /* label length */
    int *current;           /* current value */
    int last;
    int *undamaged;
    int textX, textY;
    int boxX, boxY;
} DISPLAYLINE;

static DISPLAYLINE *dline = NULL;
static int damX = DAM_X;
static int damY = DAM_Y;
static int damColumns = DAM_COLUMNS;

static char *syslabel[NUM_ADJ_SYS] = {
	"Insert Torpedo type string here",
	"",
	"",
	"",
	"",
	"Insert Phaser type string here",
	"",
	"",
	"",
	"",
	"Tractor",
	"Engines",
	"",
	"",
	"",
	"",
	"",
	"Dilithium",
	"Damage Control",
	"Cargo",
	"",
	"Armor",
	"Hull",
	"Fuel Tanks",
	"",
	"",
	"",
	"Cloaking Device",
	"Improved Sensors",
	"ECM Module",
	"Hyperspace Engines",
	"Black Sphere",
	"Adv. Fire Control",
	"Damage Absorbers"
};


static void initDamage(prog)
char *prog;
{
    int i,item, dummy,numsys;
    char *str;

	if ((me->p_status == PALIVE)
			|| (me->p_status == PIMMUNE)
			|| (me->p_status == POUTFIT)) {
		numsys = myship->s_numsys;
	}
	else numsys = 0;

    if (dline != NULL) {
		free(dline);
		dline = NULL;
    }

    strcpy(syslabel[TORP_NUM],myship->s_torpname);
    strcpy(syslabel[BEAM_NUM],myship->s_beamname);

    if ((str = XGetDefault(dpy, prog, "damage.geometry")) != NULL)
		XParseGeometry(str, &damX, &damY, &dummy, &dummy);

    if ((str = XGetDefault(dpy, prog, "damage.columns")) != NULL)
		sscanf(str, "%d", &damColumns);

    if ((dline = (DISPLAYLINE *) malloc(numsys*sizeof(DISPLAYLINE)))
			== NULL) {
		fprintf(stderr,
			"Error: could not malloc space for damage display.\n");
		logmsg1("damw: couldn't malloc space.\n");
		return;
    }
    
    for (i=0; i<numsys; ++i) {
		item = myship->s_system[i].item;
		switch (item) {
	  		case TORP_NUM:
	  		case BEAM_NUM:
	  		case TRACTOR_BEAM:
	    		/* These items have subitems */
	    		sprintf(dline[i].label,"%s %d",syslabel[item],
		    		myship->s_system[i].subitem+1);
	    		break;
	  		default:
	    		strcpy(dline[i].label,syslabel[item]);
	    		break;
		}

		dline[i].len = strlen(dline[i].label);
		dline[i].current = &(myship->s_system[i].current_size);
		dline[i].last = -1;
		dline[i].undamaged = &(myship->s_system[i].undamaged_size);
		dline[i].textX = TX_OFF(i, dline[i].len);
		dline[i].textY = TY_OFF(i);
		dline[i].boxX = BX_OFF(i);
		dline[i].boxY = BY_OFF(i);
   	}
}

void openDamage(prog)
char *prog;
{
    XSizeHints          sizehints;
    
    initDamage(prog);
    
    sizehints.flags = USPosition | USSize;
    sizehints.width = DAM_WIDTH;
    sizehints.height = DAM_HEIGHT;
    sizehints.x = damX;
    sizehints.y = damY;
    
    damwin = XCreateSimpleWindow(dpy,
			    RootWindow(dpy,DefaultScreen(dpy)),
			    damX,
			    damY,
			    DAM_WIDTH,
			    DAM_HEIGHT,
			    2, gColor, backColor );
    XSetStandardProperties(dpy, damwin,"damage","damage",
			   None, 0, 0, &sizehints);
	set_class(damwin, "DTrek", "damage");
    
    XSelectInput(dpy, damwin, ExposureMask );
    XMapWindow(dpy, damwin);
}

void closeDamage()
{
    XDestroyWindow(dpy, damwin);
}

void redrawDamage()
{
    int	i;
    XTextItem t;

	if ((me->p_status != PALIVE)
			&& (me->p_status != PIMMUNE)) {
		return;
	}

    XClearWindow(dpy, damwin);
    for (i = 0; i < myship->s_numsys; i++)
    {
	if (dline[i].len == 0)
	    continue;
	
	dline[i].last = -1;
	t.chars = dline[i].label;
	t.nchars = dline[i].len;
	t.delta = 0;
	t.font  = dfont;
	XDrawText(dpy, damwin, gc, dline[i].textX, dline[i].textY, &t, 1);
	box(damwin, gc, 0, dline[i].boxX - 1, dline[i].boxY - 1,
	    BOX_WIDTH+2, CH_HEIGHT+2, borderColor);
    }
}

void updateDamage()
{
    DISPLAYLINE *p;
    int i, value, diff;
	unsigned long color;

	if (me->p_status != PALIVE) return;

	if (me->p_damage_dirty) {
		initDamage(progname);
		redrawDamage();
		me->p_damage_dirty = FALSE;
	}
    
    for (i = 0; i < myship->s_numsys; i++)
    {
	p = &dline[i];
	if (p->len == 0)
	    continue;
	
	if (*p->undamaged > 0)
	    value = *p->current * BOX_WIDTH / *p->undamaged;
	else
	    value = 0;
	
	if (value < 0)
	    value = 0;
	if (value > BOX_WIDTH)
	    value = BOX_WIDTH;
	
	if (value == p->last)
	    continue;

	if (value < (BOX_WIDTH/3))
	    color = rColor;
	else if (value < BOX_WIDTH)
	    color = yColor;
	else
	    color = gColor;

	if (value > 0)
	    box(damwin, gc, 1, p->boxX, p->boxY, value, CH_HEIGHT, color);

	diff = value - p->last;
	if (diff < 0)
	    box(damwin, gc, 1, p->boxX + value, p->boxY,
		-diff, CH_HEIGHT, backColor);
	p->last = value;
    }
}
