/* coup.c 15.1 06/08/90 10:04:22 */

/*

	Copyright (c) 1986 	Chris Guthrie

Permission to use, copy, modify, and distribute this
software and its documentation for any purpose and without
fee is hereby granted, provided that the above copyright
notice appear in all copies and that both that copyright
notice and this permission notice appear in supporting
documentation.  No representations are made about the
suitability of this software for any purpose.  It is
provided "as is" without express or implied warranty.

*/

/* Major overhaul by Daryl Poe.
 *
 * Copyright (c) 1989 Daryl Poe
 *
 * Ported to X11 by Jim Andreas.
 * Tractors, treaties, and other features by Norm Gee.
 * Damage window and shield bitmaps by Tom LaStrange.
 *
 * The above comments apply to this version as well, and this
 * notice must also appear in any copies or follow-ons.
 */



#include <stdio.h>
#include "defs.h"
#include "weapon.h"
#include "system.h"
#include "ship.h"
#include "stats.h"
#include "player.h"
#include "torp.h"
#include "status.h"
#include "planet.h"
#include "phaser.h"
#include "message.h"
#include "shmem.h"
#include "data.h"

/* throw a coup */

void coup()
{
	register PLANET *planet;

	if (me->p_kills < 1.0) {
		warning("You must have one kill to throw a coup");
		return;
	}

	if (!(me->p_flags & PFORBIT)) {
		warning("You must orbit your home planet to throw a coup");
		return;
	}

	for (planet = planets; planet < planets+MAXPLANETS; planet++) {
		if ((planet->pl_owner_mask == me->p_team_mask)
				&& (planet->pl_armies > 0)) {
			warning("You already own a planet!!!");
			return;
		}
	}

	planet = &planets[me->p_planet];

	if ((!(planet->pl_flags & PLMASK_HOME))
			|| ((planet->pl_flags & ALL_MASK) != me->p_team_mask)) {
		warning("You must orbit your home planet to throw a coup");
		return;
	}

	if (planet->pl_armies > 4) {
		warning("Too many armies on planet to throw a coup");
		return;
	}

	if (planet->pl_couptime > 0) {
		warning("Planet not yet ready for a coup");
		return;
	}

	if (planet->pl_flags & PLMASK_COUP) { /* Avoid race conditions */
		return;
	}

	/* the cases are now met.  We can have a coup. */

	planet->pl_flags |= PLMASK_COUP;
}
