/* colors.c 15.1 06/08/90 10:04:19 */
/*

	Copyright (c) 1986 	Chris Guthrie

Permission to use, copy, modify, and distribute this
software and its documentation for any purpose and without
fee is hereby granted, provided that the above copyright
notice appear in all copies and that both that copyright
notice and this permission notice appear in supporting
documentation.  No representations are made about the
suitability of this software for any purpose.  It is
provided "as is" without express or implied warranty.

*/

/* Major overhaul by Daryl Poe.
 *
 * Copyright (c) 1989 Daryl Poe
 *
 * Ported to X11 by Jim Andreas.
 * Tractors, treaties, and other features by Norm Gee.
 * Damage window and shield bitmaps by Tom LaStrange.
 *
 * The above comments apply to this version as well, and this
 * notice must also appear in any copies or follow-ons.
 */

#include <stdio.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <string.h>
#include "defs.h"
#include "xdata.h"

typedef struct assoc {
	char          *str;
	unsigned long *colorp;
	int	          bWDef;
	char          *colorDef;
} ASSOC;
/* 
 * hack to b/w values 0/1 for now 
 */

ASSOC	assoc[] = {
	{ "border",		&borderColor,	1,	"blue"		},
	{ "background",	&backColor,		0,	"black"		},
	{ "text",		&textColor,		1,	"white"		},
	{ "nobody",		&shipCol[0],	1,	"tan"		},
	{ "fed",		&shipCol[1],	1,	"yellow",	},
	{ "rom",		&shipCol[2],	1,	"red",		},
	{ "kli",		&shipCol[3],	1,	"green",	},
	{ "ori",		&shipCol[4],	1,	"cyan",		},
	{ "warning",	&warningColor,	1,	"red"		},
	{ "unknown",	&unColor,		1,	"light grey"	},
	{ "ralert",		&rColor,		1,	"red"		},
	{ "yalert",		&yColor,		1,	"yellow"	},
	{ "galert",		&gColor,		1,	"green"		},
	{ "me",			&myColor,		1,	"white"		},
	{ "cloak",		&cloakColor,	1,	"#808080"	},
};


void getColorDefs(prog)
char	*prog;
{
	int	i, invert = 0;
	char	*color;
	XColor	hwdef;
	Status  status;

	if (DisplayCells( dpy, DefaultScreen( dpy) ) <= 2)
	{
		mono = 1;
		invert = booleanDefault(prog, "reverseVideo");
		for (i = 0; i < sizeof (assoc) / sizeof (*assoc); i++)
			*assoc[i].colorp = 
			    invert ? !assoc[i].bWDef : assoc[i].bWDef;
	}
	else
	{
		for (i = 0; i < sizeof (assoc) / sizeof (*assoc); i++) {
			if ((color = XGetDefault(dpy, prog, assoc[i].str)) == NULL)
				color = assoc[i].colorDef;
			if (!XParseColor(dpy, DefaultColormap(dpy, DefaultScreen(dpy)),
				color, &hwdef))
			{
				fprintf( stderr, "getColorDefs:  BadColor.\n");
				exit(1);
			}
			status = XAllocColor(dpy, DefaultColormap(dpy, DefaultScreen(dpy)),
				&hwdef);

			switch( status )
			{
			case BadAlloc:
				fprintf( stderr,
				    "getColorDefs:  cannot allocate colors.\n");
				exit(1);
			case BadColor:
				fprintf( stderr,
				    "getColorDefs:  BadColor.\n");
				exit(1);
			case BadName:
				fprintf( stderr,
				    "getColorDefs:  BadName.\n");
				exit(1);
			}
			*assoc[i].colorp = hwdef.pixel;
		}
	}
}

int booleanDefault(prog, def)
char  *prog, *def;
{
	char  *str;

	if ((str = XGetDefault(dpy, prog, def)) != NULL && strcmp(str, "on") == 0)
		return (1);
	else
		return (0);
}

