/* bitmaps.h 15.1 06/08/90 10:04:03 */

/*

	Copyright (c) 1986 	Chris Guthrie

Permission to use, copy, modify, and distribute this
software and its documentation for any purpose and without
fee is hereby granted, provided that the above copyright
notice appear in all copies and that both that copyright
notice and this permission notice appear in supporting
documentation.  No representations are made about the
suitability of this software for any purpose.  It is
provided "as is" without express or implied warranty.

*/

/* Major overhaul by Daryl Poe.
 *
 * Copyright (c) 1989 Daryl Poe
 *
 * Ported to X11 by Jim Andreas.
 * Tractors, treaties, and other features by Norm Gee.
 * Damage window and shield bitmaps by Tom LaStrange.
 *
 * The above comments apply to this version as well, and this
 * notice must also appear in any copies or follow-ons.
 */

/**** These are the ships ****/
#define VIEWS		16
#define ship_width	16
#define ship_height	16


static char fed_bits[4][16][32] = {
{
	/* fed CL */
{ 0x00, 0x00, 0xc0, 0x03, 0xe0, 0x07, 0xf0, 0x0f, 0xf0, 0x0f, 0xf0, 0x0f, 0xe0, 0x07, 0xe0, 0x07, 0xa0, 0x05, 0xa0, 0x05, 0xa0, 0x05, 0x20, 0x04, 0x20, 0x04, 0x20, 0x04, 0x00, 0x00, 0x00, 0x00},
{ 0x00, 0x00, 0x00, 0x07, 0xc0, 0x0f, 0xc0, 0x1f, 0xe0, 0x1f, 0xc0, 0x1f, 0xe0, 0x1f, 0xe0, 0x0f, 0xa0, 0x07, 0xd0, 0x04, 0xd0, 0x02, 0x08, 0x02, 0x00, 0x01, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00},
{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0x80, 0x1f, 0x80, 0x3f, 0xc0, 0x3f, 0xe0, 0x3f, 0xb0, 0x3f, 0xd8, 0x1f, 0xcc, 0x06, 0x00, 0x03, 0x80, 0x01, 0xc0, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00},
{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0x00, 0x3f, 0xc0, 0x7f, 0xb0, 0x7f, 0x8c, 0x7f, 0xe0, 0x3f, 0x60, 0x3f, 0x80, 0x0b, 0x60, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0xfc, 0x3f, 0x00, 0x7f, 0xe0, 0x7f, 0xe0, 0x7f, 0x00, 0x7f, 0xfc, 0x3f, 0x00, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x60, 0x00, 0x80, 0x0b, 0x60, 0x3f, 0xe0, 0x3f, 0x8c, 0x7f, 0xb0, 0x7f, 0xc0, 0x7f, 0x00, 0x3f, 0x00, 0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
{ 0x00, 0x00, 0x00, 0x00, 0x40, 0x00, 0xc0, 0x00, 0x80, 0x01, 0x00, 0x03, 0xcc, 0x06, 0xd8, 0x1f, 0xb0, 0x3f, 0xe0, 0x3f, 0xc0, 0x3f, 0x80, 0x3f, 0x80, 0x1f, 0x00, 0x0f, 0x00, 0x00, 0x00, 0x00},
{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0x08, 0x02, 0xd0, 0x02, 0xd0, 0x04, 0xa0, 0x07, 0xe0, 0x0f, 0xe0, 0x1f, 0xc0, 0x1f, 0xe0, 0x1f, 0xc0, 0x1f, 0xc0, 0x0f, 0x00, 0x07, 0x00, 0x00},
{ 0x00, 0x00, 0x00, 0x00, 0x20, 0x04, 0x20, 0x04, 0x20, 0x04, 0xa0, 0x05, 0xa0, 0x05, 0xa0, 0x05, 0xe0, 0x07, 0xe0, 0x07, 0xf0, 0x0f, 0xf0, 0x0f, 0xf0, 0x0f, 0xe0, 0x07, 0xc0, 0x03, 0x00, 0x00},
{ 0x00, 0x00, 0x00, 0x00, 0x80, 0x00, 0x80, 0x00, 0x40, 0x10, 0x40, 0x0b, 0x20, 0x0b, 0xe0, 0x05, 0xf0, 0x07, 0xf8, 0x07, 0xf8, 0x03, 0xf8, 0x07, 0xf8, 0x03, 0xf0, 0x03, 0xe0, 0x00, 0x00, 0x00},
{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x03, 0x80, 0x01, 0xc0, 0x00, 0x60, 0x33, 0xf8, 0x1b, 0xfc, 0x0d, 0xfc, 0x07, 0xfc, 0x03, 0xfc, 0x01, 0xf8, 0x01, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00},
{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x06, 0xd0, 0x01, 0xfc, 0x06, 0xfc, 0x07, 0xfe, 0x31, 0xfe, 0x0d, 0xfe, 0x03, 0xfc, 0x00, 0x78, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x00, 0xfc, 0x3f, 0xfe, 0x00, 0xfe, 0x07, 0xfe, 0x07, 0xfe, 0x00, 0xfc, 0x3f, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x78, 0x00, 0xfc, 0x00, 0xfe, 0x03, 0xfe, 0x0d, 0xfe, 0x31, 0xfc, 0x07, 0xfc, 0x06, 0xd0, 0x01, 0x00, 0x06, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
{ 0x00, 0x00, 0x00, 0x00, 0xf0, 0x00, 0xf8, 0x01, 0xfc, 0x01, 0xfc, 0x03, 0xfc, 0x07, 0xfc, 0x0d, 0xf8, 0x1b, 0x60, 0x33, 0xc0, 0x00, 0x80, 0x01, 0x00, 0x03, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00},
{ 0x00, 0x00, 0xe0, 0x00, 0xf0, 0x03, 0xf8, 0x03, 0xf8, 0x07, 0xf8, 0x03, 0xf8, 0x07, 0xf0, 0x07, 0xe0, 0x05, 0x20, 0x0b, 0x40, 0x0b, 0x40, 0x10, 0x80, 0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00}
},

/* fedCA */
{
{ 0xc0, 0x03, 0xe0, 0x07, 0xf0, 0x0f, 0xf0, 0x0f, 0xf0, 0x0f, 0xe0, 0x07, 0xc0, 0x03, 0x90, 0x09, 0x90, 0x09, 0x90, 0x09, 0xf0, 0x0f, 0x90, 0x09, 0x90, 0x09, 0x10, 0x08, 0x10, 0x08, 0x10, 0x08},
{ 0x00, 0x07, 0xc0, 0x1f, 0xc0, 0x1f, 0xc0, 0x1f, 0xc0, 0x3f, 0x80, 0x1f, 0x90, 0x0f, 0x90, 0x03, 0x98, 0x01, 0xf8, 0x08, 0xc8, 0x05, 0xe4, 0x06, 0x44, 0x02, 0x00, 0x02, 0x00, 0x02, 0x00, 0x01},
{ 0x00, 0x00, 0x00, 0x1e, 0x00, 0x3f, 0x00, 0x7f, 0x00, 0x7f, 0x20, 0x7f, 0x10, 0x7f, 0x98, 0x3f, 0xf4, 0x01, 0xe2, 0x00, 0xf1, 0x04, 0xb0, 0x03, 0x00, 0x01, 0x80, 0x00, 0x40, 0x00, 0x20, 0x00},
{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x7c, 0x40, 0x7e, 0x30, 0xfe, 0x1e, 0xff, 0xa1, 0xff, 0xf0, 0x7f, 0x78, 0x78, 0x50, 0x00, 0xc0, 0x03, 0xe0, 0x00, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00},
{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x39, 0x20, 0x7c, 0x20, 0xfe, 0xf8, 0xff, 0xf8, 0xff, 0x20, 0xfe, 0x20, 0x7c, 0xff, 0x39, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
{ 0x00, 0x00, 0x00, 0x00, 0x18, 0x00, 0xe0, 0x00, 0xc0, 0x03, 0x50, 0x00, 0x78, 0x78, 0xf0, 0x7f, 0xa1, 0xff, 0x1e, 0xff, 0x30, 0xfe, 0x40, 0x7e, 0x00, 0x7c, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00},
{ 0x20, 0x00, 0x40, 0x00, 0x80, 0x00, 0x00, 0x01, 0xb0, 0x03, 0xf1, 0x04, 0xe2, 0x00, 0xf4, 0x01, 0x98, 0x3f, 0x10, 0x7f, 0x20, 0x7f, 0x00, 0x7f, 0x00, 0x7f, 0x00, 0x3f, 0x00, 0x1e, 0x00, 0x00},
{ 0x00, 0x01, 0x00, 0x02, 0x00, 0x02, 0x44, 0x02, 0xe4, 0x06, 0xc8, 0x05, 0xf8, 0x08, 0x98, 0x01, 0x90, 0x03, 0x90, 0x0f, 0x80, 0x1f, 0xc0, 0x3f, 0xc0, 0x1f, 0xc0, 0x1f, 0xc0, 0x1f, 0x00, 0x07},
{ 0x10, 0x08, 0x10, 0x08, 0x10, 0x08, 0x90, 0x09, 0x90, 0x09, 0xf0, 0x0f, 0x90, 0x09, 0x90, 0x09, 0x90, 0x09, 0xc0, 0x03, 0xe0, 0x07, 0xf0, 0x0f, 0xf0, 0x0f, 0xf0, 0x0f, 0xe0, 0x07, 0xc0, 0x03},
{ 0x80, 0x00, 0x40, 0x00, 0x40, 0x00, 0x40, 0x22, 0x60, 0x27, 0xa0, 0x13, 0x10, 0x1f, 0x80, 0x19, 0xc0, 0x09, 0xf0, 0x09, 0xf8, 0x01, 0xfc, 0x03, 0xf8, 0x03, 0xf8, 0x03, 0xf8, 0x03, 0xe0, 0x00},
{ 0x00, 0x04, 0x00, 0x02, 0x00, 0x01, 0x80, 0x00, 0xc0, 0x0d, 0x20, 0x8f, 0x00, 0x47, 0x80, 0x2f, 0xfc, 0x19, 0xfe, 0x08, 0xfe, 0x04, 0xfe, 0x00, 0xfe, 0x00, 0xfc, 0x00, 0x78, 0x00, 0x00, 0x00},
{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x00, 0x07, 0xc0, 0x03, 0x00, 0x0a, 0x1e, 0x1e, 0xfe, 0x0f, 0xff, 0x85, 0xff, 0x78, 0x7f, 0x0c, 0x7e, 0x02, 0x3e, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00},
{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x9c, 0xff, 0x3e, 0x04, 0x7f, 0x04, 0xff, 0x1f, 0xff, 0x1f, 0x7f, 0x04, 0x3e, 0x04, 0x9c, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
{ 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x3e, 0x00, 0x7e, 0x02, 0x7f, 0x0c, 0xff, 0x78, 0xff, 0x85, 0xfe, 0x0f, 0x1e, 0x1e, 0x00, 0x0a, 0xc0, 0x03, 0x00, 0x07, 0x00, 0x18, 0x00, 0x00, 0x00, 0x00},
{ 0x00, 0x00, 0x78, 0x00, 0xfc, 0x00, 0xfe, 0x00, 0xfe, 0x00, 0xfe, 0x04, 0xfe, 0x08, 0xfc, 0x19, 0x80, 0x2f, 0x00, 0x47, 0x20, 0x8f, 0xc0, 0x0d, 0x80, 0x00, 0x00, 0x01, 0x00, 0x02, 0x00, 0x04},
{ 0xe0, 0x00, 0xf8, 0x03, 0xf8, 0x03, 0xf8, 0x03, 0xfc, 0x03, 0xf8, 0x01, 0xf0, 0x09, 0xc0, 0x09, 0x80, 0x19, 0x10, 0x1f, 0xa0, 0x13, 0x60, 0x27, 0x40, 0x22, 0x40, 0x00, 0x40, 0x00, 0x80, 0x00}
},

/* fed BC */
{
{ 0xc0, 0x03, 0xe0, 0x07, 0xf0, 0x0f, 0xf0, 0x0f, 0xf0, 0x0f, 0xf0, 0x0f, 0xe0, 0x07, 0xc8, 0x13, 0xc8, 0x13, 0xc8, 0x13, 0xf8, 0x1f, 0xc8, 0x13, 0x88, 0x11, 0x88, 0x11, 0x88, 0x11, 0x88, 0x11},
{ 0x00, 0x07, 0xc0, 0x1f, 0xc0, 0x1f, 0xc0, 0x1f, 0xe0, 0x3f, 0xc0, 0x1f, 0xc8, 0x1f, 0xc8, 0x0f, 0xcc, 0x03, 0xfc, 0x13, 0xe4, 0x09, 0xe2, 0x0f, 0x62, 0x0c, 0x60, 0x04, 0x30, 0x04, 0x00, 0x02},
{ 0x00, 0x00, 0x00, 0x1e, 0x00, 0x3f, 0x80, 0x7f, 0x90, 0x7f, 0x98, 0x7f, 0x8c, 0x7f, 0xde, 0x3f, 0xf3, 0x1f, 0xf1, 0x01, 0xf0, 0x00, 0xf8, 0x0d, 0x1c, 0x07, 0x0c, 0x03, 0x80, 0x01, 0xc0, 0x00},
{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x40, 0x7e, 0x38, 0x7f, 0x1e, 0xff, 0xd1, 0xff, 0xf0, 0xff, 0xf0, 0x7f, 0xfc, 0x7f, 0x7e, 0x08, 0x42, 0x00, 0xc0, 0x03, 0xe0, 0x00, 0x18, 0x00, 0x00, 0x00},
{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x01, 0x20, 0x3c, 0x20, 0x7e, 0xf0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0, 0xff, 0x20, 0x7e, 0x20, 0x3c, 0xff, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
{ 0x00, 0x00, 0x18, 0x00, 0xe0, 0x00, 0xc0, 0x03, 0x42, 0x00, 0x7e, 0x08, 0xfc, 0x7f, 0xf0, 0x7f, 0xf0, 0xff, 0xd1, 0xff, 0x1e, 0xff, 0x38, 0x7f, 0x40, 0x7e, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00},
{ 0xc0, 0x00, 0x80, 0x01, 0x0c, 0x03, 0x1c, 0x07, 0xf8, 0x0d, 0xf0, 0x00, 0xf1, 0x01, 0xf3, 0x1f, 0xde, 0x3f, 0x8c, 0x7f, 0x98, 0x7f, 0x90, 0x7f, 0x80, 0x7f, 0x00, 0x3f, 0x00, 0x1e, 0x00, 0x00},
{ 0x00, 0x02, 0x30, 0x04, 0x60, 0x04, 0x62, 0x0c, 0xe2, 0x0f, 0xe4, 0x09, 0xfc, 0x13, 0xcc, 0x03, 0xc8, 0x0f, 0xc8, 0x1f, 0xc0, 0x1f, 0xe0, 0x3f, 0xc0, 0x1f, 0xc0, 0x1f, 0xc0, 0x1f, 0x00, 0x07},
{ 0x88, 0x11, 0x88, 0x11, 0x88, 0x11, 0x88, 0x11, 0xc8, 0x13, 0xf8, 0x1f, 0xc8, 0x13, 0xc8, 0x13, 0xc8, 0x13, 0xe0, 0x07, 0xf0, 0x0f, 0xf0, 0x0f, 0xf0, 0x0f, 0xf0, 0x0f, 0xe0, 0x07, 0xc0, 0x03},
{ 0x40, 0x00, 0x20, 0x0c, 0x20, 0x06, 0x30, 0x46, 0xf0, 0x47, 0x90, 0x27, 0xc8, 0x3f, 0xc0, 0x33, 0xf0, 0x13, 0xf8, 0x13, 0xf8, 0x03, 0xfc, 0x07, 0xf8, 0x03, 0xf8, 0x03, 0xf8, 0x03, 0xe0, 0x00},
{ 0x00, 0x03, 0x80, 0x01, 0xc0, 0x30, 0xe0, 0x38, 0xb0, 0x1f, 0x00, 0x0f, 0x80, 0x8f, 0xf8, 0xcf, 0xfc, 0x7b, 0xfe, 0x31, 0xfe, 0x19, 0xfe, 0x09, 0xfe, 0x01, 0xfc, 0x00, 0x78, 0x00, 0x00, 0x00},
{ 0x00, 0x00, 0x00, 0x18, 0x00, 0x07, 0xc0, 0x03, 0x00, 0x42, 0x10, 0x7e, 0xfe, 0x3f, 0xfe, 0x0f, 0xff, 0x0f, 0xff, 0x8b, 0xff, 0x78, 0xfe, 0x1c, 0x7e, 0x02, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00},
{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0xff, 0x3c, 0x04, 0x7e, 0x04, 0xff, 0x0f, 0xff, 0xff, 0xff, 0xff, 0xff, 0x0f, 0x7e, 0x04, 0x3c, 0x04, 0x80, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
{ 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x7e, 0x02, 0xfe, 0x1c, 0xff, 0x78, 0xff, 0x8b, 0xff, 0x0f, 0xfe, 0x0f, 0xfe, 0x3f, 0x10, 0x7e, 0x00, 0x42, 0xc0, 0x03, 0x00, 0x07, 0x00, 0x18, 0x00, 0x00},
{ 0x00, 0x00, 0x78, 0x00, 0xfc, 0x00, 0xfe, 0x01, 0xfe, 0x09, 0xfe, 0x19, 0xfe, 0x31, 0xfc, 0x7b, 0xf8, 0xcf, 0x80, 0x8f, 0x00, 0x0f, 0xb0, 0x1f, 0xe0, 0x38, 0xc0, 0x30, 0x80, 0x01, 0x00, 0x03},
{ 0xe0, 0x00, 0xf8, 0x03, 0xf8, 0x03, 0xf8, 0x03, 0xfc, 0x07, 0xf8, 0x03, 0xf8, 0x13, 0xf0, 0x13, 0xc0, 0x33, 0xc8, 0x3f, 0x90, 0x27, 0xf0, 0x47, 0x30, 0x46, 0x20, 0x06, 0x20, 0x0c, 0x40, 0x00}
},

/* fed BB */
{
{ 0xc0, 0x03, 0xe0, 0x07, 0xf0, 0x0f, 0xf0, 0x0f, 0xf0, 0x0f, 0xf0, 0x0f, 0xe4, 0x27, 0xc4, 0x23, 0xe4, 0x27, 0xec, 0x37, 0xec, 0x37, 0xfc, 0x3f, 0xec, 0x37, 0xec, 0x37, 0x6c, 0x36, 0x44, 0x22},
{ 0x00, 0x07, 0xc0, 0x1f, 0xc0, 0x1f, 0xc0, 0x1f, 0xe8, 0x3f, 0xc8, 0x1f, 0xc4, 0x1f, 0xec, 0x0f, 0xe6, 0x23, 0xfe, 0x23, 0xff, 0x13, 0xfb, 0x1b, 0xfb, 0x1f, 0xd8, 0x0d, 0xc8, 0x0d, 0xc0, 0x06},
{ 0x00, 0x00, 0x00, 0x1e, 0x00, 0x3f, 0x90, 0x7f, 0x88, 0x7f, 0x8c, 0x7f, 0xee, 0x7f, 0xff, 0x3f, 0xfb, 0x1f, 0xfd, 0x03, 0xfe, 0x03, 0xfe, 0x11, 0xf2, 0x0f, 0x70, 0x07, 0xb8, 0x03, 0xc0, 0x01},
{ 0x00, 0x00, 0x00, 0x00, 0xc0, 0x08, 0x38, 0x7e, 0x1e, 0x7f, 0x0f, 0xff, 0xf9, 0xff, 0xfe, 0xff, 0xff, 0x7f, 0xff, 0x7f, 0xf8, 0x09, 0x7c, 0x00, 0x7e, 0x0d, 0xe0, 0x03, 0xf8, 0x00, 0x38, 0x00},
{ 0x00, 0x00, 0x00, 0x00, 0xff, 0x03, 0x7e, 0x00, 0x10, 0x3c, 0xfe, 0x7e, 0xff, 0xff, 0xfc, 0xff, 0xfc, 0xff, 0xff, 0xff, 0xfe, 0x7e, 0x10, 0x3c, 0x7e, 0x00, 0xff, 0x03, 0x00, 0x00, 0x00, 0x00},
{ 0x38, 0x00, 0xf8, 0x00, 0xe0, 0x03, 0x7e, 0x0d, 0x7c, 0x00, 0xf8, 0x09, 0xff, 0x7f, 0xff, 0x7f, 0xfe, 0xff, 0xf9, 0xff, 0x0f, 0xff, 0x1e, 0x7f, 0x38, 0x7e, 0xc0, 0x08, 0x00, 0x00, 0x00, 0x00},
{ 0xc0, 0x01, 0xb8, 0x03, 0x70, 0x07, 0xf2, 0x0f, 0xfe, 0x11, 0xfe, 0x03, 0xfd, 0x03, 0xfb, 0x1f, 0xff, 0x3f, 0xee, 0x7f, 0x8c, 0x7f, 0x88, 0x7f, 0x90, 0x7f, 0x00, 0x3f, 0x00, 0x1e, 0x00, 0x00},
{ 0xc0, 0x06, 0xc8, 0x0d, 0xd8, 0x0d, 0xfb, 0x1f, 0xfb, 0x1b, 0xff, 0x13, 0xfe, 0x23, 0xe6, 0x23, 0xec, 0x0f, 0xc4, 0x1f, 0xc8, 0x1f, 0xe8, 0x3f, 0xc0, 0x1f, 0xc0, 0x1f, 0xc0, 0x1f, 0x00, 0x07},
{ 0x44, 0x22, 0x6c, 0x36, 0xec, 0x37, 0xec, 0x37, 0xfc, 0x3f, 0xec, 0x37, 0xec, 0x37, 0xe4, 0x27, 0xc4, 0x23, 0xe4, 0x27, 0xf0, 0x0f, 0xf0, 0x0f, 0xf0, 0x0f, 0xf0, 0x0f, 0xe0, 0x07, 0xc0, 0x03},
{ 0x60, 0x03, 0xb0, 0x13, 0xb0, 0x1b, 0xf8, 0xdf, 0xd8, 0xdf, 0xc8, 0xff, 0xc4, 0x7f, 0xc4, 0x67, 0xf0, 0x37, 0xf8, 0x23, 0xf8, 0x13, 0xfc, 0x17, 0xf8, 0x03, 0xf8, 0x03, 0xf8, 0x03, 0xe0, 0x00},
{ 0x80, 0x03, 0xc0, 0x1d, 0xe0, 0x0e, 0xf0, 0x4f, 0x88, 0x7f, 0xc0, 0x7f, 0xc0, 0xbf, 0xf8, 0xdf, 0xfc, 0xff, 0xfe, 0x77, 0xfe, 0x31, 0xfe, 0x11, 0xfe, 0x09, 0xfc, 0x00, 0x78, 0x00, 0x00, 0x00},
{ 0x00, 0x1c, 0x00, 0x1f, 0xc0, 0x07, 0xb0, 0x7e, 0x00, 0x3e, 0x90, 0x1f, 0xfe, 0xff, 0xfe, 0xff, 0xff, 0x7f, 0xff, 0x9f, 0xff, 0xf0, 0xfe, 0x78, 0x7e, 0x1c, 0x10, 0x03, 0x00, 0x00, 0x00, 0x00},
{ 0x00, 0x00, 0x00, 0x00, 0xc0, 0xff, 0x00, 0x7e, 0x3c, 0x08, 0x7e, 0x7f, 0xff, 0xff, 0xff, 0x3f, 0xff, 0x3f, 0xff, 0xff, 0x7e, 0x7f, 0x3c, 0x08, 0x00, 0x7e, 0xc0, 0xff, 0x00, 0x00, 0x00, 0x00},
{ 0x00, 0x00, 0x00, 0x00, 0x10, 0x03, 0x7e, 0x1c, 0xfe, 0x78, 0xff, 0xf0, 0xff, 0x9f, 0xff, 0x7f, 0xfe, 0xff, 0xfe, 0xff, 0x90, 0x1f, 0x00, 0x3e, 0xb0, 0x7e, 0xc0, 0x07, 0x00, 0x1f, 0x00, 0x1c},
{ 0x00, 0x00, 0x78, 0x00, 0xfc, 0x00, 0xfe, 0x09, 0xfe, 0x11, 0xfe, 0x31, 0xfe, 0x77, 0xfc, 0xff, 0xf8, 0xdf, 0xc0, 0xbf, 0xc0, 0x7f, 0x88, 0x7f, 0xf0, 0x4f, 0xe0, 0x0e, 0xc0, 0x1d, 0x80, 0x03},
{ 0xe0, 0x00, 0xf8, 0x03, 0xf8, 0x03, 0xf8, 0x03, 0xfc, 0x17, 0xf8, 0x13, 0xf8, 0x23, 0xf0, 0x37, 0xc4, 0x67, 0xc4, 0x7f, 0xc8, 0xff, 0xd8, 0xdf, 0xf8, 0xdf, 0xb0, 0x1b, 0xb0, 0x13, 0x60, 0x03}
}
};


static char rom_bits[4][16][32] = {

/* CL */
{
{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc8, 0x13, 0xe8, 0x17, 0xf8, 0x1f, 0xf8, 0x1f, 0xf8, 0x1f, 0x38, 0x1c, 0x08, 0x10, 0x08, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x00, 0xd0, 0x03, 0xf0, 0x07, 0xf8, 0x2f, 0xf8, 0x3f, 0xbc, 0x1f, 0x04, 0x1e, 0x00, 0x0e, 0x00, 0x08, 0x00, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
{ 0x00, 0x00, 0x00, 0x00, 0xc0, 0x00, 0x60, 0x00, 0xf0, 0x03, 0xf8, 0x07, 0xfc, 0x0f, 0xe4, 0x0f, 0x80, 0x2f, 0x00, 0x3f, 0x00, 0x1f, 0x00, 0x0e, 0x00, 0x06, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00},
{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0xc0, 0x01, 0xf8, 0x03, 0xe8, 0x07, 0xe0, 0x0f, 0x80, 0x0f, 0x80, 0x0f, 0x00, 0x0f, 0x80, 0x17, 0x80, 0x1f, 0x80, 0x03, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00},
{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf0, 0x0f, 0xc0, 0x03, 0xc0, 0x07, 0x80, 0x0f, 0x80, 0x0f, 0x80, 0x0f, 0x80, 0x0f, 0xc0, 0x07, 0xc0, 0x03, 0xf0, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
{ 0x00, 0x00, 0x00, 0x00, 0xc0, 0x00, 0x80, 0x03, 0x80, 0x1f, 0x80, 0x17, 0x00, 0x0f, 0x80, 0x0f, 0x80, 0x0f, 0xe0, 0x0f, 0xe8, 0x07, 0xf8, 0x03, 0xc0, 0x01, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00},
{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x06, 0x00, 0x0e, 0x00, 0x1f, 0x00, 0x3f, 0x80, 0x2f, 0xe4, 0x0f, 0xfc, 0x0f, 0xf8, 0x07, 0xf0, 0x03, 0x60, 0x00, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00},
{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x00, 0x08, 0x00, 0x0e, 0x04, 0x1e, 0xbc, 0x1f, 0xf8, 0x3f, 0xf8, 0x2f, 0xf0, 0x07, 0xd0, 0x03, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x10, 0x08, 0x10, 0x38, 0x1c, 0xf8, 0x1f, 0xf8, 0x1f, 0xf8, 0x1f, 0xe8, 0x17, 0xc8, 0x13, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x00, 0x10, 0x00, 0x70, 0x00, 0x78, 0x20, 0xf8, 0x3d, 0xfc, 0x1f, 0xf4, 0x1f, 0xe0, 0x0f, 0xc0, 0x0b, 0x00, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
{ 0x00, 0x00, 0x00, 0x00, 0xc0, 0x00, 0x60, 0x00, 0x70, 0x00, 0xf8, 0x00, 0xfc, 0x00, 0xf4, 0x01, 0xf0, 0x27, 0xf0, 0x3f, 0xe0, 0x1f, 0xc0, 0x0f, 0x00, 0x06, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00},
{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0xc0, 0x01, 0xf8, 0x01, 0xe8, 0x01, 0xf0, 0x00, 0xf0, 0x01, 0xf0, 0x01, 0xf0, 0x07, 0xe0, 0x17, 0xc0, 0x1f, 0x80, 0x03, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00},
{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf0, 0x0f, 0xc0, 0x03, 0xe0, 0x03, 0xf0, 0x01, 0xf0, 0x01, 0xf0, 0x01, 0xf0, 0x01, 0xe0, 0x03, 0xc0, 0x03, 0xf0, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
{ 0x00, 0x00, 0x00, 0x00, 0xc0, 0x00, 0x80, 0x03, 0xc0, 0x1f, 0xe0, 0x17, 0xf0, 0x07, 0xf0, 0x01, 0xf0, 0x01, 0xf0, 0x00, 0xe8, 0x01, 0xf8, 0x01, 0xc0, 0x01, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00},
{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x06, 0xc0, 0x0f, 0xe0, 0x1f, 0xf0, 0x3f, 0xf0, 0x27, 0xf4, 0x01, 0xfc, 0x00, 0xf8, 0x00, 0x70, 0x00, 0x60, 0x00, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00},
{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0xc0, 0x0b, 0xe0, 0x0f, 0xf4, 0x1f, 0xfc, 0x1f, 0xf8, 0x3d, 0x78, 0x20, 0x70, 0x00, 0x10, 0x00, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
},

/* CA */
{
{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc2, 0x43, 0xe2, 0x47, 0xf2, 0x4f, 0xfa, 0x5f, 0xfa, 0x5f, 0xfe, 0x7f, 0xfe, 0x7f, 0x0e, 0x70, 0x02, 0x40, 0x02, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
{ 0x00, 0x00, 0x08, 0x00, 0x08, 0x00, 0x84, 0x03, 0xe4, 0x07, 0xf6, 0x0f, 0xfe, 0x8f, 0xfe, 0x9f, 0xff, 0x5f, 0xc1, 0x5f, 0x00, 0x7e, 0x00, 0x38, 0x00, 0x38, 0x00, 0x10, 0x00, 0x10, 0x00, 0x00},
{ 0x40, 0x00, 0x20, 0x00, 0x10, 0x00, 0x68, 0x06, 0xfc, 0x0f, 0xfe, 0x1f, 0xfd, 0x1f, 0xe0, 0x0f, 0xc0, 0x0f, 0x80, 0x9f, 0x00, 0x5f, 0x00, 0x2e, 0x00, 0x1e, 0x00, 0x0e, 0x00, 0x04, 0x00, 0x02},
{ 0x00, 0x03, 0xe0, 0x00, 0x38, 0x00, 0xfe, 0x01, 0xf8, 0x07, 0xe0, 0x0f, 0xe0, 0x1f, 0xc0, 0x1f, 0xc0, 0x1f, 0xc0, 0x0f, 0x80, 0x0f, 0x80, 0x07, 0x80, 0x63, 0x80, 0x1f, 0x80, 0x07, 0xc0, 0x00},
{ 0x00, 0x00, 0xf8, 0x1f, 0xe0, 0x00, 0xe0, 0x03, 0xc0, 0x07, 0xc0, 0x0f, 0xc0, 0x1f, 0xc0, 0x1f, 0xc0, 0x1f, 0xc0, 0x1f, 0xc0, 0x0f, 0xc0, 0x07, 0xe0, 0x03, 0xe0, 0x00, 0xf8, 0x1f, 0x00, 0x00},
{ 0xc0, 0x00, 0x80, 0x07, 0x80, 0x1f, 0x80, 0x63, 0x80, 0x07, 0x80, 0x0f, 0xc0, 0x0f, 0xc0, 0x1f, 0xc0, 0x1f, 0xe0, 0x1f, 0xe0, 0x0f, 0xf8, 0x07, 0xfe, 0x01, 0x38, 0x00, 0xe0, 0x00, 0x00, 0x03},
{ 0x00, 0x02, 0x00, 0x04, 0x00, 0x0e, 0x00, 0x1e, 0x00, 0x2e, 0x00, 0x5f, 0x80, 0x9f, 0xc0, 0x0f, 0xe0, 0x0f, 0xfd, 0x1f, 0xfe, 0x1f, 0xfc, 0x0f, 0x68, 0x06, 0x10, 0x00, 0x20, 0x00, 0x40, 0x00},
{ 0x00, 0x00, 0x00, 0x10, 0x00, 0x10, 0x00, 0x38, 0x00, 0x38, 0x00, 0x7e, 0xc1, 0x5f, 0xff, 0x5f, 0xfe, 0x9f, 0xfe, 0x8f, 0xf6, 0x0f, 0xe4, 0x07, 0x84, 0x03, 0x08, 0x00, 0x08, 0x00, 0x00, 0x00},
{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x40, 0x02, 0x40, 0x0e, 0x70, 0xfe, 0x7f, 0xfe, 0x7f, 0xfa, 0x5f, 0xfa, 0x5f, 0xf2, 0x4f, 0xe2, 0x47, 0xc2, 0x43, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
{ 0x00, 0x00, 0x08, 0x00, 0x08, 0x00, 0x1c, 0x00, 0x1c, 0x00, 0x7e, 0x00, 0xfa, 0x83, 0xfa, 0xff, 0xf9, 0x7f, 0xf1, 0x7f, 0xf0, 0x6f, 0xe0, 0x27, 0xc0, 0x21, 0x00, 0x10, 0x00, 0x10, 0x00, 0x00},
{ 0x40, 0x00, 0x20, 0x00, 0x70, 0x00, 0x78, 0x00, 0x74, 0x00, 0xfa, 0x00, 0xf9, 0x01, 0xf0, 0x03, 0xf0, 0x07, 0xf8, 0xbf, 0xf8, 0x7f, 0xf0, 0x3f, 0x60, 0x16, 0x00, 0x08, 0x00, 0x04, 0x00, 0x02},
{ 0x00, 0x03, 0xe0, 0x01, 0xf8, 0x01, 0xc6, 0x01, 0xe0, 0x01, 0xf0, 0x01, 0xf0, 0x03, 0xf8, 0x03, 0xf8, 0x03, 0xf8, 0x07, 0xf0, 0x07, 0xe0, 0x1f, 0x80, 0x7f, 0x00, 0x1c, 0x00, 0x07, 0xc0, 0x00},
{ 0x00, 0x00, 0xf8, 0x1f, 0x00, 0x07, 0xc0, 0x07, 0xe0, 0x03, 0xf0, 0x03, 0xf8, 0x03, 0xf8, 0x03, 0xf8, 0x03, 0xf8, 0x03, 0xf0, 0x03, 0xe0, 0x03, 0xc0, 0x07, 0x00, 0x07, 0xf8, 0x1f, 0x00, 0x00},
{ 0xc0, 0x00, 0x00, 0x07, 0x00, 0x1c, 0x80, 0x7f, 0xe0, 0x1f, 0xf0, 0x07, 0xf8, 0x07, 0xf8, 0x03, 0xf8, 0x03, 0xf0, 0x03, 0xf0, 0x01, 0xe0, 0x01, 0xc6, 0x01, 0xf8, 0x01, 0xe0, 0x01, 0x00, 0x03},
{ 0x00, 0x02, 0x00, 0x04, 0x00, 0x08, 0x60, 0x16, 0xf0, 0x3f, 0xf8, 0x7f, 0xf8, 0xbf, 0xf0, 0x07, 0xf0, 0x03, 0xf9, 0x01, 0xfa, 0x00, 0x74, 0x00, 0x78, 0x00, 0x70, 0x00, 0x20, 0x00, 0x40, 0x00},
{ 0x00, 0x00, 0x00, 0x10, 0x00, 0x10, 0xc0, 0x21, 0xe0, 0x27, 0xf0, 0x6f, 0xf1, 0x7f, 0xf9, 0x7f, 0xfa, 0xff, 0xfa, 0x83, 0x7e, 0x00, 0x1c, 0x00, 0x1c, 0x00, 0x08, 0x00, 0x08, 0x00, 0x00, 0x00}
},

/* BC */
{
{ 0x00, 0x00, 0x00, 0x00, 0xc0, 0x03, 0xe1, 0x87, 0xf1, 0x8f, 0xf9, 0x9f, 0xfd, 0xbf, 0xfd, 0xbf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc7, 0xe3, 0xc3, 0xc3, 0x43, 0xc2, 0x03, 0xc0, 0x00, 0x00},
{ 0x00, 0x00, 0x04, 0x00, 0x04, 0x03, 0xe2, 0x0f, 0xfa, 0x0f, 0xff, 0x1f, 0xff, 0x1f, 0xff, 0x1f, 0xff, 0xbf, 0xf1, 0xbf, 0xe0, 0xff, 0xf0, 0x7f, 0xf0, 0x78, 0x80, 0x38, 0x00, 0x30, 0x00, 0x38},
{ 0x30, 0x00, 0x18, 0x00, 0x0c, 0x00, 0xfe, 0x0f, 0xff, 0x1f, 0xff, 0x1f, 0xff, 0x1f, 0xf8, 0x1f, 0xf0, 0x1f, 0xf0, 0x1f, 0xf8, 0x9f, 0xf0, 0xdf, 0x20, 0x7f, 0x00, 0x3e, 0x00, 0x1e, 0x00, 0x0e},
{ 0xe0, 0x00, 0x38, 0x00, 0xff, 0x00, 0xff, 0x07, 0xfd, 0x1f, 0xf0, 0x1f, 0xf0, 0x3f, 0xf0, 0x3f, 0xfc, 0x1f, 0xf8, 0x1f, 0xf8, 0x1f, 0xd8, 0x0f, 0x80, 0x0f, 0x80, 0x67, 0x80, 0x1f, 0xc0, 0x07},
{ 0xfe, 0x1f, 0xfe, 0x00, 0xf0, 0x03, 0xe0, 0x07, 0xe0, 0x0f, 0xe0, 0x1f, 0xfc, 0x3f, 0xf8, 0x3f, 0xf8, 0x3f, 0xfc, 0x3f, 0xe0, 0x1f, 0xe0, 0x0f, 0xe0, 0x07, 0xf0, 0x03, 0xfe, 0x00, 0xfe, 0x1f},
{ 0xc0, 0x07, 0x80, 0x1f, 0x80, 0x67, 0x80, 0x0f, 0xd8, 0x0f, 0xf8, 0x1f, 0xf8, 0x1f, 0xfc, 0x1f, 0xf0, 0x3f, 0xf0, 0x3f, 0xf0, 0x1f, 0xfd, 0x1f, 0xff, 0x07, 0xff, 0x00, 0x38, 0x00, 0xe0, 0x00},
{ 0x00, 0x0e, 0x00, 0x1e, 0x00, 0x3e, 0x20, 0x7f, 0xf0, 0xdf, 0xf8, 0x9f, 0xf0, 0x1f, 0xf0, 0x1f, 0xf8, 0x1f, 0xff, 0x1f, 0xff, 0x1f, 0xff, 0x1f, 0xfe, 0x0f, 0x0c, 0x00, 0x18, 0x00, 0x30, 0x00},
{ 0x00, 0x38, 0x00, 0x30, 0x80, 0x38, 0xf0, 0x78, 0xf0, 0x7f, 0xe0, 0xff, 0xf1, 0xbf, 0xff, 0xbf, 0xff, 0x1f, 0xff, 0x1f, 0xff, 0x1f, 0xfa, 0x0f, 0xe2, 0x0f, 0x04, 0x03, 0x04, 0x00, 0x00, 0x00},
{ 0x00, 0x00, 0x03, 0xc0, 0x43, 0xc2, 0xc3, 0xc3, 0xc7, 0xe3, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfd, 0xbf, 0xfd, 0xbf, 0xf9, 0x9f, 0xf1, 0x8f, 0xe1, 0x87, 0xc0, 0x03, 0x00, 0x00, 0x00, 0x00},
{ 0x1c, 0x00, 0x0c, 0x00, 0x1c, 0x01, 0x1e, 0x0f, 0xfe, 0x0f, 0xff, 0x07, 0xfd, 0x8f, 0xfd, 0xff, 0xf8, 0xff, 0xf8, 0xff, 0xf8, 0xff, 0xf0, 0x5f, 0xf0, 0x47, 0xc0, 0x20, 0x00, 0x20, 0x00, 0x00},
{ 0x70, 0x00, 0x78, 0x00, 0x7c, 0x00, 0xfe, 0x04, 0xfb, 0x0f, 0xf9, 0x1f, 0xf8, 0x0f, 0xf8, 0x0f, 0xf8, 0x1f, 0xf8, 0xff, 0xf8, 0xff, 0xf8, 0xff, 0xf0, 0x7f, 0x00, 0x30, 0x00, 0x18, 0x00, 0x0c},
{ 0xe0, 0x03, 0xf8, 0x01, 0xe6, 0x01, 0xf0, 0x01, 0xf0, 0x1b, 0xf8, 0x1f, 0xf8, 0x1f, 0xf8, 0x3f, 0xfc, 0x0f, 0xfc, 0x0f, 0xf8, 0x0f, 0xf8, 0xbf, 0xe0, 0xff, 0x00, 0xff, 0x00, 0x1c, 0x00, 0x07},
{ 0xf8, 0x7f, 0x00, 0x7f, 0xc0, 0x0f, 0xe0, 0x07, 0xf0, 0x07, 0xf8, 0x07, 0xfc, 0x3f, 0xfc, 0x1f, 0xfc, 0x1f, 0xfc, 0x3f, 0xf8, 0x07, 0xf0, 0x07, 0xe0, 0x07, 0xc0, 0x0f, 0x00, 0x7f, 0xf8, 0x7f},
{ 0x00, 0x07, 0x00, 0x1c, 0x00, 0xff, 0xe0, 0xff, 0xf8, 0xbf, 0xf8, 0x0f, 0xfc, 0x0f, 0xfc, 0x0f, 0xf8, 0x3f, 0xf8, 0x1f, 0xf8, 0x1f, 0xf0, 0x1b, 0xf0, 0x01, 0xe6, 0x01, 0xf8, 0x01, 0xe0, 0x03},
{ 0x00, 0x0c, 0x00, 0x18, 0x00, 0x30, 0xf0, 0x7f, 0xf8, 0xff, 0xf8, 0xff, 0xf8, 0xff, 0xf8, 0x1f, 0xf8, 0x0f, 0xf8, 0x0f, 0xf9, 0x1f, 0xfb, 0x0f, 0xfe, 0x04, 0x7c, 0x00, 0x78, 0x00, 0x70, 0x00},
{ 0x00, 0x00, 0x00, 0x20, 0xc0, 0x20, 0xf0, 0x47, 0xf0, 0x5f, 0xf8, 0xff, 0xf8, 0xff, 0xf8, 0xff, 0xfd, 0xff, 0xfd, 0x8f, 0xff, 0x07, 0xfe, 0x0f, 0x1e, 0x0f, 0x1c, 0x01, 0x0c, 0x00, 0x1c, 0x00}
},

/* BB */
{
{ 0x00, 0x00, 0x00, 0x00, 0xc0, 0x03, 0xe0, 0x07, 0xf1, 0x8f, 0xf9, 0x9f, 0xfd, 0xbf, 0xff, 0xff, 0xfd, 0xbf, 0xfd, 0xbf, 0xff, 0xff, 0xff, 0xff, 0xbf, 0xfd, 0x1b, 0xd8, 0x1b, 0xd8, 0x08, 0x10},
{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x03, 0xe2, 0x0f, 0xfe, 0x0f, 0xff, 0x1f, 0xfd, 0x1f, 0xff, 0x1f, 0xff, 0xbf, 0xff, 0xff, 0xff, 0xff, 0xee, 0x5f, 0x46, 0x7f, 0x00, 0x3f, 0x00, 0x3e, 0x00, 0x3b},
{ 0x10, 0x00, 0x18, 0x00, 0x0c, 0x00, 0xfe, 0x0f, 0xfb, 0x1f, 0xff, 0x1f, 0xff, 0x1f, 0xff, 0x1f, 0xff, 0x1f, 0xff, 0x1f, 0xf1, 0x1f, 0xf0, 0xdf, 0xc0, 0x7f, 0xc0, 0x37, 0xc0, 0x1f, 0xe0, 0x0f},
{ 0xe0, 0x00, 0x78, 0x00, 0xef, 0x00, 0xff, 0x07, 0xff, 0x1f, 0xfe, 0x1f, 0xff, 0x3f, 0xfd, 0x3f, 0xf0, 0x1f, 0xf8, 0x1f, 0xf0, 0x1f, 0xe0, 0x0f, 0xf0, 0x0f, 0xf8, 0x2f, 0xf8, 0x1d, 0xe0, 0x07},
{ 0xfe, 0x0f, 0x3e, 0x01, 0xf8, 0x03, 0xff, 0x07, 0xfe, 0x0f, 0xf8, 0x1f, 0xf0, 0x3f, 0xf8, 0x3f, 0xf8, 0x3f, 0xf0, 0x3f, 0xf8, 0x1f, 0xfe, 0x0f, 0xff, 0x07, 0xf8, 0x03, 0x3e, 0x01, 0xfe, 0x0f},
{ 0xe0, 0x07, 0xf8, 0x1d, 0xf8, 0x2f, 0xf0, 0x0f, 0xe0, 0x0f, 0xf0, 0x1f, 0xf8, 0x1f, 0xf0, 0x1f, 0xfd, 0x3f, 0xff, 0x3f, 0xfe, 0x1f, 0xff, 0x1f, 0xff, 0x07, 0xef, 0x00, 0x78, 0x00, 0xe0, 0x00},
{ 0xe0, 0x0f, 0xc0, 0x1f, 0xc0, 0x37, 0xc0, 0x7f, 0xf0, 0xdf, 0xf1, 0x1f, 0xff, 0x1f, 0xff, 0x1f, 0xff, 0x1f, 0xff, 0x1f, 0xff, 0x1f, 0xfb, 0x1f, 0xfe, 0x0f, 0x0c, 0x00, 0x18, 0x00, 0x10, 0x00},
{ 0x00, 0x3b, 0x00, 0x3e, 0x00, 0x3f, 0x46, 0x7f, 0xee, 0x5f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xbf, 0xff, 0x1f, 0xfd, 0x1f, 0xff, 0x1f, 0xfe, 0x0f, 0xe2, 0x0f, 0x04, 0x03, 0x00, 0x00, 0x00, 0x00},
{ 0x08, 0x10, 0x1b, 0xd8, 0x1b, 0xd8, 0xbf, 0xfd, 0xff, 0xff, 0xff, 0xff, 0xfd, 0xbf, 0xfd, 0xbf, 0xff, 0xff, 0xfd, 0xbf, 0xf9, 0x9f, 0xf1, 0x8f, 0xe0, 0x07, 0xc0, 0x03, 0x00, 0x00, 0x00, 0x00},
{ 0xdc, 0x00, 0x7c, 0x00, 0xfc, 0x00, 0xfe, 0x62, 0xfa, 0x77, 0xff, 0xff, 0xff, 0xff, 0xfd, 0xff, 0xf8, 0xff, 0xf8, 0xbf, 0xf8, 0xff, 0xf0, 0x7f, 0xf0, 0x47, 0xc0, 0x20, 0x00, 0x00, 0x00, 0x00},
{ 0xf0, 0x07, 0xf8, 0x03, 0xec, 0x03, 0xfe, 0x03, 0xfb, 0x0f, 0xf8, 0x8f, 0xf8, 0xff, 0xf8, 0xff, 0xf8, 0xff, 0xf8, 0xff, 0xf8, 0xff, 0xf8, 0xdf, 0xf0, 0x7f, 0x00, 0x30, 0x00, 0x18, 0x00, 0x08},
{ 0xe0, 0x07, 0xb8, 0x1f, 0xf4, 0x1f, 0xf0, 0x0f, 0xf0, 0x07, 0xf8, 0x0f, 0xf8, 0x1f, 0xf8, 0x0f, 0xfc, 0xbf, 0xfc, 0xff, 0xf8, 0x7f, 0xf8, 0xff, 0xe0, 0xff, 0x00, 0xf7, 0x00, 0x1e, 0x00, 0x07},
{ 0xf0, 0x7f, 0x80, 0x7c, 0xc0, 0x1f, 0xe0, 0xff, 0xf0, 0x7f, 0xf8, 0x1f, 0xfc, 0x0f, 0xfc, 0x1f, 0xfc, 0x1f, 0xfc, 0x0f, 0xf8, 0x1f, 0xf0, 0x7f, 0xe0, 0xff, 0xc0, 0x1f, 0x80, 0x7c, 0xf0, 0x7f},
{ 0x00, 0x07, 0x00, 0x1e, 0x00, 0xf7, 0xe0, 0xff, 0xf8, 0xff, 0xf8, 0x7f, 0xfc, 0xff, 0xfc, 0xbf, 0xf8, 0x0f, 0xf8, 0x1f, 0xf8, 0x0f, 0xf0, 0x07, 0xf0, 0x0f, 0xf4, 0x1f, 0xb8, 0x1f, 0xe0, 0x07},
{ 0x00, 0x08, 0x00, 0x18, 0x00, 0x30, 0xf0, 0x7f, 0xf8, 0xdf, 0xf8, 0xff, 0xf8, 0xff, 0xf8, 0xff, 0xf8, 0xff, 0xf8, 0xff, 0xf8, 0x8f, 0xfb, 0x0f, 0xfe, 0x03, 0xec, 0x03, 0xf8, 0x03, 0xf0, 0x07},
{ 0x00, 0x00, 0x00, 0x00, 0xc0, 0x20, 0xf0, 0x47, 0xf0, 0x7f, 0xf8, 0xff, 0xf8, 0xbf, 0xf8, 0xff, 0xfd, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfa, 0x77, 0xfe, 0x62, 0xfc, 0x00, 0x7c, 0x00, 0xdc, 0x00}
},
};


static char kli_bits[4][16][32] = {

/* CL */
{
{ 0x00, 0x00, 0x00, 0x00, 0x80, 0x01, 0xc0, 0x03, 0xc0, 0x03, 0x80, 0x01, 0x90, 0x09, 0x90, 0x09, 0x90, 0x09, 0xf0, 0x0f, 0xb0, 0x0d, 0x90, 0x09, 0x10, 0x08, 0x10, 0x08, 0x00, 0x00, 0x00, 0x00},
{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x07, 0x00, 0x07, 0x20, 0x07, 0x10, 0x03, 0x90, 0x01, 0xf8, 0x09, 0xd8, 0x09, 0xc8, 0x07, 0xc4, 0x06, 0x00, 0x02, 0x00, 0x02, 0x00, 0x02, 0x00, 0x00},
{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x40, 0x1e, 0x20, 0x1e, 0x30, 0x0f, 0xb8, 0x03, 0xe4, 0x01, 0xe2, 0x08, 0xe0, 0x07, 0x00, 0x03, 0x00, 0x01, 0x80, 0x00, 0x40, 0x00, 0x00, 0x00},
{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0x00, 0x30, 0x1c, 0x3e, 0x3e, 0xe0, 0x1f, 0xf0, 0x01, 0xf0, 0x00, 0x80, 0x04, 0xc0, 0x03, 0xe0, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00},
{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfc, 0x03, 0x60, 0x00, 0x40, 0x18, 0xf0, 0x3f, 0xf0, 0x3f, 0x40, 0x18, 0x60, 0x00, 0xfc, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
{ 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0xe0, 0x00, 0xc0, 0x03, 0x80, 0x04, 0xf0, 0x00, 0xf0, 0x01, 0xe0, 0x1f, 0x3e, 0x3e, 0x30, 0x1c, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
{ 0x00, 0x00, 0x40, 0x00, 0x80, 0x00, 0x00, 0x01, 0x00, 0x03, 0xe0, 0x07, 0xe2, 0x08, 0xe4, 0x01, 0xb8, 0x03, 0x30, 0x0f, 0x20, 0x1e, 0x40, 0x1e, 0x00, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
{ 0x00, 0x00, 0x00, 0x02, 0x00, 0x02, 0x00, 0x02, 0xc4, 0x06, 0xc8, 0x07, 0xd8, 0x09, 0xf8, 0x09, 0x90, 0x01, 0x10, 0x03, 0x20, 0x07, 0x00, 0x07, 0x00, 0x07, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00},
{ 0x00, 0x00, 0x00, 0x00, 0x10, 0x08, 0x10, 0x08, 0x90, 0x09, 0xb0, 0x0d, 0xf0, 0x0f, 0x90, 0x09, 0x90, 0x09, 0x90, 0x09, 0x80, 0x01, 0xc0, 0x03, 0xc0, 0x03, 0x80, 0x01, 0x00, 0x00, 0x00, 0x00},
{ 0x00, 0x00, 0x40, 0x00, 0x40, 0x00, 0x40, 0x00, 0x60, 0x23, 0xe0, 0x13, 0x90, 0x1b, 0x90, 0x1f, 0x80, 0x09, 0xc0, 0x08, 0xe0, 0x04, 0xe0, 0x00, 0xe0, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00},
{ 0x00, 0x00, 0x00, 0x02, 0x00, 0x01, 0x80, 0x00, 0xc0, 0x00, 0xe0, 0x07, 0x10, 0x47, 0x80, 0x27, 0xc0, 0x1d, 0xf0, 0x0c, 0x78, 0x04, 0x78, 0x02, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x07, 0xc0, 0x03, 0x20, 0x01, 0x00, 0x0f, 0x80, 0x0f, 0xf8, 0x07, 0x7c, 0x7c, 0x38, 0x0c, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0x3f, 0x00, 0x06, 0x18, 0x02, 0xfc, 0x0f, 0xfc, 0x0f, 0x18, 0x02, 0x00, 0x06, 0xc0, 0x3f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x38, 0x0c, 0x7c, 0x7c, 0xf8, 0x07, 0x80, 0x0f, 0x00, 0x0f, 0x20, 0x01, 0xc0, 0x03, 0x00, 0x07, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00},
{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x00, 0x78, 0x02, 0x78, 0x04, 0xf0, 0x0c, 0xc0, 0x1d, 0x80, 0x27, 0x10, 0x47, 0xe0, 0x07, 0xc0, 0x00, 0x80, 0x00, 0x00, 0x01, 0x00, 0x02, 0x00, 0x00},
{ 0x00, 0x00, 0x00, 0x00, 0x40, 0x00, 0xe0, 0x00, 0xe0, 0x00, 0xe0, 0x04, 0xc0, 0x08, 0x80, 0x09, 0x90, 0x1f, 0x90, 0x1b, 0xe0, 0x13, 0x60, 0x23, 0x40, 0x00, 0x40, 0x00, 0x40, 0x00, 0x00, 0x00}
},

/* CA */
{
{ 0x80, 0x01, 0xc0, 0x03, 0xe0, 0x07, 0xc0, 0x03, 0x80, 0x01, 0x80, 0x01, 0x80, 0x01, 0x84, 0x21, 0x84, 0x21, 0xfc, 0x3f, 0xfc, 0x3f, 0x8c, 0x31, 0x04, 0x20, 0x04, 0x20, 0x04, 0x20, 0x04, 0x20},
{ 0x00, 0x00, 0x00, 0x0f, 0x00, 0x0f, 0x00, 0x1f, 0x00, 0x0f, 0x00, 0x03, 0x04, 0x03, 0x8c, 0x01, 0xfe, 0x01, 0xfe, 0x21, 0xc3, 0x17, 0xc1, 0x1e, 0x01, 0x1c, 0x00, 0x08, 0x00, 0x08, 0x00, 0x04},
{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x10, 0x3c, 0x08, 0x3c, 0x0c, 0x3e, 0x1e, 0x07, 0xbf, 0x03, 0xf0, 0x01, 0xe0, 0x00, 0xe0, 0x01, 0x80, 0x13, 0x00, 0x0f, 0x00, 0x07, 0x00, 0x03, 0x00, 0x01},
{ 0x00, 0x00, 0x00, 0x00, 0x40, 0x00, 0x38, 0x10, 0x1e, 0x78, 0x39, 0x78, 0x30, 0x7e, 0xe0, 0x7f, 0xf0, 0x01, 0xf0, 0x00, 0xc0, 0x00, 0xc0, 0x00, 0xc0, 0x01, 0xc0, 0x03, 0xe0, 0x00, 0x38, 0x00},
{ 0x00, 0x00, 0x00, 0x00, 0xff, 0x01, 0x70, 0x00, 0x60, 0x00, 0x60, 0x20, 0x60, 0x70, 0xf0, 0xff, 0xf0, 0xff, 0x60, 0x70, 0x60, 0x20, 0x60, 0x00, 0x70, 0x00, 0xff, 0x01, 0x00, 0x00, 0x00, 0x00},
{ 0x38, 0x00, 0xe0, 0x00, 0xc0, 0x03, 0xc0, 0x01, 0xc0, 0x00, 0xc0, 0x00, 0xf0, 0x00, 0xf0, 0x01, 0xe0, 0x7f, 0x30, 0x7e, 0x39, 0x78, 0x1e, 0x78, 0x38, 0x10, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00},
{ 0x00, 0x01, 0x00, 0x03, 0x00, 0x07, 0x00, 0x0f, 0x80, 0x13, 0xe0, 0x01, 0xe0, 0x00, 0xf0, 0x01, 0xbf, 0x03, 0x1e, 0x07, 0x0c, 0x3e, 0x08, 0x3c, 0x10, 0x3c, 0x00, 0x3c, 0x00, 0x00, 0x00, 0x00},
{ 0x00, 0x04, 0x00, 0x08, 0x00, 0x08, 0x01, 0x1c, 0xc1, 0x1e, 0xc3, 0x17, 0xfe, 0x21, 0xfe, 0x01, 0x8c, 0x01, 0x04, 0x03, 0x00, 0x03, 0x00, 0x0f, 0x00, 0x1f, 0x00, 0x0f, 0x00, 0x0f, 0x00, 0x00},
{ 0x04, 0x20, 0x04, 0x20, 0x04, 0x20, 0x04, 0x20, 0x8c, 0x31, 0xfc, 0x3f, 0xfc, 0x3f, 0x84, 0x21, 0x84, 0x21, 0x80, 0x01, 0x80, 0x01, 0x80, 0x01, 0xc0, 0x03, 0xe0, 0x07, 0xc0, 0x03, 0x80, 0x01},
{ 0x20, 0x00, 0x10, 0x00, 0x10, 0x00, 0x38, 0x80, 0x78, 0x83, 0xe8, 0xc3, 0x84, 0x7f, 0x80, 0x7f, 0x80, 0x31, 0xc0, 0x20, 0xc0, 0x00, 0xf0, 0x00, 0xf8, 0x00, 0xf0, 0x00, 0xf0, 0x00, 0x00, 0x00},
{ 0x80, 0x00, 0xc0, 0x00, 0xe0, 0x00, 0xf0, 0x00, 0xc8, 0x01, 0x80, 0x07, 0x00, 0x07, 0x80, 0x0f, 0xc0, 0xfd, 0xe0, 0x78, 0x7c, 0x30, 0x3c, 0x10, 0x3c, 0x08, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00},
{ 0x00, 0x1c, 0x00, 0x07, 0xc0, 0x03, 0x80, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x0f, 0x80, 0x0f, 0xfe, 0x07, 0x7e, 0x0c, 0x1e, 0x9c, 0x1e, 0x78, 0x08, 0x1c, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00},
{ 0x00, 0x00, 0x00, 0x00, 0x80, 0xff, 0x00, 0x0e, 0x00, 0x06, 0x04, 0x06, 0x0e, 0x06, 0xff, 0x0f, 0xff, 0x0f, 0x0e, 0x06, 0x04, 0x06, 0x00, 0x06, 0x00, 0x0e, 0x80, 0xff, 0x00, 0x00, 0x00, 0x00},
{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x08, 0x1c, 0x1e, 0x78, 0x1e, 0x9c, 0x7e, 0x0c, 0xfe, 0x07, 0x80, 0x0f, 0x00, 0x0f, 0x00, 0x03, 0x00, 0x03, 0x80, 0x03, 0xc0, 0x03, 0x00, 0x07, 0x00, 0x1c},
{ 0x00, 0x00, 0x00, 0x00, 0x3c, 0x00, 0x3c, 0x08, 0x3c, 0x10, 0x7c, 0x30, 0xe0, 0x78, 0xc0, 0xfd, 0x80, 0x0f, 0x00, 0x07, 0x80, 0x07, 0xc8, 0x01, 0xf0, 0x00, 0xe0, 0x00, 0xc0, 0x00, 0x80, 0x00},
{ 0x00, 0x00, 0xf0, 0x00, 0xf0, 0x00, 0xf8, 0x00, 0xf0, 0x00, 0xc0, 0x00, 0xc0, 0x20, 0x80, 0x31, 0x80, 0x7f, 0x84, 0x7f, 0xe8, 0xc3, 0x78, 0x83, 0x38, 0x80, 0x10, 0x00, 0x10, 0x00, 0x20, 0x00}
},

/* BC */
{
{ 0x80, 0x01, 0xc0, 0x03, 0xe0, 0x07, 0xe0, 0x07, 0xc0, 0x03, 0x80, 0x01, 0x84, 0x21, 0x84, 0x21, 0x84, 0x21, 0xfc, 0x3f, 0xfc, 0x3f, 0xfc, 0x3f, 0x9c, 0x39, 0x8c, 0x31, 0x8c, 0x31, 0x04, 0x20},
{ 0x00, 0x00, 0x00, 0x0f, 0x80, 0x0f, 0x80, 0x1f, 0x08, 0x1f, 0x08, 0x07, 0x04, 0x03, 0x8c, 0x01, 0xfe, 0x21, 0xfe, 0x21, 0xff, 0x17, 0xe3, 0x1f, 0x63, 0x1f, 0x60, 0x0e, 0x20, 0x0e, 0x00, 0x06},
{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x10, 0x3e, 0x08, 0x3e, 0x0c, 0x3e, 0x1e, 0x3f, 0xbf, 0x03, 0xff, 0x01, 0xf1, 0x00, 0xf0, 0x01, 0xf8, 0x13, 0x98, 0x0f, 0x80, 0x07, 0x80, 0x03, 0xc0, 0x01},
{ 0x00, 0x00, 0x00, 0x00, 0xc0, 0x00, 0x38, 0x18, 0x1e, 0x78, 0x3f, 0x7c, 0x3f, 0x7e, 0xf8, 0x7f, 0xf0, 0x31, 0xfc, 0x00, 0xfe, 0x00, 0xe0, 0x00, 0xe0, 0x0d, 0xe0, 0x03, 0xf8, 0x00, 0x38, 0x00},
{ 0x00, 0x00, 0x00, 0x00, 0xff, 0x03, 0x7e, 0x00, 0x78, 0x00, 0x70, 0x30, 0x70, 0x78, 0xfe, 0xff, 0xfe, 0xff, 0x70, 0x78, 0x70, 0x30, 0x78, 0x00, 0x7e, 0x00, 0xff, 0x03, 0x00, 0x00, 0x00, 0x00},
{ 0x38, 0x00, 0xf8, 0x00, 0xe0, 0x03, 0xe0, 0x0d, 0xe0, 0x00, 0xfe, 0x00, 0xfc, 0x00, 0xf0, 0x31, 0xf8, 0x7f, 0x3f, 0x7e, 0x3f, 0x7c, 0x1e, 0x78, 0x38, 0x18, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00},
{ 0xc0, 0x01, 0x80, 0x03, 0x80, 0x07, 0x98, 0x0f, 0xf8, 0x13, 0xf0, 0x01, 0xf1, 0x00, 0xff, 0x01, 0xbf, 0x03, 0x1e, 0x3f, 0x0c, 0x3e, 0x08, 0x3e, 0x10, 0x3e, 0x00, 0x3e, 0x00, 0x00, 0x00, 0x00},
{ 0x00, 0x06, 0x20, 0x0e, 0x60, 0x0e, 0x63, 0x1f, 0xe3, 0x1f, 0xff, 0x17, 0xfe, 0x21, 0xfe, 0x21, 0x8c, 0x01, 0x04, 0x03, 0x08, 0x07, 0x08, 0x1f, 0x80, 0x1f, 0x80, 0x0f, 0x00, 0x0f, 0x00, 0x00},
{ 0x04, 0x20, 0x8c, 0x31, 0x8c, 0x31, 0x9c, 0x39, 0xfc, 0x3f, 0xfc, 0x3f, 0xfc, 0x3f, 0x84, 0x21, 0x84, 0x21, 0x84, 0x21, 0x80, 0x01, 0xc0, 0x03, 0xe0, 0x07, 0xe0, 0x07, 0xc0, 0x03, 0x80, 0x01},
{ 0x60, 0x00, 0x70, 0x04, 0x70, 0x06, 0xf8, 0xc6, 0xf8, 0xc7, 0xe8, 0xff, 0x84, 0x7f, 0x84, 0x7f, 0x80, 0x31, 0xc0, 0x20, 0xe0, 0x10, 0xf8, 0x10, 0xf8, 0x01, 0xf0, 0x01, 0xf0, 0x00, 0x00, 0x00},
{ 0x80, 0x03, 0xc0, 0x01, 0xe0, 0x01, 0xf0, 0x19, 0xc8, 0x1f, 0x80, 0x0f, 0x00, 0x8f, 0x80, 0xff, 0xc0, 0xfd, 0xfc, 0x78, 0x7c, 0x30, 0x7c, 0x10, 0x7c, 0x08, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x00},
{ 0x00, 0x1c, 0x00, 0x1f, 0xc0, 0x07, 0xb0, 0x07, 0x00, 0x07, 0x00, 0x7f, 0x00, 0x3f, 0x8c, 0x0f, 0xfe, 0x1f, 0x7e, 0xfc, 0x3e, 0xfc, 0x1e, 0x78, 0x18, 0x1c, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00},
{ 0x00, 0x00, 0x00, 0x00, 0xc0, 0xff, 0x00, 0x7e, 0x00, 0x1e, 0x0c, 0x0e, 0x1e, 0x0e, 0xff, 0x7f, 0xff, 0x7f, 0x1e, 0x0e, 0x0c, 0x0e, 0x00, 0x1e, 0x00, 0x7e, 0xc0, 0xff, 0x00, 0x00, 0x00, 0x00},
{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x18, 0x1c, 0x1e, 0x78, 0x3e, 0xfc, 0x7e, 0xfc, 0xfe, 0x1f, 0x8c, 0x0f, 0x00, 0x3f, 0x00, 0x7f, 0x00, 0x07, 0xb0, 0x07, 0xc0, 0x07, 0x00, 0x1f, 0x00, 0x1c},
{ 0x00, 0x00, 0x00, 0x00, 0x7c, 0x00, 0x7c, 0x08, 0x7c, 0x10, 0x7c, 0x30, 0xfc, 0x78, 0xc0, 0xfd, 0x80, 0xff, 0x00, 0x8f, 0x80, 0x0f, 0xc8, 0x1f, 0xf0, 0x19, 0xe0, 0x01, 0xc0, 0x01, 0x80, 0x03},
{ 0x00, 0x00, 0xf0, 0x00, 0xf0, 0x01, 0xf8, 0x01, 0xf8, 0x10, 0xe0, 0x10, 0xc0, 0x20, 0x80, 0x31, 0x84, 0x7f, 0x84, 0x7f, 0xe8, 0xff, 0xf8, 0xc7, 0xf8, 0xc6, 0x70, 0x06, 0x70, 0x04, 0x60, 0x00}
},

/* BB */
{
{ 0xc0, 0x03, 0xf0, 0x0f, 0xf0, 0x0f, 0xe1, 0x87, 0xc1, 0x83, 0xc3, 0xc3, 0x83, 0xc1, 0x87, 0xe1, 0xc7, 0xe3, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xcf, 0xf3, 0xc3, 0xc3, 0x43, 0xc2},
{ 0x80, 0x07, 0x84, 0x1f, 0x84, 0x1f, 0x86, 0x3f, 0x86, 0x3f, 0x87, 0x07, 0x07, 0x07, 0x8f, 0x01, 0xff, 0xc1, 0xff, 0xe3, 0xff, 0xf7, 0xfb, 0x7f, 0xf0, 0x7f, 0xf0, 0x3f, 0x68, 0x3e, 0x40, 0x3c},
{ 0x30, 0x00, 0x18, 0x1e, 0x1c, 0x3e, 0x1e, 0x7e, 0x0f, 0x7e, 0x0f, 0x7f, 0x1f, 0x7f, 0xff, 0x07, 0xff, 0x01, 0xfc, 0x01, 0xf8, 0x81, 0xfc, 0xf3, 0xfe, 0x7f, 0xd8, 0x3f, 0x88, 0x1f, 0x80, 0x0f},
{ 0xe0, 0x00, 0xf8, 0x00, 0x7f, 0x18, 0x3f, 0x78, 0x1f, 0x78, 0x3f, 0xfe, 0x7e, 0xfe, 0xfc, 0xff, 0xfc, 0xfd, 0xff, 0x00, 0xfe, 0x00, 0xfc, 0x00, 0xf2, 0x01, 0xe0, 0x7f, 0xf0, 0x1f, 0xf0, 0x07},
{ 0xff, 0x1f, 0xff, 0x07, 0xfc, 0x01, 0x7c, 0x00, 0x78, 0x60, 0x78, 0x70, 0xff, 0xfc, 0xfe, 0xff, 0xfe, 0xff, 0xff, 0xfc, 0x78, 0x70, 0x78, 0x60, 0x7c, 0x00, 0xfc, 0x01, 0xff, 0x07, 0xff, 0x1f},
{ 0xf0, 0x07, 0xf0, 0x1f, 0xe0, 0x7f, 0xf2, 0x01, 0xfc, 0x00, 0xfe, 0x00, 0xff, 0x00, 0xfc, 0xfd, 0xfc, 0xff, 0x7e, 0xfe, 0x3f, 0xfe, 0x1f, 0x78, 0x3f, 0x78, 0x7f, 0x18, 0xf8, 0x00, 0xe0, 0x00},
{ 0x80, 0x0f, 0x88, 0x1f, 0xd8, 0x3f, 0xfe, 0x7f, 0xfc, 0xf3, 0xf8, 0x81, 0xfc, 0x01, 0xff, 0x01, 0xff, 0x07, 0x1f, 0x7f, 0x0f, 0x7f, 0x0f, 0x7e, 0x1e, 0x7e, 0x1c, 0x3e, 0x18, 0x1e, 0x30, 0x00},
{ 0x40, 0x3c, 0x68, 0x3e, 0xf0, 0x3f, 0xf0, 0x7f, 0xfb, 0x7f, 0xff, 0xf7, 0xff, 0xe3, 0xff, 0xc1, 0x8f, 0x01, 0x07, 0x07, 0x87, 0x07, 0x86, 0x3f, 0x86, 0x3f, 0x84, 0x1f, 0x84, 0x1f, 0x80, 0x07},
{ 0x43, 0xc2, 0xc3, 0xc3, 0xcf, 0xf3, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc7, 0xe3, 0x87, 0xe1, 0x83, 0xc1, 0xc3, 0xc3, 0xc1, 0x83, 0xe1, 0x87, 0xf0, 0x0f, 0xf0, 0x0f, 0xc0, 0x03},
{ 0x3c, 0x02, 0x7c, 0x16, 0xfc, 0x0f, 0xfe, 0x0f, 0xfe, 0xdf, 0xef, 0xff, 0xc7, 0xff, 0x83, 0xff, 0x80, 0xf1, 0xe0, 0xe0, 0xe0, 0xe1, 0xfc, 0x61, 0xfc, 0x61, 0xf8, 0x21, 0xf8, 0x21, 0xe0, 0x01},
{ 0xf0, 0x01, 0xf8, 0x11, 0xfc, 0x1b, 0xfe, 0x7f, 0xcf, 0x3f, 0x81, 0x1f, 0x80, 0x3f, 0x80, 0xff, 0xe0, 0xff, 0xfe, 0xf8, 0xfe, 0xf0, 0x7e, 0xf0, 0x7e, 0x78, 0x7c, 0x38, 0x78, 0x18, 0x00, 0x0c},
{ 0xe0, 0x0f, 0xf8, 0x0f, 0xfe, 0x07, 0x80, 0x4f, 0x00, 0x3f, 0x00, 0x7f, 0x00, 0xff, 0xbf, 0x3f, 0xff, 0x3f, 0x7f, 0x7e, 0x7f, 0xfc, 0x1e, 0xf8, 0x1e, 0xfc, 0x18, 0xfe, 0x00, 0x1f, 0x00, 0x07},
{ 0xf8, 0xff, 0xe0, 0xff, 0x80, 0x3f, 0x00, 0x3e, 0x06, 0x1e, 0x0e, 0x1e, 0x3f, 0xff, 0xff, 0x7f, 0xff, 0x7f, 0x3f, 0xff, 0x0e, 0x1e, 0x06, 0x1e, 0x00, 0x3e, 0x80, 0x3f, 0xe0, 0xff, 0xf8, 0xff},
{ 0x00, 0x07, 0x00, 0x1f, 0x18, 0xfe, 0x1e, 0xfc, 0x1e, 0xf8, 0x7f, 0xfc, 0x7f, 0x7e, 0xff, 0x3f, 0xbf, 0x3f, 0x00, 0xff, 0x00, 0x7f, 0x00, 0x3f, 0x80, 0x4f, 0xfe, 0x07, 0xf8, 0x0f, 0xe0, 0x0f},
{ 0x00, 0x0c, 0x78, 0x18, 0x7c, 0x38, 0x7e, 0x78, 0x7e, 0xf0, 0xfe, 0xf0, 0xfe, 0xf8, 0xe0, 0xff, 0x80, 0xff, 0x80, 0x3f, 0x81, 0x1f, 0xcf, 0x3f, 0xfe, 0x7f, 0xfc, 0x1b, 0xf8, 0x11, 0xf0, 0x01},
{ 0xe0, 0x01, 0xf8, 0x21, 0xf8, 0x21, 0xfc, 0x61, 0xfc, 0x61, 0xe0, 0xe1, 0xe0, 0xe0, 0x80, 0xf1, 0x83, 0xff, 0xc7, 0xff, 0xef, 0xff, 0xfe, 0xdf, 0xfe, 0x0f, 0xfc, 0x0f, 0x7c, 0x16, 0x3c, 0x02}
}
};


static char ori_bits[4][16][32] = {

/* CL */
{
{ 0x00, 0x00, 0x00, 0x00, 0x80, 0x01, 0xc0, 0x03, 0x80, 0x01, 0x80, 0x01, 0x80, 0x01, 0xc0, 0x03, 0xe0, 0x07, 0xf0, 0x0f, 0xb0, 0x0d, 0x30, 0x0c, 0x30, 0x0c, 0x30, 0x0c, 0x00, 0x00, 0x00, 0x00},
{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x07, 0x00, 0x07, 0x00, 0x03, 0x80, 0x03, 0xf0, 0x03, 0xf8, 0x03, 0xd8, 0x03, 0xd8, 0x07, 0x0c, 0x06, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x00},
{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x00, 0x1c, 0x00, 0x1e, 0xf0, 0x07, 0xf8, 0x03, 0xfc, 0x03, 0xce, 0x03, 0x80, 0x03, 0x80, 0x03, 0xc0, 0x01, 0xc0, 0x00, 0x40, 0x00, 0x00, 0x00},
{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x18, 0xfe, 0x3f, 0xee, 0x1f, 0xe0, 0x03, 0xe0, 0x01, 0x80, 0x01, 0xe0, 0x01, 0xf0, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00},
{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x00, 0xfc, 0x00, 0xc0, 0x11, 0xe0, 0x3f, 0xe0, 0x3f, 0xc0, 0x11, 0xfc, 0x00, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
{ 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0xf0, 0x00, 0xe0, 0x01, 0x80, 0x01, 0xe0, 0x01, 0xe0, 0x03, 0xee, 0x1f, 0xfe, 0x3f, 0x30, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
{ 0x00, 0x00, 0x40, 0x00, 0xc0, 0x00, 0xc0, 0x01, 0x80, 0x03, 0x80, 0x03, 0xce, 0x03, 0xfc, 0x03, 0xf8, 0x03, 0xf0, 0x07, 0x00, 0x1e, 0x00, 0x1c, 0x00, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
{ 0x00, 0x00, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x0c, 0x06, 0xd8, 0x07, 0xd8, 0x03, 0xf8, 0x03, 0xf0, 0x03, 0x80, 0x03, 0x00, 0x03, 0x00, 0x07, 0x00, 0x07, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00},
{ 0x00, 0x00, 0x00, 0x00, 0x30, 0x0c, 0x30, 0x0c, 0x30, 0x0c, 0xb0, 0x0d, 0xf0, 0x0f, 0xe0, 0x07, 0xc0, 0x03, 0x80, 0x01, 0x80, 0x01, 0x80, 0x01, 0xc0, 0x03, 0x80, 0x01, 0x00, 0x00, 0x00, 0x00},
{ 0x00, 0x00, 0xc0, 0x00, 0xc0, 0x00, 0xc0, 0x00, 0x60, 0x30, 0xe0, 0x1b, 0xc0, 0x1b, 0xc0, 0x1f, 0xc0, 0x0f, 0xc0, 0x01, 0xc0, 0x00, 0xe0, 0x00, 0xe0, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00},
{ 0x00, 0x00, 0x00, 0x02, 0x00, 0x03, 0x80, 0x03, 0xc0, 0x01, 0xc0, 0x01, 0xc0, 0x73, 0xc0, 0x3f, 0xc0, 0x1f, 0xe0, 0x0f, 0x78, 0x00, 0x38, 0x00, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x0f, 0x80, 0x07, 0x80, 0x01, 0x80, 0x07, 0xc0, 0x07, 0xf8, 0x77, 0xfc, 0x7f, 0x18, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x00, 0x3f, 0x88, 0x03, 0xfc, 0x07, 0xfc, 0x07, 0x88, 0x03, 0x00, 0x3f, 0x00, 0x3e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x0c, 0xfc, 0x7f, 0xf8, 0x77, 0xc0, 0x07, 0x80, 0x07, 0x80, 0x01, 0x80, 0x07, 0x00, 0x0f, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00},
{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x00, 0x38, 0x00, 0x78, 0x00, 0xe0, 0x0f, 0xc0, 0x1f, 0xc0, 0x3f, 0xc0, 0x73, 0xc0, 0x01, 0xc0, 0x01, 0x80, 0x03, 0x00, 0x03, 0x00, 0x02, 0x00, 0x00},
{ 0x00, 0x00, 0x00, 0x00, 0x40, 0x00, 0xe0, 0x00, 0xe0, 0x00, 0xc0, 0x00, 0xc0, 0x01, 0xc0, 0x0f, 0xc0, 0x1f, 0xc0, 0x1b, 0xe0, 0x1b, 0x60, 0x30, 0xc0, 0x00, 0xc0, 0x00, 0xc0, 0x00, 0x00, 0x00}
},

/* CA */
{
{ 0x80, 0x01, 0xc0, 0x03, 0xc0, 0x03, 0x80, 0x01, 0x80, 0x01, 0x80, 0x01, 0xc0, 0x03, 0xe0, 0x07, 0xf0, 0x0f, 0xf8, 0x1f, 0xdc, 0x3b, 0x8c, 0x31, 0x8c, 0x31, 0x8c, 0x31, 0x8c, 0x31, 0x8c, 0x31},
{ 0x00, 0x00, 0x00, 0x0e, 0x00, 0x0f, 0x00, 0x0e, 0x00, 0x07, 0x80, 0x03, 0xe0, 0x03, 0xf8, 0x07, 0xfe, 0x07, 0xee, 0x07, 0xc7, 0x0f, 0xe3, 0x0c, 0x63, 0x0c, 0x61, 0x0c, 0x30, 0x0c, 0x00, 0x06},
{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x00, 0x3c, 0x00, 0x3c, 0x90, 0x1f, 0xfe, 0x07, 0xff, 0x07, 0xe3, 0x07, 0xe1, 0x03, 0xf0, 0x03, 0x38, 0x07, 0x1c, 0x03, 0x0c, 0x03, 0x80, 0x03, 0xc0, 0x01},
{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x70, 0xff, 0x79, 0xe1, 0x7f, 0xe0, 0x2f, 0xf0, 0x07, 0xfc, 0x03, 0xde, 0x03, 0x82, 0x01, 0xc0, 0x01, 0xe0, 0x00, 0xf8, 0x00, 0x3c, 0x00},
{ 0x00, 0x00, 0x00, 0x00, 0x3f, 0x00, 0x7f, 0x00, 0xe0, 0x00, 0xc0, 0x01, 0xe0, 0x63, 0xff, 0xff, 0xff, 0xff, 0xe0, 0x63, 0xc0, 0x01, 0xe0, 0x00, 0x7f, 0x00, 0x3f, 0x00, 0x00, 0x00, 0x00, 0x00},
{ 0x3c, 0x00, 0xf8, 0x00, 0xe0, 0x00, 0xc0, 0x01, 0x82, 0x01, 0xde, 0x03, 0xfc, 0x03, 0xf0, 0x07, 0xe0, 0x2f, 0xe1, 0x7f, 0xff, 0x79, 0x3e, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
{ 0xc0, 0x01, 0x80, 0x03, 0x0c, 0x03, 0x1c, 0x03, 0x38, 0x07, 0xf0, 0x03, 0xe1, 0x03, 0xe3, 0x07, 0xff, 0x07, 0xfe, 0x07, 0x90, 0x1f, 0x00, 0x3c, 0x00, 0x3c, 0x00, 0x38, 0x00, 0x00, 0x00, 0x00},
{ 0x00, 0x06, 0x30, 0x0c, 0x61, 0x0c, 0x63, 0x0c, 0xe3, 0x0c, 0xc7, 0x0f, 0xee, 0x07, 0xfe, 0x07, 0xf8, 0x07, 0xe0, 0x03, 0x80, 0x03, 0x00, 0x07, 0x00, 0x0e, 0x00, 0x0f, 0x00, 0x0e, 0x00, 0x00},
{ 0x8c, 0x31, 0x8c, 0x31, 0x8c, 0x31, 0x8c, 0x31, 0x8c, 0x31, 0xdc, 0x3b, 0xf8, 0x1f, 0xf0, 0x0f, 0xe0, 0x07, 0xc0, 0x03, 0x80, 0x01, 0x80, 0x01, 0x80, 0x01, 0xc0, 0x03, 0xc0, 0x03, 0x80, 0x01},
{ 0x60, 0x00, 0x30, 0x0c, 0x30, 0x86, 0x30, 0xc6, 0x30, 0xc7, 0xf0, 0xe3, 0xe0, 0x77, 0xe0, 0x7f, 0xe0, 0x1f, 0xc0, 0x07, 0xc0, 0x01, 0xe0, 0x00, 0x70, 0x00, 0xf0, 0x00, 0x70, 0x00, 0x00, 0x00},
{ 0x80, 0x03, 0xc0, 0x01, 0xc0, 0x30, 0xc0, 0x38, 0xe0, 0x1c, 0xc0, 0x0f, 0xc0, 0x87, 0xe0, 0xc7, 0xe0, 0xff, 0xe0, 0x7f, 0xf8, 0x09, 0x3c, 0x00, 0x3c, 0x00, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00},
{ 0x00, 0x3c, 0x00, 0x1f, 0x00, 0x07, 0x80, 0x03, 0x80, 0x41, 0xc0, 0x7b, 0xc0, 0x3f, 0xe0, 0x0f, 0xf4, 0x07, 0xfe, 0x87, 0x9e, 0xff, 0x0e, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
{ 0x00, 0x00, 0x00, 0x00, 0x00, 0xfc, 0x00, 0xfe, 0x00, 0x07, 0x80, 0x03, 0xc6, 0x07, 0xff, 0xff, 0xff, 0xff, 0xc6, 0x07, 0x80, 0x03, 0x00, 0x07, 0x00, 0xfe, 0x00, 0xfc, 0x00, 0x00, 0x00, 0x00},
{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x7c, 0x9e, 0xff, 0xfe, 0x87, 0xf4, 0x07, 0xe0, 0x0f, 0xc0, 0x3f, 0xc0, 0x7b, 0x80, 0x41, 0x80, 0x03, 0x00, 0x07, 0x00, 0x1f, 0x00, 0x3c},
{ 0x00, 0x00, 0x00, 0x00, 0x1c, 0x00, 0x3c, 0x00, 0x3c, 0x00, 0xf8, 0x09, 0xe0, 0x7f, 0xe0, 0xff, 0xe0, 0xc7, 0xc0, 0x87, 0xc0, 0x0f, 0xe0, 0x1c, 0xc0, 0x38, 0xc0, 0x30, 0xc0, 0x01, 0x80, 0x03},
{ 0x00, 0x00, 0x70, 0x00, 0xf0, 0x00, 0x70, 0x00, 0xe0, 0x00, 0xc0, 0x01, 0xc0, 0x07, 0xe0, 0x1f, 0xe0, 0x7f, 0xe0, 0x77, 0xf0, 0xe3, 0x30, 0xc7, 0x30, 0xc6, 0x30, 0x86, 0x30, 0x0c, 0x60, 0x00}
},

/* BC */
{
{ 0x80, 0x01, 0xc0, 0x03, 0xe0, 0x07, 0xc0, 0x03, 0x80, 0x01, 0x80, 0x01, 0xc0, 0x03, 0xe0, 0x07, 0xf4, 0x2f, 0xfc, 0x3f, 0xfc, 0x3f, 0xcc, 0x33, 0xe4, 0x27, 0x64, 0x26, 0x64, 0x26, 0x64, 0x26},
{ 0x00, 0x00, 0x00, 0x0f, 0x00, 0x0f, 0x00, 0x1f, 0x00, 0x0f, 0x80, 0x03, 0xe4, 0x03, 0xfc, 0x07, 0xfe, 0x07, 0xfe, 0x07, 0xe3, 0x1f, 0xf9, 0x1f, 0xf9, 0x1d, 0x9c, 0x09, 0xc8, 0x09, 0xc0, 0x04},
{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x00, 0x3c, 0x08, 0x3c, 0x9c, 0x3f, 0xfe, 0x07, 0xff, 0x07, 0xf0, 0x07, 0xfc, 0x03, 0xfe, 0x03, 0xf6, 0x07, 0x62, 0x0f, 0x70, 0x07, 0x38, 0x03, 0x00, 0x01},
{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x10, 0x3e, 0x78, 0xf9, 0x79, 0xf0, 0x7f, 0xfe, 0x7f, 0xff, 0x07, 0xfb, 0x03, 0xf8, 0x03, 0xdc, 0x01, 0xde, 0x01, 0xc4, 0x03, 0xe0, 0x00, 0x38, 0x00},
{ 0x00, 0x00, 0x00, 0x00, 0xff, 0x00, 0x70, 0x00, 0xe0, 0x00, 0xef, 0x21, 0xff, 0x73, 0xf8, 0xff, 0xf8, 0xff, 0xff, 0x73, 0xef, 0x21, 0xe0, 0x00, 0x70, 0x00, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00},
{ 0x38, 0x00, 0xe0, 0x00, 0xc4, 0x03, 0xde, 0x01, 0xdc, 0x01, 0xf8, 0x03, 0xfb, 0x03, 0xff, 0x07, 0xfe, 0x7f, 0xf0, 0x7f, 0xf9, 0x79, 0x3e, 0x78, 0x38, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
{ 0x00, 0x01, 0x38, 0x03, 0x70, 0x07, 0x62, 0x0f, 0xf6, 0x07, 0xfe, 0x03, 0xfc, 0x03, 0xf0, 0x07, 0xff, 0x07, 0xfe, 0x07, 0x9c, 0x3f, 0x08, 0x3c, 0x00, 0x3c, 0x00, 0x3c, 0x00, 0x00, 0x00, 0x00},
{ 0xc0, 0x04, 0xc8, 0x09, 0x9c, 0x09, 0xf9, 0x1d, 0xf9, 0x1f, 0xe3, 0x1f, 0xfe, 0x07, 0xfe, 0x07, 0xfc, 0x07, 0xe4, 0x03, 0x80, 0x03, 0x00, 0x0f, 0x00, 0x1f, 0x00, 0x0f, 0x00, 0x0f, 0x00, 0x00},
{ 0x64, 0x26, 0x64, 0x26, 0x64, 0x26, 0xe4, 0x27, 0xcc, 0x33, 0xfc, 0x3f, 0xfc, 0x3f, 0xf4, 0x2f, 0xe0, 0x07, 0xc0, 0x03, 0x80, 0x01, 0x80, 0x01, 0xc0, 0x03, 0xe0, 0x07, 0xc0, 0x03, 0x80, 0x01},
{ 0x20, 0x03, 0x90, 0x13, 0x90, 0x39, 0xb8, 0x9f, 0xf8, 0x9f, 0xf8, 0xc7, 0xe0, 0x7f, 0xe0, 0x7f, 0xe0, 0x3f, 0xc0, 0x27, 0xc0, 0x01, 0xf0, 0x00, 0xf8, 0x00, 0xf0, 0x00, 0xf0, 0x00, 0x00, 0x00},
{ 0x80, 0x00, 0xc0, 0x1c, 0xe0, 0x0e, 0xf0, 0x46, 0xe0, 0x6f, 0xc0, 0x7f, 0xc0, 0x3f, 0xe0, 0x0f, 0xe0, 0xff, 0xe0, 0x7f, 0xfc, 0x39, 0x3c, 0x10, 0x3c, 0x00, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00},
{ 0x00, 0x1c, 0x00, 0x07, 0xc0, 0x23, 0x80, 0x7b, 0x80, 0x3b, 0xc0, 0x1f, 0xc0, 0xdf, 0xe0, 0xff, 0xfe, 0x7f, 0xfe, 0x0f, 0x9e, 0x9f, 0x1e, 0x7c, 0x08, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
{ 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x00, 0x0e, 0x00, 0x07, 0x84, 0xf7, 0xce, 0xff, 0xff, 0x1f, 0xff, 0x1f, 0xce, 0xff, 0x84, 0xf7, 0x00, 0x07, 0x00, 0x0e, 0x00, 0xff, 0x00, 0x00, 0x00, 0x00},
{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x1c, 0x1e, 0x7c, 0x9e, 0x9f, 0xfe, 0x0f, 0xfe, 0x7f, 0xe0, 0xff, 0xc0, 0xdf, 0xc0, 0x1f, 0x80, 0x3b, 0x80, 0x7b, 0xc0, 0x23, 0x00, 0x07, 0x00, 0x1c},
{ 0x00, 0x00, 0x00, 0x00, 0x3c, 0x00, 0x3c, 0x00, 0x3c, 0x10, 0xfc, 0x39, 0xe0, 0x7f, 0xe0, 0xff, 0xe0, 0x0f, 0xc0, 0x3f, 0xc0, 0x7f, 0xe0, 0x6f, 0xf0, 0x46, 0xe0, 0x0e, 0xc0, 0x1c, 0x80, 0x00},
{ 0x00, 0x00, 0xf0, 0x00, 0xf0, 0x00, 0xf8, 0x00, 0xf0, 0x00, 0xc0, 0x01, 0xc0, 0x27, 0xe0, 0x3f, 0xe0, 0x7f, 0xe0, 0x7f, 0xf8, 0xc7, 0xf8, 0x9f, 0xb8, 0x9f, 0x90, 0x39, 0x90, 0x13, 0x20, 0x03}
},

/* BB */
{
{ 0x80, 0x01, 0xc0, 0x03, 0xd0, 0x0b, 0xf0, 0x0f, 0xf0, 0x0f, 0xc0, 0x03, 0xe2, 0x47, 0xf2, 0x4f, 0xfa, 0x5f, 0xfe, 0x7f, 0xfe, 0x7f, 0xfe, 0x7f, 0xee, 0x77, 0xe6, 0x67, 0x66, 0x66, 0x66, 0x66},
{ 0x00, 0x00, 0x40, 0x0e, 0xc0, 0x0f, 0xc0, 0x0f, 0x84, 0x3f, 0xc6, 0x1f, 0xfa, 0x07, 0xfe, 0x07, 0xff, 0x0f, 0xff, 0x4f, 0xff, 0x7f, 0xf9, 0x3f, 0xf9, 0x3f, 0xdc, 0x1d, 0xc8, 0x1d, 0xc0, 0x0c},
{ 0x00, 0x00, 0x00, 0x02, 0x10, 0x3b, 0x08, 0x3f, 0x04, 0x3f, 0xfe, 0x1f, 0xff, 0x7f, 0xff, 0x3f, 0xf8, 0x07, 0xfc, 0x07, 0xfe, 0x07, 0xfe, 0x27, 0xf2, 0x17, 0x70, 0x0f, 0x38, 0x07, 0x00, 0x03},
{ 0x00, 0x00, 0x60, 0x00, 0x38, 0x08, 0x3e, 0x0c, 0xff, 0x7c, 0xff, 0x7f, 0xf8, 0x7f, 0xfe, 0x3f, 0xff, 0x3f, 0xff, 0x77, 0xf8, 0x03, 0xfc, 0x03, 0xfe, 0x03, 0xe4, 0x0d, 0xe0, 0x07, 0xf8, 0x00},
{ 0x00, 0x00, 0xff, 0x03, 0x7f, 0x00, 0xf8, 0x00, 0xf0, 0x39, 0xff, 0x1b, 0xff, 0x7f, 0xfc, 0xff, 0xfc, 0xff, 0xff, 0x7f, 0xff, 0x1b, 0xf0, 0x39, 0xf8, 0x00, 0x7f, 0x00, 0xff, 0x03, 0x00, 0x00},
{ 0xf8, 0x00, 0xe0, 0x07, 0xe4, 0x0d, 0xfe, 0x03, 0xfc, 0x03, 0xf8, 0x03, 0xff, 0x77, 0xff, 0x3f, 0xfe, 0x3f, 0xf8, 0x7f, 0xff, 0x7f, 0xff, 0x7c, 0x3e, 0x0c, 0x38, 0x08, 0x60, 0x00, 0x00, 0x00},
{ 0x00, 0x03, 0x38, 0x07, 0x70, 0x0f, 0xf2, 0x17, 0xfe, 0x27, 0xfe, 0x07, 0xfc, 0x07, 0xf8, 0x07, 0xff, 0x3f, 0xff, 0x7f, 0xfe, 0x1f, 0x04, 0x3f, 0x08, 0x3f, 0x10, 0x3b, 0x00, 0x02, 0x00, 0x00},
{ 0xc0, 0x0c, 0xc8, 0x1d, 0xdc, 0x1d, 0xf9, 0x3f, 0xf9, 0x3f, 0xff, 0x7f, 0xff, 0x4f, 0xff, 0x0f, 0xfe, 0x07, 0xfa, 0x07, 0xc6, 0x1f, 0x84, 0x3f, 0xc0, 0x0f, 0xc0, 0x0f, 0x40, 0x0e, 0x00, 0x00},
{ 0x66, 0x66, 0x66, 0x66, 0xe6, 0x67, 0xee, 0x77, 0xfe, 0x7f, 0xfe, 0x7f, 0xfe, 0x7f, 0xfa, 0x5f, 0xf2, 0x4f, 0xe2, 0x47, 0xc0, 0x03, 0xf0, 0x0f, 0xf0, 0x0f, 0xd0, 0x0b, 0xc0, 0x03, 0x80, 0x01},
{ 0x30, 0x03, 0xb8, 0x13, 0xb8, 0x3b, 0xfc, 0x9f, 0xfc, 0x9f, 0xfe, 0xff, 0xf2, 0xff, 0xf0, 0xff, 0xe0, 0x7f, 0xe0, 0x5f, 0xf8, 0x63, 0xfc, 0x21, 0xf0, 0x03, 0xf0, 0x03, 0x70, 0x02, 0x00, 0x00},
{ 0xc0, 0x00, 0xe0, 0x1c, 0xf0, 0x0e, 0xe8, 0x4f, 0xe4, 0x7f, 0xe0, 0x7f, 0xe0, 0x3f, 0xe0, 0x1f, 0xfc, 0xff, 0xfe, 0xff, 0xf8, 0x7f, 0xfc, 0x20, 0xfc, 0x10, 0xdc, 0x08, 0x40, 0x00, 0x00, 0x00},
{ 0x00, 0x1f, 0xe0, 0x07, 0xb0, 0x27, 0xc0, 0x7f, 0xc0, 0x3f, 0xc0, 0x1f, 0xee, 0xff, 0xfc, 0xff, 0xfc, 0x7f, 0xfe, 0x1f, 0xfe, 0xff, 0x3e, 0xff, 0x30, 0x7c, 0x10, 0x1c, 0x00, 0x06, 0x00, 0x00},
{ 0x00, 0x00, 0xc0, 0xff, 0x00, 0xfe, 0x00, 0x1f, 0x9c, 0x0f, 0xd8, 0xff, 0xfe, 0xff, 0xff, 0x3f, 0xff, 0x3f, 0xfe, 0xff, 0xd8, 0xff, 0x9c, 0x0f, 0x00, 0x1f, 0x00, 0xfe, 0xc0, 0xff, 0x00, 0x00},
{ 0x00, 0x00, 0x00, 0x06, 0x10, 0x1c, 0x30, 0x7c, 0x3e, 0xff, 0xfe, 0xff, 0xfe, 0x1f, 0xfc, 0x7f, 0xfc, 0xff, 0xee, 0xff, 0xc0, 0x1f, 0xc0, 0x3f, 0xc0, 0x7f, 0xb0, 0x27, 0xe0, 0x07, 0x00, 0x1f},
{ 0x00, 0x00, 0x40, 0x00, 0xdc, 0x08, 0xfc, 0x10, 0xfc, 0x20, 0xf8, 0x7f, 0xfe, 0xff, 0xfc, 0xff, 0xe0, 0x1f, 0xe0, 0x3f, 0xe0, 0x7f, 0xe4, 0x7f, 0xe8, 0x4f, 0xf0, 0x0e, 0xe0, 0x1c, 0xc0, 0x00},
{ 0x00, 0x00, 0x70, 0x02, 0xf0, 0x03, 0xf0, 0x03, 0xfc, 0x21, 0xf8, 0x63, 0xe0, 0x5f, 0xe0, 0x7f, 0xf0, 0xff, 0xf2, 0xff, 0xfe, 0xff, 0xfc, 0x9f, 0xfc, 0x9f, 0xb8, 0x3b, 0xb8, 0x13, 0x30, 0x03}
},
};


static char ind_bits[3][16][32] = {

/* orbiter */
{
{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x01, 0x80, 0x01, 0xc0, 0x03, 0xc0, 0x03, 0xe0, 0x07, 0xe0, 0x07, 0xf0, 0x0f, 0xf0, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x80, 0x03, 0xc0, 0x03, 0xe0, 0x03, 0xf0, 0x03, 0xf8, 0x03, 0xf0, 0x03, 0xc0, 0x07, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0xe0, 0x07, 0xf8, 0x07, 0xf8, 0x03, 0xf0, 0x03, 0xe0, 0x03, 0xc0, 0x01, 0x80, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0xf8, 0x0f, 0xf8, 0x0f, 0xf0, 0x07, 0xf0, 0x03, 0xe0, 0x01, 0xe0, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x00, 0xf0, 0x00, 0xf0, 0x03, 0xf0, 0x0f, 0xf0, 0x0f, 0xf0, 0x03, 0xf0, 0x00, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x00, 0xe0, 0x00, 0xe0, 0x01, 0xf0, 0x03, 0xf0, 0x07, 0xf8, 0x0f, 0xf8, 0x0f, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x01, 0xc0, 0x01, 0xe0, 0x03, 0xf0, 0x03, 0xf8, 0x03, 0xf8, 0x07, 0xe0, 0x07, 0x00, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0xc0, 0x07, 0xf0, 0x03, 0xf8, 0x03, 0xf0, 0x03, 0xe0, 0x03, 0xc0, 0x03, 0x80, 0x03, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf0, 0x0f, 0xf0, 0x0f, 0xe0, 0x07, 0xe0, 0x07, 0xc0, 0x03, 0xc0, 0x03, 0x80, 0x01, 0x80, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0x00, 0xe0, 0x03, 0xc0, 0x0f, 0xc0, 0x1f, 0xc0, 0x0f, 0xc0, 0x07, 0xc0, 0x03, 0xc0, 0x01, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x01, 0x80, 0x03, 0xc0, 0x07, 0xc0, 0x0f, 0xc0, 0x1f, 0xe0, 0x1f, 0xe0, 0x07, 0xe0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x07, 0x80, 0x07, 0xc0, 0x0f, 0xe0, 0x0f, 0xf0, 0x1f, 0xf0, 0x1f, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x00, 0x0f, 0xc0, 0x0f, 0xf0, 0x0f, 0xf0, 0x0f, 0xc0, 0x0f, 0x00, 0x0f, 0x00, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0xf0, 0x1f, 0xf0, 0x1f, 0xe0, 0x0f, 0xc0, 0x0f, 0x80, 0x07, 0x00, 0x07, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xe0, 0x00, 0xe0, 0x07, 0xe0, 0x1f, 0xc0, 0x1f, 0xc0, 0x0f, 0xc0, 0x07, 0x80, 0x03, 0x80, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0x00, 0xc0, 0x01, 0xc0, 0x03, 0xc0, 0x07, 0xc0, 0x0f, 0xc0, 0x1f, 0xc0, 0x0f, 0xe0, 0x03, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
},

/* Base */
{
{ 0xe0, 0x07, 0xf8, 0x1f, 0xbc, 0x3d, 0x8e, 0x79, 0x86, 0x61, 0x87, 0xe1, 0xc3, 0xc3, 0xff, 0xff, 0xff, 0xff, 0xc3, 0xc3, 0x87, 0xe1, 0x86, 0x61, 0x8e, 0x71, 0xbc, 0x3d, 0xf8, 0x1f, 0xe0, 0x07},
{ 0xe0, 0x07, 0xf8, 0x1f, 0x1c, 0x3e, 0x0e, 0x76, 0x06, 0x77, 0x9f, 0xe3, 0xff, 0xc3, 0xf3, 0xc7, 0xe3, 0xcf, 0xc3, 0xff, 0xc3, 0xf9, 0xe6, 0x60, 0x6e, 0x70, 0x7c, 0x38, 0xf8, 0x1f, 0xe0, 0x07},
{ 0xc0, 0x03, 0xf8, 0x1f, 0x3c, 0x3c, 0x1e, 0x78, 0x3e, 0x7c, 0xf6, 0x6f, 0xe3, 0xe7, 0xe3, 0xe7, 0xe3, 0xc7, 0xe3, 0xc7, 0xf6, 0x6f, 0x3e, 0x7c, 0x1e, 0x78, 0x3c, 0x3c, 0xf8, 0x1f, 0xc0, 0x03},
{ 0xe0, 0x07, 0xf8, 0x1f, 0x7c, 0x38, 0x6e, 0x70, 0xe6, 0x60, 0xc3, 0xf9, 0xc3, 0xff, 0xe3, 0xcf, 0xf3, 0xe7, 0xff, 0xe3, 0x9f, 0xe3, 0x06, 0x67, 0x0e, 0x76, 0x1c, 0x3e, 0xf8, 0x1f, 0xe0, 0x07},
{ 0xe0, 0x07, 0xf8, 0x1f, 0xbc, 0x3d, 0x8e, 0x71, 0x86, 0x61, 0x87, 0xe1, 0xc3, 0xc3, 0xff, 0xff, 0xff, 0xff, 0xc3, 0xc3, 0x87, 0xe1, 0x86, 0x71, 0x8e, 0x71, 0xbc, 0x3d, 0xf8, 0x1f, 0xe0, 0x07},
{ 0xe0, 0x07, 0xf8, 0x1f, 0x1c, 0x3e, 0x0e, 0x76, 0x06, 0x67, 0x9f, 0xc3, 0xff, 0xc3, 0xf3, 0xc7, 0xe3, 0xcf, 0xc3, 0xff, 0xc3, 0xf9, 0xe6, 0x60, 0x6e, 0x78, 0x7c, 0x3c, 0xf8, 0x1f, 0xe0, 0x07},
{ 0xc0, 0x03, 0xf8, 0x1f, 0x3c, 0x3c, 0x1e, 0x78, 0x3e, 0x7c, 0xf6, 0x6f, 0xe3, 0xc7, 0xe3, 0xc7, 0xe3, 0xc7, 0xe3, 0xc7, 0xf6, 0x6f, 0x3e, 0x7c, 0x1e, 0x78, 0x3c, 0x3f, 0xf8, 0x1f, 0xc0, 0x03},
{ 0xe0, 0x07, 0xf8, 0x1f, 0x7c, 0x38, 0x6e, 0x70, 0xe6, 0x60, 0xc3, 0xf9, 0xc3, 0xff, 0xe3, 0xcf, 0xf3, 0xc7, 0xff, 0xc3, 0x9f, 0xc3, 0x06, 0x67, 0x0e, 0x76, 0xfc, 0x3e, 0xf8, 0x1f, 0xe0, 0x07},
{ 0xe0, 0x07, 0xf8, 0x1f, 0xbc, 0x3d, 0x8e, 0x71, 0x86, 0x61, 0x87, 0xe1, 0xc3, 0xc3, 0xff, 0xff, 0xff, 0xff, 0xc3, 0xc3, 0x87, 0xe1, 0x86, 0x61, 0x9e, 0x71, 0xbc, 0x3d, 0xf8, 0x1f, 0xe0, 0x07},
{ 0xe0, 0x07, 0xf8, 0x1f, 0x1c, 0x3e, 0x0e, 0x76, 0x06, 0x67, 0x9f, 0xc3, 0xff, 0xc3, 0xf3, 0xc7, 0xe3, 0xcf, 0xc3, 0xff, 0xc7, 0xf9, 0xee, 0x60, 0x6e, 0x70, 0x7c, 0x38, 0xf8, 0x1f, 0xe0, 0x07},
{ 0xc0, 0x03, 0xf8, 0x1f, 0x3c, 0x3c, 0x1e, 0x78, 0x3e, 0x7c, 0xf6, 0x6f, 0xe3, 0xc7, 0xe3, 0xc7, 0xe7, 0xc7, 0xe7, 0xc7, 0xf6, 0x6f, 0x3e, 0x7c, 0x1e, 0x78, 0x3c, 0x3c, 0xf8, 0x1f, 0xc0, 0x03},
{ 0xe0, 0x07, 0xf8, 0x1f, 0x7c, 0x38, 0x6e, 0x70, 0xe6, 0x60, 0xc7, 0xf9, 0xc7, 0xff, 0xe7, 0xcf, 0xf3, 0xc7, 0xff, 0xc3, 0x9f, 0xc3, 0x06, 0x67, 0x0e, 0x76, 0x1c, 0x3e, 0xf8, 0x1f, 0xe0, 0x07},
{ 0xe0, 0x07, 0xf8, 0x1f, 0xbc, 0x3d, 0x8e, 0x71, 0x8e, 0x61, 0x87, 0xe1, 0xc3, 0xc3, 0xff, 0xff, 0xff, 0xff, 0xc3, 0xc3, 0x87, 0xe1, 0x86, 0x61, 0x8e, 0x71, 0xbc, 0x3d, 0xf8, 0x1f, 0xe0, 0x07},
{ 0xe0, 0x07, 0xf8, 0x1f, 0x3c, 0x3e, 0x1e, 0x76, 0x06, 0x67, 0x9f, 0xc3, 0xff, 0xc3, 0xf3, 0xc7, 0xe3, 0xcf, 0xc3, 0xff, 0xc3, 0xf9, 0xe6, 0x60, 0x6e, 0x70, 0x7c, 0x38, 0xf8, 0x1f, 0xe0, 0x07},
{ 0xc0, 0x03, 0xf8, 0x1f, 0xfc, 0x3c, 0x1e, 0x78, 0x3e, 0x7c, 0xf6, 0x6f, 0xe3, 0xc7, 0xe3, 0xc7, 0xe3, 0xc7, 0xe3, 0xc7, 0xf6, 0x6f, 0x3e, 0x7c, 0x1e, 0x78, 0x3c, 0x3c, 0xf8, 0x1f, 0xc0, 0x03},
{ 0xe0, 0x07, 0xf8, 0x1f, 0x7c, 0x3f, 0x6e, 0x70, 0xe6, 0x60, 0xc3, 0xf9, 0xc3, 0xff, 0xe3, 0xcf, 0xf3, 0xc7, 0xff, 0xc3, 0x9f, 0xc3, 0x06, 0x67, 0x0e, 0x76, 0x1c, 0x3e, 0xf8, 0x1f, 0xe0, 0x07}
},

/* Starbase */
{
{ 0x44, 0x22, 0xce, 0x73, 0xff, 0xff, 0xfe, 0x7f, 0xfc, 0x3f, 0xfc, 0x3f, 0x7f, 0xfe, 0xbe, 0x7d, 0xbe, 0x7d, 0x7f, 0xfe, 0xfc, 0x3f, 0xfc, 0x3f, 0xfe, 0x7f, 0xff, 0xff, 0xce, 0x73, 0x44, 0x22},
{ 0x78, 0x02, 0xf8, 0x17, 0xf0, 0x0f, 0xfa, 0xdf, 0xfc, 0xff, 0xfe, 0xff, 0xff, 0xfe, 0xbe, 0x7f, 0xfe, 0x7d, 0x7f, 0xff, 0xff, 0x7f, 0xff, 0x3f, 0xfb, 0x5f, 0xf0, 0x0f, 0xe8, 0x1f, 0x40, 0x1e},
{ 0xc0, 0x03, 0xc8, 0x13, 0xf8, 0x1f, 0xfe, 0x7f, 0xfc, 0x3f, 0xfc, 0x3f, 0x7f, 0xfe, 0xbf, 0xfd, 0xbf, 0xfd, 0x7f, 0xfe, 0xfc, 0x3f, 0xfc, 0x3f, 0xfe, 0x7f, 0xf8, 0x1f, 0xc8, 0x13, 0xc0, 0x03},
{ 0x40, 0x1e, 0xe8, 0x1f, 0xf0, 0x0f, 0xfb, 0x5f, 0xff, 0x3f, 0xff, 0x7f, 0x7f, 0xff, 0xfe, 0x7d, 0xbe, 0x7f, 0xff, 0xfe, 0xfe, 0xff, 0xfc, 0xff, 0xfa, 0xdf, 0xf0, 0x0f, 0xf8, 0x17, 0x78, 0x02},
{ 0x44, 0x22, 0xce, 0x73, 0xff, 0xff, 0xfe, 0x7f, 0xfc, 0x3f, 0xfc, 0x3f, 0x7f, 0xfe, 0xbe, 0x7d, 0xbe, 0x7d, 0x7f, 0xfe, 0xfc, 0x3f, 0xfc, 0x3f, 0xfe, 0x7f, 0xff, 0xff, 0xce, 0x73, 0x44, 0x22},
{ 0x78, 0x02, 0xf8, 0x17, 0xf0, 0x0f, 0xfa, 0xdf, 0xfc, 0xff, 0xfe, 0xff, 0xff, 0xfe, 0xbe, 0x7f, 0xfe, 0x7d, 0x7f, 0xff, 0xff, 0x7f, 0xff, 0x3f, 0xfb, 0x5f, 0xf0, 0x0f, 0xe8, 0x1f, 0x40, 0x1e},
{ 0xc0, 0x03, 0xc8, 0x13, 0xf8, 0x1f, 0xfe, 0x7f, 0xfc, 0x3f, 0xfc, 0x3f, 0x7f, 0xfe, 0xbf, 0xfd, 0xbf, 0xfd, 0x7f, 0xfe, 0xfc, 0x3f, 0xfc, 0x3f, 0xfe, 0x7f, 0xf8, 0x1f, 0xc8, 0x13, 0xc0, 0x03},
{ 0x40, 0x1e, 0xe8, 0x1f, 0xf0, 0x0f, 0xfb, 0x5f, 0xff, 0x3f, 0xff, 0x7f, 0x7f, 0xff, 0xfe, 0x7d, 0xbe, 0x7f, 0xff, 0xfe, 0xfe, 0xff, 0xfc, 0xff, 0xfa, 0xdf, 0xf0, 0x0f, 0xf8, 0x17, 0x78, 0x02},
{ 0x44, 0x22, 0xce, 0x73, 0xff, 0xff, 0xfe, 0x7f, 0xfc, 0x3f, 0xfc, 0x3f, 0x7f, 0xfe, 0xbe, 0x7d, 0xbe, 0x7d, 0x7f, 0xfe, 0xfc, 0x3f, 0xfc, 0x3f, 0xfe, 0x7f, 0xff, 0xff, 0xce, 0x73, 0x44, 0x22},
{ 0x78, 0x02, 0xf8, 0x17, 0xf0, 0x0f, 0xfa, 0xdf, 0xfc, 0xff, 0xfe, 0xff, 0xff, 0xfe, 0xbe, 0x7f, 0xfe, 0x7d, 0x7f, 0xff, 0xff, 0x7f, 0xff, 0x3f, 0xfb, 0x5f, 0xf0, 0x0f, 0xe8, 0x1f, 0x40, 0x1e},
{ 0xc0, 0x03, 0xc8, 0x13, 0xf8, 0x1f, 0xfe, 0x7f, 0xfc, 0x3f, 0xfc, 0x3f, 0x7f, 0xfe, 0xbf, 0xfd, 0xbf, 0xfd, 0x7f, 0xfe, 0xfc, 0x3f, 0xfc, 0x3f, 0xfe, 0x7f, 0xf8, 0x1f, 0xc8, 0x13, 0xc0, 0x03},
{ 0x40, 0x1e, 0xe8, 0x1f, 0xf0, 0x0f, 0xfb, 0x5f, 0xff, 0x3f, 0xff, 0x7f, 0x7f, 0xff, 0xfe, 0x7d, 0xbe, 0x7f, 0xff, 0xfe, 0xfe, 0xff, 0xfc, 0xff, 0xfa, 0xdf, 0xf0, 0x0f, 0xf8, 0x17, 0x78, 0x02},
{ 0x44, 0x22, 0xce, 0x73, 0xff, 0xff, 0xfe, 0x7f, 0xfc, 0x3f, 0xfc, 0x3f, 0x7f, 0xfe, 0xbe, 0x7d, 0xbe, 0x7d, 0x7f, 0xfe, 0xfc, 0x3f, 0xfc, 0x3f, 0xfe, 0x7f, 0xff, 0xff, 0xce, 0x73, 0x44, 0x22},
{ 0x78, 0x02, 0xf8, 0x17, 0xf0, 0x0f, 0xfa, 0xdf, 0xfc, 0xff, 0xfe, 0xff, 0xff, 0xfe, 0xbe, 0x7f, 0xfe, 0x7d, 0x7f, 0xff, 0xff, 0x7f, 0xff, 0x3f, 0xfb, 0x5f, 0xf0, 0x0f, 0xe8, 0x1f, 0x40, 0x1e},
{ 0xc0, 0x03, 0xc8, 0x13, 0xf8, 0x1f, 0xfe, 0x7f, 0xfc, 0x3f, 0xfc, 0x3f, 0x7f, 0xfe, 0xbf, 0xfd, 0xbf, 0xfd, 0x7f, 0xfe, 0xfc, 0x3f, 0xfc, 0x3f, 0xfe, 0x7f, 0xf8, 0x1f, 0xc8, 0x13, 0xc0, 0x03},
{ 0x40, 0x1e, 0xe8, 0x1f, 0xf0, 0x0f, 0xfb, 0x5f, 0xff, 0x3f, 0xff, 0x7f, 0x7f, 0xff, 0xfe, 0x7d, 0xbe, 0x7f, 0xff, 0xfe, 0xfe, 0xff, 0xfc, 0xff, 0xfa, 0xdf, 0xf0, 0x0f, 0xf8, 0x17, 0x78, 0x02}
}
};



static char jgr_bits[6][16][32] = {

/* FF */
{
{ 0x00, 0x00, 0x00, 0x00, 0x80, 0x01, 0x80, 0x01, 0xc0, 0x03, 0xc0, 0x03, 0xe0, 0x07, 0xe0, 0x07, 0xf0, 0x0f, 0xf0, 0x0f, 0xf8, 0x1f, 0xf0, 0x0f, 0xe0, 0x07, 0x80, 0x01, 0x00, 0x00, 0x00, 0x00},
{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x06, 0x80, 0x07, 0xc0, 0x07, 0xe0, 0x07, 0xf0, 0x07, 0xf8, 0x07, 0xf8, 0x07, 0xf8, 0x07, 0xf0, 0x07, 0xe0, 0x07, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00},
{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x1e, 0xc0, 0x0f, 0xf8, 0x0f, 0xf8, 0x07, 0xf8, 0x07, 0xf8, 0x07, 0xf8, 0x03, 0xf8, 0x03, 0xf0, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf8, 0x1f, 0xf8, 0x3f, 0xf8, 0x0f, 0xf8, 0x0f, 0xfc, 0x07, 0xf8, 0x03, 0xf0, 0x01, 0xe0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x00, 0xf0, 0x00, 0xf8, 0x03, 0xf8, 0x0f, 0xfc, 0x3f, 0xfc, 0x3f, 0xf8, 0x0f, 0xf8, 0x03, 0xf0, 0x00, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xe0, 0x00, 0xf0, 0x01, 0xf8, 0x03, 0xfc, 0x07, 0xf8, 0x0f, 0xf8, 0x0f, 0xf8, 0x3f, 0xf8, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf0, 0x03, 0xf8, 0x03, 0xf8, 0x03, 0xf8, 0x07, 0xf8, 0x07, 0xf8, 0x07, 0xf8, 0x0f, 0xc0, 0x0f, 0x00, 0x1e, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
{ 0x00, 0x00, 0x00, 0x00, 0x40, 0x00, 0xe0, 0x07, 0xf0, 0x07, 0xf8, 0x07, 0xf8, 0x07, 0xf8, 0x07, 0xf0, 0x07, 0xe0, 0x07, 0xc0, 0x07, 0x80, 0x07, 0x00, 0x06, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00},
{ 0x00, 0x00, 0x00, 0x00, 0x80, 0x01, 0xe0, 0x07, 0xf0, 0x0f, 0xf8, 0x1f, 0xf0, 0x0f, 0xf0, 0x0f, 0xe0, 0x07, 0xe0, 0x07, 0xc0, 0x03, 0xc0, 0x03, 0x80, 0x01, 0x80, 0x01, 0x00, 0x00, 0x00, 0x00},
{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xe0, 0x07, 0xe0, 0x0f, 0xe0, 0x1f, 0xe0, 0x1f, 0xe0, 0x1f, 0xe0, 0x0f, 0xe0, 0x07, 0xe0, 0x03, 0xe0, 0x01, 0x60, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00},
{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0x0f, 0xc0, 0x1f, 0xc0, 0x1f, 0xe0, 0x1f, 0xe0, 0x1f, 0xe0, 0x1f, 0xf0, 0x1f, 0xf0, 0x03, 0x78, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x80, 0x0f, 0xc0, 0x1f, 0xe0, 0x3f, 0xf0, 0x1f, 0xf0, 0x1f, 0xfc, 0x1f, 0xf8, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x0f, 0xc0, 0x1f, 0xf0, 0x1f, 0xfc, 0x3f, 0xfc, 0x3f, 0xf0, 0x1f, 0xc0, 0x1f, 0x00, 0x0f, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf8, 0x1f, 0xfc, 0x1f, 0xf0, 0x1f, 0xf0, 0x1f, 0xe0, 0x3f, 0xc0, 0x1f, 0x80, 0x0f, 0x00, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x78, 0x00, 0xf0, 0x03, 0xf0, 0x1f, 0xe0, 0x1f, 0xe0, 0x1f, 0xe0, 0x1f, 0xc0, 0x1f, 0xc0, 0x1f, 0xc0, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
{ 0x00, 0x00, 0x00, 0x00, 0x40, 0x00, 0x60, 0x00, 0xe0, 0x01, 0xe0, 0x03, 0xe0, 0x07, 0xe0, 0x0f, 0xe0, 0x1f, 0xe0, 0x1f, 0xe0, 0x1f, 0xe0, 0x0f, 0xe0, 0x07, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00}
},

/* CL */
{
{ 0x00, 0x00, 0x02, 0x40, 0x02, 0x40, 0x06, 0x60, 0x0e, 0x70, 0x0e, 0x70, 0x9e, 0x79, 0x9e, 0x79, 0xfe, 0x7f, 0xfe, 0x7f, 0xfe, 0x7f, 0xfe, 0x7f, 0x1e, 0x78, 0x1e, 0x78, 0x0e, 0x70, 0x0e, 0x70},
{ 0x10, 0x00, 0x18, 0x00, 0x18, 0x00, 0x3c, 0x00, 0x1c, 0x00, 0x3e, 0x80, 0x3e, 0xe1, 0xfe, 0xf1, 0xff, 0x79, 0xff, 0x7f, 0xff, 0x7f, 0xc7, 0x3f, 0x03, 0x3f, 0x01, 0x1e, 0x00, 0x1e, 0x00, 0x0e},
{ 0xc0, 0x00, 0xe0, 0x00, 0xf0, 0x00, 0x78, 0x00, 0x7c, 0x00, 0x3e, 0x00, 0x3f, 0x01, 0xff, 0x03, 0xff, 0xe1, 0xf3, 0xf9, 0xe0, 0x7f, 0xc0, 0x3f, 0x80, 0x1f, 0x80, 0x0f, 0xc0, 0x07, 0xc0, 0x03},
{ 0x00, 0x07, 0xe0, 0x03, 0xf8, 0x03, 0xfe, 0x01, 0xff, 0x00, 0x7f, 0x00, 0x7f, 0x00, 0xf8, 0x03, 0xf0, 0x01, 0xf0, 0x01, 0xe0, 0x17, 0xe0, 0xff, 0xe0, 0x7f, 0xf0, 0x1f, 0xf8, 0x07, 0xfc, 0x00},
{ 0x00, 0x00, 0xff, 0x7f, 0xff, 0x1f, 0xff, 0x0f, 0xfc, 0x03, 0xf0, 0x00, 0xf0, 0x00, 0xf0, 0x03, 0xf0, 0x03, 0xf0, 0x00, 0xf0, 0x00, 0xfc, 0x03, 0xff, 0x0f, 0xff, 0x1f, 0xff, 0x7f, 0x00, 0x00},
{ 0xfc, 0x00, 0xf8, 0x07, 0xf0, 0x1f, 0xe0, 0x7f, 0xe0, 0xff, 0xe0, 0x17, 0xf0, 0x01, 0xf0, 0x01, 0xf8, 0x03, 0x7f, 0x00, 0x7f, 0x00, 0xff, 0x00, 0xfe, 0x01, 0xf8, 0x03, 0xe0, 0x03, 0x00, 0x07},
{ 0xc0, 0x03, 0xc0, 0x07, 0x80, 0x0f, 0x80, 0x1f, 0xc0, 0x3f, 0xe0, 0x7f, 0xf3, 0xf9, 0xff, 0xe1, 0xff, 0x03, 0x3f, 0x01, 0x3e, 0x00, 0x7c, 0x00, 0x78, 0x00, 0xf0, 0x00, 0xe0, 0x00, 0xc0, 0x00},
{ 0x00, 0x0e, 0x00, 0x1e, 0x01, 0x1e, 0x03, 0x3f, 0xc7, 0x3f, 0xff, 0x7f, 0xff, 0x7f, 0xff, 0x79, 0xfe, 0xf1, 0x3e, 0xe1, 0x3e, 0x80, 0x1c, 0x00, 0x3c, 0x00, 0x18, 0x00, 0x18, 0x00, 0x10, 0x00},
{ 0x0e, 0x70, 0x0e, 0x70, 0x1e, 0x78, 0x1e, 0x78, 0xfe, 0x7f, 0xfe, 0x7f, 0xfe, 0x7f, 0xfe, 0x7f, 0x9e, 0x79, 0x9e, 0x79, 0x0e, 0x70, 0x0e, 0x70, 0x06, 0x60, 0x02, 0x40, 0x02, 0x40, 0x00, 0x00},
{ 0x70, 0x00, 0x78, 0x00, 0x78, 0x80, 0xfc, 0xc0, 0xfc, 0xe3, 0xfe, 0xff, 0xfe, 0xff, 0x9e, 0xff, 0x8f, 0x7f, 0x87, 0x7c, 0x01, 0x7c, 0x00, 0x38, 0x00, 0x3c, 0x00, 0x18, 0x00, 0x18, 0x00, 0x08},
{ 0xc0, 0x03, 0xe0, 0x03, 0xf0, 0x01, 0xf8, 0x01, 0xfc, 0x03, 0xfe, 0x07, 0xdf, 0xcf, 0x87, 0xff, 0xc0, 0xff, 0x80, 0xfc, 0x00, 0x7c, 0x00, 0x3e, 0x00, 0x1e, 0x00, 0x0f, 0x00, 0x07, 0x00, 0x03},
{ 0x00, 0x3f, 0xe0, 0x1f, 0xf8, 0x0f, 0xfe, 0x07, 0xff, 0x07, 0xe8, 0x07, 0x80, 0x0f, 0x80, 0x0f, 0xc0, 0x1f, 0x00, 0xfe, 0x00, 0xfe, 0x00, 0xff, 0x80, 0x7f, 0xc0, 0x1f, 0xc0, 0x07, 0xe0, 0x00},
{ 0x00, 0x00, 0xfe, 0xff, 0xf8, 0xff, 0xf0, 0xff, 0xc0, 0x3f, 0x00, 0x0f, 0x00, 0x0f, 0xc0, 0x0f, 0xc0, 0x0f, 0x00, 0x0f, 0x00, 0x0f, 0xc0, 0x3f, 0xf0, 0xff, 0xf8, 0xff, 0xfe, 0xff, 0x00, 0x00},
{ 0xe0, 0x00, 0xc0, 0x07, 0xc0, 0x1f, 0x80, 0x7f, 0x00, 0xff, 0x00, 0xfe, 0x00, 0xfe, 0xc0, 0x1f, 0x80, 0x0f, 0x80, 0x0f, 0xe8, 0x07, 0xff, 0x07, 0xfe, 0x07, 0xf8, 0x0f, 0xe0, 0x1f, 0x00, 0x3f},
{ 0x00, 0x03, 0x00, 0x07, 0x00, 0x0f, 0x00, 0x1e, 0x00, 0x3e, 0x00, 0x7c, 0x80, 0xfe, 0xc0, 0xff, 0x87, 0xff, 0xdf, 0xcf, 0xfe, 0x07, 0xfc, 0x03, 0xf8, 0x01, 0xf0, 0x01, 0xe0, 0x03, 0xc0, 0x03},
{ 0x00, 0x08, 0x00, 0x18, 0x00, 0x18, 0x00, 0x3c, 0x00, 0x38, 0x01, 0x7c, 0x87, 0x7c, 0x8f, 0x7f, 0x9e, 0xff, 0xfe, 0xff, 0xfe, 0xff, 0xfc, 0xe3, 0xfc, 0xc0, 0x78, 0x80, 0x78, 0x00, 0x70, 0x00}
},

/* CA */
{
{ 0x80, 0x01, 0x80, 0x01, 0xc0, 0x03, 0xc0, 0x03, 0xe0, 0x07, 0xe0, 0x07, 0xf0, 0x0f, 0xf0, 0x0f, 0xfa, 0x5f, 0xfa, 0x5f, 0xfe, 0x7f, 0xfe, 0x7f, 0xf2, 0x4f, 0x30, 0x0c, 0x30, 0x0c, 0x00, 0x00},
{ 0x00, 0x00, 0x00, 0x0c, 0x00, 0x0f, 0x80, 0x0f, 0xc0, 0x0f, 0xe0, 0x0f, 0xfa, 0x0f, 0xfa, 0x0f, 0xff, 0x0f, 0xff, 0x0f, 0xfc, 0x0f, 0xfc, 0x2f, 0xcc, 0x3f, 0x00, 0x1f, 0x80, 0x13, 0x00, 0x01},
{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x00, 0x3e, 0xc4, 0x1f, 0xfe, 0x1f, 0xff, 0x1f, 0xfc, 0x0f, 0xfc, 0x0f, 0xfe, 0x0f, 0xfe, 0x07, 0xf0, 0x07, 0xe0, 0x07, 0xe0, 0x0f, 0x60, 0x06, 0x00, 0x02},
{ 0x00, 0x00, 0x00, 0x00, 0x18, 0x00, 0x0e, 0x00, 0xfc, 0x7f, 0xfc, 0x7f, 0xfe, 0x3f, 0xff, 0x3f, 0xfa, 0x1f, 0xf8, 0x0f, 0xf0, 0x07, 0xf0, 0x03, 0xf8, 0x03, 0xf8, 0x00, 0xc0, 0x03, 0xc0, 0x00},
{ 0x00, 0x00, 0xf8, 0x00, 0x30, 0x00, 0xf0, 0x00, 0xfe, 0x03, 0xfe, 0x0f, 0xf8, 0x3f, 0xf8, 0xff, 0xf8, 0xff, 0xf8, 0x3f, 0xfe, 0x0f, 0xfe, 0x03, 0xf0, 0x00, 0x30, 0x00, 0xf8, 0x00, 0x00, 0x00},
{ 0xc0, 0x00, 0xc0, 0x03, 0xf8, 0x00, 0xf8, 0x03, 0xf0, 0x03, 0xf0, 0x07, 0xf8, 0x0f, 0xfa, 0x1f, 0xff, 0x3f, 0xfe, 0x3f, 0xfc, 0x7f, 0xfc, 0x7f, 0x0e, 0x00, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00},
{ 0x00, 0x02, 0x60, 0x06, 0xe0, 0x0f, 0xe0, 0x07, 0xf0, 0x07, 0xfe, 0x07, 0xfe, 0x0f, 0xfc, 0x0f, 0xfc, 0x0f, 0xff, 0x1f, 0xfe, 0x1f, 0xc4, 0x1f, 0x00, 0x3e, 0x00, 0x30, 0x00, 0x00, 0x00, 0x00},
{ 0x00, 0x01, 0x80, 0x13, 0x00, 0x1f, 0xcc, 0x3f, 0xfc, 0x2f, 0xfc, 0x0f, 0xff, 0x0f, 0xff, 0x0f, 0xfa, 0x0f, 0xfa, 0x0f, 0xe0, 0x0f, 0xc0, 0x0f, 0x80, 0x0f, 0x00, 0x0f, 0x00, 0x0c, 0x00, 0x00},
{ 0x00, 0x00, 0x30, 0x0c, 0x30, 0x0c, 0xf2, 0x4f, 0xfe, 0x7f, 0xfe, 0x7f, 0xfa, 0x5f, 0xfa, 0x5f, 0xf0, 0x0f, 0xf0, 0x0f, 0xe0, 0x07, 0xe0, 0x07, 0xc0, 0x03, 0xc0, 0x03, 0x80, 0x01, 0x80, 0x01},
{ 0x80, 0x00, 0xc8, 0x01, 0xf8, 0x00, 0xfc, 0x33, 0xf4, 0x3f, 0xf0, 0x3f, 0xf0, 0xff, 0xf0, 0xff, 0xf0, 0x5f, 0xf0, 0x5f, 0xf0, 0x07, 0xf0, 0x03, 0xf0, 0x01, 0xf0, 0x00, 0x30, 0x00, 0x00, 0x00},
{ 0x40, 0x00, 0x60, 0x06, 0xf0, 0x07, 0xe0, 0x07, 0xe0, 0x0f, 0xe0, 0x7f, 0xf0, 0x7f, 0xf0, 0x3f, 0xf0, 0x3f, 0xf8, 0xff, 0xf8, 0x7f, 0xf8, 0x23, 0x7c, 0x00, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00},
{ 0x00, 0x03, 0xc0, 0x03, 0x00, 0x1f, 0xc0, 0x1f, 0xc0, 0x0f, 0xe0, 0x0f, 0xf0, 0x1f, 0xf8, 0x5f, 0xfc, 0xff, 0xfc, 0x7f, 0xfe, 0x3f, 0xfe, 0x3f, 0x00, 0x70, 0x00, 0x18, 0x00, 0x00, 0x00, 0x00},
{ 0x00, 0x00, 0x00, 0x1f, 0x00, 0x0c, 0x00, 0x0f, 0xc0, 0x7f, 0xf0, 0x7f, 0xfc, 0x1f, 0xff, 0x1f, 0xff, 0x1f, 0xfc, 0x1f, 0xf0, 0x7f, 0xc0, 0x7f, 0x00, 0x0f, 0x00, 0x0c, 0x00, 0x1f, 0x00, 0x00},
{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x00, 0x70, 0xfe, 0x3f, 0xfe, 0x3f, 0xfc, 0x7f, 0xfc, 0xff, 0xf8, 0x5f, 0xf0, 0x1f, 0xe0, 0x0f, 0xc0, 0x0f, 0xc0, 0x1f, 0x00, 0x1f, 0xc0, 0x03, 0x00, 0x03},
{ 0x00, 0x00, 0x00, 0x00, 0x0c, 0x00, 0x7c, 0x00, 0xf8, 0x23, 0xf8, 0x7f, 0xf8, 0xff, 0xf0, 0x3f, 0xf0, 0x3f, 0xf0, 0x7f, 0xe0, 0x7f, 0xe0, 0x0f, 0xe0, 0x07, 0xf0, 0x07, 0x60, 0x06, 0x40, 0x00},
{ 0x00, 0x00, 0x30, 0x00, 0xf0, 0x00, 0xf0, 0x01, 0xf0, 0x03, 0xf0, 0x07, 0xf0, 0x5f, 0xf0, 0x5f, 0xf0, 0xff, 0xf0, 0xff, 0xf0, 0x3f, 0xf4, 0x3f, 0xfc, 0x33, 0xf8, 0x00, 0xc8, 0x01, 0x80, 0x00}
},

/* BC */
{
{ 0x80, 0x01, 0x80, 0x01, 0xc0, 0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc4, 0x23, 0xec, 0x37, 0xec, 0x37, 0xec, 0x37, 0xec, 0x37, 0xfc, 0x3f, 0xec, 0x37, 0xec, 0x37, 0xee, 0x77, 0xfe, 0x7f, 0xec, 0x37},
{ 0x00, 0x00, 0x00, 0x0c, 0x00, 0x0f, 0x08, 0x0f, 0x98, 0x0f, 0xd8, 0x07, 0xec, 0x07, 0xec, 0x07, 0xfe, 0x37, 0xfe, 0x37, 0xf7, 0x1b, 0xfb, 0x1f, 0xff, 0x1d, 0xfd, 0x0d, 0xf8, 0x0d, 0xe0, 0x0f},
{ 0x00, 0x00, 0x00, 0x00, 0x20, 0x30, 0x30, 0x3c, 0x38, 0x1e, 0xdc, 0x1f, 0xee, 0x0f, 0xff, 0x07, 0xfb, 0x07, 0xfd, 0x07, 0xff, 0x3b, 0xfe, 0x1d, 0xfe, 0x0f, 0x7c, 0x07, 0xb8, 0x03, 0xe0, 0x01},
{ 0x00, 0x00, 0x00, 0x00, 0xc0, 0x00, 0xf8, 0x00, 0x3f, 0x78, 0xdf, 0x7f, 0xf1, 0x3f, 0xff, 0x3f, 0xff, 0x0f, 0xff, 0x07, 0xff, 0x03, 0xfe, 0x0c, 0xde, 0x1f, 0xec, 0x03, 0xf8, 0x00, 0x3c, 0x00},
{ 0x00, 0x00, 0x06, 0x00, 0xff, 0x07, 0xff, 0x03, 0x22, 0x00, 0xff, 0x03, 0xff, 0x3f, 0xff, 0xff, 0xff, 0xff, 0xff, 0x3f, 0xff, 0x03, 0x22, 0x00, 0xff, 0x03, 0xff, 0x07, 0x06, 0x00, 0x00, 0x00},
{ 0x3c, 0x00, 0xf8, 0x00, 0xec, 0x03, 0xde, 0x1f, 0xfe, 0x0c, 0xff, 0x03, 0xff, 0x07, 0xff, 0x0f, 0xff, 0x3f, 0xf1, 0x3f, 0xdf, 0x7f, 0x3f, 0x78, 0xf8, 0x00, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00},
{ 0xe0, 0x01, 0xb8, 0x03, 0x7c, 0x07, 0xfe, 0x0f, 0xfe, 0x1d, 0xff, 0x3b, 0xfd, 0x07, 0xfb, 0x07, 0xff, 0x07, 0xee, 0x0f, 0xdc, 0x1f, 0x38, 0x1e, 0x30, 0x3c, 0x20, 0x30, 0x00, 0x00, 0x00, 0x00},
{ 0xe0, 0x0f, 0xf8, 0x0d, 0xfd, 0x0d, 0xff, 0x1d, 0xfb, 0x1f, 0xf7, 0x1b, 0xfe, 0x37, 0xfe, 0x37, 0xec, 0x07, 0xec, 0x07, 0xd8, 0x07, 0x98, 0x0f, 0x08, 0x0f, 0x00, 0x0f, 0x00, 0x0c, 0x00, 0x00},
{ 0xec, 0x37, 0xfe, 0x7f, 0xee, 0x77, 0xec, 0x37, 0xec, 0x37, 0xfc, 0x3f, 0xec, 0x37, 0xec, 0x37, 0xec, 0x37, 0xec, 0x37, 0xc4, 0x23, 0xc0, 0x03, 0xc0, 0x03, 0xc0, 0x03, 0x80, 0x01, 0x80, 0x01},
{ 0xf0, 0x07, 0xb0, 0x1f, 0xb0, 0xbf, 0xb8, 0xff, 0xf8, 0xdf, 0xd8, 0xef, 0xec, 0x7f, 0xec, 0x7f, 0xe0, 0x37, 0xe0, 0x37, 0xe0, 0x1b, 0xf0, 0x19, 0xf0, 0x10, 0xf0, 0x00, 0x30, 0x00, 0x00, 0x00},
{ 0x80, 0x07, 0xc0, 0x1d, 0xe0, 0x3e, 0xf0, 0x7f, 0xb8, 0x7f, 0xdc, 0xff, 0xe0, 0xbf, 0xe0, 0xdf, 0xe0, 0xff, 0xf0, 0x77, 0xf8, 0x3b, 0x78, 0x1c, 0x3c, 0x0c, 0x0c, 0x04, 0x00, 0x00, 0x00, 0x00},
{ 0x00, 0x3c, 0x00, 0x1f, 0xc0, 0x37, 0xf8, 0x7b, 0x30, 0x7f, 0xc0, 0xff, 0xe0, 0xff, 0xf0, 0xff, 0xfc, 0xff, 0xfc, 0x8f, 0xfe, 0xfb, 0x1e, 0xfc, 0x00, 0x1f, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00},
{ 0x00, 0x00, 0x00, 0x60, 0xe0, 0xff, 0xc0, 0xff, 0x00, 0x44, 0xc0, 0xff, 0xfc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0xff, 0xc0, 0xff, 0x00, 0x44, 0xc0, 0xff, 0xe0, 0xff, 0x00, 0x60, 0x00, 0x00},
{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x1f, 0x1e, 0xfc, 0xfe, 0xfb, 0xfc, 0x8f, 0xfc, 0xff, 0xf0, 0xff, 0xe0, 0xff, 0xc0, 0xff, 0x30, 0x7f, 0xf8, 0x7b, 0xc0, 0x37, 0x00, 0x1f, 0x00, 0x3c},
{ 0x00, 0x00, 0x00, 0x00, 0x0c, 0x04, 0x3c, 0x0c, 0x78, 0x1c, 0xf8, 0x3b, 0xf0, 0x77, 0xe0, 0xff, 0xe0, 0xdf, 0xe0, 0xbf, 0xdc, 0xff, 0xb8, 0x7f, 0xf0, 0x7f, 0xe0, 0x3e, 0xc0, 0x1d, 0x80, 0x07},
{ 0x00, 0x00, 0x30, 0x00, 0xf0, 0x00, 0xf0, 0x10, 0xf0, 0x19, 0xe0, 0x1b, 0xe0, 0x37, 0xe0, 0x37, 0xec, 0x7f, 0xec, 0x7f, 0xd8, 0xef, 0xf8, 0xdf, 0xb8, 0xff, 0xb0, 0xbf, 0xb0, 0x1f, 0xf0, 0x07}
},

/* BB */
{
{ 0x80, 0x01, 0x80, 0x01, 0xc1, 0x83, 0xc1, 0x83, 0xc1, 0x83, 0xc9, 0x93, 0xf9, 0x9f, 0xef, 0xf7, 0xeb, 0xd7, 0xfb, 0xdf, 0xff, 0xff, 0xff, 0xff, 0xdf, 0xfb, 0xf7, 0xef, 0xd7, 0xeb, 0x03, 0xc0},
{ 0x0c, 0x00, 0x04, 0x0c, 0x04, 0x0f, 0x02, 0x0f, 0x92, 0x0f, 0xff, 0x07, 0xeb, 0x07, 0xfb, 0x1f, 0xff, 0x9f, 0xff, 0xf7, 0xff, 0xef, 0xfd, 0x6f, 0xfc, 0x7f, 0xf0, 0x3f, 0xe0, 0x3f, 0x00, 0x3d},
{ 0x30, 0x00, 0x18, 0x00, 0x0c, 0x30, 0x7e, 0x3c, 0x77, 0x1e, 0xdf, 0x1f, 0xff, 0x0f, 0xff, 0x07, 0xfe, 0x07, 0xfe, 0x1f, 0xfe, 0x9b, 0xfc, 0xdf, 0xf8, 0x77, 0xf0, 0x3f, 0xe0, 0x1f, 0x00, 0x0f},
{ 0xe0, 0x00, 0x78, 0x00, 0x7f, 0x00, 0xcf, 0x01, 0xbf, 0x79, 0xff, 0x7f, 0xfe, 0x3f, 0xff, 0x3f, 0xfe, 0x0f, 0xfe, 0x07, 0xfe, 0x07, 0xfc, 0x0d, 0xf8, 0x87, 0xf8, 0xe4, 0xe0, 0x1f, 0xf0, 0x07},
{ 0xff, 0x3f, 0xff, 0x01, 0x3e, 0x01, 0xf8, 0x07, 0x7e, 0x02, 0xf4, 0x03, 0xfe, 0x3f, 0xfe, 0xff, 0xfe, 0xff, 0xfe, 0x3f, 0xf4, 0x03, 0x7e, 0x02, 0xf8, 0x07, 0x3e, 0x01, 0xff, 0x01, 0xff, 0x3f},
{ 0xf0, 0x07, 0xe0, 0x1f, 0xf8, 0xe4, 0xf8, 0x87, 0xfc, 0x0d, 0xfe, 0x07, 0xfe, 0x07, 0xfe, 0x0f, 0xff, 0x3f, 0xfe, 0x3f, 0xff, 0x7f, 0xbf, 0x79, 0xcf, 0x01, 0x7f, 0x00, 0x78, 0x00, 0xe0, 0x00},
{ 0x00, 0x0f, 0xe0, 0x1f, 0xf0, 0x3f, 0xf8, 0x77, 0xfc, 0xdf, 0xfe, 0x9b, 0xfe, 0x1f, 0xfe, 0x07, 0xff, 0x07, 0xff, 0x0f, 0xdf, 0x1f, 0x77, 0x1e, 0x7e, 0x3c, 0x0c, 0x30, 0x18, 0x00, 0x30, 0x00},
{ 0x00, 0x3d, 0xe0, 0x3f, 0xf0, 0x3f, 0xfc, 0x7f, 0xfd, 0x6f, 0xff, 0xef, 0xff, 0xf7, 0xff, 0x9f, 0xfb, 0x1f, 0xeb, 0x07, 0xff, 0x07, 0x92, 0x0f, 0x02, 0x0f, 0x04, 0x0f, 0x04, 0x0c, 0x0c, 0x00},
{ 0x03, 0xc0, 0xd7, 0xeb, 0xf7, 0xef, 0xdf, 0xfb, 0xff, 0xff, 0xff, 0xff, 0xfb, 0xdf, 0xeb, 0xd7, 0xef, 0xf7, 0xf9, 0x9f, 0xc9, 0x93, 0xc1, 0x83, 0xc1, 0x83, 0xc1, 0x83, 0x80, 0x01, 0x80, 0x01},
{ 0xbc, 0x00, 0xfc, 0x07, 0xfc, 0x0f, 0xfe, 0x3f, 0xf6, 0xbf, 0xf7, 0xff, 0xef, 0xff, 0xf9, 0xff, 0xf8, 0xdf, 0xe0, 0xd7, 0xe0, 0xff, 0xf0, 0x49, 0xf0, 0x40, 0xf0, 0x20, 0x30, 0x20, 0x00, 0x30},
{ 0xf0, 0x00, 0xf8, 0x07, 0xfc, 0x0f, 0xee, 0x1f, 0xfb, 0x3f, 0xd9, 0x7f, 0xf8, 0x7f, 0xe0, 0x7f, 0xe0, 0xff, 0xf0, 0xff, 0xf8, 0xfb, 0x78, 0xee, 0x3c, 0x7e, 0x0c, 0x30, 0x00, 0x18, 0x00, 0x0c},
{ 0xe0, 0x0f, 0xf8, 0x07, 0x27, 0x1f, 0xe1, 0x1f, 0xb0, 0x3f, 0xe0, 0x7f, 0xe0, 0x7f, 0xf0, 0x7f, 0xfc, 0xff, 0xfc, 0x7f, 0xfe, 0xff, 0x9e, 0xfd, 0x80, 0xf3, 0x00, 0xfe, 0x00, 0x1e, 0x00, 0x07},
{ 0xfc, 0xff, 0x80, 0xff, 0x80, 0x7c, 0xe0, 0x1f, 0x40, 0x7e, 0xc0, 0x2f, 0xfc, 0x7f, 0xff, 0x7f, 0xff, 0x7f, 0xfc, 0x7f, 0xc0, 0x2f, 0x40, 0x7e, 0xe0, 0x1f, 0x80, 0x7c, 0x80, 0xff, 0xfc, 0xff},
{ 0x00, 0x07, 0x00, 0x1e, 0x00, 0xfe, 0x80, 0xf3, 0x9e, 0xfd, 0xfe, 0xff, 0xfc, 0x7f, 0xfc, 0xff, 0xf0, 0x7f, 0xe0, 0x7f, 0xe0, 0x7f, 0xb0, 0x3f, 0xe1, 0x1f, 0x27, 0x1f, 0xf8, 0x07, 0xe0, 0x0f},
{ 0x00, 0x0c, 0x00, 0x18, 0x0c, 0x30, 0x3c, 0x7e, 0x78, 0xee, 0xf8, 0xfb, 0xf0, 0xff, 0xe0, 0xff, 0xe0, 0x7f, 0xf8, 0x7f, 0xd9, 0x7f, 0xfb, 0x3f, 0xee, 0x1f, 0xfc, 0x0f, 0xf8, 0x07, 0xf0, 0x00},
{ 0x00, 0x30, 0x30, 0x20, 0xf0, 0x20, 0xf0, 0x40, 0xf0, 0x49, 0xe0, 0xff, 0xe0, 0xd7, 0xf8, 0xdf, 0xf9, 0xff, 0xef, 0xff, 0xf7, 0xff, 0xf6, 0xbf, 0xfe, 0x3f, 0xfc, 0x0f, 0xfc, 0x07, 0xbc, 0x00}
},

/* DN */
{
{ 0xe0, 0x07, 0xf8, 0x1f, 0xfc, 0x3f, 0xfe, 0x7f, 0xfe, 0x7f, 0x7f, 0xfe, 0x7f, 0xfe, 0xbf, 0xfd, 0xbf, 0xfd, 0xdf, 0xfb, 0x1f, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf7, 0xef, 0xe7, 0xe7},
{ 0xe0, 0x07, 0xf8, 0x1f, 0xfc, 0x3f, 0xfe, 0x7f, 0xfe, 0x7f, 0xff, 0xfc, 0xff, 0xfc, 0xbf, 0xff, 0xdf, 0xfd, 0xcf, 0xfd, 0x3f, 0xfc, 0xff, 0x7d, 0xfd, 0x7f, 0xfc, 0x3f, 0xf8, 0x3f, 0xe0, 0x3d},
{ 0xc0, 0x03, 0xf8, 0x1f, 0xfc, 0x3f, 0xfe, 0x7f, 0xff, 0x7f, 0xff, 0x7f, 0x7f, 0xfc, 0x8f, 0xfd, 0xcf, 0xfd, 0x9e, 0xfe, 0x3e, 0x7e, 0x7e, 0x7e, 0xfe, 0x7f, 0xfc, 0x3f, 0xf8, 0x1f, 0x80, 0x0f},
{ 0xe0, 0x07, 0xf8, 0x1f, 0xff, 0x3f, 0xff, 0x7f, 0xff, 0x7f, 0xff, 0xff, 0x0e, 0xf9, 0xdf, 0xf9, 0xdf, 0xff, 0xdf, 0xfe, 0x3f, 0xff, 0xbe, 0x7f, 0xfe, 0x7f, 0xfc, 0x3f, 0xf0, 0x1f, 0xf8, 0x07},
{ 0xff, 0x07, 0xff, 0x1f, 0xff, 0x3f, 0xfc, 0x7f, 0xfe, 0x7f, 0x9f, 0xff, 0x5f, 0xfe, 0xdf, 0xf9, 0xdf, 0xf9, 0x5f, 0xfe, 0x9f, 0xff, 0xfe, 0x7f, 0xfc, 0x7f, 0xff, 0x3f, 0xff, 0x1f, 0xff, 0x07},
{ 0xf8, 0x07, 0xf0, 0x1f, 0xfc, 0x3f, 0xfe, 0x7f, 0xbe, 0x7f, 0x3f, 0xff, 0xdf, 0xfe, 0xdf, 0xff, 0xdf, 0xf9, 0x0e, 0xf9, 0xff, 0xff, 0xff, 0x7f, 0xff, 0x7f, 0xff, 0x3f, 0xf8, 0x1f, 0xe0, 0x07},
{ 0x80, 0x0f, 0xf8, 0x1f, 0xfc, 0x3f, 0xfe, 0x7f, 0x7e, 0x7e, 0x3e, 0x7e, 0x9e, 0xfe, 0xcf, 0xfd, 0x8f, 0xfd, 0x7f, 0xfc, 0xff, 0x7f, 0xff, 0x7f, 0xfe, 0x7f, 0xfc, 0x3f, 0xf8, 0x1f, 0xc0, 0x03},
{ 0xe0, 0x3d, 0xf8, 0x3f, 0xfc, 0x3f, 0xfd, 0x7f, 0xff, 0x7d, 0x3f, 0xfc, 0xcf, 0xfd, 0xdf, 0xfd, 0xbf, 0xff, 0xff, 0xfc, 0xff, 0xfc, 0xfe, 0x7f, 0xfe, 0x7f, 0xfc, 0x3f, 0xf8, 0x1f, 0xe0, 0x07},
{ 0xe7, 0xe7, 0xf7, 0xef, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x1f, 0xf8, 0xdf, 0xfb, 0xbf, 0xfd, 0xbf, 0xfd, 0x7f, 0xfe, 0x7f, 0xfe, 0xfe, 0x7f, 0xfe, 0x7f, 0xfc, 0x3f, 0xf8, 0x1f, 0xe0, 0x07},
{ 0xbc, 0x07, 0xfc, 0x1f, 0xfc, 0x3f, 0xfe, 0xbf, 0xbe, 0xff, 0x3f, 0xfc, 0xbf, 0xf3, 0xbf, 0xfb, 0xff, 0xfd, 0x3f, 0xff, 0x3f, 0xff, 0xfe, 0x7f, 0xfe, 0x7f, 0xfc, 0x3f, 0xf8, 0x1f, 0xe0, 0x07},
{ 0xf0, 0x01, 0xf8, 0x1f, 0xfc, 0x3f, 0xfe, 0x7f, 0x7e, 0x7e, 0x7e, 0x7c, 0x7f, 0x79, 0xbf, 0xf3, 0xbf, 0xf1, 0x3f, 0xfe, 0xfe, 0xff, 0xfe, 0xff, 0xfe, 0x7f, 0xfc, 0x3f, 0xf8, 0x1f, 0xc0, 0x03},
{ 0xe0, 0x1f, 0xf8, 0x0f, 0xfc, 0x3f, 0xfe, 0x7f, 0xfe, 0x7d, 0xff, 0xfc, 0x7f, 0xfb, 0xff, 0xfb, 0x9f, 0xfb, 0x9f, 0x70, 0xff, 0xff, 0xfe, 0xff, 0xfe, 0xff, 0xfc, 0xff, 0xf8, 0x1f, 0xe0, 0x07},
{ 0xe0, 0xff, 0xf8, 0xff, 0xfc, 0xff, 0xfe, 0x3f, 0xfe, 0x7f, 0xff, 0xf9, 0x7f, 0xfa, 0x9f, 0xfb, 0x9f, 0xfb, 0x7f, 0xfa, 0xff, 0xf9, 0xfe, 0x7f, 0xfe, 0x3f, 0xfc, 0xff, 0xf8, 0xff, 0xe0, 0xff},
{ 0xe0, 0x07, 0xf8, 0x1f, 0xfc, 0xff, 0xfe, 0xff, 0xfe, 0xff, 0xff, 0xff, 0x9f, 0x70, 0x9f, 0xfb, 0xff, 0xfb, 0x7f, 0xfb, 0xff, 0xfc, 0xfe, 0x7d, 0xfe, 0x7f, 0xfc, 0x3f, 0xf8, 0x0f, 0xe0, 0x1f},
{ 0xc0, 0x03, 0xf8, 0x1f, 0xfc, 0x3f, 0xfe, 0x7f, 0xfe, 0xff, 0xfe, 0xff, 0x3f, 0xfe, 0xbf, 0xf1, 0xbf, 0xf3, 0x7f, 0x79, 0x7e, 0x7c, 0x7e, 0x7e, 0xfe, 0x7f, 0xfc, 0x3f, 0xf8, 0x1f, 0xf0, 0x01},
{ 0xe0, 0x07, 0xf8, 0x1f, 0xfc, 0x3f, 0xfe, 0x7f, 0xfe, 0x7f, 0x3f, 0xff, 0x3f, 0xff, 0xff, 0xfd, 0xbf, 0xfb, 0xbf, 0xf3, 0x3f, 0xfc, 0xbe, 0xff, 0xfe, 0xbf, 0xfc, 0x3f, 0xfc, 0x1f, 0xbc, 0x07}
},
};


static char pkil_bits[16][32] = {
{ 0x80, 0x01, 0x90, 0x09, 0x90, 0x09, 0xf0, 0x0f, 0xc4, 0x23, 0xe4, 0x27, 0xfe, 0x7f, 0xfe, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf6, 0x6f, 0xe6, 0x67, 0xf6, 0x6f, 0xf6, 0x6f, 0xf0, 0x0f},
{ 0x80, 0x00, 0x40, 0x0c, 0xd0, 0x06, 0x88, 0x27, 0xdc, 0x3f, 0xff, 0x17, 0xff, 0x0f, 0xff, 0x4f, 0xff, 0x7f, 0xfb, 0x7f, 0xfb, 0x7f, 0xfd, 0x7f, 0xfc, 0x7f, 0xfc, 0x39, 0xf8, 0x19, 0xe0, 0x0d},
{ 0x00, 0x00, 0x40, 0x02, 0x30, 0x33, 0x3e, 0x3e, 0xfe, 0x1f, 0xfe, 0x1f, 0xff, 0x7f, 0xf9, 0x2f, 0xf8, 0x0f, 0xfe, 0x4f, 0xff, 0x3f, 0xff, 0x3f, 0xfe, 0x1f, 0x7c, 0x1e, 0x78, 0x1e, 0x30, 0x03},
{ 0x00, 0x00, 0xf8, 0x01, 0xfc, 0x18, 0xfe, 0x0c, 0xff, 0x4b, 0xf9, 0x7f, 0xf8, 0x3f, 0xff, 0x1f, 0xff, 0xbf, 0xff, 0x6f, 0xff, 0x07, 0xfe, 0x2f, 0xfe, 0x1f, 0x9c, 0x0f, 0xe0, 0x07, 0xf0, 0x07},
{ 0xe0, 0x00, 0xfe, 0x03, 0xfe, 0x0f, 0xe0, 0x03, 0xf7, 0x73, 0xff, 0x17, 0xff, 0x1f, 0xff, 0xff, 0xff, 0xff, 0xff, 0x1f, 0xff, 0x17, 0xf7, 0x73, 0xe0, 0x03, 0xfe, 0x0f, 0xfe, 0x03, 0xe0, 0x00},
{ 0xf0, 0x07, 0xe0, 0x07, 0x9c, 0x0f, 0xfe, 0x1f, 0xfe, 0x2f, 0xff, 0x07, 0xff, 0x6f, 0xff, 0xbf, 0xff, 0x1f, 0xf8, 0x3f, 0xf9, 0x7f, 0xff, 0x4b, 0xfe, 0x0c, 0xfc, 0x18, 0xf8, 0x01, 0x00, 0x00},
{ 0x30, 0x03, 0x78, 0x1e, 0x7c, 0x1e, 0xfe, 0x1f, 0xff, 0x3f, 0xff, 0x3f, 0xfe, 0x4f, 0xf8, 0x0f, 0xf9, 0x2f, 0xff, 0x7f, 0xfe, 0x1f, 0xfe, 0x1f, 0x3e, 0x3e, 0x30, 0x33, 0x40, 0x02, 0x00, 0x00},
{ 0xe0, 0x0d, 0xf8, 0x19, 0xfc, 0x39, 0xfc, 0x7f, 0xfd, 0x7f, 0xfb, 0x7f, 0xfb, 0x7f, 0xff, 0x7f, 0xff, 0x4f, 0xff, 0x0f, 0xff, 0x17, 0xdc, 0x3f, 0x88, 0x27, 0xd0, 0x06, 0x40, 0x0c, 0x80, 0x00},
{ 0xf0, 0x0f, 0xf6, 0x6f, 0xf6, 0x6f, 0xe6, 0x67, 0xf6, 0x6f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x7f, 0xfe, 0x7f, 0xe4, 0x27, 0xc4, 0x23, 0xf0, 0x0f, 0x90, 0x09, 0x90, 0x09, 0x80, 0x01},
{ 0xb0, 0x07, 0x98, 0x1f, 0x9c, 0x3f, 0xfe, 0x3f, 0xfe, 0xbf, 0xfe, 0xdf, 0xfe, 0xdf, 0xfe, 0xff, 0xf2, 0xff, 0xf0, 0xff, 0xe8, 0xff, 0xfc, 0x3b, 0xe4, 0x11, 0x60, 0x0b, 0x30, 0x02, 0x00, 0x01},
{ 0xc0, 0x0c, 0x78, 0x1e, 0x78, 0x3e, 0xf8, 0x7f, 0xfc, 0xff, 0xfc, 0xff, 0xf2, 0x7f, 0xf0, 0x1f, 0xf4, 0x9f, 0xfe, 0xff, 0xf8, 0x7f, 0xf8, 0x7f, 0x7c, 0x7c, 0xcc, 0x0c, 0x40, 0x02, 0x00, 0x00},
{ 0xe0, 0x0f, 0xe0, 0x07, 0xf0, 0x39, 0xf8, 0x7f, 0xf4, 0x7f, 0xe0, 0xff, 0xf6, 0xff, 0xfd, 0xff, 0xf8, 0xff, 0xfc, 0x1f, 0xfe, 0x9f, 0xd2, 0xff, 0x30, 0x7f, 0x18, 0x3f, 0x80, 0x1f, 0x00, 0x00},
{ 0x00, 0x07, 0xc0, 0x7f, 0xf0, 0x7f, 0xc0, 0x07, 0xce, 0xef, 0xe8, 0xff, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0xe8, 0xff, 0xce, 0xef, 0xc0, 0x07, 0xf0, 0x7f, 0xc0, 0x7f, 0x00, 0x07},
{ 0x00, 0x00, 0x80, 0x1f, 0x18, 0x3f, 0x30, 0x7f, 0xd2, 0xff, 0xfe, 0x9f, 0xfc, 0x1f, 0xf8, 0xff, 0xfd, 0xff, 0xf6, 0xff, 0xe0, 0xff, 0xf4, 0x7f, 0xf8, 0x7f, 0xf0, 0x39, 0xe0, 0x07, 0xe0, 0x0f},
{ 0x00, 0x00, 0x40, 0x02, 0xcc, 0x0c, 0x7c, 0x7c, 0xf8, 0x7f, 0xf8, 0x7f, 0xfe, 0xff, 0xf4, 0x9f, 0xf0, 0x1f, 0xf2, 0x7f, 0xfc, 0xff, 0xfc, 0xff, 0xf8, 0x7f, 0x78, 0x3e, 0x78, 0x1e, 0xc0, 0x0c},
{ 0x00, 0x01, 0x30, 0x02, 0x60, 0x0b, 0xe4, 0x11, 0xfc, 0x3b, 0xe8, 0xff, 0xf0, 0xff, 0xf2, 0xff, 0xfe, 0xff, 0xfe, 0xdf, 0xfe, 0xdf, 0xfe, 0xbf, 0xfe, 0x3f, 0x9c, 0x3f, 0x98, 0x1f, 0xb0, 0x07}
};

/* for black sphere */
static char sphere_bits[] = {
   0xe0, 0x03, 0xf8, 0x0f, 0xfc, 0x1f, 0x1e, 0x3c, 0x0e, 0x38, 0x07, 0x70,
   0x07, 0x70, 0x07, 0x70, 0x07, 0x70, 0x07, 0x70, 0x0e, 0x38, 0x1e, 0x3c,
   0xfc, 0x1f, 0xf8, 0x0f, 0xe0, 0x03, 0x00, 0x00};

/* bitmask for immune ship */
static char immune_bits[] = {
   0x40,0x05,0xa8,0x0a,0x54,0x15,0xaa,0x2a,0x54,0x55,0xaa,0xaa,
   0x55,0x55,0xaa,0xaa,0x55,0x55,0xaa,0xaa,0x55,0x55,0xaa,0x2a,
   0x54,0x55,0xa8,0x2a,0x50,0x15,0xa0,0x02
};

/**** These are the explosions ****/

#define EX_FRAMES		5
#define ex_width	64
#define ex_height	64

static short ex_bits[5][256] = {
    {
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x8000, 0x0002, 0x0000,
	0x0000, 0x1000, 0x001a, 0x0000, 0x0000, 0x2800, 0x001c, 0x0000,
	0x0000, 0x0000, 0x000b, 0x0000, 0x0000, 0x0a00, 0x0008, 0x0000,
	0x0000, 0xe000, 0x000f, 0x0000, 0x0000, 0x9400, 0x0015, 0x0000,
	0x0000, 0xd500, 0x0075, 0x0000, 0x0000, 0x9500, 0x0022, 0x0000,
	0x0000, 0x6000, 0x001b, 0x0000, 0x0000, 0xf400, 0x001e, 0x0000,
	0x0000, 0x1000, 0x0001, 0x0000, 0x0000, 0xa000, 0x0026, 0x0000,
	0x0000, 0x0000, 0x0008, 0x0000, 0x0000, 0x8000, 0x0006, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000
    }, {
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x4000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0004, 0x0000,
	0x0000, 0x0000, 0x0104, 0x0000, 0x0000, 0x0200, 0x0080, 0x0000,
	0x0000, 0x0000, 0x0140, 0x0000, 0x0000, 0x0480, 0x0010, 0x0000,
	0x0000, 0x0000, 0x0082, 0x0000, 0x0000, 0x0000, 0x0044, 0x0000,
	0x0000, 0x0004, 0x0080, 0x0000, 0x0000, 0x0088, 0x0000, 0x0000,
	0x0000, 0xa000, 0x00c0, 0x0000, 0x0000, 0xa800, 0x0025, 0x0000,
	0x0000, 0x0020, 0x0212, 0x0000, 0x0000, 0x8100, 0x0202, 0x0000,
	0x0000, 0x6000, 0x2c12, 0x0000, 0x0000, 0x9222, 0x1200, 0x0000,
	0x0000, 0x4000, 0x0004, 0x0000, 0x0000, 0x4212, 0x0800, 0x0000,
	0x0000, 0x2800, 0x0048, 0x0000, 0x0000, 0x2000, 0x0247, 0x0000,
	0x0000, 0x2820, 0x0048, 0x0000, 0x0000, 0x4200, 0x0118, 0x0000,
	0x0000, 0x0100, 0x0002, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0400, 0x0400, 0x0000, 0x0000, 0xc000, 0x0014, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0040, 0x0000,
	0x0000, 0x0000, 0x0028, 0x0000, 0x0000, 0x4000, 0x0014, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000
   }, {
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x4000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x2008, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0040, 0x0800, 0x0000, 0x0000, 0x0000, 0x0400, 0x0000,
	0x0000, 0x0000, 0x2080, 0x0000, 0x0000, 0x0084, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0800, 0x0000, 0x0000, 0x0000, 0x0004, 0x0000,
	0x0000, 0x0000, 0x0208, 0x0000, 0x0800, 0x0000, 0x0800, 0x0000,
	0x0000, 0x0004, 0x0000, 0x0000, 0x1000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0200, 0x0000, 0x0000, 0x5000, 0x0900, 0x0000,
	0x0000, 0x9100, 0x0009, 0x0000, 0x0000, 0x0001, 0x2004, 0x0000,
	0x0000, 0x4000, 0x4044, 0x0000, 0x0000, 0x8010, 0x0000, 0x0000,
	0x0000, 0x3000, 0x8044, 0x0010, 0x0400, 0x0040, 0x0000, 0x0005,
	0x0000, 0x8801, 0x4000, 0x0000, 0x0000, 0x0000, 0x0008, 0x0000,
	0x0000, 0x4040, 0x0000, 0x0000, 0x4400, 0x2000, 0x0000, 0x0002,
	0x0000, 0x1200, 0x0400, 0x0000, 0x0000, 0x0000, 0x4022, 0x0000,
	0x0000, 0x0800, 0x0412, 0x0000, 0x0000, 0x0101, 0x0200, 0x0000,
	0x0000, 0x1000, 0x2090, 0x0000, 0x0000, 0x2040, 0x0030, 0x0000,
	0x0000, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000, 0x0002, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0080, 0x0000, 0x0000,
	0x0000, 0x0000, 0x8000, 0x0000, 0x0000, 0xc000, 0x0048, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0400, 0x0000,
	0x0000, 0x0000, 0x0200, 0x0000, 0x0000, 0x0000, 0x0110, 0x0000,
	0x0000, 0x2000, 0x0008, 0x0000, 0x0000, 0x0000, 0x0040, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000
   }, {
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x2000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0020, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000, 0x0002,
	0x0000, 0x0008, 0x8000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x2000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0002,
	0x0000, 0x0000, 0x0200, 0x0000, 0x4000, 0x0010, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x8008, 0x0000,
	0x0000, 0x0000, 0x1000, 0x0000, 0x0000, 0x0000, 0x0010, 0x0000,
	0x0000, 0x0000, 0x8000, 0x0000, 0x0010, 0x0000, 0x0000, 0x0000,
	0x4000, 0x0000, 0x0000, 0x0000, 0x0040, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x1000, 0x0000, 0x0000, 0x4800, 0x8000, 0x0000,
	0x0000, 0x0040, 0x0800, 0x0000, 0x0000, 0x4400, 0x0011, 0x0000,
	0x0000, 0x0000, 0x0008, 0x0000, 0x0800, 0x0000, 0x0100, 0x0004,
	0x0000, 0x4002, 0x0008, 0x0004, 0x0000, 0x8000, 0x0000, 0x0000,
	0x0000, 0x2000, 0x0208, 0x0810, 0x0000, 0x0800, 0x0000, 0x0040,
	0x0008, 0x0008, 0x0000, 0x0100, 0x0400, 0x8200, 0x0000, 0x0008,
	0x0000, 0x0000, 0x0010, 0x0000, 0x0000, 0x2000, 0x0000, 0x0000,
	0x0000, 0x0008, 0x0000, 0x0040, 0x0208, 0x1000, 0x0000, 0x0000,
	0x0000, 0x0800, 0x2000, 0x0000, 0x0000, 0x0080, 0x0080, 0x0000,
	0x0000, 0x0000, 0x0004, 0x0008, 0x0000, 0x0400, 0x2022, 0x0000,
	0x0000, 0x0040, 0x1000, 0x0000, 0x0400, 0x0800, 0x0040, 0x0000,
	0x0000, 0x0000, 0x0200, 0x0002, 0x0000, 0x1008, 0x00c0, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0001, 0x0004, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0010,
	0x0000, 0x6000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0110, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x2000, 0x0000, 0x0000, 0x0000, 0x3000, 0x0000,
	0x0000, 0x0000, 0x0440, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x1000, 0x0120, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000
   }, {
	0x0000, 0x0000, 0x0040, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0020, 0x0000, 0x0000, 0x0000, 0x0000, 0x0040,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0001, 0x0000, 0x0008,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0002,
	0x0000, 0x0000, 0x0000, 0x0040, 0x0000, 0x0000, 0x0800, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0400, 0x0002, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0010, 0x0008,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x8000, 0x0000,
	0x0000, 0x0000, 0x0020, 0x0000, 0x0000, 0x0000, 0x0000, 0x0008,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0200, 0x0000, 0x0000, 0x0000,
	0x0001, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x8000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x2400, 0x4000, 0x0008, 0x0000, 0x0010, 0x0000, 0x0000,
	0x0000, 0x4200, 0x0021, 0x0000, 0x0000, 0x0000, 0x0010, 0x0000,
	0x0040, 0x0000, 0x0000, 0x0080, 0x0000, 0x0000, 0x0400, 0x0080,
	0x2000, 0x2000, 0x0010, 0x0000, 0x0000, 0x8000, 0x0000, 0x0000,
	0x0000, 0x1000, 0x0800, 0x0200, 0x0000, 0x0200, 0x0008, 0x1000,
	0x8000, 0x0000, 0x0000, 0x4000, 0x0000, 0x0080, 0x0000, 0x0100,
	0x0020, 0x8000, 0x0000, 0x0080, 0x0000, 0x0000, 0x0020, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1001, 0x0000, 0x0000,
	0x0000, 0x1000, 0x0000, 0x1000, 0x0008, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0400, 0x0000, 0x0003, 0x0000, 0x0020, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0208, 0x0100, 0x0000, 0x0000, 0x0000, 0x0002,
	0x0000, 0x0100, 0x0044, 0x0000, 0x0000, 0x0010, 0x8000, 0x0000,
	0x0020, 0x0000, 0x0100, 0x0000, 0x0000, 0x0400, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0900, 0x0020, 0x0000, 0x0801, 0x0080, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x2000, 0x0000, 0x0004, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0002, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0200,
	0x0000, 0x5000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0820, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000
    }
};

Pixmap	expview[EX_FRAMES];

/**** These are the misc things ****/

Pixmap fedview[VIEWS];
Pixmap romview[VIEWS];
Pixmap kliview[VIEWS];
Pixmap oriview[VIEWS];
Pixmap cloud;

Pixmap photon;
Pixmap missile_pixmap[VIEWS];
Pixmap plasma_pixmap[4];
Pixmap chaff_pixmap[4];

Cursor crosshair;

#define cloud_width 7
#define cloud_height 7
static short cloud_bits[] = {
   0x0014, 0x002a, 0x0055, 0x002a,
   0x0055, 0x002a, 0x0014};

#define photon_width 3
#define photon_height 3
static short photon_bits[] = {
   0x0005, 0x0002, 0x0005};

#define missile_width 6
#define missile_height 6
static char missile_bits[16][6] = {
	{ 0x0c, 0x0c, 0x0c, 0x0c, 0x1e, 0x1e},
	{ 0x18, 0x18, 0x0c, 0x0e, 0x0f, 0x0e},
	{ 0x00, 0x18, 0x1c, 0x0f, 0x07, 0x06},
	{ 0x00, 0x30, 0x3f, 0x0f, 0x07, 0x02},
	{ 0x00, 0x03, 0x3f, 0x3f, 0x03, 0x00},
	{ 0x02, 0x07, 0x0f, 0x3f, 0x30, 0x00},
	{ 0x06, 0x07, 0x0f, 0x1c, 0x18, 0x00},
	{ 0x0e, 0x0f, 0x0e, 0x0c, 0x18, 0x18},
	{ 0x1e, 0x1e, 0x0c, 0x0c, 0x0c, 0x0c},
	{ 0x1c, 0x3c, 0x1c, 0x0c, 0x06, 0x06},
	{ 0x18, 0x38, 0x3c, 0x0e, 0x06, 0x00},
	{ 0x10, 0x38, 0x3c, 0x3f, 0x03, 0x00},
	{ 0x00, 0x30, 0x3f, 0x3f, 0x30, 0x00},
	{ 0x00, 0x03, 0x3f, 0x3c, 0x38, 0x10},
	{ 0x00, 0x06, 0x0e, 0x3c, 0x38, 0x18},
	{ 0x06, 0x06, 0x0c, 0x1c, 0x3c, 0x1c}
};



#define plasma_width 11
#define plasma_height 11
static char plasma_bits[4][22] = {
	{ 0xf8, 0x00, 0x1c, 0x00, 0xcc, 0x03, 0xfd,
	  0x07, 0xfd, 0x06, 0xf9, 0x04, 0xfb, 0x05,
	  0xff, 0x05, 0x9e, 0x01, 0xc0, 0x01, 0xf8, 0x00},
	{ 0xf0, 0x00, 0x7a, 0x03, 0x1a, 0x00, 0xf9,
	  0x03, 0xfb, 0x07, 0xfb, 0x06, 0xff, 0x06,
	  0xfe, 0x04, 0xc0, 0x02, 0xf6, 0x02, 0x78, 0x00},
	{ 0xc8, 0x00, 0xe4, 0x01, 0x72, 0x02, 0x73,
  	  0x04, 0xff, 0x01, 0xfe, 0x03, 0xfc, 0x07,
	  0x71, 0x06, 0x72, 0x02, 0x3c, 0x01, 0x98, 0x00},
	{ 0x38, 0x00, 0xce, 0x03, 0xe6, 0x03, 0xfe,
	  0x06, 0xfe, 0x04, 0xfd, 0x05, 0xf9, 0x03,
	  0xfb, 0x03, 0x3e, 0x03, 0x9e, 0x03, 0xe0, 0x00}
};


#define bklsh_width 8
#define bklsh_height 8
static char bklsh_bits[8][8] = {
   { 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00 },
   { 0x00, 0x00, 0x18, 0x3c, 0x3c, 0x18, 0x00, 0x00 },
   { 0x00, 0x18, 0x3c, 0x66, 0x66, 0x3c, 0x18, 0x00 },
   { 0x18, 0x3c, 0x7e, 0xe7, 0xe7, 0x7e, 0x3c, 0x18 },
   { 0x3c, 0x7e, 0xe7, 0xc3, 0xc3, 0xe7, 0x7e, 0x3c },
   { 0x18, 0x3c, 0x7e, 0xe7, 0xe7, 0x7e, 0x3c, 0x18 },
   { 0x00, 0x18, 0x3c, 0x66, 0x66, 0x3c, 0x18, 0x00 },
   { 0x00, 0x00, 0x18, 0x3c, 0x3c, 0x18, 0x00, 0x00 },
};


#define chaff_width 24
#define chaff_height 24
static char chaff_bits[4][72] = {
	{ 0x00, 0x68, 0x00, 0x40, 0x0a, 0x00, 0x80, 0x90,
	  0x04, 0x28, 0x02, 0x01, 0x00, 0x05, 0x10, 0x04,
	  0x10, 0x0a, 0x52, 0x00, 0x53, 0x40, 0x22, 0x00,
	  0x05, 0x20, 0x90, 0x04, 0x09, 0x82, 0x29, 0x20,
	  0x20, 0x00, 0x01, 0x84, 0x20, 0x88, 0x40, 0x05,
	  0x00, 0x10, 0x10, 0x02, 0x02, 0x50, 0x18, 0x40,
	  0x02, 0x82, 0x50, 0x08, 0x20, 0x0c, 0xa0, 0x00,
	  0x01, 0x08, 0x09, 0x10, 0x08, 0xa4, 0x01, 0x40,
	  0x81, 0x02, 0x00, 0x10, 0x00, 0x00, 0x24, 0x00},
	{ 0x00, 0xa4, 0x00, 0x80, 0x00, 0x02, 0x00, 0xc4,
	  0x04, 0x58, 0x20, 0x10, 0x00, 0x03, 0x02, 0x20,
	  0x28, 0x10, 0x04, 0x01, 0x43, 0x20, 0x00, 0x20,
	  0x14, 0x50, 0x08, 0x80, 0x02, 0x51, 0x09, 0x00,
	  0x08, 0x10, 0x49, 0xc0, 0x02, 0x01, 0x24, 0x49,
	  0xa0, 0x81, 0x00, 0x00, 0x80, 0x8c, 0x08, 0x20,
	  0x28, 0x00, 0x12, 0x04, 0x42, 0x06, 0x40, 0x10,
	  0x20, 0x40, 0x00, 0x04, 0x90, 0x84, 0x0a, 0x00,
	  0x20, 0x00, 0x80, 0x09, 0x02, 0x00, 0xd0, 0x00},
	{ 0x00, 0x24, 0x00, 0x00, 0x08, 0x00, 0x40, 0x81,
	  0x02, 0x80, 0x25, 0x10, 0x08, 0x90, 0x10, 0x80,
	  0x00, 0x05, 0x30, 0x04, 0x10, 0x0a, 0x41, 0x40,
	  0x02, 0x18, 0x0a, 0x40, 0x40, 0x08, 0x08, 0x00,
	  0xa0, 0x02, 0x11, 0x04, 0x21, 0x80, 0x00, 0x04,
	  0x04, 0x94, 0x41, 0x90, 0x20, 0x09, 0x04, 0xa0,
	  0x00, 0x44, 0x02, 0xca, 0x00, 0x4a, 0x50, 0x08,
	  0x20, 0x08, 0xa0, 0x00, 0x80, 0x40, 0x14, 0x20,
	  0x09, 0x01, 0x00, 0x50, 0x02, 0x00, 0x16, 0x00},
	{ 0x00, 0x0b, 0x00, 0x40, 0x90, 0x01, 0x00, 0x04,
	  0x00, 0x50, 0x21, 0x09, 0x20, 0x00, 0x02, 0x04,
	  0x08, 0x02, 0x60, 0x42, 0x20, 0x48, 0x00, 0x14,
	  0x04, 0x10, 0x31, 0x01, 0x00, 0x00, 0x81, 0x05,
	  0x92, 0x24, 0x80, 0x40, 0x03, 0x92, 0x08, 0x10,
	  0x00, 0x90, 0x8a, 0x40, 0x01, 0x10, 0x0a, 0x28,
	  0x04, 0x00, 0x04, 0xc2, 0x80, 0x20, 0x08, 0x14,
	  0x04, 0x40, 0xc0, 0x00, 0x08, 0x04, 0x1a, 0x20,
	  0x23, 0x00, 0x40, 0x00, 0x01, 0x00, 0x25, 0x00}
};


#define mine_width 9
#define mine_height 9
static char mine_bits[] = {
   0x10, 0x00, 0x92, 0x00, 0x7c,
   0x00, 0x6c, 0x00, 0xc7, 0x01,
   0x6c, 0x00, 0x7c, 0x00, 0x92,
   0x00, 0x10, 0x00
};


/* PLANETS AND STELLAR OBJECTS */

#define planet_width 30
#define planet_height 30
static char bplanet_bits[] = {
   0x00,0xf8,0x03,0x00,0x00,0x07,0x1c,0x00,0xc0,0x00,0x60,0x00,
   0x20,0x00,0x80,0x00,0x10,0x00,0x00,0x01,0x08,0x00,0x00,0x02,
   0x04,0x00,0x00,0x04,0x04,0x00,0x00,0x04,0x02,0x00,0x00,0x08,
   0x02,0x00,0x00,0x08,0x02,0x00,0x00,0x08,0x01,0x00,0x00,0x10,
   0x01,0x00,0x00,0x10,0x01,0x00,0x00,0x10,0x01,0x00,0x00,0x10,
   0x01,0x00,0x00,0x10,0x01,0x00,0x00,0x10,0x01,0x00,0x00,0x10,
   0x02,0x00,0x00,0x08,0x02,0x00,0x00,0x08,0x02,0x00,0x00,0x08,
   0x04,0x00,0x00,0x04,0x04,0x00,0x00,0x04,0x08,0x00,0x00,0x02,
   0x10,0x00,0x00,0x01,0x20,0x00,0x80,0x00,0xc0,0x00,0x60,0x00,
   0x00,0x07,0x1c,0x00,0x00,0xf8,0x03,0x00,0x00,0x00,0x00,0x00
};
static char bfplanet_bits[] = {
   0x00,0xf8,0x03,0x00,0x00,0x07,0x1c,0x00,0xc0,0x00,0x60,0x00,
   0x20,0x00,0x80,0x00,0xf0,0xff,0xff,0x01,0x08,0x00,0x00,0x02,
   0x04,0x00,0x00,0x04,0x04,0x00,0x00,0x04,0x02,0x00,0x00,0x08,
   0xfe,0xff,0xff,0x0f,0x02,0x00,0x00,0x08,0x01,0x00,0x00,0x10,
   0x01,0x00,0x00,0x10,0x01,0x00,0x00,0x10,0xff,0xff,0xff,0x1f,
   0x01,0x00,0x00,0x10,0x01,0x00,0x00,0x10,0x01,0x00,0x00,0x10,
   0x02,0x00,0x00,0x08,0xfe,0xff,0xff,0x0f,0x02,0x00,0x00,0x08,
   0x04,0x00,0x00,0x04,0x04,0x00,0x00,0x04,0x08,0x00,0x00,0x02,
   0xf0,0xff,0xff,0x01,0x20,0x00,0x80,0x00,0xc0,0x00,0x60,0x00,
   0x00,0x07,0x1c,0x00,0x00,0xf8,0x03,0x00,0x00,0x00,0x00,0x00
};
static char brplanet_bits[] = {
   0x00,0xfc,0x03,0x00,0x00,0x07,0x1d,0x00,0xc0,0x04,0x62,0x00,
   0x20,0x08,0x84,0x00,0x30,0x10,0x08,0x01,0x48,0x20,0x10,0x02,
   0x84,0x40,0x20,0x04,0x04,0x81,0x40,0x04,0x06,0x02,0x81,0x08,
   0x0a,0x04,0x02,0x09,0x12,0x08,0x04,0x0a,0x21,0x10,0x08,0x14,
   0x41,0x20,0x10,0x18,0x81,0x40,0x20,0x10,0x03,0x81,0x40,0x10,
   0x05,0x02,0x81,0x10,0x09,0x04,0x02,0x11,0x11,0x08,0x04,0x12,
   0x22,0x10,0x08,0x0c,0x42,0x20,0x10,0x08,0x82,0x40,0x20,0x08,
   0x04,0x81,0x40,0x04,0x04,0x02,0x81,0x04,0x08,0x04,0x02,0x03,
   0x10,0x08,0x04,0x01,0x20,0x10,0x88,0x00,0xc0,0x20,0x70,0x00,
   0x00,0x47,0x1c,0x00,0x00,0xf8,0x03,0x00,0x00,0x00,0x00,0x00
};
static char bkplanet_bits[] = {
   0x00,0xf8,0x03,0x00,0x00,0x47,0x1c,0x00,0xc0,0x42,0x68,0x00,
   0x20,0x42,0x88,0x00,0x10,0x42,0x08,0x01,0x18,0x42,0x08,0x03,
   0x14,0x42,0x08,0x05,0x14,0x42,0x08,0x05,0x12,0x42,0x08,0x09,
   0x12,0x42,0x08,0x09,0x12,0x42,0x08,0x09,0x11,0x42,0x08,0x11,
   0x11,0x42,0x08,0x11,0x11,0x42,0x08,0x11,0x11,0x42,0x08,0x11,
   0x11,0x42,0x08,0x11,0x11,0x42,0x08,0x11,0x11,0x42,0x08,0x11,
   0x12,0x42,0x08,0x09,0x12,0x42,0x08,0x09,0x12,0x42,0x08,0x09,
   0x14,0x42,0x08,0x05,0x14,0x42,0x08,0x05,0x18,0x42,0x08,0x03,
   0x10,0x42,0x08,0x01,0x20,0x42,0x88,0x00,0xc0,0x42,0x68,0x00,
   0x00,0x47,0x1c,0x00,0x00,0xf8,0x03,0x00,0x00,0x00,0x00,0x00
};
static char boplanet_bits[] = {
   0x00,0xf8,0x03,0x00,0x00,0x17,0x1c,0x00,0xc0,0x08,0x64,0x00,
   0x20,0x04,0x82,0x00,0x10,0x02,0x81,0x01,0x08,0x81,0x40,0x02,
   0x84,0x40,0x20,0x04,0x44,0x20,0x10,0x04,0x22,0x10,0x08,0x0c,
   0x12,0x08,0x04,0x0a,0x0a,0x04,0x02,0x09,0x05,0x02,0x81,0x10,
   0x03,0x81,0x40,0x10,0x81,0x40,0x20,0x10,0x41,0x20,0x10,0x18,
   0x21,0x10,0x08,0x14,0x11,0x08,0x04,0x12,0x09,0x04,0x02,0x11,
   0x06,0x02,0x81,0x08,0x02,0x81,0x40,0x08,0x82,0x40,0x20,0x08,
   0x44,0x20,0x10,0x04,0x24,0x10,0x08,0x06,0x18,0x08,0x04,0x03,
   0x10,0x04,0x82,0x01,0x20,0x02,0x81,0x00,0xc0,0x81,0x60,0x00,
   0x00,0x47,0x1c,0x00,0x00,0xf8,0x03,0x00,0x00,0x00,0x00,0x00
};
static char bbplanet_bits[] = {
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xf8,0x03,0x00,
   0x00,0x06,0x0c,0x00,0x80,0x01,0x30,0x00,0x40,0x00,0x40,0x00,
   0x20,0x00,0x80,0x00,0x10,0x00,0x00,0x01,0x10,0x00,0x00,0x01,
   0x08,0x00,0x00,0x02,0x08,0xf0,0x01,0x02,0x04,0xf8,0x03,0x04,
   0x04,0xfc,0x07,0x04,0x04,0xfc,0x07,0x04,0x04,0xfc,0x07,0x04,
   0x04,0xfc,0x07,0x04,0x04,0xfc,0x07,0x04,0x04,0xf8,0x03,0x04,
   0x08,0xf0,0x01,0x02,0x08,0x00,0x00,0x02,0x10,0x00,0x00,0x01,
   0x10,0x00,0x00,0x01,0x20,0x00,0x80,0x00,0x40,0x00,0x40,0x00,
   0x80,0x01,0x30,0x00,0x00,0x06,0x0c,0x00,0x00,0xf8,0x03,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
};
static char bpulsar_bits[4][120] = {
   0x00,0x40,0x00,0x00,0x00,0x40,0x00,0x00,0x00,0x40,0x00,0x00,
   0x00,0x40,0x00,0x00,0x00,0x40,0x00,0x00,0x00,0x40,0x00,0x00,
   0x00,0x40,0x00,0x00,0x00,0x40,0x00,0x00,0x00,0x40,0x00,0x00,
   0x00,0x42,0x08,0x00,0x00,0xf4,0x05,0x00,0x00,0x08,0x02,0x00,
   0x00,0x04,0x04,0x00,0x00,0x04,0x04,0x00,0xfc,0x07,0xfc,0x07,
   0x00,0x04,0x04,0x00,0x00,0x04,0x04,0x00,0x00,0x08,0x02,0x00,
   0x00,0xf4,0x05,0x00,0x00,0x42,0x08,0x00,0x00,0x40,0x00,0x00,
   0x00,0x40,0x00,0x00,0x00,0x40,0x00,0x00,0x00,0x40,0x00,0x00,
   0x00,0x40,0x00,0x00,0x00,0x40,0x00,0x00,0x00,0x40,0x00,0x00,
   0x00,0x40,0x00,0x00,0x00,0x40,0x00,0x00,0x00,0x00,0x00,0x00,

   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x40,0x00,0x00,0x00,0x40,0x00,0x00,0x00,0x40,0x00,0x00,
   0x00,0x40,0x00,0x00,0x00,0x40,0x00,0x00,0x00,0x40,0x00,0x00,
   0x00,0x40,0x00,0x00,0x00,0xf0,0x01,0x00,0x00,0x08,0x02,0x00,
   0x00,0x04,0x04,0x00,0x00,0x04,0x04,0x00,0xc0,0x07,0x7c,0x00,
   0x00,0x04,0x04,0x00,0x00,0x04,0x04,0x00,0x00,0x08,0x02,0x00,
   0x00,0xf0,0x01,0x00,0x00,0x40,0x00,0x00,0x00,0x40,0x00,0x00,
   0x00,0x40,0x00,0x00,0x00,0x40,0x00,0x00,0x00,0x40,0x00,0x00,
   0x00,0x40,0x00,0x00,0x00,0x40,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,

   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x40,0x00,0x00,0x00,0x40,0x00,0x00,0x00,0x40,0x00,0x00,
   0x00,0x40,0x00,0x00,0x00,0xf0,0x01,0x00,0x00,0x08,0x02,0x00,
   0x00,0x04,0x04,0x00,0x00,0x04,0x04,0x00,0x00,0x07,0x1c,0x00,
   0x00,0x04,0x04,0x00,0x00,0x04,0x04,0x00,0x00,0x08,0x02,0x00,
   0x00,0xf0,0x01,0x00,0x00,0x40,0x00,0x00,0x00,0x40,0x00,0x00,
   0x00,0x40,0x00,0x00,0x00,0x40,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,

   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x40,0x00,0x00,0x00,0x40,0x00,0x00,0x00,0x40,0x00,0x00,
   0x00,0x40,0x00,0x00,0x00,0x40,0x00,0x00,0x00,0x40,0x00,0x00,
   0x00,0x40,0x00,0x00,0x00,0xf0,0x01,0x00,0x00,0x08,0x02,0x00,
   0x00,0x04,0x04,0x00,0x00,0x04,0x04,0x00,0xc0,0x07,0x7c,0x00,
   0x00,0x04,0x04,0x00,0x00,0x04,0x04,0x00,0x00,0x08,0x02,0x00,
   0x00,0xf0,0x01,0x00,0x00,0x40,0x00,0x00,0x00,0x40,0x00,0x00,
   0x00,0x40,0x00,0x00,0x00,0x40,0x00,0x00,0x00,0x40,0x00,0x00,
   0x00,0x40,0x00,0x00,0x00,0x40,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
};

#define blackhole_width 16
#define blackhole_height 16
static char blackhole_bits[8][32] = {
{ 0xe0, 0x03, 0x30, 0x00, 0x98, 0x0f, 0xcc, 0x1f, 0xec, 0x31, 0xed, 0x67, 0xfd, 0x4f, 0xfd, 0x5f, 0xf9, 0x5f, 0xf3, 0x5b, 0xc6, 0x1b, 0xfc, 0x19, 0xf8, 0x0c, 0x00, 0x06, 0xe0, 0x03, 0x00, 0x00},
{ 0xc0, 0x07, 0x70, 0x00, 0x38, 0x07, 0xd8, 0x1f, 0xda, 0x3b, 0xfd, 0x27, 0xfd, 0x6f, 0xf9, 0x4f, 0xf3, 0x5f, 0xe6, 0x5f, 0xfc, 0x5b, 0xfc, 0x0d, 0x60, 0x0c, 0x10, 0x03, 0xe0, 0x01, 0x00, 0x00},
{ 0x80, 0x07, 0xf0, 0x18, 0x30, 0x02, 0xba, 0x1f, 0xda, 0x3f, 0xf9, 0x33, 0xfb, 0x6f, 0xf3, 0x6f, 0xf6, 0x4f, 0xee, 0x5f, 0xfc, 0x6d, 0xf8, 0x2c, 0x00, 0x0e, 0xb8, 0x07, 0xe0, 0x00, 0x00, 0x00},
{ 0x00, 0x07, 0xe0, 0x1b, 0x74, 0x30, 0xb6, 0x0f, 0xfa, 0x3f, 0xfa, 0x3f, 0xf2, 0x27, 0xf6, 0x6f, 0xe6, 0x6f, 0xfc, 0x4f, 0xf8, 0x4d, 0x30, 0x2e, 0x0c, 0x16, 0xf0, 0x03, 0x20, 0x00, 0x00, 0x00},
{ 0x00, 0x00, 0xd8, 0x1f, 0xec, 0x30, 0x76, 0x6e, 0xf6, 0x1f, 0xf6, 0x3f, 0xf6, 0x77, 0xe6, 0x6f, 0xfe, 0x6f, 0xfc, 0x6f, 0xf8, 0x6f, 0x04, 0x2e, 0x88, 0x17, 0xf0, 0x0b, 0x00, 0x00, 0x00, 0x00},
{ 0x20, 0x00, 0x98, 0x1f, 0xec, 0x39, 0xe4, 0x60, 0xe4, 0x5f, 0xe4, 0x3f, 0xe4, 0x3f, 0xec, 0x77, 0xfc, 0x6f, 0xfa, 0x2f, 0xf2, 0x27, 0x04, 0x27, 0xf8, 0x33, 0xe0, 0x09, 0x00, 0x04, 0x00, 0x00},
{ 0xe0, 0x00, 0x18, 0x0f, 0xc8, 0x3f, 0xc8, 0x61, 0xec, 0x47, 0xec, 0x9f, 0xec, 0xbf, 0xfc, 0x3f, 0xfa, 0x67, 0xfa, 0x6f, 0xc6, 0x27, 0x9c, 0x37, 0xf8, 0x13, 0xe0, 0x1c, 0x00, 0x06, 0x00, 0x00},
{ 0xe0, 0x01, 0x30, 0x0c, 0x90, 0x1f, 0xd8, 0x73, 0xcc, 0x47, 0xec, 0x8f, 0xf8, 0xbf, 0xfa, 0xbf, 0xfa, 0x3f, 0xe2, 0x37, 0x8e, 0x27, 0xdc, 0x33, 0xf0, 0x1b, 0x00, 0x08, 0x00, 0x07, 0x00, 0x00},
};


#define mplanet_width 16
#define mplanet_height 16
static char mbplanet_bits[] = {
   0xe0,0x03,0x18,0x0c,0x04,0x10,0x02,0x20,0x02,0x20,0x01,0x40,
   0x01,0x40,0x01,0x40,0x01,0x40,0x01,0x40,0x02,0x20,0x02,0x20,
   0x04,0x10,0x18,0x0c,0xe0,0x03,0x00,0x00
};
static char mbfplanet_bits[] = {
   0xe0,0x03,0x18,0x0c,0x04,0x10,0xfe,0x3f,0x02,0x20,0x01,0x40,
   0x01,0x40,0xff,0x7f,0x01,0x40,0x01,0x40,0x02,0x20,0xfe,0x3f,
   0x04,0x10,0x18,0x0c,0xe0,0x03,0x00,0x00
};
static char mbrplanet_bits[] = {
   0xe0,0x03,0x58,0x0c,0x84,0x10,0x0a,0x21,0x12,0x22,0x21,0x44,
   0x43,0x48,0x85,0x50,0x09,0x61,0x11,0x42,0x22,0x24,0x42,0x28,
   0x84,0x10,0x18,0x0d,0xe0,0x03,0x00,0x00
};
static char mbkplanet_bits[] = {
   0xe0,0x03,0x98,0x0c,0x8c,0x18,0x8a,0x28,0x8a,0x28,0x89,0x48,
   0x89,0x48,0x89,0x48,0x89,0x48,0x89,0x48,0x8a,0x28,0x8a,0x28,
   0x8c,0x18,0x98,0x0c,0xe0,0x03,0x00,0x00
};
static char mboplanet_bits[] = {
   0xe0,0x03,0x18,0x0d,0x84,0x10,0x42,0x28,0x22,0x24,0x11,0x42,
   0x09,0x61,0x85,0x50,0x43,0x48,0x21,0x44,0x12,0x22,0x0a,0x21,
   0x84,0x10,0x58,0x0c,0xe0,0x03,0x00,0x00
};
static char mbbplanet_bits[] = {
   0xe0,0x03,0x18,0x0c,0x04,0x10,0x02,0x20,0x02,0x20,0xc1,0x41,
   0xe1,0x43,0xe1,0x43,0xe1,0x43,0xc1,0x41,0x02,0x20,0x02,0x20,
   0x04,0x10,0x18,0x0c,0xe0,0x03,0x00,0x00
};
static char mbpulsar_bits[] = {
   0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0xd0,0x05,0x20,0x02,
   0x10,0x04,0x1e,0x3c,0x10,0x04,0x20,0x02,0xd0,0x05,0x80,0x00,
   0x80,0x00,0x80,0x00,0x80,0x00,0x00,0x00
};
static char mbblackhole_bits[] = {
   0xe0,0x03,0x30,0x00,0x98,0x0f,0xcc,0x1f,0xec,0x31,0xed,0x67,
   0xfd,0x4f,0xfd,0x5f,0xf9,0x5f,0xf3,0x5b,0xc6,0x1b,0xfc,0x19,
   0xf8,0x0c,0x00,0x06,0xe0,0x03,0x00,0x00
};

#define mbnebula_width 48
#define mbnebula_height 48
static char mbnebula_bits[] = {
   0x40,0x00,0x00,0x0e,0x00,0x00,0x10,0xfd,0x87,0x8b,0x00,0x00,
   0x64,0xb1,0xc2,0xfe,0x00,0x79,0x18,0x5d,0xe8,0x36,0x8a,0x15,
   0x56,0xbf,0x6c,0x3c,0x8c,0x17,0x88,0xe3,0xbe,0x1d,0x03,0x1d,
   0x0c,0xb6,0x4d,0x17,0x12,0x3b,0x04,0xfc,0xfe,0x3f,0xe5,0x0f,
   0x02,0xd0,0xf7,0x0d,0xb0,0x6a,0x04,0xfc,0x4f,0x1a,0xbc,0x67,
   0x02,0xec,0x35,0x1c,0x3e,0x37,0x0a,0xd0,0x07,0x3c,0xef,0x3c,
   0x0e,0xf0,0x26,0xbf,0xe2,0x03,0x7c,0xda,0xff,0xff,0xfb,0x1b,
   0x3c,0xfa,0x6f,0xff,0xff,0x17,0x7e,0xfe,0xff,0xbe,0xf4,0x30,
   0x3f,0x6f,0xee,0xff,0x7c,0x13,0xfc,0xfb,0xef,0xff,0x1f,0x0e,
   0xad,0xff,0xff,0xff,0xff,0x2f,0xf4,0x7a,0xfe,0xff,0x9f,0x59,
   0x98,0x0f,0xff,0xff,0xcf,0x77,0x80,0x0e,0xfd,0xff,0x8f,0x5e,
   0x00,0x86,0xff,0xff,0x2b,0x78,0x00,0x80,0xff,0xff,0xfb,0x6f,
   0xa0,0xf0,0xfe,0xff,0x2f,0x4b,0xe8,0xa8,0xff,0xff,0xf7,0x43,
   0x74,0x9d,0xff,0xff,0x7f,0x01,0xe8,0xd8,0xfe,0xef,0x0f,0x01,
   0xb4,0xc5,0x7b,0xff,0xc1,0x18,0xd8,0xbd,0xff,0xef,0x01,0x13,
   0x52,0x9d,0x7f,0xef,0xa7,0x5a,0x70,0x14,0xcf,0xdb,0x83,0x60,
   0xc0,0x19,0xe6,0xe6,0x01,0x28,0x00,0x05,0xf1,0xee,0x43,0x12,
   0x68,0x81,0xe1,0xff,0xeb,0x01,0x48,0x03,0xc0,0xff,0x61,0x01,
   0xdc,0x32,0x99,0xff,0xf1,0x07,0x00,0x7f,0xfc,0xe3,0xdf,0x03,
   0x04,0xfe,0xff,0xb2,0x7e,0x0d,0x10,0xe6,0xff,0xc1,0xf7,0x0f,
   0x40,0xfc,0x3f,0x49,0x1d,0x10,0x24,0xff,0x7b,0x81,0x69,0x10,
   0x42,0xfd,0xbf,0x80,0x9e,0x19,0xc8,0x5e,0xd3,0x4a,0x13,0x0e,
   0x30,0xf8,0xf7,0x00,0xe2,0x03,0x40,0x12,0x8d,0x04,0x00,0x0e,
   0x00,0x80,0x0b,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
};

/* lockon indicators */
#define lock_width 28
#define lock_height 28
static char wlock_bits[] = {
   0x00,0x00,0x00,0x00,0x06,0x00,0x00,0x06,0x7e,0x00,0xe0,0x07,
   0x3c,0x00,0xc0,0x03,0x1c,0x00,0x80,0x03,0x0c,0x00,0x00,0x03,
   0x04,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x04,0x00,0x00,0x02,0x0c,0x00,0x00,0x03,0x1c,0x00,0x80,0x03,
   0x3c,0x00,0xc0,0x03,0x7e,0x00,0xe0,0x07,0x06,0x00,0x00,0x06,
   0x00,0x00,0x00,0x00
};

static char nlock_bits[] = {
   0x00,0xf8,0x00,0x00,0x00,0xfc,0x01,0x00,0x00,0x70,0x00,0x00,
   0x00,0x20,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x02,0x00,0x00,0x00,0x03,0x00,0x00,0x04,
   0x07,0x00,0x00,0x0c,0x0f,0x00,0x00,0x0e,0x07,0x00,0x00,0x0f,
   0x03,0x00,0x00,0x0e,0x02,0x00,0x00,0x0c,0x00,0x00,0x00,0x04,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x40,0x00,0x00,0x00,0xe0,0x00,0x00,0x00,0xf8,0x03,0x00,
   0x00,0xf0,0x01,0x00
};

#define pvortex_width 15
#define pvortex_height 15
static char pvortex_bits[4][30] = {
{ 0x80, 0x00, 0x80, 0x00, 0x80, 0x00, 0x88, 0x08, 0xd0, 0x05, 0xa0,
  0x02, 0xd0, 0x05, 0x7f, 0x7f, 0xd0, 0x05, 0xa0, 0x02, 0xd0, 0x05,
  0x88, 0x08, 0x80, 0x00, 0x80, 0x00, 0x80, 0x00},

{ 0x00, 0x00, 0x10, 0x00, 0x20, 0x02, 0x20, 0x02, 0xe0, 0x21, 0x6c,
  0x1e, 0xd0, 0x07, 0x50, 0x05, 0xf0, 0x05, 0x3c, 0x1b, 0xc2, 0x03,
  0x20, 0x02, 0x20, 0x02, 0x00, 0x04, 0x00, 0x00},

{ 0x00, 0x00, 0x00, 0x00, 0x84, 0x10, 0x88, 0x08, 0xd0, 0x05, 0xa0,
  0x02, 0xd0, 0x05, 0x7c, 0x1f, 0xd0, 0x05, 0xa0, 0x02, 0xd0, 0x05,
  0x88, 0x08, 0x84, 0x10, 0x00, 0x00, 0x00, 0x00},

{ 0x00, 0x00, 0x00, 0x04, 0x20, 0x02, 0x20, 0x02, 0xc2, 0x03, 0x3c,
  0x1b, 0xf0, 0x05, 0x50, 0x05, 0xd0, 0x07, 0x6c, 0x1e, 0xe0, 0x21,
  0x20, 0x02, 0x20, 0x02, 0x10, 0x00, 0x00, 0x00},
};

#define ast_width  8
#define ast_height 8
static char ast0_bits[] = {
   0x38, 0x38, 0x20, 0x00, 0x98, 0xfe, 0x7c, 0x38};
static char ast1_bits[] = {
   0x18, 0x38, 0x7f, 0x7f, 0x0f, 0x0e, 0x00, 0x00};
static char ast2_bits[] = {
   0x18, 0x3c, 0x7f, 0x7f, 0x7f, 0x16, 0x00, 0x00};
static char ast3_bits[] = {
   0x00, 0x00, 0x30, 0x78, 0x7c, 0x7c, 0x38, 0x00};
static char ast4_bits[] = {
   0x60, 0xf0, 0xf0, 0x60, 0x02, 0x07, 0x26, 0x00};
static char ast5_bits[] = {
   0x1c, 0x38, 0x78, 0x7f, 0x7f, 0x3e, 0x0c, 0x00};
static char ast6_bits[] = {
   0x00, 0x04, 0x0f, 0x7e, 0xfe, 0x3c, 0x30, 0x00};
static char ast7_bits[] = {
   0x1c, 0x0e, 0x0f, 0x7e, 0x7e, 0x7c, 0x2c, 0x00};

#define mast_field_width 32
#define mast_field_height 32
static char mast_field_bits[] = {
   0x03, 0x40, 0x00, 0x80, 0x83, 0x61, 0x08, 0x0c, 0x00, 0x07, 0x60, 0x0c,
   0x24, 0x46, 0x78, 0xd0, 0x20, 0x00, 0x1c, 0xc0, 0x18, 0x00, 0x1c, 0x00,
   0x18, 0x30, 0xc0, 0x01, 0x04, 0x01, 0xd0, 0x01, 0x00, 0x60, 0xc0, 0x41,
   0x0d, 0x00, 0x00, 0x00, 0xcc, 0x01, 0x00, 0x18, 0xc0, 0x01, 0x00, 0xd0,
   0xc0, 0x00, 0x80, 0x4c, 0x06, 0x00, 0x80, 0x00, 0x46, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x1c, 0x44, 0x00, 0x00, 0x1c, 0x20, 0x00, 0x00, 0x1c,
   0x71, 0x00, 0x00, 0x00, 0xf8, 0x00, 0x00, 0xc0, 0xf8, 0x00, 0x00, 0xc1,
   0x78, 0x00, 0x00, 0x38, 0x74, 0x00, 0x40, 0x38, 0x06, 0x0c, 0x1c, 0x38,
   0x06, 0x00, 0x3e, 0x01, 0x04, 0x00, 0x9e, 0x30, 0xc0, 0x22, 0x1c, 0x00,
   0xc0, 0x70, 0x00, 0x00, 0x00, 0x60, 0x0c, 0x12, 0x06, 0x00, 0x00, 0x40,
   0x07, 0x19, 0x1c, 0xe1, 0x00, 0x01, 0x1c, 0xc0};
