      subroutine bzone_place_objects (xcrd, ycrd, azm, obx, oby, oazm,
     &                                ospeed, object, explode, super,
     &                                missile, copter, reset, fresh,
     &                                dead, score, new, height, seed)
c
c     BZONE_PLACE_OBJECTS replaces any missing object such as a cube
c     or enemy tank.
c
% include '/sys/ins/time.ins.ftn'
      integer*2 clock(3)
      integer score, lander_count, lander, status
      real xcrd, ycrd, azm, obx(12), oby(12), oazm(12), ospeed(12)
      real seed, pi2, dazm, r
      logical object(12), explode(4), super, missile, reset, new, dead
      logical fresh, copter
      save pi2, lander_count, lander, clock
      data pi2 / 6.283185306/
      data lander_count, lander /0, 1000/
      data clock / 0, 0, 5000/
c
c    replace tanks and missiles
c
      lander_count = lander_count + 1
      if (.not. object(1) .and. .not. explode(1) .and. .not. dead) then
        if (missile) then
c
c    ring the bell to signal missile
c
          call tone_$time (clock)
          call time_$wait (time_$relative, clock, status)
          call time_$wait (time_$relative, clock, status)
          call tone_$time (clock)
          call time_$wait (time_$relative, clock, status)
          call time_$wait (time_$relative, clock, status)
          call tone_$time (clock)
          odds = score / 500000.0
          if (score .lt. 75000) odds = 0.0
          if (odds .gt. 0.333) odds = 0.333
          call rand (seed)
          if (seed .lt. odds) then
            copter = .true.
            scale = 0.2
            fresh = .true.
            height = 150.0
            r = 1900
          else
            copter = .false.
            scale = 0.1
            height = 250.0
            fresh = .true.
            r = 1750
          end if
          call rand (seed)
          dazm = seed * scale
          call rand (seed)
          if (seed .gt. 0.5) dazm = - dazm
          dazm = dazm + azm
          ca = cos(dazm)
          sa = sin(dazm)
          obx(1) = xcrd - r * sa
          oby(1) = ycrd + r * ca
          object(1) = .true.
          call rand (seed)
          dazm = seed * 0.015 / scale
          call rand (seed)
          if (seed .gt. 0.5) dazm = - dazm
          oazm(1) = azm - 3.141 + dazm
        else
c
c    pick regular or super based on score
c
          odds = (60000.0 - score) / 30000.0
          if (odds .lt. 0.10) odds = 0.10
          call rand (seed)
          super = .true.
          if (seed .lt. odds) super = .false.
c
c    use cylindrical coordinates to place enemy tank
c
          call rand (seed)
          r = 800.0 + 1200.0 * seed
          call rand (seed)
          dazm = seed * pi2
          obx(1) = xcrd + r * cos(dazm)
          oby(1) = ycrd + r * sin(dazm)
          call rand (seed)
          oazm(1) = seed * pi2
          object(1) = .true.
          reset = .true.
        end if
      end if
c
c    lander
c
      if (lander_count .gt. lander) then
        if (.not. object(2) .and. .not. explode(2)) then
          call rand (seed)
          r = 1500.0 + 500.0 * seed
          call rand (seed)
          dazm    = seed * pi2
          obx(2) = xcrd + r * cos(dazm)
          oby(2) = ycrd + r * sin(dazm)
          call rand (seed)
          oazm(2) = seed * pi2
          call rand (seed)
          ospeed(2) = seed * 10.0
          object(2) = .true.
        end if
      end if
c
c    remaining objects
c
      if (.not. new) then
        do 10 i = 5, 12
          if (.not. object(i)) then
            r = 2000.0
            call rand (seed)
            dazm = seed * pi2
            obx(i) = xcrd + r * cos(dazm)
            oby(i) = ycrd + r * sin(dazm)
            object(i) = .true.
          end if
 10     continue
      else
        do 20 i = 5, 12
          if (.not. object(i)) then
            call rand (seed)
            r = 400 + seed * 1800.0
            call rand (seed)
            dazm = seed * pi2
            obx(i) = xcrd + r * cos(dazm)
            oby(i) = ycrd + r * sin(dazm)
            object(i) = .true.
          end if
 20     continue
      end if
      return
      end





      subroutine bzone_move_lander (xcrd, ycrd, obx, oby, oazm, ospeed,
     &                              orange, seed)
c
c     BZONE_MOVE_LANDER moves the lander about when present
c
      integer*4 cl
      real xcrd, ycrd, obx(12), oby(12), oazm(12), ospeed(12), seed
      real orange(12), pi
      save pi, cl
      data pi, cl / 3.14, 0/
      cl = cl + 1
      if (cl .gt. 20) then
        cl = 0
c
c    determine range and move accordingly
c
        if (orange(2) .le. 750.0) then
c
c    move away from
c
          dx = obx(2) - xcrd
          dy = oby(2) - ycrd
          if (abs(dx) .lt. 1e-3) dx = sign (1e-3, dx)
          oazm(2) = atan2(dy, dx)
        end if
c
c    add a random component
c
        call rand (seed)
        if (seed .ge. 0.5) then
          call rand (seed)
          theta = oazm(2) + seed * pi / 4.0
        else
          call rand (seed)
          theta = oazm(2) - seed * pi / 4.0
        end if
        oazm(2) = theta
        call rand (seed)
        ospeed(2) = seed * 20.0
      end if
      return
      end





      subroutine bzone_move_missile (xcrd, ycrd, azm, rotate, speed,
     &                               obx, oby, oazm, ospeed, orotate,
     &                               orange, object, blocked, reset,
     &                               first, height, pro_y, seed)
c
c     BZONE_MOVE_MISSILE moves the enemy missile
c
      integer*4 score, count
      real xcrd, ycrd, azm, rotate, speed, obx(12), oby(12), oazm(12)
      real ospeed(12), orotate(12), orange(12), height, seed, pro_y
      logical reset, object(12), blocked, first
      save count, pi
      data count / 10/
      data pi /3.14159265/
c
c    statement function for converting degrees to radians
c
      ra(x) = x * pi / 180.0
c
c    increment counters and adjust height
c
      orotate(1) = 0.0
      count = count + 1
      height = height - 25.0
      if (height .le. 0.0) height = 0.0
      if (blocked) height = 90.0
c
c    move towards the player as usual
c
      ospeed(1) = 35.0
      if (height .gt. 91.0) ospeed(1) = 0.0
      if (count .ge. 12) then
        count = 0
        if (pro_y .gt. 100.0) then
          dx = xcrd - obx(1)
          dy = ycrd - oby(1)
          if (abs(dy) .lt. 1.e-7) dy = sign(1.e-7, dy)
          if (dy .le. 0.0) then
            tazm = - atan(dx / dy) + ra (180.0)
          else
            tazm = - atan(dx / dy)
          end if
          if (oazm(1) .gt. 2.0 * pi) oazm(1) = oazm(1) - 2.0 * pi
          if (oazm(1) .lt. 0.0) oazm(1) = 2.0 * pi + oazm(1)
          t1 = (tazm - oazm(1))
          t3 = (tazm - (oazm(1) - 2.0 * pi))
          if (abs(t3) .lt. abs(t1)) t1 = t3
          if (.not. first) then
            call rand (seed)
            dt1 = seed * 0.5
            dt1 = sign (dt1, t1)
            call rand (seed)
            if (seed .gt. 0.8) dt1 = - dt1
            t1 = t1 + dt1
          end if
          if (abs(t1) .gt. 0.90) t1 = sign (0.90, t1)
          orotate(1) = t1
        else
          tazm = azm - pi
          if (tazm .lt. 0.0) tazm = 2.0 * pi + tazm
          if (tazm .gt. 2.0 * pi) tazm = tazm - 2.0 * pi
          if (oazm(1) .lt. 0.0) oazm(1) = 2.0 * pi + oazm(1)
          if (oazm(1) .gt. 2.0 * pi) oazm(1) = oazm(1) - 2.0 * pi
          t1 = (tazm - oazm(1))
          t2 = (tazm - (oazm(1) - 2.0 * pi))
          if (abs(t2) .lt. abs(t1)) t1 = t2
          if (abs(t1) .gt. 0.90) t1 = sign (0.90, t1)
          orotate(1) = t1
        end if
      end if
      return
      end





      subroutine bzone_move_copter (xcrd, ycrd, azm, rotate, speed,
     &                              obx, oby, oazm, ospeed, orotate,
     &                              orange, object, blocked, reset,
     &                              new, mcount, height, pro_y, seed)
c
c     BZONE_MOVE_COPTER moves the enemy helicopter
c
      integer*4 count, mcount, exist
      real xcrd, ycrd, azm, rotate, speed, obx(12), oby(12), oazm(12)
      real ospeed(12), orotate(12), orange(12), height, seed, pro_y
      logical reset, new, object(12), blocked, shoot
      save count, pi, tol, exist, side, shoot
      data count, exist, raise / 10, 0, 0/
      data pi, tol /3.14159265, 6000/
      data shoot / .true./
c
c    statement function for converting degrees to radians
c
      ra(x) = x * pi / 180.0
c
c    what the counters and resets mean:
c
c     reset  the player has died **dont shoot anymore**
c     new    the copter has just been started
c     count  passes since last strategy update
c     exist  passes since creation
c
      count = count + 1
      exist = exist + 1
      if (reset) then
        count = 0
        shoot = .false.
        reset = .false.
      end if
      if (new) then
        count = 10
        exist = 0
        shoot = .true.
        new = .false.
        call rand (seed)
        if (seed .gt. 0.5) then
          side = pi / 2.0
        else
          side =-pi / 2.0
        end if
      end if
c
c    adjust height on the basis of exist and range
c
      if (exist .lt. 200 .and. orange(1) .gt. 350.0) then
        if (.not. object(4)) then
          height = height - 5.0
        else
          height = height + 5.0
        end if
      else
        height = height + 7.5
      end if
      if (height .le. 40.0) height = 40.0
      if (height .gt. 150.0) height = 150.0
      if (blocked .and. height .lt. 90.0) height = 90.0
c
c    move towards the player as usual
c
      ospeed(1) = 25.0
      if (count .ge. 10) then
        count = 0
        if (orange(1) .gt. 200.0 .and. exist .lt. 200) then
          dx = xcrd - obx(1)
          dy = ycrd - oby(1)
          if (abs(dx) .lt. 1.e-3) dx = sign(1.e-3, dx)
          if (abs(dy) .lt. 1.e-3) dy = sign(1.e-3, dy)
          tazm = - atan2(dx, dy)
          if (oazm(1) .gt. 2.0 * pi) oazm(1) = oazm(1) - 2.0 * pi
          if (oazm(1) .lt. 0.0) oazm(1) = 2.0 * pi + oazm(1)
          t1 = (tazm - oazm(1)) / 10.0
          t3 = (tazm - (oazm(1) - 2.0 * pi)) /10.0
          if (abs(t3) .lt. abs(t1)) t1 = t3
          if (abs(t1) .gt. 0.10) t1 = sign (0.10, t1)
          orotate(1) = t1
          if (abs(orotate(1)) .gt. 0.10) ospeed(1) = 5.0
        else
          tazm = side
          if (tazm .lt. 0.0) tazm = 2.0 * pi + tazm
          if (tazm .gt. 2.0 * pi) tazm = tazm - 2.0 * pi
          if (oazm(1) .lt. 0.0) oazm(1) = 2.0 * pi + oazm(1)
          if (oazm(1) .gt. 2.0 * pi) oazm(1) = oazm(1) - 2.0 * pi
          t1 = (tazm - oazm(1)) / 10.0
          t2 = (tazm - (oazm(1) - 2.0 * pi)) / 10.0
          if (abs(t2) .lt. abs(t1)) t1 = t2
          if (abs(t1) .gt. 0.06) t1 = sign (0.06, t1)
          orotate(1) = t1
          ospeed(1)= 30.0
        end if
      end if
c
c    if down consider firing
c
      if (shoot) then
        if (height .lt. 50.0 .and. .not. object(4)) then
c
c    compute the incremental angles for the player tank
c
          cp = cos(azm)
          sp = sin(azm)
          dcp = cos(rotate)
          dsp = sin(rotate)
          cm = cos(oazm(1))
          sm = sin(oazm(1))
c
c    project missile and player tank positions ahead for the next 40
c    turns and see if they ever coincide within tolerance of each
c    other.
c
          i = 0
          xmt = obx(1)
          ymt = oby(1)
          xpt = xcrd
          ypt = ycrd
          rate = 40.0
10        continue
            i = i + 1
            if (i .gt. 50) goto 20
            temp = cp
            cp = cp * dcp - sp * dsp
            sp = sp * dcp + dsp * temp
            xmt = xmt - sm * rate
            ymt = ymt + cm * rate
            xpt = xpt - sp * speed
            ypt = ypt + cp * speed
            dist = (xpt - xmt)**2 + (ymt - ypt)**2
            if (dist .le. tol) then
              object(4) = .true.
              obx(4)    = obx(1)
              oby(4)    = oby(1)
              oazm(4)   = oazm(1)
              ospeed(4) = 40.0
              mcount = 0
              call bzone_message (4, .true.)
              goto 20
            end if
            goto 10
20        continue
        end if
      end if
      return
      end







      subroutine bzone_move_super (xcrd, ycrd, ca, sa, rotate, speed,
     &                             obx, oby, oazm, ospeed, orotate,
     &                             orange, object, mcount, blocked,
     &                             player, new, seed)
c
c     BZONE_MOVE_SUPER is the routine for moving the super enemy
c     tanks about.
c
      integer mcount, count, fire, bcount, exist
      real xcrd, ycrd, obx(12), oby(12), oazm(12), ospeed(12)
      real orotate(12), orange(12), seed, rotate, tol
      logical blocked, object(12), evasive, preset, player
      logical new, last
      save count, bcount, pi, evasive, preset, fire, tol
      save exist, last, direct
      data count, bcount, fire / 10, 0, 0/
      data preset, last / 2 * .false./
      data pi /3.14159265/
      data tol / 14400/
      data exist / 0/
      data direct / 1.0/
c
c    what the variables mean:
c
c     xcrd, ycrd    - position of the player tank
c     speed, rotate - speed and rate of rotation of the player tank
c     ca, sa        - the current angles of the player tank
c     obx, oby      - positions of all other objects, object 1 is
c                     the enemy
c     oazm          - azimuth angles for all other objects
c     ospeed        - speed of all other objects
c     orotate       - rate of rotation of all other objects
c     orange        - range from player ship to all objects
c     object        - logical variable, true if object exists
c     mcount        - the number of rounds a enemy missile has
c                     existed
c     blocked       - logical variable, if true enemy tank is
c                     blocked
c     player        - logical variable, if true and blocked then the
c                     player tank blocks the enemy ship
c     seed          - seed for the random number generator
c     count         - saved variable for keeping track of rounds
c                     between enemy tank rethinks
c     evasive       - logical variable, if false then the enemy tank
c                     if avoiding an object, if true the tank is
c                     avoiding the player.
c     preset        - logical variable, if true the enemy tank is
c                     performing a preset maneuver
c     new           - logical variable, if true a new enemy tank has
c                     appeared, signal to reset all variables
c
c
c    statement function for converting degrees to radians
c
      ra(x) = x * pi / 180.0
c
c    if new then reset all internal variables
c
      count = count + 1
      fire = fire + 1
      exist = exist + 1
      if (new) then
        preset = .false.
        count = 10
        bcount = 0
        fire = 15
        exist = 0
        new = .false.
        last = .false.
        direct = 1.0
      end if
c
c    get direction to use in moving away from block
c
      if (blocked .and. last) then
        direct = -direct
      end if
c
c    deal with blocked paths if necessary
c
      last = .false.
      if (blocked .and. player) then
c
c    set up maneuver to retreat slightly and adjust direction to fire
c    on player tank quickly
c
        evasive = .true.
        preset  = .true.
        bcount  = 0
        last = .true.
      else if (blocked .and. (.not. player)) then
c
c    set up maneuver to retreat from object while turning then move past
c    object and return to normal movement
c
        evasive = .false.
        preset  = .true.
        bcount  = 0
        last = .true.
      end if
c
c    execute a preset maneuver
c
      if (preset) then
        bcount = bcount + 1
        if (.not. evasive) then
          if (bcount .eq. 1) then
            ospeed(1)  = -12.0 * direct
            orotate(1) = 0.045
            call rand (seed)
            if (seed .gt. 0.5) orotate(1) = -orotate(1)
          else if (bcount .eq. 30) then
            ospeed(1) = 12.0 * direct
            orotate(1) = 0.0
          else if (bcount .gt. 60) then
            preset = .false.
          end if
        else
          if (bcount .eq. 1) then
            ospeed(1)  = -12.0 * direct
            orotate(1) = 0.0
          else if (bcount .eq. 10 .or. bcount .eq. 15 .or.
     &             bcount .eq. 20 .or. bcount .eq. 25) then
            dx = xcrd - obx(1)
            dy = ycrd - oby(1)
            if (abs(dy) .lt. 1.e-7) dy = sign(1.e-7, dy)
            if (dy .le. 0.0) then
              tazm = - atan(dx / dy) + ra (180.0)
            else
              tazm = - atan(dx / dy)
            end if
            if (oazm(1) .gt. 2.0 * pi) oazm(1) = oazm(1) - 2.0 * pi
            if (oazm(1) .lt. 0.0) oazm(1) = 2.0 * pi + oazm(1)
            t1 = (tazm - oazm(1)) / 5.0
            t3 = (tazm - (oazm(1) - 2.0 * pi)) / 5.0
            if (abs(t3) .lt. abs(t1)) t1 = t3
            if (abs(t1) .gt. 0.045) t1 = sign (.045, t1)
            orotate(1) = t1
            ospeed(1) = 0.0
          else if (bcount .gt. 30) then
              preset = .false.
          end if
        end if
      else if (count .ge. 5) then
c
c    chase the player tank as per normal
c
        direct = 1.0
        count = 0
        dx = xcrd - obx(1)
        dy = ycrd - oby(1)
        if (abs(dy) .lt. 1.e-7) dy = sign(1.e-7, dy)
        if (dy .le. 0.0) then
          tazm = - atan(dx / dy) + ra (180.0)
        else
          tazm = - atan(dx / dy)
        end if
        if (oazm(1) .gt. 2.0 * pi) oazm(1) = oazm(1) - 2.0 * pi
        if (oazm(1) .lt. 0.0) oazm(1) = 2.0 * pi + oazm(1)
        t1 = (tazm - oazm(1)) / 5.0
        t3 = (tazm - (oazm(1) - 2.0 * pi)) / 5.0
        if (abs(t3) .lt. abs(t1)) t1 = t3
c
c    if the angle is large then turn fast and move slow, else
c    move fast and turn slow.
c
        ospeed(1) = 12.0 * (pi - abs(t1) * 5.0) / pi
        if (abs(t1) .gt. 0.045) t1 = sign (0.045, t1)
        orotate(1) = t1
      end if
c
c    adjust rotate rates and speed to reflect tank track limitations
c
      scrot = orotate(1) / 0.045 * 12.0
      sctot = sqrt (ospeed(1)**2 + scrot**2)
      if (sctot .gt. 12.0) then
        scale = 12.0 / sctot
        ospeed(1) = ospeed(1) * scale
        orotate(1) = orotate(1) * scale
      end if
c
c    consider firing a missile if practical
c
      if (fire .gt. 10 .and. (.not. object(4)) .and.
     &    exist .gt. 50) then
        fire = 0
c
c    compute the incremental angles for the player tank
c
        cp = ca
        sp = sa
        dcp = cos(rotate)
        dsp = sin(rotate)
        cm = cos(oazm(1))
        sm = sin(oazm(1))
c
c    project missile and player tank positions ahead for the next 40
c    turns and see if they ever coincide within tolerance of each
c    other.
c
        i = 0
        xmt = obx(1)
        ymt = oby(1)
        xpt = xcrd
        ypt = ycrd
        rate = 40.0
10      continue
          i = i + 1
          if (i .gt. 50) goto 20
          temp = cp
          cp = cp * dcp - sp * dsp
          sp = sp * dcp + dsp * temp
          xmt = xmt - sm * rate
          ymt = ymt + cm * rate
          xpt = xpt - sp * speed
          ypt = ypt + cp * speed
          dist = (xpt - xmt)**2 + (ymt - ypt)**2
          if (dist .le. tol) then
            object(4) = .true.
            obx(4)    = obx(1)
            oby(4)    = oby(1)
            oazm(4)   = oazm(1)
            ospeed(4) = 40.0
            mcount = 0
            call bzone_message (3, .true.)
            goto 20
          end if
          goto 10
20      continue
      end if
      return
      end





      subroutine bzone_move_tank (xcrd, ycrd, ca, sa, rotate, speed,
     &                            obx, oby, oazm, ospeed, orotate,
     &                            orange, object, mcount, blocked,
     &                            player, new, seed)
c
c     BZONE_MOVE_TANK is the routine for moving the enemy tanks about.
c
      integer mcount, count, fire, bcount, exist
      real xcrd, ycrd, obx(12), oby(12), oazm(12), ospeed(12)
      real orotate(12), orange(12), seed, rotate, tol
      logical blocked, object(12), evasive, preset, player
      logical new, last
      save count, bcount, pi, evasive, preset, fire, tol
      save exist, direct, last
      data count, bcount, fire / 10, 0, 0/
      data preset, last / 2 * .false./
      data pi /3.14159265/
      data tol / 14400/
      data exist / 0/
c
c    what the variables mean:
c
c     xcrd, ycrd    - position of the player tank
c     speed, rotate - speed and rate of rotation of the player tank
c     ca, sa        - the current angles of the player tank
c     obx, oby      - positions of all other objects, object 1 is
c                     the enemy
c     oazm          - azimuth angles for all other objects
c     ospeed        - speed of all other objects
c     orotate       - rate of rotation of all other objects
c     orange        - range from player ship to all objects
c     object        - logical variable, true if object exists
c     mcount        - the number of rounds a enemy missile has
c                     existed
c     blocked       - logical variable, if true enemy tank is
c                     blocked
c     player        - logical variable, if true and blocked then the
c                     player tank blocks the enemy ship
c     seed          - seed for the random number generator
c     count         - saved variable for keeping track of rounds
c                     between enemy tank rethinks
c     evasive       - logical variable, if false then the enemy tank
c                     if avoiding an object, if true the tank is
c                     avoiding the player.
c     preset        - logical variable, if true the enemy tank is
c                     performing a preset maneuver
c     new           - logical variable, if true a new enemy tank has
c                     appeared, signal to reset all variables
c
c
c    statement function for converting degrees to radians
c
      ra(x) = x * pi / 180.0
c
c    if new then reset all internal variables
c
      count = count + 1
      fire = fire + 1
      exist = exist + 1
      if (new) then
        preset = .false.
        count = 5
        bcount = 0
        fire = 5
        exist = 0
        new = .false.
        direct = 1.0
        last = .false.
      end if
      if (blocked .and. last) then
        direct = -direct
      end if
      last = .false.
c
c    deal with blocked paths if necessary
c
      if (blocked .and. player) then
c
c    set up maneuver to retreat slightly and adjust direction to fire
c    on player tank quickly
c
        evasive = .true.
        preset  = .true.
        bcount  = 0
        last = .true.
      else if (blocked .and. (.not. player)) then
c
c    set up maneuver to retreat from object while turning then move past
c    object and return to normal movement
c
        evasive = .false.
        preset  = .true.
        bcount  = 0
        last = .true.
      end if
c
c    execute a preset maneuver
c
      if (preset) then
        bcount = bcount + 1
        if (.not. evasive) then
          if (bcount .eq. 1) then
            ospeed(1)  = -8.0 * direct
            orotate(1) = 0.030
            call rand (seed)
            if (seed .gt. 0.5) orotate(1) = -orotate(1)
          else if (bcount .eq. 45) then
            ospeed(1)  = 8.0 * direct
            orotate(1) = 0.0
          else if (bcount .gt. 90) then
            preset = .false.
          end if
        else
          if (bcount .eq. 1) then
            ospeed(1)  = -8.0 * direct
            orotate(1) = 0.0
          else if (bcount .eq. 10 .or. bcount .eq. 15 .or.
     &             bcount .eq. 20 .or. bcount .eq. 25) then
            dx = xcrd - obx(1)
            dy = ycrd - oby(1)
            if (abs(dy) .lt. 1.e-7) dy = sign(1.e-7, dy)
            if (dy .le. 0.0) then
              tazm = - atan(dx / dy) + ra (180.0)
            else
              tazm = - atan(dx / dy)
            end if
            if (oazm(1) .gt. 2.0 * pi) oazm(1) = oazm(1) - 2.0 * pi
            if (oazm(1) .lt. 0.0) oazm(1) = 2.0 * pi + oazm(1)
            t1 = (tazm - oazm(1)) / 5.0
            t3 = (tazm - (oazm(1) - 2.0 * pi)) / 5.0
            if (abs(t3) .lt. abs(t1)) t1 = t3
            if (abs(t1) .gt. 0.030) t1 = sign (.030, t1)
            orotate(1) = t1
            ospeed(1) = 0.0
          else if (bcount .gt. 30) then
              preset = .false.
          end if
        end if
      else if (count .ge. 10) then
c
c    chase the player tank as per normal
c
        direct = 1.0
        count = 0
        dx = xcrd - obx(1)
        dy = ycrd - oby(1)
        if (abs(dy) .lt. 1.e-7) dy = sign(1.e-7, dy)
        if (dy .le. 0.0) then
          tazm = - atan(dx / dy) + ra (180.0)
        else
          tazm = - atan(dx / dy)
        end if
        if (oazm(1) .gt. 2.0 * pi) oazm(1) = oazm(1) - 2.0 * pi
        if (oazm(1) .lt. 0.0) oazm(1) = 2.0 * pi + oazm(1)
        t1 = (tazm - oazm(1)) / 10.0
        t3 = (tazm - (oazm(1) - 2.0 * pi)) / 10.0
        if (abs(t3) .lt. abs(t1)) t1 = t3
c
c    if the angle is large then turn fast and move slow, else
c    move fast and turn slow.
c
        ospeed(1) = 8.0 * (pi - abs(t1) * 10.0) / pi
        if (abs(t1) .gt. 0.030) t1 = sign (0.030, t1)
        orotate(1) = t1
      end if
c
c    adjust rotate rates and speed to reflect tank track limitations
c
      scrot = orotate(1) / 0.030 * 8.0
      sctot = sqrt (ospeed(1)**2 + scrot**2)
      if (sctot .gt. 8.0) then
        scale = 8.0 / sctot
        ospeed(1) = ospeed(1) * scale
        orotate(1) = orotate(1) * scale
      end if
c
c    consider firing a missile if practical
c
      if (fire .gt. 10 .and. (.not. object(4)) .and.
     &    exist .gt. 100) then
        fire = 0
c
c    compute the incremental angles for the player tank
c
        cp = ca
        sp = sa
        dcp = cos(rotate)
        dsp = sin(rotate)
        cm = cos(oazm(1))
        sm = sin(oazm(1))
c
c    project missile and player tank positions ahead for the next 40
c    turns and see if they ever coincide within tolerance of each
c    other.
c
        i = 0
        xmt = obx(1)
        ymt = oby(1)
        xpt = xcrd
        ypt = ycrd
        rate = 40.0
10      continue
          i = i + 1
          if (i .gt. 50) goto 20
          temp = cp
          cp = cp * dcp - sp * dsp
          sp = sp * dcp + dsp * temp
          xmt = xmt - sm * rate
          ymt = ymt + cm * rate
          xpt = xpt - sp * speed
          ypt = ypt + cp * speed
          dist = (xpt - xmt)**2 + (ymt - ypt)**2
          if (dist .le. tol) then
            object(4) = .true.
            obx(4)    = obx(1)
            oby(4)    = oby(1)
            oazm(4)   = oazm(1)
            ospeed(4) = 40.0
            mcount = 0
            call bzone_message (3, .true.)
            goto 20
          end if
          goto 10
20      continue
      end if
      return
      end





      subroutine rand (x)
c
c    RAND is a fast pseudo-random number generator, with a
c    unique sequence of 566927 numbers. X must be between
c    0 and 1 ( (0,1] actually ).
c
c    version 1
c                                         - jsr 8/85
c
      integer*4 k, j, m, ix, irand
      real*4 x, rm
      save k, j, m, rm
      data k, j, m, rm / 5701, 3612, 566927, 566927.0/
      ix = int (x * rm)
      irand = mod (j * ix + k, m)
      x = (real (irand) + 0.5) / rm
      return
      end
