      subroutine bzone_scores (score, num_not_rcvd, bitmap_desc)
c
c    *******************************************************************
c    *****                                                         *****
c    *****                BATTLE ZONE VERSION 1.0                  *****
c    *****                                                         *****
c    *****                      written by                         *****
c    *****                                                         *****
c    *****                 Justin S. Revenaugh                     *****
c    *****                                                         *****
c    *****                        5/86                             *****
c    *****                                                         *****
c    *****        Massachussetts Institute of Technology           *****
c    *****  Department of Earth, Atmospheric and Planetary Science *****
c    *****                                                         *****
c    *******************************************************************
c
c     BZONE_SCORES checks if the score is a top ten score, if
c     it is the player is prompted for his/her initials and
c     the score is placed on the top ten list which is displayed.
c
c     MODIFIED 9/86 to do this while still in borrowed mode, and
c     to keep a rough histogram of all scores.
c
% include '/sys/ins/gpr.ins.ftn'
% include '/sys/ins/time.ins.ftn'
c
      integer*2 decoded_clock(6), font_id, clock(3), cpos(2)
      integer*2 event_type, rectangle(4), box(2, 2)
      integer*4 score, top_scores(10), position, status, icol(0:15)
      integer*4 bitmap_desc, num_not_rcvd, top_not_rcvd(10)
      integer*4 bins(200), bin_width, xoff, yoff, entry, red, green
      integer*4 blue, text_x, text_y
      real dbin(20), max, scale, pi, x
      character*1 key
      character*3 top_initials(10), initials
      character*80 text
      logical top_ten, in_color, event
      common /color$/ icol, in_color
      data clock / 0, 6, 0/
      data entry / 15/
      data rectangle / 100, 380, 300, 25/
      data scale / 250.0/
      data pi / 3.1415926/
c
c    load the 'game over' font
c
      call gpr_$load_font_file('bzone_font',int2(10), font_id, status)
      call gpr_$set_text_font (font_id, status)
      call gpr_$set_text_value (icol(15), status)
      call gpr_$set_text_background_value (-1, status)
c
c    write game over
c
      call gpr_$move (int2(165), int2(300), status)
      call gpr_$text ('GAME@OVER', int2(9), status)
      call gpr_$load_font_file('/sys/dm/fonts/f7x13',
     &                         int2(19), font_id, status)
      call gpr_$set_text_font (font_id, status)
      call gpr_$set_text_value (icol(15), status)
      call gpr_$move (int2(165), int2(320), status)
      call gpr_$text ('1986 JSR', int2(8), status)
c
c    open score info file
c
      open (unit = 1, file = '/usr/local/lib/bzone_info')
c
c    read the top ten list
c
  5   continue
      do 10 i = 1, 10
        read (1, '(a3, i13)', end = 999, err = 999) top_initials(i),
     &                                              top_scores(i)
 10   continue
      read (1, '(10i10)', end = 999, err = 999) (bins(i), i = 1, 200)
c
c    see if the current score is high enough for the top ten
c
      rewind (1)
      top_ten = .false.
      i = 10
      position = 11
 20   continue
      if (score .gt. top_scores(i)) then
        position = i
        top_ten = .true.
      end if
      i = i - 1
      if (i .gt. 0) goto 20
c
c    clear screen after a ~3 second wait in the mean time make the
c    colors dance around a bit
c
      if (in_color) then
        do 200 x = 0.0, 2 * pi, pi / 180.0
          red   = int(real(122.0 * cos(x) + 123.0))
          green = int(real(122.0 * cos(x + pi / 2.0) + 123.0))
          blue  = int(real(122.0 * cos(x + pi ) + 123.0))
          call bzone_set_color (red, green, blue, entry)
200     continue
        red = 255
        green = 0
        blue = 0
        call bzone_set_color (red, green, blue, entry)
      else
        call time_$wait (time_$relative, clock, status)
      end if
      call bzone_clear_screen (bitmap_desc)
c
c    If top ten print out scores and prompt for player inits,
c    if not top ten then print out the top ten scores, call the
c    histogram routine and quit
c
      call gpr_$load_font_file('/sys/dm/fonts/nonie.r.16',
     &                         int2(24), font_id, status)
      call gpr_$set_text_font (font_id, status)
      call gpr_$set_text_value (icol(15), status)
      call cal_$decode_local_time (decoded_clock)
      call gpr_$disable_input (gpr_$buttons, status)
      if (top_ten) then
        write (text, 500) decoded_clock(2), decoded_clock(3),
     &                 decoded_clock(1)
500     format (' Top Ten Scores as of ',i2,'/',i2,'/',i4,':')
        call gpr_$move (int2(100), int2(110), status)
        call gpr_$text (text, int2(33), status)
        write (text, '(''       Player      Score'')')
        call gpr_$move (int2(100), int2(150), status)
        call gpr_$text (text, int2(24), status)
        call gpr_$set_text_value (icol(2), status)
        do 30 i = 1, position - 1
          write (text, '(9x, a3)') top_initials(i)
          text_y = 170 + i * 20
          call gpr_$move (int2(100), int2(text_y), status)
          call gpr_$text (text, int2(12), status)
          text(1:25) = '                         '
          write (text, '(12x, i13)') top_scores(i)
          call gpr_$inq_text_extent (text, int2(25), cpos, status)
          xoff = cpos(1) - 259
          call gpr_$move (int2(100 - xoff), int2(text_y), status)
          call gpr_$text (text, int2(25), status)
 30     continue
        write (text, '(9x, a3)') '   '
        text_y = 170 + position * 20
        call gpr_$move (int2(100), int2(text_y), status)
        call gpr_$text (text, int2(12), status)
        text(1:25) = '                         '
        write (text, '(12x, i13)') score
        call gpr_$inq_text_extent (text, int2(25), cpos, status)
        xoff = cpos(1) - 259
        call gpr_$move (int2(100 - xoff), int2(text_y), status)
        call gpr_$text (text, int2(25), status)
        do 40 i = position, 9
          write (text, '(9x, a3)') top_initials(i)
          text_y = 190 + i * 20
          call gpr_$move (int2(100), int2(text_y), status)
          call gpr_$text (text, int2(12), status)
          text(1:25) = '                         '
          write (text, '(12x, i13)') top_scores(i)
          call gpr_$inq_text_extent (text, int2(25), cpos, status)
          xoff = cpos(1) - 259
          call gpr_$move (int2(100 - xoff), int2(text_y), status)
          call gpr_$text (text, int2(25), status)
 40     continue
        call gpr_$move (int2(100), int2(400), status)
        call gpr_$text ('Enter your initials:', int2(20), status)
        initials = '   '
        do 50 i = 1, 3
 55       continue
          event = gpr_$event_wait (event_type, key, cpos, status)
          j = ichar(key)
          if (j .ge. 65 .and. j .le. 90) then
            initials(i:i) = key
          else if (j .ge. 97 .and. j .le. 122) then
            initials(i:i) = char(j - 32)
          else
            goto 55
          end if
          text_y = 170 + position * 20
          text = ' '
          text(10:12) = initials
          call gpr_$move (int2(100), int2(text_y), status)
          call gpr_$text (text, int2(12), status)
 50     continue
        call gpr_$set_fill_value (icol(0), status)
        call gpr_$rectangle (rectangle, status)
        call gpr_$move (int2(140), int2(400), status)
        call gpr_$set_text_value (icol(15), status)
c
c    rewrite the top scores file and quit
c
        do 70 i = 1, position - 1
          write (1, '(a3, i13)') top_initials(i), top_scores(i)
 70     continue
        write (1, '(a3, i13, l1)') initials, score, in_color
        do 80 i = position, 9
          write (1, '(a3, i13)') top_initials(i), top_scores(i)
 80     continue
        rewind(1)
        do 85 i = 1, 10
          read (1, '(a3, i13)') top_initials(i), top_scores(i)
 85     continue
      else
        write (text, 500) decoded_clock(2), decoded_clock(3),
     &                    decoded_clock(1)
        call gpr_$move (int2(100), int2(110), status)
        call gpr_$text (text, int2(33), status)
        write (text, '(''       Player      Score'')')
        call gpr_$move (int2(100), int2(150), status)
        call gpr_$text (text, int2(24), status)
        call gpr_$set_text_value (icol(2), status)
        do 90 i = 1, 10
          write (text, '(9x, a3)') top_initials(i)
          text_y = 170 + i * 20
          call gpr_$move (int2(100), int2(text_y), status)
          call gpr_$text (text, int2(12), status)
          text(1:25) = '                         '
          write (text, '(12x, i13)') top_scores(i)
          call gpr_$inq_text_extent (text, int2(25), cpos, status)
          xoff = cpos(1) - 259
          call gpr_$move (int2(100 - xoff), int2(text_y), status)
          call gpr_$text (text, int2(25), status)
 90     continue
      end if
c
c    place score in bin and rewrite bins
c
      num_bin = score / 5000 + 1
      if (num_bin .gt. 200) num_bin = 200
      bins(num_bin) = bins(num_bin) + 1
      rewind (1)
      do 110 i = 1, 10
        read(1, *)
110   continue
      write (1, '(10i10)') (bins(i), i = 1, 200)
      close(1)
c
c    draw the histogram
c
      max_score = top_scores(1)
      if (score .gt. top_scores(1)) max_score = score
      max_score = (max_score - 1) / 100000
      max_score = max_score * 100000 + 100000
      if (max_score .gt. 1000000) max_score = 1000000
      bin_width = (max_score / 20) / 5000
      if (bin_width .gt. 20) bin_width = 20
c
c    form the display bins
c
      do 130 i = 1, 20
        dbin(i) = 0.0
        do 140 j = 1, bin_width
          indice = (i - 1) * bin_width + j
          dbin(i) = dbin(i) + bins(indice)
140     continue
130   continue
      max = 0
      do 150 i = 1, 20
        if (dbin(i) .gt. max) max = dbin(i)
150   continue
c
c    scale all bins by maximum hit count and scale factor
c
      do 160 i = 1, 20
        dbin(i) = dbin(i) / max * scale
160   continue
c
c    draw the rectangles of the bins
c
      xoff = 530
      yoff = 380
      call gpr_$set_fill_value (icol(8), status)
      call gpr_$set_draw_value (icol(1), status)
      do 170  i = 1, 20
        xoff = xoff + 15
        box(1, 1) = xoff
        box(2, 1) = yoff - int(dbin(i))
        box(1, 2) = 15
        box(2, 2) = int(dbin(i))
        call gpr_$rectangle (box, status)
        box(1, 2) = xoff + 15
        box(2, 2) = yoff
        call gpr_$draw_box (box(1, 1), box(2, 1), box(1, 2), box(2, 2),
     &                      status)
        call gpr_$move (int2(xoff), int2(yoff), status)
        call gpr_$line (int2(xoff), int2(yoff + 6), status)
170   continue
      call gpr_$move (int2(545), int2(yoff), status)
      call gpr_$line (int2(545), int2(yoff + 10), status)
      call gpr_$move (int2(845), int2(yoff), status)
      call gpr_$line (int2(845), int2(yoff + 10), status)
      call gpr_$move (int2(545), int2(yoff), status)
      call gpr_$line (int2(845), int2(yoff), status)
c
c    label the endpoints
c
      call gpr_$load_font_file('/sys/dm/fonts/f5x7', int2(18),
     &                         font_id, status)
      call gpr_$set_text_font (font_id, status)
      text = '0'
      call gpr_$inq_text_extent (text, int2(1), cpos, status)
      xoff = 545 - cpos(1) / 2
      yoff = 400 + cpos(2)
      call gpr_$move (int2(xoff), int2(yoff), status)
      call gpr_$text (text, int2(1), status)
      write (text, '(i7)') max_score
      call gpr_$inq_text_extent (text, int2(7), cpos, status)
      xoff = 845 - cpos(1) / 2
      yoff = 400 + cpos(2)
      call gpr_$move (int2(xoff), int2(yoff), status)
      call gpr_$text (text, int2(7), status)
c
c    mark player's score bin
c
      ibin = (min(score, 999999) * 20) / max_score + 1
      xoff = 536 + ibin * 15
      yoff = 373 - int(dbin(ibin))
      call gpr_$move (int2(xoff), int2(yoff), status)
      call gpr_$text ('*', int2(1), status)
c
c    write out the escape mechanism
c
      call gpr_$load_font_file('/sys/dm/fonts/nonie.r.16',
     &                         int2(24), font_id, status)
      call gpr_$set_text_font (font_id, status)
      call gpr_$set_text_value (icol(15), status)
      call gpr_$move (int2(140), int2(400), status)
      call gpr_$text (' Hit space bar to exit', int2(22), status)
100   continue
      event = gpr_$event_wait (event_type, key, cpos, status)
      if (key .ne. ' ') goto 100
c
c    close up gpr and return to main
c
      call gpr_$terminate (.false., status)
      return
c
c    deal with screwed up or non-existent info files
c
999   continue
      rewind(1)
      do 120 i = 1, 10
        write (1, '(a3, i13)') 'xyz', 0
120   continue
      bins(1) = 0
      write (1, '(10i10)') (bins(1), i = 1, 200)
      print*,'New info file created.'
      rewind(1)
      goto 5
      end




      subroutine bzone_set_color (red, green, blue, entry)
c
c     BZONE_SET_COLOR sets the color map entry to the color
c     specified by the combination of r, g and b.
c
      integer red, green, blue, entry, color, status
      color = (65536 * red) + (256 * green) + blue
      call gpr_$set_color_map (entry, int2(1), color, status)
      return
      end
