      program bzone_main
c
c   ********************************************************************
c   *****                                                          *****
c   *****                BATTLE ZONE VERSION 1.0                   *****
c   *****                                                          *****
c   *****                      written by                          *****
c   *****                                                          *****
c   *****                 Justin S. Revenaugh                      *****
c   *****                                                          *****
c   *****                        5/86                              *****
c   *****                                                          *****
c   *****        Massachussetts Institute of Technology            *****
c   *****  Department of Earth, Atmospheric and Planetary Science  *****
c   *****                                                          *****
c   ********************************************************************
c
c     BZONE_MAIN drives the graphics and strategy routines, resolves
c     movement and missile fire, handles all mouse events and keeps game
c     time.
c
% include '/sys/ins/base.ins.ftn'
% include '/sys/ins/gpr.ins.ftn'
% include '/sys/ins/kbd.ins.ftn'
% include '/sys/ins/time.ins.ftn'
% include '/sys/ins/cal.ins.ftn'
% include '/sys/ins/gmf.ins.ftn'
c
      integer*2 position(2), clock(3), cur_op(8), origin(2), event_type
      integer*2 timer(3), size(2), stream_id, width
      integer*4 bitmap_desc, score, num_left, status, cursor_bitmap
      integer*4 mcount(2), passes, excount(4), ex_count(4)
      integer*4 score_base, tank_count, missile_count, next_missile
      integer*4 dead_count, num_not_rcvd, ptr
      real speed, rotate, xcrd, ycrd, azm, ca, sa, seed, obx(12)
      real oby(12), oazm(12), orange(12), pro_x(12), pro_y(12)
      real threshold, ospeed(12), distance(4, 12), critical(12)
      real block_size, check(12), lander_threshold, cla, sla
      real exx(4), exy(4), exrange(4), exazm(4), orotate(12)
      real expro_x(4), expro_y(4), excheck(4), block_size_sqrd
      real tank_width, tank_length
      double precision elapsed, duration, turn
      logical missile, lander, event, object(12), super, seen(12)
      logical sens, active, last, blocked(2), blocked_last(2)
      logical explode(4), exseen(4), new(12), player, reset, seen_last
      logical aligned, first_missile, first, dead, copter
      logical fresh, mnc
      character key*1, name*80
      data size / 1024, 800/
      data score, num_left, score_base, num_not_rcvd / 0, 3, 0, 0/
      data xcrd, ycrd, azm / 3 * 0.0/
      data object / 12 * .false./
      data orotate, ospeed, oazm, obx, oby / 60 * 0.0/
      data explode / 4 * .false./
      data tank_count, missile_count, next_missile / 2 * 0, 1200/
      data missile, copter, lander, super, last / 4 * .false., .true./
      data player, seen_last, aligned, reset / 3 * .false., .true./
      data first_missile, first, dead / 2 * .true., .false./
      data sens, blocked, blocked_last / 5 * .false./
      data critical /0.0, 6400.0, 0.0, 0.0, 4 * 50.0, 4 * 35.0/
      data tank_width, tank_length / 45.0, 70.0/
      data threshold, cla, sla / 0.7, 1.0, 0.0/
      data block_size, block_size_sqrd /100.0, 10000.0/
      data lander_threshold / 0.50/
      data ex_count / 40, 40, 20, 20/
      data name / 'bzone.screen.dump.gmf'/
c
c    start the random number generator
c
      call cal_$get_local_time (clock)
      seed = abs(clock(3) / 33000.0)
c
c    set up the static display
c
      call bzone_screen_init (bitmap_desc)
      call gpr_$set_clipping_active (.false., status)
      do 10 i = 1, 3
        call bzone_update_display (missile, lander, score, i,
     &                             sens, bitmap_desc)
 10   continue
      call gpr_$set_clipping_active (.true., status)
      call bzone_x_hairs (aligned)
      call gpr_$inq_cursor (cursor_bitmap, cur_op, active, position,
     &                      origin, status)
      event = gpr_$cond_event_wait (event_type, key, position, status)
      call bzone_joystick (bitmap_desc, position, sens, speed, rotate)
c
c    place the cubes, pyramids and enemy tank
c
      call bzone_place_objects (xcrd, ycrd, azm, obx, oby, oazm,
     &                          ospeed, object, explode, super,
     &                          missile, copter, reset, fresh,
     &                          dead, score, .true., height, seed)
c
c    get ranges from player ship to all objects
c
      do 20 i = 1, 12
        if (object(i)) then
          orange(i) = sqrt((obx(i) - xcrd)**2 + (oby(i) - ycrd)**2)
        else
          orange(i) = 0.0
        end if
 20   continue
c
c    project the enemy tank into player-centric coordinates
c
      ca = cos(azm)
      sa = sin(azm)
      dx = obx(1) - xcrd
      dy = oby(1) - ycrd
      pro_y(1) = -dx * sa + dy * ca
      pro_x(1) = dx * ca + dy * sa
c
c    initiate the scanner
c
      call gpr_$set_clipping_active (.false., status)
      call bzone_scanner (pro_x, pro_y, orange)
      call gpr_$set_clipping_active (.true., status)
c
c    paint the horizon
c
      call bzone_draw_horizon (azm)
c
c    start turn timer
c
      call time_$clock (timer)
      call cal_$float_clock (timer, elapsed)
c
c    everything is initiated, now start the normal sequence: get cursor
c    position, resolve keystrokes, missile fire, movement, etc.  then
c    erase the old objects and draw new ones
c
 30   continue
c
c    set up a do-while over inq and event for a max of 5 passes or
c    a button event
c
      passes = 0
 40   continue
        if (passes .ge. 5) goto 50
          passes = passes + 1
          call gpr_$inq_cursor (cursor_bitmap, cur_op, active, position,
     &                          origin, status)
          event = gpr_$cond_event_wait (event_type, key, position,
     &                                  status)
          if (event .and. event_type .eq. gpr_$buttons) then
            goto 50
          else if (event .and. event_type .eq. gpr_$keystroke) then
            if (key .eq. kbd_$f1 .or. key .eq. kbd_$r6 .or.
     &          key .eq. '/') then
              call bzone_pause
            else if (key .eq. 'g') then
              call gpr_$inq_bitmap_pointer (bitmap_desc, ptr, width,
     &                                      status)
              call gmf_$open (name, int2(80), gmf_$overwrite, stream_id,
     &                        status)
              call gmf_$copy_plane (stream_id, .true., int2(300), ptr,
     &                              size(1), size(2), width, status)
              call gmf_$close (stream_id, status)
            end if
          end if
        goto 40
 50   continue
      call bzone_joystick (bitmap_desc, position, sens, speed, rotate)
      if (event .and. .not. dead) then
        if (last) then
          if ((key .eq. 'a') .and. (.not. object(3))) then
c
c    fire a player missile
c
            object(3) = .true.
            mcount(1) = 0
            obx(3)    = xcrd
            oby(3)    = ycrd
            oazm(3)   = azm
            ospeed(3) = 40.0
            last = .false.
          else if (key .eq. 'b') then
            position(1) = 500
            position(2) = 400
            call gpr_$set_cursor_position (position ,status)
            call bzone_joystick (bitmap_desc, position, sens, speed,
     &                           rotate)
            last = .false.
          else if (key .eq. 'c') then
            sens = .not. sens
            call bzone_joystick (bitmap_desc, position, sens, speed,
     &                           rotate)
            last = .false.
          end if
        else
          if (key .eq. 'A' .or. key .eq. 'B' .or. key .eq. 'C') then
            last = .true.
          end if
        end if
      end if
c
c    move the players ship
c
      if (.not. blocked(1) .and. .not. dead) then
        azm = azm + rotate
        if (azm .gt. 6.283185306) azm = azm - 6.283185306
        if (azm .le. 0.0) azm = azm + 6.283185306
        ca = cos(azm)
        sa = sin(azm)
      end if
      if (.not. dead) then
        xcrd = xcrd - sa * speed
        ycrd = ycrd + ca * speed
      else
        speed = 0.0
      end if
c
c    move objects with speed
c
      if (object(1)) then
        if (super) then
          call bzone_move_super (xcrd, ycrd, ca, sa, rotate, speed, obx,
     &                           oby, oazm, ospeed, orotate, orange,
     &                           object, mcount(2), blocked(2), player,
     &                           reset, seed)
        else if (copter) then
          call bzone_move_copter (xcrd, ycrd, azm, rotate, speed,
     &                            obx, oby, oazm, ospeed, orotate,
     &                            orange, object, blocked(2), reset,
     &                            fresh, mcount(2), height, pro_y(1),
     &                            seed)
        else if (missile) then
          call bzone_move_missile (xcrd, ycrd, azm, rotate, speed,
     &                             obx, oby, oazm, ospeed, orotate,
     &                             orange, object, blocked(2), reset,
     &                             first, height, pro_y(1), seed)
        else
          call bzone_move_tank (xcrd, ycrd, ca, sa, rotate, speed, obx,
     &                          oby, oazm, ospeed, orotate, orange,
     &                          object, mcount(2), blocked(2), player,
     &                          reset, seed)
        end if
      end if
      if (object(2)) then
        call bzone_move_lander (xcrd, ycrd, obx, oby, oazm ,ospeed,
     &                          orange, seed)
      end if
      do 60 i = 2, 4
        if (object(i)) then
          coa = cos(oazm(i))
          soa = sin(oazm(i))
          obx(i) = obx(i) - soa * ospeed(i)
          oby(i) = oby(i) + coa * ospeed(i)
        end if
 60   continue
c
c    move the enemy tank
c
      if (.not. blocked(2)) then
        oazm(1) = oazm(1) + orotate(1)
      end if
      ct = cos(oazm(1))
      st = sin(oazm(1))
      obx(1) = obx(1) - st * ospeed(1)
      oby(1) = oby(1) + ct * ospeed(1)
c
c    calculate object to object distances**2 and ranges from player tank
c
      do 70 j = 1, 12
        if (object(j)) then
          orange(j) = sqrt((obx(j) - xcrd)**2 + (oby(j) - ycrd)**2)
          if (object(1)) then
            distance(1, j) = (obx(1) - obx(j))**2 + (oby(1) - oby(j))**2
          end if
        else
          orange(j) = 0.0
        end if
 70   continue
      distance(2, 3) = (obx(2) - obx(3))**2 + (oby(2) - oby(3))**2
      distance(2, 4) = (obx(2) - obx(4))**2 + (oby(2) - oby(4))**2
c
c    check for blocked paths for the player tank
c
      blocked(1) = .false.
      blocked(2) = .false.
      do 90 i = 5, 12
        if (orange(i) .lt. block_size) then
c
c    ship is blocked
c
          blocked(1) = .true.
c
c    back-project ship to stopping distance
c
          dx = xcrd - obx(i)
          dy = ycrd - oby(i)
          diff = dy * ca - dx * sa
          if (speed .gt. 0.0) then
            v = diff + sqrt(diff**2 + block_size_sqrd -
     &                      orange(i)**2)
          else if (speed .lt. 0.0) then
            v = diff - sqrt(diff**2 + block_size_sqrd -
     &                      orange(i)**2)
          end if
          xcrd = xcrd + sa * v
          ycrd = ycrd - ca * v
        end if
c
c    check for blocked paths for the enemy tank or missile
c
        if (distance(1, i) .lt. block_size_sqrd) then
c
c    tank is blocked
c
          blocked(2) = .true.
c
c    back-project tank to stopping distance
c
          if (.not. missile) then
            dx = obx(1) - obx(i)
            dy = oby(1) - oby(i)
            diff = dy * ct - dx * st
            if (ospeed(1) .gt. 0.0) then
              v = diff + sqrt(diff**2 + block_size_sqrd -
     &                        distance(1, i))
            else if (ospeed(1) .lt. 0.0) then
              v = diff - sqrt(diff**2 + block_size_sqrd -
     &                        distance(1, i))
            end if
            obx(1) = obx(1) + st * v
            oby(1) = oby(1) - ct * v
          end if
        end if
 90   continue
c
c    see if the two are blocking each other
c
      player = .false.
      if (blocked(1) .or. blocked(2)) then
        orange(1) = sqrt((obx(1) - xcrd)**2 + (oby(1) - ycrd)**2)
      end if
      if (object(1) .and. orange(1) .lt. block_size) then
        if (.not. missile) then
c
c    yes they are, project them both back
c
          if (blocked(1)) then
            speed = 0.0
            if (abs(ospeed(1)) .lt. 0.001) ospeed(1) =
     &          sign(0.001, ospeed(1))
          end if
          blocked(1) = .true.
          blocked(2) = .true.
          player = .true.
          ddx = speed * sa - ospeed(1) * st
          ddy = speed * ca - ospeed(1) * ct
          ddx2 = ddx**2
          ddy2 = ddy**2
          dx = xcrd - obx(1)
          dy = ycrd - oby(1)
          dif = ddy * dy - ddx * dx
          alpha = (dif + sqrt(dif**2 + (block_size_sqrd - orange(1)**2)
     &          * (ddx2 + ddy2))) / (ddx2 + ddy2)
          xcrd = xcrd + alpha * speed * sa
          ycrd = ycrd - alpha * speed * ca
          obx(1) = obx(1) + alpha * ospeed(1) * st
          oby(1) = oby(1) - alpha * ospeed(1) * ct
        end if
      end if
c
c    if blocked then notify the player of this fact
c
      if (blocked(1) .and. .not. blocked_last(1)) then
        call bzone_message (2, .true.)
      else if (.not. blocked(1) .and. blocked_last(1)) then
        call bzone_message (-2, .false.)
      end if
      blocked_last(1) = .false.
      blocked_last(2) = .false.
c
c    recalculate range to salvo if necessary
c
      if (blocked(1)) then
        blocked_last(1) = .true.
        if (object(4)) then
          orange(4) = sqrt((obx(4) - xcrd)**2 + (oby(4) - ycrd)**2)
        end if
      end if
c
c    recalculate distance to salvo if needed
c
      if (blocked(2)) then
        blocked_last(2) = .true.
        if (object(3)) then
          distance(1, 3) = (obx(3) - obx(1))**2 + (oby(3) - oby(1))**2
        end if
      end if
c
c    delete out of range objects
c
      if (orange(1) .gt. 2200.0) then
        object(1) = .false.
        reset = .true.
      end if
      if (orange(2) .gt. 2750.0) object(2) = .false.
      do 110 i = 5, 12
        if (orange(i) .gt. 2200.0) object(i) = .false.
110   continue
c
c    add one to the player salvo counts and exploded objects
c
      mcount(1) = mcount(1) + 1
      mcount(2) = mcount(2) + 1
      do 120 i = 1, 4
        excount(i) = excount(i) + 1
120   continue
c
c    if salvos have been around too long then remove them
c
      if (mcount(1) .gt. 50 .and. object(3)) then
        object(3) = .false.
        mcount(1) = 0
      end if
      if (mcount(2) .gt. 50 .and. object(4)) then
        object(4) = .false.
        mcount(2) = 0
        call bzone_message (-3, .false.)
      end if
c
c    if an exploded object has been around too long then remove it
c
      do 130 i = 1, 4
        if (explode(i) .and. excount(i) .gt. ex_count(i)) then
          explode(i) = .false.
        end if
130   continue
c
c    if salvo hits a block then remove it
c
       do 140 i = 3, 4
         if (object(i)) then
           do 150 j = 5, 12
             test_x = abs(obx(i) - obx(j))
             test_y = abs(oby(i) - oby(j))
             if (test_x .lt. critical(j)) then
               if (test_y .lt. critical(j)) then
                 object(i) = .false.
                 explode(i) = .true.
                 excount(i) = 0
                 exx(i) = obx(i)
                 exy(i) = oby(i)
                 exrange(i) = orange(i)
                 new(i) = .true.
                 if (i .eq. 4) then
                   call bzone_message (-3, .false.)
                 end if
               end if
             end if
150        continue
         end if
140    continue
c
c    check for salvos hitting lander
c
      if (object(2)) then
        do 300 i = 3, 4
          if (object(i)) then
            if (distance(2, i) .lt. critical(2)) then
              object(2) = .false.
              object(i) = .false.
              if (i .eq. 4) then
                call bzone_message (-3, .false.)
              end if
              explode(2) = .true.
              explode(i) = .true.
              excount(2) = 0
              excount(i) = 0
              exx(2) = obx(2)
              exy(2) = oby(2)
              exrange(2) = orange(2)
              exazm(2) = oazm(2)
              exx(i) = obx(i)
              exy(i) = oby(i)
              exrange(i) = orange(i)
              exazm(i) = oazm(i)
              new(2) = .true.
              new(i) = .true.
              if (i .eq. 3) then
                score = score + 10000
                icheck = score / 100000
                if (icheck .gt. score_base) then
                  num_left = num_left + 1
                  if (num_left .gt. 4) then
                    num_left = 4
                    num_not_rcvd = num_not_rcvd + 1
                  end if
                  score_base = icheck
                end if
              end if
            end if
          end if
300     continue
      end if
c
c    check if the missile or copter hits the lander
c
      if (object(1) .and. missile .and. object(2)) then
        if (distance(1, 2) .lt. critical(2) .and. height .lt. 80) then
          num_missile = num_missile - 1
          object(1) = .false.
          explode(1) = .true.
          excount(1) = 0
          exx(1) = obx(1)
          exy(1) = oby(1)
          exrange(1) = orange(1)
          exazm(1) = oazm(1)
          new(1) = .true.
          object(2) = .false.
          explode(2) = .true.
          excount(2) = 0
          exx(2) = obx(2)
          exy(2) = oby(2)
          exrange(2) = orange(2)
          exazm(2) = oazm(2)
          new(2) = .true.
        end if
      end if
c
c    check for player salvo hitting enemy object # 1
c
      if (object(3) .and. object(1)) then
        dx = obx(1) - obx(3)
        dy = oby(1) - oby(3)
        test_x = abs( dx * ct + dy * st)
        test_y = abs(-dx * st + dy * ct)
        if (test_x .lt. tank_width) then
          if (test_y .lt. tank_length) then
            if (.not. missile .or. height .lt. 50.0) then
              tank_count = 0
              object(1) = .false.
              object(3) = .false.
              explode(1) = .true.
              excount(1) = 0
              exx(1) = obx(1)
              exy(1) = oby(1)
              exrange(1) = orange(1)
              exazm(1) = oazm(1)
              new(1) = .true.
              new(3) = .true.
              if (super) then
                score = score + 5000
              else if (missile .and. .not. copter) then
                score = score + 5000
                num_missile = num_missile - 1
              else if (missile .and. copter) then
                score = score + 10000
                num_missile = num_missile - 1
              else
                score = score + 3000
              end if
              icheck = score / 100000
              if (icheck .gt. score_base) then
                num_left = num_left + 1
                if (num_left .gt. 4) then
                  num_left = 4
                  num_not_rcvd = num_not_rcvd + 1
                end if
                score_base = icheck
              end if
            end if
          end if
        end if
      end if
c
c    calculate ranges to exploded objects
c
      do 160 i = 2, 4
        if (explode(i)) then
          exrange(i) = sqrt((exx(i) - xcrd)**2 + (exy(i) - ycrd)**2)
        end if
160   continue
c
c    project all objects in play-centric space and calculate ranges
c
      do 170 i = 1, 12
        if (object(i) .and. orange(i) .lt. 2000.0) then
          dx = obx(i) - xcrd
          dy = oby(i) - ycrd
          pro_y(i) = -dx * sa + dy * ca
          pro_x(i) =  dx * ca + dy * sa
          check(i) = pro_y(i) / (abs(pro_x(i)) + 1.0)
          if (check(i) .gt. threshold) then
            seen(i) = .true.
          else
            seen(i) = .false.
          end if
        else
          pro_y(i) = 0.0
          pro_x(i) = 0.0
          seen(i) = .false.
        end if
170   continue
c
c    project all exploded items except enemy tank
c
      do 180 i = 2, 4
        if (explode(i) .and. exrange(i) .lt. 2000.0) then
          dx = exx(i) - xcrd
          dy = exy(i) - ycrd
          expro_y(i) = -dx * sa + dy * ca
          expro_x(i) =  dx * ca + dy * sa
          excheck(i) = expro_y(i) / (abs(expro_x(i)) + 1.0)
          if (excheck(i) .gt. threshold) then
            exseen(i) = .true.
          else
            exseen(i) = .false.
          end if
        else
          expro_y(i) = 0.0
          expro_x(i) = 0.0
          exseen(i) = .false.
        end if
180   continue
      lander = .false.
      if (check(2) .gt. lander_threshold .and. orange(2) .lt. 2000.0
     &   .and. object(2)) lander = .true.
c
c    determine type of x hair to draw
c
      aligned = .false.
      if (abs(pro_x(1)) .lt. 50 .and. seen(1)) aligned = .true.
      if (abs(pro_x(2)) .lt. 60 .and. seen(2)) aligned = .true.
c
c    redraw the viewport
c
      call gpr_$set_clipping_active (.false., status)
      call bzone_scanner (pro_x, pro_y, orange)
c
c    if missile (but not copter) set mnc to true
c
      if (missile .and. .not. copter) then
        mnc = .true.
      else
        mnc = .false.
      end if
      call bzone_update_display (mnc, lander, score, num_left, sens,
     &                           bitmap_desc)
      call gpr_$set_clipping_active (.true., status)
      call bzone_x_hairs (aligned)
      call bzone_draw_horizon (azm)
      call bzone_draw_cube (xcrd, ycrd, ca, sa, obx, oby, orange, seen)
      call bzone_draw_pyramid (xcrd, ycrd, ca, sa, obx, oby, orange,
     &                         seen)
      call bzone_draw_lander (xcrd, ycrd, ca, sa, obx, oby, orange,
     &                        seen, cla, sla)
      call bzone_draw_salvo (xcrd, ycrd, ca, sa, obx, oby, oazm, orange,
     &                       seen)
      if (super) then
        call bzone_draw_super (xcrd, ycrd, ca, sa, obx, oby, oazm,
     &                         orange, seen)
      else if (copter) then
        call bzone_draw_copter  (xcrd, ycrd, ca, sa, obx, oby, oazm,
     &                           orange, seen, height)
      else if (missile) then
        call bzone_draw_missile (xcrd, ycrd, ca, sa, obx, oby, oazm,
     &                           orange, seen, height)
      else
        call bzone_draw_tank (xcrd, ycrd, ca, sa, obx, oby, oazm,
     &                        orange, seen)
      end if
      call bzone_explode_salvo (xcrd, ycrd, ca, sa, exx, exy, exazm,
     &                          exrange, exseen, seed, new)
      call bzone_explode_lander (xcrd, ycrd, ca, sa, exx, exy, exrange,
     &                           exseen, cla, sla)
      if (explode(1)) then
        if (super) then
          call bzone_explode_super (xcrd, ycrd, ca, sa, exx, exy,
     &                              exazm, exrange, exseen, new(1),
     &                              excount(1), seed)
        else if (copter) then
          call bzone_explode_copter (xcrd, ycrd, ca, sa, exx, exy,
     &                               exazm, exrange, exseen, height,
     &                               new(1), excount(1), seed)
        else if (missile) then
          call bzone_explode_missile (xcrd, ycrd, ca, sa, exx, exy,
     &                                exazm, exrange, exseen, height,
     &                                new(1), excount(1), seed)
        else
          call bzone_explode_tank (xcrd, ycrd, ca, sa, exx, exy,
     &                             exazm, exrange, exseen, new(1),
     &                             excount(1), seed)
        end if
      end if
c
c    if enemy is visible then say so
c
      if (seen(1) .and. (.not. seen_last) .and. (.not. missile)) then
        call bzone_message (1, .false.)
      else if ((.not. seen(1)) .and. seen_last) then
        call bzone_message (-1, .false.)
      end if
      seen_last = seen(1)
c
c    check for enemy missile hitting player tank
c
      if (object(1) .and. missile) then
        if (orange(1) .lt. block_size) then
          if (.not. copter .or. height .lt. 50) then
            object(1) = .false.
            explode(1) = .true.
            excount(1) = 0
            exx(1) = obx(1)
            exy(1) = oby(1)
            exrange(1) = orange(1)
            exazm(1) = oazm(1)
            new(1) = .true.
            call bzone_draw_cracks
            dead = .true.
            dead_count = 0
          end if
        end if
      end if
c
c    check for enemy salvo hitting player tank
c
      if (object(4) .and. orange(4) .lt. 100.0) then
        if (abs(pro_x(4)) .lt. tank_width) then
          if (abs(pro_y(4)) .lt. tank_length) then
            seen(4) = .false.
            call bzone_draw_salvo (xcrd, ycrd, ca, sa, obx, oby, oazm,
     &                             orange, seen)
            object(4) = .false.
            call bzone_message (-3, .false.)
            reset = .true.
            call bzone_draw_cracks
            dead = .true.
            dead_count = 0
          end if
        end if
      end if
c
c    if player has been dead long enough then finish the job
c    else occassionally redraw the cracks on the screen
c
      if (dead) then
        if (mod(dead_count, 5) .eq. 0) then
          call bzone_draw_cracks
        end if
        if (dead_count .gt. 50) then
          dead = .false.
          num_left = num_left - 1
          if (num_left .lt. 0) then
            call bzone_scores (score, num_not_rcvd, bitmap_desc)
            stop
          end if
          if (missile) then
            num_missile = num_missile - 2
            if (num_missile .le. 0) then
              missile = .false.
              copter = .false.
              call rand (seed)
              next_missile = 750 * seed + 750
            end if
          end if
          call bzone_clear_screen (bitmap_desc)
          xcrd = 0.0
          ycrd = 0.0
          speed = 0.0
          azm = 0.0
          ca = 1.0
          sa = 0.0
c
c    delete all objects
c
          do 190 i = 1, 12
            object(i) = .false.
190       continue
          do 200 i = 1, 4
            explode(i) = .false.
200       continue
          call bzone_message (-1, .false.)
          call bzone_message (-2, .false.)
          call bzone_message (-3, .false.)
          call bzone_place_objects (xcrd, ycrd, azm, obx, oby, oazm,
     &                              ospeed, object, explode, super,
     &                              missile, copter, reset, fresh,
     &                              dead, score, .true., height, seed)
        end if
      end if
c
c    if player is lingering on a tank start a missile run, or
c    start a run if it's count exceeds the next_missile count
c
      if ((tank_count .gt. 700 .and. object(1)) .or.
     &    (missile_count .gt. next_missile .and. object(1))) then
        if (.not. missile) then
          tank_count = 0
          missile_count = 0
c
c    get rid of tank and start a missile run
c
          if (object(4)) then
            object(4) = .false.
            call bzone_message (-3, .false.)
          end if
          seen(1) = .false.
          if (super) then
            call bzone_draw_super (xcrd, ycrd, ca, sa, obx, oby, oazm,
     &                             orange, seen)
          else
            call bzone_draw_tank (xcrd, ycrd, ca, sa, obx, oby, oazm,
     &                            orange, seen)
          end if
          call rand (seed)
          num_missile = seed * 3 + 1
          if (first_missile) num_missile = 1
          first = first_missile
          first_missile = .false.
          super = .false.
          missile = .true.
          object(1) = .false.
          call bzone_place_objects (xcrd, ycrd, azm, obx, oby, oazm,
     &                              ospeed, object, explode, super,
     &                              missile, copter, reset, fresh,
     &                              dead, score, .false., height, seed)
        end if
      end if
c
c    if a missile run is over get a new tank
c
      if (missile .and. num_missile .le. 0 .and. .not. explode(1)) then
        object(1) = .false.
        missile = .false.
        copter = .false.
          call bzone_place_objects (xcrd, ycrd, azm, obx, oby, oazm,
     &                              ospeed, object, explode, super,
     &                              missile, copter, reset, fresh,
     &                              dead, score, .false., height, seed)
        call rand (seed)
        next_missile = 750 * seed + 750
      end if
c
c    create new objects if necessary
c
      call bzone_place_objects (xcrd, ycrd, azm, obx, oby, oazm,
     &                          ospeed, object, explode, super,
     &                          missile, copter, reset, fresh,
     &                          dead, score, .false., height, seed)
      game_counter  = game_counter + 1
      dead_count    = dead_count + 1
      tank_count    = tank_count + 1
      if (.not. missile) missile_count = missile_count + 1
c
c    repeat the sequence after timing the turn
c
210   continue
      call time_$clock (timer)
      call cal_$float_clock (timer, turn)
      duration = turn - elapsed
      if (duration .gt. 0.06) then
        elapsed = turn
        goto 30
      end if
      goto 210
      end
