C
C        PROGRAM MODIFIED 7/82 BY BILL SMITH OF GOULD, SEL
C        TO ALLOW COMPILATION AND RUNNING IN MPX 1.X OR MPX 2.0.
C
C        CONSIDERATIONS FOR USING 'SUSPEND' AND 'RESTORE':
C
C        SUSPENDED FILES WILL BE PLACED INTO THE USERS CURRENT
C        DIRECTORY.
C
C
C  CURRENT LIMITS:
C      9800 WORDS OF MESSAGE TEXT (LINES, LINSIZ).
C       750 TRAVEL OPTIONS (TRAVEL, TRVSIZ).
C       300 VOCABULARY WORDS (KTAB, ATAB, TABSIZ).
C       150 LOCATIONS (LTEXT, STEXT, KEY, COND, ABB, ATLOC, LOCSIZ).
C       100 OBJECTS (PLAC, PLACE, FIXD, FIXED, LINK (TWICE), PTEXT, PROP
C        35 "ACTION" VERBS (ACTSPK, VRBSIZ).
C       205 RANDOM MESSAGES (RTEXT, RTXSIZ).
C        12 DIFFERENT PLAYER CLASSIFICATIONS (CTEXT, CVAL, CLSMAX).
C        20 HINTS, LESS 3 (HINTLC, HINTED, HINTS, HNTSIZ).
C        35 MAGIC MESSAGES (MTEXT, MAGSIZ).
C  THERE ARE ALSO LIMITS WHICH CANNOT BE EXCEEDED DUE TO THE STRUCTURE O
C  THE DATABASE.  (E.G., THE VOCABULARY USES N/1000 TO DETERMINE WORD TY
C  SO THERE CAN'T BE MORE THAN 1000 WORDS.)  THESE UPPER LIMITS ARE:
C      1000 NON-SYNONYMOUS VOCABULARY WORDS
C       300 LOCATIONS
C       100 OBJECTS
C
      IMPLICIT INTEGER*4(A-Z)
      LOGICAL DSEEN,BLKLIN,HINTED,YESX,START
C
C!!!  COMMON /TXTCOM/ RTEXT,LINES
      COMMON /TXTCOM/ RTEXT
      COMMON /VOCCOM/ KTAB,ATAB,TABSIZ
      COMMON /PLACOM/ ATLOC,LINK,PLACE,FIXED,COND,PROP,LOC,LAMP,HOLDNG
      COMMON /MTXCOM/ MTEXT
      COMMON /PTXCOM/ PTEXT
      COMMON /ABBCOM/ ABB
      COMMON /WIZCOM/ WKDAY,WKEND,HOLID,HBEGIN,HEND,HNAME,
     1SHORT,MAGIC,MAGNM,LATNCY,SAVED,SAVET,SETUP
      COMMON /IOSCOM/ TTYI,TTYO,BLKLIN,DBFI
      COMMON /MTDCOM/ MTDTXT
      COMMON /RANCOM/ R
      COMMON /MSCCOM/ TRAVEL,LTEXT,STEXT,KEY,ACTSPK,
     1CTEXT,CVAL,HINTLC,HINTED,HINTS,DSEEN,DLOC,CLSSES,HNTMAX,
     2PLAC,FIXD,MAXTRS,TALLY,TALLY2,
     3KEYS,GRATE,CAGE,ROD,ROD2,STEPS,BIRD,DOOR,PILLOW,SNAKE,
     4FISSUR,TABLET,CLAM,OYSTER,MAGZIN,DWARF,KNIFE,FOOD,BOTTLE,
     5WATER,OIL,PLANT,PLANT2,AXE,MIRROR,DRAGON,CHASM,TROLL,TROLL2,
     6BEAR,MESSAG,VEND,BATTER,NUGGET,COINS,CHEST,EGGS,TRIDNT,VASE,
     7EMRALD,PYRAM,PEARL,RUG,CHAIN,BACK,LOOK,CAVE,NULL,ENTRNC,
     8DPRSSN,SAY,LOCK,THROW,FIND,INVENT,CHLOC,CHLOC2,DFLAG,DALTLC,
     9SUSPND,TURNS,LMWARN,IWEST,KNFLOC,DETAIL,ABBNUM,SCORNG,NUMDIE,
     1DKILL,FOOBAR,BONUS,CLOCK1,CLOCK2,CLOSNG,PANIC,
     2DEMO,HINT,LIMIT,NEWLOC,OBJ,ODLOC,OLDLC2,OLDLOC,SCORE,
     3SPICES,STICK,VERB,WD1,WD1X,WD2,WD2X,WZDARK,
     4ATTACK,DTOTAL,FOO,HINTM3,I,J,K,K1,K2,KK,KQ,L,LL,MXSCOR,SPK,TK,
     5YEA,CLOSED,GAVEUP,MAXDIE,XXD,XXT,YYD,YYT
C
C!!!  DIMENSION LINES(9800)
      DIMENSION TRAVEL(750)
      DIMENSION KTAB(300),ATAB(300)
      DIMENSION LTEXT(150),STEXT(150),KEY(150),COND(150),ABB(150),
     1ATLOC(150)
      DIMENSION PLAC(100),PLACE(100),FIXD(100),FIXED(100),LINK(200),
     1PTEXT(100),PROP(100)
      DIMENSION ACTSPK(35)
      DIMENSION RTEXT(205)
      DIMENSION CTEXT(12),CVAL(12)
      DIMENSION HINTLC(20),HINTED(20),HINTS(20,4)
      DIMENSION MTEXT(35)
      DIMENSION TK(20),DSEEN(6),DLOC(6),ODLOC(6),HNAME(20)
      DIMENSION MTDTXT(100)
      DIMENSION CMADRS(4,11),CMSZES(11),TEXT(70),FNAME(10),FDUMY(10)
C
      LOGICAL TOTING,HERE,AT,BITSET,DARK,WZDARK,LMWARN,CLOSNG,PANIC,
     1CLOSED,GAVEUP,SCORNG,DEMO,YEA,FORCED,PCT
C
      DATA LINSIZ/9800/,TRVSIZ/750/,LOCSIZ/150/,
     1VRBSIZ/35/,RTXSIZ/205/,CLSMAX/12/,HNTSIZ/20/,MAGSIZ/35/
      DATA BLANK/' '/
C
C  STATEMENT FUNCTIONS
C
C
C  TOTING(OBJ)  = TRUE IF THE OBJ IS BEING CARRIED
C  HERE(OBJ)    = TRUE IF THE OBJ IS AT "LOC" (OR IS BEING CARRIED)
C  AT(OBJ)      = TRUE IF ON EITHER SIDE OF TWO-PLACED OBJECT
C  LIQ(DUMY)   = OBJECT NUMBER OF LIQUID IN BOTTLE
C  LIQLOC(LOC)  = OBJECT NUMBER OF LIQUID (IF ANY) AT LOC
C  BITSET(L,N)  = TRUE IF COND(L) HAS BIT N SET (BIT 0 IS UNITS BIT)
C  FORCED(LOC)  = TRUE IF LOC MOVES WITHOUT ASKING FOR INPUT (COND=2)
C  DARK(DUMY)  = TRUE IF LOCATION "LOC" IS DARK
C  PCT(N)       = TRUE N% OF THE TIME (N INTEGER*4 FROM 0 TO 100)
C
C  WZDARK SAYS WHETHER THE LOC HE'S LEAVING WAS DARK
C  LMWARN SAYS WHETHER HE'S BEEN WARNED ABOUT LAMP GOING DIM
C  CLOSNG SAYS WHETHER ITS CLOSING TIME YET
C  PANIC SAYS WHETHER HE'S FOUND OUT HE'S TRAPPED IN THE CAVE
C  CLOSED SAYS WHETHER WE'RE ALL THE WAY CLOSED
C  GAVEUP SAYS WHETHER HE EXITED VIA "QUIT"
C  SCORNG INDICATES TO THE SCORE ROUTINE WHETHER WE'RE DOING A "SCORE" C
C  DEMO IS TRUE IF THIS IS A PRIME-TIME DEMONSTRATION GAME
C  YEA IS RANDOM YES/NO REPLY
c     SIZE(UNIQ1,UNIQ2)=(ADDR(UNIQ2)-ADDR(UNIQ1))/4+1
      SIZE(UNIQ1,UNIQ2)=(UNIQ2-UNIQ1)/4+1
      TOTING(OBJ)=PLACE(OBJ).EQ.-1
      HERE(OBJ)=PLACE(OBJ).EQ.LOC.OR.TOTING(OBJ)
      AT(OBJ)=PLACE(OBJ).EQ.LOC.OR.FIXED(OBJ).EQ.LOC
      LIQ2(PBOTL)=(1-PBOTL)*WATER+(PBOTL/2)*(WATER+OIL)
      LIQ(DUMY)=LIQ2(MAX0(PROP(BOTTLE),-1-PROP(BOTTLE)))
      LIQLOC(LOC)=LIQ2((MOD(COND(LOC)/2*2,8)-5)*MOD(COND(LOC)/4,2)
     1+1)
      BITSET(L,N)=AND(COND(L),ISHFT(1,N)).NE.0
      FORCED(LOC)=COND(LOC).EQ.2
      DARK(DUMY)=MOD(COND(LOC),2).EQ.0.AND.(PROP(LAMP).EQ.0.OR.
     1.NOT.HERE(LAMP))
      PCT(N)=RAN(100).LT.N
C
C  SETUP ADDRESSES AND LENGTHS OF COMMON BLOCKS IN CMADRS AND CMSZES
C  RESPECTIVELY.
C
C  CMADRS ALLOWS  FOUR CONTIGUOUS INTEGER*4 VARIABLES FOR EACH "POINTER"
C  ADDR AND SIZE ARE SITE-SUPPLIED FUNCTIONS.
C
C  FURTHER INFORMATION WILL BE FOUND IN THE CONVERSION GUIDE ACCOMPANYIN
C  THIS PROGRAM.  FOR STILL FURTHER INFORMATION, CONTACT:
C       GARY M. PALTER, MIT    (617) 253-7728
C                (PALTER@MIT-MULTICS)
C
c     CMADRS(1,1) = ADDR(RTEXT(1))
C!!!  CMSZES(1) = SIZE(RTEXT(1),LINES(9800)))/4 + 1
c     CMSZES(1) = SIZE(RTEXT(1),RTEXT(205)))/4 + 1
      CMADRS(1,1) = iaddr(RTEXT(1))
      cmadrs(2,1) = iaddr(RTEXT(205))
C
c     CMADRS(1,2) = ADDR(KTAB(1))
c     CMSZES(2) = SIZE(KTAB(1),TABSIZ))/4 + 1
      CMADRS(1,2) = iaddr(KTAB(1))
      cmadrs(2,2) = iaddr(TABSIZ)
C
c     CMADRS(1,3) = ADDR(ATLOC(1))
c     CMSZES(3) = SIZE(AT(iaddr(1),HOLDNG))/4 + 1
      CMADRS(1,3) = iaddr(ATLOC(1))
      cmadrs(2,3) = iaddr(HOLDNG)
C
c     CMADRS(1,4) = ADDR(MTEXT(1))
c     CMSZES(4) = SIZE(MTEXT(1),MTEXT(34)))/4 + 1
      CMADRS(1,4) = iaddr(MTEXT(1))
      cmadrs(2,4) = iaddr(MTEXT(34))
C
c     CMADRS(1,5) = ADDR(PTEXT(1))
c     CMSZES(5) = SIZE(PTEXT(1),PTEXT(100)))/4 + 1
      CMADRS(1,5) = iaddr(PTEXT(1))
      cmadrs(2,5) = iaddr(PTEXT(100))
C
c     CMADRS(1,6) = ADDR(ABB(1))
c     CMSZES(6) = SIZE(ABB(1),ABB(150)))/4 + 1
      CMADRS(1,6) = iaddr(ABB(1))
      cmadrs(2,6) = iaddr(ABB(150))
C
c     CMADRS(1,7) = ADDR(WKDAY)
c     CMSZES(7) = SIZE(WKDAY,SETUP))/4 + 1
      CMADRS(1,7) = iaddr(WKDAY)
      cmadrs(2,7) = iaddr(SETUP)
C
c     CMADRS(1,8) = ADDR(TTYI)
c     CMSZES(8) = SIZE(TTYI,DBFI))/4 + 1
      CMADRS(1,8) = iaddr(TTYI)
      cmadrs(2,8) = iaddr(DBFI)
C
c     CMADRS(1,9) = ADDR(MTDTXT(1))
c     CMSZES(9) = SIZE(MTDTXT(1),MTDTXT(90)))/4 + 1
      CMADRS(1,9) = iaddr(MTDTXT(1))
      cmadrs(2,9) = iaddr(MTDTXT(90))
C
c     CMADRS(1,10) = ADDR(R)
c     CMSZES(10) = SIZE(R,R))/4 + 1
      CMADRS(1,10) = iaddr(R)
      cmadrs(2,10) = iaddr(R)
C
c     CMADRS(1,11) = ADDR(TRAVEL(1))
c     CMSZES(11) = SIZE(TRAVEL(1),MAXDIE))/4 + 1
      CMADRS(1,11) = iaddr(TRAVEL(1))
      cmadrs(2,11) = iaddr(MAXDIE)
c
c     write (0,9997)
c9997 format (' In MAIN:')
      do 9999 i=1,11
      cmszes(i) = size(cmadrs(1,i),cmadrs(2,i))
c     write (0,9998) i, cmszes(i), cmadrs(1,i), cmadrs(2,i)
c9998 format (' i = ',i3,', cmszes = ',i10,', cmadrs = ',2z9.8)
9999  continue
C
C
C  LOAD 'SYSTEM' COMMON BLOCKS.  THESE COMMON BLOCKS DEFINE THE STATE
C  OF A GAME WHICH HAS YET TO BE STARTED...
C
      CALL IOINIT(0)
      CALL LDCOMN(.TRUE.,FDUMY,CMADRS,CMSZES)
C
C  DESCRIPTION OF THE DATABASE FORMAT
C
C
C  THE DATA FILE CONTAINS SEVERAL SECTIONS.  EACH BEGINS WITH A LINE CON
C  A NUMBER IDENTIFYING THE SECTION, AND ENDS WITH A LINE CONTAINING "-1
C
C  SECTION 1: LONG FORM DESCRIPTIONS.  EACH LINE CONTAINS A LOCATION NUM
C       A TAB, AND A LINE OF TEXT.  THE SET OF (NECESSARILY ADJACENT) LI
C       WHOSE NUMBERS ARE X FORM THE LONG DESCRIPTION OF LOCATION X.
C  SECTION 2: SHORT FORM DESCRIPTIONS.  SAME FORMAT AS LONG FORM.  NOT A
C       PLACES HAVE SHORT DESCRIPTIONS.
C  SECTION 3: TRAVEL TABLE.  EACH LINE CONTAINS A LOCATION NUMBER (X), A
C       LOCATION NUMBER (Y), AND A LIST OF MOTION NUMBERS (SEE SECTION 4
C       EACH MOTION REPRESENTS A VERB WHICH WILL GO TO Y IF CURRENTLY AT
C       Y, IN TURN, IS INTERPRETED AS FOLLOWS.  LET M=Y/1000, N=Y MOD
C               IF N<=300       IT IS THE LOCATION TO GO TO.
C               IF 300<N<=500   N-300 IS USED IN A COMPUTED GO TO TO
C                                       A SECTION OF SPECIAL CODE.
C               IF N>500        MESSAGE N-500 FROM SECTION 6 IS PRINTED,
C                                       AND HE STAYS WHEREVER HE IS.
C       MEANWHILE, M SPECIFIES THE CONDITIONS ON THE MOTION.
C               IF M=0          IT'S UNCONDITIONAL.
C               IF 0<M<100      IT IS DONE WITH M% PROBABILITY.
C               IF M=100        UNCONDITIONAL, BUT FORBIDDEN TO DWARVES.
C               IF 100<M<=200   HE MUST BE CARRYING OBJECT M-100.
C               IF 200<M<=300   MUST BE CARRYING OR IN SAME ROOM AS M-20
C               IF 300<M<=400   PROP(M MOD 100) MUST *NOT* BE 0.
C               IF 400<M<=500   PROP(M MOD 100) MUST *NOT* BE 1.
C               IF 500<M<=600   PROP(M MOD 100) MUST *NOT* BE 2, ETC.
C       IF THE CONDITION (IF ANY) IS NOT MET, THEN THE NEXT *DIFFERENT*
C       "DESTINATION" VALUE IS USED (UNLESS IT FAILS TO MEET *ITS* CONDI
C       IN WHICH CASE THE NEXT IS FOUND, ETC.).  TYPICALLY, THE NEXT DES
C       BE FOR ONE OF THE SAME VERBS, SO THAT ITS ONLY USE IS AS THE ALT
C       DESTINATION FOR THOSE VERBS.  FOR INSTANCE:
C               15      110022  29      31      34      35      23
C               15      14      29
C       THIS SAYS THAT, FROM LOC 15, ANY OF THE VERBS 29, 31, ETC., WILL
C       HIM TO 22 IF HE'S CARRYING OBJECT 10, AND OTHERWISE WILL GO TO 1
C               11      303008  49
C               11      9       50
C       THIS SAYS THAT, FROM 11, 49 TAKES HIM TO 8 UNLESS PROP(3)=0, IN
C       CASE HE GOES TO 9.  VERB 50 TAKES HIM TO 9 REGARDLESS OF PROP(3)
C  SECTION 4: VOCABULARY.  EACH LINE CONTAINS A NUMBER (N), A TAB, AND A
C       FIVE-LETTER WORD.  CALL M=N/1000.  IF M=0, THEN THE WORD IS A MO
C       VERB FOR USE IN TRAVELLING (SEE SECTION 3).  ELSE, IF M=1, THE W
C       AN OBJECT.  ELSE, IF M=2, THE WORD IS AN ACTION VERB (SUCH AS "C
C       OR "ATTACK").  ELSE, IF M=3, THE WORD IS A SPECIAL CASE VERB (SU
C       "DIG") AND N MOD 1000 IS AN INDEX INTO SECTION 6.  OBJECTS FRO
C       (CURRENTLY, ANYWAY) 79 ARE CONSIDERED TREASURES (FOR PIRATE, CLO
C  SECTION 5: OBJECT DESCRIPTIONS.  EACH LINE CONTAINS A NUMBER (N), A T
C       AND A MESSAGE.  IF N IS FROM 1 TO 100, THE MESSAGE IS THE "INVEN
C       MESSAGE FOR OBJECT N.  OTHERWISE, N SHOULD BE 000, 100, 200, ETC
C       THE MESSAGE SHOULD BE THE DESCRIPTION OF THE PRECEDING OBJECT WH
C       PROP VALUE IS N/100.  THE N/100 IS USED ONLY TO DISTINGUISH MULT
C       MESSAGES FROM MULTI-LINE MESSAGES; THE PROP INFO ACTUALLY REQUIR
C       MESSAGES FOR AN OBJECT TO BE PRESENT AND CONSECUTIVE.  PROPERTIE
C       PRODUCE NO MESSAGE SHOULD BE GIVEN THE MESSAGE ">$<".
C  SECTION 6: ARBITRARY MESSAGES.  SAME FORMAT AS SECTIONS 1, 2, AND 5,
C       THE NUMBERS BEAR NO RELATION TO ANYTHING (EXCEPT FOR SPECIAL VER
C       IN SECTION 4).
C  SECTION 7: OBJECT LOCATIONS.  EACH LINE CONTAINS AN OBJECT NUMBER AND
C       INITIAL LOCATION (ZERO (OR OMITTED) IF NONE).  IF THE OBJECT IS
C       IMMOVABLE, THE LOCATION IS FOLLOWED BY A "-1".  IF IT HAS TWO LO
C       (E.G. THE GRATE) THE FIRST LOCATION IS FOLLOWED WITH THE SECOND,
C       THE OBJECT IS ASSUMED TO BE IMMOVABLE.
C  SECTION 8: ACTION DEFAULTS.  EACH LINE CONTAINS AN "ACTION-VERB" NUMB
C       THE INDEX (IN SECTION 6) OF THE DEFAULT MESSAGE FOR THE VERB.
C  SECTION 9: LIQUID ASSETS, ETC.  EACH LINE CONTAINS A NUMBER (N) AND U
C       LOCATION NUMBERS.  BIT N (WHERE 0 IS THE UNITS BIT) IS SET IN CO
C       FOR EACH LOC GIVEN.  THE COND BITS CURRENTLY ASSIGNED ARE:
C               0       LIGHT
C               1       IF BIT 2 IS ON: ON FOR OIL, OFF FOR WATER
C               2       LIQUID ASSET, SEE BIT 1
C               3       PIRATE DOESN'T GO HERE UNLESS FOLLOWING PLAYER
C       OTHER BITS ARE USED TO INDICATE AREAS OF INTEREST TO "HINT" ROUT
C               4       TRYING TO GET INTO CAVE
C               5       TRYING TO CATCH BIRD
C               6       TRYING TO DEAL WITH SNAKE
C               7       LOST IN MAZE
C               8       PONDERING DARK ROOM
C               9       AT WITT'S END
C       COND(LOC) IS SET TO 2, OVERRIDING ALL OTHER BITS, IF LOC HAS FOR
C       MOTION.
C  SECTION 10: CLASS MESSAGES.  EACH LINE CONTAINS A NUMBER (N), A TAB,
C       MESSAGE DESCRIBING A CLASSIFICATION OF PLAYER.  THE SCORING SECT
C       SELECTS THE APPROPRIATE MESSAGE, WHERE EACH MESSAGE IS CONSIDERE
C       APPLY TO PLAYERS WHOSE SCORES ARE HIGHER THAN THE PREVIOUS N BUT
C       HIGHER THAN THIS N.  NOTE THAT THESE SCORES PROBABLY CHANGE WITH
C       MODIFICATION (AND PARTICULARLY EXPANSION) OF THE PROGRAM.
C  SECTION 11: HINTS.  EACH LINE CONTAINS A HINT NUMBER (CORRESPONDING T
C       COND BIT, SEE SECTION 9), THE NUMBER OF TURNS HE MUST BE AT THE
C       LOC(S) BEFORE TRIGGERING THE HINT, THE POINTS DEDUCTED FOR TAKIN
C       HINT, THE MESSAGE NUMBER (SECTION 6) OF THE QUESTION, AND THE ME
C       NUMBER OF THE HINT.  THESE VALUES ARE STASHED IN THE "HINTS" ARR
C       HNTMAX IS SET TO THE MAX0 HINT NUMBER (<= HNTSIZ).  NUMBERS 1-3
C       UNUSABLE SINCE COND BITS ARE OTHERWISE ASSIGNED, SO 2 IS USED TO
C       REMEMBER IF HE'S READ THE CLUE IN THE REPOSITORY, AND 3 IS USED
C       REMEMBER WHETHER HE ASKED FOR INSTRUCTIONS (GETS MORE TURNS, BUT
C       POINTS).
C  SECTION 12: MAGIC MESSAGES. IDENTICAL TO SECTION 6 EXCEPT PUT IN A SE
C       SECTION FOR EASIER REFERENCE.  MAGIC MESSAGES ARE USED BY THE ST
C       MAINTENANCE MODE, AND RELATED ROUTINES.
C  SECTION 0: END OF DATABASE.
C
C  READ THE DATABASE IF WE HAVE NOT YET DONE SO
C
 8500 IF(SETUP.NE.0)GO TO 1100
      CALL IOINIT(1)
      WRITE(TTYO,1000)
 1000 FORMAT(' INITIALIZING...')
C
C  CLEAR OUT THE VARIOUS TEXT-POINTER ARRAYS.  ALL TEXT IS STORED IN ARR
C  LINES; EACH LINE IS PRECEDED BY A WORD POINTING TO THE NEXT POINTER (
C  THE WORD FOLLOWING THE END OF THE LINE).  THE POINTER IS NEGATIVE IF
C  FIRST LINE OF A MESSAGE.  THE TEXT-POINTER ARRAYS CONTAIN INDICES OF
C  POINTER-WORDS IN LINES.  STEXT(N) IS SHORT DESCRIPTION OF LOCATION N.
C  LTEXT(N) IS LONG DESCRIPTION.  PTEXT(N) POINTS TO MESSAGE FOR PROP(N)
C  SUCCESSIVE PROP MESSAGES ARE FOUND BY CHASING POINTERS.  RTEXT CONTAI
C  SECTION 6'S STUFF.  CTEXT(N) POINTS TO A PLAYER-CLASS MESSAGE.  MTEXT
C  SECTION 12.  WE ALSO CLEAR COND.  SEE DESCRIPTION OF SECTION 9 FOR DE
C
C
      TABSIZ=300
      BLKLIN=.TRUE.
      R=0
C
      DO 1001 I=1,300
         IF(I.LE.100)PTEXT(I)=0
         IF(I.LE.100)MTDTXT(I)=-1
         IF(I.LE.RTXSIZ)RTEXT(I)=0
         IF(I.LE.CLSMAX)CTEXT(I)=0
         IF(I.LE.MAGSIZ)MTEXT(I)=0
         IF(I.GT.LOCSIZ)GO TO 1001
         STEXT(I)=0
         LTEXT(I)=0
         COND(I)=0
 1001 CONTINUE
C
      SETUP=1
      LINUSE=1
      TRVS=1
      CLSSES=1
C
C  START NEW DATA SECTION.  SECT IS THE SECTION NUMBER.
C
 1002 READ(DBFI,1003)SECT
 1003 FORMAT(I8)
      IF(SECT.EQ.-37)GO TO 1002
c     WRITE (0,9990) SECT
c9990 FORMAT (' READING SECTION',I4)
      OLDLOC=-1
      SECT1=SECT+1
      IF ((SECT1.LT.1).OR.(SECT1.GT.13)) CALL BUG(9)
      GO TO(1100,1004,1004,1030,1040,1004,1004,1050,1060,1070,1004,
     11080,1004),SECT1
C           (0)  (1)  (2)  (3)  (4)  (5)  (6)  (7)  (8)  (9)  (10)
C     (11) (12)
      CALL BUG(9)
C
C  SECTIONS 1, 2, 5, 6, 10, 12.  READ MESSAGES AND SET UP POINTERS.
C
 1004 READ(DBFI,1005)LOC,TEXT,KK
 1005 FORMAT(1I8,70A1,A1)
      IF(KK.NE.BLANK)CALL BUG(0)
      IF(LOC.EQ.-1)GO TO 1002
      DO 1006 K=1,70
         KK=71-K
         IF(TEXT(KK).NE.BLANK)GO TO 1007
 1006 CONTINUE
      CALL BUG(1)
 1007 KK=(KK+4)/5
      DO 10071 K=1,KK
         K1=LINUSE+K
         K2=5*(K-1)+1
         CALL SETLINES(K1,CODE2(TEXT(K2)))
10071 CONTINUE
      KK=LINUSE+KK
      CALL SETLINES(LINUSE,KK+1)
      IF(LOC.EQ.OLDLOC)GO TO 1020
      CALL SETLINES(LINUSE,-LINES(LINUSE))
      IF(SECT.EQ.12)GO TO 1013
      IF(SECT.EQ.10)GO TO 1012
      IF(SECT.EQ.6)GO TO 1011
      IF(SECT.EQ.5)GO TO 1010
      IF(SECT.EQ.1)GO TO 1008
C
      STEXT(LOC)=LINUSE
      GO TO 1020
C
 1008 LTEXT(LOC)=LINUSE
      GO TO 1020
C
 1010 IF(LOC.GT.0.AND.LOC.LE.100)PTEXT(LOC)=LINUSE
      GO TO 1020
C
 1011 IF(LOC.GT.RTXSIZ)CALL BUG(6)
      RTEXT(LOC)=LINUSE
      GO TO 1020
C
 1012 CTEXT(CLSSES)=LINUSE
      CVAL(CLSSES)=LOC
      CLSSES=CLSSES+1
      GO TO 1020
C
 1013 IF(LOC.GT.MAGSIZ)CALL BUG(6)
      MTEXT(LOC)=LINUSE
C
 1020 LINUSE=KK+1
      CALL SETLINES(LINUSE,-1)
      OLDLOC=LOC
      IF(LINUSE+14.GT.LINSIZ)CALL BUG(2)
      GO TO 1004
C
C  THE STUFF FOR SECTION 3 IS ENCODED HERE.  EACH "FROM-LOCATION" GETS A
C  CONTIGUOUS SECTION OF THE "TRAVEL" ARRAY.  EACH ENTRY IN TRAVEL IS
C  NEWLOC*1000 + KEYWORD (FROM SECTION 4, MOTION VERBS), AND IS NEGATED
C  THIS IS THE LAST ENTRY FOR THIS LOCATION.  KEY(N) IS THE INDEX IN TRA
C  OF THE FIRST OPTION AT LOCATION N.
C
1030  READ(DBFI,1031)LOC,NEWLOC,(TK(I),I=1,8)
 1031 FORMAT(I8,9I8)
      IF(LOC.EQ.-1)GO TO 1002
      IF(KEY(LOC).NE.0)GO TO 1033
      KEY(LOC)=TRVS
      GO TO 1035
 1033 TRAVEL(TRVS-1)=-TRAVEL(TRVS-1)
 1035 DO 1037 L=1,8
         IF(TK(L).EQ.0)GO TO 1039
         TRAVEL(TRVS)=NEWLOC*1000+TK(L)
         TRVS=TRVS+1
         IF(TRVS.EQ.TRVSIZ)CALL BUG(3)
 1037 CONTINUE
 1039 TRAVEL(TRVS-1)=-TRAVEL(TRVS-1)
      GO TO 1030
C
C  HERE WE READ IN THE VOCABULARY.  KTAB(N) IS THE WORD NUMBER, ATAB(N)
C  THE CORRESPONDING WORD.  THE -1 AT THE END OF SECTION 4 IS LEFT IN KT
C  AS AN END-MARKER.  THE WORDS ARE GIVEN A MINIMAL HASH TO MAKE READING
C  CORE-IMAGE HARDER.  NOTE THAT '/7-08' HAD BETTER NOT BE IN THE LIST,
C  IT COULD HASH TO -1.
C
 1040 DO 1042 TABNDX=1,TABSIZ
 1043    READ(DBFI,1041)KTAB(TABNDX),(TEXT(I),I=1,5)
 1041    FORMAT(I8,5A1)
         IF(KTAB(TABNDX).EQ.-1)GO TO 1002
C     SCRAMBLE THE CODE
 1042 ATAB(TABNDX)=-(CODE2(TEXT(1)))
      CALL BUG(4)
C
C  READ IN THE INITIAL LOCATIONS FOR EACH OBJECT.  ALSO THE IMMOVABILITY
C  PLAC CONTAINS INITIAL LOCATIONS OF OBJECTS.  FIXD IS -1 FOR IMMOVABLE
C  OBJECTS (INCLUDING THE SNAKE), OR = SECOND LOC FOR TWO-PLACED OBJECTS
C
 1050 READ(DBFI,1031)OBJ,J,K
      IF(OBJ.EQ.-1)GO TO 1002
      PLAC(OBJ)=J
      FIXD(OBJ)=K
      GO TO 1050
C
C  READ DEFAULT MESSAGE NUMBERS FOR ACTION VERBS, STORE IN ACTSPK.
C
 1060 READ(DBFI,1031)VERB,J
      IF(VERB.EQ.-1)GO TO 1002
      ACTSPK(VERB)=J
      GO TO 1060
C
C  READ INFO ABOUT AVAILABLE LIQUIDS AND OTHER CONDITIONS, STORE IN COND
C
 1070 READ(DBFI,1031)K,(TK(I),I=1,9)
      IF(K.EQ.-1)GO TO 1002
      DO 1071 I=1,9
         LOC=TK(I)
         IF(LOC.EQ.0)GO TO 1070
         IF(BITSET(LOC,K))CALL BUG(8)
 1071 COND(LOC)=COND(LOC)+ISHFT(1,K)
      GO TO 1070
C
C  READ DATA FOR HINTS.
C
 1080 HNTMAX=0
 1081 READ(DBFI,1031)K,(TK(I),I=1,4)
      IF(K.EQ.-1)GO TO 1002
      IF(K.EQ.0)GO TO 1081
      IF(K.LT.0.OR.K.GT.HNTSIZ)CALL BUG(7)
      DO 1083 I=1,4
 1083 HINTS(K,I)=TK(I)
      HNTMAX=MAX0(HNTMAX,K)
      GO TO 1081
C
C  FINISH CONSTRUCTING INTERNAL DATA FORMAT
C
C  IF SETUP=2 WE DON'T NEED TO DO THIS.  IT'S ONLY NECESSARY IF WE HAVEN
C  IT AT ALL OR IF THE PROGRAM HAS BEEN RUN SINCE THEN.
C
1100  CLOSE (UNIT=DBFI)
      IF(SETUP.EQ.2)GO TO 1
      IF(SETUP.EQ.-1)GO TO 8305
C
C  HAVING READ IN THE DATABASE, CERTAIN THINGS ARE NOW CONSTRUCTED.  PRO
C  SET TO ZERO.  WE FINISH SETTING UP COND BY CHECKING FOR FORCED-MOTION
C  ENTRIES.  THE PLAC AND FIXD ARRAYS ARE USED TO SET UP ATLOC(N) AS THE
C  OBJECT AT LOCATION N, AND LINK(OBJ) AS THE NEXT OBJECT AT THE SAME LO
C  AS OBJ.  (OBJ>100 INDICATES THAT FIXED(OBJ-100)=LOC; LINK(OBJ) IS STI
C  CORRECT LINK TO USE.)  ABB IS ZEROED; IT CONTROLS WHETHER THE ABBREVI
C  DESCRIPTION IS PRINTED.  COUNTS MOD 5 UNLESS "LOOK" IS USED.
C
      DO 1101 I=1,100
         PLACE(I)=0
         PROP(I)=0
         LINK(I)=0
 1101 LINK(I+100)=0
C
      DO 1102 I=1,LOCSIZ
         ABB(I)=0
         IF(LTEXT(I).EQ.0.OR.KEY(I).EQ.0)GO TO 1102
         K=KEY(I)
         IF(MOD(IABS(TRAVEL(K)),1000).EQ.1)COND(I)=2
 1102 ATLOC(I)=0
C
C  SET UP THE ATLOC AND LINK ARRAYS AS DESCRIBED ABOVE.  WE'LL USE THE D
C  SUBROUTINE, WHICH PREFACES NEW OBJECTS ON THE LISTS.  SINCE WE WANT T
C  IN THE OTHER ORDER, WE'LL RUN THE LOOP BACKWARDS.  IF THE OBJECT IS I
C  LOCS, WE DROP IT TWICE.  THIS ALSO SETS UP "PLACE" AND "FIXED" AS COP
C  "PLAC" AND "FIXD".  ALSO, SINCE TWO-PLACED OBJECTS ARE TYPICALLY BEST
C  DESCRIBED LAST, WE'LL DROP THEM FIRST.
C
      DO 1106 I=1,100
         K=101-I
         IF(FIXD(K).LE.0)GO TO 1106
         CALL DROP(K+100,FIXD(K))
         CALL DROP(K,PLAC(K))
 1106 CONTINUE
C
      DO 1107 I=1,100
         K=101-I
         FIXED(K)=FIXD(K)
 1107 IF(PLAC(K).NE.0.AND.FIXD(K).LE.0)CALL DROP(K,PLAC(K))
C
C  TREASURES, AS NOTED EARLIER, ARE OBJECTS 50 THROUGH MAXTRS (CURRENTLY
C  THEIR PROPS ARE INITIALLY -1, AND ARE SET TO 0 THE FIRST TIME THEY AR
C  DESCRIBED.  TALLY KEEPS TRACK OF HOW MANY ARE NOT YET FOUND, SO WE KN
C  WHEN TO CLOSE THE CAVE.  TALLY2 COUNTS HOW MANY CAN NEVER BE FOUND (E
C  LOST BIRD OR BRIDGE).
C
      MAXTRS=79
      TALLY=0
      TALLY2=0
      DO 1200 I=50,MAXTRS
         IF(PTEXT(I).NE.0)PROP(I)=-1
 1200 TALLY=TALLY-PROP(I)
C
C  CLEAR THE HINT STUFF.  HINTLC(I) IS HOW LONG HE'S BEEN AT LOC WITH CO
C  I.  HINTED(I) IS TRUE IFF HINT I HAS BEEN USED.
C
      DO 1300 I=1,HNTMAX
         HINTED(I)=.FALSE.
 1300 HINTLC(I)=0
C
C  DEFINE SOME HANDY MNEMONICS.  THESE CORRESPOND TO OBJECT NUMBERS.
C
c     WRITE (0,9992)
c9992 FORMAT (' DEFINE OBJECT MNEMONICS')
C
      KEYS=VOCAB(CODE1('KEYS     '),1)
c     WRITE (0,9993)
c9993 FORMAT (' DEFINED KEYS')
      LAMP=VOCAB(CODE1('LAMP     '),1)
      GRATE=VOCAB(CODE1('GRATE    '),1)
      CAGE=VOCAB(CODE1('CAGE     '),1)
      ROD=VOCAB(CODE1('ROD      '),1)
      ROD2=ROD+1
      STEPS=VOCAB(CODE1('STEPS    '),1)
      BIRD=VOCAB(CODE1('BIRD     '),1)
      DOOR=VOCAB(CODE1('DOOR     '),1)
      PILLOW=VOCAB(CODE1('PILLO    '),1)
      SNAKE=VOCAB(CODE1('SNAKE    '),1)
      FISSUR=VOCAB(CODE1('FISSU    '),1)
      TABLET=VOCAB(CODE1('TABLE    '),1)
      CLAM=VOCAB(CODE1('CLAM     '),1)
      OYSTER=VOCAB(CODE1('OYSTE    '),1)
      MAGZIN=VOCAB(CODE1('MAGAZ    '),1)
      DWARF=VOCAB(CODE1('DWARF    '),1)
      KNIFE=VOCAB(CODE1('KNIFE    '),1)
      FOOD=VOCAB(CODE1('FOOD     '),1)
      BOTTLE=VOCAB(CODE1('BOTTL    '),1)
      WATER=VOCAB(CODE1('WATER    '),1)
      OIL=VOCAB(CODE1('OIL      '),1)
      PLANT=VOCAB(CODE1('PLANT    '),1)
      PLANT2=PLANT+1
      AXE=VOCAB(CODE1('AXE      '),1)
      MIRROR=VOCAB(CODE1('MIRRO    '),1)
      DRAGON=VOCAB(CODE1('DRAGO    '),1)
      CHASM=VOCAB(CODE1('CHASM    '),1)
      TROLL=VOCAB(CODE1('TROLL    '),1)
      TROLL2=TROLL+1
      BEAR=VOCAB(CODE1('BEAR     '),1)
      MESSAG=VOCAB(CODE1('MESSA    '),1)
      VEND=VOCAB(CODE1('VENDI    '),1)
      BATTER=VOCAB(CODE1('BATTE    '),1)
C
C  OBJECTS FROM 50 THROUGH WHATEVER ARE TREASURES.  HERE ARE A FEW.
C
c     WRITE (0,9994)
c9994 FORMAT (' DEFINE TREASURE MNEMONICS')
C
      NUGGET=VOCAB(CODE1('GOLD     '),1)
      COINS=VOCAB(CODE1('COINS    '),1)
      CHEST=VOCAB(CODE1('CHEST    '),1)
      EGGS=VOCAB(CODE1('EGGS     '),1)
      TRIDNT=VOCAB(CODE1('TRIDE    '),1)
      VASE=VOCAB(CODE1('VASE     '),1)
      EMRALD=VOCAB(CODE1('EMERA    '),1)
      PYRAM=VOCAB(CODE1('PYRAM    '),1)
      PEARL=VOCAB(CODE1('PEARL    '),1)
      RUG=VOCAB(CODE1('RUG      '),1)
      CHAIN=VOCAB(CODE1('CHAIN    '),1)
      SPICES=VOCAB(CODE1('SPICE    '),1)
C
C  THESE ARE MOTION-VERB NUMBERS.
C
      BACK=VOCAB(CODE1('BACK      '),0)
      LOOK=VOCAB(CODE1('LOOK      '),0)
      CAVE=VOCAB(CODE1('CAVE      '),0)
      NULL=VOCAB(CODE1('NULL     '),0)
      ENTRNC=VOCAB(CODE1('ENTRA    '),0)
      DPRSSN=VOCAB(CODE1('DEPRE    '),0)
C
C  AND SOME ACTION VERBS.
C
c     WRITE (0,9995)
c9995 FORMAT (' DEFINE ACTION MNEMONICS')
C
      SAY=VOCAB(CODE1('SAY      '),2)
      LOCK=VOCAB(CODE1('LOCK     '),2)
      THROW=VOCAB(CODE1('THROW    '),2)
      FIND=VOCAB(CODE1('FIND     '),2)
      INVENT=VOCAB(CODE1('INVEN    '),2)
      SUSPND=VOCAB(CODE1('SUSPE    '),2)
C
c     WRITE (0,9996)
c9996 FORMAT (' END MNEMONICS')
C
C  INITIALIZE THE DWARVES.  DLOC IS LOC OF DWARVES, HARD-WIRED IN.  ODLO
C  PRIOR LOC OF EACH DWARF, INITIALLY GARBAGE.  DALTLC IS ALTERNATE INIT
C  FOR DWARF, IN CASE ONE OF THEM STARTS OUT ON TOP OF THE ADVENTURER.
C  OF THE 5 INITIAL LOCS ARE ADJACENT.)  DSEEN IS TRUE IF DWARF HAS SEEN
C  DFLAG CONTROLS THE LEVEL OF ACTIVATION OF ALL THIS:
C       0       NO DWARF STUFF YET (WAIT UNTIL REACHES HALL OF MISTS)
C       1       REACHED HALL OF MISTS, BUT HASN'T MET FIRST DWARF
C       2       MET FIRST DWARF, OTHERS START MOVING, NO KNIVES THROWN Y
C       3       A KNIFE HAS BEEN THROWN (FIRST SET ALWAYS MISSES)
C       3+      DWARVES ARE MAD (INCREASES THEIR ACCURACY)
C  SIXTH DWARF IS SPECIAL (THE PIRATE).  HE ALWAYS STARTS AT HIS CHEST'S
C  EVENTUAL LOCATION INSIDE THE MAZE.  THIS LOC IS SAVED IN CHLOC FOR RE
C  THE DEAD END IN THE OTHER MAZE HAS ITS LOC STORED IN CHLOC2.
C
      CHLOC=114
      CHLOC2=140
      DO 1700 I=1,6
 1700 DSEEN(I)=.FALSE.
      DFLAG=0
      DLOC(1)=19
      DLOC(2)=27
      DLOC(3)=33
      DLOC(4)=44
      DLOC(5)=64
      DLOC(6)=CHLOC
      DALTLC=18
C
C  OTHER RANDOM FLAGS AND COUNTERS, AS FOLLOWS:
C       TURNS   TALLIES HOW MANY COMMANDS HE'S GIVEN (IGNORES YES/NO)
C       LIMIT   LIFETIME OF LAMP (NOT SET HERE)
C       IWEST   HOW MANY TIMES HE'S SAID "WEST" INSTEAD OF "W"
C       KNFLOC  0 IF NO KNIFE HERE, LOC IF KNIFE HERE, -1 AFTER CAVEAT
C       DETAIL  HOW OFTEN WE'VE SAID "NOT ALLOWED TO GIVE MORE DETAIL"
C       ABBNUM  HOW OFTEN WE SHOULD PRINT NON-ABBREVIATED DESCRIPTIONS
C       MAXDIE  NUMBER OF REINCARNATION MESSAGES AVAILABLE (UP TO 5)
C       NUMDIE  NUMBER OF TIMES KILLED SO FAR
C       HOLDNG  NUMBER OF OBJECTS BEING CARRIED
C       DKILL   NUMBER OF DWARVES KILLED (UNUSED IN SCORING, NEEDED FOR
C       FOOBAR  CURRENT PROGRESS IN SAYING "FEE FIE FOE FOO".
C       BONUS   USED TO DETERMINE AMOUNT OF BONUS IF HE REACHES CLOSING
C       CLOCK1  NUMBER OF TURNS FROM FINDING LAST TREASURE TILL CLOSING
C       CLOCK2  NUMBER OF TURNS FROM FIRST WARNING TILL BLINDING FLASH
C       LOGICALS WERE EXPLAINED EARLIER
C
      TURNS=0
      LMWARN=.FALSE.
      IWEST=0
      KNFLOC=0
      DETAIL=0
      ABBNUM=5
      DO 1800 I=0,4
 1800 IF(RTEXT(2*I+81).NE.0)MAXDIE=I+1
      NUMDIE=0
      HOLDNG=0
      DKILL=0
      FOOBAR=0
      BONUS=0
      CLOCK1=30
      CLOCK2=50
      SAVED=0
      CLOSNG=.FALSE.
      PANIC=.FALSE.
      CLOSED=.FALSE.
      GAVEUP=.FALSE.
      SCORNG=.FALSE.
C
C  IF SETUP=1, REPORT ON AMOUNT OF ARRAYS ACTUALLY USED, TO PERMIT REDUC
C
      IF(SETUP.NE.1)GO TO 19990
      SETUP=2
C
      DO 1998 K=1,LOCSIZ
         KK=LOCSIZ+1-K
         IF(LTEXT(KK).NE.0)GO TO 1997
 1998 CONTINUE
C
      OBJ=0
 1997 DO 1996 K=1,100
 1996 IF(PTEXT(K).NE.0)OBJ=OBJ+1
C
      DO 1995 K=1,TABNDX
 1995 IF(KTAB(K)/1000.EQ.2)VERB=KTAB(K)-2000
C
      DO 1994 K=1,RTXSIZ
         J=RTXSIZ+1-K
         IF(RTEXT(J).NE.0)GO TO 1993
 1994 CONTINUE
C
 1993 DO 1992 K=1,MAGSIZ
         I=MAGSIZ+1-K
         IF(MTEXT(I).NE.0)GO TO 1991
 1992 CONTINUE
C
 1991 K=100
      WRITE(TTYO,1999)LINUSE,LINSIZ,TRVS,TRVSIZ,TABNDX,TABSIZ,KK
     1,LOCSIZ,OBJ,K,VERB,VRBSIZ,J,RTXSIZ,CLSSES,CLSMAX
     2,HNTMAX,HNTSIZ,I,MAGSIZ
 1999 FORMAT (' TABLE SPACE USED:',/
     1' ',I6,' OF ',I6,' WORDS OF MESSAGES',/
     2' ',I6,' OF ',I6,' TRAVEL OPTIONS',/
     3' ',I6,' OF ',I6,' VOCABULARY WORDS',/
     4' ',I6,' OF ',I6,' LOCATIONS',/
     5' ',I6,' OF ',I6,' OBJECTS',/
     6' ',I6,' OF ',I6,' ACTION VERBS',/
     7' ',I6,' OF ',I6,' RTEXT MESSAGES',/
     8' ',I6,' OF ',I6,' CLASS MESSAGES',/
     9' ',I6,' OF ',I6,' HINTS',/
     1' ',I6,' OF ',I6,' MAGIC MESSAGES',/
     2)
C
C  FINALLY, SINCE WE'RE CLEARLY SETTING THINGS UP FOR THE FIRST TIME...
C
      CALL POOF
19990 CALL MAINT(CMADRS,CMSZES)
C
      WRITE(TTYO,19991)
19991 FORMAT(' INITIALIZATION COMPLETED.')
C
C  START-UP, DWARF STUFF
C
    1 DEMO=START(0)
      CALL MOTD(.FALSE.)
      I=RAN(1)
      HINTED(3)=YESX(65,1,0,1)
      NEWLOC=1
      SETUP=3
      LIMIT=330
      IF(HINTED(3))LIMIT=1000
C
C  CAN'T LEAVE CAVE ONCE IT'S CLOSING (EXCEPT BY MAIN OFFICE).
C
    2 IF(NEWLOC.GE.9.OR.NEWLOC.EQ.0.OR..NOT.CLOSNG)GO TO 71
      CALL RSPEAK(130)
      NEWLOC=LOC
      IF(.NOT.PANIC)CLOCK2=15
      PANIC=.TRUE.
C
C  SEE IF A DWARF HAS SEEN HIM AND HAS COME FROM WHERE HE WANTS TO GO.
C  THE DWARF'S BLOCKING HIS WAY.  IF COMING FROM PLACE FORBIDDEN TO PIRA
C  (DWARVES ROOTED IN PLACE) LET HIM GET OUT (AND ATTACKED).
C
   71 IF(NEWLOC.EQ.LOC.OR.FORCED(LOC).OR.BITSET(LOC,3))GO TO 74
      DO 73 I=1,5
         IF(ODLOC(I).NE.NEWLOC.OR..NOT.DSEEN(I))GO TO 73
         NEWLOC=LOC
         CALL RSPEAK(2)
         GO TO 74
   73 CONTINUE
   74 LOC=NEWLOC
C
C  DWARF STUFF.  SEE EARLIER COMMENTS FOR DESCRIPTION OF VARIABLES.  REM
C  SIXTH DWARF IS PIRATE AND IS THUS VERY DIFFERENT EXCEPT FOR MOTION RU
C
C  FIRST OFF, DON'T LET THE DWARVES FOLLOW HIM INTO A PIT OR A WALL.  AC
C  THE WHOLE MESS THE FIRST TIME HE GETS AS FAR AS THE HALL OF MISTS (LO
C  IF NEWLOC IS FORBIDDEN TO PIRATE (IN PARTICULAR, IF IT'S BEYOND THE T
C  BRIDGE), BYPASS DWARF STUFF.  THAT WAY PIRATE CAN'T STEAL RETURN TOLL
C  DWARVES CAN'T MEET THE BEAR.  ALSO MEANS DWARVES WON'T FOLLOW HIM INT
C  END IN MAZE, BUT C'EST LA VIE.  THEY'LL WAIT FOR HIM OUTSIDE THE DEAD
C
      IF(LOC.EQ.0.OR.FORCED(LOC).OR.BITSET(NEWLOC,3))GO TO 2000
      IF(DFLAG.NE.0)GO TO 6000
      IF(LOC.GE.15)DFLAG=1
      GO TO 2000
C
C  WHEN WE ENCOUNTER THE FIRST DWARF, WE KILL 0, 1, OR 2 OF THE 5 DWARVE
C  ANY OF THE SURVIVORS IS AT LOC, REPLACE HIM WITH THE ALTERNATE.
C
 6000 IF(DFLAG.NE.1)GO TO 6010
      IF(LOC.LT.15.OR.PCT(95))GO TO 2000
      DFLAG=2
      DO 6001 I=1,2
         J=1+RAN(5)
C  IF SAVED NOT = -1, HE BYPASSED THE "START" CALL.
 6001 IF(PCT(50).AND.SAVED.EQ.-1)DLOC(J)=0
      DO 6002 I=1,5
         IF(DLOC(I).EQ.LOC)DLOC(I)=DALTLC
 6002 ODLOC(I)=DLOC(I)
      CALL RSPEAK(3)
      CALL DROP(AXE,LOC)
      GO TO 2000
C
C  THINGS ARE IN FULL SWING.  MOVE EACH DWARF AT RANDOM, EXCEPT IF HE'S
C  HE STICKS WITH US.  DWARVES NEVER GO TO LOCS <15.  IF WANDERING AT RA
C  THEY DON'T BACK UP UNLESS THERE'S NO ALTERNATIVE.  IF THEY DON'T HAVE
C  MOVE, THEY ATTACK.  AND, OF COURSE, DEAD DWARVES DON'T DO MUCH OF ANY
C
 6010 DTOTAL=0
      ATTACK=0
      STICK=0
      DO 6030 I=1,6
         IF(DLOC(I).EQ.0)GO TO 6030
         J=1
         KK=DLOC(I)
         KK=KEY(KK)
         IF(KK.EQ.0)GO TO 6016
 6012    NEWLOC=MOD(IABS(TRAVEL(KK))/1000,1000)
         IF(NEWLOC.GT.300.OR.NEWLOC.LT.15.OR.NEWLOC.EQ.ODLOC(I)
     1   .OR.(J.GT.1.AND.NEWLOC.EQ.TK(J-1)).OR.J.GE.20
     2   .OR.NEWLOC.EQ.DLOC(I).OR.FORCED(NEWLOC)
     3   .OR.(I.EQ.6.AND.BITSET(NEWLOC,3))
     4   .OR.IABS(TRAVEL(KK))/1000000.EQ.100)GO TO 6014
         TK(J)=NEWLOC
         J=J+1
 6014    KK=KK+1
         IF(TRAVEL(KK-1).GE.0)GO TO 6012
 6016    TK(J)=ODLOC(I)
         IF(J.GE.2)J=J-1
         J=1+RAN(J)
         ODLOC(I)=DLOC(I)
         DLOC(I)=TK(J)
         DSEEN(I)=(DSEEN(I).AND.LOC.GE.15)
     1   .OR.(DLOC(I).EQ.LOC.OR.ODLOC(I).EQ.LOC)
         IF(.NOT.DSEEN(I))GO TO 6030
         DLOC(I)=LOC
         IF(I.NE.6)GO TO 6027
C
C  THE PIRATE'S SPOTTED HIM.  HE LEAVES HIM ALONE ONCE WE'VE FOUND CHEST
C  K COUNTS IF A TREASURE IS HERE.  IF NOT, AND TALLY=TALLY2 PLUS ONE FO
C  AN UNSEEN CHEST, LET THE PIRATE BE SPOTTED.
C
         IF(LOC.EQ.CHLOC.OR.PROP(CHEST).GE.0)GO TO 6030
         K=0
         DO 6020 J=50,MAXTRS
C  PIRATE WON'T TAKE PYRAMID FROM PLOVER ROOM OR DARK ROOM (TOO EASY!).
            IF(J.EQ.PYRAM.AND.(LOC.EQ.PLAC(PYRAM)
     1      .OR.LOC.EQ.PLAC(EMRALD)))GO TO 6020
            IF(TOTING(J))GO TO 6022
 6020    IF(HERE(J))K=1
         IF(TALLY.EQ.TALLY2+1.AND.K.EQ.0.AND.PLACE(CHEST).EQ.0
     1   .AND.HERE(LAMP).AND.PROP(LAMP).EQ.1)GO TO 6025
         IF(ODLOC(6).NE.DLOC(6).AND.PCT(20))CALL RSPEAK(127)
         GO TO 6030
C
 6022    CALL RSPEAK(128)
C  DON'T STEAL CHEST BACK FROM TROLL!
         IF(PLACE(MESSAG).EQ.0)CALL MOVE(CHEST,CHLOC)
         CALL MOVE(MESSAG,CHLOC2)
         DO 6023 J=50,MAXTRS
            IF(J.EQ.PYRAM.AND.(LOC.EQ.PLAC(PYRAM)
     1      .OR.LOC.EQ.PLAC(EMRALD)))GO TO 6023
            IF(AT(J).AND.FIXED(J).EQ.0)CALL CARRY(J,LOC)
            IF(TOTING(J))CALL DROP(J,CHLOC)
 6023    CONTINUE
 6024    DLOC(6)=CHLOC
         ODLOC(6)=CHLOC
         DSEEN(6)=.FALSE.
         GO TO 6030
C
 6025    CALL RSPEAK(186)
         CALL MOVE(CHEST,CHLOC)
         CALL MOVE(MESSAG,CHLOC2)
         GO TO 6024
C
C  THIS THREATENING LITTLE DWARF IS IN THE ROOM WITH HIM!
C
 6027    DTOTAL=DTOTAL+1
         IF(ODLOC(I).NE.DLOC(I))GO TO 6030
         ATTACK=ATTACK+1
         IF(KNFLOC.GE.0)KNFLOC=LOC
         IF(RAN(1000).LT.95*(DFLAG-2))STICK=STICK+1
 6030 CONTINUE
C
C  NOW WE KNOW WHAT'S HAPPENING.  LET'S TELL THE POOR SUCKER ABOUT IT.
C
      IF(DTOTAL.EQ.0)GO TO 2000
      IF(DTOTAL.EQ.1)GO TO 75
      WRITE(TTYO,67)DTOTAL
   67 FORMAT(/,' THERE ARE ',I1,' THREATENING LITTLE DWARVES IN THE'
     1,' ROOM WITH YOU.')
      GO TO 77
   75 CALL RSPEAK(4)
   77 IF(ATTACK.EQ.0)GO TO 2000
      IF(DFLAG.EQ.2)DFLAG=3
C  IF SAVED NOT = -1, HE BYPASSED THE "START" CALL.  DWARVES GET *VERY*
      IF(SAVED.NE.-1)DFLAG=20
      IF(ATTACK.EQ.1)GO TO 79
      WRITE(TTYO,78)ATTACK
   78 FORMAT(/,' ',I1,' OF THEM THROW KNIVES AT YOU!')
      K=6
   82 IF(STICK.GT.1)GO TO 83
      CALL RSPEAK(K+STICK)
      IF(STICK.EQ.0)GO TO 2000
      GO TO 84
   83 WRITE(TTYO,68)STICK
   68 FORMAT(/,' ',I1,' OF THEM GET YOU!')
   84 OLDLC2=LOC
      GO TO 99
C
   79 CALL RSPEAK(5)
      K=52
      GO TO 82
C
C  DESCRIBE THE CURRENT LOCATION AND (MAYBE) GET NEXT COMMAND.
C
C  PRINT TEXT FOR CURRENT LOC.
C
 2000 IF(LOC.EQ.0)GO TO 99
      KK=STEXT(LOC)
      IF(MOD(ABB(LOC),ABBNUM).EQ.0.OR.KK.EQ.0)KK=LTEXT(LOC)
      IF(FORCED(LOC).OR..NOT.DARK(0))GO TO 2001
      IF(WZDARK.AND.PCT(35))GO TO 90
      KK=RTEXT(16)
 2001 IF(TOTING(BEAR))CALL RSPEAK(141)
      CALL SPEAK(KK)
      K=1
      IF(FORCED(LOC))GO TO 8
      IF(LOC.EQ.33.AND.PCT(25).AND..NOT.CLOSNG)CALL RSPEAK(8)
C
C  PRINT OUT DESCRIPTIONS OF OBJECTS AT THIS LOCATION.  IF NOT CLOSING A
C  PROPERTY VALUE IS NEGATIVE, TALLY OFF ANOTHER TREASURE.  RUG IS SPECI
C  CASE; ONCE SEEN, ITS PROP IS 1 (DRAGON ON IT) TILL DRAGON IS KILLED.
C  SIMILARLY FOR CHAIN; PROP IS INITIALLY 1 (LOCKED TO BEAR).  THESE HAC
C  ARE BECAUSE PROP=0 IS NEEDED TO GET FULL SCORE.
C
      IF(DARK(0))GO TO 2012
      ABB(LOC)=ABB(LOC)+1
      I=ATLOC(LOC)
 2004 IF(I.EQ.0)GO TO 2012
      OBJ=I
      IF(OBJ.GT.100)OBJ=OBJ-100
      IF(OBJ.EQ.STEPS.AND.TOTING(NUGGET))GO TO 2008
      IF(PROP(OBJ).GE.0)GO TO 2006
      IF(CLOSED)GO TO 2008
      PROP(OBJ)=0
      IF(OBJ.EQ.RUG.OR.OBJ.EQ.CHAIN)PROP(OBJ)=1
      TALLY=TALLY-1
C  IF REMAINING TREASURES TOO ELUSIVE, ZAP HIS LAMP.
      IF(TALLY.EQ.TALLY2.AND.TALLY.NE.0)LIMIT=MIN0(35,LIMIT)
 2006 KK=PROP(OBJ)
      IF(OBJ.EQ.STEPS.AND.LOC.EQ.FIXED(STEPS))KK=1
      CALL PSPEAK(OBJ,KK)
 2008 I=LINK(I)
      GO TO 2004
C
 2009 K=54
 2010 SPK=K
 2011 CALL RSPEAK(SPK)
C
 2012 VERB=0
      OBJ=0
C
C  CHECK IF THIS LOC IS ELIGIBLE FOR ANY HINTS.  IF BEEN HERE LONG ENOUG
C  BRANCH TO HELP SECTION (ON LATER PAGE).  HINTS ALL COME BACK HERE EVE
C  TO FINISH THE LOOP.  IGNORE "HINTS" < 4 (SPECIAL STUFF, SEE DATABASE
C
 2600 DO 2602 HINT=4,HNTMAX
      IF(HINTED(HINT))GO TO 2602
      IF(.NOT.BITSET(LOC,HINT))HINTLC(HINT)=-1
      HINTLC(HINT)=HINTLC(HINT)+1
      IF(HINTLC(HINT).GE.HINTS(HINT,1))GO TO 40000
 2602 CONTINUE
C
C  KICK THE RANDOM NUMBER GENERATOR JUST TO ADD VARIETY TO THE CHASE.  A
C  IF CLOSING TIME, CHECK FOR ANY OBJECTS BEING TOTED WITH PROP < 0 AND
C  THE PROP TO -1-PROP.  THIS WAY OBJECTS WON'T BE DESCRIBED UNTIL THEY'
C  BEEN PICKED UP AND PUT DOWN SEPARATE FROM THEIR RESPECTIVE PILES.  DO
C  TICK CLOCK1 UNLESS WELL INTO CAVE (AND NOT AT Y2).
C
      IF(.NOT.CLOSED)GO TO 2605
      IF(PROP(OYSTER).LT.0.AND.TOTING(OYSTER))
     1CALL PSPEAK(OYSTER,1)
      DO 2604 I=1,100
 2604 IF(TOTING(I).AND.PROP(I).LT.0)PROP(I)=-1-PROP(I)
 2605 WZDARK=DARK(0)
      IF(KNFLOC.GT.0.AND.KNFLOC.NE.LOC)KNFLOC=0
      I=RAN(1)
      CALL GETIN(WD1,WD1X,WD2,WD2X,.FALSE.)
C
C  EVERY INPUT, CHECK "FOOBAR" FLAG.  IF ZERO, NOTHING'S GOING ON.  IF P
C  MAKE NEG.  IF NEG, HE SKIPPED A WORD, SO MAKE IT ZERO.
C
 2608 FOOBAR=MIN0(0,-FOOBAR)
      IF(TURNS.EQ.0.AND.WD1.EQ.CODE1('MAGIC    ').AND.
     1WD2.EQ.CODE1('MODE     '))CALL MAINT(CMADRS,CMSZES)
      IF(TURNS.EQ.0.AND.WD1.EQ.CODE1('RESTO    '))GO TO 8400
C
      TURNS=TURNS+1
      IF(DEMO.AND.TURNS.GE.SHORT)GO TO 13000
C
      IF(TURNS.EQ.3)CALL DATIME(XXD,XXT)
      IF(TURNS.NE.45)GO TO 2609
C  CHECK IF PLAYER HAS ZAPPED TIMING ROUTINE;  IF SO, HE'S CHEATING.
      CALL DATIME(YYD,YYT)
      IF(XXD.EQ.YYD.AND.XXT.EQ.YYT)SAVED=0
C
 2609 IF(VERB.EQ.SAY.AND.WD2.NE.0)VERB=0
      IF(VERB.EQ.SAY)GO TO 4090
      IF(TALLY.EQ.0.AND.LOC.GE.15.AND.LOC.NE.33)CLOCK1=CLOCK1-1
      IF(CLOCK1.EQ.0)GO TO 10000
      IF(CLOCK1.LT.0)CLOCK2=CLOCK2-1
      IF(CLOCK2.EQ.0)GO TO 11000
      IF(PROP(LAMP).EQ.1)LIMIT=LIMIT-1
      IF(LIMIT.LE.30.AND.HERE(BATTER).AND.PROP(BATTER).EQ.0
     1.AND.HERE(LAMP))GO TO 12000
      IF(LIMIT.EQ.0)GO TO 12400
      IF(LIMIT.LT.0.AND.LOC.LE.8)GO TO 12600
      IF(LIMIT.LE.30)GO TO 12200
19999 K=43
      IF(LIQLOC(LOC).EQ.WATER)K=70
      IF(WD1.EQ.CODE1('ENTER    ').AND.
     1(WD2.EQ.CODE1('STREA    ').OR.WD2.EQ.CODE1('WATER    ')))
     2GO TO 2010
      IF(WD1.EQ.CODE1('ENTER    ').AND.WD2.NE.0)GO TO 2800
      IF((WD1.NE.CODE1('WATER    ').AND.WD1.NE.CODE1('OIL      '))
     1.OR.(WD2.NE.CODE1('PLANT    ').AND.WD2.NE.CODE1('DOOR     ')))
     *GO TO 2610
      IF(AT(VOCAB(WD2,1)))WD2=CODE1('POUR     ')
 2610 IF(WD1.NE.CODE1('WEST     '))GO TO 2630
      IWEST=IWEST+1
      IF(IWEST.EQ.10)CALL RSPEAK(17)
 2630 I=VOCAB(WD1,-1)
      IF(I.EQ.-1)GO TO 3000
      K=MOD(I,1000)
      KQ=I/1000+1
      IF ((KQ.LT.1).OR.(KQ.GT.4)) CALL BUG(22)
      GO TO (8,5000,4000,2010),KQ
C
C  GET SECOND WORD FOR ANALYSIS.
C
 2800 WD1=WD2
      WD1X=WD2X
      WD2=0
      GO TO 2610
C
C  GEE, I DON'T UNDERSTAND.
C
 3000 SPK=60
      IF(PCT(20))SPK=61
      IF(PCT(20))SPK=13
      CALL RSPEAK(SPK)
      GO TO 2600
C
C  ANALYSE A VERB.  REMEMBER WHAT IT WAS, GO BACK FOR OBJECT IF SECOND W
C  UNLESS VERB IS "SAY" OR "SUSPEND", WHICH SNARFS ARBITRARY SECOND WORD
C
 4000 VERB=K
      SPK=ACTSPK(VERB)
      IF(WD2.NE.0.AND.
     1(VERB.NE.SAY.AND.VERB.NE.SUSPND))GO TO 2800
      IF(VERB.EQ.SAY.OR.VERB.EQ.SUSPND)OBJ=WD2
      IF(OBJ.NE.0)GO TO 4090
C
C  ANALYSE AN INTRANSITIVE VERB (IE, NO OBJECT GIVEN YET).
C
      IF ((VERB.LT.1).OR.(VERB.GT.31)) CALL BUG(23)
 4080 GO TO(8010,8000,8000,8040,2009,8040,9070,9080,8000,8000,
     12011,9120,9130,8140,9150,8000,8000,8180,8000,8200,
     28000,9220,9230,8240,8250,8260,8270,8000,8000,8300,
     38310),VERB
C          TAKE DROP  SAY OPEN NOTH LOCK   ON  OFF WAVE CALM
C     WALK KILL POUR  EAT DRNK  RUB TOSS QUIT FIND INVN
C     FEED FILL BLST SCOR  FOO  BRF READ BREK WAKE SUSP
C     HOUR
C
C  ANALYSE A TRANSITIVE VERB.
C
      IF ((VERB.LT.1).OR.(VERB.GT.31)) CALL BUG(24)
 4090 GO TO(9010,9020,9030,9040,2009,9040,9070,9080,9090,2011,
     12011,9120,9130,9140,9150,9160,9170,2011,9190,9190,
     29210,9220,9230,2011,2011,2011,9270,9280,9290,8300,
     32011),VERB
C          TAKE DROP  SAY OPEN NOTH LOCK   ON  OFF WAVE CALM
C     WALK KILL POUR  EAT DRNK  RUB TOSS QUIT FIND INVN
C     FEED FILL BLST SCOR  FOO  BRF READ BREK WAKE SUSP
C     HOUR
C
C  ANALYSE AN OBJECT WORD.  SEE IF THE THING IS HERE, WHETHER WE'VE GOT
C  YET, AND SO ON.  OBJECT MUST BE HERE UNLESS VERB IS "FIND" OR "INVENT
C  (AND NO NEW VERB YET TO BE ANALYSED).  WATER AND OIL ARE ALSO FUNNY,
C  THEY ARE NEVER ACTUALLY DROPPED AT ANY LOCATION, BUT MIGHT BE HERE IN
C  THE BOTTLE OR AS A FEATURE OF THE LOCATION.
C
 5000 OBJ=K
      IF(FIXED(K).NE.LOC.AND..NOT.HERE(K))GO TO 5100
 5010 IF(WD2.NE.0)GO TO 2800
      IF(VERB.NE.0)GO TO 4090
      CALL A5TOA1(WD1,WD1X,CODE1('?        '),.FALSE.,TK,K)
      WRITE(TTYO,5015)(TK(I),I=1,K)
 5015 FORMAT(/,' WHAT DO YOU WANT TO DO WITH THE ',20A1)
      GO TO 2600
C
 5100 IF(K.NE.GRATE)GO TO 5110
      IF(LOC.EQ.1.OR.LOC.EQ.4.OR.LOC.EQ.7)K=DPRSSN
      IF(LOC.GT.9.AND.LOC.LT.15)K=ENTRNC
      IF(K.NE.GRATE)GO TO 8
 5110 IF(K.NE.DWARF)GO TO 5120
      DO 5112 I=1,5
         IF(DLOC(I).EQ.LOC.AND.DFLAG.GE.2)GO TO 5010
 5112 CONTINUE
 5120 IF((LIQ(0).EQ.K.AND.HERE(BOTTLE)).OR.K.EQ.LIQLOC(LOC))GO TO 5010
      IF(OBJ.NE.PLANT.OR..NOT.AT(PLANT2).OR.PROP(PLANT2).EQ.0)GO TO 5130
      OBJ=PLANT2
      GO TO 5010
 5130 IF(OBJ.NE.KNIFE.OR.KNFLOC.NE.LOC)GO TO 5140
      KNFLOC=-1
      SPK=116
      GO TO 2011
 5140 IF(OBJ.NE.ROD.OR..NOT.HERE(ROD2))GO TO 5190
      OBJ=ROD2
      GO TO 5010
 5190 IF((VERB.EQ.FIND.OR.VERB.EQ.INVENT).AND.WD2.EQ.0)GO TO 5010
      CALL A5TOA1(WD1,WD1X,CODE1('HERE.    '),.TRUE.,TK,K)
      WRITE(TTYO,5199)(TK(I),I=1,K)
 5199 FORMAT(/,' I SEE NO ',20A1)
      GO TO 2012
C
C  FIGURE OUT THE NEW LOCATION
C
C  GIVEN THE CURRENT LOCATION IN "LOC", AND A MOTION VERB NUMBER IN "K",
C  THE NEW LOCATION IN "NEWLOC".  THE CURRENT LOC IS SAVED IN "OLDLOC" I
C  HE WANTS TO RETREAT.  THE CURRENT OLDLOC IS SAVED IN OLDLC2, IN CASE
C  DIES.  (IF HE DOES, NEWLOC WILL BE LIMBO, AND OLDLOC WILL BE WHAT KIL
C  HIM, SO WE NEED OLDLC2, WHICH IS THE LAST PLACE HE WAS SAFE.)
C
    8 KK=KEY(LOC)
      NEWLOC=LOC
      IF(KK.EQ.0)CALL BUG(26)
      IF(K.EQ.NULL)GO TO 2
      IF(K.EQ.BACK)GO TO 20
      IF(K.EQ.LOOK)GO TO 30
      IF(K.EQ.CAVE)GO TO 40
      OLDLC2=OLDLOC
      OLDLOC=LOC
C
    9 LL=IABS(TRAVEL(KK))
      IF(MOD(LL,1000).EQ.1.OR.MOD(LL,1000).EQ.K)GO TO 10
      IF(TRAVEL(KK).LT.0)GO TO 50
      KK=KK+1
      GO TO 9
C
   10 LL=LL/1000
   11 NEWLOC=LL/1000
      K=MOD(NEWLOC,100)
      IF(NEWLOC.LE.300)GO TO 13
      IF(PROP(K).NE.NEWLOC/100-3)GO TO 16
   12 IF(TRAVEL(KK).LT.0)CALL BUG(25)
      KK=KK+1
      NEWLOC=IABS(TRAVEL(KK))/1000
      IF(NEWLOC.EQ.LL)GO TO 12
      LL=NEWLOC
      GO TO 11
C
   13 IF(NEWLOC.LE.100)GO TO 14
      IF(TOTING(K).OR.(NEWLOC.GT.200.AND.AT(K)))GO TO 16
      GO TO 12
C
   14 IF(NEWLOC.NE.0.AND..NOT.PCT(NEWLOC))GO TO 12
   16 NEWLOC=MOD(LL,1000)
      IF(NEWLOC.LE.300)GO TO 2
      IF(NEWLOC.LE.500)GO TO 30000
      CALL RSPEAK(NEWLOC-500)
      NEWLOC=LOC
      GO TO 2
C
C  SPECIAL MOTIONS COME HERE.  LABELLING CONVENTION: STATEMENT NUMBERS N
C  (XX=00-99) ARE USED FOR SPECIAL CASE NUMBER NNN (NNN=301-500).
C
30000 NEWLOC=NEWLOC-300
      IF ((NEWLOC.LT.1).OR.(NEWLOC.GT.3)) CALL BUG(20)
      GO TO (30100,30200,30300),NEWLOC
C
C  TRAVEL 301.  PLOVER-ALCOVE PASSAGE.  CAN CARRY ONLY EMERALD.  NOTE: T
C  TABLE MUST INCLUDE "USELESS" ENTRIES GOING THROUGH PASSAGE, WHICH CAN
C  BE USED FOR ACTUAL MOTION, BUT CAN BE SPOTTED BY "GO BACK".
C
30100 NEWLOC=99+100-LOC
      IF(HOLDNG.EQ.0.OR.(HOLDNG.EQ.1.AND.TOTING(EMRALD)))GO TO 2
      NEWLOC=LOC
      CALL RSPEAK(117)
      GO TO 2
C
C  TRAVEL 302.  PLOVER TRANSPORT.  DROP THE EMERALD (ONLY USE SPECIAL TR
C  TOTING IT), SO HE'S FORCED TO USE THE PLOVER-PASSAGE TO GET IT OUT.
C  DROPPED IT, GO BACK AND PRETEND HE WASN'T CARRYING IT AFTER ALL.
C
30200 CALL DROP(EMRALD,LOC)
      GO TO 12
C
C  TRAVEL 303.  TROLL BRIDGE.  MUST BE DONE ONLY AS SPECIAL MOTION SO TH
C  DWARVES WON'T WANDER ACROSS AND ENCOUNTER THE BEAR.  (THEY WON'T FOLL
C  PLAYER THERE BECAUSE THAT REGION IS FORBIDDEN TO THE PIRATE.)  IF
C  PROP(TROLL)=1, HE'S CROSSED SINCE PAYING, SO STEP OUT AND BLOCK HIM.
C  (STANDARD TRAVEL ENTRIES CHECK FOR PROP(TROLL)=0.)  SPECIAL STUFF FOR
C
30300 IF(PROP(TROLL).NE.1)GO TO 30310
      CALL PSPEAK(TROLL,1)
      PROP(TROLL)=0
      CALL MOVE(TROLL2,0)
      CALL MOVE(TROLL2+100,0)
      CALL MOVE(TROLL,PLAC(TROLL))
      CALL MOVE(TROLL+100,FIXD(TROLL))
      CALL JUGGLE(CHASM)
      NEWLOC=LOC
      GO TO 2
C
30310 NEWLOC=PLAC(TROLL)+FIXD(TROLL)-LOC
      IF(PROP(TROLL).EQ.0)PROP(TROLL)=1
      IF(.NOT.TOTING(BEAR))GO TO 2
      CALL RSPEAK(162)
      PROP(CHASM)=1
      PROP(TROLL)=2
      CALL DROP(BEAR,NEWLOC)
      FIXED(BEAR)=-1
      PROP(BEAR)=3
      IF(PROP(SPICES).LT.0)TALLY2=TALLY2+1
      OLDLC2=NEWLOC
      GO TO 99
C
C  END OF SPECIALS.
C
C  HANDLE "GO BACK".  LOOK FOR VERB WHICH GOES FROM LOC TO OLDLOC, OR TO
C  IF OLDLOC HAS FORCED-MOTION.  K2 SAVES ENTRY -> FORCED LOC -> PREVIOU
C
   20 K=OLDLOC
      IF(FORCED(K))K=OLDLC2
      OLDLC2=OLDLOC
      OLDLOC=LOC
      K2=0
      IF(K.NE.LOC)GO TO 21
      CALL RSPEAK(91)
      GO TO 2
C
   21 LL=MOD((IABS(TRAVEL(KK))/1000),1000)
      IF(LL.EQ.K)GO TO 25
      IF(LL.GT.300)GO TO 22
      J=KEY(LL)
      IF(FORCED(LL).AND.MOD((IABS(TRAVEL(J))/1000),1000).EQ.K)K2=KK
   22 IF(TRAVEL(KK).LT.0)GO TO 23
      KK=KK+1
      GO TO 21
C
   23 KK=K2
      IF(KK.NE.0)GO TO 25
      CALL RSPEAK(140)
      GO TO 2
C
   25 K=MOD(IABS(TRAVEL(KK)),1000)
      KK=KEY(LOC)
      GO TO 9
C
C  LOOK.  CAN'T GIVE MORE DETAIL.  PRETEND IT WASN'T DARK (THOUGH IT MAY
C  BE DARK) SO HE WON'T FALL INTO A PIT WHILE STARING INTO THE GLOOM.
C
   30 IF(DETAIL.LT.3)CALL RSPEAK(15)
      DETAIL=DETAIL+1
      WZDARK=.FALSE.
      ABB(LOC)=0
      GO TO 2
C
C  CAVE.  DIFFERENT MESSAGES DEPENDING ON WHETHER ABOVE GROUND.
C
   40 IF(LOC.LT.8)CALL RSPEAK(57)
      IF(LOC.GE.8)CALL RSPEAK(58)
      GO TO 2
C
C  NON-APPLICABLE MOTION.  VARIOUS MESSAGES DEPENDING ON WORD GIVEN.
C
   50 SPK=12
      IF(K.GE.43.AND.K.LE.50)SPK=9
      IF(K.EQ.29.OR.K.EQ.30)SPK=9
      IF(K.EQ.7.OR.K.EQ.36.OR.K.EQ.37)SPK=10
      IF(K.EQ.11.OR.K.EQ.19)SPK=11
      IF(VERB.EQ.FIND.OR.VERB.EQ.INVENT)SPK=59
      IF(K.EQ.62.OR.K.EQ.65)SPK=42
      IF(K.EQ.17)SPK=80
      CALL RSPEAK(SPK)
      GO TO 2
C
C  "YOU'RE DEAD, JIM."
C
C  IF THE CURRENT LOC IS ZERO, IT MEANS THE CLOWN GOT HIMSELF KILLED.  W
C  ALLOW THIS MAXDIE TIMES.  MAXDIE IS AUTOMATICALLY SET BASED ON THE NU
C  SNIDE MESSAGES AVAILABLE.  EACH DEATH RESULTS IN A MESSAGE (81, 83, E
C  WHICH OFFERS REINCARNATION; IF ACCEPTED, THIS RESULTS IN MESSAGE 82,
C  ETC.  THE LAST TIME, IF HE WANTS ANOTHER CHANCE, HE GETS A SNIDE REMA
C  WE EXIT.  WHEN REINCARNATED, ALL OBJECTS BEING CARRIED GET DROPPED AT
C  (PRESUMABLY THE LAST PLACE PRIOR TO BEING KILLED) WITHOUT CHANGE OF P
C  THE LOOP RUNS BACKWARDS TO ASSURE THAT THE BIRD IS DROPPED BEFORE THE
C  (THIS KLUGE COULD BE CHANGED ONCE WE'RE SURE ALL REFERENCES TO BIRD A
C  ARE DONE BY KEYWORDS.)  THE LAMP IS A SPECIAL CASE (IT WOULDN'T DO TO
C  IT IN THE CAVE).  IT IS TURNED OFF AND LEFT OUTSIDE THE BUILDING (ONL
C  WAS CARRYING IT, OF COURSE).  HE HIMSELF IS LEFT INSIDE THE BUILDING
C  HEAVEN HELP HIM IF HE TRIES TO XYZZY BACK INTO THE CAVE WITHOUT THE L
C  OLDLOC IS ZAPPED SO HE CAN'T JUST "RETREAT".
C
C  THE EASIEST WAY TO GET KILLED IS TO FALL INTO A PIT IN PITCH DARKNESS
C
   90 CALL RSPEAK(23)
      OLDLC2=LOC
C
C  OKAY, HE'S DEAD.  LET'S GET ON WITH IT.
C
   99 IF(CLOSNG)GO TO 95
      YEA=YESX(81+NUMDIE*2,82+NUMDIE*2,54,1)
      NUMDIE=NUMDIE+1
      IF(NUMDIE.EQ.MAXDIE.OR..NOT.YEA)GO TO 20000
      PLACE(WATER)=0
      PLACE(OIL)=0
      IF(TOTING(LAMP))PROP(LAMP)=0
      DO 98 J=1,100
         I=101-J
         IF(.NOT.TOTING(I))GO TO 98
         K=OLDLC2
         IF(I.EQ.LAMP)K=1
         CALL DROP(I,K)
   98 CONTINUE
      LOC=3
      OLDLOC=LOC
      GO TO 2000
C
C  HE DIED DURING CLOSING TIME.  NO RESURRECTION.  TALLY UP A DEATH AND
C
   95 CALL RSPEAK(131)
      NUMDIE=NUMDIE+1
      GO TO 20000
C
C  ROUTINES FOR PERFORMING THE VARIOUS ACTION VERBS
C
C  STATEMENT NUMBERS IN THIS SECTION ARE 8000 FOR INTRANSITIVE VERBS, 90
C  TRANSITIVE, PLUS TEN TIMES THE VERB NUMBER.  MANY INTRANSITIVE VERBS
C  TRANSITIVE CODE, AND SOME VERBS USE CODE FOR OTHER VERBS, AS NOTED BE
C
C  RANDOM INTRANSITIVE VERBS COME HERE.  CLEAR OBJ JUST IN CASE (SEE "AT
C
 8000 CALL A5TOA1(WD1,WD1X,CODE1('WHAT?    '),.TRUE.,TK,K)
      WRITE(TTYO,8002)(TK(I),I=1,K)
 8002 FORMAT(/,' ',20A1)
      OBJ=0
      GO TO 2600
C
C  CARRY, NO OBJECT GIVEN YET.  OK IF ONLY ONE OBJECT PRESENT.
C
 8010 IF(ATLOC(LOC).EQ.0.OR.LINK(ATLOC(LOC)).NE.0)GO TO 8000
      DO 8012 I=1,5
         IF(DLOC(I).EQ.LOC.AND.DFLAG.GE.2)GO TO 8000
 8012 CONTINUE
      OBJ=ATLOC(LOC)
C
C  CARRY AN OBJECT.  SPECIAL CASES FOR BIRD AND CAGE (IF BIRD IN CAGE, C
C  TAKE ONE WITHOUT THE OTHER.  LIQUIDS ALSO SPECIAL, SINCE THEY DEPEND
C  STATUS OF BOTTLE.  ALSO VARIOUS SIDE EFFECTS, ETC.
C
 9010 IF(TOTING(OBJ))GO TO 2011
      SPK=25
      IF(OBJ.EQ.PLANT.AND.PROP(PLANT).LE.0)SPK=115
      IF(OBJ.EQ.BEAR.AND.PROP(BEAR).EQ.1)SPK=169
      IF(OBJ.EQ.CHAIN.AND.PROP(BEAR).NE.0)SPK=170
      IF(FIXED(OBJ).NE.0)GO TO 2011
      IF(OBJ.NE.WATER.AND.OBJ.NE.OIL)GO TO 9017
      IF(HERE(BOTTLE).AND.LIQ(0).EQ.OBJ)GO TO 9018
      OBJ=BOTTLE
      IF(TOTING(BOTTLE).AND.PROP(BOTTLE).EQ.1)GO TO 9220
      IF(PROP(BOTTLE).NE.1)SPK=105
      IF(.NOT.TOTING(BOTTLE))SPK=104
      GO TO 2011
 9018 OBJ=BOTTLE
 9017 IF(HOLDNG.LT.7)GO TO 9016
      CALL RSPEAK(92)
      GO TO 2012
 9016 IF(OBJ.NE.BIRD)GO TO 9014
      IF(PROP(BIRD).NE.0)GO TO 9014
      IF(.NOT.TOTING(ROD))GO TO 9013
      CALL RSPEAK(26)
      GO TO 2012
 9013 IF(TOTING(CAGE))GO TO 9015
      CALL RSPEAK(27)
      GO TO 2012
 9015 PROP(BIRD)=1
 9014 IF((OBJ.EQ.BIRD.OR.OBJ.EQ.CAGE).AND.PROP(BIRD).NE.0)
     1CALL CARRY(BIRD+CAGE-OBJ,LOC)
      CALL CARRY(OBJ,LOC)
      K=LIQ(0)
      IF(OBJ.EQ.BOTTLE.AND.K.NE.0)PLACE(K)=-1
      GO TO 2009
C
C  DISCARD OBJECT.  "THROW" ALSO COMES HERE FOR MOST OBJECTS.  SPECIAL C
C  BIRD (MIGHT ATTACK SNAKE OR DRAGON) AND CAGE (MIGHT CONTAIN BIRD) AND
C  DROP COINS AT VENDING MACHINE FOR EXTRA BATTERIES.
C
 9020 IF(TOTING(ROD2).AND.OBJ.EQ.ROD.AND..NOT.TOTING(ROD))OBJ=ROD2
      IF(.NOT.TOTING(OBJ))GO TO 2011
      IF(OBJ.NE.BIRD.OR..NOT.HERE(SNAKE))GO TO 9024
      CALL RSPEAK(30)
      IF(CLOSED)GO TO 19000
      CALL MOVE(SNAKE,0)
C  SET PROP FOR USE BY TRAVEL OPTIONS
      PROP(SNAKE)=1
 9021 K=LIQ(0)
      IF(K.EQ.OBJ)OBJ=BOTTLE
      IF(OBJ.EQ.BOTTLE.AND.K.NE.0)PLACE(K)=0
      IF(OBJ.EQ.CAGE.AND.PROP(BIRD).NE.0)CALL DROP(BIRD,LOC)
      IF(OBJ.EQ.BIRD)PROP(BIRD)=0
      CALL DROP(OBJ,LOC)
      GO TO 2012
C
 9024 IF(OBJ.NE.COINS.OR..NOT.HERE(VEND))GO TO 9025
      CALL MOVE(COINS,0)
      CALL DROP(BATTER,LOC)
      CALL PSPEAK(BATTER,0)
      GO TO 2012
C
 9025 IF(OBJ.NE.BIRD.OR..NOT.AT(DRAGON).OR.PROP(DRAGON).NE.0)GO TO 9026
      CALL RSPEAK(154)
      CALL MOVE(BIRD,0)
      PROP(BIRD)=0
      IF(PLACE(SNAKE).EQ.PLAC(SNAKE))TALLY2=TALLY2+1
      GO TO 2012
C
 9026 IF(OBJ.NE.BEAR.OR..NOT.AT(TROLL))GO TO 9027
      CALL RSPEAK(163)
      CALL MOVE(TROLL,0)
      CALL MOVE(TROLL+100,0)
      CALL MOVE(TROLL2,PLAC(TROLL))
      CALL MOVE(TROLL2+100,FIXD(TROLL))
      CALL JUGGLE(CHASM)
      PROP(TROLL)=2
      GO TO 9021
C
 9027 IF(OBJ.EQ.VASE.AND.LOC.NE.PLAC(PILLOW))GO TO 9028
      CALL RSPEAK(54)
      GO TO 9021
C
 9028 PROP(VASE)=2
      IF(AT(PILLOW))PROP(VASE)=0
      CALL PSPEAK(VASE,PROP(VASE)+1)
      IF(PROP(VASE).NE.0)FIXED(VASE)=-1
      GO TO 9021
C
C  SAY.  ECHO WD2 (OR WD1 IF NO WD2 (SAY WHAT?, ETC.).)  MAGIC WORDS OVE
C
 9030 CALL A5TOA1(WD2,WD2X,CODE1('".       '),.FALSE.,TK,K)
      IF(WD2.EQ.0)CALL A5TOA1(WD1,WD1X,CODE1('".       '),.FALSE.,TK,K)
      IF(WD2.NE.0)WD1=WD2
      I=VOCAB(WD1,-1)
      IF(I.EQ.62.OR.I.EQ.65.OR.I.EQ.71.OR.I.EQ.2025)GO TO 9035
      WRITE(TTYO,9032)(TK(I),I=1,K)
 9032 FORMAT(/,' OKAY, "',20A1)
      GO TO 2012
C
 9035 WD2=0
      OBJ=0
      GO TO 2630
C
C  LOCK, UNLOCK, NO OBJECT GIVEN.  ASSUME VARIOUS THINGS IF PRESENT.
C
 8040 SPK=28
      IF(HERE(CLAM))OBJ=CLAM
      IF(HERE(OYSTER))OBJ=OYSTER
      IF(AT(DOOR))OBJ=DOOR
      IF(AT(GRATE))OBJ=GRATE
      IF(OBJ.NE.0.AND.HERE(CHAIN))GO TO 8000
      IF(HERE(CHAIN))OBJ=CHAIN
      IF(OBJ.EQ.0)GO TO 2011
C
C  LOCK, UNLOCK OBJECT.  SPECIAL STUFF FOR OPENING CLAM/OYSTER AND FOR C
C
 9040 IF(OBJ.EQ.CLAM.OR.OBJ.EQ.OYSTER)GO TO 9046
      IF(OBJ.EQ.DOOR)SPK=111
      IF(OBJ.EQ.DOOR.AND.PROP(DOOR).EQ.1)SPK=54
      IF(OBJ.EQ.CAGE)SPK=32
      IF(OBJ.EQ.KEYS)SPK=55
      IF(OBJ.EQ.GRATE.OR.OBJ.EQ.CHAIN)SPK=31
      IF(SPK.NE.31.OR..NOT.HERE(KEYS))GO TO 2011
      IF(OBJ.EQ.CHAIN)GO TO 9048
      IF(.NOT.CLOSNG)GO TO 9043
      K=130
      IF(.NOT.PANIC)CLOCK2=15
      PANIC=.TRUE.
      GO TO 2010
C
 9043 K=34+PROP(GRATE)
      PROP(GRATE)=1
      IF(VERB.EQ.LOCK)PROP(GRATE)=0
      K=K+2*PROP(GRATE)
      GO TO 2010
C
C  CLAM/OYSTER.
 9046 K=0
      IF(OBJ.EQ.OYSTER)K=1
      SPK=124+K
      IF(TOTING(OBJ))SPK=120+K
      IF(.NOT.TOTING(TRIDNT))SPK=122+K
      IF(VERB.EQ.LOCK)SPK=61
      IF(SPK.NE.124)GO TO 2011
      CALL MOVE(CLAM,0)
      CALL DROP(OYSTER,LOC)
      CALL DROP(PEARL,105)
      GO TO 2011
C
C  CHAIN.
 9048 IF(VERB.EQ.LOCK)GO TO 9049
      SPK=171
      IF(PROP(BEAR).EQ.0)SPK=41
      IF(PROP(CHAIN).EQ.0)SPK=37
      IF(SPK.NE.171)GO TO 2011
      PROP(CHAIN)=0
      FIXED(CHAIN)=0
      IF(PROP(BEAR).NE.3)PROP(BEAR)=2
      FIXED(BEAR)=2-PROP(BEAR)
      GO TO 2011
C
 9049 SPK=172
      IF(PROP(CHAIN).NE.0)SPK=34
      IF(LOC.NE.PLAC(CHAIN))SPK=173
      IF(SPK.NE.172)GO TO 2011
      PROP(CHAIN)=2
      IF(TOTING(CHAIN))CALL DROP(CHAIN,LOC)
      FIXED(CHAIN)=-1
      GO TO 2011
C
C  LIGHT LAMP
C
 9070 IF(.NOT.HERE(LAMP))GO TO 2011
      SPK=184
      IF(LIMIT.LT.0)GO TO 2011
      PROP(LAMP)=1
      CALL RSPEAK(39)
      IF(WZDARK)GO TO 2000
      GO TO 2012
C
C  LAMP OFF
C
 9080 IF(.NOT.HERE(LAMP))GO TO 2011
      PROP(LAMP)=0
      CALL RSPEAK(40)
      IF(DARK(0))CALL RSPEAK(16)
      GO TO 2012
C
C  WAVE.  NO EFFECT UNLESS WAVING ROD AT FISSURE.
C
 9090 IF((.NOT.TOTING(OBJ)).AND.(OBJ.NE.ROD.OR..NOT.TOTING(ROD2)))
     1SPK=29
      IF(OBJ.NE.ROD.OR..NOT.AT(FISSUR).OR..NOT.TOTING(OBJ)
     1.OR.CLOSNG)GO TO 2011
      PROP(FISSUR)=1-PROP(FISSUR)
      CALL PSPEAK(FISSUR,2-PROP(FISSUR))
      GO TO 2012
C
C  ATTACK.  ASSUME TARGET IF UNAMBIGUOUS.  "THROW" ALSO LINKS HERE.  ATT
C  OBJECTS FALL INTO TWO CATEGORIES: ENEMIES (SNAKE, DWARF, ETC.)  AND O
C  (BIRD, CLAM).  AMBIGUOUS IF TWO ENEMIES, OR IF NO ENEMIES BUT TWO OTH
C
 9120 DO 9121 I=1,5
         IF(DLOC(I).EQ.LOC.AND.DFLAG.GE.2)GO TO 9122
 9121 CONTINUE
      I=0
 9122 IF(OBJ.NE.0)GO TO 9124
      IF(I.NE.0)OBJ=DWARF
      IF(HERE(SNAKE))OBJ=OBJ*100+SNAKE
      IF(AT(DRAGON).AND.PROP(DRAGON).EQ.0)OBJ=OBJ*100+DRAGON
      IF(AT(TROLL))OBJ=OBJ*100+TROLL
      IF(HERE(BEAR).AND.PROP(BEAR).EQ.0)OBJ=OBJ*100+BEAR
      IF(OBJ.GT.100)GO TO 8000
      IF(OBJ.NE.0)GO TO 9124
C  CAN'T ATTACK BIRD BY THROWING AXE.
      IF(HERE(BIRD).AND.VERB.NE.THROW)OBJ=BIRD
C  CLAM AND OYSTER BOTH TREATED AS CLAM FOR INTRANSITIVE CASE; NO HARM D
      IF(HERE(CLAM).OR.HERE(OYSTER))OBJ=100*OBJ+CLAM
      IF(OBJ.GT.100)GO TO 8000
 9124 IF(OBJ.NE.BIRD)GO TO 9125
      SPK=137
      IF(CLOSED)GO TO 2011
      CALL MOVE(BIRD,0)
      PROP(BIRD)=0
      IF(PLACE(SNAKE).EQ.PLAC(SNAKE))TALLY2=TALLY2+1
      SPK=45
 9125 IF(OBJ.EQ.0)SPK=44
      IF(OBJ.EQ.CLAM.OR.OBJ.EQ.OYSTER)SPK=150
      IF(OBJ.EQ.SNAKE)SPK=46
      IF(OBJ.EQ.DWARF)SPK=49
      IF(OBJ.EQ.DWARF.AND.CLOSED)GO TO 19000
      IF(OBJ.EQ.DRAGON)SPK=167
      IF(OBJ.EQ.TROLL)SPK=157
      IF(OBJ.EQ.BEAR)SPK=165+(PROP(BEAR)+1)/2
      IF(OBJ.NE.DRAGON.OR.PROP(DRAGON).NE.0)GO TO 2011
C  FUN STUFF FOR DRAGON.  IF HE INSISTS ON ATTACKING IT, WIN!  SET PROP
C  MOVE DRAGON TO CENTRAL LOC (STILL FIXED), MOVE RUG THERE (NOT FIXED),
C  MOVE HIM THERE, TOO.  THEN DO A NULL MOTION TO GET NEW DESCRIPTION.
      CALL RSPEAK(49)
      VERB=0
      OBJ=0
      CALL GETIN(WD1,WD1X,WD2,WD2X,.FALSE.)
      IF(WD1.NE.CODE1('Y        ').AND.WD1.NE.CODE1('YES      '))
     *GO TO 2608
      CALL PSPEAK(DRAGON,1)
      PROP(DRAGON)=2
      PROP(RUG)=0
      K=(PLAC(DRAGON)+FIXD(DRAGON))/2
      CALL MOVE(DRAGON+100,-1)
      CALL MOVE(RUG+100,0)
      CALL MOVE(DRAGON,K)
      CALL MOVE(RUG,K)
      DO 9126 OBJ=1,100
         IF(PLACE(OBJ).EQ.PLAC(DRAGON).OR.PLACE(OBJ).EQ.FIXD(DRAGON))
     1   CALL MOVE(OBJ,K)
 9126 CONTINUE
      LOC=K
      K=NULL
      GO TO 8
C
C  POUR.  IF NO OBJECT, OR OBJECT IS BOTTLE, ASSUME CONTENTS OF BOTTLE.
C  SPECIAL TESTS FOR POURING WATER OR OIL ON PLANT OR RUSTY DOOR.
C
 9130 IF(OBJ.EQ.BOTTLE.OR.OBJ.EQ.0)OBJ=LIQ(0)
      IF(OBJ.EQ.0)GO TO 8000
      IF(.NOT.TOTING(OBJ))GO TO 2011
      SPK=78
      IF(OBJ.NE.OIL.AND.OBJ.NE.WATER)GO TO 2011
      PROP(BOTTLE)=1
      PLACE(OBJ)=0
      SPK=77
      IF(.NOT.(AT(PLANT).OR.AT(DOOR)))GO TO 2011
C
      IF(AT(DOOR))GO TO 9132
      SPK=112
      IF(OBJ.NE.WATER)GO TO 2011
      CALL PSPEAK(PLANT,PROP(PLANT)+1)
      PROP(PLANT)=MOD(PROP(PLANT)+2,6)
      PROP(PLANT2)=PROP(PLANT)/2
      K=NULL
      GO TO 8
C
 9132 PROP(DOOR)=0
      IF(OBJ.EQ.OIL)PROP(DOOR)=1
      SPK=113+PROP(DOOR)
      GO TO 2011
C
C  EAT.  INTRANSITIVE: ASSUME FOOD IF PRESENT, ELSE ASK WHAT.  TRANSITIV
C  OK, SOME THINGS LOSE APPETITE, REST ARE RIDICULOUS.
C
 8140 IF(.NOT.HERE(FOOD))GO TO 8000
 8142 CALL MOVE(FOOD,0)
      SPK=72
      GO TO 2011
C
 9140 IF(OBJ.EQ.FOOD)GO TO 8142
      IF(OBJ.EQ.BIRD.OR.OBJ.EQ.SNAKE.OR.OBJ.EQ.CLAM.OR.OBJ.EQ.OYSTER
     1.OR.OBJ.EQ.DWARF.OR.OBJ.EQ.DRAGON.OR.OBJ.EQ.TROLL
     2.OR.OBJ.EQ.BEAR)SPK=71
      GO TO 2011
C
C  DRINK.  IF NO OBJECT, ASSUME WATER AND LOOK FOR IT HERE.  IF WATER IS
C  THE BOTTLE, DRINK THAT, ELSE MUST BE AT A WATER LOC, SO DRINK STREAM.
C
 9150 IF(OBJ.EQ.0.AND.LIQLOC(LOC).NE.WATER.AND.(LIQ(0).NE.WATER
     1.OR..NOT.HERE(BOTTLE)))GO TO 8000
      IF(OBJ.NE.0.AND.OBJ.NE.WATER)SPK=110
      IF(SPK.EQ.110.OR.LIQ(0).NE.WATER.OR..NOT.HERE(BOTTLE))GO TO 2011
      PROP(BOTTLE)=1
      PLACE(WATER)=0
      SPK=74
      GO TO 2011
C
C  RUB.  YIELDS VARIOUS SNIDE REMARKS.
C
 9160 IF(OBJ.NE.LAMP)SPK=76
      GO TO 2011
C
C  THROW.  SAME AS DISCARD UNLESS AXE.  THEN SAME AS ATTACK EXCEPT IGNOR
C  AND IF DWARF IS PRESENT THEN ONE MIGHT BE KILLED.  (ONLY WAY TO DO SO
C  AXE ALSO SPECIAL FOR DRAGON, BEAR, AND TROLL.  TREASURES SPECIAL FOR
C
 9170 IF(TOTING(ROD2).AND.OBJ.EQ.ROD.AND..NOT.TOTING(ROD))OBJ=ROD2
      IF(.NOT.TOTING(OBJ))GO TO 2011
      IF(OBJ.GE.50.AND.OBJ.LE.MAXTRS.AND.AT(TROLL))GO TO 9178
      IF(OBJ.EQ.FOOD.AND.HERE(BEAR))GO TO 9177
      IF(OBJ.NE.AXE)GO TO 9020
      DO 9171 I=1,5
C  NEEDN'T CHECK DFLAG IF AXE IS HERE.
         IF(DLOC(I).EQ.LOC)GO TO 9172
 9171 CONTINUE
      SPK=152
      IF(AT(DRAGON).AND.PROP(DRAGON).EQ.0)GO TO 9175
      SPK=158
      IF(AT(TROLL))GO TO 9175
      IF(HERE(BEAR).AND.PROP(BEAR).EQ.0)GO TO 9176
      OBJ=0
      GO TO 9120
C
 9172 SPK=48
C  IF SAVED NOT = -1, HE BYPASSED THE "START" CALL.
      IF(RAN(3).EQ.0.OR.SAVED.NE.-1)GO TO 9175
      DSEEN(I)=.FALSE.
      DLOC(I)=0
      SPK=47
      DKILL=DKILL+1
      IF(DKILL.EQ.1)SPK=149
 9175 CALL RSPEAK(SPK)
      CALL DROP(AXE,LOC)
      K=NULL
      GO TO 8
C
C  THIS'LL TEACH HIM TO THROW THE AXE AT THE BEAR!
 9176 SPK=164
      CALL DROP(AXE,LOC)
      FIXED(AXE)=-1
      PROP(AXE)=1
      CALL JUGGLE(BEAR)
      GO TO 2011
C
C  BUT THROWING FOOD IS ANOTHER STORY.
 9177 OBJ=BEAR
      GO TO 9210
C
 9178 SPK=159
C  SNARF A TREASURE FOR THE TROLL.
      CALL DROP(OBJ,0)
      CALL MOVE(TROLL,0)
      CALL MOVE(TROLL+100,0)
      CALL DROP(TROLL2,PLAC(TROLL))
      CALL DROP(TROLL2+100,FIXD(TROLL))
      CALL JUGGLE(CHASM)
      GO TO 2011
C
C  QUIT.  INTRANSITIVE ONLY.  VERIFY INTENT AND EXIT IF THAT'S WHAT HE W
C
 8180 GAVEUP=YESX(22,54,54,1)
 8185 IF(GAVEUP)GO TO 20000
      GO TO 2012
C
C  FIND.  MIGHT BE CARRYING IT, OR IT MIGHT BE HERE.  ELSE GIVE CAVEAT.
C
 9190 IF(AT(OBJ).OR.(LIQ(0).EQ.OBJ.AND.AT(BOTTLE))
     1.OR.K.EQ.LIQLOC(LOC))SPK=94
      DO 9192 I=1,5
 9192 IF(DLOC(I).EQ.LOC.AND.DFLAG.GE.2.AND.OBJ.EQ.DWARF)SPK=94
      IF(CLOSED)SPK=138
      IF(TOTING(OBJ))SPK=24
      GO TO 2011
C
C  INVENTORY.  IF OBJECT, TREAT SAME AS FIND.  ELSE REPORT ON CURRENT BU
C
 8200 SPK=98
      DO 8201 I=1,100
         IF(I.EQ.BEAR.OR..NOT.TOTING(I))GO TO 8201
         IF(SPK.EQ.98)CALL RSPEAK(99)
         BLKLIN=.FALSE.
         CALL PSPEAK(I,-1)
         BLKLIN=.TRUE.
         SPK=0
 8201 CONTINUE
      IF(TOTING(BEAR))SPK=141
      GO TO 2011
C
C  FEED.  IF BIRD, NO SEED.  SNAKE, DRAGON, TROLL: QUIP.  IF DWARF, MAKE
C  MAD.  BEAR, SPECIAL.
C
 9210 IF(OBJ.NE.BIRD)GO TO 9212
      SPK=100
      GO TO 2011
C
 9212 IF(OBJ.NE.SNAKE.AND.OBJ.NE.DRAGON.AND.OBJ.NE.TROLL)GO TO 9213
      SPK=102
      IF(OBJ.EQ.DRAGON.AND.PROP(DRAGON).NE.0)SPK=110
      IF(OBJ.EQ.TROLL)SPK=182
      IF(OBJ.NE.SNAKE.OR.CLOSED.OR..NOT.HERE(BIRD))GO TO 2011
      SPK=101
      CALL MOVE(BIRD,0)
      PROP(BIRD)=0
      TALLY2=TALLY2+1
      GO TO 2011
C
 9213 IF(OBJ.NE.DWARF)GO TO 9214
      IF(.NOT.HERE(FOOD))GO TO 2011
      SPK=103
      DFLAG=DFLAG+1
      GO TO 2011
C
 9214 IF(OBJ.NE.BEAR)GO TO 9215
      IF(PROP(BEAR).EQ.0)SPK=102
      IF(PROP(BEAR).EQ.3)SPK=110
      IF(.NOT.HERE(FOOD))GO TO 2011
      CALL MOVE(FOOD,0)
      PROP(BEAR)=1
      FIXED(AXE)=0
      PROP(AXE)=0
      SPK=168
      GO TO 2011
C
 9215 SPK=14
      GO TO 2011
C
C  FILL.  BOTTLE MUST BE EMPTY, AND SOME LIQUID AVAILABLE.  (VASE IS NAS
C
 9220 IF(OBJ.EQ.VASE)GO TO 9222
      IF(OBJ.NE.0.AND.OBJ.NE.BOTTLE)GO TO 2011
      IF(OBJ.EQ.0.AND..NOT.HERE(BOTTLE))GO TO 8000
      SPK=107
      IF(LIQLOC(LOC).EQ.0)SPK=106
      IF(LIQ(0).NE.0)SPK=105
      IF(SPK.NE.107)GO TO 2011
      PROP(BOTTLE)=MOD(COND(LOC),4)/2*2
      K=LIQ(0)
      IF(TOTING(BOTTLE))PLACE(K)=-1
      IF(K.EQ.OIL)SPK=108
      GO TO 2011
C
 9222 SPK=29
      IF(LIQLOC(LOC).EQ.0)SPK=144
      IF(LIQLOC(LOC).EQ.0.OR..NOT.TOTING(VASE))GO TO 2011
      CALL RSPEAK(145)
      PROP(VASE)=2
      FIXED(VASE)=-1
      GO TO 9024
C
C  BLAST.  NO EFFECT UNLESS YOU'VE GOT DYNAMITE, WHICH IS A NEAT TRICK!
C
 9230 IF(PROP(ROD2).LT.0.OR..NOT.CLOSED)GO TO 2011
      BONUS=133
      IF(LOC.EQ.115)BONUS=134
      IF(HERE(ROD2))BONUS=135
      CALL RSPEAK(BONUS)
      GO TO 20000
C
C  SCORE.  GO TO SCORING SECTION, WHICH WILL RETURN TO 8241 IF SCORNG IS
C
 8240 SCORNG=.TRUE.
      GO TO 20000
C
 8241 SCORNG=.FALSE.
      WRITE(TTYO,8243)SCORE,MXSCOR
 8243 FORMAT(/,' IF YOU WERE TO QUIT NOW, YOU WOULD SCORE',I4
     1,' OUT OF A POSSIBLE',I4,'.')
C     GAVEUP=YESX(143,54,54,1)
      GAVEUP=.FALSE.
      GO TO 8185
C
C  FEE FIE FOE FOO (AND FUM).  ADVANCE TO NEXT STATE IF GIVEN IN PROPER
C  LOOK UP WD1 IN SECTION 3 OF VOCAB TO DETERMINE WHICH WORD WE'VE GOT.
C  WORD ZIPS THE EGGS BACK TO THE GIANT ROOM (UNLESS ALREADY THERE).
C
 8250 K=VOCAB(WD1,3)
      SPK=42
      IF(FOOBAR.EQ.1-K)GO TO 8252
      IF(FOOBAR.NE.0)SPK=151
      GO TO 2011
C
 8252 FOOBAR=K
      IF(K.NE.4)GO TO 2009
      FOOBAR=0
      IF(PLACE(EGGS).EQ.PLAC(EGGS)
     1.OR.(TOTING(EGGS).AND.LOC.EQ.PLAC(EGGS)))GO TO 2011
C  BRING BACK TROLL IF WE STEAL THE EGGS BACK FROM HIM BEFORE CROSSING.
      IF(PLACE(EGGS).EQ.0.AND.PLACE(TROLL).EQ.0.AND.PROP(TROLL).EQ.0)
     1PROP(TROLL)=1
      K=2
      IF(HERE(EGGS))K=1
      IF(LOC.EQ.PLAC(EGGS))K=0
      CALL MOVE(EGGS,PLAC(EGGS))
      CALL PSPEAK(EGGS,K)
      GO TO 2012
C
C  BRIEF.  INTRANSITIVE ONLY.  SUPPRESS LONG DESCRIPTIONS AFTER FIRST TI
C
 8260 SPK=156
      ABBNUM=10000
      DETAIL=3
      GO TO 2011
C
C  READ.  MAGAZINES IN DWARVISH, MESSAGE WE'VE SEEN, AND . . . OYSTER?
C
 8270 IF(HERE(MAGZIN))OBJ=MAGZIN
      IF(HERE(TABLET))OBJ=OBJ*100+TABLET
      IF(HERE(MESSAG))OBJ=OBJ*100+MESSAG
      IF(CLOSED.AND.TOTING(OYSTER))OBJ=OYSTER
      IF(OBJ.GT.100.OR.OBJ.EQ.0.OR.DARK(0))GO TO 8000
C
 9270 IF(DARK(0))GO TO 5190
      IF(OBJ.EQ.MAGZIN)SPK=190
      IF(OBJ.EQ.TABLET)SPK=196
      IF(OBJ.EQ.MESSAG)SPK=191
      IF(OBJ.EQ.OYSTER.AND.HINTED(2).AND.TOTING(OYSTER))SPK=194
      IF(OBJ.NE.OYSTER.OR.HINTED(2).OR..NOT.TOTING(OYSTER)
     1.OR..NOT.CLOSED)GO TO 2011
      HINTED(2)=YESX(192,193,54,1)
      GO TO 2012
C
C  BREAK.  ONLY WORKS FOR MIRROR IN REPOSITORY AND, OF COURSE, THE VASE.
C
 9280 IF(OBJ.EQ.MIRROR)SPK=148
      IF(OBJ.EQ.VASE.AND.PROP(VASE).EQ.0)GO TO 9282
      IF(OBJ.NE.MIRROR.OR..NOT.CLOSED)GO TO 2011
      CALL RSPEAK(197)
      GO TO 19000
C
 9282 SPK=198
      IF(TOTING(VASE))CALL DROP(VASE,LOC)
      PROP(VASE)=2
      FIXED(VASE)=-1
      GO TO 2011
C
C  WAKE.  ONLY USE IS TO DISTURB THE DWARVES.
C
 9290 IF(OBJ.NE.DWARF.OR..NOT.CLOSED)GO TO 2011
      CALL RSPEAK(199)
      GO TO 19000
C
C  SUSPEND.  OFFER TO EXIT LEAVING THINGS RESTARTABLE, BUT REQUIRING A D
C  BEFORE RESTARTING (SO CAN'T SAVE THE WORLD BEFORE TRYING SOMETHING RI
C  UPON RESTARTING, SETUP=-1 CAUSES RETURN TO 8305 TO PICK UP AGAIN.
C
 8300 SPK=201
      IF(DEMO)GO TO 2011
      IF (WD2 .EQ. CODE1('         ')) THEN
         WRITE (TTYO,8303)
8303     FORMAT (/' YOU MUST SPECIFY A FILE NAME WITH YOUR COMMAND')
         GO TO 2012
      END IF
      WRITE(TTYO,8302)LATNCY
 8302 FORMAT(/,' I CAN SUSPEND YOUR ADVENTURE FOR YOU SO THAT YOU CAN',
     1' RESUME LATER, BUT',/,' YOU WILL HAVE TO WAIT AT LEAST ',
     2I3,' MINUTES BEFORE CONTINUING.')
      IF(.NOT.YESX(200,54,54,1))GO TO 2012
      CALL DATIME(SAVED,SAVET)
      SETUP=-1
      R=0
      CALL DCODE1(WD2,FNAME(1))
      CALL DCODE1(WD2X,FNAME(6))
      CALL SVCOMN(.FALSE.,FNAME,CMADRS,CMSZES)
      STOP
C
 8305 YEA=START(0)
      SETUP=3
      K=NULL
      GO TO 8
C
C
C  HOURS.  REPORT CURRENT NON-PRIME-TIME HOURS.
C
 8310 CALL MSPEAK(6)
      CALL HOURS
      GO TO 2012
C
C
C  RESTORE.  ATTEMPT TO RESTORE THE GAME WHOSE NAME IS SUPPLIED BY THE
C  USER.  IF THE RESTORE DOES NOT WORK, THE USER WILL BE LEFT IN A FRESH
C  GAME.
C
 8400 CALL DCODE1(WD2,FNAME(1))
      CALL DCODE1(WD2X,FNAME(6))
      CALL LDCOMN(.FALSE.,FNAME,CMADRS,CMSZES)
      GO TO 8500
C
C  HINTS
C
C  COME HERE IF HE'S BEEN LONG ENOUGH AT REQUIRED LOC(S) FOR SOME UNUSED
C  HINT NUMBER IS IN VARIABLE "HINT".  BRANCH TO QUICK TEST FOR ADDITION
C  CONDITIONS, THEN COME BACK TO DO NEAT STUFF.  GOTO 40010 IF CONDITION
C  MET AND WE WANT TO OFFER THE HINT.  GOTO 40020 TO CLEAR HINTLC BACK T
C  40030 TO TAKE NO ACTION YET.
C
40000 HINTM3=HINT-3
      IF((HINTM3.LT.1).OR.(HINTM3.GT.6)) CALL BUG(27)
      GO TO (40400,40500,40600,40700,40800,40900),HINTM3
C           CAVE  BIRD  SNAKE MAZE  DARK  WITT
C
40010 HINTLC(HINT)=0
      IF(.NOT.YESX(HINTS(HINT,3),0,54,1))GO TO 2602
      WRITE(TTYO,40012)HINTS(HINT,2)
40012 FORMAT(/,' I AM PREPARED TO GIVE YOU A HINT, BUT IT WILL COST YOU'
     1,I2,' POINTS.')
      HINTED(HINT)=YESX(175,HINTS(HINT,4),54,1)
      IF(HINTED(HINT).AND.LIMIT.GT.30)LIMIT=LIMIT+30*HINTS(HINT,2)
40020 HINTLC(HINT)=0
40030 GO TO 2602
C
C  NOW FOR THE QUICK TESTS.  SEE DATABASE DESCRIPTION FOR ONE-LINE NOTES
C
40400 IF(PROP(GRATE).EQ.0.AND..NOT.HERE(KEYS))GO TO 40010
      GO TO 40020
C
40500 IF(HERE(BIRD).AND.TOTING(ROD).AND.OBJ.EQ.BIRD)GO TO 40010
      GO TO 40030
C
40600 IF(HERE(SNAKE).AND..NOT.HERE(BIRD))GO TO 40010
      GO TO 40020
C
40700 IF(ATLOC(LOC).EQ.0.AND.ATLOC(OLDLOC).EQ.0
     1.AND.ATLOC(OLDLC2).EQ.0.AND.HOLDNG.GT.1)GO TO 40010
      GO TO 40020
C
40800 IF(PROP(EMRALD).NE.-1.AND.PROP(PYRAM).EQ.-1)GO TO 40010
      GO TO 40020
C
40900 GO TO 40010
C
C  CAVE CLOSING AND SCORING
C
C
C  THESE SECTIONS HANDLE THE CLOSING OF THE CAVE.  THE CAVE CLOSES "CLOC
C  TURNS AFTER THE LAST TREASURE HAS BEEN LOCATED (INCLUDING THE PIRATE'
C  CHEST, WHICH MAY OF COURSE NEVER SHOW UP).  NOTE THAT THE TREASURES N
C  HAVE BEEN TAKEN YET, JUST LOCATED.  HENCE CLOCK1 MUST BE LARGE ENOUGH
C  OUT OF THE CAVE (IT ONLY TICKS WHILE INSIDE THE CAVE).  WHEN IT HITS
C  WE BRANCH TO 10000 TO START CLOSING THE CAVE, AND THEN SIT BACK AND W
C  HIM TO TRY TO GET OUT.  IF HE DOESN'T WITHIN CLOCK2 TURNS, WE CLOSE T
C  CAVE; IF HE DOES TRY, WE ASSUME HE PANICS, AND GIVE HIM A FEW ADDITIO
C  TURNS TO GET FRANTIC BEFORE WE CLOSE.  WHEN CLOCK2 HITS ZERO, WE BRAN
C  11000 TO TRANSPORT HIM INTO THE FINAL PUZZLE.  NOTE THAT THE PUZZLE D
C  UPON ALL SORTS OF RANDOM THINGS.  FOR INSTANCE, THERE MUST BE NO WATE
C  OIL, SINCE THERE ARE BEANSTALKS WHICH WE DON'T WANT TO BE ABLE TO WAT
C  SINCE THE CODE CAN'T HANDLE IT.  ALSO, WE CAN HAVE NO KEYS, SINCE THE
C  GRATE (HAVING MOVED THE FIXED OBJECT!) THERE SEPARATING HIM FROM ALL
C  TREASURES.  MOST OF THESE PROBLEMS ARISE FROM THE USE OF NEGATIVE PRO
C  NUMBERS TO SUPPRESS THE OBJECT DESCRIPTIONS UNTIL HE'S ACTUALLY MOVED
C  OBJECTS.
C
C  WHEN THE FIRST WARNING COMES, WE LOCK THE GRATE, DESTROY THE BRIDGE,
C  ALL THE DWARVES (AND THE PIRATE), REMOVE THE TROLL AND BEAR (UNLESS D
C  AND SET "CLOSNG" TO TRUE.  LEAVE THE DRAGON; TOO MUCH TROUBLE TO MOVE
C  FROM NOW UNTIL CLOCK2 RUNS OUT, HE CANNOT UNLOCK THE GRATE, MOVE TO A
C  LOCATION OUTSIDE THE CAVE (LOC<9), OR CREATE THE BRIDGE.  NOR CAN HE
C  RESURRECTED IF HE DIES.  NOTE THAT THE SNAKE IS ALREADY GONE, SINCE H
C  TO THE TREASURE ACCESSIBLE ONLY VIA THE HALL OF THE MT. KING.  ALSO,
C  BEEN IN GIANT ROOM (TO GET EGGS), SO WE CAN REFER TO IT.  ALSO ALSO,
C  GOTTEN THE PEARL, SO WE KNOW THE BIVALVE IS AN OYSTER.  *AND*, THE DW
C  MUST HAVE BEEN ACTIVATED, SINCE WE'VE FOUND CHEST.
C
10000 PROP(GRATE)=0
      PROP(FISSUR)=0
      DO 10010 I=1,6
         DSEEN(I)=.FALSE.
10010 DLOC(I)=0
      CALL MOVE(TROLL,0)
      CALL MOVE(TROLL+100,0)
      CALL MOVE(TROLL2,PLAC(TROLL))
      CALL MOVE(TROLL2+100,FIXD(TROLL))
      CALL JUGGLE(CHASM)
      IF(PROP(BEAR).NE.3)CALL MOVE(BEAR,0)
      PROP(CHAIN)=0
      FIXED(CHAIN)=0
      PROP(AXE)=0
      FIXED(AXE)=0
      CALL RSPEAK(129)
      CLOCK1=-1
      CLOSNG=.TRUE.
      GO TO 19999
C
C  ONCE HE'S PANICKED, AND CLOCK2 HAS RUN OUT, WE COME HERE TO SET UP TH
C  STORAGE ROOM.  THE ROOM HAS TWO LOCS, HARDWIRED AS 115 (NE) AND 116 (
C  AT THE NE END, WE PLACE EMPTY BOTTLES, A NURSERY OF PLANTS, A BED OF
C  OYSTERS, A PILE OF LAMPS, RODS WITH STARS, SLEEPING DWARVES, AND HIM.
C  THE SW END WE PLACE GRATE OVER TREASURES, SNAKE PIT, COVEY OF CAGED B
C  MORE RODS, AND PILLOWS.  A MIRROR STRETCHES ACROSS ONE WALL.  MANY OF
C  OBJECTS COME FROM KNOWN LOCATIONS AND/OR STATES (E.G. THE SNAKE IS KN
C  HAVE BEEN DESTROYED AND NEEDN'T BE CARRIED AWAY FROM ITS OLD "PLACE")
C  MAKING THE VARIOUS OBJECTS BE HANDLED DIFFERENTLY.  WE ALSO DROP ALL
C  OBJECTS HE MIGHT BE CARRYING (LEST HE HAVE SOME WHICH COULD CAUSE TRO
C  SUCH AS THE KEYS).  WE DESCRIBE THE FLASH OF LIGHT AND TRUNDLE BACK.
C
11000 PROP(BOTTLE)=PUT(BOTTLE,115,1)
      PROP(PLANT)=PUT(PLANT,115,0)
      PROP(OYSTER)=PUT(OYSTER,115,0)
      PROP(LAMP)=PUT(LAMP,115,0)
      PROP(ROD)=PUT(ROD,115,0)
      PROP(DWARF)=PUT(DWARF,115,0)
      LOC=115
      OLDLOC=115
      NEWLOC=115
C
C  LEAVE THE GRATE WITH NORMAL (NON-NEGATIVE PROPERTY).
C
      FOO=PUT(GRATE,116,0)
      PROP(SNAKE)=PUT(SNAKE,116,1)
      PROP(BIRD)=PUT(BIRD,116,1)
      PROP(CAGE)=PUT(CAGE,116,0)
      PROP(ROD2)=PUT(ROD2,116,0)
      PROP(PILLOW)=PUT(PILLOW,116,0)
C
      PROP(MIRROR)=PUT(MIRROR,115,0)
      FIXED(MIRROR)=116
C
      DO 11010 I=1,100
11010 IF(TOTING(I))CALL MOVE(I,0)
C
      CALL RSPEAK(132)
      CLOSED=.TRUE.
      GO TO 2
C
C  ANOTHER WAY WE CAN FORCE AN END TO THINGS IS BY HAVING THE LAMP GIVE
C  WHEN IT GETS CLOSE, WE COME HERE TO WARN HIM.  WE GO TO 12000 IF THE
C  AND FRESH BATTERIES ARE HERE, IN WHICH CASE WE REPLACE THE BATTERIES
C  CONTINUE.  12200 IS FOR OTHER CASES OF LAMP DYING.  12400 IS WHEN IT
C  OUT, AND 12600 IS IF HE'S WANDERED OUTSIDE AND THE LAMP IS USED UP, I
C  CASE WE FORCE HIM TO GIVE UP.
C
12000 CALL RSPEAK(188)
      PROP(BATTER)=1
      IF(TOTING(BATTER))CALL DROP(BATTER,LOC)
      LIMIT=LIMIT+2500
      LMWARN=.FALSE.
      GO TO 19999
C
12200 IF(LMWARN.OR..NOT.HERE(LAMP))GO TO 19999
      LMWARN=.TRUE.
      SPK=187
      IF(PLACE(BATTER).EQ.0)SPK=183
      IF(PROP(BATTER).EQ.1)SPK=189
      CALL RSPEAK(SPK)
      GO TO 19999
C
12400 LIMIT=-1
      PROP(LAMP)=0
      IF(HERE(LAMP))CALL RSPEAK(184)
      GO TO 19999
C
12600 CALL RSPEAK(185)
      GAVEUP=.TRUE.
      GO TO 20000
C
C  AND, OF COURSE, DEMO GAMES ARE ENDED BY THE WIZARD.
C
13000 CALL MSPEAK(1)
      GAVEUP=.TRUE.
      GO TO 20000
C
C  OH DEAR, HE'S DISTURBED THE DWARVES.
C
19000 CALL RSPEAK(136)
C
C  EXIT CODE.  WILL EVENTUALLY INCLUDE SCORING.  FOR NOW, HOWEVER, ...
C
C  THE PRESENT SCORING ALGORITHM IS AS FOLLOWS:
C     OBJECTIVE:          POINTS:        PRESENT TOTAL POSSIBLE:
C  GETTING WELL INTO CAVE   25                    25
C  EACH TREASURE < CHEST    12                    60
C  TREASURE CHEST ITSELF    14                    14
C  EACH TREASURE > CHEST    16                   144
C  SURVIVING             (MAX0-NUM)*10             30
C  NOT QUITTING              4                     4
C  REACHING "CLOSNG"        25                    25
C  "CLOSED": QUIT/KILLED    10
C            KLUTZED        25
C            WRONG WAY      30
C            SUCCESS        45                    45
C  CAME TO WITT'S END        1                     1
C  ROUND OUT THE TOTAL       2                     2
C                                       TOTAL:   350
C  (POINTS CAN ALSO BE DEDUCTED FOR USING HINTS.)
C
20000 SCORE=0
      MXSCOR=0
C
C  FIRST TALLY UP THE TREASURES.  MUST BE IN BUILDING AND NOT BROKEN.
C  GIVE THE POOR GUY 2 POINTS JUST FOR FINDING EACH TREASURE.
C
      DO 20010 I=50,MAXTRS
         IF(PTEXT(I).EQ.0)GO TO 20010
         K=12
         IF(I.EQ.CHEST)K=14
         IF(I.GT.CHEST)K=16
         IF(PROP(I).GE.0)SCORE=SCORE+2
         IF(PLACE(I).EQ.3.AND.PROP(I).EQ.0)SCORE=SCORE+K-2
         MXSCOR=MXSCOR+K
20010 CONTINUE
C
C  NOW LOOK AT HOW HE FINISHED AND HOW FAR HE GOT.  MAXDIE AND NUMDIE TE
C  HOW WELL HE SURVIVED.  GAVEUP SAYS WHETHER HE EXITED VIA QUIT.  DFLAG
C  TELL US IF HE EVER GOT SUITABLY DEEP INTO THE CAVE.  CLOSNG STILL IND
C  WHETHER HE REACHED THE ENDGAME.  AND IF HE GOT AS FAR AS "CAVE CLOSED
C  (INDICATED BY "CLOSED"), THEN BONUS IS ZERO FOR MUNDANE EXITS OR 133,
C  135 IF HE BLEW IT (SO TO SPEAK).
C
      SCORE=SCORE+(MAXDIE-NUMDIE)*10
      MXSCOR=MXSCOR+MAXDIE*10
      IF(.NOT.(SCORNG.OR.GAVEUP))SCORE=SCORE+4
      MXSCOR=MXSCOR+4
      IF(DFLAG.NE.0)SCORE=SCORE+25
      MXSCOR=MXSCOR+25
      IF(CLOSNG)SCORE=SCORE+25
      MXSCOR=MXSCOR+25
      IF(.NOT.CLOSED)GO TO 20020
      IF(BONUS.EQ.0)SCORE=SCORE+10
      IF(BONUS.EQ.135)SCORE=SCORE+25
      IF(BONUS.EQ.134)SCORE=SCORE+30
      IF(BONUS.EQ.133)SCORE=SCORE+45
20020 MXSCOR=MXSCOR+45
C
C  DID HE COME TO WITT'S END AS HE SHOULD?
C
      IF(PLACE(MAGZIN).EQ.108)SCORE=SCORE+1
      MXSCOR=MXSCOR+1
C
C  ROUND IT OFF.
C
      SCORE=SCORE+2
      MXSCOR=MXSCOR+2
C
C  DEDUCT POINTS FOR HINTS.  HINTS < 4 ARE SPECIAL; SEE DATABASE DESCRIP
C
      DO 20030 I=1,HNTMAX
20030 IF(HINTED(I))SCORE=SCORE-HINTS(I,2)
C
C  RETURN TO SCORE COMMAND IF THAT'S WHERE WE CAME FROM.
C
      IF(SCORNG)GO TO 8241
C
C  THAT SHOULD BE GOOD ENOUGH.  LET'S TELL HIM ALL ABOUT IT.
C
      WRITE(TTYO,20100)SCORE,MXSCOR,TURNS
20100 FORMAT(///,' YOU SCORED',I4,' OUT OF A POSSIBLE',I4,
     1', USING',I5,' TURNS.')
C
      DO 20200 I=1,CLSSES
         IF(CVAL(I).GE.SCORE)GO TO 20210
20200 CONTINUE
      WRITE(TTYO,20202)
20202 FORMAT(/,' YOU JUST WENT OFF MY SCALE!!',/)
      GO TO 25000
C
20210 CALL SPEAK(CTEXT(I))
      IF(I.EQ.CLSSES-1)GO TO 20220
      K=CVAL(I)+1-SCORE
      KK='S.'
      IF(K.EQ.1)KK='. '
      WRITE(TTYO,20212)K,KK
20212 FORMAT(/,' TO ACHIEVE THE NEXT HIGHER RATING, YOU NEED',I3,
     1' MORE POINT',A2/)
      GO TO 25000
C
20220 WRITE(TTYO,20222)
20222 FORMAT(/,' TO ACHIEVE THE NEXT HIGHER RATING ',
     1'WOULD BE A NEAT TRICK!',//,' CONGRATULATIONS!!',/)
C
25000 STOP
C
      END
C
C  INTERNAL/EXTERNAL CHARACTER SET CONVERSION UTILITIES (CODE1, CODE2,
C   DCODE1, CVLTUC, CVSTB)
C
      INTEGER*4 FUNCTION CODE1(QQQ)
C
C  CONVERT EXTERNAL CHARACTERS TO INTERNAL FORMAT (5 CHARS/INTEGER*4).
C
C  THE FIRST FIVE CHARACTERS OF WORDS ARE CONVERTED TO THEIR INTERNAL
C  REPRESENTATION (SIXBIT).  IF A CHARACTER HAS NO REPRESENTATION, IT IS
C  REPLACED BY A PERIOD.
C
C  DEFINITION OF CONSTANTS:
C       NWORDS = NUMBER OF INTEGER*4 VARIABLES NEEDED TO HOLD FIVE CHARS
C       NCHARS = NUMBER OF CHARACTERS STORED IN AN INTEGER*4 VARIABLE
C       CHRSIZ = NUMBER OF BITS REQUIRED TO REPRESENT A CHARACTER
C       CHRMSK = NUMBER TO AND WITH AN INTEGER*4 TO OBTAIN HIGH-ORDER
C                CHARACTER.
C
C  (SEE CONVERSION GUIDE)
C
      IMPLICIT INTEGER*4(A-Z)
      character QQQ*(*),SSS*8
      DIMENSION WORDS(2)
      DIMENSION CHRSET(64)
      EQUIVALENCE(SSS,WORDS(1))
C
      DATA NWORDS/2/,NCHARS/4/,CHRSIZ/8/,CHRMSK/Z'FF000000'/
C
      DATA CHRSET/1H ,1H!,1H",1H#,1H$,1H%,1H&,1H',
     1            1H(,1H),1H*,1H+,1H,,1H-,1H.,1H/,
     2            1H0,1H1,1H2,1H3,1H4,1H5,1H6,1H7,
     3            1H8,1H9,1H:,1H;,1H<,1H=,1H>,1H?,
     4            1H@,1HA,1HB,1HC,1HD,1HE,1HF,1HG,
     5            1HH,1HI,1HJ,1HK,1HL,1HM,1HN,1HO,
     6            1HP,1HQ,1HR,1HS,1HT,1HU,1HV,1HW,
     7            1HX,1HY,1HZ,1H[,Z'5C202020',1H],1H^,Z'07202020'/
C ABOVE LINE SCROGGED FOR TSS EDITOR; 5C=BACKSLASH, 5F=UNDERBAR
C
         DO 1234 I=1,5
1234     SSS(I:I)=QQQ(I:I)
      RESULT=0
      COUNT=0
C
      DO 10 I=1,NWORDS
         WORD=WORDS(I)
C
         DO 5 J=1,NCHARS
            COUNT=COUNT+1
            IF(COUNT.GT.5)GO TO 20
            CHAR=AND(WORD,CHRMSK)
            WORD=ISHFT(WORD,CHRSIZ)
            DO 1 CHRIDX=1,64
               IF(CHAR.EQ.AND(CHRSET(CHRIDX),CHRMSK))GO TO 2
    1       CONTINUE
            CHRIDX=15
    2       RESULT=ISHFT(RESULT,6)+CHRIDX-1
    5    CONTINUE
   10 CONTINUE
C
   20 CODE1=RESULT
      RETURN
      END
      INTEGER*4 FUNCTION CODE2(CHARS)
C
C  CONVERT EXTERNAL CHARACTERS TO INTERNAL FORMAT (5 CHARS/INTEGER*4).
C
C  CHARS CONTAINS FIVE CHARACTERS IN A1 FORMAT.  THEY ARE CONVERTED TO
C  THEIR INTERNAL REPRESENTATION (SIXBIT).  IF A CHARACTER
C  HAS NO REPRESENTATION, IT IS REPLACED BY A PERIOD.
C
C  (SEE CONVERSION GUIDE)
C
      IMPLICIT INTEGER*4(A-Z)
      DIMENSION CHARS(5)
C
      DIMENSION CHRSET(64)
      DATA CHRSET/1H ,1H!,1H",1H#,1H$,1H%,1H&,1H',
     1            1H(,1H),1H*,1H+,1H,,1H-,1H.,1H/,
     2            1H0,1H1,1H2,1H3,1H4,1H5,1H6,1H7,
     3            1H8,1H9,1H:,1H;,1H<,1H=,1H>,1H?,
     4            1H@,1HA,1HB,1HC,1HD,1HE,1HF,1HG,
     5            1HH,1HI,1HJ,1HK,1HL,1HM,1HN,1HO,
     6            1HP,1HQ,1HR,1HS,1HT,1HU,1HV,1HW,
     7            1HX,1HY,1HZ,1H[,Z'5C202020',1H],1H^,Z'07202020'/
C ABOVE LINE SCROGGED FOR TSS EDITOR; 5C=BACKSLASH, 5F=UNDERBAR
C
      RESULT=0
C
      DO 10 I=1,5
         DO 1 CHRIDX=1,64
            IF(CHARS(I).EQ.CHRSET(CHRIDX))GO TO 2
    1    CONTINUE
         CHRIDX=15
    2    RESULT=ISHFT(RESULT,6)+CHRIDX-1
   10 CONTINUE
C
      CODE2=RESULT
      RETURN
      END
      SUBROUTINE DCODE1(VALUE,RESULT)
C
C  CONVERT INTERNAL CHARACTERS TO EXTERNAL FORMAT.
C
C  VALUE CONTAINS FIVE CHARACTERS IN SIXBIT.  THEY ARE CONVERTED
C  TO A1 FORMAT AND PLACED INTO RESULT(1) TO RESULT(5).
C
C  (SEE CONVERSION GUIDE)
C
      IMPLICIT INTEGER*4(A-Z)
      DIMENSION RESULT(5)
C
      DIMENSION CHRSET(64)
      DATA CHRSET/1H ,1H!,1H",1H#,1H$,1H%,1H&,1H',
     1            1H(,1H),1H*,1H+,1H,,1H-,1H.,1H/,
     2            1H0,1H1,1H2,1H3,1H4,1H5,1H6,1H7,
     3            1H8,1H9,1H:,1H;,1H<,1H=,1H>,1H?,
     4            1H@,1HA,1HB,1HC,1HD,1HE,1HF,1HG,
     5            1HH,1HI,1HJ,1HK,1HL,1HM,1HN,1HO,
     6            1HP,1HQ,1HR,1HS,1HT,1HU,1HV,1HW,
     7            1HX,1HY,1HZ,1H[,Z'5C202020',1H],1H^,Z'07202020'/
C ABOVE LINE SCROGGED FOR TSS EDITOR; 5C=BACKSLASH, 5F=UNDERBAR
C
      VALCPY=VALUE
C
      DO 10 I=1,5
         II=6-I
         CHRIDX=AND(VALCPY,Z'0000003F')+1
         VALCPY=VALCPY/64
         RESULT(II)=CHRSET(CHRIDX)
   10 CONTINUE
C
      RETURN
      END
      SUBROUTINE CVLTUC(TEXT,LTEXT)
C
C  CONVERT LOWER CASE CHARACTERS TO UPPER CASE.
C
C (SEE CONVERSION GUIDE)
C
      IMPLICIT INTEGER*4(A-Z)
      DIMENSION TEXT(70)
C
      DIMENSION UPPER(26),LOWER(26)
      DATA UPPER/1HA,1HB,1HC,1HD,1HE,1HF,1HG,1HH,1HI,1HJ,1HK,1HL,1HM,
     1           1HN,1HO,1HP,1HQ,1HR,1HS,1HT,1HU,1HV,1HW,1HX,1HY,1HZ/,
     2     LOWER/1Ha,1Hb,1Hc,1Hd,1He,1Hf,1Hg,1Hh,1Hi,1Hj,1Hk,1Hl,1Hm,
     3           1Hn,1Ho,1Hp,1Hq,1Hr,1Hs,1Ht,1Hu,1Hv,1Hw,1Hx,1Hy,1Hz/
C
C
      DO 10 I=1,LTEXT
         CHR=TEXT(I)
         DO 5 J=1,26
             IF(CHR.NE.LOWER(J))GO TO 5
             TEXT(I)=UPPER(J)
             GO TO 10
    5    CONTINUE
   10 CONTINUE
C
      RETURN
      END
      INTEGER*4 FUNCTION CVSTB(WORD1,WORD1X)
C
C  INTERNAL CHARACTER SET TO INTEGER*4 VALUE (BINARY NUMBER).
C
C  WORD1 AND WORD1X CONTAIN UP TO TEN NON-BLANK CHARACTERS IN SIXBIT
C  REPRESENTING AN INTEGER*4 VALUE.  IF A NON-DIGIT IS ENCOUNTERED IN TH
C  STRING, IT IS IGNORED.
C
C  (SEE CONVERSION GUIDE)
C
      IMPLICIT INTEGER*4(A-Z)
      LOGICAL NEGATE
      DIMENSION TEXT(10)
C
      DIMENSION DIGITS(10)
      DATA DIGITS/1H0,1H1,1H2,1H3,1H4,1H5,1H6,1H7,1H8,1H9/
      DATA BLANK,MINUS,PLUS/' ','-','+'/
C
C
      CALL DCODE1(WORD1,TEXT(1))
      CALL DCODE1(WORD1X,TEXT(6))
      RESULT=0
      NEGATE=.FALSE.
      S=1
C
      IF(TEXT(1).NE.MINUS)GO TO 1
      NEGATE=.TRUE.
      S=2
      GO TO 2
C
    1 IF(TEXT(1).NE.PLUS)GO TO 2
      NEGATE=.FALSE.
      S=2
C
    2 DO 10 I=S,10
         IF(TEXT(I).EQ.BLANK)GO TO 20
         DO 5 J=1,10
            IF(TEXT(I).EQ.DIGITS(J))GO TO 6
    5    CONTINUE
         GO TO 10
    6    RESULT=10*RESULT+J-1
   10 CONTINUE
C
   20 IF(NEGATE)RESULT=-RESULT
      CVSTB=RESULT
      RETURN
      END
      SUBROUTINE SPEAK(N)
C
C  PRINT THE MESSAGE WHICH STARTS AT LINES(N).  PRECEDE IT WITH A BLANK
C  UNLESS BLKLIN IS FALSE.
C
      IMPLICIT INTEGER*4(A-Z)
      LOGICAL BLKLIN
C!!!  COMMON /TXTCOM/ RTEXT,LINES
      COMMON /TXTCOM/ RTEXT
      COMMON /IOSCOM/ TTYI,TTYO,BLKLIN,DBFI
      DIMENSION RTEXT(205),TEXT(70)
C!!!  DIMENSION LINES(9800)
      DATA BLANK/' '/
C
C
      IF(N.EQ.0)RETURN
      IF(LINES(N+1).EQ.CODE1('>$<      '))RETURN
C
      IF(BLKLIN)WRITE(TTYO,1)
    1 FORMAT(1X)
C
      K=N
C
   10 NWORDS=IABS(LINES(K))-K-1
      IF(NWORDS.EQ.0)GO TO 40
C
      NCHARS=5*NWORDS
      DO 15 I=1,NWORDS
         LIDX=K+I
         TIDX=5*(I-1)+1
         CALL DCODE1(LINES(LIDX),TEXT(TIDX))
   15 CONTINUE
      WRITE(TTYO,20)(TEXT(I),I=1,NCHARS)
   20 FORMAT(1X,70A1)
C
   30 K=IABS(LINES(K))
      IF(LINES(K).GE.0)GO TO 10
      RETURN
C
   40 WRITE(TTYO,1)
      GO TO 30
      END
      SUBROUTINE PSPEAK(MSG,SKIP)
C
C  FIND THE SKIP+1ST MESSAGE FROM MSG AND PRINT IT.  MSG SHOULD BE THE I
C  THE INVENTORY MESSAGE FOR OBJECT.  (INVEN+N+1 MESSAGE IS PROP=N MESSA
C
      IMPLICIT INTEGER*4(A-Z)
C!!!  COMMON /TXTCOM/ RTEXT,LINES
      COMMON /TXTCOM/ RTEXT
      COMMON /PTXCOM/ PTEXT
      DIMENSION RTEXT(205),PTEXT(100)
C!!!  DIMENSION LINES(9800)
C
      M=PTEXT(MSG)
      IF(SKIP.LT.0)GO TO 9
      DO 3 I=0,SKIP
    1 M=IABS(LINES(M))
      IF(LINES(M).GE.0)GO TO 1
    3 CONTINUE
    9 CALL SPEAK(M)
      RETURN
      END
      SUBROUTINE RSPEAK(I)
C
C  PRINT THE I-TH "RANDOM" MESSAGE (SECTION 6 OF DATABASE).
C
      IMPLICIT INTEGER*4(A-Z)
C!!!  COMMON /TXTCOM/ RTEXT,LINES
      COMMON /TXTCOM/ RTEXT
      DIMENSION RTEXT(205)
C!!!  DIMENSION LINES(9800)
C
      IF(I.NE.0)CALL SPEAK(RTEXT(I))
      RETURN
      END
      SUBROUTINE MSPEAK(I)
C
C  PRINT THE I-TH "MAGIC" MESSAGE (SECTION 12 OF DATABASE).
C
      IMPLICIT INTEGER*4(A-Z)
      COMMON /MTXCOM/ MTEXT
      DIMENSION MTEXT(35)
C
      IF(I.NE.0)CALL SPEAK(MTEXT(I))
      RETURN
      END
      SUBROUTINE GETIN(WORD1,WORD1X,WORD2,WORD2X,NULLOK)
C
C  GET A COMMAND FROM THE ADVENTURER.
C
C  WORD1 IS SET TO THE FIRST FIVE CHARACTERS OF THE FIRST WORD AND
C  WORD1X IS SET TO THE SECOND FIVE.  WORD2 AND WORD2X ARE USED IN
C  AN ANALAGOUS FASHION FOR THE SECOND WORD.  IF THERE IS NO SECOND
C  WORD, WORD2 IS SET TO ZERO.
C  IF NULLOK IS .TRUE. AND A BLANK LINE IS SUPPLIED, WORD1 IS SET TO ZER
C  OTHERWISE, THE USER MUST TYPE A NON-BLANK RESPONSE.
C
      IMPLICIT INTEGER*4(A-Z)
      LOGICAL NULLOK,BLKLIN,NULL,LGWORD
C
      COMMON /IOSCOM/ TTYI,TTYO,BLKLIN,DBFI
C
      DIMENSION LINE(70),CHARS(5)
      DATA BLANK/' '/, NEWLINE/Z'0D202020'/
C
C
      WORD1=0
      WORD1X=0
      WORD2=0
      WORD2X=0
C
      IF(BLKLIN)WRITE(TTYO,1)
    1 FORMAT(1X)
C
    2 write (ttyo,'('' ? '',$)')
      READ(TTYI,3)LINE
    3 FORMAT(70A1)
C
C
C  CHECK FOR A NULL RESPONSE
C
      NULL = .TRUE.
      DO 4 I =1,70
         IF (LINE(I) .EQ. NEWLINE) LINE(I) = BLANK
         IF(LINE(I).NE.BLANK)NULL=.FALSE.
    4 CONTINUE
C
      IF(NULL.AND..NOT.NULLOK)GO TO 2
      IF(NULL.AND.NULLOK)RETURN
C
      CALL CVLTUC(LINE,70)
C
C
C  PROCESS THE FIRST WORD
C
      DO 10 WDST=1,70
         IF(LINE(WDST).NE.BLANK)GO TO 11
   10 CONTINUE
      CALL BUG(29)
C
   11 RETPNT=1
      GO TO 1000
   12 WORD1=CODE2(CHARS)
C
      IF(.NOT.LGWORD)GO TO 20
      RETPNT=2
      GO TO 1000
   15 WORD1X=CODE2(CHARS)
C
      IF(.NOT.LGWORD)GO TO 20
      DO 16 WDST=WDST,70
         IF(LINE(WDST).EQ.BLANK)GO TO 20
   16 CONTINUE
      RETURN
C
C
C  PROCESS SECOND WORD (IF ANY)
C
   20 IF(WDST.GT.70)RETURN
      DO 21 WDST=WDST,70
         IF(LINE(WDST).NE.BLANK)GO TO 25
   21 CONTINUE
      RETURN
C
   25 RETPNT=3
      GO TO 1000
   30 WORD2=CODE2(CHARS)
C
      IF(.NOT.LGWORD)RETURN
      RETPNT=4
      GO TO 1000
   35 WORD2X=CODE2(CHARS)
      RETURN
C
C
C  'INTERNAL SUBROUTINE' TO GET FIVE CHARACTERS (OR LESS) FROM CURRENT
C  WORD AND INDICATE IF WORD IS OVER FIVE CHARACTER LONG.
C
 1000 DO 1001 I=1,5
 1001 CHARS(I)=BLANK
C
      WDEND=MIN0(WDST+4,70)
      DO 1002 I=WDST,WDEND
         IF(LINE(I).EQ.BLANK)GO TO 1010
         J=I-WDST+1
         CHARS(J)=LINE(I)
 1002 CONTINUE
C
      WDST=WDST+5
      IF(LINE(WDST).NE.BLANK)LGWORD=.TRUE.
      IF(WDST.GT.70)LGWORD=.FALSE.
      GO TO 1099
C
 1010 WDST=I
      LGWORD=.FALSE.
C
 1099 GO TO(12,15,30,35),RETPNT
      END
      LOGICAL FUNCTION YESX(X,Y,Z,ISPK)
C
C  PRINT MESSAGE X, WAIT FOR YES/NO ANSWER.  IF YES, PRINT Y AND LEAVE Y
C  TRUE; IF NO, PRINT Z AND LEAVE YEA FALSE.  SPK IS EITHER RSPEAK OR MS
C
      IMPLICIT INTEGER*4(A-Z)
      LOGICAL BLKLIN
      COMMON /IOSCOM/ TTYI,TTYO,BLKLIN,DBFI
C
    1 IF(X.NE.0.AND.ISPK.EQ.1)CALL RSPEAK(X)
      IF(X.NE.0.AND.ISPK.EQ.2)CALL MSPEAK(X)
      CALL GETIN(REPLY,JUNK1,JUNK2,JUNK3,.FALSE.)
      IF(REPLY.EQ.CODE1('YES      ').OR.REPLY.EQ.CODE1('Y        '))
     *GO TO 10
      IF(REPLY.EQ.CODE1('NO       ').OR.REPLY.EQ.CODE1('N        '))
     *GO TO 20
      WRITE(TTYO,9)
    9 FORMAT(/,' PLEASE ANSWER THE QUESTION.')
      GO TO 1
   10 YESX=.TRUE.
      IF(Y.NE.0.AND.ISPK.EQ.1)CALL RSPEAK(Y)
      IF(Y.NE.0.AND.ISPK.EQ.2)CALL MSPEAK(Y)
      RETURN
   20 YESX=.FALSE.
      IF(Z.NE.0.AND.ISPK.EQ.1)CALL RSPEAK(Z)
      IF(Z.NE.0.AND.ISPK.EQ.2)CALL MSPEAK(Z)
      RETURN
      END
      SUBROUTINE A5TOA1(A,B,C,INSBLK,CHARS,LENG)
C
C  A AND B CONTAIN A 1- TO 10-CHARACTER WORD IN SIXBIT, C CONTAINS ANOTH
C  WORD AND/OR PUNCTUATION.  THEY ARE UNPACKED TO ONE CHARACTER PER WORD
C  ARRAY CHARS, WITH EXACTLY ONE BLANK BETWEEN B AND C IF INSBLK IS .TRU
C  (OTHERWISE, NO BLANK IS INSERTED).
C  THE INDEX OF THE LAST NON-BLANK CHAR IN CHARS IS RETURNED IN LENG.
C
      IMPLICIT INTEGER*4(A-Z)
      LOGICAL INSBLK
      DIMENSION CHARS(20)
      DATA BLANK/' '/
C
C
      CALL DCODE1(A,CHARS(1))
      CALL DCODE1(B,CHARS(6))
C
      DO 1 I=1,10
         II=11-I
         IF(CHARS(II).NE.BLANK)GO TO 2
    1 CONTINUE
      II=0
C
    2 IF(.NOT.INSBLK)GO TO 3
      II=II+1
      CHARS(II)=BLANK
C
    3 II=II+1
      CALL DCODE1(C,CHARS(II))
C
      DO 4 I=1,5
         LENG=II+5-I
         IF(CHARS(LENG).NE.BLANK)RETURN
    4 CONTINUE
C
      LENG=II-1
      IF(INSBLK)LENG=LENG-1
      RETURN
      END
C
C  DATA STRUCTURE ROUTINES (VOCAB, DSTROY, JUGGLE, MOVE, PUT, CARRY, DRO
C
      INTEGER*4 FUNCTION VOCAB(ID,INIT)
C
C  LOOK UP ID IN THE VOCABULARY (ATAB) AND RETURN ITS "DEFINITION" (KTAB
C  -1 IF NOT FOUND.  IF INIT IS POSITIVE, THIS IS AN INITIALIZATION CALL
C  UP A KEYWORD VARIABLE, AND NOT FINDING IT CONSTITUTES A BUG.  IT ALSO
C  THAT ONLY KTAB VALUES WHICH TAKEN OVER 1000 EQUAL INIT MAY BE CONSIDE
C  (THUS "STEPS", WHICH IS A MOTION VERB AS WELL AS AN OBJECT, MAY BE LO
C  AS AN OBJECT.)  AND IT ALSO MEANS THE KTAB VALUE IS TAKEN MOD 1000.
C
      IMPLICIT INTEGER*4(A-Z)
      COMMON /VOCCOM/ KTAB,ATAB,TABSIZ
      DIMENSION KTAB(300),ATAB(300)
C
C     SCRAMBLE THE CODE
      HASH=-(ID)
      DO 1 I=1,TABSIZ
      IF(KTAB(I).EQ.-1)GO TO 2
      IF(INIT.GE.0.AND.KTAB(I)/1000.NE.INIT)GO TO 1
      IF(ATAB(I).EQ.HASH)GO TO 3
    1 CONTINUE
      CALL BUG(21)
C
    2 VOCAB=-1
      IF(INIT.LT.0)RETURN
      CALL BUG(5)
C
    3 V=KTAB(I)
      VOCAB=KTAB(I)
      IF(INIT.GE.0)VOCAB=MOD(V,1000)
      RETURN
      END
      SUBROUTINE JUGGLE(OBJECT)
C
C  JUGGLE AN OBJECT BY PICKING IT UP AND PUTTING IT DOWN AGAIN, THE PURP
C  BEING TO GET THE OBJECT TO THE FRONT OF THE CHAIN OF THINGS AT ITS LO
C
      IMPLICIT INTEGER*4(A-Z)
      COMMON /PLACOM/ ATLOC,LINK,PLACE,FIXED,COND,PROP,LOC,LAMP,HOLDNG
      DIMENSION ATLOC(150),LINK(200),PLACE(100),FIXED(100)
      DIMENSION COND(150),PROP(100)
C
      I=PLACE(OBJECT)
      J=FIXED(OBJECT)
      CALL MOVE(OBJECT,I)
      CALL MOVE(OBJECT+100,J)
      RETURN
      END
      SUBROUTINE MOVE(OBJECT,WHERE)
C
C  PLACE ANY OBJECT ANYWHERE BY PICKING IT UP AND DROPPING IT.  MAY ALRE
C  TOTING, IN WHICH CASE THE CARRY IS A NO-OP.  MUSTN'T PICK UP OBJECTS
C  ARE NOT AT ANY LOC, SINCE CARRY WANTS TO REMOVE OBJECTS FROM ATLOC CH
C
      IMPLICIT INTEGER*4(A-Z)
      COMMON /PLACOM/ ATLOC,LINK,PLACE,FIXED,COND,PROP,LOC,LAMP,HOLDNG
      DIMENSION ATLOC(150),LINK(200),PLACE(100),FIXED(100)
      DIMENSION COND(150),PROP(100)
C
      IF(OBJECT.GT.100)GO TO 1
      FROM=PLACE(OBJECT)
      GO TO 2
    1 FROM=FIXED(OBJECT-100)
    2 IF(FROM.GT.0.AND.FROM.LE.300)CALL CARRY(OBJECT,FROM)
      CALL DROP(OBJECT,WHERE)
      RETURN
      END
      INTEGER*4 FUNCTION PUT(OBJECT,WHERE,PVAL)
C
C  PUT IS THE SAME AS MOVE, EXCEPT IT RETURNS A VALUE USED TO SET UP THE
C  NEGATED PROP VALUES FOR THE REPOSITORY OBJECTS.
C
      IMPLICIT INTEGER*4(A-Z)
C
      CALL MOVE(OBJECT,WHERE)
      PUT=(-1)-PVAL
      RETURN
      END
      SUBROUTINE CARRY(OBJECT,WHERE)
C
C  START TOTING AN OBJECT, REMOVING IT FROM THE LIST OF THINGS AT ITS FO
C  LOCATION.  INCR HOLDNG UNLESS IT WAS ALREADY BEING TOTED.  IF OBJECT>
C  (MOVING "FIXED" SECOND LOC), DON'T CHANGE PLACE OR HOLDNG.
C
      IMPLICIT INTEGER*4(A-Z)
      COMMON /PLACOM/ ATLOC,LINK,PLACE,FIXED,COND,PROP,LOC,LAMP,HOLDNG
      DIMENSION ATLOC(150),LINK(200),PLACE(100),FIXED(100)
      DIMENSION COND(150),PROP(100)
C
      IF(OBJECT.GT.100)GO TO 5
      IF(PLACE(OBJECT).EQ.-1)RETURN
      PLACE(OBJECT)=-1
      HOLDNG=HOLDNG+1
    5 IF(ATLOC(WHERE).NE.OBJECT)GO TO 6
      ATLOC(WHERE)=LINK(OBJECT)
      RETURN
    6 TEMP=ATLOC(WHERE)
    7 IF(LINK(TEMP).EQ.OBJECT)GO TO 8
      TEMP=LINK(TEMP)
      GO TO 7
    8 LINK(TEMP)=LINK(OBJECT)
      RETURN
      END
      SUBROUTINE DROP(OBJECT,WHERE)
C
C  PLACE AN OBJECT AT A GIVEN LOC, PREFIXING IT ONTO THE ATLOC LIST.  DE
C  HOLDNG IF THE OBJECT WAS BEING TOTED.
C
      IMPLICIT INTEGER*4(A-Z)
      COMMON /PLACOM/ ATLOC,LINK,PLACE,FIXED,COND,PROP,LOC,LAMP,HOLDNG
      DIMENSION ATLOC(150),LINK(200),PLACE(100),FIXED(100)
      DIMENSION COND(150),PROP(100)
C
      IF(OBJECT.GT.100)GO TO 1
      IF(PLACE(OBJECT).EQ.-1)HOLDNG=HOLDNG-1
      PLACE(OBJECT)=WHERE
      GO TO 2
    1 FIXED(OBJECT-100)=WHERE
    2 IF(WHERE.LE.0)RETURN
      LINK(OBJECT)=ATLOC(WHERE)
      ATLOC(WHERE)=OBJECT
      RETURN
      END
C  WIZARDRY ROUTINES (START, MAINT, WIZARD, HOURS(X), NEWHRS(X), MOTD, P
C
C
      LOGICAL FUNCTION START(DUMY)
C
C  CHECK TO SEE IF THIS IS "PRIME TIME".  IF SO, ONLY WIZARDS MAY PLAY,
C  OTHERS MAY BE ALLOWED A SHORT GAME FOR DEMONSTRATION PURPOSES.  IF SE
C  WE'RE CONTINUING FROM A SAVED GAME, SO CHECK FOR SUITABLE LATENCY.  R
C  TRUE IF THIS IS A DEMO GAME (VALUE IS IGNORED FOR RESTARTS).
C
      IMPLICIT INTEGER*4(A-Z)
      LOGICAL PTIME,SOON,WIZARD,BLKLIN,YESX
      DIMENSION HNAME(20)
      COMMON /WIZCOM/ WKDAY,WKEND,HOLID,HBEGIN,HEND,HNAME,
     1SHORT,MAGIC,MAGNM,LATNCY,SAVED,SAVET,SETUP
      COMMON /IOSCOM/ TTYI,TTYO,BLKLIN,DBFI
C
C  FIRST FIND OUT WHETHER IT IS PRIME TIME (SAVE IN PTIME) AND, IF RESTA
C  WHETHER IT'S TOO SOON (SAVE IN SOON).  PRIME-TIME SPECS ARE IN WKDAY,
C  AND HOLID; SEE MAINT ROUTINE FOR DETAILS.  LATNCY IS REQUIRED DELAY B
C  RESTARTING.  WIZARDS MAY CUT THIS TO A THIRD.
C
      CALL DATIME(D,T)
      PRIMTM=WKDAY
      IF(MOD(D,7).LE.1)PRIMTM=WKEND
      IF(D.GE.HBEGIN.AND.D.LE.HEND)PRIMTM=HOLID
      PTIME=AND(PRIMTM,ISHFT(1,T/60)).NE.0
      SOON=.FALSE.
      IF(SETUP.GE.0)GO TO 20
      DELAY=(D-SAVED)*1440+(T-SAVET)
      IF(DELAY.GE.LATNCY)GO TO 20
      WRITE(TTYO,10)DELAY
   10 FORMAT(' THIS ADVENTURE WAS SUSPENDED A MERE',I3,' MINUTES AGO.')
      SOON=.TRUE.
C
C    REMOVE NEXT THREE LINES TO ALLOW WIZARD TO RESUME WITHOUT
C    WAITING
C
C     IF(DELAY.GE.LATNCY/3)GO TO 20
C     CALL MSPEAK(2)
C     STOP
C
C  IF NEITHER TOO SOON NOR PRIME TIME, NO PROBLEM.  ELSE SPECIFY WHAT'S
C
   20 START=.FALSE.
      IF(SOON)GO TO 30
      IF(PTIME)GO TO 25
   22 SAVED=-1
      RETURN
C
C  COME HERE IF NOT RESTARTING TOO SOON (MAYBE NOT RESTARTING AT ALL), B
C  PRIME TIME.  GIVE OUR HOURS AND SEE IF HE'S A WIZARD.  IF NOT, THEN C
C  RESTART, BUT IF JUST BEGINNING THEN WE CAN OFFER A SHORT GAME.
C
   25 CALL MSPEAK(3)
      CALL HOURS
      CALL MSPEAK(4)
      IF(WIZARD(0))GO TO 22
      IF(SETUP.LT.0)GO TO 33
      START=YESX(5,7,7,2)
      IF(START)GO TO 22
      STOP
C
C  COME HERE IF RESTARTING TOO SOON.  IF HE'S A WIZARD, LET HIM GO (AND
C  THAT IT THEN DOESN'T MATTER WHETHER IT'S PRIME TIME).  ELSE, TOUGH BE
C
   30 CALL MSPEAK(8)
      IF(WIZARD(0))GO TO 22
   33 CALL MSPEAK(9)
      STOP
      END
      SUBROUTINE MAINT(CMADRS,CMSZES)
C
C  SOMEONE SAID THE MAGIC WORD TO INVOKE MAINTENANCE MODE.  MAKE SURE HE
C  WIZARD.  IF SO, LET HIM TWEAK ALL SORTS OF RANDOM THINGS, THEN EXIT S
C  SAVE TWEAKED VERSION.  SINCE MAGIC WORD MUST BE FIRST COMMAND GIVEN,
C  THING WHICH NEEDS TO BE FIXED UP IS ABB(1).
C
      IMPLICIT INTEGER*4(A-Z)
      LOGICAL YESX,BLKLIN,WIZARD
      DIMENSION HNAME(20),ABB(150),CMADRS(4,11),CMSZES(11),FDUMY(10)
      COMMON /ABBCOM/ ABB
      COMMON /WIZCOM/ WKDAY,WKEND,HOLID,HBEGIN,HEND,HNAME,
     1SHORT,MAGIC,MAGNM,LATNCY,SAVED,SAVET,SETUP
      COMMON /IOSCOM/ TTYI,TTYO,BLKLIN,DBFI
C
C
      IF(.NOT.WIZARD(0))RETURN
C
      IF(YESX(10,0,0,2))CALL HOURS
      IF(YESX(11,0,0,2))CALL NEWHRS
      IF(.NOT.YESX(26,0,0,2))GO TO 10
C
      CALL MSPEAK(27)
      CALL GETIN(WORD1,WORD1X,DUMY,DUMY,.FALSE.)
      HBEGIN=CVSTB(WORD1,WORD1X)
      CALL MSPEAK(28)
      CALL GETIN(WORD1,WORD1X,DUMY,DUMY,.FALSE.)
      HEND=CVSTB(WORD1,WORD1X)
      CALL DATIME(D,T)
      HBEGIN=HBEGIN+D
      HEND=HBEGIN+HEND-1
      CALL MSPEAK(29)
      READ(TTYI,2)HNAME
    2 FORMAT(20A1)
C
   10 WRITE(TTYO,12)SHORT
   12 FORMAT(/,' LENGTH OF SHORT GAME (NULL TO LEAVE AT ',I3,'):')
      CALL GETIN(WORD1,WORD1X,DUMY,DUMY,.TRUE.)
      IF(WORD1.EQ.0)GO TO 15
      X=CVSTB(WORD1,WORD1X)
      IF(X.GT.0)SHORT=X
C
   15 CALL MSPEAK(12)
      CALL GETIN(WORD1,DUMY,DUMY,DUMY,.TRUE.)
      IF(WORD1.NE.0)MAGIC=WORD1
C
      WRITE(TTYO,16)LATNCY
   16 FORMAT(/,' LATENCY FOR RESTART (NULL TO LEAVE AT ',I3,'):')
      CALL GETIN(WORD1,WORD1X,DUMY,DUMY,.TRUE.)
      IF(WORD1.EQ.0)GO TO 20
      X=CVSTB(WORD1,WORD1X)
      IF(X.GT.0.AND.X.LT.45)CALL MSPEAK(30)
      IF(X.GT.0)LATNCY=MAX0(45,X)
C
   20 IF(YESX(14,0,0,2))CALL MOTD(.TRUE.)
C
      SAVED=0
      SETUP=2
      ABB(1)=0
      BLKLIN=.TRUE.
      CALL SVCOMN(.TRUE.,FDUMY,CMADRS,CMSZES)
      CALL MSPEAK(15)
      RETURN
      END
      LOGICAL FUNCTION WIZARD(DUMY)
C
C  ASK IF HE'S A WIZARD.  IF HE SAYS YES, MAKE HIM PROVE IT.  RETURN TRU
C  REALLY IS A WIZARD.
C
      IMPLICIT INTEGER*4(A-Z)
      LOGICAL YESX,BLKLIN
      DIMENSION HNAME(20),XD(10)
      COMMON /WIZCOM/ WKDAY,WKEND,HOLID,HBEGIN,HEND,HNAME,
     1SHORT,MAGIC,MAGNM,LATNCY,SAVED,SAVET,SETUP
      COMMON /IOSCOM/ TTYI,TTYO,BLKLIN,DBFI
C
      WIZARD=YESX(16,0,7,2)
      IF(.NOT.WIZARD)RETURN
C
C  HE SAYS HE IS.  FIRST STEP: DOES HE KNOW ANYTHING MAGICAL?
C
      CALL MSPEAK(17)
      CALL GETIN(WORD,X,Y,Z,.FALSE.)
      IF(WORD.NE.MAGIC)GO TO 99
C
C  HE DOES.  GIVE HIM A RANDOM CHALLENGE AND CHECK HIS REPLY.
C
C     X=0
C     DO 10 I=1,10
C        XD(I)=RAN(8)
C        X=ISHFT(X,3)+XD(I)
C  10 CONTINUE
C     MWORD=IEOR(MAGIC,X)
C
      IF(YESX(18,0,0,2))GO TO 99
C
C     WRITE(TTYO,11)XD
C  11 FORMAT(/1X,10I1)
C     CALL GETIN(WORD,X,Y,Z,.FALSE.)
C     IF(WORD.NE.MWORD)GO TO 99
C
C  BY GEORGE, HE REALLY *IS* A WIZARD!
C
      CALL MSPEAK(19)
      RETURN
C
C  AHA!  AN IMPOSTOR!
C
   99 CALL MSPEAK(20)
      WIZARD=.FALSE.
      RETURN
      END
      SUBROUTINE HOURS
C
C  ANNOUNCE THE CURRENT HOURS WHEN THE CAVE IS OPEN FOR ADVENTURING.  TH
C  IS STORED IN WKDAY, WKEND, AND HOLID, WHERE BIT ISHFT(1,N) IS ON IFF
C  HOUR FROM N:00 TO N:59 IS "PRIME TIME" (CAVE CLOSED).  WKDAY IS FOR
C  WEEKDAYS, WKEND FOR WEEKENDS, HOLID FOR HOLIDAYS.  NEXT HOLIDAY IS FR
C  HBEGIN TO HEND.
C
      IMPLICIT INTEGER*4(A-Z)
      LOGICAL BLKLIN
      DIMENSION HNAME(20)
      COMMON /WIZCOM/ WKDAY,WKEND,HOLID,HBEGIN,HEND,HNAME,
     1SHORT,MAGIC,MAGNM,LATNCY,SAVED,SAVET,SETUP
      COMMON /IOSCOM/ TTYI,TTYO,BLKLIN,DBFI
C
C
      WRITE(TTYO,1)
    1 FORMAT(' ')
C
      CALL HOURSX(WKDAY,1)
      CALL HOURSX(WKEND,2)
      CALL HOURSX(HOLID,3)
C
      CALL DATIME(D,T)
      IF(HEND.LT.D.OR.HEND.LT.HBEGIN)RETURN
      IF(HBEGIN.GT.D)GO TO 10
C
      WRITE(TTYO,5)HNAME
    5 FORMAT(/,' TODAY IS A HOLIDAY, NAMELY ',20A1)
      RETURN
C
   10 D=HBEGIN-D
      T='S,'
      IF(D.EQ.1)T=', '
      WRITE(TTYO,15)D,T,HNAME
   15 FORMAT(/,' THE NEXT HOLIDAY WILL BE IN',I3,' DAY',A2,
     1' NAMELY ',20A1)
      RETURN
      END
      SUBROUTINE HOURSX(H,DAYTYP)
C
C  USED BY HOURS (ABOVE) TO PRINT HOURS FOR EITHER WEEKDAYS OR WEEKENDS.
C
      IMPLICIT INTEGER*4(A-Z)
      LOGICAL FIRST,BLKLIN
      COMMON /IOSCOM/ TTYI,TTYO,BLKLIN,DBFI
C
      DIMENSION TYPE(3,10)
      DATA ((TYPE(I,J),J=1,10),I=1,3)
     1     /1HM,1HO,1HN,1H ,1H-,1H ,1HF,1HR,1HI,1H:,
     2      1HS,1HA,1HT,1H ,1H&,1H ,1HS,1HU,1HN,1H:,
     3      1HH,1HO,1HL,1HI,1HD,1HA,1HY,1HS,1H:,1H /
C
C
      FIRST=.TRUE.
      FROM=-1
      IF(H.NE.0)GO TO 10
C
      WRITE(TTYO,2)(TYPE(DAYTYP,J),J=1,10)
    2 FORMAT(10X,10A1,'   OPEN ALL DAY')
      RETURN
C
   10 FROM=FROM+1
      IF(AND(H,ISHFT(1,FROM)).NE.0)GO TO 10
      IF(FROM.GE.24)GO TO 20
      TILL=FROM
   14 TILL=TILL+1
      IF(AND(H,ISHFT(1,TILL)).EQ.0.AND.TILL.NE.24)GO TO 14
C
      IF(FIRST)WRITE(TTYO,16)(TYPE(DAYTYP,J),J=1,10),FROM,TILL
      IF(.NOT.FIRST)WRITE(TTYO,18)FROM,TILL
   16 FORMAT(10X,10A1,I4,':00 TO',I3,':00')
   18 FORMAT(20X,I4,':00 TO',I3,':00')
      FIRST=.FALSE.
      FROM=TILL
      GO TO 10
C
   20 IF(FIRST)WRITE(TTYO,22)(TYPE(DAYTYP,J),J=1,10)
   22 FORMAT(10X,10A1,'   CLOSED ALL DAY')
      RETURN
      END
      SUBROUTINE NEWHRS
C
C  SET UP NEW HOURS FOR THE CAVE.  SPECIFIED AS INVERSE--I.E., WHEN IS I
C  CLOSED DUE TO PRIME TIME?  SEE HOURS (ABOVE) FOR DESC OF VARIABLES.
C
      IMPLICIT INTEGER*4(A-Z)
      DIMENSION HNAME(20)
      COMMON /WIZCOM/ WKDAY,WKEND,HOLID,HBEGIN,HEND,HNAME,
     1SHORT,MAGIC,MAGNM,LATNCY,SAVED,SAVET,SETUP
C
      CALL MSPEAK(21)
C
      WKDAY=NEWHRX(1)
      WKEND=NEWHRX(2)
      HOLID=NEWHRX(3)
C
      CALL MSPEAK(22)
      CALL HOURS
      RETURN
      END
      INTEGER*4 FUNCTION NEWHRX(DAYTYP)
C
C  INPUT PRIME TIME SPECS AND SET UP A WORD OF INTERNAL FORMAT.
C
      IMPLICIT INTEGER*4(A-Z)
      LOGICAL BLKLIN
      COMMON /IOSCOM/ TTYI,TTYO,BLKLIN,DBFI
C
      DIMENSION TYPE(3,10)
      DATA ((TYPE(I,J),J=1,10),I=1,3)
     1     /1HM,1HO,1HN,1H ,1H-,1H ,1HF,1HR,1HI,1H:,
     2      1HS,1HA,1HT,1H ,1H&,1H ,1HS,1HU,1HN,1H:,
     3      1HH,1HO,1HL,1HI,1HD,1HA,1HY,1HS,1H:,1H /
C
      NX=0
      BLKLIN=.FALSE.
      WRITE(TTYO,1)(TYPE(DAYTYP,J),J=1,10)
    1 FORMAT(' PRIME TIME ON ',10A1)
C
   10 WRITE(TTYO,2)
    2 FORMAT(' FROM:')
      CALL GETIN(WORD1,WORD1X,DUMY,DUMY,.TRUE.)
      FROM=CVSTB(WORD1,WORD1X)
      IF(FROM.LT.0.OR.FROM.GE.24)GO TO 20
C
      WRITE(TTYO,4)
    4 FORMAT(' TILL:')
      CALL GETIN(WORD1,WORD1X,DUMY,DUMY,.TRUE.)
      TILL=CVSTB(WORD1,WORD1X)-1
      IF(TILL.LT.FROM.OR.TILL.GE.24)GO TO 20
C
      DO 5 I=FROM,TILL
    5 NX=OR(NX,ISHFT(1,I))
      GO TO 10
C
   20 BLKLIN=.TRUE.
      NEWHRX=NX
      RETURN
      END
      SUBROUTINE MOTD(ALTER)
C
C  HANDLES MESSAGE OF THE DAY.  IF ALTER IS TRUE, READ A NEW MESSAGE FRO
C  WIZARD.  ELSE PRINT THE CURRENT ONE.  MESSAGE IS INITIALLY NULL.
C
      IMPLICIT INTEGER*4(A-Z)
      LOGICAL ALTER,BLKLIN
C
      COMMON /IOSCOM/ TTYI,TTYO,BLKLIN,DBFI
      COMMON /MTDCOM/ MTDTXT
C
      DIMENSION MTDTXT(100),TEXT(70)
      DATA BLANK/' '/,PERIOD/'.'/
C
C
      IF(ALTER)GO TO 50
C
      K=1
C
   10 IF(MTDTXT(K).LT.0)RETURN
      NWORDS=MTDTXT(K)-K-1
      IF(NWORDS.EQ.0)GO TO 40
C
      NCHARS=5*NWORDS
      DO 15 I=1,NWORDS
         MIDX=K+I
         TIDX=5*(I-1)+1
         CALL DCODE1(MTDTXT(MIDX),TEXT(TIDX))
   15 CONTINUE
      WRITE(TTYO,20)(TEXT(I),I=1,NCHARS)
   20 FORMAT(1X,70A1)
C
   30 K=MTDTXT(K)
      GO TO 10
C
   40 WRITE(TTYO,45)
   45 FORMAT(1X)
      GO TO 30
C
   50 M=1
      CALL MSPEAK(23)
C
   55 READ(TTYI,56)TEXT,K
   56 FORMAT(70A1,A1)
      IF(K.EQ.BLANK)GO TO 60
      CALL MSPEAK(24)
      GO TO 55
C
   60 DO 62 I=1,70
         K=71-I
         IF(TEXT(K).NE.BLANK)GO TO 65
   62 CONTINUE
      K=0
      GO TO 70
C
   65 IF((K.EQ.1).AND.(TEXT(1).EQ.PERIOD))GO TO 90
C
      CALL CVLTUC(TEXT,K)
      K=(K+4)/5
      DO 66 I=1,K
         K1=M+I
         K2=5*(I-1)+1
         MTDTXT(K1)=CODE2(TEXT(K2))
   66 CONTINUE
C
   70 MTDTXT(M)=M+K+1
      M=M+K+1
      IF(M+14.LT.100)GO TO 55
      CALL MSPEAK(25)
C
   90 MTDTXT(M)=-1
      RETURN
      END
      SUBROUTINE POOF
C
C  AS PART OF DATABASE INITIALIZATION, WE CALL POOF TO SET UP SOME DUMY
C  PRIME-TIME SPECS, MAGIC WORDS, ETC.
C
      IMPLICIT INTEGER*4(A-Z)
      DIMENSION HNAME(20)
      COMMON /WIZCOM/ WKDAY,WKEND,HOLID,HBEGIN,HEND,HNAME,
     1SHORT,MAGIC,MAGNM,LATNCY,SAVED,SAVET,SETUP
C
      WKDAY=261888
C  ABOVE CONSTANT SETS PRIME-TIME ON WEEKDAYS AS 09:00 - 18:00
      WKEND=0
      HOLID=0
      HBEGIN=0
      HEND=-1
      SHORT=30
      MAGIC=CODE1('DWARF    ')
      MAGNM=11111
      LATNCY=90
      RETURN
      END
C
C  UTILITY ROUTINES (SCRMBL, RAN, DATIME, CIAO, BUG)
C
      SUBROUTINE BUG(NUM)
      IMPLICIT INTEGER*4(A-Z)
      LOGICAL BLKLIN
      COMMON /IOSCOM/ TTYI,TTYO,BLKLIN,DBFI
      DATA CAVE/'CAVE'/
C
C  THE FOLLOWING CONDITIONS ARE CURRENTLY CONSIDERED FATAL BUGS.  NUMBER
C  ARE DETECTED WHILE READING THE DATABASE; THE OTHERS OCCUR AT "RUN TIM
C       0       MESSAGE LINE > 70 CHARACTERS
C       1       NULL LINE IN MESSAGE
C       2       TOO MANY WORDS OF MESSAGES
C       3       TOO MANY TRAVEL OPTIONS
C       4       TOO MANY VOCABULARY WORDS
C       5       REQUIRED VOCABULARY WORD NOT FOUND
C       6       TOO MANY RTEXT OR MTEXT MESSAGES
C       7       TOO MANY HINTS
C       8       LOCATION HAS COND BIT BEING SET TWICE
C       9       INVALID SECTION NUMBER IN DATABASE
C      20       SPECIAL TRAVEL (500>L>300) EXCEEDS GO TO LIST
C      21       RAN OFF END OF VOCABULARY TABLE
C      22       VOCABULARY TYPE (N/1000) NOT BETWEEN 0 AND 3
C      23       INTRANSITIVE ACTION VERB EXCEEDS GO TO LIST
C      24       TRANSITIVE ACTION VERB EXCEEDS GO TO LIST
C      25       CONDITIONAL TRAVEL ENTRY WITH NO ALTERNATIVE
C      26       LOCATION HAS NO TRAVEL ENTRIES
C      27       HINT NUMBER EXCEEDS GO TO LIST
C      28       INVALID MONTH RETURNED BY DATE FUNCTION
C      29       INTERNAL ERROR IN GETIN (POSSIBLE FORTRAN BUG)
C
      WRITE(TTYO,1)NUM
    1 FORMAT (' FATAL ERROR, SEE SOURCE CODE FOR INTERPRETATION.',/
     1' PROBABLY CAUSE: ERRONEOUS INFO IN DATABASE.',/
     2' ERROR CODE =',I2/)
      CALL ABORT(CAVE)
9     RETURN
      END
      SUBROUTINE IOINIT(DUMY)
C
      IMPLICIT INTEGER*4(A-Z)
      LOGICAL BLKLIN
      COMMON /IOSCOM/ TTYI,TTYO,BLKLIN,DBFI
      integer getuid
      CHARACTER*16 MODE
      DATA LINE/'LINE'/, DATA/'DATA'/
C
C     TTYI='!!!'
C     TTYO='!!!'
C     DBFI='DBF'
      TTYI=5
      TTYO=6
      DBFI=1
C
C     OPEN (UNIT=TTYI)
      IF (DUMY .NE. 0) GO TO 38
      MODE = 'old'
      IF (getuid() .eq. 0) MODE='unknown'
c     WRITE(0,4321) MODE
c4321 FORMAT(' OPEN LFC = >2<, FILENAME = ',
c    1 '>/usr/local/lib/M.ADVLIN<, MODE = >',A,'<')
      OPEN (UNIT=2,ACCESS='DIRECT',ERR=37,
     * FORM='FORMATTED',RECL=768,
     * FILE='/usr/local/lib/M.ADVLIN', status=MODE)
      GO TO 38
37    CALL ABORT(LINE)
38    CONTINUE
C
c     WRITE(0,4322)
c4322 FORMAT(' OPEN LFC = >1<, FILENAME = ',
c    1 '>/usr/local/lib/M.ADVDAT<')
      OPEN (UNIT=1,ERR=39,
     * FILE='/usr/local/lib/M.ADVDAT',
     * status='old')
      GO TO 40
39    CALL ABORT(DATA)
40    CONTINUE
C
      RETURN
      END
      SUBROUTINE LDCOMN(L,FNAME,CMADDR,CMSIZE)
C
      IMPLICIT INTEGER*4(A-Z)
C
      COMMON /IOSCOM/ TTYI,TTYO,BLKLIN,DBFI
C
      LOGICAL L
C
      DIMENSION FNAME(8),CMADDR(4,11),CMSIZE(11)
      DIMENSION NEW2(8)
C
      DATA NEW2/1HM,1H.,1HA,1HD,1HV,1HG,1HA,1HM/
C
      QQQ=3
c     write (0,9997) l
c9997 format (' In LDCOMN, l = ', l1)
c     do 9998 i=1,11
c9998 write (0,9999) i, cmsize(i), cmaddr(1,i)
c9999 format (' i = ',i3,', cmsize = ',i10,', cmaddr = ',z8.8)
      IF (L) GO TO 1
      IF (ATTACH(QQQ,1,FNAME,'old').EQ.0) GO TO 5
      WRITE (TTYO,10) FNAME
10    FORMAT (/' I CAN NOT FIND FILE NAME ',8A1,
     1 ' - I WILL START A REGULAR GAME INSTEAD')
C
1     IF (ATTACH(QQQ,0,NEW2,'old').NE.0) GO TO 999
5     CONTINUE
      DO 110 I=1,11
      CALL IO(CMSIZE(I),CMADDR(1,I),0)
110   CONTINUE
c     WRITE(0,4323)
c4323 FORMAT(' CLOSE 3')
      CLOSE (UNIT=3)
      RETURN
C
999   WRITE (TTYO,998)
998   FORMAT (' I AM SORRY, BUT I CAN''T SEEM TO FIND YOUR FILE')
      STOP
      END
      SUBROUTINE SVCOMN(L,FNAME,CMADDR,CMSIZE)
C
      IMPLICIT INTEGER*4(A-Z)
      LOGICAL L
C
      DIMENSION FNAME(8),CMADDR(4,11),CMSIZE(11)
      DIMENSION NEW2(8)
      COMMON /IOSCOM/ TTYI,TTYO,BLKLIN,DBFI
C
      DATA NEW2/1HM,1H.,1HA,1HD,1HV,1HG,1HA,1HM/
C
      QQQ=3
c     write (0,9997) l
c9997 format (' In SVCOMN, l = ', l1)
c     do 9998 i=1,11
c9998 write (0,9999) i, cmsize(i), cmaddr(1,i)
c9999 format (' i = ',i3,', cmsize = ',i10,', cmaddr = ',z8.8)
      IF (L) GO TO 1
C     HERE TO SAVE CURRENT GAME
      CALL GENRAT(1,FNAME)
      IF (ATTACH(QQQ,1,FNAME,'unknown').EQ.0) GO TO 5
      GO TO 900
C
C     HERE TO SAVE NEW GAME (WIZARDS ONLY)
1     CALL GENRAT(0,NEW2)
      IF (ATTACH( QQQ ,0,NEW2,'unknown').NE.0) GO TO 900
      CALL SAVLINES
5     CONTINUE
      DO 110 I=1,11
      CALL IO(CMSIZE(I),CMADDR(1,I),1)
110   CONTINUE
c     WRITE(0,4324)
c4324 FORMAT(' CLOSE 3')
      CLOSE (UNIT=3)
      RETURN
C
900   WRITE(TTYO,903)
903   FORMAT(' I AM SORRY, BUT I CAN''T CREATE OR FIND YOUR FILE')
      RETURN
      END
      INTEGER*4 FUNCTION RAN(RANGE)
C
C  RETURN RANDOM UNIFORMLY DISTRIBUTED VALUE IN CLOSED INTERVAL
C     [0,RANGE-1]
C
      IMPLICIT INTEGER*4(A-Z)
      COMMON /RANCOM/ R
C
      IF (R.NE.0) GO TO 1
      CALL DATIME(D,T)
      R = T
      IF (R .EQ. 0)  R = 1
C
C     16807 = 7**5 - LONG PERIOD FOR 32 BIT INT
1     R = R * 16807
C     TAKE MIDDLE DIGITS
      RAN = AND (Z'0000FFFF', ISHFT(R,-8))
      RAN = MOD (RAN, RANGE)
      RETURN
      END
      INTEGER*4 FUNCTION ATTACH (LFC, QUAL, FNAME, MODE)
C ALLOCATE FNAME TO LFC
      IMPLICIT INTEGER*4 (A-Z)
      DIMENSION FNAME (8)
C FNAME IS IN 1H FORMAT; NEED TO CONVERT
      CHARACTER F8C*8, ZFILE*50, MODE*(*)
C
      DO 1 I = 1,8
         F8C(I:I) = CHAR( ISHFT (FNAME(I), -24) )
c        write (0,*) 'In ATTACH, I = ', i, ', f8c(i:i) = ', f8c(i:i)
 1    CONTINUE
c        WRITE(0,4321)LFC,F8C,QUAL,MODE
c4321    FORMAT(' OPEN FOR LFC = >',I4,'< FILENAME = >',A8,'< QUAL = >'
c    *           ,I1,'< MODE = >',A,'<')
      ZFILE = F8C//' '
      IF (QUAL .EQ. 0) ZFILE = '/usr/local/lib/'//F8C//' '
         OPEN (UNIT=LFC,FILE=ZFILE,ERR=2,
     *   FORM='UNFORMATTED',status=MODE,IOSTAT=ISTAT)
c     write (0,*) 'ATTACH successful for file ', zfile
3     ATTACH = 0
      RETURN
C
 2    ATTACH = 1
      WRITE (0,9990) ISTAT, ZFILE
 9990 FORMAT (/' *** ATTACH OPEN STATUS =',I15/' FILE: ',A50)
      RETURN
      END
      SUBROUTINE GENRAT (QUAL, FNAME)
C CREATE A COMMON SAVE FILE
      IMPLICIT INTEGER*4 (A-Z)
      DIMENSION FNAME(8)
C AGAIN, FNAME IN 1H - CONVERT
      CHARACTER ZFILE*50, F8C*8
C
      DO 1 I=1,8
         F8C(I:I) = CHAR( ISHFT (FNAME(I), -24) )
1     CONTINUE
      ZFILE = F8C//' '
      IF (QUAL .EQ. 0) ZFILE = '/usr/local/lib/'//F8C//' '
c     WRITE(0,123)F8C,QUAL
c123  FORMAT(' In GENRAT: >',A8,'< >',I1,'<')
      OPEN (UNIT=3, ERR=800, FILE=ZFILE,
     1 FORM='UNFORMATTED', STATUS='OLD')
      CLOSE (UNIT=3, ERR=800, STATUS='DELETE')
c800  CRSIZ = 80
800   OPEN (UNIT=3, ERR=910, FILE=ZFILE,
     1  FORM='UNFORMATTED', STATUS='NEW',
     2 IOSTAT=ISTAT)
      CLOSE (UNIT=3, ERR=900)
900   RETURN
C
910   CONTINUE
      WRITE (0,9990) ISTAT, ZFILE
 9990 FORMAT (/' *** UNABLE TO CREATE SAVE FILE, OPEN STATUS =',I15/
     1 ' FILE NAME: ',A50)
      RETURN
      END
      SUBROUTINE IO (QUANT, BASE, RWFLAG)
c
C TRANSFER QUANT WORDS TO/FROM ADDRESS BASE
c Note that this routine uses "illegal" subscripts on array 'foo'
c to actually get at the elements of the array pointed to by 'base'.
c On the Apollo, 'foo' must be in common to get addresses that are
c close enough to the addresses in 'base'.
c
      IMPLICIT INTEGER*4 (A-Z)
      DIMENSION FOO(2)
      common /foocommon/ foo
C
      QQQ=3
c     write (0,9998) QUANT, BASE, RWFLAG
c9998 format (' In IO, QUANT = ',i6,', BASE = ',z8.8,', RWFLAG = ',i4)
      IF (QUANT .LE. 0) RETURN
c     Create an offset from FOO to BASE for addressing.
      subscript = (base-iaddr(foo(1))) / 4
c     write (0,9999) iaddr(foo(1)), subscript, subscript
c9999 format (' iaddr(FOO(1)) = ',z8.8,', subscript = ',i12,
c    1 ' (',z8.8,')')
      IF (RWFLAG .EQ. 0) GO TO 1
      IF (RWFLAG .EQ. 1) GO TO 2
      RETURN
c
c     Read.
c
1     continue
c     write (0,4322) qqq, quant
c4322 FORMAT(' TRY TO READ.  QQQ = >',I4,'<, QUANT = >',I10,'<')
      read (qqq,end=900) (foo(subscript+i),i=1,quant)
      RETURN
900   write (0,901)
901   format (' Read failed in routine IO - if this is the',
     1 ' initialization phase, no problem.'/
     2 ' Returning a buffer of zeroes.')
      do 902 i=1,quant
902   foo(subscript+i) = 0
      return
c
c     Write.
c
2     continue
c     write (0,4321) qqq, quant
c4321 FORMAT(' TRY TO WRITE.  QQQ = >',I4,'<, QUANT = >',I10,'<')
      write (qqq) (foo(subscript+i),i=1,quant)
      RETURN
      END
      SUBROUTINE DATIME(D,T)
C
C  RETURN THE CURRENT DATE AND TIME.
C
C  D IS SET TO THE NUMBER OF DAYS SINCE 07/01/78 (A SATURDAY)
C  T IS SET TO THE NUMBER OF MINUTES PAST MIDNIGHT.
C
C
      IMPLICIT INTEGER*4(A-Z)
      DIMENSION MOTAB(12)
      INTEGER T1(3)
      DATA MOTAB/0,31,59,90,120,151,181,212,243,273,304,334/
C
      call itime (t1)
      T = 60 * T1(1) + T1(2)
c     write (0,*) 'time is ', t1(1), ':', t1(2)
C
      call idate (t1)
      DD = t1(1)
      MM = t1(2)
      YY = t1(3) - 1900
c     write (0,*) 'date is ', t1(1), '/', t1(2), '/', t1(3)
C
      IF (YY .LT. 78) YY = 78
      D = (YY - 78)*365 + (YY - 76)/4
C     JULY 1 ADJUST
      D = D - 182
C     WHY NOT JULY?
      IF (MM .GT. 12 .OR. MM .LT. 1) MM = 7
      D = D + MOTAB(MM)
      IF (MOD(YY,4) .EQ. 0 .AND. MM .LE. 2) D = D - 1
C     WHY NOT AUGUST 47?
      D = D + DD
C     FRI JULY 7, 1978
      IF (D .LT. 0) D = 6
      RETURN
      END
      INTEGER FUNCTION LINES (JNDEX)
c
c     Retrieve an entry from the data base.
c
      IMPLICIT INTEGER*4 (A-Z)
c
      DIMENSION BUF(0:191)
c
      DATA CURRENT/-1/, DIRTY/0/, BUF/192*0/
C
c     write (0,*) 'Call LINES: JNDEX = ', jndex
      WFLAG = 0
      INDEX=JNDEX
C     MAKE SURE CURRENT CORRECT
      GO TO 200
10    LINES = BUF(DISP)
      RETURN
C
      ENTRY SETLINES (JNDEX, VALUE)
c
c     Add an entry to the data base.
c
c     write (0,*) 'Call SETLINES: JNDEX = ', jndex
      WFLAG = 1
      INDEX=JNDEX
      GO TO 200
20    BUF(DISP) = VALUE
      LINES = VALUE
      DIRTY = 1
      RETURN
C
      ENTRY SAVLINES
c
c     Force the last block to be written out.
c
c     write (0,*) 'Call SAVLINES'
      WFLAG = 0
      INDEX = 1
      IF (CURRENT .EQ. 0) INDEX = 1000
C
200   QQQ=2
      IDX = INDEX - 1
      BLK = IDX/192
      DISP = IDX - BLK*192
c     write (0,*) 'In LINES: INDEX = ', index, ', BLK = ', blk,
c    1 ', CURRENT = ', current
      IF (BLK .EQ. CURRENT) GO TO 210
      IF (DIRTY .EQ. 0) GO TO 205
      CURR=CURRENT+1
c     write (0,*) 'In LINES: writing record ', curr
      IF(CURR.GT.0)WRITE(qqq,1000,REC=CURR)BUF
1000  FORMAT(192A4)
      DIRTY = 0
205   CONTINUE
      CURRENT = BLK
      CURR=CURRENT+1
c     write (0,*) 'In LINES: reading record ', curr
      IF(CURR.GT.0)READ(qqq,1000,REC=CURR,err=207)BUF
      go to 210
c
c     Error on read (probably a record past EOF) - return a
c     block of zeroes, which is what is needed for the first
c     initialization of the data base.
c
207   write (0,*) 'LINES/SETLINES/SAVLINES: error on read',
     1 ' of record ', curr, ' (OK if initializing).'
      write (0,*) 'Returning a buffer of zeroes.'
      do 208 i=0,191
208   buf(i) = 0
c
210   IF (WFLAG .EQ. 0) GO TO 10
      GO TO 20
C
      END
C     integer function ishft (iarg, icount)
c
c     Replace Gould ishft function by Apollo versions.
c
c     Shift iarg left by icount bits (icount > 0).
c     Shift iarg right by icount bits (icount < 0).
c
C     implicit integer*4 (a-z)
c
c     write (0,9999) iarg, icount
c9999 format (' In ishft, iarg is ',z8.8,', icount is ',i4)
C     if (icount .gt. 0) then
C        ishft = lshft (iarg, icount)
C     else if (icount .lt. 0) then
C        ishft = rshft (iarg, -icount)
C     else
C        ishft = iarg
C     end if
c     write (0,9998) ishft
c9998 format ('           ishft returned ',z8.8)
C     return
C     end
      integer function and (iarg1, iarg2)
c
c     Replace Apollo 'and' function by HP 'iand'.
c
c
      implicit integer*4 (a-z)
c
c     write (0,9999) iarg1, iarg2
c9999 format (' In and, iarg1 is ',z8.8,', iarg2 is ',z8.8)
      and = iand (iarg1, iarg2)
c     write (0,9998) and
c9998 format ('         and returned ',z8.8)
      return
      end
      integer function or (iarg1, iarg2)
c
c     Replace Apollo 'or' function by HP 'ior'.
c
c
      implicit integer*4 (a-z)
c
c     write (0,9999) iarg1, iarg2
c9999 format (' In or, iarg1 is ',z8.8,', iarg2 is ',z8.8)
      or = ior (iarg1, iarg2)
c     write (0,9998) or
c9998 format ('        or returned ',z8.8)
      return
      end
      integer function iaddr (i)
c
c     Replace Apollo 'iaddr' function by HP 'loc'.
c
c     Return the address of 'i'.
c
c
      iaddr = loc (i)
      return
      end
