static const char *configfile  = "config.cfg";
static const char *outputdir   = "output";
static const char *templatedir = "templates";

enum { BlockHeader = 0, BlockItem, BlockFooter, BlockLast };

struct block {
	char *name; /* filename */
	char *data; /* content (set at runtime) */
};

struct template {
        char *name;
        /* blocks: header, item, footer */
	struct block blocks[BlockLast];
        /* output FILE * (set at runtime) */
        FILE *fp;
};

static struct template templates[] = {
	/* special: will be applied per page */
	{
		.name = "page", .blocks = {
			{ .name = "page/header.html" },
			{ .name = "page/item.html" },
			{ .name = "page/footer.html" }
		}
	},
	{
		.name = "atom.xml", .blocks = {
			{ .name = "atom.xml/header.xml" },
			{ .name = "atom.xml/item.xml" },
			{ .name = "atom.xml/footer.xml" }
		}
	},
	{
		.name = "index.html", .blocks = {
			{ .name = "index.html/header.html" },
			{ .name = "index.html/item.html" },
			{ .name = "index.html/footer.html" }
		}
	},
	{
		.name = "sitemap.xml", .blocks = {
			{ .name = "sitemap.xml/header.xml" },
			{ .name = "sitemap.xml/item.xml" },
			{ .name = "sitemap.xml/footer.xml" }
		}
	},
	{
		.name = "urllist.txt", .blocks = {
			{ .name = "urllist.txt/header.txt" },
			{ .name = "urllist.txt/item.txt" },
			{ .name = "urllist.txt/footer.txt" }
		}
	}
};
