function script_load(uri, fn) {
	var script = document.createElement("script");
	script.type = "text/javascript";
	script.src = uri;
	script.async = true;
	var loaded = 0;
	var onload = function() {
		// fire fn() once.
		if (!loaded) {
			loaded = 1;
			fn();
		}
	};
	// for IE <= 8.
	script.onreadystatechange = function() {
		switch (this.readyState) {
		case "complete":
		case "loaded":
			onload();
		}
	}
	// for the normal world.
	script.onload = function() {
		onload();
	};
	document.getElementsByTagName("head")[0].appendChild(script);
}

// load list of uri's (async, order indetermined), fire fn() when all
// are loaded.
function scripts_load(uris, fn) {
	for (var i = 0, loaded = 0; i < uris.length; i++)
		script_load(uris[i], function() {
			if (++loaded == uris.length)
				fn();
		});
}
