function datepicker_init(input) {
	input.className += " datepicker";

	var datepicker_mons = [
		"January", "February", "March", "April", "May", "June",
		"July", "August", "September", "October", "November", "December"
	];
	var datepicker_days = [ "Su", "Mo", "Tu", "We", "Th", "Fr", "Sa" ];
	var datepicker_isoweekdate = true;

	var parsedateutc = function(s) {
		var l = (s || "").split("-"), d;
		if (l.length < 3)
			return NaN;
		d = new Date(l[0], parseInt(l[1]) - 1, l[2], 0, 0, 0);
		return d.getTime() - (d.getTimezoneOffset() * 60000);
	};

	var table = document.createElement("table");
	table.className = "datepicker";

	var curdate = new Date();
	var mindate = parsedateutc(input.min);
	var maxdate = parsedateutc(input.max);
	var seldate = NaN;

	var td = document.createElement("td");
	td.className = "prev";
	td.innerHTML = "&lt;";
	td.addEventListener("mousedown", function(e) {
		datepicker_nextmon(-1);
		datepicker_render();
		return !!e.stopPropagation();
	}, false);
	var tr = document.createElement("tr");
	tr.className = "yearmons";
	tr.appendChild(td);
	td = document.createElement("td");
	td.colSpan = 5;
	td.className = "name";
	var header = td; // set header.
	tr.appendChild(td);
	td = document.createElement("td");
	td.className = "next";
	td.innerHTML = "&gt;";
	td.addEventListener("mousedown", function(e) {
		datepicker_nextmon(1);
		datepicker_render();
		return !!e.stopPropagation();
	}, false);
	tr.appendChild(td);
	var thead = document.createElement("thead");
	thead.appendChild(tr);
	tr = document.createElement("tr");
	tr.className = "days";
	for (var i = 0; i < 7; i++) {
		td = document.createElement("td");
		td.appendChild(document.createTextNode(
		               datepicker_days[datepicker_isoweekdate ? (i + 1) % 7 : i]));
		tr.appendChild(td);
	}
	thead.appendChild(tr);
	table.appendChild(thead);
	var tbodyel = table.appendChild(document.createElement("tbody"));

	var datepicker_dateparse = function(s) {
		var v = (s || "").split(/-/);
		if (v.length == 3)
			return new Date(v[0], parseInt(v[1]) - 1, parseInt(v[2]) || 1);
		return NaN;
	};
	var datepicker_hide = function() {
		table.hidden = true;
		table.style.display = "none";
	};
	var datepicker_show = function() {
		table.hidden = false;
		table.style.display = "table";
		table.style.position = "absolute";
		var r = input.getClientRects() || [];
		if (r.length) {
			table.style.left = String(r[0].left + window.pageXOffset) + "px";
			table.style.top = String(r[0].top + input.offsetHeight + window.pageYOffset) + "px";
		}
		// scroll if outside window.
		input.scrollIntoView();
	};
	var datepicker_nextmon = function(n) {
		curdate = new Date(curdate.getFullYear(), curdate.getMonth() + n, 1);
	};
	var datepicker_render = function() {
		datepicker_nextmon(0); // fix date.
		var y = curdate.getFullYear(), m = curdate.getMonth();
		header.innerHTML = datepicker_mons[m] + "&nbsp;" + String(y);

		var startidx = curdate.getDay();
		if (datepicker_isoweekdate)
			startidx = (startidx + 6) % 7;

		var tr = document.createElement("tr");
		for (var i = 0; i < startidx; i++)
			tr.appendChild(document.createElement("td"));

		var endday = 0;
		for (var i = 27; (new Date(y, m, i)).getMonth() == m; i++)
			endday = i;

		var pad0 = function(n) {
			return (n < 10 ? "0" : "") + String(n);
		};
		var now = new Date();
		var tbody = document.createElement("tbody");
		var sel = !isNaN(seldate) ? (seldate.getTime() - seldate.getTimezoneOffset() * 60000) : NaN;
		for (var i = 1; i <= endday; i++) {
			if ((datepicker_isoweekdate && !(((i - 1 % 7) + startidx) % 7)) ||
			    (!datepicker_isoweekdate && !((i + startidx - 1) % 7))) {
				if (tr.childNodes.length) {
					tbody.appendChild(tr);
					tr = document.createElement("tr");
				}
			}
			var td = document.createElement("td");
			td.setAttribute("data-value", String(y) + "-" + pad0(m + 1) + "-" + pad0(i));
			td.appendChild(document.createTextNode(String(i)));

			// check if valid date (enabled or disabled).
			var classes = [];
			var d = parsedateutc(td.getAttribute("data-value")) || 0;
			if ((!isNaN(mindate) && d < mindate) ||
			    (!isNaN(maxdate) && d > maxdate)) {
				classes.push("d");
			} else {
				classes.push("v");
				// NOTE: onmousedown is handled before input.blur event.
				td.addEventListener("mousedown", function(e) {
					input.value = this.getAttribute("data-value");
					curdate = seldate = datepicker_dateparse(input.value);
					datepicker_hide();
					return !!e.stopPropagation();
				}, false);
			}
			// selected date?
			if (!isNaN(sel) && sel >= d && sel < d + 86400000)
				classes.push("sel");
			// is date today?
			if (now.getFullYear() == y && now.getMonth() == m && now.getDate() == i)
				classes.push("today");
			td.className = classes.join(" ");
			tr.appendChild(td);
		}
		for (var i = endday; (startidx + i) % 7; i++)
			tr.appendChild(document.createElement("td"));
		tbody.appendChild(tr);

		tbodyel.parentNode.replaceChild(tbody, tbodyel);
		tbodyel = tbody;
	};
	var inparent = function(p, c) {
		for (; c; c = c.parentNode)
			if (c === p)
				return true;
		return false;
	};
	var pad0 = function(n) {
		return (n < 10 ? "0" : "") + String(n);
	};
	var focuschange = function(e) {
		if (e.which !== 27 && e.target == input) {
			if (input.value.length) {
				var d = datepicker_dateparse(input.value);
				if (!isNaN(d))
					curdate = seldate = d;
			} else {
				curdate = new Date();
			}
			datepicker_render();
			datepicker_show();
		} else if (!inparent(table, e.target)) {
			// is in parent? ignore, format date onblur.
			var d = datepicker_dateparse(this.value);
			if (!isNaN(d)) {
				curdate = seldate = d;
				input.value = String(d.getFullYear()) + "-" +
					pad0(d.getMonth() + 1) + "-" + pad0(d.getDate());
			}
			datepicker_hide();
		}
	};
	document.addEventListener("click", focuschange, false);
	input.addEventListener("input", focuschange, false);
	input.addEventListener("focus", focuschange, false);
	document.addEventListener("keyup", focuschange, false);

	datepicker_render();
	datepicker_hide();
	document.body.appendChild(table);
}

// has native HTML5 date input type support? type is "text" if it isn't.
if (!(function() { var input = document.createElement("input"); try { input.type = "date"; return (input.type === "date"); } catch(e) {} return false; })()) {
	var els = document.getElementsByClassName && document.getElementsByClassName("date") || [];
	for (var i = 0; i < els.length; i++)
		if (els[i].tagName.toLowerCase() === "input")
			datepicker_init(els[i]);
}
