var datatable_parse_date = Date.parse,
    datatable_parse_float = parseFloat,
    datatable_parse_int = parseInt,
    datatable_parse_string = String;

function datatable_sort_default(x, y) {
	return x > y ? 1 : (x == y ? 0 : -1);
}

function datatable_init(el) {
	var thead = el.tHead;
	var ths = thead.children[0].children,
	    cols = [];
	for (var i = 0; i < ths.length; i++)
		cols.push({
			filterable: ["1", "true"].indexOf(ths[i].getAttribute("data-filterable")   || "true") != -1,
			parsefn:    window["datatable_parse_" + (ths[i].getAttribute("data-parse") || "string")],
			sortfn:     window["datatable_sort_" + (ths[i].getAttribute("data-sort")   || "default")],
			sortable:   ["1", "true"].indexOf(ths[i].getAttribute("data-sortable")     || "true") != -1
		});
	var d = {
		table: el,
		thead: thead,
		ths:   ths,
		tbody: el.tBodies[0],
		cols:  cols,
		sort:  [], // sort options: [colidx, order (ASC = 0, DESC = 1)].
		lazyscroll: ["1", "true"].indexOf(el.getAttribute("data-lazyscroll") || "") != -1,
		search: "" // previous search text.
	};
	d.data_raw = d.data = datatable_data_parse(d);

	if (d.lazyscroll) {
		var bodytable = document.createElement("table");
		bodytable.className = el.className;
		bodytable.cellSpacing = bodytable.cellPadding = bodytable.border = "0";

		var tr = document.createElement("tr");
		for (var i = 0; i < ths.length; i++) {
			var th = ths[i].cloneNode(true);
			th.innerHTML = "";
			tr.appendChild(th);
		}
		var bodythead = document.createElement("thead");
		bodythead.appendChild(tr);

		tr = document.createElement("tr");
		var newths = [];
		for (var i = 0; i < ths.length; i++)
			newths.push(tr.appendChild(ths[i].cloneNode(true)));
		d.ths = newths; // set new columns (for sorting etc)..
		var elthead = document.createElement("thead");
		elthead.appendChild(tr);

		var headerstable = document.createElement("table");
		headerstable.cellSpacing = headerstable.cellPadding = headerstable.border = "0";
		headerstable.className = el.className;
		headerstable.appendChild(elthead);

		var headersel = document.createElement("div");
		headersel.className = "datatable-lazyscroll-headers";
		headersel.appendChild(headerstable);

		bodytable.appendChild(bodythead);

		var bodyel = document.createElement("div");
		bodyel.className = "datatable-lazyscroll-body";
		bodyel.appendChild(bodytable);

		var containerel = document.createElement("div");
		containerel.className = "datatable-lazyscroll-container";
		containerel.appendChild(headersel);
		containerel.appendChild(bodyel);

		var bodytbody = bodytable.appendChild(document.createElement("tbody"));
		var startfiller = bodytbody.appendChild(document.createElement("tr"));
		var endfiller = bodytbody.appendChild(document.createElement("tr"));

		el.parentNode.insertBefore(containerel, el);

		var rowheight = 25;
		d.display = function(data) {
			var nrows = data.length;

			bodytable.style.height = (nrows * rowheight) + "px";

			var start = parseInt(bodyel.scrollTop / rowheight),
			    end = Math.min(parseInt((bodyel.scrollTop + bodyel.offsetHeight) / rowheight), nrows - 1);

			startfiller.style.height = (start * rowheight) + "px";
			endfiller.style.height = ((nrows - end - 1) * rowheight) + "px";

			// remove nodes but keep first startfiller and endfiller.
			for (var c = bodytbody.childNodes; c.length > 2; )
				bodytbody.removeChild(startfiller.nextSibling);

			for (var i = start, prev = startfiller, p = bodytbody; i <= end; i++)
				prev = p.insertBefore(d.data[i].tr, prev.nextSibling);
		};
		d.scroll = function(y) {
			bodyel.scrollTop = y;
		};

		var curscrollleft, verticalscrolltimer;
		var scroll = function() {
			// handle left / right scroll.
			var scrolleft = bodyel.scrollLeft;
			if (curscrollleft !== scrolleft)
				headersel.scrollLeft = curscrollleft = scrolleft;
			// handle up/down scroll.
			clearTimeout(verticalscrolltimer);
			verticalscrolltimer = setTimeout(function() {
				d.display(d.data);
			}, 16);
		};
		window.addEventListener("resize", scroll);
		bodyel.addEventListener("scroll", scroll);
		d.display(d.data);
	} else {
		d.display = function(data) {
			var tbody = document.createElement("tbody");
			for (var i = 0; i < data.length; i++)
				tbody.appendChild(data[i].tr);
			d.table.replaceChild(tbody, d.tbody);
			tbody.style.display = data.length ? "table-row-group" : "none";
			d.tbody = tbody;
		};
	}
	// setup click event handlers for sorting.
	for (var i = 0; i < d.ths.length; i++)
		d.cols[i].sortable && d.ths[i].addEventListener("click", function(idx) {
			return function(e) {
				// shift-click for multi-select modifier.
				datatable_sort_column_toggle(d, idx, e.shiftKey);
				d.data = datatable_sort(d, d.data);
				d.display(d.data);
			};
		}(i), false);
	return d;
}

function datatable_sort_column_get(d, idx) {
	for (var i = 0; i < d.sort.length; i++)
		if (d.sort[i][0] == idx)
			return i;
	return -1;
}

function datatable_sort_column_set(d, idx, order, multi) {
	var c = datatable_sort_column_get(d, idx);
	if (multi)
		if (c != -1)
			d.sort[c][1] = order;
		else
			d.sort.push([ idx, order ]);
	else
		d.sort = [ [idx, order] ];

	for (var i = 0; i < d.ths.length; i++) {
		var c = " " + d.ths[i].className + " ";
		d.ths[i].className = c.replace(/ sort-(asc|desc) /g, " ").replace(/\s+/g, " ").trim();
	}
	for (var i = 0; i < d.sort.length; i++)
		d.ths[d.sort[i][0]].className += " sort-" + (d.sort[i][1] ? "desc" : "asc");
}

// toggle sort or use default order: ASC.
function datatable_sort_column_toggle(d, idx, multi) {
	var c = datatable_sort_column_get(d, idx);
	datatable_sort_column_set(d, idx, c == -1 || d.sort[c][1] ? 0 : 1, multi);
}

function datatable_data_parse(d) {
	var data = [], trs = d.tbody.children;
	// NOTE: assumes each tr has only "<td>" childnodes.
	for (var i = 0; i < trs.length; i++) {
		var values = [], fv = [];
		for (var j = 0, trc = trs[i].children; j < trc.length; j++) {
			var td = trc[j], v = td.getAttribute("data-value");
			// prefer data-value attribute, else use cell contents,
			// also set preprocess values to filter on cell content
			// and data-value (case-insensitive).
			var s = td.textContent || td.innerText;
			if (typeof(v) != "undefined" && v !== null) {
				fv.push([ s.toLowerCase(), v.toLowerCase() ]);
				values.push(d.cols[j].parsefn(v));
			} else {
				fv.push([ s.toLowerCase() ]);
				values.push(d.cols[j].parsefn(s));
			}
		}
		data.push({
			filtervalues: fv,
			tr:           trs[i],
			values:       values
		});
	}
	return data;
}

function datatable_sort(d, data) {
	// setup sort functions once (in order for multi-select).
	var sortfns = d.sort.map(function(s) {
		return (function(c, o, fn) {
			if (o)
				return function(xvals, yvals) {
					return -fn(xvals[c], yvals[c]);
				};
			else
				return function(xvals, yvals) {
					return fn(xvals[c], yvals[c]);
				};
		})(s[0], s[1], d.cols[s[0]].sortfn);
	});
	return data.sort(function(x, y) {
		for (var i = 0, r; i < sortfns.length; i++)
			if ((r = sortfns[i](x.values, y.values)) != 0)
				return r;
		return r;
	});
}

function datatable_filter(d, data, s) {
	var ret = [], tok = s.toLowerCase().split(" ");
	for (var i = 0; i < data.length; i++) {
		var fc = 0;
		for (var k = 0; k < tok.length && fc < tok.length; k++) {
			var f = false;
			for (var j = 0; j < data[i].filtervalues.length && fc < tok.length && !f; j++)
				for (var l = 0; l < data[i].filtervalues[j].length && !f &&
				                    d.cols[j].filterable; l++)
					if (data[i].filtervalues[j][l].indexOf(tok[k]) != -1)
						f = true;
			if (f)
				fc++;
		}
		// all tokens (separated by space) must match.
		if (fc == tok.length)
			ret.push(data[i]);
	}
	return ret;
}

function datatable_filter_text(d, s) {
	s = s.toLowerCase();
	if (d.search == s)
		return;
	// if token string is different or string not in previous search: use raw data,
	// else filter on existing data and no need to sort.
	if ((d.search.split(" ").length != s.split(" ").length) ||
	    s.indexOf(d.search) == -1) {
		d.data = datatable_sort(d, datatable_filter(d, d.data_raw, s));
	} else {
		d.data = datatable_filter(d, d.data, s);
	}
	d.search = s;
	d.display(d.data);
	if (d.scroll)
		d.scroll(0);
}

function datatable_filter_delayed(d, fn, e) {
	clearTimeout(d.filter_timer);
	d.filter_timer = setTimeout(function() {
		fn(e);
	}, 150); // filter delay in ms.
}

function datatable_autoload() {
	// convert to Array (not changed in-place, mandatory).
	var ds = [], dl = [], els = document.getElementsByClassName && document.getElementsByClassName("datatable") || [];
	for (var i = 0; i < els.length; i++)
		dl.push(els[i]);
	for (var i = 0, d; i < dl.length; i++) {
		if ((d = datatable_init(dl[i])) === null)
			continue;
		var input = dl[i].parentNode.getElementsByClassName("filter-text");
		// delayed filtering.
		for (var j = 0; j < input.length; j++) {
			input[j].addEventListener("input", (function(d, el) {
				return function(e) {
					datatable_filter_delayed(d, function() {
						datatable_filter_text(d, el.value);
					}, e);
				};
			})(d, input[j]), false);
		}
		ds.push(d);
	}
	return ds;
}
